# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDeployEnvironmentsResult',
    'AwaitableGetDeployEnvironmentsResult',
    'get_deploy_environments',
    'get_deploy_environments_output',
]

@pulumi.output_type
class GetDeployEnvironmentsResult:
    """
    A collection of values returned by getDeployEnvironments.
    """
    def __init__(__self__, compartment_id=None, deploy_environment_collections=None, display_name=None, filters=None, id=None, project_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if deploy_environment_collections and not isinstance(deploy_environment_collections, list):
            raise TypeError("Expected argument 'deploy_environment_collections' to be a list")
        pulumi.set(__self__, "deploy_environment_collections", deploy_environment_collections)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of a compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="deployEnvironmentCollections")
    def deploy_environment_collections(self) -> Sequence['outputs.GetDeployEnvironmentsDeployEnvironmentCollectionResult']:
        """
        The list of deploy_environment_collection.
        """
        return pulumi.get(self, "deploy_environment_collections")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Deployment environment display name, which can be renamed and is not necessarily unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDeployEnvironmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier that is immutable on creation.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> Optional[str]:
        """
        The OCID of a project.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the deployment environment.
        """
        return pulumi.get(self, "state")


class AwaitableGetDeployEnvironmentsResult(GetDeployEnvironmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDeployEnvironmentsResult(
            compartment_id=self.compartment_id,
            deploy_environment_collections=self.deploy_environment_collections,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            project_id=self.project_id,
            state=self.state)


def get_deploy_environments(compartment_id: Optional[str] = None,
                            display_name: Optional[str] = None,
                            filters: Optional[Sequence[pulumi.InputType['GetDeployEnvironmentsFilterArgs']]] = None,
                            id: Optional[str] = None,
                            project_id: Optional[str] = None,
                            state: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDeployEnvironmentsResult:
    """
    This data source provides the list of Deploy Environments in Oracle Cloud Infrastructure Devops service.

    Returns a list of deployment environments.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_deploy_environments = oci.DevOps.get_deploy_environments(compartment_id=var["compartment_id"],
        display_name=var["deploy_environment_display_name"],
        id=var["deploy_environment_id"],
        project_id=oci_devops_project["test_project"]["id"],
        state=var["deploy_environment_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: Unique identifier or OCID for listing a single resource by ID.
    :param str project_id: unique project identifier
    :param str state: A filter to return only DeployEnvironments that matches the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['projectId'] = project_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getDeployEnvironments:getDeployEnvironments', __args__, opts=opts, typ=GetDeployEnvironmentsResult).value

    return AwaitableGetDeployEnvironmentsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        deploy_environment_collections=pulumi.get(__ret__, 'deploy_environment_collections'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        project_id=pulumi.get(__ret__, 'project_id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_deploy_environments)
def get_deploy_environments_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetDeployEnvironmentsFilterArgs']]]]] = None,
                                   id: Optional[pulumi.Input[Optional[str]]] = None,
                                   project_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   state: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDeployEnvironmentsResult]:
    """
    This data source provides the list of Deploy Environments in Oracle Cloud Infrastructure Devops service.

    Returns a list of deployment environments.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_deploy_environments = oci.DevOps.get_deploy_environments(compartment_id=var["compartment_id"],
        display_name=var["deploy_environment_display_name"],
        id=var["deploy_environment_id"],
        project_id=oci_devops_project["test_project"]["id"],
        state=var["deploy_environment_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment in which to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given.
    :param str id: Unique identifier or OCID for listing a single resource by ID.
    :param str project_id: unique project identifier
    :param str state: A filter to return only DeployEnvironments that matches the given lifecycleState.
    """
    ...
