# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetRepositoryObjectResult',
    'AwaitableGetRepositoryObjectResult',
    'get_repository_object',
    'get_repository_object_output',
]

@pulumi.output_type
class GetRepositoryObjectResult:
    """
    A collection of values returned by getRepositoryObject.
    """
    def __init__(__self__, file_path=None, id=None, is_binary=None, ref_name=None, repository_id=None, sha=None, size_in_bytes=None, type=None):
        if file_path and not isinstance(file_path, str):
            raise TypeError("Expected argument 'file_path' to be a str")
        pulumi.set(__self__, "file_path", file_path)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_binary and not isinstance(is_binary, bool):
            raise TypeError("Expected argument 'is_binary' to be a bool")
        pulumi.set(__self__, "is_binary", is_binary)
        if ref_name and not isinstance(ref_name, str):
            raise TypeError("Expected argument 'ref_name' to be a str")
        pulumi.set(__self__, "ref_name", ref_name)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)
        if sha and not isinstance(sha, str):
            raise TypeError("Expected argument 'sha' to be a str")
        pulumi.set(__self__, "sha", sha)
        if size_in_bytes and not isinstance(size_in_bytes, str):
            raise TypeError("Expected argument 'size_in_bytes' to be a str")
        pulumi.set(__self__, "size_in_bytes", size_in_bytes)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[str]:
        return pulumi.get(self, "file_path")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isBinary")
    def is_binary(self) -> bool:
        """
        Flag to determine if the object contains binary file content or not.
        """
        return pulumi.get(self, "is_binary")

    @property
    @pulumi.getter(name="refName")
    def ref_name(self) -> Optional[str]:
        return pulumi.get(self, "ref_name")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter
    def sha(self) -> str:
        """
        SHA-1 hash of git object.
        """
        return pulumi.get(self, "sha")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> str:
        """
        Size in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of git object.
        """
        return pulumi.get(self, "type")


class AwaitableGetRepositoryObjectResult(GetRepositoryObjectResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryObjectResult(
            file_path=self.file_path,
            id=self.id,
            is_binary=self.is_binary,
            ref_name=self.ref_name,
            repository_id=self.repository_id,
            sha=self.sha,
            size_in_bytes=self.size_in_bytes,
            type=self.type)


def get_repository_object(file_path: Optional[str] = None,
                          ref_name: Optional[str] = None,
                          repository_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryObjectResult:
    """
    This data source provides details about a specific Repository Object resource in Oracle Cloud Infrastructure Devops service.

    Retrieves blob of specific branch name/commit ID and file path.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_object = oci.DevOps.get_repository_object(repository_id=oci_devops_repository["test_repository"]["id"],
        file_path=var["repository_object_file_path"],
        ref_name=var["repository_object_ref_name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str file_path: A filter to return only commits that affect any of the specified paths.
    :param str ref_name: A filter to return only resources that match the given reference name.
    :param str repository_id: Unique repository identifier.
    """
    __args__ = dict()
    __args__['filePath'] = file_path
    __args__['refName'] = ref_name
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryObject:getRepositoryObject', __args__, opts=opts, typ=GetRepositoryObjectResult).value

    return AwaitableGetRepositoryObjectResult(
        file_path=pulumi.get(__ret__, 'file_path'),
        id=pulumi.get(__ret__, 'id'),
        is_binary=pulumi.get(__ret__, 'is_binary'),
        ref_name=pulumi.get(__ret__, 'ref_name'),
        repository_id=pulumi.get(__ret__, 'repository_id'),
        sha=pulumi.get(__ret__, 'sha'),
        size_in_bytes=pulumi.get(__ret__, 'size_in_bytes'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_repository_object)
def get_repository_object_output(file_path: Optional[pulumi.Input[Optional[str]]] = None,
                                 ref_name: Optional[pulumi.Input[Optional[str]]] = None,
                                 repository_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRepositoryObjectResult]:
    """
    This data source provides details about a specific Repository Object resource in Oracle Cloud Infrastructure Devops service.

    Retrieves blob of specific branch name/commit ID and file path.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_object = oci.DevOps.get_repository_object(repository_id=oci_devops_repository["test_repository"]["id"],
        file_path=var["repository_object_file_path"],
        ref_name=var["repository_object_ref_name"])
    ```
    <!--End PulumiCodeChooser -->


    :param str file_path: A filter to return only commits that affect any of the specified paths.
    :param str ref_name: A filter to return only resources that match the given reference name.
    :param str repository_id: Unique repository identifier.
    """
    ...
