# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DeploymentCertificateArgs', 'DeploymentCertificate']

@pulumi.input_type
class DeploymentCertificateArgs:
    def __init__(__self__, *,
                 certificate_content: pulumi.Input[str],
                 deployment_id: pulumi.Input[str],
                 key: pulumi.Input[str]):
        """
        The set of arguments for constructing a DeploymentCertificate resource.
        :param pulumi.Input[str] certificate_content: A PEM-encoded SSL certificate.
        :param pulumi.Input[str] deployment_id: A unique Deployment identifier.
        :param pulumi.Input[str] key: The identifier key (unique name in the scope of the deployment) of the certificate being referenced.  It must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "certificate_content", certificate_content)
        pulumi.set(__self__, "deployment_id", deployment_id)
        pulumi.set(__self__, "key", key)

    @property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> pulumi.Input[str]:
        """
        A PEM-encoded SSL certificate.
        """
        return pulumi.get(self, "certificate_content")

    @certificate_content.setter
    def certificate_content(self, value: pulumi.Input[str]):
        pulumi.set(self, "certificate_content", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Input[str]:
        """
        A unique Deployment identifier.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The identifier key (unique name in the scope of the deployment) of the certificate being referenced.  It must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)


@pulumi.input_type
class _DeploymentCertificateState:
    def __init__(__self__, *,
                 authority_key_id: Optional[pulumi.Input[str]] = None,
                 certificate_content: Optional[pulumi.Input[str]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 is_ca: Optional[pulumi.Input[bool]] = None,
                 is_self_signed: Optional[pulumi.Input[bool]] = None,
                 issuer: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 md5hash: Optional[pulumi.Input[str]] = None,
                 public_key: Optional[pulumi.Input[str]] = None,
                 public_key_algorithm: Optional[pulumi.Input[str]] = None,
                 public_key_size: Optional[pulumi.Input[str]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 sha1hash: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subject: Optional[pulumi.Input[str]] = None,
                 subject_key_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_valid_from: Optional[pulumi.Input[str]] = None,
                 time_valid_to: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DeploymentCertificate resources.
        :param pulumi.Input[str] authority_key_id: The Certificate authority key id.
        :param pulumi.Input[str] certificate_content: A PEM-encoded SSL certificate.
        :param pulumi.Input[str] deployment_id: A unique Deployment identifier.
        :param pulumi.Input[bool] is_ca: Indicates if the certificate is ca.
        :param pulumi.Input[bool] is_self_signed: Indicates if the certificate is self signed.
        :param pulumi.Input[str] issuer: The Certificate issuer.
        :param pulumi.Input[str] key: The identifier key (unique name in the scope of the deployment) of the certificate being referenced.  It must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] md5hash: The Certificate md5Hash.
        :param pulumi.Input[str] public_key: The Certificate public key.
        :param pulumi.Input[str] public_key_algorithm: The Certificate public key algorithm.
        :param pulumi.Input[str] public_key_size: The Certificate public key size.
        :param pulumi.Input[str] serial: The Certificate serial.
        :param pulumi.Input[str] sha1hash: The Certificate sha1 hash.
        :param pulumi.Input[str] state: Possible certificate lifecycle states.
        :param pulumi.Input[str] subject: The Certificate subject.
        :param pulumi.Input[str] subject_key_id: The Certificate subject key id.
        :param pulumi.Input[str] time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_valid_from: The time the certificate is valid from. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_valid_to: The time the certificate is valid to. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] version: The Certificate version.
        """
        if authority_key_id is not None:
            pulumi.set(__self__, "authority_key_id", authority_key_id)
        if certificate_content is not None:
            pulumi.set(__self__, "certificate_content", certificate_content)
        if deployment_id is not None:
            pulumi.set(__self__, "deployment_id", deployment_id)
        if is_ca is not None:
            pulumi.set(__self__, "is_ca", is_ca)
        if is_self_signed is not None:
            pulumi.set(__self__, "is_self_signed", is_self_signed)
        if issuer is not None:
            pulumi.set(__self__, "issuer", issuer)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if md5hash is not None:
            pulumi.set(__self__, "md5hash", md5hash)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if public_key_algorithm is not None:
            pulumi.set(__self__, "public_key_algorithm", public_key_algorithm)
        if public_key_size is not None:
            pulumi.set(__self__, "public_key_size", public_key_size)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if sha1hash is not None:
            pulumi.set(__self__, "sha1hash", sha1hash)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if subject_key_id is not None:
            pulumi.set(__self__, "subject_key_id", subject_key_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_valid_from is not None:
            pulumi.set(__self__, "time_valid_from", time_valid_from)
        if time_valid_to is not None:
            pulumi.set(__self__, "time_valid_to", time_valid_to)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="authorityKeyId")
    def authority_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Certificate authority key id.
        """
        return pulumi.get(self, "authority_key_id")

    @authority_key_id.setter
    def authority_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authority_key_id", value)

    @property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> Optional[pulumi.Input[str]]:
        """
        A PEM-encoded SSL certificate.
        """
        return pulumi.get(self, "certificate_content")

    @certificate_content.setter
    def certificate_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate_content", value)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[pulumi.Input[str]]:
        """
        A unique Deployment identifier.
        """
        return pulumi.get(self, "deployment_id")

    @deployment_id.setter
    def deployment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_id", value)

    @property
    @pulumi.getter(name="isCa")
    def is_ca(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the certificate is ca.
        """
        return pulumi.get(self, "is_ca")

    @is_ca.setter
    def is_ca(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_ca", value)

    @property
    @pulumi.getter(name="isSelfSigned")
    def is_self_signed(self) -> Optional[pulumi.Input[bool]]:
        """
        Indicates if the certificate is self signed.
        """
        return pulumi.get(self, "is_self_signed")

    @is_self_signed.setter
    def is_self_signed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_self_signed", value)

    @property
    @pulumi.getter
    def issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The Certificate issuer.
        """
        return pulumi.get(self, "issuer")

    @issuer.setter
    def issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuer", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier key (unique name in the scope of the deployment) of the certificate being referenced.  It must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def md5hash(self) -> Optional[pulumi.Input[str]]:
        """
        The Certificate md5Hash.
        """
        return pulumi.get(self, "md5hash")

    @md5hash.setter
    def md5hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "md5hash", value)

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[str]]:
        """
        The Certificate public key.
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key", value)

    @property
    @pulumi.getter(name="publicKeyAlgorithm")
    def public_key_algorithm(self) -> Optional[pulumi.Input[str]]:
        """
        The Certificate public key algorithm.
        """
        return pulumi.get(self, "public_key_algorithm")

    @public_key_algorithm.setter
    def public_key_algorithm(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_algorithm", value)

    @property
    @pulumi.getter(name="publicKeySize")
    def public_key_size(self) -> Optional[pulumi.Input[str]]:
        """
        The Certificate public key size.
        """
        return pulumi.get(self, "public_key_size")

    @public_key_size.setter
    def public_key_size(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_size", value)

    @property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[str]]:
        """
        The Certificate serial.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter
    def sha1hash(self) -> Optional[pulumi.Input[str]]:
        """
        The Certificate sha1 hash.
        """
        return pulumi.get(self, "sha1hash")

    @sha1hash.setter
    def sha1hash(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sha1hash", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        Possible certificate lifecycle states.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[str]]:
        """
        The Certificate subject.
        """
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter(name="subjectKeyId")
    def subject_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The Certificate subject key id.
        """
        return pulumi.get(self, "subject_key_id")

    @subject_key_id.setter
    def subject_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subject_key_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeValidFrom")
    def time_valid_from(self) -> Optional[pulumi.Input[str]]:
        """
        The time the certificate is valid from. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_valid_from")

    @time_valid_from.setter
    def time_valid_from(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_valid_from", value)

    @property
    @pulumi.getter(name="timeValidTo")
    def time_valid_to(self) -> Optional[pulumi.Input[str]]:
        """
        The time the certificate is valid to. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_valid_to")

    @time_valid_to.setter
    def time_valid_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_valid_to", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The Certificate version.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class DeploymentCertificate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_content: Optional[pulumi.Input[str]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Deployment Certificate resource in Oracle Cloud Infrastructure Golden Gate service.

        Creates a new certificate to truststore.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_deployment_certificate = oci.golden_gate.DeploymentCertificate("testDeploymentCertificate",
            certificate_content=var["deployment_certificate_certificate_content"],
            deployment_id=oci_golden_gate_deployment["test_deployment"]["id"],
            key=var["deployment_certificate_key"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        DeploymentCertificates can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GoldenGate/deploymentCertificate:DeploymentCertificate test_deployment_certificate "deployments/{deploymentId}/certificates/{certificateKey}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] certificate_content: A PEM-encoded SSL certificate.
        :param pulumi.Input[str] deployment_id: A unique Deployment identifier.
        :param pulumi.Input[str] key: The identifier key (unique name in the scope of the deployment) of the certificate being referenced.  It must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentCertificateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Deployment Certificate resource in Oracle Cloud Infrastructure Golden Gate service.

        Creates a new certificate to truststore.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_deployment_certificate = oci.golden_gate.DeploymentCertificate("testDeploymentCertificate",
            certificate_content=var["deployment_certificate_certificate_content"],
            deployment_id=oci_golden_gate_deployment["test_deployment"]["id"],
            key=var["deployment_certificate_key"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        DeploymentCertificates can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GoldenGate/deploymentCertificate:DeploymentCertificate test_deployment_certificate "deployments/{deploymentId}/certificates/{certificateKey}"
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentCertificateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentCertificateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_content: Optional[pulumi.Input[str]] = None,
                 deployment_id: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentCertificateArgs.__new__(DeploymentCertificateArgs)

            if certificate_content is None and not opts.urn:
                raise TypeError("Missing required property 'certificate_content'")
            __props__.__dict__["certificate_content"] = certificate_content
            if deployment_id is None and not opts.urn:
                raise TypeError("Missing required property 'deployment_id'")
            __props__.__dict__["deployment_id"] = deployment_id
            if key is None and not opts.urn:
                raise TypeError("Missing required property 'key'")
            __props__.__dict__["key"] = key
            __props__.__dict__["authority_key_id"] = None
            __props__.__dict__["is_ca"] = None
            __props__.__dict__["is_self_signed"] = None
            __props__.__dict__["issuer"] = None
            __props__.__dict__["md5hash"] = None
            __props__.__dict__["public_key"] = None
            __props__.__dict__["public_key_algorithm"] = None
            __props__.__dict__["public_key_size"] = None
            __props__.__dict__["serial"] = None
            __props__.__dict__["sha1hash"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["subject"] = None
            __props__.__dict__["subject_key_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_valid_from"] = None
            __props__.__dict__["time_valid_to"] = None
            __props__.__dict__["version"] = None
        super(DeploymentCertificate, __self__).__init__(
            'oci:GoldenGate/deploymentCertificate:DeploymentCertificate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authority_key_id: Optional[pulumi.Input[str]] = None,
            certificate_content: Optional[pulumi.Input[str]] = None,
            deployment_id: Optional[pulumi.Input[str]] = None,
            is_ca: Optional[pulumi.Input[bool]] = None,
            is_self_signed: Optional[pulumi.Input[bool]] = None,
            issuer: Optional[pulumi.Input[str]] = None,
            key: Optional[pulumi.Input[str]] = None,
            md5hash: Optional[pulumi.Input[str]] = None,
            public_key: Optional[pulumi.Input[str]] = None,
            public_key_algorithm: Optional[pulumi.Input[str]] = None,
            public_key_size: Optional[pulumi.Input[str]] = None,
            serial: Optional[pulumi.Input[str]] = None,
            sha1hash: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subject: Optional[pulumi.Input[str]] = None,
            subject_key_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_valid_from: Optional[pulumi.Input[str]] = None,
            time_valid_to: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'DeploymentCertificate':
        """
        Get an existing DeploymentCertificate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] authority_key_id: The Certificate authority key id.
        :param pulumi.Input[str] certificate_content: A PEM-encoded SSL certificate.
        :param pulumi.Input[str] deployment_id: A unique Deployment identifier.
        :param pulumi.Input[bool] is_ca: Indicates if the certificate is ca.
        :param pulumi.Input[bool] is_self_signed: Indicates if the certificate is self signed.
        :param pulumi.Input[str] issuer: The Certificate issuer.
        :param pulumi.Input[str] key: The identifier key (unique name in the scope of the deployment) of the certificate being referenced.  It must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] md5hash: The Certificate md5Hash.
        :param pulumi.Input[str] public_key: The Certificate public key.
        :param pulumi.Input[str] public_key_algorithm: The Certificate public key algorithm.
        :param pulumi.Input[str] public_key_size: The Certificate public key size.
        :param pulumi.Input[str] serial: The Certificate serial.
        :param pulumi.Input[str] sha1hash: The Certificate sha1 hash.
        :param pulumi.Input[str] state: Possible certificate lifecycle states.
        :param pulumi.Input[str] subject: The Certificate subject.
        :param pulumi.Input[str] subject_key_id: The Certificate subject key id.
        :param pulumi.Input[str] time_created: The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_valid_from: The time the certificate is valid from. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] time_valid_to: The time the certificate is valid to. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        :param pulumi.Input[str] version: The Certificate version.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentCertificateState.__new__(_DeploymentCertificateState)

        __props__.__dict__["authority_key_id"] = authority_key_id
        __props__.__dict__["certificate_content"] = certificate_content
        __props__.__dict__["deployment_id"] = deployment_id
        __props__.__dict__["is_ca"] = is_ca
        __props__.__dict__["is_self_signed"] = is_self_signed
        __props__.__dict__["issuer"] = issuer
        __props__.__dict__["key"] = key
        __props__.__dict__["md5hash"] = md5hash
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["public_key_algorithm"] = public_key_algorithm
        __props__.__dict__["public_key_size"] = public_key_size
        __props__.__dict__["serial"] = serial
        __props__.__dict__["sha1hash"] = sha1hash
        __props__.__dict__["state"] = state
        __props__.__dict__["subject"] = subject
        __props__.__dict__["subject_key_id"] = subject_key_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_valid_from"] = time_valid_from
        __props__.__dict__["time_valid_to"] = time_valid_to
        __props__.__dict__["version"] = version
        return DeploymentCertificate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="authorityKeyId")
    def authority_key_id(self) -> pulumi.Output[str]:
        """
        The Certificate authority key id.
        """
        return pulumi.get(self, "authority_key_id")

    @property
    @pulumi.getter(name="certificateContent")
    def certificate_content(self) -> pulumi.Output[str]:
        """
        A PEM-encoded SSL certificate.
        """
        return pulumi.get(self, "certificate_content")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> pulumi.Output[str]:
        """
        A unique Deployment identifier.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="isCa")
    def is_ca(self) -> pulumi.Output[bool]:
        """
        Indicates if the certificate is ca.
        """
        return pulumi.get(self, "is_ca")

    @property
    @pulumi.getter(name="isSelfSigned")
    def is_self_signed(self) -> pulumi.Output[bool]:
        """
        Indicates if the certificate is self signed.
        """
        return pulumi.get(self, "is_self_signed")

    @property
    @pulumi.getter
    def issuer(self) -> pulumi.Output[str]:
        """
        The Certificate issuer.
        """
        return pulumi.get(self, "issuer")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[str]:
        """
        The identifier key (unique name in the scope of the deployment) of the certificate being referenced.  It must be 1 to 32 characters long, must contain only alphanumeric characters and must start with a letter. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def md5hash(self) -> pulumi.Output[str]:
        """
        The Certificate md5Hash.
        """
        return pulumi.get(self, "md5hash")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[str]:
        """
        The Certificate public key.
        """
        return pulumi.get(self, "public_key")

    @property
    @pulumi.getter(name="publicKeyAlgorithm")
    def public_key_algorithm(self) -> pulumi.Output[str]:
        """
        The Certificate public key algorithm.
        """
        return pulumi.get(self, "public_key_algorithm")

    @property
    @pulumi.getter(name="publicKeySize")
    def public_key_size(self) -> pulumi.Output[str]:
        """
        The Certificate public key size.
        """
        return pulumi.get(self, "public_key_size")

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Output[str]:
        """
        The Certificate serial.
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter
    def sha1hash(self) -> pulumi.Output[str]:
        """
        The Certificate sha1 hash.
        """
        return pulumi.get(self, "sha1hash")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        Possible certificate lifecycle states.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def subject(self) -> pulumi.Output[str]:
        """
        The Certificate subject.
        """
        return pulumi.get(self, "subject")

    @property
    @pulumi.getter(name="subjectKeyId")
    def subject_key_id(self) -> pulumi.Output[str]:
        """
        The Certificate subject key id.
        """
        return pulumi.get(self, "subject_key_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the resource was created. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeValidFrom")
    def time_valid_from(self) -> pulumi.Output[str]:
        """
        The time the certificate is valid from. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_valid_from")

    @property
    @pulumi.getter(name="timeValidTo")
    def time_valid_to(self) -> pulumi.Output[str]:
        """
        The time the certificate is valid to. The format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339), such as `2016-08-25T21:10:29.600Z`.
        """
        return pulumi.get(self, "time_valid_to")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The Certificate version.
        """
        return pulumi.get(self, "version")

