# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetConnectionAssignmentsResult',
    'AwaitableGetConnectionAssignmentsResult',
    'get_connection_assignments',
    'get_connection_assignments_output',
]

@pulumi.output_type
class GetConnectionAssignmentsResult:
    """
    A collection of values returned by getConnectionAssignments.
    """
    def __init__(__self__, compartment_id=None, connection_assignment_collections=None, connection_id=None, deployment_id=None, filters=None, id=None, name=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_assignment_collections and not isinstance(connection_assignment_collections, list):
            raise TypeError("Expected argument 'connection_assignment_collections' to be a list")
        pulumi.set(__self__, "connection_assignment_collections", connection_assignment_collections)
        if connection_id and not isinstance(connection_id, str):
            raise TypeError("Expected argument 'connection_id' to be a str")
        pulumi.set(__self__, "connection_id", connection_id)
        if deployment_id and not isinstance(deployment_id, str):
            raise TypeError("Expected argument 'deployment_id' to be a str")
        pulumi.set(__self__, "deployment_id", deployment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment being referenced.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionAssignmentCollections")
    def connection_assignment_collections(self) -> Sequence['outputs.GetConnectionAssignmentsConnectionAssignmentCollectionResult']:
        """
        The list of connection_assignment_collection.
        """
        return pulumi.get(self, "connection_assignment_collections")

    @property
    @pulumi.getter(name="connectionId")
    def connection_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connection being referenced.
        """
        return pulumi.get(self, "connection_id")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> Optional[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment being referenced.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetConnectionAssignmentsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        Possible lifecycle states for connection assignments.
        """
        return pulumi.get(self, "state")


class AwaitableGetConnectionAssignmentsResult(GetConnectionAssignmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectionAssignmentsResult(
            compartment_id=self.compartment_id,
            connection_assignment_collections=self.connection_assignment_collections,
            connection_id=self.connection_id,
            deployment_id=self.deployment_id,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state)


def get_connection_assignments(compartment_id: Optional[str] = None,
                               connection_id: Optional[str] = None,
                               deployment_id: Optional[str] = None,
                               filters: Optional[Sequence[pulumi.InputType['GetConnectionAssignmentsFilterArgs']]] = None,
                               name: Optional[str] = None,
                               state: Optional[str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectionAssignmentsResult:
    """
    This data source provides the list of Connection Assignments in Oracle Cloud Infrastructure Golden Gate service.

    Lists the Connection Assignments in the compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_connection_assignments = oci.GoldenGate.get_connection_assignments(compartment_id=var["compartment_id"],
        connection_id=oci_golden_gate_connection["test_connection"]["id"],
        deployment_id=oci_golden_gate_deployment["test_deployment"]["id"],
        name=var["connection_assignment_name"],
        state=var["connection_assignment_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
    :param str connection_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connection.
    :param str deployment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment in which to list resources.
    :param str name: The name of the connection in the assignment (aliasName).
    :param str state: A filter to return only connection assignments having the 'lifecycleState' given.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['connectionId'] = connection_id
    __args__['deploymentId'] = deployment_id
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:GoldenGate/getConnectionAssignments:getConnectionAssignments', __args__, opts=opts, typ=GetConnectionAssignmentsResult).value

    return AwaitableGetConnectionAssignmentsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        connection_assignment_collections=pulumi.get(__ret__, 'connection_assignment_collections'),
        connection_id=pulumi.get(__ret__, 'connection_id'),
        deployment_id=pulumi.get(__ret__, 'deployment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_connection_assignments)
def get_connection_assignments_output(compartment_id: Optional[pulumi.Input[str]] = None,
                                      connection_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      deployment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                      filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetConnectionAssignmentsFilterArgs']]]]] = None,
                                      name: Optional[pulumi.Input[Optional[str]]] = None,
                                      state: Optional[pulumi.Input[Optional[str]]] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectionAssignmentsResult]:
    """
    This data source provides the list of Connection Assignments in Oracle Cloud Infrastructure Golden Gate service.

    Lists the Connection Assignments in the compartment.

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_connection_assignments = oci.GoldenGate.get_connection_assignments(compartment_id=var["compartment_id"],
        connection_id=oci_golden_gate_connection["test_connection"]["id"],
        deployment_id=oci_golden_gate_deployment["test_deployment"]["id"],
        name=var["connection_assignment_name"],
        state=var["connection_assignment_state"])
    ```
    <!--End PulumiCodeChooser -->


    :param str compartment_id: The OCID of the compartment that contains the work request. Work requests should be scoped  to the same compartment as the resource the work request affects. If the work request concerns  multiple resources, and those resources are not in the same compartment, it is up to the service team  to pick the primary resource whose compartment should be used.
    :param str connection_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the connection.
    :param str deployment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the deployment in which to list resources.
    :param str name: The name of the connection in the assignment (aliasName).
    :param str state: A filter to return only connection assignments having the 'lifecycleState' given.
    """
    ...
