# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DomainsUserArgs', 'DomainsUser']

@pulumi.input_type
class DomainsUserArgs:
    def __init__(__self__, *,
                 idcs_endpoint: pulumi.Input[str],
                 schemas: pulumi.Input[Sequence[pulumi.Input[str]]],
                 user_name: pulumi.Input[str],
                 active: Optional[pulumi.Input[bool]] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserAddressArgs']]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserEmailArgs']]]] = None,
                 entitlements: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserEntitlementArgs']]]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 ims: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserImArgs']]]] = None,
                 locale: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input['DomainsUserNameArgs']] = None,
                 nick_name: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 phone_numbers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserPhoneNumberArgs']]]] = None,
                 photos: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserPhotoArgs']]]] = None,
                 preferred_language: Optional[pulumi.Input[str]] = None,
                 profile_url: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserRoleArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserTagArgs']]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasextensionenterprise20user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasextensionenterprise20userArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionadaptive_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensioncapabilities_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensiondb_credentials_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionkerberos_user_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionmfa_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionpasswordless_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionposix_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionself_change_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionself_registration_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionsff_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionsocial_account_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionterms_of_use_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionuser_state_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionuser_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUserArgs']] = None,
                 user_type: Optional[pulumi.Input[str]] = None,
                 x509certificates: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserX509certificateArgs']]]] = None):
        """
        The set of arguments for constructing a DomainsUser resource.
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] user_name: (Updatable) User name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: User ID
               * idcsCsvAttributeNameMappings: [[columnHeaderName:User Name, deprecatedColumnHeaderName:User ID]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[bool] active: (Updatable) Status of the account
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserAddressArgs']]] addresses: (Updatable) A physical mailing address for this User, as described in (address Element). Canonical Type Values of work, home, and other. The value attribute is a complex type with the following sub-attributes.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [type]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Address Street, deprecatedColumnHeaderName:Work Street Address, mapsTo:addresses[work].streetAddress], [columnHeaderName:Work Address Locality, deprecatedColumnHeaderName:Work City, mapsTo:addresses[work].locality], [columnHeaderName:Work Address Region, deprecatedColumnHeaderName:Work State, mapsTo:addresses[work].region], [columnHeaderName:Work Address Postal Code, deprecatedColumnHeaderName:Work Postal Code, mapsTo:addresses[work].postalCode], [columnHeaderName:Work Address Country, deprecatedColumnHeaderName:Work Country, mapsTo:addresses[work].country], [columnHeaderName:Work Address Formatted, mapsTo:addresses[work].formatted], [columnHeaderName:Home Address Formatted, mapsTo:addresses[home].formatted], [columnHeaderName:Other Address Formatted, mapsTo:addresses[other].formatted], [columnHeaderName:Home Address Street, mapsTo:addresses[home].streetAddress], [columnHeaderName:Other Address Street, mapsTo:addresses[other].streetAddress], [columnHeaderName:Home Address Locality, mapsTo:addresses[home].locality], [columnHeaderName:Other Address Locality, mapsTo:addresses[other].locality], [columnHeaderName:Home Address Region, mapsTo:addresses[home].region], [columnHeaderName:Other Address Region, mapsTo:addresses[other].region], [columnHeaderName:Home Address Country, mapsTo:addresses[home].country], [columnHeaderName:Other Address Country, mapsTo:addresses[other].country], [columnHeaderName:Home Address Postal Code, mapsTo:addresses[home].postalCode], [columnHeaderName:Other Address Postal Code, mapsTo:addresses[other].postalCode], [columnHeaderName:Primary Address Type, mapsTo:addresses[$(type)].primary]]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] description: (Updatable) Description of the user
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsPii: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] display_name: (Updatable) The displayName of the User's manager. OPTIONAL and READ-ONLY.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserEmailArgs']]] emails: (Updatable) A complex attribute representing emails
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Email, mapsTo:emails[work].value], [columnHeaderName:Home Email, mapsTo:emails[home].value], [columnHeaderName:Primary Email Type, mapsTo:emails[$(type)].primary], [columnHeaderName:Other Email, mapsTo:emails[other].value], [columnHeaderName:Recovery Email, mapsTo:emails[recovery].value], [columnHeaderName:Work Email Verified, mapsTo:emails[work].verified], [columnHeaderName:Home Email Verified, mapsTo:emails[home].verified], [columnHeaderName:Other Email Verified, mapsTo:emails[other].verified], [columnHeaderName:Recovery Email Verified, mapsTo:emails[recovery].verified]]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserEntitlementArgs']]] entitlements: (Updatable) A list of entitlements for the User that represent a thing the User has.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. READ-ONLY.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserImArgs']]] ims: (Updatable) User's instant messaging addresses
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] locale: (Updatable) Used to indicate the User's default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Locale
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Locale]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsUserNameArgs'] name: (Updatable) Name of the account assigned to the User.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] nick_name: (Updatable) Nick name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Nick Name
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Nick Name]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) The OCID of the user's support account.
               
               **Added In:** 2103141444
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: always
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] password: (Updatable) Password attribute. Max length for password is controlled via Password Policy.
               
               **SCIM++ Properties:**
               * idcsCsvAttributeName: Password
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Password]]
               * idcsPii: true
               * idcsSearchable: false
               * idcsSensitive: hash
               * multiValued: false
               * mutability: writeOnly
               * required: false
               * returned: never
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserPhoneNumberArgs']]] phone_numbers: (Updatable) Phone numbers
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Phone, mapsTo:phoneNumbers[work].value], [columnHeaderName:Mobile No, mapsTo:phoneNumbers[mobile].value], [columnHeaderName:Home Phone, mapsTo:phoneNumbers[home].value], [columnHeaderName:Fax, mapsTo:phoneNumbers[fax].value], [columnHeaderName:Pager, mapsTo:phoneNumbers[pager].value], [columnHeaderName:Other Phone, mapsTo:phoneNumbers[other].value], [columnHeaderName:Recovery Phone, mapsTo:phoneNumbers[recovery].value], [columnHeaderName:Primary Phone Type, mapsTo:phoneNumbers[$(type)].primary]]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserPhotoArgs']]] photos: (Updatable) URLs of photos for the User
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] preferred_language: (Updatable) User's preferred written or spoken language used for localized user interfaces
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Preferred Language
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Preferred Language]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] profile_url: (Updatable) A fully-qualified URL to a page representing the User's online profile
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Profile URL
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Profile Url]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserRoleArgs']]] roles: (Updatable) A list of roles for the User that collectively represent who the User is; e.g., 'Student', 'Faculty'.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] timezone: (Updatable) User's timezone
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * idcsCsvAttributeName: TimeZone
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Time Zone, deprecatedColumnHeaderName:TimeZone]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] title: (Updatable) Title
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Title
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Title]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasextensionenterprise20userArgs'] urnietfparamsscimschemasextensionenterprise20user: (Updatable) Enterprise User
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs'] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUserArgs'] urnietfparamsscimschemasoracleidcsextensionadaptive_user: (Updatable) This extension defines attributes to manage user's risk score.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUserArgs'] urnietfparamsscimschemasoracleidcsextensioncapabilities_user: (Updatable) User's Capabilities
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUserArgs'] urnietfparamsscimschemasoracleidcsextensiondb_credentials_user: (Updatable) The database credentials user extension.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUserArgs'] urnietfparamsscimschemasoracleidcsextensionkerberos_user_user: (Updatable) Kerberos User extension
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUserArgs'] urnietfparamsscimschemasoracleidcsextensionmfa_user: (Updatable) This extension defines attributes used to manage Multi-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUserArgs'] urnietfparamsscimschemasoracleidcsextensionpasswordless_user: (Updatable) This extension defines attributes used to manage Passwordless-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUserArgs'] urnietfparamsscimschemasoracleidcsextensionposix_user: (Updatable) POSIX User extension
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUserArgs'] urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user: (Updatable) This extension defines the attributes used to store the security questions of a user.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUserArgs'] urnietfparamsscimschemasoracleidcsextensionself_change_user: (Updatable) Controls whether a user can update themselves or not via User related APIs
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUserArgs'] urnietfparamsscimschemasoracleidcsextensionself_registration_user: (Updatable) This extension defines attributes used to manage self registration profile linked to the user.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUserArgs'] urnietfparamsscimschemasoracleidcsextensionsff_user: (Updatable) SFF Auth Keys User extension
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUserArgs'] urnietfparamsscimschemasoracleidcsextensionsocial_account_user: (Updatable) Social User extension
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUserArgs'] urnietfparamsscimschemasoracleidcsextensionterms_of_use_user: (Updatable) Terms Of Use extension
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUserArgs'] urnietfparamsscimschemasoracleidcsextensionuser_state_user: (Updatable) This extension defines the attributes used to manage account passwords within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use passwords.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUserArgs'] urnietfparamsscimschemasoracleidcsextensionuser_user: (Updatable) Oracle Identity Cloud Service User
        :param pulumi.Input[str] user_type: (Updatable) Used to identify the organization-to-user relationship
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: User Type
               * idcsCsvAttributeNameMappings: [[columnHeaderName:User Type]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserX509certificateArgs']]] x509certificates: (Updatable) A list of certificates issued to the User.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        """
        pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        pulumi.set(__self__, "schemas", schemas)
        pulumi.set(__self__, "user_name", user_name)
        if active is not None:
            pulumi.set(__self__, "active", active)
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if entitlements is not None:
            pulumi.set(__self__, "entitlements", entitlements)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if ims is not None:
            pulumi.set(__self__, "ims", ims)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nick_name is not None:
            pulumi.set(__self__, "nick_name", nick_name)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if phone_numbers is not None:
            pulumi.set(__self__, "phone_numbers", phone_numbers)
        if photos is not None:
            pulumi.set(__self__, "photos", photos)
        if preferred_language is not None:
            pulumi.set(__self__, "preferred_language", preferred_language)
        if profile_url is not None:
            pulumi.set(__self__, "profile_url", profile_url)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if urnietfparamsscimschemasextensionenterprise20user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasextensionenterprise20user", urnietfparamsscimschemasextensionenterprise20user)
        if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextension_oci_tags", urnietfparamsscimschemasoracleidcsextension_oci_tags)
        if urnietfparamsscimschemasoracleidcsextensionadaptive_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionadaptive_user", urnietfparamsscimschemasoracleidcsextensionadaptive_user)
        if urnietfparamsscimschemasoracleidcsextensioncapabilities_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensioncapabilities_user", urnietfparamsscimschemasoracleidcsextensioncapabilities_user)
        if urnietfparamsscimschemasoracleidcsextensiondb_credentials_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensiondb_credentials_user", urnietfparamsscimschemasoracleidcsextensiondb_credentials_user)
        if urnietfparamsscimschemasoracleidcsextensionkerberos_user_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionkerberos_user_user", urnietfparamsscimschemasoracleidcsextensionkerberos_user_user)
        if urnietfparamsscimschemasoracleidcsextensionmfa_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionmfa_user", urnietfparamsscimschemasoracleidcsextensionmfa_user)
        if urnietfparamsscimschemasoracleidcsextensionpasswordless_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionpasswordless_user", urnietfparamsscimschemasoracleidcsextensionpasswordless_user)
        if urnietfparamsscimschemasoracleidcsextensionposix_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionposix_user", urnietfparamsscimschemasoracleidcsextensionposix_user)
        if urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user", urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user)
        if urnietfparamsscimschemasoracleidcsextensionself_change_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionself_change_user", urnietfparamsscimschemasoracleidcsextensionself_change_user)
        if urnietfparamsscimschemasoracleidcsextensionself_registration_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionself_registration_user", urnietfparamsscimschemasoracleidcsextensionself_registration_user)
        if urnietfparamsscimschemasoracleidcsextensionsff_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionsff_user", urnietfparamsscimschemasoracleidcsextensionsff_user)
        if urnietfparamsscimschemasoracleidcsextensionsocial_account_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionsocial_account_user", urnietfparamsscimschemasoracleidcsextensionsocial_account_user)
        if urnietfparamsscimschemasoracleidcsextensionterms_of_use_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionterms_of_use_user", urnietfparamsscimschemasoracleidcsextensionterms_of_use_user)
        if urnietfparamsscimschemasoracleidcsextensionuser_state_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionuser_state_user", urnietfparamsscimschemasoracleidcsextensionuser_state_user)
        if urnietfparamsscimschemasoracleidcsextensionuser_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionuser_user", urnietfparamsscimschemasoracleidcsextensionuser_user)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)
        if x509certificates is not None:
            pulumi.set(__self__, "x509certificates", x509certificates)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Input[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: pulumi.Input[str]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Input[str]:
        """
        (Updatable) User name

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: User ID
        * idcsCsvAttributeNameMappings: [[columnHeaderName:User Name, deprecatedColumnHeaderName:User ID]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Status of the account

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserAddressArgs']]]]:
        """
        (Updatable) A physical mailing address for this User, as described in (address Element). Canonical Type Values of work, home, and other. The value attribute is a complex type with the following sub-attributes.

        **SCIM++ Properties:**
        * idcsCompositeKey: [type]
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Address Street, deprecatedColumnHeaderName:Work Street Address, mapsTo:addresses[work].streetAddress], [columnHeaderName:Work Address Locality, deprecatedColumnHeaderName:Work City, mapsTo:addresses[work].locality], [columnHeaderName:Work Address Region, deprecatedColumnHeaderName:Work State, mapsTo:addresses[work].region], [columnHeaderName:Work Address Postal Code, deprecatedColumnHeaderName:Work Postal Code, mapsTo:addresses[work].postalCode], [columnHeaderName:Work Address Country, deprecatedColumnHeaderName:Work Country, mapsTo:addresses[work].country], [columnHeaderName:Work Address Formatted, mapsTo:addresses[work].formatted], [columnHeaderName:Home Address Formatted, mapsTo:addresses[home].formatted], [columnHeaderName:Other Address Formatted, mapsTo:addresses[other].formatted], [columnHeaderName:Home Address Street, mapsTo:addresses[home].streetAddress], [columnHeaderName:Other Address Street, mapsTo:addresses[other].streetAddress], [columnHeaderName:Home Address Locality, mapsTo:addresses[home].locality], [columnHeaderName:Other Address Locality, mapsTo:addresses[other].locality], [columnHeaderName:Home Address Region, mapsTo:addresses[home].region], [columnHeaderName:Other Address Region, mapsTo:addresses[other].region], [columnHeaderName:Home Address Country, mapsTo:addresses[home].country], [columnHeaderName:Other Address Country, mapsTo:addresses[other].country], [columnHeaderName:Home Address Postal Code, mapsTo:addresses[home].postalCode], [columnHeaderName:Other Address Postal Code, mapsTo:addresses[other].postalCode], [columnHeaderName:Primary Address Type, mapsTo:addresses[$(type)].primary]]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserAddressArgs']]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description of the user

        **Added In:** 2012271618

        **SCIM++ Properties:**
        * caseExact: false
        * idcsPii: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The displayName of the User's manager. OPTIONAL and READ-ONLY.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserEmailArgs']]]]:
        """
        (Updatable) A complex attribute representing emails

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Email, mapsTo:emails[work].value], [columnHeaderName:Home Email, mapsTo:emails[home].value], [columnHeaderName:Primary Email Type, mapsTo:emails[$(type)].primary], [columnHeaderName:Other Email, mapsTo:emails[other].value], [columnHeaderName:Recovery Email, mapsTo:emails[recovery].value], [columnHeaderName:Work Email Verified, mapsTo:emails[work].verified], [columnHeaderName:Home Email Verified, mapsTo:emails[home].verified], [columnHeaderName:Other Email Verified, mapsTo:emails[other].verified], [columnHeaderName:Recovery Email Verified, mapsTo:emails[recovery].verified]]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "emails")

    @emails.setter
    def emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserEmailArgs']]]]):
        pulumi.set(self, "emails", value)

    @property
    @pulumi.getter
    def entitlements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserEntitlementArgs']]]]:
        """
        (Updatable) A list of entitlements for the User that represent a thing the User has.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "entitlements")

    @entitlements.setter
    def entitlements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserEntitlementArgs']]]]):
        pulumi.set(self, "entitlements", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. READ-ONLY.

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def ims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserImArgs']]]]:
        """
        (Updatable) User's instant messaging addresses

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "ims")

    @ims.setter
    def ims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserImArgs']]]]):
        pulumi.set(self, "ims", value)

    @property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Used to indicate the User's default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Locale
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Locale]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locale", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input['DomainsUserNameArgs']]:
        """
        (Updatable) Name of the account assigned to the User.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input['DomainsUserNameArgs']]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nickName")
    def nick_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Nick name

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Nick Name
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Nick Name]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "nick_name")

    @nick_name.setter
    def nick_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nick_name", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the user's support account.

        **Added In:** 2103141444

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: always
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Password attribute. Max length for password is controlled via Password Policy.

        **SCIM++ Properties:**
        * idcsCsvAttributeName: Password
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Password]]
        * idcsPii: true
        * idcsSearchable: false
        * idcsSensitive: hash
        * multiValued: false
        * mutability: writeOnly
        * required: false
        * returned: never
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="phoneNumbers")
    def phone_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserPhoneNumberArgs']]]]:
        """
        (Updatable) Phone numbers

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Phone, mapsTo:phoneNumbers[work].value], [columnHeaderName:Mobile No, mapsTo:phoneNumbers[mobile].value], [columnHeaderName:Home Phone, mapsTo:phoneNumbers[home].value], [columnHeaderName:Fax, mapsTo:phoneNumbers[fax].value], [columnHeaderName:Pager, mapsTo:phoneNumbers[pager].value], [columnHeaderName:Other Phone, mapsTo:phoneNumbers[other].value], [columnHeaderName:Recovery Phone, mapsTo:phoneNumbers[recovery].value], [columnHeaderName:Primary Phone Type, mapsTo:phoneNumbers[$(type)].primary]]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "phone_numbers")

    @phone_numbers.setter
    def phone_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserPhoneNumberArgs']]]]):
        pulumi.set(self, "phone_numbers", value)

    @property
    @pulumi.getter
    def photos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserPhotoArgs']]]]:
        """
        (Updatable) URLs of photos for the User

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "photos")

    @photos.setter
    def photos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserPhotoArgs']]]]):
        pulumi.set(self, "photos", value)

    @property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User's preferred written or spoken language used for localized user interfaces

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Preferred Language
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Preferred Language]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "preferred_language")

    @preferred_language.setter
    def preferred_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_language", value)

    @property
    @pulumi.getter(name="profileUrl")
    def profile_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A fully-qualified URL to a page representing the User's online profile

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Profile URL
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Profile Url]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: reference
        * uniqueness: none
        """
        return pulumi.get(self, "profile_url")

    @profile_url.setter
    def profile_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_url", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserRoleArgs']]]]:
        """
        (Updatable) A list of roles for the User that collectively represent who the User is; e.g., 'Student', 'Faculty'.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserRoleArgs']]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User's timezone

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * idcsCsvAttributeName: TimeZone
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Time Zone, deprecatedColumnHeaderName:TimeZone]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Title

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Title
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Title]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def urnietfparamsscimschemasextensionenterprise20user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasextensionenterprise20userArgs']]:
        """
        (Updatable) Enterprise User
        """
        return pulumi.get(self, "urnietfparamsscimschemasextensionenterprise20user")

    @urnietfparamsscimschemasextensionenterprise20user.setter
    def urnietfparamsscimschemasextensionenterprise20user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasextensionenterprise20userArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasextensionenterprise20user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionOciTags")
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]:
        """
        (Updatable) Oracle Cloud Infrastructure Tags.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags")

    @urnietfparamsscimschemasoracleidcsextension_oci_tags.setter
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionadaptiveUser")
    def urnietfparamsscimschemasoracleidcsextensionadaptive_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUserArgs']]:
        """
        (Updatable) This extension defines attributes to manage user's risk score.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionadaptive_user")

    @urnietfparamsscimschemasoracleidcsextensionadaptive_user.setter
    def urnietfparamsscimschemasoracleidcsextensionadaptive_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionadaptive_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensioncapabilitiesUser")
    def urnietfparamsscimschemasoracleidcsextensioncapabilities_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUserArgs']]:
        """
        (Updatable) User's Capabilities
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensioncapabilities_user")

    @urnietfparamsscimschemasoracleidcsextensioncapabilities_user.setter
    def urnietfparamsscimschemasoracleidcsextensioncapabilities_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensioncapabilities_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiondbCredentialsUser")
    def urnietfparamsscimschemasoracleidcsextensiondb_credentials_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUserArgs']]:
        """
        (Updatable) The database credentials user extension.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiondb_credentials_user")

    @urnietfparamsscimschemasoracleidcsextensiondb_credentials_user.setter
    def urnietfparamsscimschemasoracleidcsextensiondb_credentials_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensiondb_credentials_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionkerberosUserUser")
    def urnietfparamsscimschemasoracleidcsextensionkerberos_user_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUserArgs']]:
        """
        (Updatable) Kerberos User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionkerberos_user_user")

    @urnietfparamsscimschemasoracleidcsextensionkerberos_user_user.setter
    def urnietfparamsscimschemasoracleidcsextensionkerberos_user_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionkerberos_user_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionmfaUser")
    def urnietfparamsscimschemasoracleidcsextensionmfa_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUserArgs']]:
        """
        (Updatable) This extension defines attributes used to manage Multi-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionmfa_user")

    @urnietfparamsscimschemasoracleidcsextensionmfa_user.setter
    def urnietfparamsscimschemasoracleidcsextensionmfa_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionmfa_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionpasswordlessUser")
    def urnietfparamsscimschemasoracleidcsextensionpasswordless_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUserArgs']]:
        """
        (Updatable) This extension defines attributes used to manage Passwordless-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionpasswordless_user")

    @urnietfparamsscimschemasoracleidcsextensionpasswordless_user.setter
    def urnietfparamsscimschemasoracleidcsextensionpasswordless_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionpasswordless_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionposixUser")
    def urnietfparamsscimschemasoracleidcsextensionposix_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUserArgs']]:
        """
        (Updatable) POSIX User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionposix_user")

    @urnietfparamsscimschemasoracleidcsextensionposix_user.setter
    def urnietfparamsscimschemasoracleidcsextensionposix_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionposix_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUser")
    def urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUserArgs']]:
        """
        (Updatable) This extension defines the attributes used to store the security questions of a user.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user")

    @urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user.setter
    def urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionselfChangeUser")
    def urnietfparamsscimschemasoracleidcsextensionself_change_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUserArgs']]:
        """
        (Updatable) Controls whether a user can update themselves or not via User related APIs
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionself_change_user")

    @urnietfparamsscimschemasoracleidcsextensionself_change_user.setter
    def urnietfparamsscimschemasoracleidcsextensionself_change_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionself_change_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionselfRegistrationUser")
    def urnietfparamsscimschemasoracleidcsextensionself_registration_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUserArgs']]:
        """
        (Updatable) This extension defines attributes used to manage self registration profile linked to the user.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionself_registration_user")

    @urnietfparamsscimschemasoracleidcsextensionself_registration_user.setter
    def urnietfparamsscimschemasoracleidcsextensionself_registration_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionself_registration_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsffUser")
    def urnietfparamsscimschemasoracleidcsextensionsff_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUserArgs']]:
        """
        (Updatable) SFF Auth Keys User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsff_user")

    @urnietfparamsscimschemasoracleidcsextensionsff_user.setter
    def urnietfparamsscimschemasoracleidcsextensionsff_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionsff_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsocialAccountUser")
    def urnietfparamsscimschemasoracleidcsextensionsocial_account_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUserArgs']]:
        """
        (Updatable) Social User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsocial_account_user")

    @urnietfparamsscimschemasoracleidcsextensionsocial_account_user.setter
    def urnietfparamsscimschemasoracleidcsextensionsocial_account_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionsocial_account_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiontermsOfUseUser")
    def urnietfparamsscimschemasoracleidcsextensionterms_of_use_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUserArgs']]:
        """
        (Updatable) Terms Of Use extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionterms_of_use_user")

    @urnietfparamsscimschemasoracleidcsextensionterms_of_use_user.setter
    def urnietfparamsscimschemasoracleidcsextensionterms_of_use_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionterms_of_use_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionuserStateUser")
    def urnietfparamsscimschemasoracleidcsextensionuser_state_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUserArgs']]:
        """
        (Updatable) This extension defines the attributes used to manage account passwords within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use passwords.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionuser_state_user")

    @urnietfparamsscimschemasoracleidcsextensionuser_state_user.setter
    def urnietfparamsscimschemasoracleidcsextensionuser_state_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionuser_state_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionuserUser")
    def urnietfparamsscimschemasoracleidcsextensionuser_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUserArgs']]:
        """
        (Updatable) Oracle Identity Cloud Service User
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionuser_user")

    @urnietfparamsscimschemasoracleidcsextensionuser_user.setter
    def urnietfparamsscimschemasoracleidcsextensionuser_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionuser_user", value)

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Used to identify the organization-to-user relationship

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: User Type
        * idcsCsvAttributeNameMappings: [[columnHeaderName:User Type]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_type", value)

    @property
    @pulumi.getter
    def x509certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserX509certificateArgs']]]]:
        """
        (Updatable) A list of certificates issued to the User.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "x509certificates")

    @x509certificates.setter
    def x509certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserX509certificateArgs']]]]):
        pulumi.set(self, "x509certificates", value)


@pulumi.input_type
class _DomainsUserState:
    def __init__(__self__, *,
                 active: Optional[pulumi.Input[bool]] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserAddressArgs']]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 compartment_ocid: Optional[pulumi.Input[str]] = None,
                 delete_in_progress: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain_ocid: Optional[pulumi.Input[str]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserEmailArgs']]]] = None,
                 entitlements: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserEntitlementArgs']]]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 groups: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserGroupArgs']]]] = None,
                 idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserIdcsCreatedByArgs']]]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserIdcsLastModifiedByArgs']]]] = None,
                 idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
                 idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ims: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserImArgs']]]] = None,
                 locale: Optional[pulumi.Input[str]] = None,
                 metas: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserMetaArgs']]]] = None,
                 name: Optional[pulumi.Input['DomainsUserNameArgs']] = None,
                 nick_name: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 phone_numbers: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserPhoneNumberArgs']]]] = None,
                 photos: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserPhotoArgs']]]] = None,
                 preferred_language: Optional[pulumi.Input[str]] = None,
                 profile_url: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserRoleArgs']]]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserTagArgs']]]] = None,
                 tenancy_ocid: Optional[pulumi.Input[str]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasextensionenterprise20user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasextensionenterprise20userArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionadaptive_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensioncapabilities_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensiondb_credentials_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensiondb_user_users: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbUserUserArgs']]]] = None,
                 urnietfparamsscimschemasoracleidcsextensionkerberos_user_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionmfa_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionpassword_state_users: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordStateUserArgs']]]] = None,
                 urnietfparamsscimschemasoracleidcsextensionpasswordless_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionposix_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionself_change_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionself_registration_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionsff_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionsocial_account_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionterms_of_use_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionuser_credentials_users: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserCredentialsUserArgs']]]] = None,
                 urnietfparamsscimschemasoracleidcsextensionuser_state_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUserArgs']] = None,
                 urnietfparamsscimschemasoracleidcsextensionuser_user: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUserArgs']] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 user_type: Optional[pulumi.Input[str]] = None,
                 x509certificates: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserX509certificateArgs']]]] = None):
        """
        Input properties used for looking up and filtering DomainsUser resources.
        :param pulumi.Input[bool] active: (Updatable) Status of the account
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserAddressArgs']]] addresses: (Updatable) A physical mailing address for this User, as described in (address Element). Canonical Type Values of work, home, and other. The value attribute is a complex type with the following sub-attributes.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [type]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Address Street, deprecatedColumnHeaderName:Work Street Address, mapsTo:addresses[work].streetAddress], [columnHeaderName:Work Address Locality, deprecatedColumnHeaderName:Work City, mapsTo:addresses[work].locality], [columnHeaderName:Work Address Region, deprecatedColumnHeaderName:Work State, mapsTo:addresses[work].region], [columnHeaderName:Work Address Postal Code, deprecatedColumnHeaderName:Work Postal Code, mapsTo:addresses[work].postalCode], [columnHeaderName:Work Address Country, deprecatedColumnHeaderName:Work Country, mapsTo:addresses[work].country], [columnHeaderName:Work Address Formatted, mapsTo:addresses[work].formatted], [columnHeaderName:Home Address Formatted, mapsTo:addresses[home].formatted], [columnHeaderName:Other Address Formatted, mapsTo:addresses[other].formatted], [columnHeaderName:Home Address Street, mapsTo:addresses[home].streetAddress], [columnHeaderName:Other Address Street, mapsTo:addresses[other].streetAddress], [columnHeaderName:Home Address Locality, mapsTo:addresses[home].locality], [columnHeaderName:Other Address Locality, mapsTo:addresses[other].locality], [columnHeaderName:Home Address Region, mapsTo:addresses[home].region], [columnHeaderName:Other Address Region, mapsTo:addresses[other].region], [columnHeaderName:Home Address Country, mapsTo:addresses[home].country], [columnHeaderName:Other Address Country, mapsTo:addresses[other].country], [columnHeaderName:Home Address Postal Code, mapsTo:addresses[home].postalCode], [columnHeaderName:Other Address Postal Code, mapsTo:addresses[other].postalCode], [columnHeaderName:Primary Address Type, mapsTo:addresses[$(type)].primary]]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) Description of the user
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsPii: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] display_name: (Updatable) The displayName of the User's manager. OPTIONAL and READ-ONLY.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserEmailArgs']]] emails: (Updatable) A complex attribute representing emails
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Email, mapsTo:emails[work].value], [columnHeaderName:Home Email, mapsTo:emails[home].value], [columnHeaderName:Primary Email Type, mapsTo:emails[$(type)].primary], [columnHeaderName:Other Email, mapsTo:emails[other].value], [columnHeaderName:Recovery Email, mapsTo:emails[recovery].value], [columnHeaderName:Work Email Verified, mapsTo:emails[work].verified], [columnHeaderName:Home Email Verified, mapsTo:emails[home].verified], [columnHeaderName:Other Email Verified, mapsTo:emails[other].verified], [columnHeaderName:Recovery Email Verified, mapsTo:emails[recovery].verified]]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserEntitlementArgs']]] entitlements: (Updatable) A list of entitlements for the User that represent a thing the User has.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. READ-ONLY.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserGroupArgs']]] groups: (Updatable) A list of groups that the user belongs to, either thorough direct membership, nested groups, or dynamically calculated
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserIdcsCreatedByArgs']]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserIdcsLastModifiedByArgs']]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserImArgs']]] ims: (Updatable) User's instant messaging addresses
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] locale: (Updatable) Used to indicate the User's default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Locale
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Locale]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserMetaArgs']]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input['DomainsUserNameArgs'] name: (Updatable) Name of the account assigned to the User.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] nick_name: (Updatable) Nick name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Nick Name
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Nick Name]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) The OCID of the user's support account.
               
               **Added In:** 2103141444
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: always
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] password: (Updatable) Password attribute. Max length for password is controlled via Password Policy.
               
               **SCIM++ Properties:**
               * idcsCsvAttributeName: Password
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Password]]
               * idcsPii: true
               * idcsSearchable: false
               * idcsSensitive: hash
               * multiValued: false
               * mutability: writeOnly
               * required: false
               * returned: never
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserPhoneNumberArgs']]] phone_numbers: (Updatable) Phone numbers
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Phone, mapsTo:phoneNumbers[work].value], [columnHeaderName:Mobile No, mapsTo:phoneNumbers[mobile].value], [columnHeaderName:Home Phone, mapsTo:phoneNumbers[home].value], [columnHeaderName:Fax, mapsTo:phoneNumbers[fax].value], [columnHeaderName:Pager, mapsTo:phoneNumbers[pager].value], [columnHeaderName:Other Phone, mapsTo:phoneNumbers[other].value], [columnHeaderName:Recovery Phone, mapsTo:phoneNumbers[recovery].value], [columnHeaderName:Primary Phone Type, mapsTo:phoneNumbers[$(type)].primary]]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserPhotoArgs']]] photos: (Updatable) URLs of photos for the User
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] preferred_language: (Updatable) User's preferred written or spoken language used for localized user interfaces
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Preferred Language
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Preferred Language]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] profile_url: (Updatable) A fully-qualified URL to a page representing the User's online profile
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Profile URL
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Profile Url]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserRoleArgs']]] roles: (Updatable) A list of roles for the User that collectively represent who the User is; e.g., 'Student', 'Faculty'.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserTagArgs']]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] timezone: (Updatable) User's timezone
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * idcsCsvAttributeName: TimeZone
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Time Zone, deprecatedColumnHeaderName:TimeZone]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] title: (Updatable) Title
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Title
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Title]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasextensionenterprise20userArgs'] urnietfparamsscimschemasextensionenterprise20user: (Updatable) Enterprise User
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs'] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUserArgs'] urnietfparamsscimschemasoracleidcsextensionadaptive_user: (Updatable) This extension defines attributes to manage user's risk score.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUserArgs'] urnietfparamsscimschemasoracleidcsextensioncapabilities_user: (Updatable) User's Capabilities
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUserArgs'] urnietfparamsscimschemasoracleidcsextensiondb_credentials_user: (Updatable) The database credentials user extension.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbUserUserArgs']]] urnietfparamsscimschemasoracleidcsextensiondb_user_users: (Updatable) DB User extension
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUserArgs'] urnietfparamsscimschemasoracleidcsextensionkerberos_user_user: (Updatable) Kerberos User extension
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUserArgs'] urnietfparamsscimschemasoracleidcsextensionmfa_user: (Updatable) This extension defines attributes used to manage Multi-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordStateUserArgs']]] urnietfparamsscimschemasoracleidcsextensionpassword_state_users: (Updatable) This extension defines attributes used to manage account passwords within a Service Provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use passwords.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUserArgs'] urnietfparamsscimschemasoracleidcsextensionpasswordless_user: (Updatable) This extension defines attributes used to manage Passwordless-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUserArgs'] urnietfparamsscimschemasoracleidcsextensionposix_user: (Updatable) POSIX User extension
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUserArgs'] urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user: (Updatable) This extension defines the attributes used to store the security questions of a user.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUserArgs'] urnietfparamsscimschemasoracleidcsextensionself_change_user: (Updatable) Controls whether a user can update themselves or not via User related APIs
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUserArgs'] urnietfparamsscimschemasoracleidcsextensionself_registration_user: (Updatable) This extension defines attributes used to manage self registration profile linked to the user.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUserArgs'] urnietfparamsscimschemasoracleidcsextensionsff_user: (Updatable) SFF Auth Keys User extension
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUserArgs'] urnietfparamsscimschemasoracleidcsextensionsocial_account_user: (Updatable) Social User extension
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUserArgs'] urnietfparamsscimschemasoracleidcsextensionterms_of_use_user: (Updatable) Terms Of Use extension
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserCredentialsUserArgs']]] urnietfparamsscimschemasoracleidcsextensionuser_credentials_users: (Updatable) User's credentials
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUserArgs'] urnietfparamsscimschemasoracleidcsextensionuser_state_user: (Updatable) This extension defines the attributes used to manage account passwords within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use passwords.
        :param pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUserArgs'] urnietfparamsscimschemasoracleidcsextensionuser_user: (Updatable) Oracle Identity Cloud Service User
        :param pulumi.Input[str] user_name: (Updatable) User name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: User ID
               * idcsCsvAttributeNameMappings: [[columnHeaderName:User Name, deprecatedColumnHeaderName:User ID]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] user_type: (Updatable) Used to identify the organization-to-user relationship
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: User Type
               * idcsCsvAttributeNameMappings: [[columnHeaderName:User Type]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input['DomainsUserX509certificateArgs']]] x509certificates: (Updatable) A list of certificates issued to the User.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        """
        if active is not None:
            pulumi.set(__self__, "active", active)
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if attribute_sets is not None:
            pulumi.set(__self__, "attribute_sets", attribute_sets)
        if attributes is not None:
            pulumi.set(__self__, "attributes", attributes)
        if authorization is not None:
            pulumi.set(__self__, "authorization", authorization)
        if compartment_ocid is not None:
            pulumi.set(__self__, "compartment_ocid", compartment_ocid)
        if delete_in_progress is not None:
            pulumi.set(__self__, "delete_in_progress", delete_in_progress)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain_ocid is not None:
            pulumi.set(__self__, "domain_ocid", domain_ocid)
        if emails is not None:
            pulumi.set(__self__, "emails", emails)
        if entitlements is not None:
            pulumi.set(__self__, "entitlements", entitlements)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if groups is not None:
            pulumi.set(__self__, "groups", groups)
        if idcs_created_bies is not None:
            pulumi.set(__self__, "idcs_created_bies", idcs_created_bies)
        if idcs_endpoint is not None:
            pulumi.set(__self__, "idcs_endpoint", idcs_endpoint)
        if idcs_last_modified_bies is not None:
            pulumi.set(__self__, "idcs_last_modified_bies", idcs_last_modified_bies)
        if idcs_last_upgraded_in_release is not None:
            pulumi.set(__self__, "idcs_last_upgraded_in_release", idcs_last_upgraded_in_release)
        if idcs_prevented_operations is not None:
            pulumi.set(__self__, "idcs_prevented_operations", idcs_prevented_operations)
        if ims is not None:
            pulumi.set(__self__, "ims", ims)
        if locale is not None:
            pulumi.set(__self__, "locale", locale)
        if metas is not None:
            pulumi.set(__self__, "metas", metas)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if nick_name is not None:
            pulumi.set(__self__, "nick_name", nick_name)
        if ocid is not None:
            pulumi.set(__self__, "ocid", ocid)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if phone_numbers is not None:
            pulumi.set(__self__, "phone_numbers", phone_numbers)
        if photos is not None:
            pulumi.set(__self__, "photos", photos)
        if preferred_language is not None:
            pulumi.set(__self__, "preferred_language", preferred_language)
        if profile_url is not None:
            pulumi.set(__self__, "profile_url", profile_url)
        if resource_type_schema_version is not None:
            pulumi.set(__self__, "resource_type_schema_version", resource_type_schema_version)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)
        if schemas is not None:
            pulumi.set(__self__, "schemas", schemas)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tenancy_ocid is not None:
            pulumi.set(__self__, "tenancy_ocid", tenancy_ocid)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if urnietfparamsscimschemasextensionenterprise20user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasextensionenterprise20user", urnietfparamsscimschemasextensionenterprise20user)
        if urnietfparamsscimschemasoracleidcsextension_oci_tags is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextension_oci_tags", urnietfparamsscimschemasoracleidcsextension_oci_tags)
        if urnietfparamsscimschemasoracleidcsextensionadaptive_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionadaptive_user", urnietfparamsscimschemasoracleidcsextensionadaptive_user)
        if urnietfparamsscimschemasoracleidcsextensioncapabilities_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensioncapabilities_user", urnietfparamsscimschemasoracleidcsextensioncapabilities_user)
        if urnietfparamsscimschemasoracleidcsextensiondb_credentials_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensiondb_credentials_user", urnietfparamsscimschemasoracleidcsextensiondb_credentials_user)
        if urnietfparamsscimschemasoracleidcsextensiondb_user_users is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensiondb_user_users", urnietfparamsscimschemasoracleidcsextensiondb_user_users)
        if urnietfparamsscimschemasoracleidcsextensionkerberos_user_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionkerberos_user_user", urnietfparamsscimschemasoracleidcsextensionkerberos_user_user)
        if urnietfparamsscimschemasoracleidcsextensionmfa_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionmfa_user", urnietfparamsscimschemasoracleidcsextensionmfa_user)
        if urnietfparamsscimschemasoracleidcsextensionpassword_state_users is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionpassword_state_users", urnietfparamsscimschemasoracleidcsextensionpassword_state_users)
        if urnietfparamsscimschemasoracleidcsextensionpasswordless_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionpasswordless_user", urnietfparamsscimschemasoracleidcsextensionpasswordless_user)
        if urnietfparamsscimschemasoracleidcsextensionposix_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionposix_user", urnietfparamsscimschemasoracleidcsextensionposix_user)
        if urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user", urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user)
        if urnietfparamsscimschemasoracleidcsextensionself_change_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionself_change_user", urnietfparamsscimschemasoracleidcsextensionself_change_user)
        if urnietfparamsscimschemasoracleidcsextensionself_registration_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionself_registration_user", urnietfparamsscimschemasoracleidcsextensionself_registration_user)
        if urnietfparamsscimschemasoracleidcsextensionsff_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionsff_user", urnietfparamsscimschemasoracleidcsextensionsff_user)
        if urnietfparamsscimschemasoracleidcsextensionsocial_account_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionsocial_account_user", urnietfparamsscimschemasoracleidcsextensionsocial_account_user)
        if urnietfparamsscimschemasoracleidcsextensionterms_of_use_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionterms_of_use_user", urnietfparamsscimschemasoracleidcsextensionterms_of_use_user)
        if urnietfparamsscimschemasoracleidcsextensionuser_credentials_users is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionuser_credentials_users", urnietfparamsscimschemasoracleidcsextensionuser_credentials_users)
        if urnietfparamsscimschemasoracleidcsextensionuser_state_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionuser_state_user", urnietfparamsscimschemasoracleidcsextensionuser_state_user)
        if urnietfparamsscimschemasoracleidcsextensionuser_user is not None:
            pulumi.set(__self__, "urnietfparamsscimschemasoracleidcsextensionuser_user", urnietfparamsscimschemasoracleidcsextensionuser_user)
        if user_name is not None:
            pulumi.set(__self__, "user_name", user_name)
        if user_type is not None:
            pulumi.set(__self__, "user_type", user_type)
        if x509certificates is not None:
            pulumi.set(__self__, "x509certificates", x509certificates)

    @property
    @pulumi.getter
    def active(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Status of the account

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "active")

    @active.setter
    def active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "active", value)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserAddressArgs']]]]:
        """
        (Updatable) A physical mailing address for this User, as described in (address Element). Canonical Type Values of work, home, and other. The value attribute is a complex type with the following sub-attributes.

        **SCIM++ Properties:**
        * idcsCompositeKey: [type]
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Address Street, deprecatedColumnHeaderName:Work Street Address, mapsTo:addresses[work].streetAddress], [columnHeaderName:Work Address Locality, deprecatedColumnHeaderName:Work City, mapsTo:addresses[work].locality], [columnHeaderName:Work Address Region, deprecatedColumnHeaderName:Work State, mapsTo:addresses[work].region], [columnHeaderName:Work Address Postal Code, deprecatedColumnHeaderName:Work Postal Code, mapsTo:addresses[work].postalCode], [columnHeaderName:Work Address Country, deprecatedColumnHeaderName:Work Country, mapsTo:addresses[work].country], [columnHeaderName:Work Address Formatted, mapsTo:addresses[work].formatted], [columnHeaderName:Home Address Formatted, mapsTo:addresses[home].formatted], [columnHeaderName:Other Address Formatted, mapsTo:addresses[other].formatted], [columnHeaderName:Home Address Street, mapsTo:addresses[home].streetAddress], [columnHeaderName:Other Address Street, mapsTo:addresses[other].streetAddress], [columnHeaderName:Home Address Locality, mapsTo:addresses[home].locality], [columnHeaderName:Other Address Locality, mapsTo:addresses[other].locality], [columnHeaderName:Home Address Region, mapsTo:addresses[home].region], [columnHeaderName:Other Address Region, mapsTo:addresses[other].region], [columnHeaderName:Home Address Country, mapsTo:addresses[home].country], [columnHeaderName:Other Address Country, mapsTo:addresses[other].country], [columnHeaderName:Home Address Postal Code, mapsTo:addresses[home].postalCode], [columnHeaderName:Other Address Postal Code, mapsTo:addresses[other].postalCode], [columnHeaderName:Primary Address Type, mapsTo:addresses[$(type)].primary]]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "addresses")

    @addresses.setter
    def addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserAddressArgs']]]]):
        pulumi.set(self, "addresses", value)

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @attribute_sets.setter
    def attribute_sets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "attribute_sets", value)

    @property
    @pulumi.getter
    def attributes(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter
    def authorization(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "authorization", value)

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @compartment_ocid.setter
    def compartment_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_ocid", value)

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @delete_in_progress.setter
    def delete_in_progress(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_in_progress", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description of the user

        **Added In:** 2012271618

        **SCIM++ Properties:**
        * caseExact: false
        * idcsPii: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The displayName of the User's manager. OPTIONAL and READ-ONLY.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @domain_ocid.setter
    def domain_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_ocid", value)

    @property
    @pulumi.getter
    def emails(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserEmailArgs']]]]:
        """
        (Updatable) A complex attribute representing emails

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Email, mapsTo:emails[work].value], [columnHeaderName:Home Email, mapsTo:emails[home].value], [columnHeaderName:Primary Email Type, mapsTo:emails[$(type)].primary], [columnHeaderName:Other Email, mapsTo:emails[other].value], [columnHeaderName:Recovery Email, mapsTo:emails[recovery].value], [columnHeaderName:Work Email Verified, mapsTo:emails[work].verified], [columnHeaderName:Home Email Verified, mapsTo:emails[home].verified], [columnHeaderName:Other Email Verified, mapsTo:emails[other].verified], [columnHeaderName:Recovery Email Verified, mapsTo:emails[recovery].verified]]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "emails")

    @emails.setter
    def emails(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserEmailArgs']]]]):
        pulumi.set(self, "emails", value)

    @property
    @pulumi.getter
    def entitlements(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserEntitlementArgs']]]]:
        """
        (Updatable) A list of entitlements for the User that represent a thing the User has.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "entitlements")

    @entitlements.setter
    def entitlements(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserEntitlementArgs']]]]):
        pulumi.set(self, "entitlements", value)

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. READ-ONLY.

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "external_id", value)

    @property
    @pulumi.getter
    def groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserGroupArgs']]]]:
        """
        (Updatable) A list of groups that the user belongs to, either thorough direct membership, nested groups, or dynamically calculated

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "groups")

    @groups.setter
    def groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserGroupArgs']]]]):
        pulumi.set(self, "groups", value)

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserIdcsCreatedByArgs']]]]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @idcs_created_bies.setter
    def idcs_created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserIdcsCreatedByArgs']]]]):
        pulumi.set(self, "idcs_created_bies", value)

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @idcs_endpoint.setter
    def idcs_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_endpoint", value)

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserIdcsLastModifiedByArgs']]]]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @idcs_last_modified_bies.setter
    def idcs_last_modified_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserIdcsLastModifiedByArgs']]]]):
        pulumi.set(self, "idcs_last_modified_bies", value)

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_last_upgraded_in_release", value)

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "idcs_prevented_operations", value)

    @property
    @pulumi.getter
    def ims(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserImArgs']]]]:
        """
        (Updatable) User's instant messaging addresses

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "ims")

    @ims.setter
    def ims(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserImArgs']]]]):
        pulumi.set(self, "ims", value)

    @property
    @pulumi.getter
    def locale(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Used to indicate the User's default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Locale
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Locale]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "locale")

    @locale.setter
    def locale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "locale", value)

    @property
    @pulumi.getter
    def metas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserMetaArgs']]]]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @metas.setter
    def metas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserMetaArgs']]]]):
        pulumi.set(self, "metas", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input['DomainsUserNameArgs']]:
        """
        (Updatable) Name of the account assigned to the User.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input['DomainsUserNameArgs']]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nickName")
    def nick_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Nick name

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Nick Name
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Nick Name]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "nick_name")

    @nick_name.setter
    def nick_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "nick_name", value)

    @property
    @pulumi.getter
    def ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the user's support account.

        **Added In:** 2103141444

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: always
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "ocid")

    @ocid.setter
    def ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ocid", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Password attribute. Max length for password is controlled via Password Policy.

        **SCIM++ Properties:**
        * idcsCsvAttributeName: Password
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Password]]
        * idcsPii: true
        * idcsSearchable: false
        * idcsSensitive: hash
        * multiValued: false
        * mutability: writeOnly
        * required: false
        * returned: never
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="phoneNumbers")
    def phone_numbers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserPhoneNumberArgs']]]]:
        """
        (Updatable) Phone numbers

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Phone, mapsTo:phoneNumbers[work].value], [columnHeaderName:Mobile No, mapsTo:phoneNumbers[mobile].value], [columnHeaderName:Home Phone, mapsTo:phoneNumbers[home].value], [columnHeaderName:Fax, mapsTo:phoneNumbers[fax].value], [columnHeaderName:Pager, mapsTo:phoneNumbers[pager].value], [columnHeaderName:Other Phone, mapsTo:phoneNumbers[other].value], [columnHeaderName:Recovery Phone, mapsTo:phoneNumbers[recovery].value], [columnHeaderName:Primary Phone Type, mapsTo:phoneNumbers[$(type)].primary]]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "phone_numbers")

    @phone_numbers.setter
    def phone_numbers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserPhoneNumberArgs']]]]):
        pulumi.set(self, "phone_numbers", value)

    @property
    @pulumi.getter
    def photos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserPhotoArgs']]]]:
        """
        (Updatable) URLs of photos for the User

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "photos")

    @photos.setter
    def photos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserPhotoArgs']]]]):
        pulumi.set(self, "photos", value)

    @property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User's preferred written or spoken language used for localized user interfaces

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Preferred Language
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Preferred Language]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "preferred_language")

    @preferred_language.setter
    def preferred_language(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_language", value)

    @property
    @pulumi.getter(name="profileUrl")
    def profile_url(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A fully-qualified URL to a page representing the User's online profile

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Profile URL
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Profile Url]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: reference
        * uniqueness: none
        """
        return pulumi.get(self, "profile_url")

    @profile_url.setter
    def profile_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_url", value)

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @resource_type_schema_version.setter
    def resource_type_schema_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type_schema_version", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserRoleArgs']]]]:
        """
        (Updatable) A list of roles for the User that collectively represent who the User is; e.g., 'Student', 'Faculty'.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserRoleArgs']]]]):
        pulumi.set(self, "roles", value)

    @property
    @pulumi.getter
    def schemas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @schemas.setter
    def schemas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "schemas", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserTagArgs']]]]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @tenancy_ocid.setter
    def tenancy_ocid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tenancy_ocid", value)

    @property
    @pulumi.getter
    def timezone(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User's timezone

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * idcsCsvAttributeName: TimeZone
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Time Zone, deprecatedColumnHeaderName:TimeZone]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "timezone")

    @timezone.setter
    def timezone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "timezone", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Title

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Title
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Title]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def urnietfparamsscimschemasextensionenterprise20user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasextensionenterprise20userArgs']]:
        """
        (Updatable) Enterprise User
        """
        return pulumi.get(self, "urnietfparamsscimschemasextensionenterprise20user")

    @urnietfparamsscimschemasextensionenterprise20user.setter
    def urnietfparamsscimschemasextensionenterprise20user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasextensionenterprise20userArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasextensionenterprise20user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionOciTags")
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]:
        """
        (Updatable) Oracle Cloud Infrastructure Tags.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags")

    @urnietfparamsscimschemasoracleidcsextension_oci_tags.setter
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionadaptiveUser")
    def urnietfparamsscimschemasoracleidcsextensionadaptive_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUserArgs']]:
        """
        (Updatable) This extension defines attributes to manage user's risk score.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionadaptive_user")

    @urnietfparamsscimschemasoracleidcsextensionadaptive_user.setter
    def urnietfparamsscimschemasoracleidcsextensionadaptive_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionadaptive_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensioncapabilitiesUser")
    def urnietfparamsscimschemasoracleidcsextensioncapabilities_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUserArgs']]:
        """
        (Updatable) User's Capabilities
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensioncapabilities_user")

    @urnietfparamsscimschemasoracleidcsextensioncapabilities_user.setter
    def urnietfparamsscimschemasoracleidcsextensioncapabilities_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensioncapabilities_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiondbCredentialsUser")
    def urnietfparamsscimschemasoracleidcsextensiondb_credentials_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUserArgs']]:
        """
        (Updatable) The database credentials user extension.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiondb_credentials_user")

    @urnietfparamsscimschemasoracleidcsextensiondb_credentials_user.setter
    def urnietfparamsscimschemasoracleidcsextensiondb_credentials_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensiondb_credentials_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiondbUserUsers")
    def urnietfparamsscimschemasoracleidcsextensiondb_user_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbUserUserArgs']]]]:
        """
        (Updatable) DB User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiondb_user_users")

    @urnietfparamsscimschemasoracleidcsextensiondb_user_users.setter
    def urnietfparamsscimschemasoracleidcsextensiondb_user_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbUserUserArgs']]]]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensiondb_user_users", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionkerberosUserUser")
    def urnietfparamsscimschemasoracleidcsextensionkerberos_user_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUserArgs']]:
        """
        (Updatable) Kerberos User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionkerberos_user_user")

    @urnietfparamsscimschemasoracleidcsextensionkerberos_user_user.setter
    def urnietfparamsscimschemasoracleidcsextensionkerberos_user_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionkerberos_user_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionmfaUser")
    def urnietfparamsscimschemasoracleidcsextensionmfa_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUserArgs']]:
        """
        (Updatable) This extension defines attributes used to manage Multi-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionmfa_user")

    @urnietfparamsscimschemasoracleidcsextensionmfa_user.setter
    def urnietfparamsscimschemasoracleidcsextensionmfa_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionmfa_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionpasswordStateUsers")
    def urnietfparamsscimschemasoracleidcsextensionpassword_state_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordStateUserArgs']]]]:
        """
        (Updatable) This extension defines attributes used to manage account passwords within a Service Provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use passwords.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionpassword_state_users")

    @urnietfparamsscimschemasoracleidcsextensionpassword_state_users.setter
    def urnietfparamsscimschemasoracleidcsextensionpassword_state_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordStateUserArgs']]]]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionpassword_state_users", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionpasswordlessUser")
    def urnietfparamsscimschemasoracleidcsextensionpasswordless_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUserArgs']]:
        """
        (Updatable) This extension defines attributes used to manage Passwordless-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionpasswordless_user")

    @urnietfparamsscimschemasoracleidcsextensionpasswordless_user.setter
    def urnietfparamsscimschemasoracleidcsextensionpasswordless_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionpasswordless_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionposixUser")
    def urnietfparamsscimschemasoracleidcsextensionposix_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUserArgs']]:
        """
        (Updatable) POSIX User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionposix_user")

    @urnietfparamsscimschemasoracleidcsextensionposix_user.setter
    def urnietfparamsscimschemasoracleidcsextensionposix_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionposix_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUser")
    def urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUserArgs']]:
        """
        (Updatable) This extension defines the attributes used to store the security questions of a user.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user")

    @urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user.setter
    def urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionselfChangeUser")
    def urnietfparamsscimschemasoracleidcsextensionself_change_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUserArgs']]:
        """
        (Updatable) Controls whether a user can update themselves or not via User related APIs
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionself_change_user")

    @urnietfparamsscimschemasoracleidcsextensionself_change_user.setter
    def urnietfparamsscimschemasoracleidcsextensionself_change_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionself_change_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionselfRegistrationUser")
    def urnietfparamsscimschemasoracleidcsextensionself_registration_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUserArgs']]:
        """
        (Updatable) This extension defines attributes used to manage self registration profile linked to the user.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionself_registration_user")

    @urnietfparamsscimschemasoracleidcsextensionself_registration_user.setter
    def urnietfparamsscimschemasoracleidcsextensionself_registration_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionself_registration_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsffUser")
    def urnietfparamsscimschemasoracleidcsextensionsff_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUserArgs']]:
        """
        (Updatable) SFF Auth Keys User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsff_user")

    @urnietfparamsscimschemasoracleidcsextensionsff_user.setter
    def urnietfparamsscimschemasoracleidcsextensionsff_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionsff_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsocialAccountUser")
    def urnietfparamsscimschemasoracleidcsextensionsocial_account_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUserArgs']]:
        """
        (Updatable) Social User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsocial_account_user")

    @urnietfparamsscimschemasoracleidcsextensionsocial_account_user.setter
    def urnietfparamsscimschemasoracleidcsextensionsocial_account_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionsocial_account_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiontermsOfUseUser")
    def urnietfparamsscimschemasoracleidcsextensionterms_of_use_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUserArgs']]:
        """
        (Updatable) Terms Of Use extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionterms_of_use_user")

    @urnietfparamsscimschemasoracleidcsextensionterms_of_use_user.setter
    def urnietfparamsscimschemasoracleidcsextensionterms_of_use_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionterms_of_use_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionuserCredentialsUsers")
    def urnietfparamsscimschemasoracleidcsextensionuser_credentials_users(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserCredentialsUserArgs']]]]:
        """
        (Updatable) User's credentials
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionuser_credentials_users")

    @urnietfparamsscimschemasoracleidcsextensionuser_credentials_users.setter
    def urnietfparamsscimschemasoracleidcsextensionuser_credentials_users(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserCredentialsUserArgs']]]]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionuser_credentials_users", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionuserStateUser")
    def urnietfparamsscimschemasoracleidcsextensionuser_state_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUserArgs']]:
        """
        (Updatable) This extension defines the attributes used to manage account passwords within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use passwords.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionuser_state_user")

    @urnietfparamsscimschemasoracleidcsextensionuser_state_user.setter
    def urnietfparamsscimschemasoracleidcsextensionuser_state_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionuser_state_user", value)

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionuserUser")
    def urnietfparamsscimschemasoracleidcsextensionuser_user(self) -> Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUserArgs']]:
        """
        (Updatable) Oracle Identity Cloud Service User
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionuser_user")

    @urnietfparamsscimschemasoracleidcsextensionuser_user.setter
    def urnietfparamsscimschemasoracleidcsextensionuser_user(self, value: Optional[pulumi.Input['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUserArgs']]):
        pulumi.set(self, "urnietfparamsscimschemasoracleidcsextensionuser_user", value)

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) User name

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: User ID
        * idcsCsvAttributeNameMappings: [[columnHeaderName:User Name, deprecatedColumnHeaderName:User ID]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "user_name")

    @user_name.setter
    def user_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_name", value)

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Used to identify the organization-to-user relationship

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: User Type
        * idcsCsvAttributeNameMappings: [[columnHeaderName:User Type]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "user_type")

    @user_type.setter
    def user_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_type", value)

    @property
    @pulumi.getter
    def x509certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserX509certificateArgs']]]]:
        """
        (Updatable) A list of certificates issued to the User.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "x509certificates")

    @x509certificates.setter
    def x509certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DomainsUserX509certificateArgs']]]]):
        pulumi.set(self, "x509certificates", value)


class DomainsUser(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserAddressArgs']]]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserEmailArgs']]]]] = None,
                 entitlements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserEntitlementArgs']]]]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 ims: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserImArgs']]]]] = None,
                 locale: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[pulumi.InputType['DomainsUserNameArgs']]] = None,
                 nick_name: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 phone_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserPhoneNumberArgs']]]]] = None,
                 photos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserPhotoArgs']]]]] = None,
                 preferred_language: Optional[pulumi.Input[str]] = None,
                 profile_url: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserRoleArgs']]]]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserTagArgs']]]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasextensionenterprise20user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasextensionenterprise20userArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionadaptive_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensioncapabilities_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensiondb_credentials_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionkerberos_user_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionmfa_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionpasswordless_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionposix_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionself_change_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionself_registration_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionsff_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionsocial_account_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionterms_of_use_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionuser_state_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionuser_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUserArgs']]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 user_type: Optional[pulumi.Input[str]] = None,
                 x509certificates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserX509certificateArgs']]]]] = None,
                 __props__=None):
        """
        This resource provides the User resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a user.

        ## Import

        Users can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsUser:DomainsUser test_user "idcsEndpoint/{idcsEndpoint}/users/{userId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: (Updatable) Status of the account
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserAddressArgs']]]] addresses: (Updatable) A physical mailing address for this User, as described in (address Element). Canonical Type Values of work, home, and other. The value attribute is a complex type with the following sub-attributes.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [type]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Address Street, deprecatedColumnHeaderName:Work Street Address, mapsTo:addresses[work].streetAddress], [columnHeaderName:Work Address Locality, deprecatedColumnHeaderName:Work City, mapsTo:addresses[work].locality], [columnHeaderName:Work Address Region, deprecatedColumnHeaderName:Work State, mapsTo:addresses[work].region], [columnHeaderName:Work Address Postal Code, deprecatedColumnHeaderName:Work Postal Code, mapsTo:addresses[work].postalCode], [columnHeaderName:Work Address Country, deprecatedColumnHeaderName:Work Country, mapsTo:addresses[work].country], [columnHeaderName:Work Address Formatted, mapsTo:addresses[work].formatted], [columnHeaderName:Home Address Formatted, mapsTo:addresses[home].formatted], [columnHeaderName:Other Address Formatted, mapsTo:addresses[other].formatted], [columnHeaderName:Home Address Street, mapsTo:addresses[home].streetAddress], [columnHeaderName:Other Address Street, mapsTo:addresses[other].streetAddress], [columnHeaderName:Home Address Locality, mapsTo:addresses[home].locality], [columnHeaderName:Other Address Locality, mapsTo:addresses[other].locality], [columnHeaderName:Home Address Region, mapsTo:addresses[home].region], [columnHeaderName:Other Address Region, mapsTo:addresses[other].region], [columnHeaderName:Home Address Country, mapsTo:addresses[home].country], [columnHeaderName:Other Address Country, mapsTo:addresses[other].country], [columnHeaderName:Home Address Postal Code, mapsTo:addresses[home].postalCode], [columnHeaderName:Other Address Postal Code, mapsTo:addresses[other].postalCode], [columnHeaderName:Primary Address Type, mapsTo:addresses[$(type)].primary]]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] description: (Updatable) Description of the user
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsPii: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] display_name: (Updatable) The displayName of the User's manager. OPTIONAL and READ-ONLY.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserEmailArgs']]]] emails: (Updatable) A complex attribute representing emails
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Email, mapsTo:emails[work].value], [columnHeaderName:Home Email, mapsTo:emails[home].value], [columnHeaderName:Primary Email Type, mapsTo:emails[$(type)].primary], [columnHeaderName:Other Email, mapsTo:emails[other].value], [columnHeaderName:Recovery Email, mapsTo:emails[recovery].value], [columnHeaderName:Work Email Verified, mapsTo:emails[work].verified], [columnHeaderName:Home Email Verified, mapsTo:emails[home].verified], [columnHeaderName:Other Email Verified, mapsTo:emails[other].verified], [columnHeaderName:Recovery Email Verified, mapsTo:emails[recovery].verified]]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserEntitlementArgs']]]] entitlements: (Updatable) A list of entitlements for the User that represent a thing the User has.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. READ-ONLY.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserImArgs']]]] ims: (Updatable) User's instant messaging addresses
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] locale: (Updatable) Used to indicate the User's default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Locale
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Locale]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsUserNameArgs']] name: (Updatable) Name of the account assigned to the User.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] nick_name: (Updatable) Nick name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Nick Name
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Nick Name]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) The OCID of the user's support account.
               
               **Added In:** 2103141444
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: always
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] password: (Updatable) Password attribute. Max length for password is controlled via Password Policy.
               
               **SCIM++ Properties:**
               * idcsCsvAttributeName: Password
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Password]]
               * idcsPii: true
               * idcsSearchable: false
               * idcsSensitive: hash
               * multiValued: false
               * mutability: writeOnly
               * required: false
               * returned: never
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserPhoneNumberArgs']]]] phone_numbers: (Updatable) Phone numbers
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Phone, mapsTo:phoneNumbers[work].value], [columnHeaderName:Mobile No, mapsTo:phoneNumbers[mobile].value], [columnHeaderName:Home Phone, mapsTo:phoneNumbers[home].value], [columnHeaderName:Fax, mapsTo:phoneNumbers[fax].value], [columnHeaderName:Pager, mapsTo:phoneNumbers[pager].value], [columnHeaderName:Other Phone, mapsTo:phoneNumbers[other].value], [columnHeaderName:Recovery Phone, mapsTo:phoneNumbers[recovery].value], [columnHeaderName:Primary Phone Type, mapsTo:phoneNumbers[$(type)].primary]]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserPhotoArgs']]]] photos: (Updatable) URLs of photos for the User
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] preferred_language: (Updatable) User's preferred written or spoken language used for localized user interfaces
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Preferred Language
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Preferred Language]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] profile_url: (Updatable) A fully-qualified URL to a page representing the User's online profile
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Profile URL
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Profile Url]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserRoleArgs']]]] roles: (Updatable) A list of roles for the User that collectively represent who the User is; e.g., 'Student', 'Faculty'.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserTagArgs']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] timezone: (Updatable) User's timezone
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * idcsCsvAttributeName: TimeZone
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Time Zone, deprecatedColumnHeaderName:TimeZone]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] title: (Updatable) Title
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Title
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Title]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasextensionenterprise20userArgs']] urnietfparamsscimschemasextensionenterprise20user: (Updatable) Enterprise User
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUserArgs']] urnietfparamsscimschemasoracleidcsextensionadaptive_user: (Updatable) This extension defines attributes to manage user's risk score.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUserArgs']] urnietfparamsscimschemasoracleidcsextensioncapabilities_user: (Updatable) User's Capabilities
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUserArgs']] urnietfparamsscimschemasoracleidcsextensiondb_credentials_user: (Updatable) The database credentials user extension.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUserArgs']] urnietfparamsscimschemasoracleidcsextensionkerberos_user_user: (Updatable) Kerberos User extension
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUserArgs']] urnietfparamsscimschemasoracleidcsextensionmfa_user: (Updatable) This extension defines attributes used to manage Multi-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUserArgs']] urnietfparamsscimschemasoracleidcsextensionpasswordless_user: (Updatable) This extension defines attributes used to manage Passwordless-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUserArgs']] urnietfparamsscimschemasoracleidcsextensionposix_user: (Updatable) POSIX User extension
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUserArgs']] urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user: (Updatable) This extension defines the attributes used to store the security questions of a user.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUserArgs']] urnietfparamsscimschemasoracleidcsextensionself_change_user: (Updatable) Controls whether a user can update themselves or not via User related APIs
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUserArgs']] urnietfparamsscimschemasoracleidcsextensionself_registration_user: (Updatable) This extension defines attributes used to manage self registration profile linked to the user.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUserArgs']] urnietfparamsscimschemasoracleidcsextensionsff_user: (Updatable) SFF Auth Keys User extension
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUserArgs']] urnietfparamsscimschemasoracleidcsextensionsocial_account_user: (Updatable) Social User extension
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUserArgs']] urnietfparamsscimschemasoracleidcsextensionterms_of_use_user: (Updatable) Terms Of Use extension
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUserArgs']] urnietfparamsscimschemasoracleidcsextensionuser_state_user: (Updatable) This extension defines the attributes used to manage account passwords within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use passwords.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUserArgs']] urnietfparamsscimschemasoracleidcsextensionuser_user: (Updatable) Oracle Identity Cloud Service User
        :param pulumi.Input[str] user_name: (Updatable) User name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: User ID
               * idcsCsvAttributeNameMappings: [[columnHeaderName:User Name, deprecatedColumnHeaderName:User ID]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] user_type: (Updatable) Used to identify the organization-to-user relationship
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: User Type
               * idcsCsvAttributeNameMappings: [[columnHeaderName:User Type]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserX509certificateArgs']]]] x509certificates: (Updatable) A list of certificates issued to the User.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DomainsUserArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the User resource in Oracle Cloud Infrastructure Identity Domains service.

        Create a user.

        ## Import

        Users can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:Identity/domainsUser:DomainsUser test_user "idcsEndpoint/{idcsEndpoint}/users/{userId}"
        ```

        :param str resource_name: The name of the resource.
        :param DomainsUserArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DomainsUserArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 active: Optional[pulumi.Input[bool]] = None,
                 addresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserAddressArgs']]]]] = None,
                 attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 attributes: Optional[pulumi.Input[str]] = None,
                 authorization: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 emails: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserEmailArgs']]]]] = None,
                 entitlements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserEntitlementArgs']]]]] = None,
                 external_id: Optional[pulumi.Input[str]] = None,
                 idcs_endpoint: Optional[pulumi.Input[str]] = None,
                 ims: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserImArgs']]]]] = None,
                 locale: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[pulumi.InputType['DomainsUserNameArgs']]] = None,
                 nick_name: Optional[pulumi.Input[str]] = None,
                 ocid: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 phone_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserPhoneNumberArgs']]]]] = None,
                 photos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserPhotoArgs']]]]] = None,
                 preferred_language: Optional[pulumi.Input[str]] = None,
                 profile_url: Optional[pulumi.Input[str]] = None,
                 resource_type_schema_version: Optional[pulumi.Input[str]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserRoleArgs']]]]] = None,
                 schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserTagArgs']]]]] = None,
                 timezone: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 urnietfparamsscimschemasextensionenterprise20user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasextensionenterprise20userArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionadaptive_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensioncapabilities_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensiondb_credentials_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionkerberos_user_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionmfa_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionpasswordless_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionposix_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionself_change_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionself_registration_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionsff_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionsocial_account_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionterms_of_use_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionuser_state_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUserArgs']]] = None,
                 urnietfparamsscimschemasoracleidcsextensionuser_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUserArgs']]] = None,
                 user_name: Optional[pulumi.Input[str]] = None,
                 user_type: Optional[pulumi.Input[str]] = None,
                 x509certificates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserX509certificateArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DomainsUserArgs.__new__(DomainsUserArgs)

            __props__.__dict__["active"] = active
            __props__.__dict__["addresses"] = addresses
            __props__.__dict__["attribute_sets"] = attribute_sets
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["authorization"] = authorization
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["emails"] = emails
            __props__.__dict__["entitlements"] = entitlements
            __props__.__dict__["external_id"] = external_id
            if idcs_endpoint is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_endpoint'")
            __props__.__dict__["idcs_endpoint"] = idcs_endpoint
            __props__.__dict__["ims"] = ims
            __props__.__dict__["locale"] = locale
            __props__.__dict__["name"] = name
            __props__.__dict__["nick_name"] = nick_name
            __props__.__dict__["ocid"] = ocid
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["phone_numbers"] = phone_numbers
            __props__.__dict__["photos"] = photos
            __props__.__dict__["preferred_language"] = preferred_language
            __props__.__dict__["profile_url"] = profile_url
            __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
            __props__.__dict__["roles"] = roles
            if schemas is None and not opts.urn:
                raise TypeError("Missing required property 'schemas'")
            __props__.__dict__["schemas"] = schemas
            __props__.__dict__["tags"] = tags
            __props__.__dict__["timezone"] = timezone
            __props__.__dict__["title"] = title
            __props__.__dict__["urnietfparamsscimschemasextensionenterprise20user"] = urnietfparamsscimschemasextensionenterprise20user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextension_oci_tags"] = urnietfparamsscimschemasoracleidcsextension_oci_tags
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionadaptive_user"] = urnietfparamsscimschemasoracleidcsextensionadaptive_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensioncapabilities_user"] = urnietfparamsscimschemasoracleidcsextensioncapabilities_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensiondb_credentials_user"] = urnietfparamsscimschemasoracleidcsextensiondb_credentials_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionkerberos_user_user"] = urnietfparamsscimschemasoracleidcsextensionkerberos_user_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionmfa_user"] = urnietfparamsscimschemasoracleidcsextensionmfa_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionpasswordless_user"] = urnietfparamsscimschemasoracleidcsextensionpasswordless_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionposix_user"] = urnietfparamsscimschemasoracleidcsextensionposix_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user"] = urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionself_change_user"] = urnietfparamsscimschemasoracleidcsextensionself_change_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionself_registration_user"] = urnietfparamsscimschemasoracleidcsextensionself_registration_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionsff_user"] = urnietfparamsscimschemasoracleidcsextensionsff_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionsocial_account_user"] = urnietfparamsscimschemasoracleidcsextensionsocial_account_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionterms_of_use_user"] = urnietfparamsscimschemasoracleidcsextensionterms_of_use_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionuser_state_user"] = urnietfparamsscimschemasoracleidcsextensionuser_state_user
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionuser_user"] = urnietfparamsscimschemasoracleidcsextensionuser_user
            if user_name is None and not opts.urn:
                raise TypeError("Missing required property 'user_name'")
            __props__.__dict__["user_name"] = user_name
            __props__.__dict__["user_type"] = user_type
            __props__.__dict__["x509certificates"] = x509certificates
            __props__.__dict__["compartment_ocid"] = None
            __props__.__dict__["delete_in_progress"] = None
            __props__.__dict__["domain_ocid"] = None
            __props__.__dict__["groups"] = None
            __props__.__dict__["idcs_created_bies"] = None
            __props__.__dict__["idcs_last_modified_bies"] = None
            __props__.__dict__["idcs_last_upgraded_in_release"] = None
            __props__.__dict__["idcs_prevented_operations"] = None
            __props__.__dict__["metas"] = None
            __props__.__dict__["tenancy_ocid"] = None
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensiondb_user_users"] = None
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionpassword_state_users"] = None
            __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionuser_credentials_users"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DomainsUser, __self__).__init__(
            'oci:Identity/domainsUser:DomainsUser',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active: Optional[pulumi.Input[bool]] = None,
            addresses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserAddressArgs']]]]] = None,
            attribute_sets: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            attributes: Optional[pulumi.Input[str]] = None,
            authorization: Optional[pulumi.Input[str]] = None,
            compartment_ocid: Optional[pulumi.Input[str]] = None,
            delete_in_progress: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            domain_ocid: Optional[pulumi.Input[str]] = None,
            emails: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserEmailArgs']]]]] = None,
            entitlements: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserEntitlementArgs']]]]] = None,
            external_id: Optional[pulumi.Input[str]] = None,
            groups: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserGroupArgs']]]]] = None,
            idcs_created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserIdcsCreatedByArgs']]]]] = None,
            idcs_endpoint: Optional[pulumi.Input[str]] = None,
            idcs_last_modified_bies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserIdcsLastModifiedByArgs']]]]] = None,
            idcs_last_upgraded_in_release: Optional[pulumi.Input[str]] = None,
            idcs_prevented_operations: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            ims: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserImArgs']]]]] = None,
            locale: Optional[pulumi.Input[str]] = None,
            metas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserMetaArgs']]]]] = None,
            name: Optional[pulumi.Input[pulumi.InputType['DomainsUserNameArgs']]] = None,
            nick_name: Optional[pulumi.Input[str]] = None,
            ocid: Optional[pulumi.Input[str]] = None,
            password: Optional[pulumi.Input[str]] = None,
            phone_numbers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserPhoneNumberArgs']]]]] = None,
            photos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserPhotoArgs']]]]] = None,
            preferred_language: Optional[pulumi.Input[str]] = None,
            profile_url: Optional[pulumi.Input[str]] = None,
            resource_type_schema_version: Optional[pulumi.Input[str]] = None,
            roles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserRoleArgs']]]]] = None,
            schemas: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserTagArgs']]]]] = None,
            tenancy_ocid: Optional[pulumi.Input[str]] = None,
            timezone: Optional[pulumi.Input[str]] = None,
            title: Optional[pulumi.Input[str]] = None,
            urnietfparamsscimschemasextensionenterprise20user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasextensionenterprise20userArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextension_oci_tags: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionadaptive_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensioncapabilities_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensiondb_credentials_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensiondb_user_users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbUserUserArgs']]]]] = None,
            urnietfparamsscimschemasoracleidcsextensionkerberos_user_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionmfa_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionpassword_state_users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordStateUserArgs']]]]] = None,
            urnietfparamsscimschemasoracleidcsextensionpasswordless_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionposix_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionself_change_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionself_registration_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionsff_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionsocial_account_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionterms_of_use_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionuser_credentials_users: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserCredentialsUserArgs']]]]] = None,
            urnietfparamsscimschemasoracleidcsextensionuser_state_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUserArgs']]] = None,
            urnietfparamsscimschemasoracleidcsextensionuser_user: Optional[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUserArgs']]] = None,
            user_name: Optional[pulumi.Input[str]] = None,
            user_type: Optional[pulumi.Input[str]] = None,
            x509certificates: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserX509certificateArgs']]]]] = None) -> 'DomainsUser':
        """
        Get an existing DomainsUser resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] active: (Updatable) Status of the account
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserAddressArgs']]]] addresses: (Updatable) A physical mailing address for this User, as described in (address Element). Canonical Type Values of work, home, and other. The value attribute is a complex type with the following sub-attributes.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [type]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Address Street, deprecatedColumnHeaderName:Work Street Address, mapsTo:addresses[work].streetAddress], [columnHeaderName:Work Address Locality, deprecatedColumnHeaderName:Work City, mapsTo:addresses[work].locality], [columnHeaderName:Work Address Region, deprecatedColumnHeaderName:Work State, mapsTo:addresses[work].region], [columnHeaderName:Work Address Postal Code, deprecatedColumnHeaderName:Work Postal Code, mapsTo:addresses[work].postalCode], [columnHeaderName:Work Address Country, deprecatedColumnHeaderName:Work Country, mapsTo:addresses[work].country], [columnHeaderName:Work Address Formatted, mapsTo:addresses[work].formatted], [columnHeaderName:Home Address Formatted, mapsTo:addresses[home].formatted], [columnHeaderName:Other Address Formatted, mapsTo:addresses[other].formatted], [columnHeaderName:Home Address Street, mapsTo:addresses[home].streetAddress], [columnHeaderName:Other Address Street, mapsTo:addresses[other].streetAddress], [columnHeaderName:Home Address Locality, mapsTo:addresses[home].locality], [columnHeaderName:Other Address Locality, mapsTo:addresses[other].locality], [columnHeaderName:Home Address Region, mapsTo:addresses[home].region], [columnHeaderName:Other Address Region, mapsTo:addresses[other].region], [columnHeaderName:Home Address Country, mapsTo:addresses[home].country], [columnHeaderName:Other Address Country, mapsTo:addresses[other].country], [columnHeaderName:Home Address Postal Code, mapsTo:addresses[home].postalCode], [columnHeaderName:Other Address Postal Code, mapsTo:addresses[other].postalCode], [columnHeaderName:Primary Address Type, mapsTo:addresses[$(type)].primary]]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attribute_sets: (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        :param pulumi.Input[str] attributes: (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        :param pulumi.Input[str] authorization: (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        :param pulumi.Input[str] compartment_ocid: (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[bool] delete_in_progress: (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: boolean
               * uniqueness: none
        :param pulumi.Input[str] description: (Updatable) Description of the user
               
               **Added In:** 2012271618
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsPii: true
               * idcsSearchable: false
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] display_name: (Updatable) The displayName of the User's manager. OPTIONAL and READ-ONLY.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] domain_ocid: (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserEmailArgs']]]] emails: (Updatable) A complex attribute representing emails
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Email, mapsTo:emails[work].value], [columnHeaderName:Home Email, mapsTo:emails[home].value], [columnHeaderName:Primary Email Type, mapsTo:emails[$(type)].primary], [columnHeaderName:Other Email, mapsTo:emails[other].value], [columnHeaderName:Recovery Email, mapsTo:emails[recovery].value], [columnHeaderName:Work Email Verified, mapsTo:emails[work].verified], [columnHeaderName:Home Email Verified, mapsTo:emails[home].verified], [columnHeaderName:Other Email Verified, mapsTo:emails[other].verified], [columnHeaderName:Recovery Email Verified, mapsTo:emails[recovery].verified]]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserEntitlementArgs']]]] entitlements: (Updatable) A list of entitlements for the User that represent a thing the User has.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] external_id: (Updatable) An identifier for the Resource as defined by the Service Consumer. READ-ONLY.
               
               **Added In:** 2011192329
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserGroupArgs']]]] groups: (Updatable) A list of groups that the user belongs to, either thorough direct membership, nested groups, or dynamically calculated
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserIdcsCreatedByArgs']]]] idcs_created_bies: (Updatable) The User or App who created the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: true
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_endpoint: The basic endpoint for the identity domain
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserIdcsLastModifiedByArgs']]]] idcs_last_modified_bies: (Updatable) The User or App who modified the Resource
               
               **SCIM++ Properties:**
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: complex
        :param pulumi.Input[str] idcs_last_upgraded_in_release: (Updatable) The release number when the resource was upgraded.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] idcs_prevented_operations: (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.
               
               **SCIM++ Properties:**
               * idcsSearchable: false
               * multiValued: true
               * mutability: readOnly
               * required: false
               * returned: request
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserImArgs']]]] ims: (Updatable) User's instant messaging addresses
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] locale: (Updatable) Used to indicate the User's default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Locale
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Locale]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserMetaArgs']]]] metas: (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
               * type: complex
        :param pulumi.Input[pulumi.InputType['DomainsUserNameArgs']] name: (Updatable) Name of the account assigned to the User.
               
               **Added In:** 17.4.6
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] nick_name: (Updatable) Nick name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Nick Name
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Nick Name]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] ocid: (Updatable) The OCID of the user's support account.
               
               **Added In:** 2103141444
               
               **SCIM++ Properties:**
               * caseExact: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: always
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] password: (Updatable) Password attribute. Max length for password is controlled via Password Policy.
               
               **SCIM++ Properties:**
               * idcsCsvAttributeName: Password
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Password]]
               * idcsPii: true
               * idcsSearchable: false
               * idcsSensitive: hash
               * multiValued: false
               * mutability: writeOnly
               * required: false
               * returned: never
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserPhoneNumberArgs']]]] phone_numbers: (Updatable) Phone numbers
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Phone, mapsTo:phoneNumbers[work].value], [columnHeaderName:Mobile No, mapsTo:phoneNumbers[mobile].value], [columnHeaderName:Home Phone, mapsTo:phoneNumbers[home].value], [columnHeaderName:Fax, mapsTo:phoneNumbers[fax].value], [columnHeaderName:Pager, mapsTo:phoneNumbers[pager].value], [columnHeaderName:Other Phone, mapsTo:phoneNumbers[other].value], [columnHeaderName:Recovery Phone, mapsTo:phoneNumbers[recovery].value], [columnHeaderName:Primary Phone Type, mapsTo:phoneNumbers[$(type)].primary]]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserPhotoArgs']]]] photos: (Updatable) URLs of photos for the User
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * idcsPii: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] preferred_language: (Updatable) User's preferred written or spoken language used for localized user interfaces
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Preferred Language
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Preferred Language]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] profile_url: (Updatable) A fully-qualified URL to a page representing the User's online profile
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Profile URL
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Profile Url]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: reference
               * uniqueness: none
        :param pulumi.Input[str] resource_type_schema_version: (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserRoleArgs']]]] roles: (Updatable) A list of roles for the User that collectively represent who the User is; e.g., 'Student', 'Faculty'.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value, type]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[str]]] schemas: (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: true
               * mutability: readWrite
               * required: true
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserTagArgs']]]] tags: (Updatable) A list of tags on this resource.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [key, value]
               * idcsSearchable: true
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: request
               * type: complex
               * uniqueness: none
        :param pulumi.Input[str] tenancy_ocid: (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsSearchable: false
               * multiValued: false
               * mutability: readOnly
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] timezone: (Updatable) User's timezone
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
               * idcsCanonicalValueSourceResourceType: AllowedValue
               * idcsCsvAttributeName: TimeZone
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Time Zone, deprecatedColumnHeaderName:TimeZone]]
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[str] title: (Updatable) Title
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: Title
               * idcsCsvAttributeNameMappings: [[columnHeaderName:Title]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasextensionenterprise20userArgs']] urnietfparamsscimschemasextensionenterprise20user: (Updatable) Enterprise User
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTagsArgs']] urnietfparamsscimschemasoracleidcsextension_oci_tags: (Updatable) Oracle Cloud Infrastructure Tags.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUserArgs']] urnietfparamsscimschemasoracleidcsextensionadaptive_user: (Updatable) This extension defines attributes to manage user's risk score.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUserArgs']] urnietfparamsscimschemasoracleidcsextensioncapabilities_user: (Updatable) User's Capabilities
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUserArgs']] urnietfparamsscimschemasoracleidcsextensiondb_credentials_user: (Updatable) The database credentials user extension.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbUserUserArgs']]]] urnietfparamsscimschemasoracleidcsextensiondb_user_users: (Updatable) DB User extension
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUserArgs']] urnietfparamsscimschemasoracleidcsextensionkerberos_user_user: (Updatable) Kerberos User extension
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUserArgs']] urnietfparamsscimschemasoracleidcsextensionmfa_user: (Updatable) This extension defines attributes used to manage Multi-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordStateUserArgs']]]] urnietfparamsscimschemasoracleidcsextensionpassword_state_users: (Updatable) This extension defines attributes used to manage account passwords within a Service Provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use passwords.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUserArgs']] urnietfparamsscimschemasoracleidcsextensionpasswordless_user: (Updatable) This extension defines attributes used to manage Passwordless-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUserArgs']] urnietfparamsscimschemasoracleidcsextensionposix_user: (Updatable) POSIX User extension
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUserArgs']] urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user: (Updatable) This extension defines the attributes used to store the security questions of a user.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUserArgs']] urnietfparamsscimschemasoracleidcsextensionself_change_user: (Updatable) Controls whether a user can update themselves or not via User related APIs
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUserArgs']] urnietfparamsscimschemasoracleidcsextensionself_registration_user: (Updatable) This extension defines attributes used to manage self registration profile linked to the user.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUserArgs']] urnietfparamsscimschemasoracleidcsextensionsff_user: (Updatable) SFF Auth Keys User extension
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUserArgs']] urnietfparamsscimschemasoracleidcsextensionsocial_account_user: (Updatable) Social User extension
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUserArgs']] urnietfparamsscimschemasoracleidcsextensionterms_of_use_user: (Updatable) Terms Of Use extension
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserCredentialsUserArgs']]]] urnietfparamsscimschemasoracleidcsextensionuser_credentials_users: (Updatable) User's credentials
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUserArgs']] urnietfparamsscimschemasoracleidcsextensionuser_state_user: (Updatable) This extension defines the attributes used to manage account passwords within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use passwords.
        :param pulumi.Input[pulumi.InputType['DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUserArgs']] urnietfparamsscimschemasoracleidcsextensionuser_user: (Updatable) Oracle Identity Cloud Service User
        :param pulumi.Input[str] user_name: (Updatable) User name
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: User ID
               * idcsCsvAttributeNameMappings: [[columnHeaderName:User Name, deprecatedColumnHeaderName:User ID]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: true
               * returned: always
               * type: string
               * uniqueness: global
        :param pulumi.Input[str] user_type: (Updatable) Used to identify the organization-to-user relationship
               
               **SCIM++ Properties:**
               * caseExact: false
               * idcsCsvAttributeName: User Type
               * idcsCsvAttributeNameMappings: [[columnHeaderName:User Type]]
               * idcsPii: true
               * idcsSearchable: true
               * multiValued: false
               * mutability: readWrite
               * required: false
               * returned: default
               * type: string
               * uniqueness: none
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DomainsUserX509certificateArgs']]]] x509certificates: (Updatable) A list of certificates issued to the User.
               
               **SCIM++ Properties:**
               * idcsCompositeKey: [value]
               * multiValued: true
               * mutability: readWrite
               * required: false
               * returned: default
               * type: complex
               * uniqueness: none
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DomainsUserState.__new__(_DomainsUserState)

        __props__.__dict__["active"] = active
        __props__.__dict__["addresses"] = addresses
        __props__.__dict__["attribute_sets"] = attribute_sets
        __props__.__dict__["attributes"] = attributes
        __props__.__dict__["authorization"] = authorization
        __props__.__dict__["compartment_ocid"] = compartment_ocid
        __props__.__dict__["delete_in_progress"] = delete_in_progress
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain_ocid"] = domain_ocid
        __props__.__dict__["emails"] = emails
        __props__.__dict__["entitlements"] = entitlements
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["groups"] = groups
        __props__.__dict__["idcs_created_bies"] = idcs_created_bies
        __props__.__dict__["idcs_endpoint"] = idcs_endpoint
        __props__.__dict__["idcs_last_modified_bies"] = idcs_last_modified_bies
        __props__.__dict__["idcs_last_upgraded_in_release"] = idcs_last_upgraded_in_release
        __props__.__dict__["idcs_prevented_operations"] = idcs_prevented_operations
        __props__.__dict__["ims"] = ims
        __props__.__dict__["locale"] = locale
        __props__.__dict__["metas"] = metas
        __props__.__dict__["name"] = name
        __props__.__dict__["nick_name"] = nick_name
        __props__.__dict__["ocid"] = ocid
        __props__.__dict__["password"] = password
        __props__.__dict__["phone_numbers"] = phone_numbers
        __props__.__dict__["photos"] = photos
        __props__.__dict__["preferred_language"] = preferred_language
        __props__.__dict__["profile_url"] = profile_url
        __props__.__dict__["resource_type_schema_version"] = resource_type_schema_version
        __props__.__dict__["roles"] = roles
        __props__.__dict__["schemas"] = schemas
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tenancy_ocid"] = tenancy_ocid
        __props__.__dict__["timezone"] = timezone
        __props__.__dict__["title"] = title
        __props__.__dict__["urnietfparamsscimschemasextensionenterprise20user"] = urnietfparamsscimschemasextensionenterprise20user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextension_oci_tags"] = urnietfparamsscimschemasoracleidcsextension_oci_tags
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionadaptive_user"] = urnietfparamsscimschemasoracleidcsextensionadaptive_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensioncapabilities_user"] = urnietfparamsscimschemasoracleidcsextensioncapabilities_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensiondb_credentials_user"] = urnietfparamsscimschemasoracleidcsextensiondb_credentials_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensiondb_user_users"] = urnietfparamsscimschemasoracleidcsextensiondb_user_users
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionkerberos_user_user"] = urnietfparamsscimschemasoracleidcsextensionkerberos_user_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionmfa_user"] = urnietfparamsscimschemasoracleidcsextensionmfa_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionpassword_state_users"] = urnietfparamsscimschemasoracleidcsextensionpassword_state_users
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionpasswordless_user"] = urnietfparamsscimschemasoracleidcsextensionpasswordless_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionposix_user"] = urnietfparamsscimschemasoracleidcsextensionposix_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user"] = urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionself_change_user"] = urnietfparamsscimschemasoracleidcsextensionself_change_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionself_registration_user"] = urnietfparamsscimschemasoracleidcsextensionself_registration_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionsff_user"] = urnietfparamsscimschemasoracleidcsextensionsff_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionsocial_account_user"] = urnietfparamsscimschemasoracleidcsextensionsocial_account_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionterms_of_use_user"] = urnietfparamsscimschemasoracleidcsextensionterms_of_use_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionuser_credentials_users"] = urnietfparamsscimschemasoracleidcsextensionuser_credentials_users
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionuser_state_user"] = urnietfparamsscimschemasoracleidcsextensionuser_state_user
        __props__.__dict__["urnietfparamsscimschemasoracleidcsextensionuser_user"] = urnietfparamsscimschemasoracleidcsextensionuser_user
        __props__.__dict__["user_name"] = user_name
        __props__.__dict__["user_type"] = user_type
        __props__.__dict__["x509certificates"] = x509certificates
        return DomainsUser(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def active(self) -> pulumi.Output[bool]:
        """
        (Updatable) Status of the account

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter
    def addresses(self) -> pulumi.Output[Sequence['outputs.DomainsUserAddress']]:
        """
        (Updatable) A physical mailing address for this User, as described in (address Element). Canonical Type Values of work, home, and other. The value attribute is a complex type with the following sub-attributes.

        **SCIM++ Properties:**
        * idcsCompositeKey: [type]
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Address Street, deprecatedColumnHeaderName:Work Street Address, mapsTo:addresses[work].streetAddress], [columnHeaderName:Work Address Locality, deprecatedColumnHeaderName:Work City, mapsTo:addresses[work].locality], [columnHeaderName:Work Address Region, deprecatedColumnHeaderName:Work State, mapsTo:addresses[work].region], [columnHeaderName:Work Address Postal Code, deprecatedColumnHeaderName:Work Postal Code, mapsTo:addresses[work].postalCode], [columnHeaderName:Work Address Country, deprecatedColumnHeaderName:Work Country, mapsTo:addresses[work].country], [columnHeaderName:Work Address Formatted, mapsTo:addresses[work].formatted], [columnHeaderName:Home Address Formatted, mapsTo:addresses[home].formatted], [columnHeaderName:Other Address Formatted, mapsTo:addresses[other].formatted], [columnHeaderName:Home Address Street, mapsTo:addresses[home].streetAddress], [columnHeaderName:Other Address Street, mapsTo:addresses[other].streetAddress], [columnHeaderName:Home Address Locality, mapsTo:addresses[home].locality], [columnHeaderName:Other Address Locality, mapsTo:addresses[other].locality], [columnHeaderName:Home Address Region, mapsTo:addresses[home].region], [columnHeaderName:Other Address Region, mapsTo:addresses[other].region], [columnHeaderName:Home Address Country, mapsTo:addresses[home].country], [columnHeaderName:Other Address Country, mapsTo:addresses[other].country], [columnHeaderName:Home Address Postal Code, mapsTo:addresses[home].postalCode], [columnHeaderName:Other Address Postal Code, mapsTo:addresses[other].postalCode], [columnHeaderName:Primary Address Type, mapsTo:addresses[$(type)].primary]]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="attributeSets")
    def attribute_sets(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        (Updatable) A multi-valued list of strings indicating the return type of attribute definition. The specified set of attributes can be fetched by the return type of the attribute. One or more values can be given together to fetch more than one group of attributes. If 'attributes' query parameter is also available, union of the two is fetched. Valid values - all, always, never, request, default. Values are case-insensitive.
        """
        return pulumi.get(self, "attribute_sets")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) A comma-delimited string that specifies the names of resource attributes that should be returned in the response. By default, a response that contains resource attributes contains only attributes that are defined in the schema for that resource type as returned=always or returned=default. An attribute that is defined as returned=request is returned in a response only if the request specifies its name in the value of this query parameter. If a request specifies this query parameter, the response contains the attributes that this query parameter specifies, as well as any attribute that is defined as returned=always.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter
    def authorization(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) The Authorization field value consists of credentials containing the authentication information of the user agent for the realm of the resource being requested.
        """
        return pulumi.get(self, "authorization")

    @property
    @pulumi.getter(name="compartmentOcid")
    def compartment_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "compartment_ocid")

    @property
    @pulumi.getter(name="deleteInProgress")
    def delete_in_progress(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: boolean
        * uniqueness: none
        """
        return pulumi.get(self, "delete_in_progress")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Description of the user

        **Added In:** 2012271618

        **SCIM++ Properties:**
        * caseExact: false
        * idcsPii: true
        * idcsSearchable: false
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The displayName of the User's manager. OPTIONAL and READ-ONLY.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="domainOcid")
    def domain_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "domain_ocid")

    @property
    @pulumi.getter
    def emails(self) -> pulumi.Output[Sequence['outputs.DomainsUserEmail']]:
        """
        (Updatable) A complex attribute representing emails

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Email, mapsTo:emails[work].value], [columnHeaderName:Home Email, mapsTo:emails[home].value], [columnHeaderName:Primary Email Type, mapsTo:emails[$(type)].primary], [columnHeaderName:Other Email, mapsTo:emails[other].value], [columnHeaderName:Recovery Email, mapsTo:emails[recovery].value], [columnHeaderName:Work Email Verified, mapsTo:emails[work].verified], [columnHeaderName:Home Email Verified, mapsTo:emails[home].verified], [columnHeaderName:Other Email Verified, mapsTo:emails[other].verified], [columnHeaderName:Recovery Email Verified, mapsTo:emails[recovery].verified]]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "emails")

    @property
    @pulumi.getter
    def entitlements(self) -> pulumi.Output[Sequence['outputs.DomainsUserEntitlement']]:
        """
        (Updatable) A list of entitlements for the User that represent a thing the User has.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "entitlements")

    @property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[str]:
        """
        (Updatable) An identifier for the Resource as defined by the Service Consumer. READ-ONLY.

        **Added In:** 2011192329

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "external_id")

    @property
    @pulumi.getter
    def groups(self) -> pulumi.Output[Sequence['outputs.DomainsUserGroup']]:
        """
        (Updatable) A list of groups that the user belongs to, either thorough direct membership, nested groups, or dynamically calculated

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "groups")

    @property
    @pulumi.getter(name="idcsCreatedBies")
    def idcs_created_bies(self) -> pulumi.Output[Sequence['outputs.DomainsUserIdcsCreatedBy']]:
        """
        (Updatable) The User or App who created the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: true
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_created_bies")

    @property
    @pulumi.getter(name="idcsEndpoint")
    def idcs_endpoint(self) -> pulumi.Output[str]:
        """
        The basic endpoint for the identity domain
        """
        return pulumi.get(self, "idcs_endpoint")

    @property
    @pulumi.getter(name="idcsLastModifiedBies")
    def idcs_last_modified_bies(self) -> pulumi.Output[Sequence['outputs.DomainsUserIdcsLastModifiedBy']]:
        """
        (Updatable) The User or App who modified the Resource

        **SCIM++ Properties:**
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: complex
        """
        return pulumi.get(self, "idcs_last_modified_bies")

    @property
    @pulumi.getter(name="idcsLastUpgradedInRelease")
    def idcs_last_upgraded_in_release(self) -> pulumi.Output[str]:
        """
        (Updatable) The release number when the resource was upgraded.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_last_upgraded_in_release")

    @property
    @pulumi.getter(name="idcsPreventedOperations")
    def idcs_prevented_operations(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
        * idcsSearchable: false
        * multiValued: true
        * mutability: readOnly
        * required: false
        * returned: request
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "idcs_prevented_operations")

    @property
    @pulumi.getter
    def ims(self) -> pulumi.Output[Sequence['outputs.DomainsUserIm']]:
        """
        (Updatable) User's instant messaging addresses

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "ims")

    @property
    @pulumi.getter
    def locale(self) -> pulumi.Output[str]:
        """
        (Updatable) Used to indicate the User's default location for purposes of localizing items such as currency, date and time format, numerical representations, and so on.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Locale
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Locale]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "locale")

    @property
    @pulumi.getter
    def metas(self) -> pulumi.Output[Sequence['outputs.DomainsUserMeta']]:
        """
        (Updatable) A complex attribute that contains resource metadata. All sub-attributes are OPTIONAL.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Created Date, mapsTo:meta.created]]
        * type: complex
        """
        return pulumi.get(self, "metas")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output['outputs.DomainsUserName']:
        """
        (Updatable) Name of the account assigned to the User.

        **Added In:** 17.4.6

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nickName")
    def nick_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Nick name

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Nick Name
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Nick Name]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "nick_name")

    @property
    @pulumi.getter
    def ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the user's support account.

        **Added In:** 2103141444

        **SCIM++ Properties:**
        * caseExact: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: always
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "ocid")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        (Updatable) Password attribute. Max length for password is controlled via Password Policy.

        **SCIM++ Properties:**
        * idcsCsvAttributeName: Password
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Password]]
        * idcsPii: true
        * idcsSearchable: false
        * idcsSensitive: hash
        * multiValued: false
        * mutability: writeOnly
        * required: false
        * returned: never
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="phoneNumbers")
    def phone_numbers(self) -> pulumi.Output[Sequence['outputs.DomainsUserPhoneNumber']]:
        """
        (Updatable) Phone numbers

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Work Phone, mapsTo:phoneNumbers[work].value], [columnHeaderName:Mobile No, mapsTo:phoneNumbers[mobile].value], [columnHeaderName:Home Phone, mapsTo:phoneNumbers[home].value], [columnHeaderName:Fax, mapsTo:phoneNumbers[fax].value], [columnHeaderName:Pager, mapsTo:phoneNumbers[pager].value], [columnHeaderName:Other Phone, mapsTo:phoneNumbers[other].value], [columnHeaderName:Recovery Phone, mapsTo:phoneNumbers[recovery].value], [columnHeaderName:Primary Phone Type, mapsTo:phoneNumbers[$(type)].primary]]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "phone_numbers")

    @property
    @pulumi.getter
    def photos(self) -> pulumi.Output[Sequence['outputs.DomainsUserPhoto']]:
        """
        (Updatable) URLs of photos for the User

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * idcsPii: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "photos")

    @property
    @pulumi.getter(name="preferredLanguage")
    def preferred_language(self) -> pulumi.Output[str]:
        """
        (Updatable) User's preferred written or spoken language used for localized user interfaces

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Preferred Language
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Preferred Language]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "preferred_language")

    @property
    @pulumi.getter(name="profileUrl")
    def profile_url(self) -> pulumi.Output[str]:
        """
        (Updatable) A fully-qualified URL to a page representing the User's online profile

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Profile URL
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Profile Url]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: reference
        * uniqueness: none
        """
        return pulumi.get(self, "profile_url")

    @property
    @pulumi.getter(name="resourceTypeSchemaVersion")
    def resource_type_schema_version(self) -> pulumi.Output[Optional[str]]:
        """
        (Updatable) An endpoint-specific schema version number to use in the Request. Allowed version values are Earliest Version or Latest Version as specified in each REST API endpoint description, or any sequential number inbetween. All schema attributes/body parameters are a part of version 1. After version 1, any attributes added or deprecated will be tagged with the version that they were added to or deprecated in. If no version is provided, the latest schema version is returned.
        """
        return pulumi.get(self, "resource_type_schema_version")

    @property
    @pulumi.getter
    def roles(self) -> pulumi.Output[Sequence['outputs.DomainsUserRole']]:
        """
        (Updatable) A list of roles for the User that collectively represent who the User is; e.g., 'Student', 'Faculty'.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value, type]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "roles")

    @property
    @pulumi.getter
    def schemas(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\"enterprise\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: true
        * mutability: readWrite
        * required: true
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "schemas")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence['outputs.DomainsUserTag']]:
        """
        (Updatable) A list of tags on this resource.

        **SCIM++ Properties:**
        * idcsCompositeKey: [key, value]
        * idcsSearchable: true
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: request
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tenancyOcid")
    def tenancy_ocid(self) -> pulumi.Output[str]:
        """
        (Updatable) Oracle Cloud Infrastructure Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
        * caseExact: false
        * idcsSearchable: false
        * multiValued: false
        * mutability: readOnly
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "tenancy_ocid")

    @property
    @pulumi.getter
    def timezone(self) -> pulumi.Output[str]:
        """
        (Updatable) User's timezone

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCanonicalValueSourceFilter: attrName eq "timezones" and attrValues.value eq "$(timezone)"
        * idcsCanonicalValueSourceResourceType: AllowedValue
        * idcsCsvAttributeName: TimeZone
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Time Zone, deprecatedColumnHeaderName:TimeZone]]
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "timezone")

    @property
    @pulumi.getter
    def title(self) -> pulumi.Output[str]:
        """
        (Updatable) Title

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: Title
        * idcsCsvAttributeNameMappings: [[columnHeaderName:Title]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "title")

    @property
    @pulumi.getter
    def urnietfparamsscimschemasextensionenterprise20user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasextensionenterprise20user']:
        """
        (Updatable) Enterprise User
        """
        return pulumi.get(self, "urnietfparamsscimschemasextensionenterprise20user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionOciTags")
    def urnietfparamsscimschemasoracleidcsextension_oci_tags(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionOciTags']:
        """
        (Updatable) Oracle Cloud Infrastructure Tags.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextension_oci_tags")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionadaptiveUser")
    def urnietfparamsscimschemasoracleidcsextensionadaptive_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionadaptiveUser']:
        """
        (Updatable) This extension defines attributes to manage user's risk score.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionadaptive_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensioncapabilitiesUser")
    def urnietfparamsscimschemasoracleidcsextensioncapabilities_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensioncapabilitiesUser']:
        """
        (Updatable) User's Capabilities
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensioncapabilities_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiondbCredentialsUser")
    def urnietfparamsscimschemasoracleidcsextensiondb_credentials_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbCredentialsUser']:
        """
        (Updatable) The database credentials user extension.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiondb_credentials_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiondbUserUsers")
    def urnietfparamsscimschemasoracleidcsextensiondb_user_users(self) -> pulumi.Output[Sequence['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensiondbUserUser']]:
        """
        (Updatable) DB User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensiondb_user_users")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionkerberosUserUser")
    def urnietfparamsscimschemasoracleidcsextensionkerberos_user_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionkerberosUserUser']:
        """
        (Updatable) Kerberos User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionkerberos_user_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionmfaUser")
    def urnietfparamsscimschemasoracleidcsextensionmfa_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionmfaUser']:
        """
        (Updatable) This extension defines attributes used to manage Multi-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionmfa_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionpasswordStateUsers")
    def urnietfparamsscimschemasoracleidcsextensionpassword_state_users(self) -> pulumi.Output[Sequence['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordStateUser']]:
        """
        (Updatable) This extension defines attributes used to manage account passwords within a Service Provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use passwords.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionpassword_state_users")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionpasswordlessUser")
    def urnietfparamsscimschemasoracleidcsextensionpasswordless_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionpasswordlessUser']:
        """
        (Updatable) This extension defines attributes used to manage Passwordless-Factor Authentication within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use MFA.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionpasswordless_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionposixUser")
    def urnietfparamsscimschemasoracleidcsextensionposix_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionposixUser']:
        """
        (Updatable) POSIX User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionposix_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUser")
    def urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionsecurityQuestionsUser']:
        """
        (Updatable) This extension defines the attributes used to store the security questions of a user.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsecurity_questions_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionselfChangeUser")
    def urnietfparamsscimschemasoracleidcsextensionself_change_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfChangeUser']:
        """
        (Updatable) Controls whether a user can update themselves or not via User related APIs
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionself_change_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionselfRegistrationUser")
    def urnietfparamsscimschemasoracleidcsextensionself_registration_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionselfRegistrationUser']:
        """
        (Updatable) This extension defines attributes used to manage self registration profile linked to the user.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionself_registration_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsffUser")
    def urnietfparamsscimschemasoracleidcsextensionsff_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionsffUser']:
        """
        (Updatable) SFF Auth Keys User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsff_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionsocialAccountUser")
    def urnietfparamsscimschemasoracleidcsextensionsocial_account_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionsocialAccountUser']:
        """
        (Updatable) Social User extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionsocial_account_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensiontermsOfUseUser")
    def urnietfparamsscimschemasoracleidcsextensionterms_of_use_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensiontermsOfUseUser']:
        """
        (Updatable) Terms Of Use extension
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionterms_of_use_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionuserCredentialsUsers")
    def urnietfparamsscimschemasoracleidcsextensionuser_credentials_users(self) -> pulumi.Output[Sequence['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserCredentialsUser']]:
        """
        (Updatable) User's credentials
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionuser_credentials_users")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionuserStateUser")
    def urnietfparamsscimschemasoracleidcsextensionuser_state_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserStateUser']:
        """
        (Updatable) This extension defines the attributes used to manage account passwords within a service provider. The extension is typically applied to a User resource, but MAY be applied to other resources that use passwords.
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionuser_state_user")

    @property
    @pulumi.getter(name="urnietfparamsscimschemasoracleidcsextensionuserUser")
    def urnietfparamsscimschemasoracleidcsextensionuser_user(self) -> pulumi.Output['outputs.DomainsUserUrnietfparamsscimschemasoracleidcsextensionuserUser']:
        """
        (Updatable) Oracle Identity Cloud Service User
        """
        return pulumi.get(self, "urnietfparamsscimschemasoracleidcsextensionuser_user")

    @property
    @pulumi.getter(name="userName")
    def user_name(self) -> pulumi.Output[str]:
        """
        (Updatable) User name

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: User ID
        * idcsCsvAttributeNameMappings: [[columnHeaderName:User Name, deprecatedColumnHeaderName:User ID]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: true
        * returned: always
        * type: string
        * uniqueness: global
        """
        return pulumi.get(self, "user_name")

    @property
    @pulumi.getter(name="userType")
    def user_type(self) -> pulumi.Output[str]:
        """
        (Updatable) Used to identify the organization-to-user relationship

        **SCIM++ Properties:**
        * caseExact: false
        * idcsCsvAttributeName: User Type
        * idcsCsvAttributeNameMappings: [[columnHeaderName:User Type]]
        * idcsPii: true
        * idcsSearchable: true
        * multiValued: false
        * mutability: readWrite
        * required: false
        * returned: default
        * type: string
        * uniqueness: none
        """
        return pulumi.get(self, "user_type")

    @property
    @pulumi.getter
    def x509certificates(self) -> pulumi.Output[Sequence['outputs.DomainsUserX509certificate']]:
        """
        (Updatable) A list of certificates issued to the User.

        **SCIM++ Properties:**
        * idcsCompositeKey: [value]
        * multiValued: true
        * mutability: readWrite
        * required: false
        * returned: default
        * type: complex
        * uniqueness: none
        """
        return pulumi.get(self, "x509certificates")

