# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackendSetArgs', 'BackendSet']

@pulumi.input_type
class BackendSetArgs:
    def __init__(__self__, *,
                 health_checker: pulumi.Input['BackendSetHealthCheckerArgs'],
                 load_balancer_id: pulumi.Input[str],
                 policy: pulumi.Input[str],
                 lb_cookie_session_persistence_configuration: Optional[pulumi.Input['BackendSetLbCookieSessionPersistenceConfigurationArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 session_persistence_configuration: Optional[pulumi.Input['BackendSetSessionPersistenceConfigurationArgs']] = None,
                 ssl_configuration: Optional[pulumi.Input['BackendSetSslConfigurationArgs']] = None):
        """
        The set of arguments for constructing a BackendSet resource.
        :param pulumi.Input['BackendSetHealthCheckerArgs'] health_checker: (Updatable) The health check policy's configuration details.
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a backend set.
        :param pulumi.Input[str] policy: (Updatable) The load balancer policy for the backend set. To get a list of available policies, use the [ListPolicies](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerPolicy/ListPolicies) operation.  Example: `LEAST_CONNECTIONS`
        :param pulumi.Input['BackendSetLbCookieSessionPersistenceConfigurationArgs'] lb_cookie_session_persistence_configuration: (Updatable) The configuration details for implementing load balancer cookie session persistence (LB cookie stickiness).
               
               Session persistence enables the Load Balancing service to direct all requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).
               
               When you configure LB cookie stickiness, the load balancer inserts a cookie into the response. The parameters configured in the cookie enable session stickiness. This method is useful when you have applications and Web backend services that cannot generate their own cookies.
               
               Path route rules take precedence to determine the target backend server. The load balancer verifies that session stickiness is enabled for the backend server and that the cookie configuration (domain, path, and cookie hash) is valid for the target. The system ignores invalid cookies.
               
               To disable LB cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `LBCookieSessionPersistenceConfigurationDetails` object.
               
               Example: `LBCookieSessionPersistenceConfigurationDetails: null`
               
               **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[str] name: A friendly name for the backend set. It must be unique and it cannot be changed.
               
               Valid backend set names include only alphanumeric characters, dashes, and underscores. Backend set names cannot contain spaces. Avoid entering confidential information.
               
               Example: `example_backend_set`
        :param pulumi.Input['BackendSetSessionPersistenceConfigurationArgs'] session_persistence_configuration: (Updatable) The configuration details for implementing session persistence based on a user-specified cookie name (application cookie stickiness).
               
               Session persistence enables the Load Balancing service to direct any number of requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).
               
               With application cookie stickiness, the load balancer enables session persistence only when the response from a backend application server includes a `Set-cookie` header with the user-specified cookie name.
               
               To disable application cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `SessionPersistenceConfigurationDetails` object.
               
               Example: `SessionPersistenceConfigurationDetails: null`
               
               **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input['BackendSetSslConfigurationArgs'] ssl_configuration: (Updatable) The load balancer's SSL handling configuration details.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        pulumi.set(__self__, "health_checker", health_checker)
        pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        pulumi.set(__self__, "policy", policy)
        if lb_cookie_session_persistence_configuration is not None:
            pulumi.set(__self__, "lb_cookie_session_persistence_configuration", lb_cookie_session_persistence_configuration)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if session_persistence_configuration is not None:
            pulumi.set(__self__, "session_persistence_configuration", session_persistence_configuration)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)

    @property
    @pulumi.getter(name="healthChecker")
    def health_checker(self) -> pulumi.Input['BackendSetHealthCheckerArgs']:
        """
        (Updatable) The health check policy's configuration details.
        """
        return pulumi.get(self, "health_checker")

    @health_checker.setter
    def health_checker(self, value: pulumi.Input['BackendSetHealthCheckerArgs']):
        pulumi.set(self, "health_checker", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a backend set.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[str]:
        """
        (Updatable) The load balancer policy for the backend set. To get a list of available policies, use the [ListPolicies](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerPolicy/ListPolicies) operation.  Example: `LEAST_CONNECTIONS`
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="lbCookieSessionPersistenceConfiguration")
    def lb_cookie_session_persistence_configuration(self) -> Optional[pulumi.Input['BackendSetLbCookieSessionPersistenceConfigurationArgs']]:
        """
        (Updatable) The configuration details for implementing load balancer cookie session persistence (LB cookie stickiness).

        Session persistence enables the Load Balancing service to direct all requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).

        When you configure LB cookie stickiness, the load balancer inserts a cookie into the response. The parameters configured in the cookie enable session stickiness. This method is useful when you have applications and Web backend services that cannot generate their own cookies.

        Path route rules take precedence to determine the target backend server. The load balancer verifies that session stickiness is enabled for the backend server and that the cookie configuration (domain, path, and cookie hash) is valid for the target. The system ignores invalid cookies.

        To disable LB cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `LBCookieSessionPersistenceConfigurationDetails` object.

        Example: `LBCookieSessionPersistenceConfigurationDetails: null`

        **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "lb_cookie_session_persistence_configuration")

    @lb_cookie_session_persistence_configuration.setter
    def lb_cookie_session_persistence_configuration(self, value: Optional[pulumi.Input['BackendSetLbCookieSessionPersistenceConfigurationArgs']]):
        pulumi.set(self, "lb_cookie_session_persistence_configuration", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the backend set. It must be unique and it cannot be changed.

        Valid backend set names include only alphanumeric characters, dashes, and underscores. Backend set names cannot contain spaces. Avoid entering confidential information.

        Example: `example_backend_set`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="sessionPersistenceConfiguration")
    def session_persistence_configuration(self) -> Optional[pulumi.Input['BackendSetSessionPersistenceConfigurationArgs']]:
        """
        (Updatable) The configuration details for implementing session persistence based on a user-specified cookie name (application cookie stickiness).

        Session persistence enables the Load Balancing service to direct any number of requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).

        With application cookie stickiness, the load balancer enables session persistence only when the response from a backend application server includes a `Set-cookie` header with the user-specified cookie name.

        To disable application cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `SessionPersistenceConfigurationDetails` object.

        Example: `SessionPersistenceConfigurationDetails: null`

        **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "session_persistence_configuration")

    @session_persistence_configuration.setter
    def session_persistence_configuration(self, value: Optional[pulumi.Input['BackendSetSessionPersistenceConfigurationArgs']]):
        pulumi.set(self, "session_persistence_configuration", value)

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional[pulumi.Input['BackendSetSslConfigurationArgs']]:
        """
        (Updatable) The load balancer's SSL handling configuration details.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "ssl_configuration")

    @ssl_configuration.setter
    def ssl_configuration(self, value: Optional[pulumi.Input['BackendSetSslConfigurationArgs']]):
        pulumi.set(self, "ssl_configuration", value)


@pulumi.input_type
class _BackendSetState:
    def __init__(__self__, *,
                 backends: Optional[pulumi.Input[Sequence[pulumi.Input['BackendSetBackendArgs']]]] = None,
                 health_checker: Optional[pulumi.Input['BackendSetHealthCheckerArgs']] = None,
                 lb_cookie_session_persistence_configuration: Optional[pulumi.Input['BackendSetLbCookieSessionPersistenceConfigurationArgs']] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 session_persistence_configuration: Optional[pulumi.Input['BackendSetSessionPersistenceConfigurationArgs']] = None,
                 ssl_configuration: Optional[pulumi.Input['BackendSetSslConfigurationArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BackendSet resources.
        :param pulumi.Input['BackendSetHealthCheckerArgs'] health_checker: (Updatable) The health check policy's configuration details.
        :param pulumi.Input['BackendSetLbCookieSessionPersistenceConfigurationArgs'] lb_cookie_session_persistence_configuration: (Updatable) The configuration details for implementing load balancer cookie session persistence (LB cookie stickiness).
               
               Session persistence enables the Load Balancing service to direct all requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).
               
               When you configure LB cookie stickiness, the load balancer inserts a cookie into the response. The parameters configured in the cookie enable session stickiness. This method is useful when you have applications and Web backend services that cannot generate their own cookies.
               
               Path route rules take precedence to determine the target backend server. The load balancer verifies that session stickiness is enabled for the backend server and that the cookie configuration (domain, path, and cookie hash) is valid for the target. The system ignores invalid cookies.
               
               To disable LB cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `LBCookieSessionPersistenceConfigurationDetails` object.
               
               Example: `LBCookieSessionPersistenceConfigurationDetails: null`
               
               **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a backend set.
        :param pulumi.Input[str] name: A friendly name for the backend set. It must be unique and it cannot be changed.
               
               Valid backend set names include only alphanumeric characters, dashes, and underscores. Backend set names cannot contain spaces. Avoid entering confidential information.
               
               Example: `example_backend_set`
        :param pulumi.Input[str] policy: (Updatable) The load balancer policy for the backend set. To get a list of available policies, use the [ListPolicies](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerPolicy/ListPolicies) operation.  Example: `LEAST_CONNECTIONS`
        :param pulumi.Input['BackendSetSessionPersistenceConfigurationArgs'] session_persistence_configuration: (Updatable) The configuration details for implementing session persistence based on a user-specified cookie name (application cookie stickiness).
               
               Session persistence enables the Load Balancing service to direct any number of requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).
               
               With application cookie stickiness, the load balancer enables session persistence only when the response from a backend application server includes a `Set-cookie` header with the user-specified cookie name.
               
               To disable application cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `SessionPersistenceConfigurationDetails` object.
               
               Example: `SessionPersistenceConfigurationDetails: null`
               
               **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input['BackendSetSslConfigurationArgs'] ssl_configuration: (Updatable) The load balancer's SSL handling configuration details.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        if backends is not None:
            pulumi.set(__self__, "backends", backends)
        if health_checker is not None:
            pulumi.set(__self__, "health_checker", health_checker)
        if lb_cookie_session_persistence_configuration is not None:
            pulumi.set(__self__, "lb_cookie_session_persistence_configuration", lb_cookie_session_persistence_configuration)
        if load_balancer_id is not None:
            pulumi.set(__self__, "load_balancer_id", load_balancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)
        if session_persistence_configuration is not None:
            pulumi.set(__self__, "session_persistence_configuration", session_persistence_configuration)
        if ssl_configuration is not None:
            pulumi.set(__self__, "ssl_configuration", ssl_configuration)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def backends(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackendSetBackendArgs']]]]:
        return pulumi.get(self, "backends")

    @backends.setter
    def backends(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackendSetBackendArgs']]]]):
        pulumi.set(self, "backends", value)

    @property
    @pulumi.getter(name="healthChecker")
    def health_checker(self) -> Optional[pulumi.Input['BackendSetHealthCheckerArgs']]:
        """
        (Updatable) The health check policy's configuration details.
        """
        return pulumi.get(self, "health_checker")

    @health_checker.setter
    def health_checker(self, value: Optional[pulumi.Input['BackendSetHealthCheckerArgs']]):
        pulumi.set(self, "health_checker", value)

    @property
    @pulumi.getter(name="lbCookieSessionPersistenceConfiguration")
    def lb_cookie_session_persistence_configuration(self) -> Optional[pulumi.Input['BackendSetLbCookieSessionPersistenceConfigurationArgs']]:
        """
        (Updatable) The configuration details for implementing load balancer cookie session persistence (LB cookie stickiness).

        Session persistence enables the Load Balancing service to direct all requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).

        When you configure LB cookie stickiness, the load balancer inserts a cookie into the response. The parameters configured in the cookie enable session stickiness. This method is useful when you have applications and Web backend services that cannot generate their own cookies.

        Path route rules take precedence to determine the target backend server. The load balancer verifies that session stickiness is enabled for the backend server and that the cookie configuration (domain, path, and cookie hash) is valid for the target. The system ignores invalid cookies.

        To disable LB cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `LBCookieSessionPersistenceConfigurationDetails` object.

        Example: `LBCookieSessionPersistenceConfigurationDetails: null`

        **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "lb_cookie_session_persistence_configuration")

    @lb_cookie_session_persistence_configuration.setter
    def lb_cookie_session_persistence_configuration(self, value: Optional[pulumi.Input['BackendSetLbCookieSessionPersistenceConfigurationArgs']]):
        pulumi.set(self, "lb_cookie_session_persistence_configuration", value)

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a backend set.
        """
        return pulumi.get(self, "load_balancer_id")

    @load_balancer_id.setter
    def load_balancer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "load_balancer_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        A friendly name for the backend set. It must be unique and it cannot be changed.

        Valid backend set names include only alphanumeric characters, dashes, and underscores. Backend set names cannot contain spaces. Avoid entering confidential information.

        Example: `example_backend_set`
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The load balancer policy for the backend set. To get a list of available policies, use the [ListPolicies](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerPolicy/ListPolicies) operation.  Example: `LEAST_CONNECTIONS`
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)

    @property
    @pulumi.getter(name="sessionPersistenceConfiguration")
    def session_persistence_configuration(self) -> Optional[pulumi.Input['BackendSetSessionPersistenceConfigurationArgs']]:
        """
        (Updatable) The configuration details for implementing session persistence based on a user-specified cookie name (application cookie stickiness).

        Session persistence enables the Load Balancing service to direct any number of requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).

        With application cookie stickiness, the load balancer enables session persistence only when the response from a backend application server includes a `Set-cookie` header with the user-specified cookie name.

        To disable application cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `SessionPersistenceConfigurationDetails` object.

        Example: `SessionPersistenceConfigurationDetails: null`

        **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "session_persistence_configuration")

    @session_persistence_configuration.setter
    def session_persistence_configuration(self, value: Optional[pulumi.Input['BackendSetSessionPersistenceConfigurationArgs']]):
        pulumi.set(self, "session_persistence_configuration", value)

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> Optional[pulumi.Input['BackendSetSslConfigurationArgs']]:
        """
        (Updatable) The load balancer's SSL handling configuration details.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "ssl_configuration")

    @ssl_configuration.setter
    def ssl_configuration(self, value: Optional[pulumi.Input['BackendSetSslConfigurationArgs']]):
        pulumi.set(self, "ssl_configuration", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


class BackendSet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 health_checker: Optional[pulumi.Input[pulumi.InputType['BackendSetHealthCheckerArgs']]] = None,
                 lb_cookie_session_persistence_configuration: Optional[pulumi.Input[pulumi.InputType['BackendSetLbCookieSessionPersistenceConfigurationArgs']]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 session_persistence_configuration: Optional[pulumi.Input[pulumi.InputType['BackendSetSessionPersistenceConfigurationArgs']]] = None,
                 ssl_configuration: Optional[pulumi.Input[pulumi.InputType['BackendSetSslConfigurationArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Backend Set resource in Oracle Cloud Infrastructure Load Balancer service.

        Adds a backend set to a load balancer.

        ## Supported Aliases

        * `oci_load_balancer_backendset`

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_backend_set = oci.load_balancer.BackendSet("testBackendSet",
            health_checker=oci.load_balancer.BackendSetHealthCheckerArgs(
                protocol=var["backend_set_health_checker_protocol"],
                interval_ms=var["backend_set_health_checker_interval_ms"],
                is_force_plain_text=var["backend_set_health_checker_is_force_plain_text"],
                port=var["backend_set_health_checker_port"],
                response_body_regex=var["backend_set_health_checker_response_body_regex"],
                retries=var["backend_set_health_checker_retries"],
                return_code=var["backend_set_health_checker_return_code"],
                timeout_in_millis=var["backend_set_health_checker_timeout_in_millis"],
                url_path=var["backend_set_health_checker_url_path"],
            ),
            load_balancer_id=oci_load_balancer_load_balancer["test_load_balancer"]["id"],
            policy=var["backend_set_policy"],
            lb_cookie_session_persistence_configuration=oci.load_balancer.BackendSetLbCookieSessionPersistenceConfigurationArgs(
                cookie_name=var["backend_set_lb_cookie_session_persistence_configuration_cookie_name"],
                disable_fallback=var["backend_set_lb_cookie_session_persistence_configuration_disable_fallback"],
                domain=var["backend_set_lb_cookie_session_persistence_configuration_domain"],
                is_http_only=var["backend_set_lb_cookie_session_persistence_configuration_is_http_only"],
                is_secure=var["backend_set_lb_cookie_session_persistence_configuration_is_secure"],
                max_age_in_seconds=var["backend_set_lb_cookie_session_persistence_configuration_max_age_in_seconds"],
                path=var["backend_set_lb_cookie_session_persistence_configuration_path"],
            ),
            session_persistence_configuration=oci.load_balancer.BackendSetSessionPersistenceConfigurationArgs(
                cookie_name=var["backend_set_session_persistence_configuration_cookie_name"],
                disable_fallback=var["backend_set_session_persistence_configuration_disable_fallback"],
            ),
            ssl_configuration=oci.load_balancer.BackendSetSslConfigurationArgs(
                certificate_ids=var["backend_set_ssl_configuration_certificate_ids"],
                certificate_name=oci_load_balancer_certificate["test_certificate"]["name"],
                cipher_suite_name=var["backend_set_ssl_configuration_cipher_suite_name"],
                protocols=var["backend_set_ssl_configuration_protocols"],
                server_order_preference=var["backend_set_ssl_configuration_server_order_preference"],
                trusted_certificate_authority_ids=var["backend_set_ssl_configuration_trusted_certificate_authority_ids"],
                verify_depth=var["backend_set_ssl_configuration_verify_depth"],
                verify_peer_certificate=var["backend_set_ssl_configuration_verify_peer_certificate"],
            ))
        ```
        <!--End PulumiCodeChooser -->
        **Note:** The `sessionPersistenceConfiguration` (application cookie stickiness) and `lbCookieSessionPersistenceConfiguration`
              (LB cookie stickiness) attributes are mutually exclusive. To avoid returning an error, configure only one of these two
              attributes per backend set.

        ## Import

        BackendSets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LoadBalancer/backendSet:BackendSet test_backend_set "loadBalancers/{loadBalancerId}/backendSets/{backendSetName}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['BackendSetHealthCheckerArgs']] health_checker: (Updatable) The health check policy's configuration details.
        :param pulumi.Input[pulumi.InputType['BackendSetLbCookieSessionPersistenceConfigurationArgs']] lb_cookie_session_persistence_configuration: (Updatable) The configuration details for implementing load balancer cookie session persistence (LB cookie stickiness).
               
               Session persistence enables the Load Balancing service to direct all requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).
               
               When you configure LB cookie stickiness, the load balancer inserts a cookie into the response. The parameters configured in the cookie enable session stickiness. This method is useful when you have applications and Web backend services that cannot generate their own cookies.
               
               Path route rules take precedence to determine the target backend server. The load balancer verifies that session stickiness is enabled for the backend server and that the cookie configuration (domain, path, and cookie hash) is valid for the target. The system ignores invalid cookies.
               
               To disable LB cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `LBCookieSessionPersistenceConfigurationDetails` object.
               
               Example: `LBCookieSessionPersistenceConfigurationDetails: null`
               
               **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a backend set.
        :param pulumi.Input[str] name: A friendly name for the backend set. It must be unique and it cannot be changed.
               
               Valid backend set names include only alphanumeric characters, dashes, and underscores. Backend set names cannot contain spaces. Avoid entering confidential information.
               
               Example: `example_backend_set`
        :param pulumi.Input[str] policy: (Updatable) The load balancer policy for the backend set. To get a list of available policies, use the [ListPolicies](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerPolicy/ListPolicies) operation.  Example: `LEAST_CONNECTIONS`
        :param pulumi.Input[pulumi.InputType['BackendSetSessionPersistenceConfigurationArgs']] session_persistence_configuration: (Updatable) The configuration details for implementing session persistence based on a user-specified cookie name (application cookie stickiness).
               
               Session persistence enables the Load Balancing service to direct any number of requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).
               
               With application cookie stickiness, the load balancer enables session persistence only when the response from a backend application server includes a `Set-cookie` header with the user-specified cookie name.
               
               To disable application cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `SessionPersistenceConfigurationDetails` object.
               
               Example: `SessionPersistenceConfigurationDetails: null`
               
               **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[pulumi.InputType['BackendSetSslConfigurationArgs']] ssl_configuration: (Updatable) The load balancer's SSL handling configuration details.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackendSetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Backend Set resource in Oracle Cloud Infrastructure Load Balancer service.

        Adds a backend set to a load balancer.

        ## Supported Aliases

        * `oci_load_balancer_backendset`

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_backend_set = oci.load_balancer.BackendSet("testBackendSet",
            health_checker=oci.load_balancer.BackendSetHealthCheckerArgs(
                protocol=var["backend_set_health_checker_protocol"],
                interval_ms=var["backend_set_health_checker_interval_ms"],
                is_force_plain_text=var["backend_set_health_checker_is_force_plain_text"],
                port=var["backend_set_health_checker_port"],
                response_body_regex=var["backend_set_health_checker_response_body_regex"],
                retries=var["backend_set_health_checker_retries"],
                return_code=var["backend_set_health_checker_return_code"],
                timeout_in_millis=var["backend_set_health_checker_timeout_in_millis"],
                url_path=var["backend_set_health_checker_url_path"],
            ),
            load_balancer_id=oci_load_balancer_load_balancer["test_load_balancer"]["id"],
            policy=var["backend_set_policy"],
            lb_cookie_session_persistence_configuration=oci.load_balancer.BackendSetLbCookieSessionPersistenceConfigurationArgs(
                cookie_name=var["backend_set_lb_cookie_session_persistence_configuration_cookie_name"],
                disable_fallback=var["backend_set_lb_cookie_session_persistence_configuration_disable_fallback"],
                domain=var["backend_set_lb_cookie_session_persistence_configuration_domain"],
                is_http_only=var["backend_set_lb_cookie_session_persistence_configuration_is_http_only"],
                is_secure=var["backend_set_lb_cookie_session_persistence_configuration_is_secure"],
                max_age_in_seconds=var["backend_set_lb_cookie_session_persistence_configuration_max_age_in_seconds"],
                path=var["backend_set_lb_cookie_session_persistence_configuration_path"],
            ),
            session_persistence_configuration=oci.load_balancer.BackendSetSessionPersistenceConfigurationArgs(
                cookie_name=var["backend_set_session_persistence_configuration_cookie_name"],
                disable_fallback=var["backend_set_session_persistence_configuration_disable_fallback"],
            ),
            ssl_configuration=oci.load_balancer.BackendSetSslConfigurationArgs(
                certificate_ids=var["backend_set_ssl_configuration_certificate_ids"],
                certificate_name=oci_load_balancer_certificate["test_certificate"]["name"],
                cipher_suite_name=var["backend_set_ssl_configuration_cipher_suite_name"],
                protocols=var["backend_set_ssl_configuration_protocols"],
                server_order_preference=var["backend_set_ssl_configuration_server_order_preference"],
                trusted_certificate_authority_ids=var["backend_set_ssl_configuration_trusted_certificate_authority_ids"],
                verify_depth=var["backend_set_ssl_configuration_verify_depth"],
                verify_peer_certificate=var["backend_set_ssl_configuration_verify_peer_certificate"],
            ))
        ```
        <!--End PulumiCodeChooser -->
        **Note:** The `sessionPersistenceConfiguration` (application cookie stickiness) and `lbCookieSessionPersistenceConfiguration`
              (LB cookie stickiness) attributes are mutually exclusive. To avoid returning an error, configure only one of these two
              attributes per backend set.

        ## Import

        BackendSets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:LoadBalancer/backendSet:BackendSet test_backend_set "loadBalancers/{loadBalancerId}/backendSets/{backendSetName}"
        ```

        :param str resource_name: The name of the resource.
        :param BackendSetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackendSetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 health_checker: Optional[pulumi.Input[pulumi.InputType['BackendSetHealthCheckerArgs']]] = None,
                 lb_cookie_session_persistence_configuration: Optional[pulumi.Input[pulumi.InputType['BackendSetLbCookieSessionPersistenceConfigurationArgs']]] = None,
                 load_balancer_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 session_persistence_configuration: Optional[pulumi.Input[pulumi.InputType['BackendSetSessionPersistenceConfigurationArgs']]] = None,
                 ssl_configuration: Optional[pulumi.Input[pulumi.InputType['BackendSetSslConfigurationArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackendSetArgs.__new__(BackendSetArgs)

            if health_checker is None and not opts.urn:
                raise TypeError("Missing required property 'health_checker'")
            __props__.__dict__["health_checker"] = health_checker
            __props__.__dict__["lb_cookie_session_persistence_configuration"] = lb_cookie_session_persistence_configuration
            if load_balancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_id'")
            __props__.__dict__["load_balancer_id"] = load_balancer_id
            __props__.__dict__["name"] = name
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
            __props__.__dict__["session_persistence_configuration"] = session_persistence_configuration
            __props__.__dict__["ssl_configuration"] = ssl_configuration
            __props__.__dict__["backends"] = None
            __props__.__dict__["state"] = None
        super(BackendSet, __self__).__init__(
            'oci:LoadBalancer/backendSet:BackendSet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backends: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackendSetBackendArgs']]]]] = None,
            health_checker: Optional[pulumi.Input[pulumi.InputType['BackendSetHealthCheckerArgs']]] = None,
            lb_cookie_session_persistence_configuration: Optional[pulumi.Input[pulumi.InputType['BackendSetLbCookieSessionPersistenceConfigurationArgs']]] = None,
            load_balancer_id: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            policy: Optional[pulumi.Input[str]] = None,
            session_persistence_configuration: Optional[pulumi.Input[pulumi.InputType['BackendSetSessionPersistenceConfigurationArgs']]] = None,
            ssl_configuration: Optional[pulumi.Input[pulumi.InputType['BackendSetSslConfigurationArgs']]] = None,
            state: Optional[pulumi.Input[str]] = None) -> 'BackendSet':
        """
        Get an existing BackendSet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['BackendSetHealthCheckerArgs']] health_checker: (Updatable) The health check policy's configuration details.
        :param pulumi.Input[pulumi.InputType['BackendSetLbCookieSessionPersistenceConfigurationArgs']] lb_cookie_session_persistence_configuration: (Updatable) The configuration details for implementing load balancer cookie session persistence (LB cookie stickiness).
               
               Session persistence enables the Load Balancing service to direct all requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).
               
               When you configure LB cookie stickiness, the load balancer inserts a cookie into the response. The parameters configured in the cookie enable session stickiness. This method is useful when you have applications and Web backend services that cannot generate their own cookies.
               
               Path route rules take precedence to determine the target backend server. The load balancer verifies that session stickiness is enabled for the backend server and that the cookie configuration (domain, path, and cookie hash) is valid for the target. The system ignores invalid cookies.
               
               To disable LB cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `LBCookieSessionPersistenceConfigurationDetails` object.
               
               Example: `LBCookieSessionPersistenceConfigurationDetails: null`
               
               **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[str] load_balancer_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a backend set.
        :param pulumi.Input[str] name: A friendly name for the backend set. It must be unique and it cannot be changed.
               
               Valid backend set names include only alphanumeric characters, dashes, and underscores. Backend set names cannot contain spaces. Avoid entering confidential information.
               
               Example: `example_backend_set`
        :param pulumi.Input[str] policy: (Updatable) The load balancer policy for the backend set. To get a list of available policies, use the [ListPolicies](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerPolicy/ListPolicies) operation.  Example: `LEAST_CONNECTIONS`
        :param pulumi.Input[pulumi.InputType['BackendSetSessionPersistenceConfigurationArgs']] session_persistence_configuration: (Updatable) The configuration details for implementing session persistence based on a user-specified cookie name (application cookie stickiness).
               
               Session persistence enables the Load Balancing service to direct any number of requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).
               
               With application cookie stickiness, the load balancer enables session persistence only when the response from a backend application server includes a `Set-cookie` header with the user-specified cookie name.
               
               To disable application cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `SessionPersistenceConfigurationDetails` object.
               
               Example: `SessionPersistenceConfigurationDetails: null`
               
               **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        :param pulumi.Input[pulumi.InputType['BackendSetSslConfigurationArgs']] ssl_configuration: (Updatable) The load balancer's SSL handling configuration details.
               
               **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackendSetState.__new__(_BackendSetState)

        __props__.__dict__["backends"] = backends
        __props__.__dict__["health_checker"] = health_checker
        __props__.__dict__["lb_cookie_session_persistence_configuration"] = lb_cookie_session_persistence_configuration
        __props__.__dict__["load_balancer_id"] = load_balancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["policy"] = policy
        __props__.__dict__["session_persistence_configuration"] = session_persistence_configuration
        __props__.__dict__["ssl_configuration"] = ssl_configuration
        __props__.__dict__["state"] = state
        return BackendSet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backends(self) -> pulumi.Output[Sequence['outputs.BackendSetBackend']]:
        return pulumi.get(self, "backends")

    @property
    @pulumi.getter(name="healthChecker")
    def health_checker(self) -> pulumi.Output['outputs.BackendSetHealthChecker']:
        """
        (Updatable) The health check policy's configuration details.
        """
        return pulumi.get(self, "health_checker")

    @property
    @pulumi.getter(name="lbCookieSessionPersistenceConfiguration")
    def lb_cookie_session_persistence_configuration(self) -> pulumi.Output['outputs.BackendSetLbCookieSessionPersistenceConfiguration']:
        """
        (Updatable) The configuration details for implementing load balancer cookie session persistence (LB cookie stickiness).

        Session persistence enables the Load Balancing service to direct all requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).

        When you configure LB cookie stickiness, the load balancer inserts a cookie into the response. The parameters configured in the cookie enable session stickiness. This method is useful when you have applications and Web backend services that cannot generate their own cookies.

        Path route rules take precedence to determine the target backend server. The load balancer verifies that session stickiness is enabled for the backend server and that the cookie configuration (domain, path, and cookie hash) is valid for the target. The system ignores invalid cookies.

        To disable LB cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `LBCookieSessionPersistenceConfigurationDetails` object.

        Example: `LBCookieSessionPersistenceConfigurationDetails: null`

        **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "lb_cookie_session_persistence_configuration")

    @property
    @pulumi.getter(name="loadBalancerId")
    def load_balancer_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the load balancer on which to add a backend set.
        """
        return pulumi.get(self, "load_balancer_id")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A friendly name for the backend set. It must be unique and it cannot be changed.

        Valid backend set names include only alphanumeric characters, dashes, and underscores. Backend set names cannot contain spaces. Avoid entering confidential information.

        Example: `example_backend_set`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[str]:
        """
        (Updatable) The load balancer policy for the backend set. To get a list of available policies, use the [ListPolicies](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/LoadBalancerPolicy/ListPolicies) operation.  Example: `LEAST_CONNECTIONS`
        """
        return pulumi.get(self, "policy")

    @property
    @pulumi.getter(name="sessionPersistenceConfiguration")
    def session_persistence_configuration(self) -> pulumi.Output['outputs.BackendSetSessionPersistenceConfiguration']:
        """
        (Updatable) The configuration details for implementing session persistence based on a user-specified cookie name (application cookie stickiness).

        Session persistence enables the Load Balancing service to direct any number of requests that originate from a single logical client to a single backend web server. For more information, see [Session Persistence](https://docs.cloud.oracle.com/iaas/Content/Balance/Reference/sessionpersistence.htm).

        With application cookie stickiness, the load balancer enables session persistence only when the response from a backend application server includes a `Set-cookie` header with the user-specified cookie name.

        To disable application cookie stickiness on a running load balancer, use the [UpdateBackendSet](https://docs.cloud.oracle.com/iaas/api/#/en/loadbalancer/20170115/BackendSet/UpdateBackendSet) operation and specify `null` for the `SessionPersistenceConfigurationDetails` object.

        Example: `SessionPersistenceConfigurationDetails: null`

        **Note:** `SessionPersistenceConfigurationDetails` (application cookie stickiness) and `LBCookieSessionPersistenceConfigurationDetails` (LB cookie stickiness) are mutually exclusive. An error results if you try to enable both types of session persistence.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "session_persistence_configuration")

    @property
    @pulumi.getter(name="sslConfiguration")
    def ssl_configuration(self) -> pulumi.Output[Optional['outputs.BackendSetSslConfiguration']]:
        """
        (Updatable) The load balancer's SSL handling configuration details.

        **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
        """
        return pulumi.get(self, "ssl_configuration")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        return pulumi.get(self, "state")

