# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['NamespaceArgs', 'Namespace']

@pulumi.input_type
class NamespaceArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 is_onboarded: pulumi.Input[bool],
                 namespace: pulumi.Input[str]):
        """
        The set of arguments for constructing a Namespace resource.
        :param pulumi.Input[str] compartment_id: The OCID of the root compartment i.e. OCID of the tenancy.
        :param pulumi.Input[bool] is_onboarded: Use `true` if tenancy is to be onboarded to logging analytics and `false` if tenancy is to be offboarded
        :param pulumi.Input[str] namespace: The Log Analytics namespace used for the request.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "is_onboarded", is_onboarded)
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the root compartment i.e. OCID of the tenancy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isOnboarded")
    def is_onboarded(self) -> pulumi.Input[bool]:
        """
        Use `true` if tenancy is to be onboarded to logging analytics and `false` if tenancy is to be offboarded
        """
        return pulumi.get(self, "is_onboarded")

    @is_onboarded.setter
    def is_onboarded(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_onboarded", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The Log Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)


@pulumi.input_type
class _NamespaceState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_onboarded: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Namespace resources.
        :param pulumi.Input[str] compartment_id: The OCID of the root compartment i.e. OCID of the tenancy.
        :param pulumi.Input[bool] is_onboarded: Use `true` if tenancy is to be onboarded to logging analytics and `false` if tenancy is to be offboarded
        :param pulumi.Input[str] namespace: The Log Analytics namespace used for the request.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if is_onboarded is not None:
            pulumi.set(__self__, "is_onboarded", is_onboarded)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the root compartment i.e. OCID of the tenancy.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isOnboarded")
    def is_onboarded(self) -> Optional[pulumi.Input[bool]]:
        """
        Use `true` if tenancy is to be onboarded to logging analytics and `false` if tenancy is to be offboarded
        """
        return pulumi.get(self, "is_onboarded")

    @is_onboarded.setter
    def is_onboarded(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_onboarded", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The Log Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)


class Namespace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_onboarded: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Namespace resource in Oracle Cloud Infrastructure Log Analytics service.

        Onboards a tenancy with Log Analytics or Offboards a tenancy from Log Analytics functionality.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_namespace = oci.log_analytics.Namespace("testNamespace",
            compartment_id=var["compartment_id"],
            is_onboarded=var["is_onboarded"],
            namespace=var["namespace_namespace"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Namespace can be imported using the `namespace`, e.g.

        ```sh
        $ pulumi import oci:LogAnalytics/namespace:Namespace test_namespace "namespace"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the root compartment i.e. OCID of the tenancy.
        :param pulumi.Input[bool] is_onboarded: Use `true` if tenancy is to be onboarded to logging analytics and `false` if tenancy is to be offboarded
        :param pulumi.Input[str] namespace: The Log Analytics namespace used for the request.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NamespaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Namespace resource in Oracle Cloud Infrastructure Log Analytics service.

        Onboards a tenancy with Log Analytics or Offboards a tenancy from Log Analytics functionality.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_namespace = oci.log_analytics.Namespace("testNamespace",
            compartment_id=var["compartment_id"],
            is_onboarded=var["is_onboarded"],
            namespace=var["namespace_namespace"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        Namespace can be imported using the `namespace`, e.g.

        ```sh
        $ pulumi import oci:LogAnalytics/namespace:Namespace test_namespace "namespace"
        ```

        :param str resource_name: The name of the resource.
        :param NamespaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NamespaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 is_onboarded: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NamespaceArgs.__new__(NamespaceArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            if is_onboarded is None and not opts.urn:
                raise TypeError("Missing required property 'is_onboarded'")
            __props__.__dict__["is_onboarded"] = is_onboarded
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
        super(Namespace, __self__).__init__(
            'oci:LogAnalytics/namespace:Namespace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            is_onboarded: Optional[pulumi.Input[bool]] = None,
            namespace: Optional[pulumi.Input[str]] = None) -> 'Namespace':
        """
        Get an existing Namespace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the root compartment i.e. OCID of the tenancy.
        :param pulumi.Input[bool] is_onboarded: Use `true` if tenancy is to be onboarded to logging analytics and `false` if tenancy is to be offboarded
        :param pulumi.Input[str] namespace: The Log Analytics namespace used for the request.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NamespaceState.__new__(_NamespaceState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["is_onboarded"] = is_onboarded
        __props__.__dict__["namespace"] = namespace
        return Namespace(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the root compartment i.e. OCID of the tenancy.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="isOnboarded")
    def is_onboarded(self) -> pulumi.Output[bool]:
        """
        Use `true` if tenancy is to be onboarded to logging analytics and `false` if tenancy is to be offboarded
        """
        return pulumi.get(self, "is_onboarded")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The Log Analytics namespace used for the request.
        """
        return pulumi.get(self, "namespace")

