# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetManagementAgentAvailableHistoriesResult',
    'AwaitableGetManagementAgentAvailableHistoriesResult',
    'get_management_agent_available_histories',
    'get_management_agent_available_histories_output',
]

@pulumi.output_type
class GetManagementAgentAvailableHistoriesResult:
    """
    A collection of values returned by getManagementAgentAvailableHistories.
    """
    def __init__(__self__, availability_histories=None, filters=None, id=None, management_agent_id=None, time_availability_status_ended_greater_than=None, time_availability_status_started_less_than=None):
        if availability_histories and not isinstance(availability_histories, list):
            raise TypeError("Expected argument 'availability_histories' to be a list")
        pulumi.set(__self__, "availability_histories", availability_histories)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if management_agent_id and not isinstance(management_agent_id, str):
            raise TypeError("Expected argument 'management_agent_id' to be a str")
        pulumi.set(__self__, "management_agent_id", management_agent_id)
        if time_availability_status_ended_greater_than and not isinstance(time_availability_status_ended_greater_than, str):
            raise TypeError("Expected argument 'time_availability_status_ended_greater_than' to be a str")
        pulumi.set(__self__, "time_availability_status_ended_greater_than", time_availability_status_ended_greater_than)
        if time_availability_status_started_less_than and not isinstance(time_availability_status_started_less_than, str):
            raise TypeError("Expected argument 'time_availability_status_started_less_than' to be a str")
        pulumi.set(__self__, "time_availability_status_started_less_than", time_availability_status_started_less_than)

    @property
    @pulumi.getter(name="availabilityHistories")
    def availability_histories(self) -> Sequence['outputs.GetManagementAgentAvailableHistoriesAvailabilityHistoryResult']:
        """
        The list of availability_histories.
        """
        return pulumi.get(self, "availability_histories")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetManagementAgentAvailableHistoriesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> str:
        """
        agent identifier
        """
        return pulumi.get(self, "management_agent_id")

    @property
    @pulumi.getter(name="timeAvailabilityStatusEndedGreaterThan")
    def time_availability_status_ended_greater_than(self) -> Optional[str]:
        return pulumi.get(self, "time_availability_status_ended_greater_than")

    @property
    @pulumi.getter(name="timeAvailabilityStatusStartedLessThan")
    def time_availability_status_started_less_than(self) -> Optional[str]:
        return pulumi.get(self, "time_availability_status_started_less_than")


class AwaitableGetManagementAgentAvailableHistoriesResult(GetManagementAgentAvailableHistoriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetManagementAgentAvailableHistoriesResult(
            availability_histories=self.availability_histories,
            filters=self.filters,
            id=self.id,
            management_agent_id=self.management_agent_id,
            time_availability_status_ended_greater_than=self.time_availability_status_ended_greater_than,
            time_availability_status_started_less_than=self.time_availability_status_started_less_than)


def get_management_agent_available_histories(filters: Optional[Sequence[pulumi.InputType['GetManagementAgentAvailableHistoriesFilterArgs']]] = None,
                                             management_agent_id: Optional[str] = None,
                                             time_availability_status_ended_greater_than: Optional[str] = None,
                                             time_availability_status_started_less_than: Optional[str] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetManagementAgentAvailableHistoriesResult:
    """
    This data source provides the list of Management Agent Available Histories in Oracle Cloud Infrastructure Management Agent service.

    Lists the availability history records of Management Agent

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_available_histories = oci.ManagementAgent.get_management_agent_available_histories(management_agent_id=oci_management_agent_management_agent["test_management_agent"]["id"],
        time_availability_status_ended_greater_than=var["management_agent_available_history_time_availability_status_ended_greater_than"],
        time_availability_status_started_less_than=var["management_agent_available_history_time_availability_status_started_less_than"])
    ```
    <!--End PulumiCodeChooser -->


    :param str management_agent_id: Unique Management Agent identifier
    :param str time_availability_status_ended_greater_than: Filter to limit the availability history results to that of time after the input time including the boundary record. Defaulted to current date minus one year. The date and time to be given as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 5.6.
    :param str time_availability_status_started_less_than: Filter to limit the availability history results to that of time before the input time including the boundary record Defaulted to current date. The date and time to be given as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 5.6.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['managementAgentId'] = management_agent_id
    __args__['timeAvailabilityStatusEndedGreaterThan'] = time_availability_status_ended_greater_than
    __args__['timeAvailabilityStatusStartedLessThan'] = time_availability_status_started_less_than
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ManagementAgent/getManagementAgentAvailableHistories:getManagementAgentAvailableHistories', __args__, opts=opts, typ=GetManagementAgentAvailableHistoriesResult).value

    return AwaitableGetManagementAgentAvailableHistoriesResult(
        availability_histories=pulumi.get(__ret__, 'availability_histories'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        management_agent_id=pulumi.get(__ret__, 'management_agent_id'),
        time_availability_status_ended_greater_than=pulumi.get(__ret__, 'time_availability_status_ended_greater_than'),
        time_availability_status_started_less_than=pulumi.get(__ret__, 'time_availability_status_started_less_than'))


@_utilities.lift_output_func(get_management_agent_available_histories)
def get_management_agent_available_histories_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetManagementAgentAvailableHistoriesFilterArgs']]]]] = None,
                                                    management_agent_id: Optional[pulumi.Input[str]] = None,
                                                    time_availability_status_ended_greater_than: Optional[pulumi.Input[Optional[str]]] = None,
                                                    time_availability_status_started_less_than: Optional[pulumi.Input[Optional[str]]] = None,
                                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetManagementAgentAvailableHistoriesResult]:
    """
    This data source provides the list of Management Agent Available Histories in Oracle Cloud Infrastructure Management Agent service.

    Lists the availability history records of Management Agent

    ## Example Usage

    <!--Start PulumiCodeChooser -->
    ```python
    import pulumi
    import pulumi_oci as oci

    test_management_agent_available_histories = oci.ManagementAgent.get_management_agent_available_histories(management_agent_id=oci_management_agent_management_agent["test_management_agent"]["id"],
        time_availability_status_ended_greater_than=var["management_agent_available_history_time_availability_status_ended_greater_than"],
        time_availability_status_started_less_than=var["management_agent_available_history_time_availability_status_started_less_than"])
    ```
    <!--End PulumiCodeChooser -->


    :param str management_agent_id: Unique Management Agent identifier
    :param str time_availability_status_ended_greater_than: Filter to limit the availability history results to that of time after the input time including the boundary record. Defaulted to current date minus one year. The date and time to be given as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 5.6.
    :param str time_availability_status_started_less_than: Filter to limit the availability history results to that of time before the input time including the boundary record Defaulted to current date. The date and time to be given as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339), section 5.6.
    """
    ...
