# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['ReplicationPolicyArgs', 'ReplicationPolicy']

@pulumi.input_type
class ReplicationPolicyArgs:
    def __init__(__self__, *,
                 bucket: pulumi.Input[str],
                 destination_bucket_name: pulumi.Input[str],
                 destination_region_name: pulumi.Input[str],
                 namespace: pulumi.Input[str],
                 delete_object_in_destination_bucket: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ReplicationPolicy resource.
        :param pulumi.Input[str] bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        :param pulumi.Input[str] destination_bucket_name: The bucket to replicate to in the destination region. Replication policy creation does not automatically create a destination bucket. Create the destination bucket before creating the policy.
        :param pulumi.Input[str] destination_region_name: The destination region to replicate to, for example "us-ashburn-1".
        :param pulumi.Input[str] namespace: The Object Storage namespace used for the request.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] name: The name of the policy. Avoid entering confidential information.
        """
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "destination_bucket_name", destination_bucket_name)
        pulumi.set(__self__, "destination_region_name", destination_region_name)
        pulumi.set(__self__, "namespace", namespace)
        if delete_object_in_destination_bucket is not None:
            warnings.warn("""The 'delete_object_in_destination_bucket' field has been deprecated. It is no longer supported.""", DeprecationWarning)
            pulumi.log.warn("""delete_object_in_destination_bucket is deprecated: The 'delete_object_in_destination_bucket' field has been deprecated. It is no longer supported.""")
        if delete_object_in_destination_bucket is not None:
            pulumi.set(__self__, "delete_object_in_destination_bucket", delete_object_in_destination_bucket)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Input[str]:
        """
        The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="destinationBucketName")
    def destination_bucket_name(self) -> pulumi.Input[str]:
        """
        The bucket to replicate to in the destination region. Replication policy creation does not automatically create a destination bucket. Create the destination bucket before creating the policy.
        """
        return pulumi.get(self, "destination_bucket_name")

    @destination_bucket_name.setter
    def destination_bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_bucket_name", value)

    @property
    @pulumi.getter(name="destinationRegionName")
    def destination_region_name(self) -> pulumi.Input[str]:
        """
        The destination region to replicate to, for example "us-ashburn-1".
        """
        return pulumi.get(self, "destination_region_name")

    @destination_region_name.setter
    def destination_region_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "destination_region_name", value)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Input[str]:
        """
        The Object Storage namespace used for the request.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: pulumi.Input[str]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="deleteObjectInDestinationBucket")
    def delete_object_in_destination_bucket(self) -> Optional[pulumi.Input[str]]:
        warnings.warn("""The 'delete_object_in_destination_bucket' field has been deprecated. It is no longer supported.""", DeprecationWarning)
        pulumi.log.warn("""delete_object_in_destination_bucket is deprecated: The 'delete_object_in_destination_bucket' field has been deprecated. It is no longer supported.""")

        return pulumi.get(self, "delete_object_in_destination_bucket")

    @delete_object_in_destination_bucket.setter
    def delete_object_in_destination_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_object_in_destination_bucket", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _ReplicationPolicyState:
    def __init__(__self__, *,
                 bucket: Optional[pulumi.Input[str]] = None,
                 delete_object_in_destination_bucket: Optional[pulumi.Input[str]] = None,
                 destination_bucket_name: Optional[pulumi.Input[str]] = None,
                 destination_region_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 status_message: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_last_sync: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ReplicationPolicy resources.
        :param pulumi.Input[str] bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        :param pulumi.Input[str] destination_bucket_name: The bucket to replicate to in the destination region. Replication policy creation does not automatically create a destination bucket. Create the destination bucket before creating the policy.
        :param pulumi.Input[str] destination_region_name: The destination region to replicate to, for example "us-ashburn-1".
        :param pulumi.Input[str] name: The name of the policy. Avoid entering confidential information.
        :param pulumi.Input[str] namespace: The Object Storage namespace used for the request.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] status: The replication status of the policy. If the status is CLIENT_ERROR, once the user fixes the issue described in the status message, the status will become ACTIVE.
        :param pulumi.Input[str] status_message: A human-readable description of the status.
        :param pulumi.Input[str] time_created: The date when the replication policy was created as per [RFC 3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_last_sync: Changes made to the source bucket before this time has been replicated.
        """
        if bucket is not None:
            pulumi.set(__self__, "bucket", bucket)
        if delete_object_in_destination_bucket is not None:
            warnings.warn("""The 'delete_object_in_destination_bucket' field has been deprecated. It is no longer supported.""", DeprecationWarning)
            pulumi.log.warn("""delete_object_in_destination_bucket is deprecated: The 'delete_object_in_destination_bucket' field has been deprecated. It is no longer supported.""")
        if delete_object_in_destination_bucket is not None:
            pulumi.set(__self__, "delete_object_in_destination_bucket", delete_object_in_destination_bucket)
        if destination_bucket_name is not None:
            pulumi.set(__self__, "destination_bucket_name", destination_bucket_name)
        if destination_region_name is not None:
            pulumi.set(__self__, "destination_region_name", destination_region_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if status_message is not None:
            pulumi.set(__self__, "status_message", status_message)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_last_sync is not None:
            pulumi.set(__self__, "time_last_sync", time_last_sync)

    @property
    @pulumi.getter
    def bucket(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        """
        return pulumi.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket", value)

    @property
    @pulumi.getter(name="deleteObjectInDestinationBucket")
    def delete_object_in_destination_bucket(self) -> Optional[pulumi.Input[str]]:
        warnings.warn("""The 'delete_object_in_destination_bucket' field has been deprecated. It is no longer supported.""", DeprecationWarning)
        pulumi.log.warn("""delete_object_in_destination_bucket is deprecated: The 'delete_object_in_destination_bucket' field has been deprecated. It is no longer supported.""")

        return pulumi.get(self, "delete_object_in_destination_bucket")

    @delete_object_in_destination_bucket.setter
    def delete_object_in_destination_bucket(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_object_in_destination_bucket", value)

    @property
    @pulumi.getter(name="destinationBucketName")
    def destination_bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        The bucket to replicate to in the destination region. Replication policy creation does not automatically create a destination bucket. Create the destination bucket before creating the policy.
        """
        return pulumi.get(self, "destination_bucket_name")

    @destination_bucket_name.setter
    def destination_bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_bucket_name", value)

    @property
    @pulumi.getter(name="destinationRegionName")
    def destination_region_name(self) -> Optional[pulumi.Input[str]]:
        """
        The destination region to replicate to, for example "us-ashburn-1".
        """
        return pulumi.get(self, "destination_region_name")

    @destination_region_name.setter
    def destination_region_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "destination_region_name", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the policy. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The Object Storage namespace used for the request.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The replication status of the policy. If the status is CLIENT_ERROR, once the user fixes the issue described in the status message, the status will become ACTIVE.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> Optional[pulumi.Input[str]]:
        """
        A human-readable description of the status.
        """
        return pulumi.get(self, "status_message")

    @status_message.setter
    def status_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status_message", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date when the replication policy was created as per [RFC 3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeLastSync")
    def time_last_sync(self) -> Optional[pulumi.Input[str]]:
        """
        Changes made to the source bucket before this time has been replicated.
        """
        return pulumi.get(self, "time_last_sync")

    @time_last_sync.setter
    def time_last_sync(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_last_sync", value)


class ReplicationPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 delete_object_in_destination_bucket: Optional[pulumi.Input[str]] = None,
                 destination_bucket_name: Optional[pulumi.Input[str]] = None,
                 destination_region_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Replication Policy resource in Oracle Cloud Infrastructure Object Storage service.

        Creates a replication policy for the specified bucket.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_replication_policy = oci.object_storage.ReplicationPolicy("testReplicationPolicy",
            bucket=var["replication_policy_bucket"],
            destination_bucket_name=oci_objectstorage_bucket["test_bucket"]["name"],
            destination_region_name=oci_identity_region["test_region"]["name"],
            namespace=var["replication_policy_namespace"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        ReplicationPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ObjectStorage/replicationPolicy:ReplicationPolicy test_replication_policy "n/{namespaceName}/b/{bucketName}/replicationPolicies/{replicationId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        :param pulumi.Input[str] destination_bucket_name: The bucket to replicate to in the destination region. Replication policy creation does not automatically create a destination bucket. Create the destination bucket before creating the policy.
        :param pulumi.Input[str] destination_region_name: The destination region to replicate to, for example "us-ashburn-1".
        :param pulumi.Input[str] name: The name of the policy. Avoid entering confidential information.
        :param pulumi.Input[str] namespace: The Object Storage namespace used for the request.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ReplicationPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Replication Policy resource in Oracle Cloud Infrastructure Object Storage service.

        Creates a replication policy for the specified bucket.

        ## Example Usage

        <!--Start PulumiCodeChooser -->
        ```python
        import pulumi
        import pulumi_oci as oci

        test_replication_policy = oci.object_storage.ReplicationPolicy("testReplicationPolicy",
            bucket=var["replication_policy_bucket"],
            destination_bucket_name=oci_objectstorage_bucket["test_bucket"]["name"],
            destination_region_name=oci_identity_region["test_region"]["name"],
            namespace=var["replication_policy_namespace"])
        ```
        <!--End PulumiCodeChooser -->

        ## Import

        ReplicationPolicies can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:ObjectStorage/replicationPolicy:ReplicationPolicy test_replication_policy "n/{namespaceName}/b/{bucketName}/replicationPolicies/{replicationId}"
        ```

        :param str resource_name: The name of the resource.
        :param ReplicationPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ReplicationPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket: Optional[pulumi.Input[str]] = None,
                 delete_object_in_destination_bucket: Optional[pulumi.Input[str]] = None,
                 destination_bucket_name: Optional[pulumi.Input[str]] = None,
                 destination_region_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ReplicationPolicyArgs.__new__(ReplicationPolicyArgs)

            if bucket is None and not opts.urn:
                raise TypeError("Missing required property 'bucket'")
            __props__.__dict__["bucket"] = bucket
            __props__.__dict__["delete_object_in_destination_bucket"] = delete_object_in_destination_bucket
            if destination_bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'destination_bucket_name'")
            __props__.__dict__["destination_bucket_name"] = destination_bucket_name
            if destination_region_name is None and not opts.urn:
                raise TypeError("Missing required property 'destination_region_name'")
            __props__.__dict__["destination_region_name"] = destination_region_name
            __props__.__dict__["name"] = name
            if namespace is None and not opts.urn:
                raise TypeError("Missing required property 'namespace'")
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["status"] = None
            __props__.__dict__["status_message"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_last_sync"] = None
        super(ReplicationPolicy, __self__).__init__(
            'oci:ObjectStorage/replicationPolicy:ReplicationPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket: Optional[pulumi.Input[str]] = None,
            delete_object_in_destination_bucket: Optional[pulumi.Input[str]] = None,
            destination_bucket_name: Optional[pulumi.Input[str]] = None,
            destination_region_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            status_message: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_last_sync: Optional[pulumi.Input[str]] = None) -> 'ReplicationPolicy':
        """
        Get an existing ReplicationPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket: The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        :param pulumi.Input[str] destination_bucket_name: The bucket to replicate to in the destination region. Replication policy creation does not automatically create a destination bucket. Create the destination bucket before creating the policy.
        :param pulumi.Input[str] destination_region_name: The destination region to replicate to, for example "us-ashburn-1".
        :param pulumi.Input[str] name: The name of the policy. Avoid entering confidential information.
        :param pulumi.Input[str] namespace: The Object Storage namespace used for the request.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] status: The replication status of the policy. If the status is CLIENT_ERROR, once the user fixes the issue described in the status message, the status will become ACTIVE.
        :param pulumi.Input[str] status_message: A human-readable description of the status.
        :param pulumi.Input[str] time_created: The date when the replication policy was created as per [RFC 3339](https://tools.ietf.org/html/rfc3339).
        :param pulumi.Input[str] time_last_sync: Changes made to the source bucket before this time has been replicated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ReplicationPolicyState.__new__(_ReplicationPolicyState)

        __props__.__dict__["bucket"] = bucket
        __props__.__dict__["delete_object_in_destination_bucket"] = delete_object_in_destination_bucket
        __props__.__dict__["destination_bucket_name"] = destination_bucket_name
        __props__.__dict__["destination_region_name"] = destination_region_name
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["status"] = status
        __props__.__dict__["status_message"] = status_message
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_last_sync"] = time_last_sync
        return ReplicationPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bucket(self) -> pulumi.Output[str]:
        """
        The name of the bucket. Avoid entering confidential information. Example: `my-new-bucket1`
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="deleteObjectInDestinationBucket")
    def delete_object_in_destination_bucket(self) -> pulumi.Output[Optional[str]]:
        warnings.warn("""The 'delete_object_in_destination_bucket' field has been deprecated. It is no longer supported.""", DeprecationWarning)
        pulumi.log.warn("""delete_object_in_destination_bucket is deprecated: The 'delete_object_in_destination_bucket' field has been deprecated. It is no longer supported.""")

        return pulumi.get(self, "delete_object_in_destination_bucket")

    @property
    @pulumi.getter(name="destinationBucketName")
    def destination_bucket_name(self) -> pulumi.Output[str]:
        """
        The bucket to replicate to in the destination region. Replication policy creation does not automatically create a destination bucket. Create the destination bucket before creating the policy.
        """
        return pulumi.get(self, "destination_bucket_name")

    @property
    @pulumi.getter(name="destinationRegionName")
    def destination_region_name(self) -> pulumi.Output[str]:
        """
        The destination region to replicate to, for example "us-ashburn-1".
        """
        return pulumi.get(self, "destination_region_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the policy. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[str]:
        """
        The Object Storage namespace used for the request.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The replication status of the policy. If the status is CLIENT_ERROR, once the user fixes the issue described in the status message, the status will become ACTIVE.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusMessage")
    def status_message(self) -> pulumi.Output[str]:
        """
        A human-readable description of the status.
        """
        return pulumi.get(self, "status_message")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date when the replication policy was created as per [RFC 3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastSync")
    def time_last_sync(self) -> pulumi.Output[str]:
        """
        Changes made to the source bucket before this time has been replicated.
        """
        return pulumi.get(self, "time_last_sync")

