#!~/.wine/drive_c/Python25/python.exe
# -*- coding: utf-8 -*-

# Copyright (c) 2009-2014, Mario Vilas
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#     * Redistributions of source code must retain the above copyright notice,
#       this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice,this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of the copyright holder nor the names of its
#       contributors may be used to endorse or promote products derived from
#       this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
# INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
# CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
# ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

# $Id: 19_show_window_tree.py 1299 2013-12-20 09:30:55Z qvasimodo $

from winappdbg import System, HexDump


def show_window_tree( window, indent = 0 ):

    # Show this window's handle and caption.
    # Use some ASCII art to show the layout. :)
    handle  = HexDump.integer( window.get_handle() )
    caption = window.get_text()
    line = ""
    if indent > 0:
        print "|   " * indent
        line = "|   " * (indent - 1) + "|---"
    else:
        print "|"
    if caption is not None:
        line += handle + ": " + caption
    else:
        line += handle
    print line

    # Recursively show the child windows.
    for child in window.get_children():
        show_window_tree( child, indent + 1 )


def main():

    # Create a system snaphot.
    system = System()

    # Get the Desktop window.
    root = system.get_desktop_window()

    # Now show the window tree.
    show_window_tree(root)

    # You can also ge the tree as a Python dictionary:
    # tree = root.get_tree()
    # print tree

if __name__ == '__main__':
    main()
