/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc;

import com.datapps.linkoopdb.jdbc.ClientConnection;
import com.datapps.linkoopdb.jdbc.LdbSqlException;
import com.datapps.linkoopdb.jdbc.lib.DataOutputStream;
import com.datapps.linkoopdb.jdbc.lib.LdbSqlByteArrayOutputStream;
import com.datapps.linkoopdb.jdbc.result.Result;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class ClientConnectionHTTP
extends ClientConnection {
    static final String ENCODING = "ISO-8859-1";
    static final int IDLENGTH = 12;
    private HttpURLConnection httpConnection = null;

    public ClientConnectionHTTP(String host, int port, String path, String database, boolean isTLS, boolean isTLSWrapper, String user, String password, int timeZoneSeconds, int queryIterator) {
        super(host, port, path, database, isTLS, isTLSWrapper, user, password, timeZoneSeconds, queryIterator);
    }

    public ClientConnectionHTTP(ClientConnectionHTTP other) {
        super(other);
    }

    @Override
    protected void initConnection(String host, int port, boolean isTLS) {
    }

    @Override
    protected void openConnection(String host, int port, boolean isTLS) {
        try {
            URL url = null;
            String s = "";
            if (!this.path.endsWith("/")) {
                s = "/";
            }
            url = isTLS ? new URL("https://" + host + ":" + port + this.path + s + this.database) : new URL("http://" + host + ":" + port + this.path + s + this.database);
            this.httpConnection = (HttpURLConnection)url.openConnection();
            this.httpConnection.setDefaultUseCaches(false);
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    @Override
    protected void closeConnection() {
    }

    @Override
    public synchronized Result execute(Result r) {
        this.openConnection(this.host, this.port, this.isTLS);
        Result result = super.execute(r);
        this.closeConnection();
        return result;
    }

    @Override
    public Result cancel(Result result) {
        ClientConnectionHTTP connection = new ClientConnectionHTTP(this);
        return connection.execute(result);
    }

    @Override
    protected void write(Result r) throws IOException, LdbSqlException {
        LdbSqlByteArrayOutputStream memStream = new LdbSqlByteArrayOutputStream();
        DataOutputStream tempOutput = new DataOutputStream(memStream);
        r.write(this, tempOutput, this.rowOut);
        this.httpConnection.setRequestMethod("POST");
        this.httpConnection.setDoOutput(true);
        this.httpConnection.setUseCaches(false);
        this.httpConnection.setRequestProperty("Content-Type", "application/octet-stream");
        this.httpConnection.setRequestProperty("Content-Length", String.valueOf(12 + memStream.size()));
        this.dataOutput = new DataOutputStream(this.httpConnection.getOutputStream());
        this.dataOutput.writeInt(r.getDatabaseId());
        this.dataOutput.writeLong(r.getSessionId());
        memStream.writeTo(this.dataOutput);
        this.dataOutput.flush();
    }

    @Override
    protected Result read() throws IOException, LdbSqlException {
        this.dataInput = new DataInputStream(new BufferedInputStream(this.httpConnection.getInputStream()));
        this.rowOut.reset();
        Result result = Result.newResult(this.dataInput, this.rowIn);
        result.readAdditionalResults(this, this.dataInput, this.rowIn);
        this.dataInput.close();
        return result;
    }

    @Override
    protected void handshake() throws IOException {
    }
}

