/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms;

import com.amazonaws.ml.mms.http.InferenceRequestHandler;
import com.amazonaws.ml.mms.http.ManagementRequestHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslContext;

public class ServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final boolean managementServer;
    private SslContext sslCtx;

    public ServerInitializer(SslContext sslCtx, boolean managementServer) {
        this.sslCtx = sslCtx;
        this.managementServer = managementServer;
    }

    @Override
    public void initChannel(SocketChannel ch) {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslCtx != null) {
            pipeline.addLast("ssl", (ChannelHandler)this.sslCtx.newHandler(ch.alloc()));
        }
        pipeline.addLast("http", (ChannelHandler)new HttpServerCodec());
        pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(0x640000));
        if (this.managementServer) {
            pipeline.addLast("handler", (ChannelHandler)new ManagementRequestHandler());
        } else {
            pipeline.addLast("handler", (ChannelHandler)new InferenceRequestHandler());
        }
    }
}

