/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.archive;

public final class Hex {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    public static String toHexString(byte[] block) {
        return Hex.toHexString(block, 0, block.length);
    }

    public static String toHexString(byte[] block, int offset, int len) {
        if (block == null) {
            return null;
        }
        if (offset < 0 || offset + len > block.length) {
            throw new IllegalArgumentException("Invalid offset or length.");
        }
        StringBuilder buf = new StringBuilder();
        int size = offset + len;
        for (int i = offset; i < size; ++i) {
            int high = (block[i] & 0xF0) >> 4;
            int low = block[i] & 0xF;
            buf.append(HEX_CHARS[high]);
            buf.append(HEX_CHARS[low]);
        }
        return buf.toString();
    }
}

