/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.archive;

import com.amazonaws.ml.mms.archive.InvalidModelException;
import com.amazonaws.ml.mms.archive.Manifest;
import com.google.gson.annotations.SerializedName;
import java.util.Map;

public class LegacyManifest {
    @SerializedName(value="Engine")
    private Map<String, Object> engine;
    @SerializedName(value="Model-Archive-Description")
    private String description;
    @SerializedName(value="License")
    private String license;
    @SerializedName(value="Model-Archive-Version")
    private String version;
    @SerializedName(value="Model-Server")
    private String serverVersion;
    @SerializedName(value="Model")
    private ModelInfo modelInfo;
    @SerializedName(value="Created-By")
    private CreatedBy createdBy;

    public Map<String, Object> getEngine() {
        return this.engine;
    }

    public void setEngine(Map<String, Object> engine) {
        this.engine = engine;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(String serverVersion) {
        this.serverVersion = serverVersion;
    }

    public ModelInfo getModelInfo() {
        return this.modelInfo;
    }

    public void setModelInfo(ModelInfo modelInfo) {
        this.modelInfo = modelInfo;
    }

    public CreatedBy getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(CreatedBy createdBy) {
        this.createdBy = createdBy;
    }

    public Manifest migrate() throws InvalidModelException {
        Object engineVersion;
        Manifest manifest = new Manifest();
        manifest.setDescription(this.description);
        manifest.setLicense(this.license);
        manifest.setSpecificationVersion("0.1");
        if (this.createdBy != null) {
            Manifest.Publisher publisher = new Manifest.Publisher();
            publisher.setAuthor(this.createdBy.getAuthor());
            publisher.setEmail(this.createdBy.getEmail());
            manifest.setPublisher(publisher);
        }
        if (this.engine != null && (engineVersion = this.engine.get("MXNet")) instanceof Number) {
            Manifest.Engine eng = new Manifest.Engine();
            eng.setEngineName(Manifest.EngineType.MX_NET);
            eng.setEngineVersion(engineVersion.toString());
            manifest.setEngine(eng);
        }
        Manifest.Model model = new Manifest.Model();
        model.setModelName(this.modelInfo.getModelName());
        model.setDescription(this.modelInfo.getDescription());
        model.setHandler(this.modelInfo.getService());
        model.setModelVersion("snapshot");
        model.addExtension("parametersFile", this.modelInfo.getParameters());
        model.addExtension("symbolFile", this.modelInfo.getSymbol());
        manifest.setModel(model);
        if (model.getHandler() == null) {
            throw new InvalidModelException("Missing Service entry in MANIFEST.json");
        }
        return manifest;
    }

    public static final class ModelInfo {
        @SerializedName(value="Parameters")
        private String parameters;
        @SerializedName(value="Symbol")
        private String symbol;
        @SerializedName(value="Description")
        private String description;
        @SerializedName(value="Model-Name")
        private String modelName;
        @SerializedName(value="Service")
        private String service;

        public String getParameters() {
            return this.parameters;
        }

        public void setParameters(String parameters) {
            this.parameters = parameters;
        }

        public String getSymbol() {
            return this.symbol;
        }

        public void setSymbol(String symbol) {
            this.symbol = symbol;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getModelName() {
            return this.modelName;
        }

        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public String getService() {
            return this.service;
        }

        public void setService(String service) {
            this.service = service;
        }
    }

    public static final class CreatedBy {
        @SerializedName(value="Author")
        private String author;
        @SerializedName(value="Author-Email")
        private String email;

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }
}

