/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.archive;

import java.util.LinkedHashMap;
import java.util.Map;

public class Manifest {
    private String specificationVersion = "1.0";
    private String implementationVersion = "1.0";
    private String description;
    private String modelServerVersion = "1.0";
    private String license = "Apache 2.0";
    private RuntimeType runtime = RuntimeType.PYTHON;
    private Engine engine;
    private Model model = new Model();
    private Publisher publisher;

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public void setSpecificationVersion(String specificationVersion) {
        this.specificationVersion = specificationVersion;
    }

    public String getImplementationVersion() {
        return this.implementationVersion;
    }

    public void setImplementationVersion(String implementationVersion) {
        this.implementationVersion = implementationVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getModelServerVersion() {
        return this.modelServerVersion;
    }

    public void setModelServerVersion(String modelServerVersion) {
        this.modelServerVersion = modelServerVersion;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public RuntimeType getRuntime() {
        return this.runtime;
    }

    public void setRuntime(RuntimeType runtime) {
        this.runtime = runtime;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void setEngine(Engine engine) {
        this.engine = engine;
    }

    public Model getModel() {
        return this.model;
    }

    public void setModel(Model model) {
        this.model = model;
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public void setPublisher(Publisher publisher) {
        this.publisher = publisher;
    }

    public static enum RuntimeType {
        PYTHON("python"),
        PYTHON2("python2"),
        PYTHON3("python3");

        String value;

        private RuntimeType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static RuntimeType fromValue(String value) {
            for (RuntimeType runtime : RuntimeType.values()) {
                if (!runtime.value.equals(value)) continue;
                return runtime;
            }
            throw new IllegalArgumentException("Invalid RuntimeType value: " + value);
        }
    }

    public static enum EngineType {
        MX_NET("MxNet");

        String value;

        private EngineType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static EngineType fromValue(String value) {
            for (EngineType engineType : EngineType.values()) {
                if (!engineType.value.equals(value)) continue;
                return engineType;
            }
            throw new IllegalArgumentException("Invalid EngineType value: " + value);
        }
    }

    public static final class Model {
        private String modelName;
        private String description;
        private String modelVersion;
        private Map<String, Object> extensions;
        private String handler;

        public String getModelName() {
            return this.modelName;
        }

        public void setModelName(String modelName) {
            this.modelName = modelName;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getModelVersion() {
            return this.modelVersion;
        }

        public void setModelVersion(String modelVersion) {
            this.modelVersion = modelVersion;
        }

        public Map<String, Object> getExtensions() {
            return this.extensions;
        }

        public void setExtensions(Map<String, Object> extensions) {
            this.extensions = extensions;
        }

        public void addExtension(String key, Object value) {
            if (this.extensions == null) {
                this.extensions = new LinkedHashMap<String, Object>();
            }
            this.extensions.put(key, value);
        }

        public String getHandler() {
            return this.handler;
        }

        public void setHandler(String handler) {
            this.handler = handler;
        }
    }

    public static final class Engine {
        private EngineType engineName;
        private String engineVersion;

        public EngineType getEngineName() {
            return this.engineName;
        }

        public void setEngineName(EngineType engineName) {
            this.engineName = engineName;
        }

        public String getEngineVersion() {
            return this.engineVersion;
        }

        public void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }
    }

    public static final class Publisher {
        private String author;
        private String email;

        public String getAuthor() {
            return this.author;
        }

        public void setAuthor(String author) {
            this.author = author;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }
    }
}

