/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.http;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DescribeModelResponse {
    private String modelName;
    private String modelVersion;
    private String modelUrl;
    private String engine;
    private String runtime;
    private int minWorkers;
    private int maxWorkers;
    private int batchSize;
    private int maxBatchDelay;
    private String status;
    private List<Worker> workers = new ArrayList<Worker>();
    private Metrics metrics;

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public String getModelUrl() {
        return this.modelUrl;
    }

    public void setModelUrl(String modelUrl) {
        this.modelUrl = modelUrl;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getRuntime() {
        return this.runtime;
    }

    public void setRuntime(String runtime) {
        this.runtime = runtime;
    }

    public int getMinWorkers() {
        return this.minWorkers;
    }

    public void setMinWorkers(int minWorkers) {
        this.minWorkers = minWorkers;
    }

    public int getMaxWorkers() {
        return this.maxWorkers;
    }

    public void setMaxWorkers(int maxWorkers) {
        this.maxWorkers = maxWorkers;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getMaxBatchDelay() {
        return this.maxBatchDelay;
    }

    public void setMaxBatchDelay(int maxBatchDelay) {
        this.maxBatchDelay = maxBatchDelay;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<Worker> getWorkers() {
        return this.workers;
    }

    public void setWorkers(List<Worker> workers) {
        this.workers = workers;
    }

    public void addWorker(String id, long startTime, boolean isRunning, int gpuId, long memoryUsage) {
        Worker worker = new Worker();
        worker.setId(id);
        worker.setStartTime(new Date(startTime));
        worker.setStatus(isRunning ? "READY" : "UNLOADING");
        worker.setGpu(gpuId >= 0);
        worker.setMemoryUsage(memoryUsage);
        this.workers.add(worker);
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(Metrics metrics) {
        this.metrics = metrics;
    }

    public static final class Metrics {
        private int rejectedRequests;
        private int waitingQueueSize;
        private int requests;

        public int getRejectedRequests() {
            return this.rejectedRequests;
        }

        public void setRejectedRequests(int rejectedRequests) {
            this.rejectedRequests = rejectedRequests;
        }

        public int getWaitingQueueSize() {
            return this.waitingQueueSize;
        }

        public void setWaitingQueueSize(int waitingQueueSize) {
            this.waitingQueueSize = waitingQueueSize;
        }

        public int getRequests() {
            return this.requests;
        }

        public void setRequests(int requests) {
            this.requests = requests;
        }
    }

    public static final class Worker {
        private String id;
        private Date startTime;
        private String status;
        private boolean gpu;
        private long memoryUsage;

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public void setStartTime(Date startTime) {
            this.startTime = startTime;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public boolean isGpu() {
            return this.gpu;
        }

        public void setGpu(boolean gpu) {
            this.gpu = gpu;
        }

        public long getMemoryUsage() {
            return this.memoryUsage;
        }

        public void setMemoryUsage(long memoryUsage) {
            this.memoryUsage = memoryUsage;
        }
    }
}

