/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.http;

import com.amazonaws.ml.mms.archive.ModelException;
import com.amazonaws.ml.mms.archive.ModelNotFoundException;
import com.amazonaws.ml.mms.http.BadRequestException;
import com.amazonaws.ml.mms.http.MethodNotAllowedException;
import com.amazonaws.ml.mms.http.ResourceNotFoundException;
import com.amazonaws.ml.mms.http.ServiceUnavailableException;
import com.amazonaws.ml.mms.util.NettyUtils;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestHandler.class);

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
        try {
            NettyUtils.requestReceived(ctx.channel(), req);
            if (!req.decoderResult().isSuccess()) {
                throw new BadRequestException("Invalid HTTP message.");
            }
            QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
            String path = decoder.path();
            if ("/".equals(path)) {
                if (HttpMethod.OPTIONS.equals(req.method())) {
                    this.handleApiDescription(ctx);
                    return;
                }
                throw new MethodNotAllowedException();
            }
            String[] segments = path.split("/");
            this.handleRequest(ctx, req, decoder, segments);
        }
        catch (ModelNotFoundException | ResourceNotFoundException e) {
            logger.trace("", e);
            NettyUtils.sendError(ctx, HttpResponseStatus.NOT_FOUND, e);
        }
        catch (ModelException | BadRequestException e) {
            logger.trace("", e);
            NettyUtils.sendError(ctx, HttpResponseStatus.BAD_REQUEST, e);
        }
        catch (MethodNotAllowedException e) {
            logger.trace("", e);
            NettyUtils.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED, e);
        }
        catch (ServiceUnavailableException e) {
            logger.trace("", e);
            NettyUtils.sendError(ctx, HttpResponseStatus.SERVICE_UNAVAILABLE, e);
        }
        catch (Throwable t) {
            logger.error("", t);
            NettyUtils.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR, t);
        }
    }

    protected abstract void handleRequest(ChannelHandlerContext var1, FullHttpRequest var2, QueryStringDecoder var3, String[] var4) throws ModelException;

    protected abstract void handleApiDescription(ChannelHandlerContext var1);

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.error("", cause);
        ctx.close();
    }
}

