/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.metrics;

import com.amazonaws.ml.mms.metrics.Metric;
import com.amazonaws.ml.mms.metrics.MetricManager;
import com.amazonaws.ml.mms.util.ConfigManager;
import com.amazonaws.ml.mms.wlm.ModelManager;
import com.amazonaws.ml.mms.wlm.WorkerThread;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricCollector
implements Runnable {
    static final Logger logger = LoggerFactory.getLogger(MetricCollector.class);
    private static final org.apache.log4j.Logger loggerMetrics = org.apache.log4j.Logger.getLogger("MMS_METRICS");
    private ConfigManager configManager;

    public MetricCollector(ConfigManager configManager) {
        this.configManager = configManager;
    }

    @Override
    public void run() {
        try {
            String[] args = new String[]{"python", "mms/metrics/metric_collector.py"};
            File workingDir = new File(this.configManager.getModelServerHome());
            String pythonPath = System.getenv("PYTHONPATH");
            String pythonEnv = pythonPath == null || pythonPath.isEmpty() ? "PYTHONPATH=" + workingDir.getAbsolutePath() : "PYTHONPATH=" + pythonPath + File.pathSeparatorChar + workingDir.getAbsolutePath();
            StringBuilder path = new StringBuilder();
            path.append("PATH=").append(System.getenv("PATH"));
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Mac OS X")) {
                path.append(File.pathSeparatorChar).append("/sbin/");
            }
            String[] env = new String[]{pythonEnv, path.toString()};
            Process p = Runtime.getRuntime().exec(args, env, workingDir);
            ModelManager modelManager = ModelManager.getInstance();
            Map<Integer, WorkerThread> workerMap = modelManager.getWorkers();
            try (OutputStream os = p.getOutputStream();){
                this.writeWorkerPids(workerMap, os);
            }
            new Thread(() -> {
                try {
                    String error = IOUtils.toString(p.getErrorStream(), StandardCharsets.UTF_8);
                    if (!error.isEmpty()) {
                        logger.error(error);
                    }
                }
                catch (IOException e) {
                    logger.error("", e);
                }
            }).start();
            MetricManager metricManager = MetricManager.getInstance();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                ArrayList<Metric> metricsSystem = new ArrayList<Metric>();
                metricManager.setMetrics(metricsSystem);
                while ((line = reader.readLine()) != null && !line.isEmpty()) {
                    Metric metric = Metric.parse(line);
                    if (metric == null) {
                        logger.warn("Parse metrics failed: " + line);
                        continue;
                    }
                    loggerMetrics.info(metric);
                    metricsSystem.add(metric);
                }
                while ((line = reader.readLine()) != null) {
                    String[] tokens = line.split(":");
                    if (tokens.length != 2) continue;
                    Integer pid = Integer.valueOf(tokens[0]);
                    WorkerThread worker = workerMap.get(pid);
                    worker.setMemory(Long.parseLong(tokens[1]));
                }
            }
        }
        catch (IOException e) {
            logger.error("", e);
        }
    }

    private void writeWorkerPids(Map<Integer, WorkerThread> workerMap, OutputStream os) throws IOException {
        boolean first = true;
        for (Integer pid : workerMap.keySet()) {
            if (pid < 0) {
                logger.warn("worker pid is not available yet.");
                continue;
            }
            if (first) {
                first = false;
            } else {
                IOUtils.write(",", os, StandardCharsets.UTF_8);
            }
            IOUtils.write(pid.toString(), os, StandardCharsets.UTF_8);
        }
        os.write(10);
    }
}

