/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.metrics;

import com.amazonaws.ml.mms.metrics.Metric;
import com.amazonaws.ml.mms.metrics.MetricCollector;
import com.amazonaws.ml.mms.util.ConfigManager;
import com.amazonaws.ml.mms.wlm.ModelManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class MetricManager {
    private static final MetricManager METRIC_MANAGER = new MetricManager();
    private List<Metric> metrics = Collections.emptyList();

    private MetricManager() {
    }

    public static MetricManager getInstance() {
        return METRIC_MANAGER;
    }

    public static void scheduleMetrics(ConfigManager configManager) {
        MetricCollector metricCollector = new MetricCollector(configManager);
        ModelManager.getInstance().getScheduler().scheduleAtFixedRate(metricCollector, 0L, configManager.getMetricTimeInterval(), TimeUnit.SECONDS);
    }

    public synchronized List<Metric> getMetrics() {
        return this.metrics;
    }

    public synchronized void setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
    }
}

