/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.openapi;

import com.amazonaws.ml.mms.openapi.Parameter;
import com.amazonaws.ml.mms.openapi.RequestBody;
import com.amazonaws.ml.mms.openapi.Response;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Operation {
    private String summary;
    private String description;
    private String operationId;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private RequestBody requestBody;
    private Map<String, Response> responses;
    private Boolean deprecated;

    public Operation() {
    }

    public Operation(String operationId) {
        this(operationId, null);
    }

    public Operation(String operationId, String description) {
        this.operationId = operationId;
        this.description = description;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(parameter);
    }

    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
    }

    public Map<String, Response> getResponses() {
        return this.responses;
    }

    public void setResponses(Map<String, Response> responses) {
        this.responses = responses;
    }

    public void addResponse(Response response) {
        if (this.responses == null) {
            this.responses = new LinkedHashMap<String, Response>();
        }
        this.responses.put(response.getCode(), response);
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }
}

