/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.util;

import com.amazonaws.ml.mms.util.OpenSslKey;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOUtils;

public final class ConfigManager {
    public static final String MODEL_METRICS_LOGGER = "MODEL_METRICS";
    public static final String MODEL_LOGGER = "MODEL_LOG";
    public static final String MMS_METRICS_LOGGER = "MMS_METRICS";
    private static final String DEBUG = "debug";
    private static final String INFERENCE_ADDRESS = "inference_address";
    private static final String MANAGEMENT_ADDRESS = "management_address";
    private static final String MODEL_SERVER_HOME = "model_server_home";
    private static final String MODEL_STORE = "model_store";
    private static final String LOAD_MODELS = "load_models";
    private static final String BLACKLIST_ENV_VARS = "blacklist_env_vars";
    private static final String NUMBER_OF_NETTY_THREADS = "number_of_netty_threads";
    private static final String MAX_WORKERS = "max_workers";
    private static final String JOB_QUEUE_SIZE = "job_queue_size";
    private static final String NUMBER_OF_GPU = "number_of_gpu";
    private static final String METRIC_TIME_INTERVAL = "metric_time_interval";
    private static final String KEYSTORE = "keystore";
    private static final String KEYSTORE_PASS = "keystore_pass";
    private static final String KEYSTORE_TYPE = "keystore_type";
    private static final String CERTIFICATE_FILE = "certificate_file";
    private static final String PRIVATE_KEY_FILE = "private_key_file";
    private Pattern blacklistPattern;
    private Properties prop = new Properties();

    public Pattern getBlacklistPattern() {
        return this.blacklistPattern;
    }

    public ConfigManager(Arguments args) {
        CharSequence[] models;
        String logLocation;
        File file;
        String filePath = System.getenv("MMS_CONFIG_FILE");
        if (filePath == null && (filePath = args.getMmsConfigFile()) == null) {
            filePath = System.getProperty("mmsConfigFile", "config.properties");
        }
        if ((file = new File(filePath)).exists()) {
            try (FileInputStream stream = new FileInputStream(file);){
                this.prop.load(stream);
                this.prop.put("mmsConfigFile", filePath);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to read configuration file", e);
            }
        }
        if ((logLocation = System.getenv("LOG_LOCATION")) != null) {
            System.setProperty("LOG_LOCATION", logLocation);
        } else if (System.getProperty("LOG_LOCATION") == null) {
            System.setProperty("LOG_LOCATION", "logs");
        }
        String metricsLocation = System.getenv("METRICS_LOCATION");
        if (metricsLocation != null) {
            System.setProperty("METRICS_LOCATION", metricsLocation);
        } else if (System.getProperty("METRICS_LOCATION") == null) {
            System.setProperty("METRICS_LOCATION", "logs");
        }
        String modelStore = args.getModelStore();
        if (modelStore != null) {
            this.prop.setProperty(MODEL_STORE, modelStore);
        }
        if ((models = args.getModels()) != null) {
            this.prop.setProperty(LOAD_MODELS, String.join((CharSequence)",", models));
        }
        if (!this.prop.containsKey(NUMBER_OF_GPU)) {
            this.prop.setProperty(NUMBER_OF_GPU, String.valueOf(ConfigManager.getAvailableGpu()));
        }
    }

    public boolean isDebug() {
        return Boolean.getBoolean("DEBUG") || Boolean.parseBoolean(this.prop.getProperty(DEBUG, "false"));
    }

    private URI getAddressProperty(String key, String defaultValue) {
        String address = this.getProperty(key, defaultValue);
        try {
            String host;
            URI uri = new URI(address);
            String scheme = uri.getScheme() != null ? uri.getScheme() : "http";
            String string = host = uri.getHost() != null ? uri.getHost() : "127.0.0.1";
            int port = uri.getPort() == -1 ? ("https".equalsIgnoreCase(scheme) ? 443 : 80) : uri.getPort();
            if (!"http".equalsIgnoreCase(scheme) && !"https".equalsIgnoreCase(scheme)) {
                throw new IllegalArgumentException("Unsupported protocol in address: " + address);
            }
            return new URI(scheme + "://" + host + ":" + port);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid address: %s", address), e);
        }
    }

    public URI getInferenceAddress() {
        return this.getAddressProperty(INFERENCE_ADDRESS, "http://127.0.0.1:8080");
    }

    public URI getManagementAddress() {
        return this.getAddressProperty(MANAGEMENT_ADDRESS, "http://127.0.0.1:8081");
    }

    public int getNettyThreads() {
        return this.getIntProperty(NUMBER_OF_NETTY_THREADS, 0);
    }

    public int getMaxWorkers() {
        return this.getIntProperty(MAX_WORKERS, Runtime.getRuntime().availableProcessors());
    }

    public int getJobQueueSize() {
        return this.getIntProperty(JOB_QUEUE_SIZE, 100);
    }

    public int getNumberOfGpu() {
        return this.getIntProperty(NUMBER_OF_GPU, 0);
    }

    public int getMetricTimeInterval() {
        return this.getIntProperty(METRIC_TIME_INTERVAL, 60);
    }

    public String getModelServerHome() {
        String mmsHome = System.getenv("MODEL_SERVER_HOME");
        if (mmsHome == null && (mmsHome = System.getProperty(MODEL_SERVER_HOME)) == null && (mmsHome = this.getProperty(MODEL_SERVER_HOME, null)) == null) {
            mmsHome = ConfigManager.getCanonicalPath(this.findMmsHome());
            return mmsHome;
        }
        File dir = new File(mmsHome);
        if (!dir.exists()) {
            throw new IllegalArgumentException("Model server home not exist: " + mmsHome);
        }
        mmsHome = ConfigManager.getCanonicalPath(dir);
        return mmsHome;
    }

    public String getModelStore() {
        return ConfigManager.getCanonicalPath(this.prop.getProperty(MODEL_STORE));
    }

    public String getLoadModels() {
        return this.prop.getProperty(LOAD_MODELS);
    }

    public SslContext getSslContext() throws IOException, GeneralSecurityException {
        X509Certificate[] chain;
        PrivateKey privateKey;
        List<String> supportedCiphers = Arrays.asList("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
        String keyStoreFile = this.prop.getProperty(KEYSTORE);
        String privateKeyFile = this.prop.getProperty(PRIVATE_KEY_FILE);
        String certificateFile = this.prop.getProperty(CERTIFICATE_FILE);
        if (keyStoreFile != null) {
            char[] keystorePass = this.getProperty(KEYSTORE_PASS, "changeit").toCharArray();
            String keystoreType = this.getProperty(KEYSTORE_TYPE, "PKCS12");
            KeyStore keyStore = KeyStore.getInstance(keystoreType);
            try (FileInputStream is = new FileInputStream(keyStoreFile);){
                keyStore.load(is, keystorePass);
            }
            Enumeration<String> en = keyStore.aliases();
            String keyAlias = null;
            while (en.hasMoreElements()) {
                String alias = en.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                keyAlias = alias;
                break;
            }
            if (keyAlias == null) {
                throw new KeyException("No key entry found in keystore.");
            }
            privateKey = (PrivateKey)keyStore.getKey(keyAlias, keystorePass);
            Certificate[] certs = keyStore.getCertificateChain(keyAlias);
            chain = new X509Certificate[certs.length];
            for (int i = 0; i < certs.length; ++i) {
                chain[i] = (X509Certificate)certs[i];
            }
        } else if (privateKeyFile != null && certificateFile != null) {
            privateKey = this.loadPrivateKey(privateKeyFile);
            chain = this.loadCertificateChain(certificateFile);
        } else {
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            privateKey = ssc.key();
            chain = new X509Certificate[]{ssc.cert()};
        }
        return SslContextBuilder.forServer(privateKey, chain).protocols("TLSv1.2").ciphers(supportedCiphers).build();
    }

    /*
     * Loose catch block
     */
    private PrivateKey loadPrivateKey(String keyFile) throws IOException, GeneralSecurityException {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        Throwable throwable = null;
        try (FileInputStream is = new FileInputStream(keyFile);){
            String content = IOUtils.toString((InputStream)is, StandardCharsets.UTF_8);
            content = content.replaceAll("-----(BEGIN|END)( RSA)? PRIVATE KEY-----\\s*", "");
            byte[] buf = Base64.getMimeDecoder().decode(content);
            try {
                PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(buf);
                PrivateKey privateKey = keyFactory.generatePrivate(privKeySpec);
                return privateKey;
            }
            catch (InvalidKeySpecException e) {
                PrivateKey privateKey;
                block17: {
                    block18: {
                        buf = OpenSslKey.convertPrivateKey(buf);
                        PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(buf);
                        privateKey = keyFactory.generatePrivate(privKeySpec);
                        if (is == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    ((InputStream)is).close();
                }
                return privateKey;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    private X509Certificate[] loadCertificateChain(String keyFile) throws IOException, GeneralSecurityException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (FileInputStream is = new FileInputStream(keyFile);){
            Collection<? extends Certificate> certs = cf.generateCertificates(is);
            int i = 0;
            X509Certificate[] chain = new X509Certificate[certs.size()];
            for (Certificate certificate : certs) {
                chain[i++] = (X509Certificate)certificate;
            }
            X509Certificate[] x509CertificateArray = chain;
            return x509CertificateArray;
        }
    }

    public String getProperty(String key, String def) {
        return this.prop.getProperty(key, def);
    }

    public void validateConfigurations() throws InvalidPropertiesFormatException {
        String blacklistVars = this.prop.getProperty(BLACKLIST_ENV_VARS, "");
        try {
            this.blacklistPattern = Pattern.compile(blacklistVars);
        }
        catch (PatternSyntaxException e) {
            throw new InvalidPropertiesFormatException(e);
        }
    }

    public String dumpConfigurations() {
        return "\nMMS Home: " + this.getModelServerHome() + "\nCurrent directory: " + ConfigManager.getCanonicalPath(".") + "\nTemp directory: " + System.getProperty("java.io.tmpdir") + "\nConfig file: " + this.prop.getProperty("mmsConfigFile") + "\nNumber of GPU: " + this.getNumberOfGpu() + "\nModel Store: " + this.getModelStore() + "\nInitial Models: " + this.getLoadModels() + "\nLog dir: " + ConfigManager.getCanonicalPath(System.getProperty("LOG_LOCATION")) + "\nMetrics dir: " + ConfigManager.getCanonicalPath(System.getProperty("METRICS_LOCATION")) + "\nBlacklist Regex: " + this.prop.getProperty(BLACKLIST_ENV_VARS, "");
    }

    void setProperty(String key, String value) {
        this.prop.setProperty(key, value);
    }

    private int getIntProperty(String key, int def) {
        String value = this.prop.getProperty(key);
        if (value == null) {
            return def;
        }
        return Integer.parseInt(value);
    }

    private File findMmsHome() {
        File cwd;
        for (File file = cwd = new File(ConfigManager.getCanonicalPath(".")); file != null; file = file.getParentFile()) {
            File mms = new File(file, "mms");
            if (!mms.exists()) continue;
            return file;
        }
        return cwd;
    }

    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return file.getAbsolutePath();
        }
    }

    private static String getCanonicalPath(String path) {
        if (path == null) {
            return null;
        }
        return ConfigManager.getCanonicalPath(new File(path));
    }

    private static int getAvailableGpu() {
        try {
            Process process = Runtime.getRuntime().exec("nvidia-smi --query-gpu=index --format=csv");
            int ret = process.waitFor();
            if (ret != 0) {
                return 0;
            }
            List<String> list = IOUtils.readLines(process.getInputStream(), StandardCharsets.UTF_8);
            if (list.isEmpty() || !"index".equals(list.get(0))) {
                throw new AssertionError((Object)"Unexpected nvidia-smi response.");
            }
            return list.size() - 1;
        }
        catch (IOException | InterruptedException e) {
            return 0;
        }
    }

    public static final class Arguments {
        private String mmsConfigFile;
        private String modelStore;
        private String[] models;

        public Arguments() {
        }

        public Arguments(CommandLine cmd) {
            this.mmsConfigFile = cmd.getOptionValue("mms-config-file");
            this.modelStore = cmd.getOptionValue("model-store");
            this.models = cmd.getOptionValues("models");
        }

        public static Options getOptions() {
            Options options = new Options();
            options.addOption(Option.builder("f").longOpt("mms-config-file").hasArg().argName("MMS-CONFIG-FILE").desc("Path to the configuration properties file.").build());
            options.addOption(Option.builder("m").longOpt("models").hasArgs().argName("MODELS").desc("Models to be loaded at startup.").build());
            options.addOption(Option.builder("s").longOpt("model-store").hasArgs().argName("MODELS-STORE").desc("Model store location where models can be loaded.").build());
            return options;
        }

        public String getMmsConfigFile() {
            return this.mmsConfigFile;
        }

        public void setMmsConfigFile(String mmsConfigFile) {
            this.mmsConfigFile = mmsConfigFile;
        }

        public String getModelStore() {
            return this.modelStore;
        }

        public void setModelStore(String modelStore) {
            this.modelStore = modelStore;
        }

        public String[] getModels() {
            return this.models;
        }

        public void setModels(String[] models) {
            this.models = models;
        }
    }
}

