/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.util.codec;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import java.nio.charset.StandardCharsets;

public final class CodecUtils {
    public static final int END = -1;
    public static final int BUFFER_UNDER_RUN = -3;

    private CodecUtils() {
    }

    public static int readLength(ByteBuf byteBuf, int maxLength) {
        int size = byteBuf.readableBytes();
        if (size < 4) {
            return -3;
        }
        int len = byteBuf.readInt();
        if (len > maxLength) {
            throw new CorruptedFrameException("Message size exceed limit: " + len);
        }
        if (len > byteBuf.readableBytes()) {
            return -3;
        }
        return len;
    }

    public static String readString(ByteBuf byteBuf, int len) {
        return new String(CodecUtils.read(byteBuf, len), StandardCharsets.UTF_8);
    }

    public static byte[] read(ByteBuf in, int len) {
        if (len < 0) {
            throw new CorruptedFrameException("Invalid message size: " + len);
        }
        byte[] buf = new byte[len];
        in.readBytes(buf);
        return buf;
    }
}

