/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.util.codec;

import com.amazonaws.ml.mms.util.codec.CodecUtils;
import com.amazonaws.ml.mms.util.messages.ModelWorkerResponse;
import com.amazonaws.ml.mms.util.messages.Predictions;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.ArrayList;
import java.util.List;

public class ModelResponseDecoder
extends ByteToMessageDecoder {
    private static final int MAX_BUFFER_SIZE = 6553500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        int size = in.readableBytes();
        if (size < 9) {
            return;
        }
        in.markReaderIndex();
        boolean completed = false;
        try {
            ModelWorkerResponse resp = new ModelWorkerResponse();
            resp.setCode(in.readInt());
            int len = CodecUtils.readLength(in, 6553500);
            if (len == -3) {
                return;
            }
            resp.setMessage(CodecUtils.readString(in, len));
            ArrayList<Predictions> predictions = new ArrayList<Predictions>();
            while ((len = CodecUtils.readLength(in, 6553500)) != -1) {
                if (len == -3) {
                    return;
                }
                Predictions prediction = new Predictions();
                prediction.setRequestId(CodecUtils.readString(in, len));
                len = CodecUtils.readLength(in, 6553500);
                if (len == -3) {
                    return;
                }
                prediction.setContentType(CodecUtils.readString(in, len));
                len = CodecUtils.readLength(in, 6553500);
                if (len == -3) {
                    return;
                }
                prediction.setResp(CodecUtils.read(in, len));
                predictions.add(prediction);
            }
            resp.setPredictions(predictions);
            out.add(resp);
            completed = true;
        }
        finally {
            if (!completed) {
                in.resetReaderIndex();
            }
        }
    }
}

