/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.util.logging;

import com.amazonaws.ml.mms.metrics.Dimension;
import com.amazonaws.ml.mms.metrics.Metric;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;

public class QLogLayout
extends PatternLayout {
    @Override
    public String format(LoggingEvent event) {
        Object eventMessage = event.getMessage();
        if (eventMessage == null) {
            return null;
        }
        if (eventMessage instanceof Metric) {
            StringBuilder stringBuilder = new StringBuilder();
            Metric metric = (Metric)eventMessage;
            stringBuilder.append("HostName=").append(metric.getHostName());
            if (metric.getRequestId() != null) {
                stringBuilder.append("\nRequestId=").append(metric.getRequestId());
            }
            stringBuilder.append("\nTimeStamp=").append(metric.getTimestamp());
            stringBuilder.append("\nMetrics=").append(metric.getMetricName()).append('=').append(metric.getValue()).append(' ').append(metric.getUnit());
            for (Dimension dimension : metric.getDimensions()) {
                stringBuilder.append(' ').append(dimension.getName()).append('|').append(dimension.getValue()).append(' ');
            }
            stringBuilder.append("\nEOE\n");
            return stringBuilder.toString();
        }
        return eventMessage.toString();
    }
}

