/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.util.messages;

import com.amazonaws.ml.mms.util.messages.BaseModelRequest;
import com.amazonaws.ml.mms.util.messages.WorkerCommands;
import com.amazonaws.ml.mms.wlm.Model;

public class ModelLoadModelRequest
extends BaseModelRequest {
    private String modelPath;
    private String handler;
    private int batchSize;
    private int gpuId;

    public ModelLoadModelRequest(Model model, int gpuId) {
        super(WorkerCommands.LOAD, model.getModelName());
        this.gpuId = gpuId;
        this.modelPath = model.getModelDir().getAbsolutePath();
        this.handler = model.getModelArchive().getManifest().getModel().getHandler();
        this.batchSize = model.getBatchSize();
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public String getHandler() {
        return this.handler;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getGpuId() {
        return this.gpuId;
    }
}

