/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.util.messages;

import com.amazonaws.ml.mms.util.messages.InputParameter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RequestInput {
    private String requestId;
    private Map<String, String> headers;
    private List<InputParameter> parameters;

    public RequestInput(String requestId) {
        this.requestId = requestId;
        this.headers = new HashMap<String, String>();
        this.parameters = new ArrayList<InputParameter>();
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public List<InputParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<InputParameter> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(InputParameter modelInput) {
        this.parameters.add(modelInput);
    }

    public String getStringParameter(String key) {
        for (InputParameter param : this.parameters) {
            if (!key.equals(param.getName())) continue;
            return new String(param.getValue(), StandardCharsets.UTF_8);
        }
        return null;
    }
}

