/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.wlm;

import com.amazonaws.ml.mms.archive.ModelArchive;
import com.amazonaws.ml.mms.wlm.Job;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class Model {
    public static final String DEFAULT_DATA_QUEUE = "DATA_QUEUE";
    private ModelArchive modelArchive;
    private int minWorkers;
    private int maxWorkers;
    private int batchSize;
    private int maxBatchDelay;
    private AtomicInteger failedInfReqs;
    private ConcurrentMap<String, LinkedBlockingDeque<Job>> jobsDb;

    public Model(ModelArchive modelArchive, int queueSize) {
        this.modelArchive = modelArchive;
        this.batchSize = 1;
        this.maxBatchDelay = 100;
        this.jobsDb = new ConcurrentHashMap<String, LinkedBlockingDeque<Job>>();
        this.jobsDb.putIfAbsent(DEFAULT_DATA_QUEUE, new LinkedBlockingDeque(queueSize));
        this.failedInfReqs = new AtomicInteger(0);
    }

    public String getModelName() {
        return this.modelArchive.getModelName();
    }

    public File getModelDir() {
        return this.modelArchive.getModelDir();
    }

    public String getModelUrl() {
        return this.modelArchive.getUrl();
    }

    public ModelArchive getModelArchive() {
        return this.modelArchive;
    }

    public int getMinWorkers() {
        return this.minWorkers;
    }

    public void setMinWorkers(int minWorkers) {
        this.minWorkers = minWorkers;
    }

    public int getMaxWorkers() {
        return this.maxWorkers;
    }

    public void setMaxWorkers(int maxWorkers) {
        this.maxWorkers = maxWorkers;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public int getMaxBatchDelay() {
        return this.maxBatchDelay;
    }

    public void setMaxBatchDelay(int maxBatchDelay) {
        this.maxBatchDelay = maxBatchDelay;
    }

    public void addJob(String threadId, Job job) {
        LinkedBlockingDeque<Job> blockingDeque = (LinkedBlockingDeque<Job>)this.jobsDb.get(threadId);
        if (blockingDeque == null) {
            blockingDeque = new LinkedBlockingDeque<Job>();
            this.jobsDb.put(threadId, blockingDeque);
        }
        blockingDeque.offer(job);
    }

    public void removeJobQueue(String threadId) {
        if (!threadId.equals(DEFAULT_DATA_QUEUE)) {
            this.jobsDb.remove(threadId);
        }
    }

    public boolean addJob(Job job) {
        return ((LinkedBlockingDeque)this.jobsDb.get(DEFAULT_DATA_QUEUE)).offer(job);
    }

    public void addFirst(Job job) {
        ((LinkedBlockingDeque)this.jobsDb.get(DEFAULT_DATA_QUEUE)).addFirst(job);
    }

    public Job nextJob(String threadId) throws InterruptedException {
        return this.nextJob(threadId, Long.MAX_VALUE);
    }

    public Job nextJob(String threadId, long timeoutMillis) throws InterruptedException {
        Job j;
        LinkedBlockingDeque jobs = (LinkedBlockingDeque)this.jobsDb.get(threadId);
        if (jobs != null && !jobs.isEmpty() && (j = (Job)jobs.poll()) != null) {
            return j;
        }
        return (Job)((LinkedBlockingDeque)this.jobsDb.get(DEFAULT_DATA_QUEUE)).poll(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public int incrFailedInfReqs() {
        return this.failedInfReqs.incrementAndGet();
    }

    public void resetFailedInfReqs() {
        this.failedInfReqs.set(0);
    }
}

