/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.ml.mms.wlm;

import com.amazonaws.ml.mms.wlm.WorkerState;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerStateListener {
    private static final Logger logger = LoggerFactory.getLogger(WorkerStateListener.class);
    private CompletableFuture<Boolean> future;
    private AtomicInteger count;

    public WorkerStateListener(CompletableFuture<Boolean> future, int count) {
        this.future = future;
        this.count = new AtomicInteger(count);
    }

    public void notifyChangeState(String modelName, WorkerState state) {
        logger.info("{} worker state is: {}", (Object)modelName, (Object)state);
        if (state == WorkerState.WORKER_MODEL_LOADED && this.count.decrementAndGet() == 0) {
            this.future.complete(Boolean.TRUE);
        }
        if (state == WorkerState.WORKER_ERROR || state == WorkerState.WORKER_STOPPED) {
            this.future.complete(Boolean.FALSE);
        }
    }
}

