import typing
import mathutils
import bpy
import bl_ui.properties_data_bone
import bl_ui.properties_data_light
import bl_ui.properties_data_armature
import bl_ui.node_add_menu_texture
import bl_ui.space_graph
import bl_ui.properties_object
import bl_ui.properties_material
import bl_operators.anim
import bl_operators.object
import bl_ui.space_console
import bl_ui.properties_physics_geometry_nodes
import bl_ui
import bl_ui.properties_view_layer
import bl_ui.space_text
import bl_ui.space_properties
import bl_ui.space_userpref
import bl_ui.properties_scene
import bl_ui.anim
import bl_ui.properties_data_volume
import bl_operators.spreadsheet
import bl_ui.node_add_menu_geometry
import bl_ui.properties_data_shaderfx
import bl_ui.properties_data_metaball
import bl_ui.node_add_menu
import bl_ui.space_image
import bl_ui.properties_paint_common
import bl_operators.node
import bl_operators.wm
import bl_ui.properties_data_grease_pencil
import bl_operators.freestyle
import bl_ui.space_sequencer
import bl_operators.clip
import bl_ui.properties_data_pointcloud
import bl_ui.properties_freestyle
import bl_operators.assets
import bl_ui.properties_data_speaker
import bl_ui.properties_collection
import bl_ui.properties_texture
import bl_operators.file
import bl_ui.properties_physics_cloth
import bl_ui.properties_physics_dynamicpaint
import bl_ui.properties_material_gpencil
import bl_ui.properties_grease_pencil_common
import bl_ui.properties_data_lightprobe
import bl_ui.properties_physics_field
import bl_ui.properties_constraint
import bl_ui.properties_physics_softbody
import bl_ui.properties_physics_rigidbody_constraint
import bl_operators.constraint
import bl_ui.properties_data_lattice
import bl_ui.properties_render
import bl_ui.space_filebrowser
import bl_ui.space_dopesheet
import bl_ui.space_view3d_toolbar
import bl_ui.properties_physics_rigidbody
import bl_ui.space_clip
import bl_ui.space_statusbar
import bl_ui.properties_data_camera
import bl_ui.properties_data_modifier
import bl_ui.space_topbar
import bl_ui.properties_output
import bl_operators.presets
import bl_ui.properties_mask_common
import bl_ui.properties_data_empty
import bl_ui.space_nla
import bl_ui.node_add_menu_compositor
import bl_ui.properties_data_curves
import bl_ui.properties_data_gpencil
import bl_operators.userpref
import bl_ui.space_toolsystem_toolbar
import bl_ui.space_time
import bl_ui.asset_shelf
import bl_ui.space_toolsystem_common
import bl_ui.properties_physics_common
import bl_ui.space_info
import bl_operators.view3d
import bl_ui.node_add_menu_shader
import bl_ui.space_outliner
import bl_ui.properties_world
import bl_ui.properties_data_curve
import bl_ui.space_view3d
import bl_ui.generic_ui_list
import bl_ui.space_spreadsheet
import bl_ui.properties_data_mesh
import bl_ui.properties_particle
import bl_ui.space_node
import bl_ui.properties_physics_fluid
import bl_ui.properties_workspace

GenericType = typing.TypeVar("GenericType")

class bpy_prop_collection(typing.Generic[GenericType]):
    """built-in class used for all collections."""

    def find(self, key: typing.Optional[str]) -> int:
        """Returns the index of a key in a collection or -1 when not found
        (matches Python's string find function of the same name).

                :param key: The identifier for the collection member.
                :type key: typing.Optional[str]
                :rtype: int
                :return: index of the key.
        """
        ...

    def foreach_get(self, attr, seq):
        """This is a function to give fast access to attributes within a collection.Only works for 'basic type' properties (bool, int and float)!
        Multi-dimensional arrays (like array of vectors) will be flattened into seq.

                :param attr:
                :type attr:
                :param seq:
                :type seq:
        """
        ...

    def foreach_set(self, attr, seq):
        """This is a function to give fast access to attributes within a collection.Only works for 'basic type' properties (bool, int and float)!
        seq must be uni-dimensional, multi-dimensional arrays (like array of vectors) will be re-created from it.

                :param attr:
                :type attr:
                :param seq:
                :type seq:
        """
        ...

    def get(
        self, key: typing.Optional[str], default: typing.Optional[typing.Any] = None
    ):
        """Returns the value of the item assigned to key or default when not found
        (matches Python's dictionary function of the same name).

                :param key: The identifier for the collection member.
                :type key: typing.Optional[str]
                :param default: Optional argument for the value to return if
        key is not found.
                :type default: typing.Optional[typing.Any]
        """
        ...

    def items(self) -> typing.List:
        """Return the identifiers of collection members
        (matching Python's dict.items() functionality).

                :rtype: typing.List
                :return: (key, value) pairs for each member of this collection.
        """
        ...

    def keys(self) -> typing.List[str]:
        """Return the identifiers of collection members
        (matching Python's dict.keys() functionality).

                :rtype: typing.List[str]
                :return: the identifiers for each member of this collection.
        """
        ...

    def values(self) -> typing.List:
        """Return the values of collection
        (matching Python's dict.values() functionality).

                :rtype: typing.List
                :return: the members of this collection.
        """
        ...

    def __getitem__(
        self, key: typing.Optional[typing.Union[int, str]]
    ) -> "GenericType":
        """

        :param key:
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'GenericType'
        """
        ...

    def __setitem__(
        self, key: typing.Optional[typing.Union[int, str]], value: "GenericType"
    ):
        """

        :param key:
        :type key: typing.Optional[typing.Union[int, str]]
        :param value:
        :type value: 'GenericType'
        """
        ...

    def __delitem__(
        self, key: typing.Optional[typing.Union[int, str]]
    ) -> "GenericType":
        """

        :param key:
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'GenericType'
        """
        ...

    def __iter__(self) -> typing.Iterator["GenericType"]:
        """

        :rtype: typing.Iterator['GenericType']
        """
        ...

    def __next__(self) -> "GenericType":
        """

        :rtype: 'GenericType'
        """
        ...

    def __len__(self) -> int:
        """

        :rtype: int
        """
        ...

class bpy_struct:
    """built-in base class for all classes in bpy.types."""

    id_data: typing.Any
    """ The `bpy.types.ID` object this datablock is from or None, (not available for all data types)"""

    def as_pointer(self) -> int:
        """Returns the memory address which holds a pointer to Blender's internal data

        :rtype: int
        :return: int (memory address).
        """
        ...

    def driver_add(
        self, path: typing.Optional[str], index: typing.Optional[int] = -1
    ) -> "FCurve":
        """Adds driver(s) to the given property

        :param path: path to the property to drive, analogous to the fcurve's data path.
        :type path: typing.Optional[str]
        :param index: array index of the property drive. Defaults to -1 for all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :rtype: 'FCurve'
        :return: The driver(s) added.
        """
        ...

    def driver_remove(
        self, path: typing.Optional[str], index: typing.Optional[int] = -1
    ) -> bool:
        """Remove driver(s) from the given property

        :param path: path to the property to drive, analogous to the fcurve's data path.
        :type path: typing.Optional[str]
        :param index: array index of the property drive. Defaults to -1 for all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :rtype: bool
        :return: Success of driver removal.
        """
        ...

    def get(
        self, key: typing.Optional[str], default: typing.Optional[typing.Any] = None
    ):
        """Returns the value of the custom property assigned to key or default
        when not found (matches Python's dictionary function of the same name).

                :param key: The key associated with the custom property.
                :type key: typing.Optional[str]
                :param default: Optional argument for the value to return if
        key is not found.
                :type default: typing.Optional[typing.Any]
        """
        ...

    def id_properties_clear(self):
        """

        :return: Remove the parent group for an RNA struct's custom IDProperties.
        """
        ...

    def id_properties_ensure(self) -> typing.Any:
        """

        :rtype: typing.Any
        :return: the parent group for an RNA struct's custom IDProperties.
        """
        ...

    def id_properties_ui(self, key) -> typing.Any:
        """

        :param key: String name of the property.
        :type key:
        :rtype: typing.Any
        :return: Return an object used to manage an IDProperty's UI data.
        """
        ...

    def is_property_hidden(self, property) -> bool:
        """Check if a property is hidden.

        :param property:
        :type property:
        :rtype: bool
        :return: True when the property is hidden.
        """
        ...

    def is_property_overridable_library(self, property) -> bool:
        """Check if a property is overridable.

        :param property:
        :type property:
        :rtype: bool
        :return: True when the property is overridable.
        """
        ...

    def is_property_readonly(self, property) -> bool:
        """Check if a property is readonly.

        :param property:
        :type property:
        :rtype: bool
        :return: True when the property is readonly (not writable).
        """
        ...

    def is_property_set(self, property, ghost: typing.Optional[bool] = True) -> bool:
        """Check if a property is set, use for testing operator properties.

                :param property:
                :type property:
                :param ghost: Used for operators that re-run with previous settings.
        In this case the property is not marked as set,
        yet the value from the previous execution is used.

        In rare cases you may want to set this option to false.
                :type ghost: typing.Optional[bool]
                :rtype: bool
                :return: True when the property has been set.
        """
        ...

    def items(self) -> typing.Any:
        """Returns the items of this objects custom properties (matches Python's
        dictionary function of the same name).

                :rtype: typing.Any
                :return: custom property key, value pairs.
        """
        ...

    def keyframe_delete(
        self,
        data_path: typing.Optional[str],
        index: typing.Optional[int] = -1,
        frame: typing.Optional[float] = None,
        group: typing.Optional[str] = "",
    ) -> bool:
        """Remove a keyframe from this properties fcurve.

        :param data_path: path to the property to remove a key, analogous to the fcurve's data path.
        :type data_path: typing.Optional[str]
        :param index: array index of the property to remove a key. Defaults to -1 removing all indices or a single channel if the property is not an array.
        :type index: typing.Optional[int]
        :param frame: The frame on which the keyframe is deleted, defaulting to the current frame.
        :type frame: typing.Optional[float]
        :param group: The name of the group the F-Curve should be added to if it doesn't exist yet.
        :type group: typing.Optional[str]
        :rtype: bool
        :return: Success of keyframe deletion.
        """
        ...

    def keyframe_insert(
        self,
        data_path: typing.Optional[str],
        index: typing.Optional[int] = -1,
        frame: typing.Optional[float] = None,
        group: typing.Optional[str] = "",
        options=None(),
    ) -> bool:
        """Insert a keyframe on the property given, adding fcurves and animation data when necessary.This is the most simple example of inserting a keyframe from python.Note that when keying data paths which contain nested properties this must be
        done from the `ID` subclass, in this case the `Armature` rather
        than the bone.

                :param data_path: path to the property to key, analogous to the fcurve's data path.
                :type data_path: typing.Optional[str]
                :param index: array index of the property to key.
        Defaults to -1 which will key all indices or a single channel if the property is not an array.
                :type index: typing.Optional[int]
                :param frame: The frame on which the keyframe is inserted, defaulting to the current frame.
                :type frame: typing.Optional[float]
                :param group: The name of the group the F-Curve should be added to if it doesn't exist yet.
                :type group: typing.Optional[str]
                :param options: Optional set of flags:

        INSERTKEY_NEEDED Only insert keyframes where they're needed in the relevant F-Curves.

        INSERTKEY_VISUAL Insert keyframes based on 'visual transforms'.

        INSERTKEY_XYZ_TO_RGB Color for newly added transformation F-Curves (Location, Rotation, Scale) is based on the transform axis.

        INSERTKEY_REPLACE Only replace already existing keyframes.

        INSERTKEY_AVAILABLE Only insert into already existing F-Curves.

        INSERTKEY_CYCLE_AWARE Take cyclic extrapolation into account (Cycle-Aware Keying option).
                :type options:
                :rtype: bool
                :return: Success of keyframe insertion.
        """
        ...

    def keys(self) -> typing.Any:
        """Returns the keys of this objects custom properties (matches Python's
        dictionary function of the same name).

                :rtype: typing.Any
                :return: custom property keys.
        """
        ...

    def path_from_id(self, property: typing.Optional[str] = "") -> str:
        """Returns the data path from the ID to this object (string).

                :param property: Optional property name which can be used if the path is
        to a property of this object.
                :type property: typing.Optional[str]
                :rtype: str
                :return: The path from `bpy.types.bpy_struct.id_data`
        to this struct and property (when given).
        """
        ...

    def path_resolve(
        self, path: typing.Optional[str], coerce: typing.Optional[bool] = True
    ):
        """Returns the property from the path, raise an exception when not found.

                :param path: path which this property resolves.
                :type path: typing.Optional[str]
                :param coerce: optional argument, when True, the property will be converted
        into its Python representation.
                :type coerce: typing.Optional[bool]
        """
        ...

    def pop(
        self, key: typing.Optional[str], default: typing.Optional[typing.Any] = None
    ):
        """Remove and return the value of the custom property assigned to key or default
        when not found (matches Python's dictionary function of the same name).

                :param key: The key associated with the custom property.
                :type key: typing.Optional[str]
                :param default: Optional argument for the value to return if
        key is not found.
                :type default: typing.Optional[typing.Any]
        """
        ...

    def property_overridable_library_set(self, property, overridable) -> bool:
        """Define a property as overridable or not (only for custom properties!).

        :param property:
        :type property:
        :param overridable:
        :type overridable:
        :rtype: bool
        :return: True when the overridable status of the property was successfully set.
        """
        ...

    def property_unset(self, property):
        """Unset a property, will use default value afterward.

        :param property:
        :type property:
        """
        ...

    def type_recast(self) -> "bpy_struct":
        """Return a new instance, this is needed because types
        such as textures can be changed at runtime.

                :rtype: 'bpy_struct'
                :return: a new instance of this object with the type initialized again.
        """
        ...

    def values(self) -> typing.Any:
        """Returns the values of this objects custom properties (matches Python's
        dictionary function of the same name).

                :rtype: typing.Any
                :return: custom property values.
        """
        ...

    def __getitem__(self, key: typing.Optional[typing.Union[int, str]]) -> "typing.Any":
        """

        :param key:
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'typing.Any'
        """
        ...

    def __setitem__(
        self, key: typing.Optional[typing.Union[int, str]], value: "typing.Any"
    ):
        """

        :param key:
        :type key: typing.Optional[typing.Union[int, str]]
        :param value:
        :type value: 'typing.Any'
        """
        ...

    def __delitem__(self, key: typing.Optional[typing.Union[int, str]]) -> "typing.Any":
        """

        :param key:
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'typing.Any'
        """
        ...

class bpy_prop_array(typing.Generic[GenericType]):
    def foreach_get(self, attr, seq): ...
    def foreach_set(self, attr, seq): ...
    def __getitem__(
        self, key: typing.Optional[typing.Union[int, str]]
    ) -> "GenericType":
        """

        :param key:
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'GenericType'
        """
        ...

    def __setitem__(
        self, key: typing.Optional[typing.Union[int, str]], value: "GenericType"
    ):
        """

        :param key:
        :type key: typing.Optional[typing.Union[int, str]]
        :param value:
        :type value: 'GenericType'
        """
        ...

    def __delitem__(
        self, key: typing.Optional[typing.Union[int, str]]
    ) -> "GenericType":
        """

        :param key:
        :type key: typing.Optional[typing.Union[int, str]]
        :rtype: 'GenericType'
        """
        ...

    def __iter__(self) -> typing.Iterator["GenericType"]:
        """

        :rtype: typing.Iterator['GenericType']
        """
        ...

    def __next__(self) -> "GenericType":
        """

        :rtype: 'GenericType'
        """
        ...

    def __len__(self) -> int:
        """

        :rtype: int
        """
        ...

class AOV(bpy_struct):
    is_valid: bool
    """ Is the name of the AOV conflicting

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Name of the AOV

    :type: typing.Union[str, typing.Any]
    """

    type: typing.Union[int, str]
    """ Data type of the AOV

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ActionGroup(bpy_struct):
    """Groups of F-Curves"""

    channels: bpy_prop_collection["FCurve"]
    """ F-Curves in this group

    :type: bpy_prop_collection['FCurve']
    """

    color_set: typing.Union[int, str]
    """ Custom color set to use

    :type: typing.Union[int, str]
    """

    colors: "ThemeBoneColorSet"
    """ Copy of the colors associated with the group's color set

    :type: 'ThemeBoneColorSet'
    """

    is_custom_color_set: typing.Union[bool, typing.Any]
    """ Color set is user-defined instead of a fixed theme color set

    :type: typing.Union[bool, typing.Any]
    """

    lock: bool
    """ Action group is locked

    :type: bool
    """

    mute: bool
    """ Action group is muted

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    select: bool
    """ Action group is selected

    :type: bool
    """

    show_expanded: bool
    """ Action group is expanded except in graph editor

    :type: bool
    """

    show_expanded_graph: bool
    """ Action group is expanded in graph editor

    :type: bool
    """

    use_pin: bool
    """ 

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Addon(bpy_struct):
    """Python add-ons to be loaded automatically"""

    module: typing.Union[str, typing.Any]
    """ Module name

    :type: typing.Union[str, typing.Any]
    """

    preferences: "AddonPreferences"
    """ 

    :type: 'AddonPreferences'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AddonPreferences(bpy_struct):
    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    layout: "UILayout"
    """ 

    :type: 'UILayout'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AnimData(bpy_struct):
    """Animation data for data-block"""

    action: "Action"
    """ Active Action for this data-block

    :type: 'Action'
    """

    action_blend_type: typing.Union[int, str]
    """ Method used for combining Active Action's result with result of NLA stack

    :type: typing.Union[int, str]
    """

    action_extrapolation: typing.Union[int, str]
    """ Action to take for gaps past the Active Action's range (when evaluating with NLA)

    :type: typing.Union[int, str]
    """

    action_influence: float
    """ Amount the Active Action contributes to the result of the NLA stack

    :type: float
    """

    action_tweak_storage: "Action"
    """ Slot to temporarily hold the main action while in tweak mode

    :type: 'Action'
    """

    drivers: "AnimDataDrivers"
    """ The Drivers/Expressions for this data-block

    :type: 'AnimDataDrivers'
    """

    nla_tracks: "NlaTracks"
    """ NLA Tracks (i.e. Animation Layers)

    :type: 'NlaTracks'
    """

    use_nla: bool
    """ NLA stack is evaluated when evaluating this block

    :type: bool
    """

    use_pin: bool
    """ 

    :type: bool
    """

    use_tweak_mode: bool
    """ Whether to enable or disable tweak mode in NLA

    :type: bool
    """

    def nla_tweak_strip_time_to_scene(
        self,
        frame: typing.Optional[float],
        invert: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> float:
        """Convert a time value from the local time of the tweaked strip to scene time, exactly as done by built-in key editing tools. Returns the input time unchanged if not tweaking.

        :param frame: Input time
        :type frame: typing.Optional[float]
        :param invert: Invert, Convert scene time to action time
        :type invert: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: float
        :return: Converted time
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AnimViz(bpy_struct):
    """Settings for the visualization of motion"""

    motion_path: "AnimVizMotionPaths"
    """ Motion Path settings for visualization

    :type: 'AnimVizMotionPaths'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AnimVizMotionPaths(bpy_struct):
    """Motion Path settings for animation visualization"""

    bake_location: typing.Union[int, str]
    """ When calculating Bone Paths, use Head or Tips

    :type: typing.Union[int, str]
    """

    frame_after: int
    """ Number of frames to show after the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    """

    frame_before: int
    """ Number of frames to show before the current frame (only for 'Around Current Frame' Onion-skinning method)

    :type: int
    """

    frame_end: int
    """ End frame of range of paths to display/calculate (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    """

    frame_start: int
    """ Starting frame of range of paths to display/calculate (not for 'Around Current Frame' Onion-skinning method)

    :type: int
    """

    frame_step: int
    """ Number of frames between paths shown (not for 'On Keyframes' Onion-skinning method)

    :type: int
    """

    has_motion_paths: typing.Union[bool, typing.Any]
    """ Are there any bone paths that will need updating (read-only)

    :type: typing.Union[bool, typing.Any]
    """

    range: typing.Union[int, str]
    """ Type of range to calculate for Motion Paths

    :type: typing.Union[int, str]
    """

    show_frame_numbers: bool
    """ Show frame numbers on Motion Paths

    :type: bool
    """

    show_keyframe_action_all: bool
    """ For bone motion paths, search whole Action for keyframes instead of in group with matching name only (is slower)

    :type: bool
    """

    show_keyframe_highlight: bool
    """ Emphasize position of keyframes on Motion Paths

    :type: bool
    """

    show_keyframe_numbers: bool
    """ Show frame numbers of Keyframes on Motion Paths

    :type: bool
    """

    type: typing.Union[int, str]
    """ Type of range to show for Motion Paths

    :type: typing.Union[int, str]
    """

    use_camera_space_bake: bool
    """ Motion path points will be baked into the camera space of the active camera. This means they will only look right when looking through that camera. Switching cameras using markers is not supported

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AnyType(bpy_struct):
    """RNA type used for pointers to any possible data"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Area(bpy_struct):
    """Area in a subdivided screen, containing an editor"""

    height: int
    """ Area height

    :type: int
    """

    regions: bpy_prop_collection["Region"]
    """ Regions this area is subdivided in

    :type: bpy_prop_collection['Region']
    """

    show_menus: bool
    """ Show menus in the header

    :type: bool
    """

    spaces: "AreaSpaces"
    """ Spaces contained in this area, the first being the active space (NOTE: Useful for example to restore a previously used 3D view space in a certain area to get the old view orientation)

    :type: 'AreaSpaces'
    """

    type: typing.Union[int, str]
    """ Current editor type for this area

    :type: typing.Union[int, str]
    """

    ui_type: typing.Union[int, str]
    """ Current editor type for this area

    :type: typing.Union[int, str]
    """

    width: int
    """ Area width

    :type: int
    """

    x: int
    """ The window relative vertical location of the area

    :type: int
    """

    y: int
    """ The window relative horizontal location of the area

    :type: int
    """

    def tag_redraw(self):
        """tag_redraw"""
        ...

    def header_text_set(self, text: typing.Optional[str]):
        """Set the header status text

        :param text: Text, New string for the header, None clears the text
        :type text: typing.Optional[str]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetCatalogPath(bpy_struct):
    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetLibraryReference(bpy_struct):
    """Identifier to refer to the asset library"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetMetaData(bpy_struct):
    """Additional data stored for an asset data-block"""

    active_tag: int
    """ Index of the tag set for editing

    :type: int
    """

    author: typing.Union[str, typing.Any]
    """ Name of the creator of the asset

    :type: typing.Union[str, typing.Any]
    """

    catalog_id: typing.Union[str, typing.Any]
    """ Identifier for the asset's catalog, used by Blender to look up the asset's catalog path. Must be a UUID according to RFC4122

    :type: typing.Union[str, typing.Any]
    """

    catalog_simple_name: typing.Union[str, typing.Any]
    """ Simple name of the asset's catalog, for debugging and data recovery purposes

    :type: typing.Union[str, typing.Any]
    """

    copyright: typing.Union[str, typing.Any]
    """ Copyright notice for this asset. An empty copyright notice does not necessarily indicate that this is copyright-free. Contact the author if any clarification is needed

    :type: typing.Union[str, typing.Any]
    """

    description: typing.Union[str, typing.Any]
    """ A description of the asset to be displayed for the user

    :type: typing.Union[str, typing.Any]
    """

    license: typing.Union[str, typing.Any]
    """ The type of license this asset is distributed under. An empty license name does not necessarily indicate that this is free of licensing terms. Contact the author if any clarification is needed

    :type: typing.Union[str, typing.Any]
    """

    tags: "AssetTags"
    """ Custom tags (name tokens) for the asset, used for filtering and general asset management

    :type: 'AssetTags'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetRepresentation(bpy_struct):
    """Information about an entity that makes it possible for the asset system to deal with the entity as asset"""

    full_library_path: typing.Union[str, typing.Any]
    """ Absolute path to the .blend file containing this asset

    :type: typing.Union[str, typing.Any]
    """

    full_path: typing.Union[str, typing.Any]
    """ Absolute path to the .blend file containing this asset extended with the path of the asset inside the file

    :type: typing.Union[str, typing.Any]
    """

    id_type: typing.Any
    """ The type of the data-block, if the asset represents one ('NONE' otherwise)

    :type: typing.Any
    """

    local_id: "ID"
    """ The local data-block this asset represents; only valid if that is a data-block in this file

    :type: 'ID'
    """

    metadata: "AssetMetaData"
    """ Additional information about the asset

    :type: 'AssetMetaData'
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetShelf(bpy_struct):
    """Regions for quick access to assets"""

    asset_library_reference: typing.Union[int, str]
    """ Choose the asset library to display assets from

    :type: typing.Union[int, str]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the asset gets a custom ID, otherwise it takes the name of the class used to define the asset (for example, if the class name is "OBJECT_AST_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_AST_hello")

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Options for this asset shelf type

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    bl_space_type: typing.Union[int, str]
    """ The space where the asset shelf is going to be used in

    :type: typing.Union[int, str]
    """

    preview_size: int
    """ Size of the asset preview thumbnails in pixels

    :type: int
    """

    search_filter: typing.Union[str, typing.Any]
    """ Filter assets by name

    :type: typing.Union[str, typing.Any]
    """

    show_names: bool
    """ Show the asset name together with the preview. Otherwise only the preview will be visible

    :type: bool
    """

    def poll(self, context: typing.Optional["Context"]) -> bool:
        """If this method returns a non-null output, the asset shelf will be visible

        :param context:
        :type context: typing.Optional['Context']
        :rtype: bool
        """
        ...

    def asset_poll(self, asset: typing.Optional["AssetRepresentation"]) -> bool:
        """Determine if an asset should be visible in the asset shelf. If this method returns a non-null output, the asset will be visible

        :param asset:
        :type asset: typing.Optional['AssetRepresentation']
        :rtype: bool
        """
        ...

    def draw_context_menu(
        self,
        context: typing.Optional["Context"],
        asset: typing.Optional["AssetRepresentation"],
        layout: typing.Optional["UILayout"],
    ):
        """Draw UI elements into the context menu UI layout displayed on right click

        :param context:
        :type context: typing.Optional['Context']
        :param asset:
        :type asset: typing.Optional['AssetRepresentation']
        :param layout:
        :type layout: typing.Optional['UILayout']
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetTag(bpy_struct):
    """User defined tag (name token)"""

    name: typing.Union[str, typing.Any]
    """ The identifier that makes up this tag

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class AssetWeakReference(bpy_struct):
    """Weak reference to some asset"""

    asset_library_identifier: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    asset_library_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    relative_asset_identifier: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Attribute(bpy_struct):
    """Geometry attribute"""

    data_type: typing.Any
    """ Type of data stored in attribute

    :type: typing.Any
    """

    domain: typing.Any
    """ Domain of the Attribute

    :type: typing.Any
    """

    is_internal: typing.Union[bool, typing.Any]
    """ The attribute is meant for internal use by Blender

    :type: typing.Union[bool, typing.Any]
    """

    is_required: typing.Union[bool, typing.Any]
    """ Whether the attribute can be removed or renamed

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Name of the Attribute

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BakeSettings(bpy_struct):
    """Bake data for a Scene data-block"""

    cage_extrusion: float
    """ Inflate the active object by the specified distance for baking. This helps matching to points nearer to the outside of the selected object meshes

    :type: float
    """

    cage_object: "Object"
    """ Object to use as cage instead of calculating the cage from the active object with cage extrusion

    :type: 'Object'
    """

    filepath: typing.Union[str, typing.Any]
    """ Image filepath to use when saving externally

    :type: typing.Union[str, typing.Any]
    """

    height: int
    """ Vertical dimension of the baking map

    :type: int
    """

    image_settings: "ImageFormatSettings"
    """ 

    :type: 'ImageFormatSettings'
    """

    margin: int
    """ Extends the baked result as a post process filter

    :type: int
    """

    margin_type: typing.Union[int, str]
    """ Algorithm to extend the baked result

    :type: typing.Union[int, str]
    """

    max_ray_distance: float
    """ The maximum ray distance for matching points between the active and selected objects. If zero, there is no limit

    :type: float
    """

    normal_b: typing.Union[int, str]
    """ Axis to bake in blue channel

    :type: typing.Union[int, str]
    """

    normal_g: typing.Union[int, str]
    """ Axis to bake in green channel

    :type: typing.Union[int, str]
    """

    normal_r: typing.Union[int, str]
    """ Axis to bake in red channel

    :type: typing.Union[int, str]
    """

    normal_space: typing.Union[int, str]
    """ Choose normal space for baking

    :type: typing.Union[int, str]
    """

    pass_filter: typing.Any
    """ Passes to include in the active baking pass

    :type: typing.Any
    """

    save_mode: typing.Union[int, str]
    """ Where to save baked image textures

    :type: typing.Union[int, str]
    """

    target: typing.Union[int, str]
    """ Where to output the baked map

    :type: typing.Union[int, str]
    """

    use_automatic_name: bool
    """ Automatically name the output file with the pass type (external only)

    :type: bool
    """

    use_cage: bool
    """ Cast rays to active object from a cage

    :type: bool
    """

    use_clear: bool
    """ Clear Images before baking (internal only)

    :type: bool
    """

    use_pass_color: bool
    """ Color the pass

    :type: bool
    """

    use_pass_diffuse: bool
    """ Add diffuse contribution

    :type: bool
    """

    use_pass_direct: bool
    """ Add direct lighting contribution

    :type: bool
    """

    use_pass_emit: bool
    """ Add emission contribution

    :type: bool
    """

    use_pass_glossy: bool
    """ Add glossy contribution

    :type: bool
    """

    use_pass_indirect: bool
    """ Add indirect lighting contribution

    :type: bool
    """

    use_pass_transmission: bool
    """ Add transmission contribution

    :type: bool
    """

    use_selected_to_active: bool
    """ Bake shading on the surface of selected objects to the active object

    :type: bool
    """

    use_split_materials: bool
    """ Split external images per material (external only)

    :type: bool
    """

    view_from: typing.Union[int, str]
    """ Source of reflection ray directions

    :type: typing.Union[int, str]
    """

    width: int
    """ Horizontal dimension of the baking map

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BezierSplinePoint(bpy_struct):
    """Bézier curve point with two handles"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Coordinates of the control point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_left: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Coordinates of the first handle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_left_type: typing.Union[int, str]
    """ Handle types

    :type: typing.Union[int, str]
    """

    handle_right: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Coordinates of the second handle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_right_type: typing.Union[int, str]
    """ Handle types

    :type: typing.Union[int, str]
    """

    hide: bool
    """ Visibility status

    :type: bool
    """

    radius: float
    """ Radius for beveling

    :type: float
    """

    select_control_point: bool
    """ Control point selection status

    :type: bool
    """

    select_left_handle: bool
    """ Handle 1 selection status

    :type: bool
    """

    select_right_handle: bool
    """ Handle 2 selection status

    :type: bool
    """

    tilt: float
    """ Tilt in 3D View

    :type: float
    """

    weight_softbody: float
    """ Softbody goal weight

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BlendData(bpy_struct):
    """Main data structure representing a .blend file and all its data-blocks"""

    actions: "BlendDataActions"
    """ Action data-blocks

    :type: 'BlendDataActions'
    """

    armatures: "BlendDataArmatures"
    """ Armature data-blocks

    :type: 'BlendDataArmatures'
    """

    brushes: "BlendDataBrushes"
    """ Brush data-blocks

    :type: 'BlendDataBrushes'
    """

    cache_files: "BlendDataCacheFiles"
    """ Cache Files data-blocks

    :type: 'BlendDataCacheFiles'
    """

    cameras: "BlendDataCameras"
    """ Camera data-blocks

    :type: 'BlendDataCameras'
    """

    collections: "BlendDataCollections"
    """ Collection data-blocks

    :type: 'BlendDataCollections'
    """

    curves: "BlendDataCurves"
    """ Curve data-blocks

    :type: 'BlendDataCurves'
    """

    filepath: typing.Union[str, typing.Any]
    """ Path to the .blend file

    :type: typing.Union[str, typing.Any]
    """

    fonts: "BlendDataFonts"
    """ Vector font data-blocks

    :type: 'BlendDataFonts'
    """

    grease_pencils: "BlendDataGreasePencils"
    """ Grease Pencil data-blocks

    :type: 'BlendDataGreasePencils'
    """

    grease_pencils_v3: "BlendDataGreasePencilsV3"
    """ Grease Pencil v3 data-blocks

    :type: 'BlendDataGreasePencilsV3'
    """

    hair_curves: "BlendDataHairCurves"
    """ Hair curve data-blocks

    :type: 'BlendDataHairCurves'
    """

    images: "BlendDataImages"
    """ Image data-blocks

    :type: 'BlendDataImages'
    """

    is_dirty: typing.Union[bool, typing.Any]
    """ Have recent edits been saved to disk

    :type: typing.Union[bool, typing.Any]
    """

    is_saved: typing.Union[bool, typing.Any]
    """ Has the current session been saved to disk as a .blend file

    :type: typing.Union[bool, typing.Any]
    """

    lattices: "BlendDataLattices"
    """ Lattice data-blocks

    :type: 'BlendDataLattices'
    """

    libraries: "BlendDataLibraries"
    """ Library data-blocks

    :type: 'BlendDataLibraries'
    """

    lightprobes: "BlendDataProbes"
    """ Light Probe data-blocks

    :type: 'BlendDataProbes'
    """

    lights: "BlendDataLights"
    """ Light data-blocks

    :type: 'BlendDataLights'
    """

    linestyles: "BlendDataLineStyles"
    """ Line Style data-blocks

    :type: 'BlendDataLineStyles'
    """

    masks: "BlendDataMasks"
    """ Masks data-blocks

    :type: 'BlendDataMasks'
    """

    materials: "BlendDataMaterials"
    """ Material data-blocks

    :type: 'BlendDataMaterials'
    """

    meshes: "BlendDataMeshes"
    """ Mesh data-blocks

    :type: 'BlendDataMeshes'
    """

    metaballs: "BlendDataMetaBalls"
    """ Metaball data-blocks

    :type: 'BlendDataMetaBalls'
    """

    movieclips: "BlendDataMovieClips"
    """ Movie Clip data-blocks

    :type: 'BlendDataMovieClips'
    """

    node_groups: "BlendDataNodeTrees"
    """ Node group data-blocks

    :type: 'BlendDataNodeTrees'
    """

    objects: "BlendDataObjects"
    """ Object data-blocks

    :type: 'BlendDataObjects'
    """

    paint_curves: "BlendDataPaintCurves"
    """ Paint Curves data-blocks

    :type: 'BlendDataPaintCurves'
    """

    palettes: "BlendDataPalettes"
    """ Palette data-blocks

    :type: 'BlendDataPalettes'
    """

    particles: "BlendDataParticles"
    """ Particle data-blocks

    :type: 'BlendDataParticles'
    """

    pointclouds: "BlendDataPointClouds"
    """ Point cloud data-blocks

    :type: 'BlendDataPointClouds'
    """

    scenes: "BlendDataScenes"
    """ Scene data-blocks

    :type: 'BlendDataScenes'
    """

    screens: "BlendDataScreens"
    """ Screen data-blocks

    :type: 'BlendDataScreens'
    """

    shape_keys: bpy_prop_collection["Key"]
    """ Shape Key data-blocks

    :type: bpy_prop_collection['Key']
    """

    sounds: "BlendDataSounds"
    """ Sound data-blocks

    :type: 'BlendDataSounds'
    """

    speakers: "BlendDataSpeakers"
    """ Speaker data-blocks

    :type: 'BlendDataSpeakers'
    """

    texts: "BlendDataTexts"
    """ Text data-blocks

    :type: 'BlendDataTexts'
    """

    textures: "BlendDataTextures"
    """ Texture data-blocks

    :type: 'BlendDataTextures'
    """

    use_autopack: bool
    """ Automatically pack all external data into .blend file

    :type: bool
    """

    version: bpy_prop_array[int]
    """ File format version the .blend file was saved with

    :type: bpy_prop_array[int]
    """

    volumes: "BlendDataVolumes"
    """ Volume data-blocks

    :type: 'BlendDataVolumes'
    """

    window_managers: "BlendDataWindowManagers"
    """ Window manager data-blocks

    :type: 'BlendDataWindowManagers'
    """

    workspaces: "BlendDataWorkSpaces"
    """ Workspace data-blocks

    :type: 'BlendDataWorkSpaces'
    """

    worlds: "BlendDataWorlds"
    """ World data-blocks

    :type: 'BlendDataWorlds'
    """

    def batch_remove(self, ids):
        """Remove (delete) several IDs at once.WARNING: Considered experimental feature currently.Note that this function is quicker than individual calls to `remove()` (from `bpy.types.BlendData`
        ID collections), but less safe/versatile (it can break Blender, e.g. by removing all scenes...).

                :param ids: Iterables of IDs (types can be mixed).
                :type ids:
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

    def orphans_purge(self):
        """Remove (delete) all IDs with no user.

        :return: The number of deleted IDs.
        """
        ...

    def temp_data(
        self, filepath: typing.Optional[typing.Union[bytes, str]] = None
    ) -> "BlendData":
        """A context manager that temporarily creates blender file data.

        :param filepath: The file path for the newly temporary data. When None, the path of the currently open file is used.
        :type filepath: typing.Optional[typing.Union[bytes, str]]
        :rtype: 'BlendData'
        :return: Blend file data which is freed once the context exists.
        """
        ...

    def user_map(
        self,
        subset: typing.Optional[typing.Sequence],
        key_types: typing.Optional[typing.Set[str]],
        value_types: typing.Optional[typing.Set[str]],
    ) -> typing.Dict:
        """Returns a mapping of all ID data-blocks in current bpy.data to a set of all datablocks using them.For list of valid set members for key_types & value_types, see: `bpy.types.KeyingSetPath.id_type`.

        :param subset: When passed, only these data-blocks and their users will be included as keys/values in the map.
        :type subset: typing.Optional[typing.Sequence]
        :param key_types: Filter the keys mapped by ID types.
        :type key_types: typing.Optional[typing.Set[str]]
        :param value_types: Filter the values in the set by ID types.
        :type value_types: typing.Optional[typing.Set[str]]
        :rtype: typing.Dict
        :return: dictionary of `bpy.types.ID` instances, with sets of ID's as their values.
        """
        ...

class BlenderRNA(bpy_struct):
    """Blender RNA structure definitions"""

    structs: bpy_prop_collection["Struct"]
    """ 

    :type: bpy_prop_collection['Struct']
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoidRule(bpy_struct):
    name: typing.Union[str, typing.Any]
    """ Boid rule name

    :type: typing.Union[str, typing.Any]
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    use_in_air: bool
    """ Use rule when boid is flying

    :type: bool
    """

    use_on_land: bool
    """ Use rule when boid is on land

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoidSettings(bpy_struct):
    """Settings for boid physics"""

    accuracy: float
    """ Accuracy of attack

    :type: float
    """

    active_boid_state: "BoidRule"
    """ 

    :type: 'BoidRule'
    """

    active_boid_state_index: int
    """ 

    :type: int
    """

    aggression: float
    """ Boid will fight this times stronger enemy

    :type: float
    """

    air_acc_max: float
    """ Maximum acceleration in air (relative to maximum speed)

    :type: float
    """

    air_ave_max: float
    """ Maximum angular velocity in air (relative to 180 degrees)

    :type: float
    """

    air_personal_space: float
    """ Radius of boids personal space in air (% of particle size)

    :type: float
    """

    air_speed_max: float
    """ Maximum speed in air

    :type: float
    """

    air_speed_min: float
    """ Minimum speed in air (relative to maximum speed)

    :type: float
    """

    bank: float
    """ Amount of rotation around velocity vector on turns

    :type: float
    """

    health: float
    """ Initial boid health when born

    :type: float
    """

    height: float
    """ Boid height relative to particle size

    :type: float
    """

    land_acc_max: float
    """ Maximum acceleration on land (relative to maximum speed)

    :type: float
    """

    land_ave_max: float
    """ Maximum angular velocity on land (relative to 180 degrees)

    :type: float
    """

    land_jump_speed: float
    """ Maximum speed for jumping

    :type: float
    """

    land_personal_space: float
    """ Radius of boids personal space on land (% of particle size)

    :type: float
    """

    land_smooth: float
    """ How smoothly the boids land

    :type: float
    """

    land_speed_max: float
    """ Maximum speed on land

    :type: float
    """

    land_stick_force: float
    """ How strong a force must be to start effecting a boid on land

    :type: float
    """

    pitch: float
    """ Amount of rotation around side vector

    :type: float
    """

    range: float
    """ Maximum distance from which a boid can attack

    :type: float
    """

    states: bpy_prop_collection["BoidState"]
    """ 

    :type: bpy_prop_collection['BoidState']
    """

    strength: float
    """ Maximum caused damage on attack per second

    :type: float
    """

    use_climb: bool
    """ Allow boids to climb goal objects

    :type: bool
    """

    use_flight: bool
    """ Allow boids to move in air

    :type: bool
    """

    use_land: bool
    """ Allow boids to move on land

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoidState(bpy_struct):
    """Boid state for boid physics"""

    active_boid_rule: "BoidRule"
    """ 

    :type: 'BoidRule'
    """

    active_boid_rule_index: int
    """ 

    :type: int
    """

    falloff: float
    """ 

    :type: float
    """

    name: typing.Union[str, typing.Any]
    """ Boid state name

    :type: typing.Union[str, typing.Any]
    """

    rule_fuzzy: float
    """ 

    :type: float
    """

    rules: bpy_prop_collection["BoidRule"]
    """ 

    :type: bpy_prop_collection['BoidRule']
    """

    ruleset_type: typing.Union[int, str]
    """ How the rules in the list are evaluated

    :type: typing.Union[int, str]
    """

    volume: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Bone(bpy_struct):
    """Bone in an Armature data-block"""

    bbone_curveinx: float
    """ X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveinz: float
    """ Z-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutx: float
    """ X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutz: float
    """ Z-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_custom_handle_end: "Bone"
    """ Bone that serves as the end handle for the B-Bone curve

    :type: 'Bone'
    """

    bbone_custom_handle_start: "Bone"
    """ Bone that serves as the start handle for the B-Bone curve

    :type: 'Bone'
    """

    bbone_easein: float
    """ Length of first Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_easeout: float
    """ Length of second Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_handle_type_end: typing.Union[int, str]
    """ Selects how the end handle of the B-Bone is computed

    :type: typing.Union[int, str]
    """

    bbone_handle_type_start: typing.Union[int, str]
    """ Selects how the start handle of the B-Bone is computed

    :type: typing.Union[int, str]
    """

    bbone_handle_use_ease_end: bool
    """ Multiply the B-Bone Ease Out channel by the local Y scale value of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    """

    bbone_handle_use_ease_start: bool
    """ Multiply the B-Bone Ease In channel by the local Y scale value of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    """

    bbone_handle_use_scale_end: typing.List[bool]
    """ Multiply B-Bone Scale Out channels by the local scale values of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    """

    bbone_handle_use_scale_start: typing.List[bool]
    """ Multiply B-Bone Scale In channels by the local scale values of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    """

    bbone_mapping_mode: typing.Union[int, str]
    """ Selects how the vertices are mapped to B-Bone segments based on their position

    :type: typing.Union[int, str]
    """

    bbone_rollin: float
    """ Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    """

    bbone_rollout: float
    """ Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    """

    bbone_scalein: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale factors for the start of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bbone_scaleout: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale factors for the end of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bbone_segments: int
    """ Number of subdivisions of bone (for B-Bones only)

    :type: int
    """

    bbone_x: float
    """ B-Bone X size

    :type: float
    """

    bbone_z: float
    """ B-Bone Z size

    :type: float
    """

    children: bpy_prop_collection["Bone"]
    """ Bones which are children of this bone

    :type: bpy_prop_collection['Bone']
    """

    collections: "BoneCollectionMemberships"
    """ Bone Collections that contain this bone

    :type: 'BoneCollectionMemberships'
    """

    color: "BoneColor"
    """ 

    :type: 'BoneColor'
    """

    envelope_distance: float
    """ Bone deformation distance (for Envelope deform only)

    :type: float
    """

    envelope_weight: float
    """ Bone deformation weight (for Envelope deform only)

    :type: float
    """

    head: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of head end of the bone relative to its parent

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    head_local: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of head end of the bone relative to armature

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    head_radius: float
    """ Radius of head of bone (for Envelope deform only)

    :type: float
    """

    hide: bool
    """ Bone is not visible when it is not in Edit Mode (i.e. in Object or Pose Modes)

    :type: bool
    """

    hide_select: bool
    """ Bone is able to be selected

    :type: bool
    """

    inherit_scale: typing.Union[int, str]
    """ Specifies how the bone inherits scaling from the parent bone

    :type: typing.Union[int, str]
    """

    length: float
    """ Length of the bone

    :type: float
    """

    matrix: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
        ],
    ]
    """ 3×3 bone matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]]]
    """

    matrix_local: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ 4×4 bone matrix relative to armature

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    parent: "Bone"
    """ Parent bone (in same Armature)

    :type: 'Bone'
    """

    select: bool
    """ 

    :type: bool
    """

    select_head: bool
    """ 

    :type: bool
    """

    select_tail: bool
    """ 

    :type: bool
    """

    show_wire: bool
    """ Bone is always displayed in wireframe regardless of viewport shading mode (useful for non-obstructive custom bone shapes)

    :type: bool
    """

    tail: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of tail end of the bone relative to its parent

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    tail_local: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of tail end of the bone relative to armature

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    tail_radius: float
    """ Radius of tail of bone (for Envelope deform only)

    :type: float
    """

    use_connect: typing.Union[bool, typing.Any]
    """ When bone has a parent, bone's head is stuck to the parent's tail

    :type: typing.Union[bool, typing.Any]
    """

    use_cyclic_offset: bool
    """ When bone doesn't have a parent, it receives cyclic offset effects (Deprecated)

    :type: bool
    """

    use_deform: bool
    """ Enable Bone to deform geometry

    :type: bool
    """

    use_endroll_as_inroll: bool
    """ Add Roll Out of the Start Handle bone to the Roll In value

    :type: bool
    """

    use_envelope_multiply: bool
    """ When deforming bone, multiply effects of Vertex Group weights with Envelope influence

    :type: bool
    """

    use_inherit_rotation: bool
    """ Bone inherits rotation or scale from parent bone

    :type: bool
    """

    use_local_location: bool
    """ Bone location is set in local space

    :type: bool
    """

    use_relative_parent: bool
    """ Object children will use relative transform, like deform

    :type: bool
    """

    use_scale_easing: bool
    """ Multiply the final easing values by the Scale In/Out Y factors

    :type: bool
    """

    basename: typing.Any
    """ The name of this bone before any '.' character(readonly)"""

    center: typing.Any
    """ The midpoint between the head and the tail.(readonly)"""

    children_recursive: typing.Any
    """ A list of all children from this bone.(readonly)"""

    children_recursive_basename: typing.Any
    """ Returns a chain of children with the same base name as this bone.
Only direct chains are supported, forks caused by multiple children
with matching base names will terminate the function
and not be returned.(readonly)"""

    parent_recursive: typing.Any
    """ A list of parents, starting with the immediate parent(readonly)"""

    vector: typing.Any
    """ The direction this bone is pointing.
Utility function for (tail - head)(readonly)"""

    x_axis: typing.Any
    """ Vector pointing down the x-axis of the bone.(readonly)"""

    y_axis: typing.Any
    """ Vector pointing down the y-axis of the bone.(readonly)"""

    z_axis: typing.Any
    """ Vector pointing down the z-axis of the bone.(readonly)"""

    def evaluate_envelope(
        self,
        point: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
    ) -> float:
        """Calculate bone envelope at given point

        :param point: Point, Position in 3d space to evaluate
        :type point: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
        :rtype: float
        :return: Factor, Envelope factor
        """
        ...

    def convert_local_to_pose(
        self,
        matrix: typing.Optional[
            typing.Union[
                "mathutils.Matrix",
                typing.List[typing.List[float]],
                typing.Tuple[
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                ],
            ]
        ],
        matrix_local: typing.Optional[
            typing.Union[
                "mathutils.Matrix",
                typing.List[typing.List[float]],
                typing.Tuple[
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                ],
            ]
        ],
        parent_matrix: typing.Optional[typing.Any] = (
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
        ),
        parent_matrix_local: typing.Optional[typing.Any] = (
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
            (0.0, 0.0, 0.0, 0.0),
        ),
        invert: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]:
        """Transform a matrix from Local to Pose space (or back), taking into account options like Inherit Scale and Local Location. Unlike Object.convert_space, this uses custom rest and pose matrices provided by the caller. If the parent matrices are omitted, the bone is assumed to have no parent.This method enables conversions between Local and Pose space for bones in
        the middle of updating the armature without having to update dependencies
        after each change, by manually carrying updated matrices in a recursive walk.

                :param matrix: The matrix to transform
                :type matrix: typing.Optional[typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]]
                :param matrix_local: The custom rest matrix of this bone (Bone.matrix_local)
                :type matrix_local: typing.Optional[typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]]
                :param parent_matrix: The custom pose matrix of the parent bone (PoseBone.matrix)
                :type parent_matrix: typing.Optional[typing.Any]
                :param parent_matrix_local: The custom rest matrix of the parent bone (Bone.matrix_local)
                :type parent_matrix_local: typing.Optional[typing.Any]
                :param invert: Convert from Pose to Local space
                :type invert: typing.Optional[typing.Union[bool, typing.Any]]
                :rtype: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
                :return: The transformed matrix
        """
        ...

    def MatrixFromAxisRoll(
        self, axis: typing.Any, roll: typing.Optional[float]
    ) -> typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
        ],
    ]:
        """Convert the axis + roll representation to a matrix

        :param axis: The main axis of the bone (tail - head)
        :type axis: typing.Any
        :param roll: The roll of the bone
        :type roll: typing.Optional[float]
        :rtype: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]]]
        :return: The resulting orientation matrix
        """
        ...

    def AxisRollFromMatrix(
        self, matrix: typing.Any, axis: typing.Optional[typing.Any] = (0.0, 0.0, 0.0)
    ):
        """Convert a rotational matrix to the axis + roll representation. Note that the resulting value of the roll may not be as expected if the matrix has shear or negative determinant.

                :param matrix: The orientation matrix of the bone
                :type matrix: typing.Any
                :param axis: The optional override for the axis (finds closest approximation for the matrix)
                :type axis: typing.Optional[typing.Any]
                :return: result_axis, The main axis of the bone, `mathutils.Vector` of 3 items in [-inf, inf]

        result_roll, The roll of the bone, float in [-inf, inf]
        """
        ...

    def parent_index(self, parent_test):
        """The same as 'bone in other_bone.parent_recursive'
        but saved generating a list.

                :param parent_test:
                :type parent_test:
        """
        ...

    def translate(self, vec):
        """Utility function to add vec to the head and tail of this bone

        :param vec:
        :type vec:
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoneCollection(bpy_struct):
    """Bone collection in an Armature data-block"""

    bones: bpy_prop_collection["Bone"]
    """ Bones assigned to this bone collection. In armature edit mode this will always return an empty list of bones, as the bone collection memberships are only synchronized when exiting edit mode

    :type: bpy_prop_collection['Bone']
    """

    child_number: int
    """ Index of this collection into its parent's list of children. Note that finding this index requires a scan of all the bone collections, so do access this with care

    :type: int
    """

    children: bpy_prop_collection["BoneCollection"]
    """ 

    :type: bpy_prop_collection['BoneCollection']
    """

    index: int
    """ Index of this bone collection in the armature.collections_all array. Note that finding this index requires a scan of all the bone collections, so do access this with care

    :type: int
    """

    is_editable: typing.Union[bool, typing.Any]
    """ This collection is owned by a local Armature, or was added via a library override in the current blend file

    :type: typing.Union[bool, typing.Any]
    """

    is_expanded: bool
    """ This bone collection is expanded in the bone collections tree view

    :type: bool
    """

    is_local_override: typing.Union[bool, typing.Any]
    """ This collection was added via a library override in the current blend file

    :type: typing.Union[bool, typing.Any]
    """

    is_solo: bool
    """ Show only this bone collection, and others also marked as 'solo'

    :type: bool
    """

    is_visible: bool
    """ Bones in this collection will be visible in pose/object mode

    :type: bool
    """

    is_visible_ancestors: typing.Union[bool, typing.Any]
    """ True when all of the ancestors of this bone collection are marked as visible; always True for root bone collections

    :type: typing.Union[bool, typing.Any]
    """

    is_visible_effectively: typing.Union[bool, typing.Any]
    """ Whether this bone collection is effectively visible in the viewport. This is True when this bone collection and all of its ancestors are visible, or when it is marked as 'solo'

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Unique within the Armature

    :type: typing.Union[str, typing.Any]
    """

    parent: "BoneCollection"
    """ Parent bone collection. Note that accessing this requires a scan of all the bone collections to find the parent

    :type: 'BoneCollection'
    """

    bones_recursive: typing.Any
    """ A set of all bones assigned to this bone collection and its child collections.(readonly)"""

    def assign(self, bone: typing.Optional[typing.Any]) -> bool:
        """Assign the given bone to this collection

        :param bone: Bone to assign to this collection. This must be a Bone, PoseBone, or EditBone
        :type bone: typing.Optional[typing.Any]
        :rtype: bool
        :return: Assigned, Whether the bone was actually assigned; will be false if the bone was already member of the collection
        """
        ...

    def unassign(self, bone: typing.Optional[typing.Any]) -> bool:
        """Remove the given bone from this collection

        :param bone: Bone to remove from this collection. This must be a Bone, PoseBone, or EditBone
        :type bone: typing.Optional[typing.Any]
        :rtype: bool
        :return: Unassigned, Whether the bone was actually removed; will be false if the bone was not a member of the collection to begin with
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoneCollections(bpy_struct):
    """The Bone Collections of this Armature"""

    active: "BoneCollection"
    """ Armature's active bone collection

    :type: 'BoneCollection'
    """

    active_index: int
    """ The index of the Armature's active bone collection; -1 when there is no active collection. Note that this is indexing the underlying array of bone collections, which may not be in the order you expect. Root collections are listed first, and siblings are always sequential. Apart from that, bone collections can be in any order, and thus incrementing or decrementing this index can make the active bone collection jump around in unexpected ways. For a more predictable interface, use active or active_name

    :type: int
    """

    active_name: typing.Union[str, typing.Any]
    """ The name of the Armature's active bone collection; empty when there is no active collection

    :type: typing.Union[str, typing.Any]
    """

    is_solo_active: typing.Union[bool, typing.Any]
    """ Read-ony flag that indicates there is at least one bone collection marked as 'solo'

    :type: typing.Union[bool, typing.Any]
    """

    def new(
        self,
        name: typing.Union[str, typing.Any],
        parent: typing.Optional["BoneCollection"] = None,
    ) -> "BoneCollection":
        """Add a new empty bone collection to the armature

        :param name: Name, Name of the new collection. Blender will ensure it is unique within the collections of the Armature
        :type name: typing.Union[str, typing.Any]
        :param parent: Parent Collection, If not None, the new bone collection becomes a child of this collection
        :type parent: typing.Optional['BoneCollection']
        :rtype: 'BoneCollection'
        :return: Newly created bone collection
        """
        ...

    def remove(self, bone_collection: typing.Optional["BoneCollection"]):
        """Remove the bone collection from the armature. If this bone collection has any children, they will be reassigned to their grandparent; in other words, the children will take the place of the removed bone collection

        :param bone_collection: Bone Collection, The bone collection to remove
        :type bone_collection: typing.Optional['BoneCollection']
        """
        ...

    def move(self, from_index: typing.Optional[int], to_index: typing.Optional[int]):
        """Move a bone collection to a different position in the collection list. This can only be used to reorder siblings, and not to change parent-child relationships

        :param from_index: From Index, Index to move
        :type from_index: typing.Optional[int]
        :param to_index: To Index, Target index
        :type to_index: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoneColor(bpy_struct):
    """Theme color or custom color of a bone"""

    custom: "ThemeBoneColorSet"
    """ The custom bone colors, used when palette is 'CUSTOM'

    :type: 'ThemeBoneColorSet'
    """

    is_custom: typing.Union[bool, typing.Any]
    """ A color palette is user-defined, instead of using a theme-defined one

    :type: typing.Union[bool, typing.Any]
    """

    palette: typing.Union[int, str]
    """ Color palette to use

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BoolAttributeValue(bpy_struct):
    """Bool value in geometry attribute"""

    value: bool
    """ 

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushCapabilities(bpy_struct):
    """Read-only indications of supported operations"""

    has_overlay: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_random_texture_angle: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_smooth_stroke: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_spacing: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushCapabilitiesImagePaint(bpy_struct):
    """Read-only indications of supported operations"""

    has_accumulate: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_color: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_radius: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_space_attenuation: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushCapabilitiesSculpt(bpy_struct):
    """Read-only indications of which brush operations are supported by the current sculpt tool"""

    has_accumulate: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_auto_smooth: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_color: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_direction: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_gravity: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_height: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_jitter: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_normal_weight: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_persistence: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_pinch_factor: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_plane_offset: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_rake_factor: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_random_texture_angle: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_sculpt_plane: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_secondary_color: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_smooth_stroke: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_space_attenuation: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_strength_pressure: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_tilt: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    has_topology_rake: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushCapabilitiesVertexPaint(bpy_struct):
    """Read-only indications of supported operations"""

    has_color: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushCapabilitiesWeightPaint(bpy_struct):
    """Read-only indications of supported operations"""

    has_weight: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushCurvesSculptSettings(bpy_struct):
    add_amount: int
    """ Number of curves added by the Add brush

    :type: int
    """

    curve_length: float
    """ Length of newly added curves when it is not interpolated from other curves

    :type: float
    """

    curve_parameter_falloff: "CurveMapping"
    """ Falloff that is applied from the tip to the root of each curve

    :type: 'CurveMapping'
    """

    density_add_attempts: int
    """ How many times the Density brush tries to add a new curve

    :type: int
    """

    density_mode: typing.Union[int, str]
    """ Determines whether the brush adds or removes curves

    :type: typing.Union[int, str]
    """

    interpolate_length: bool
    """ Use length of the curves in close proximity

    :type: bool
    """

    interpolate_point_count: bool
    """ Use the number of points from the curves in close proximity

    :type: bool
    """

    interpolate_shape: bool
    """ Use shape of the curves in close proximity

    :type: bool
    """

    minimum_distance: float
    """ Goal distance between curve roots for the Density brush

    :type: float
    """

    minimum_length: float
    """ Avoid shrinking curves shorter than this length

    :type: float
    """

    points_per_curve: int
    """ Number of control points in a newly added curve

    :type: int
    """

    scale_uniform: bool
    """ Grow or shrink curves by changing their size uniformly instead of using trimming or extrapolation

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class BrushGpencilSettings(bpy_struct):
    """Settings for grease pencil brush"""

    active_smooth_factor: float
    """ Amount of smoothing while drawing

    :type: float
    """

    angle: float
    """ Direction of the stroke at which brush gives maximal thickness (0° for horizontal)

    :type: float
    """

    angle_factor: float
    """ Reduce brush thickness by this factor when stroke is perpendicular to 'Angle' direction

    :type: float
    """

    aspect: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    brush_draw_mode: typing.Union[int, str]
    """ Preselected mode when using this brush

    :type: typing.Union[int, str]
    """

    caps_type: typing.Union[int, str]
    """ The shape of the start and end of the stroke

    :type: typing.Union[int, str]
    """

    curve_jitter: "CurveMapping"
    """ Curve used for the jitter effect

    :type: 'CurveMapping'
    """

    curve_random_hue: "CurveMapping"
    """ Curve used for modulating effect

    :type: 'CurveMapping'
    """

    curve_random_pressure: "CurveMapping"
    """ Curve used for modulating effect

    :type: 'CurveMapping'
    """

    curve_random_saturation: "CurveMapping"
    """ Curve used for modulating effect

    :type: 'CurveMapping'
    """

    curve_random_strength: "CurveMapping"
    """ Curve used for modulating effect

    :type: 'CurveMapping'
    """

    curve_random_uv: "CurveMapping"
    """ Curve used for modulating effect

    :type: 'CurveMapping'
    """

    curve_random_value: "CurveMapping"
    """ Curve used for modulating effect

    :type: 'CurveMapping'
    """

    curve_sensitivity: "CurveMapping"
    """ Curve used for the sensitivity

    :type: 'CurveMapping'
    """

    curve_strength: "CurveMapping"
    """ Curve used for the strength

    :type: 'CurveMapping'
    """

    dilate: int
    """ Number of pixels to expand or contract fill area

    :type: int
    """

    direction: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    eraser_mode: typing.Union[int, str]
    """ Eraser Mode

    :type: typing.Union[int, str]
    """

    eraser_strength_factor: float
    """ Amount of erasing for strength

    :type: float
    """

    eraser_thickness_factor: float
    """ Amount of erasing for thickness

    :type: float
    """

    extend_stroke_factor: float
    """ Strokes end extension for closing gaps, use zero to disable

    :type: float
    """

    fill_direction: typing.Union[int, str]
    """ Direction of the fill

    :type: typing.Union[int, str]
    """

    fill_draw_mode: typing.Union[int, str]
    """ Mode to draw boundary limits

    :type: typing.Union[int, str]
    """

    fill_extend_mode: typing.Union[int, str]
    """ Types of stroke extensions used for closing gaps

    :type: typing.Union[int, str]
    """

    fill_factor: float
    """ Factor for fill boundary accuracy, higher values are more accurate but slower

    :type: float
    """

    fill_layer_mode: typing.Union[int, str]
    """ Layers used as boundaries

    :type: typing.Union[int, str]
    """

    fill_simplify_level: int
    """ Number of simplify steps (large values reduce fill accuracy)

    :type: int
    """

    fill_threshold: float
    """ Threshold to consider color transparent for filling

    :type: float
    """

    gpencil_paint_icon: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    gpencil_sculpt_icon: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    gpencil_vertex_icon: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    gpencil_weight_icon: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    hardness: float
    """ Gradient from the center of Dot and Box strokes (set to 1 for a solid stroke)

    :type: float
    """

    input_samples: int
    """ Generate intermediate points for very fast mouse movements. Set to 0 to disable

    :type: int
    """

    material: "Material"
    """ Material used for strokes drawn using this brush

    :type: 'Material'
    """

    material_alt: "Material"
    """ Material used for secondary uses for this brush

    :type: 'Material'
    """

    outline_thickness_factor: float
    """ Thickness of the outline stroke relative to current brush thickness

    :type: float
    """

    pen_jitter: float
    """ Jitter factor for new strokes

    :type: float
    """

    pen_smooth_factor: float
    """ Amount of smoothing to apply after finish newly created strokes, to reduce jitter/noise

    :type: float
    """

    pen_smooth_steps: int
    """ Number of times to smooth newly created strokes

    :type: int
    """

    pen_strength: float
    """ Color strength for new strokes (affect alpha factor of color)

    :type: float
    """

    pen_subdivision_steps: int
    """ Number of times to subdivide newly created strokes, for less jagged strokes

    :type: int
    """

    pin_draw_mode: bool
    """ Pin the mode to the brush

    :type: bool
    """

    random_hue_factor: float
    """ Random factor to modify original hue

    :type: float
    """

    random_pressure: float
    """ Randomness factor for pressure in new strokes

    :type: float
    """

    random_saturation_factor: float
    """ Random factor to modify original saturation

    :type: float
    """

    random_strength: float
    """ Randomness factor strength in new strokes

    :type: float
    """

    random_value_factor: float
    """ Random factor to modify original value

    :type: float
    """

    show_fill: bool
    """ Show transparent lines to use as boundary for filling

    :type: bool
    """

    show_fill_boundary: bool
    """ Show help lines for filling to see boundaries

    :type: bool
    """

    show_fill_extend: bool
    """ Show help lines for stroke extension

    :type: bool
    """

    show_lasso: bool
    """ Do not display fill color while drawing the stroke

    :type: bool
    """

    simplify_factor: float
    """ Factor of Simplify using adaptive algorithm

    :type: float
    """

    use_active_layer_only: bool
    """ Only edit the active layer of the object

    :type: bool
    """

    use_collide_strokes: bool
    """ Check if extend lines collide with strokes

    :type: bool
    """

    use_default_eraser: bool
    """ Use this brush when enable eraser with fast switch key

    :type: bool
    """

    use_edit_position: bool
    """ The brush affects the position of the point

    :type: bool
    """

    use_edit_strength: bool
    """ The brush affects the color strength of the point

    :type: bool
    """

    use_edit_thickness: bool
    """ The brush affects the thickness of the point

    :type: bool
    """

    use_edit_uv: bool
    """ The brush affects the UV rotation of the point

    :type: bool
    """

    use_fill_limit: bool
    """ Fill only visible areas in viewport

    :type: bool
    """

    use_jitter_pressure: bool
    """ Use tablet pressure for jitter

    :type: bool
    """

    use_keep_caps_eraser: bool
    """ Keep the caps as they are and don't flatten them when erasing

    :type: bool
    """

    use_material_pin: bool
    """ Keep material assigned to brush

    :type: bool
    """

    use_occlude_eraser: bool
    """ Erase only strokes visible and not occluded

    :type: bool
    """

    use_pressure: bool
    """ Use tablet pressure

    :type: bool
    """

    use_random_press_hue: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_radius: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_sat: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_strength: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_uv: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_random_press_val: bool
    """ Use pressure to modulate randomness

    :type: bool
    """

    use_settings_outline: bool
    """ Convert stroke to perimeter

    :type: bool
    """

    use_settings_postprocess: bool
    """ Additional post processing options for new strokes

    :type: bool
    """

    use_settings_random: bool
    """ Random brush settings

    :type: bool
    """

    use_settings_stabilizer: bool
    """ Draw lines with a delay to allow smooth strokes. Press Shift key to override while drawing

    :type: bool
    """

    use_strength_pressure: bool
    """ Use tablet pressure for color strength

    :type: bool
    """

    use_stroke_random_hue: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_radius: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_sat: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_strength: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_uv: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_stroke_random_val: bool
    """ Use randomness at stroke level

    :type: bool
    """

    use_trim: bool
    """ Trim intersecting stroke ends

    :type: bool
    """

    uv_random: float
    """ Random factor for auto-generated UV rotation

    :type: float
    """

    vertex_color_factor: float
    """ Factor used to mix vertex color to get final color

    :type: float
    """

    vertex_mode: typing.Union[int, str]
    """ Defines how vertex color affect to the strokes

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ByteColorAttributeValue(bpy_struct):
    """Color value in geometry attribute"""

    color: bpy_prop_array[float]
    """ RGBA color in scene linear color space

    :type: bpy_prop_array[float]
    """

    color_srgb: bpy_prop_array[float]
    """ RGBA color in sRGB color space

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ByteIntAttributeValue(bpy_struct):
    """8-bit value in geometry attribute"""

    value: int
    """ 

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CacheFileLayer(bpy_struct):
    """Layer of the cache, used to load or override data from the first the first layer"""

    filepath: typing.Union[str, typing.Any]
    """ Path to the archive

    :type: typing.Union[str, typing.Any]
    """

    hide_layer: bool
    """ Do not load data from this layer

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CacheObjectPath(bpy_struct):
    """Path of an object inside of an Alembic archive"""

    path: typing.Union[str, typing.Any]
    """ Object path

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CameraBackgroundImage(bpy_struct):
    """Image and settings for display in the 3D View background"""

    alpha: float
    """ Image opacity to blend the image against the background color

    :type: float
    """

    clip: "MovieClip"
    """ Movie clip displayed and edited in this space

    :type: 'MovieClip'
    """

    clip_user: "MovieClipUser"
    """ Parameters defining which frame of the movie clip is displayed

    :type: 'MovieClipUser'
    """

    display_depth: typing.Union[int, str]
    """ Display under or over everything

    :type: typing.Union[int, str]
    """

    frame_method: typing.Union[int, str]
    """ How the image fits in the camera frame

    :type: typing.Union[int, str]
    """

    image: "Image"
    """ Image displayed and edited in this space

    :type: 'Image'
    """

    image_user: "ImageUser"
    """ Parameters defining which layer, pass and frame of the image is displayed

    :type: 'ImageUser'
    """

    is_override_data: typing.Union[bool, typing.Any]
    """ In a local override camera, whether this background image comes from the linked reference camera, or is local to the override

    :type: typing.Union[bool, typing.Any]
    """

    offset: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    rotation: float
    """ Rotation for the background image (ortho view only)

    :type: float
    """

    scale: float
    """ Scale the background image

    :type: float
    """

    show_background_image: bool
    """ Show this image as background

    :type: bool
    """

    show_expanded: bool
    """ Show the details in the user interface

    :type: bool
    """

    show_on_foreground: bool
    """ Show this image in front of objects in viewport

    :type: bool
    """

    source: typing.Union[int, str]
    """ Data source used for background

    :type: typing.Union[int, str]
    """

    use_camera_clip: bool
    """ Use movie clip from active scene camera

    :type: bool
    """

    use_flip_x: bool
    """ Flip the background image horizontally

    :type: bool
    """

    use_flip_y: bool
    """ Flip the background image vertically

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CameraDOFSettings(bpy_struct):
    """Depth of Field settings"""

    aperture_blades: int
    """ Number of blades in aperture for polygonal bokeh (at least 3)

    :type: int
    """

    aperture_fstop: float
    """ F-Stop ratio (lower numbers give more defocus, higher numbers give a sharper image)

    :type: float
    """

    aperture_ratio: float
    """ Distortion to simulate anamorphic lens bokeh

    :type: float
    """

    aperture_rotation: float
    """ Rotation of blades in aperture

    :type: float
    """

    focus_distance: float
    """ Distance to the focus point for depth of field

    :type: float
    """

    focus_object: "Object"
    """ Use this object to define the depth of field focal point

    :type: 'Object'
    """

    focus_subtarget: typing.Union[str, typing.Any]
    """ Use this armature bone to define the depth of field focal point

    :type: typing.Union[str, typing.Any]
    """

    use_dof: bool
    """ Use Depth of Field

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CameraStereoData(bpy_struct):
    """Stereoscopy settings for a Camera data-block"""

    convergence_distance: float
    """ The converge point for the stereo cameras (often the distance between a projector and the projection screen)

    :type: float
    """

    convergence_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    interocular_distance: float
    """ Set the distance between the eyes - the stereo plane distance / 30 should be fine

    :type: float
    """

    pivot: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    pole_merge_angle_from: float
    """ Angle at which interocular distance starts to fade to 0

    :type: float
    """

    pole_merge_angle_to: float
    """ Angle at which interocular distance is 0

    :type: float
    """

    use_pole_merge: bool
    """ Fade interocular distance to 0 after the given cutoff angle

    :type: bool
    """

    use_spherical_stereo: bool
    """ Render every pixel rotating the camera around the middle of the interocular distance

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ChildParticle(bpy_struct):
    """Child particle interpolated from simulated or edited particles"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ClothCollisionSettings(bpy_struct):
    """Cloth simulation settings for self collision and collision with other objects"""

    collection: "Collection"
    """ Limit colliders to this Collection

    :type: 'Collection'
    """

    collision_quality: int
    """ How many collision iterations should be done. (higher is better quality but slower)

    :type: int
    """

    damping: float
    """ Amount of velocity lost on collision

    :type: float
    """

    distance_min: float
    """ Minimum distance between collision objects before collision response takes effect

    :type: float
    """

    friction: float
    """ Friction force if a collision happened (higher = less movement)

    :type: float
    """

    impulse_clamp: float
    """ Clamp collision impulses to avoid instability (0.0 to disable clamping)

    :type: float
    """

    self_distance_min: float
    """ Minimum distance between cloth faces before collision response takes effect

    :type: float
    """

    self_friction: float
    """ Friction with self contact

    :type: float
    """

    self_impulse_clamp: float
    """ Clamp collision impulses to avoid instability (0.0 to disable clamping)

    :type: float
    """

    use_collision: bool
    """ Enable collisions with other objects

    :type: bool
    """

    use_self_collision: bool
    """ Enable self collisions

    :type: bool
    """

    vertex_group_object_collisions: typing.Union[str, typing.Any]
    """ Triangles with all vertices in this group are not used during object collisions

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_self_collisions: typing.Union[str, typing.Any]
    """ Triangles with all vertices in this group are not used during self collisions

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ClothSettings(bpy_struct):
    """Cloth simulation settings for an object"""

    air_damping: float
    """ Air has normally some thickness which slows falling things down

    :type: float
    """

    bending_damping: float
    """ Amount of damping in bending behavior

    :type: float
    """

    bending_model: typing.Union[int, str]
    """ Physical model for simulating bending forces

    :type: typing.Union[int, str]
    """

    bending_stiffness: float
    """ How much the material resists bending

    :type: float
    """

    bending_stiffness_max: float
    """ Maximum bending stiffness value

    :type: float
    """

    collider_friction: float
    """ 

    :type: float
    """

    compression_damping: float
    """ Amount of damping in compression behavior

    :type: float
    """

    compression_stiffness: float
    """ How much the material resists compression

    :type: float
    """

    compression_stiffness_max: float
    """ Maximum compression stiffness value

    :type: float
    """

    density_strength: float
    """ Influence of target density on the simulation

    :type: float
    """

    density_target: float
    """ Maximum density of hair

    :type: float
    """

    effector_weights: "EffectorWeights"
    """ 

    :type: 'EffectorWeights'
    """

    fluid_density: float
    """ Density (kg/l) of the fluid contained inside the object, used to create a hydrostatic pressure gradient simulating the weight of the internal fluid, or buoyancy from the surrounding fluid if negative

    :type: float
    """

    goal_default: float
    """ Default Goal (vertex target position) value, when no Vertex Group used

    :type: float
    """

    goal_friction: float
    """ Goal (vertex target position) friction

    :type: float
    """

    goal_max: float
    """ Goal maximum, vertex group weights are scaled to match this range

    :type: float
    """

    goal_min: float
    """ Goal minimum, vertex group weights are scaled to match this range

    :type: float
    """

    goal_spring: float
    """ Goal (vertex target position) spring stiffness

    :type: float
    """

    gravity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Gravity or external force vector

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    internal_compression_stiffness: float
    """ How much the material resists compression

    :type: float
    """

    internal_compression_stiffness_max: float
    """ Maximum compression stiffness value

    :type: float
    """

    internal_friction: float
    """ 

    :type: float
    """

    internal_spring_max_diversion: float
    """ How much the rays used to connect the internal points can diverge from the vertex normal

    :type: float
    """

    internal_spring_max_length: float
    """ The maximum length an internal spring can have during creation. If the distance between internal points is greater than this, no internal spring will be created between these points. A length of zero means that there is no length limit

    :type: float
    """

    internal_spring_normal_check: bool
    """ Require the points the internal springs connect to have opposite normal directions

    :type: bool
    """

    internal_tension_stiffness: float
    """ How much the material resists stretching

    :type: float
    """

    internal_tension_stiffness_max: float
    """ Maximum tension stiffness value

    :type: float
    """

    mass: float
    """ The mass of each vertex on the cloth material

    :type: float
    """

    pin_stiffness: float
    """ Pin (vertex target position) spring stiffness

    :type: float
    """

    pressure_factor: float
    """ Ambient pressure (kPa) that balances out between the inside and outside of the object when it has the target volume

    :type: float
    """

    quality: int
    """ Quality of the simulation in steps per frame (higher is better quality but slower)

    :type: int
    """

    rest_shape_key: "ShapeKey"
    """ Shape key to use the rest spring lengths from

    :type: 'ShapeKey'
    """

    sewing_force_max: float
    """ Maximum sewing force

    :type: float
    """

    shear_damping: float
    """ Amount of damping in shearing behavior

    :type: float
    """

    shear_stiffness: float
    """ How much the material resists shearing

    :type: float
    """

    shear_stiffness_max: float
    """ Maximum shear scaling value

    :type: float
    """

    shrink_max: float
    """ Max amount to shrink cloth by

    :type: float
    """

    shrink_min: float
    """ Factor by which to shrink cloth

    :type: float
    """

    target_volume: float
    """ The mesh volume where the inner/outer pressure will be the same. If set to zero the change in volume will not affect pressure

    :type: float
    """

    tension_damping: float
    """ Amount of damping in stretching behavior

    :type: float
    """

    tension_stiffness: float
    """ How much the material resists stretching

    :type: float
    """

    tension_stiffness_max: float
    """ Maximum tension stiffness value

    :type: float
    """

    time_scale: float
    """ Cloth speed is multiplied by this value

    :type: float
    """

    uniform_pressure_force: float
    """ The uniform pressure that is constantly applied to the mesh, in units of Pressure Scale. Can be negative

    :type: float
    """

    use_dynamic_mesh: bool
    """ Make simulation respect deformations in the base mesh

    :type: bool
    """

    use_internal_springs: bool
    """ Simulate an internal volume structure by creating springs connecting the opposite sides of the mesh

    :type: bool
    """

    use_pressure: bool
    """ Simulate pressure inside a closed cloth mesh

    :type: bool
    """

    use_pressure_volume: bool
    """ Use the Target Volume parameter as the initial volume, instead of calculating it from the mesh itself

    :type: bool
    """

    use_sewing_springs: bool
    """ Pulls loose edges together

    :type: bool
    """

    vertex_group_bending: typing.Union[str, typing.Any]
    """ Vertex group for fine control over bending stiffness

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_intern: typing.Union[str, typing.Any]
    """ Vertex group for fine control over the internal spring stiffness

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_mass: typing.Union[str, typing.Any]
    """ Vertex Group for pinning of vertices

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_pressure: typing.Union[str, typing.Any]
    """ Vertex Group for where to apply pressure. Zero weight means no pressure while a weight of one means full pressure. Faces with a vertex that has zero weight will be excluded from the volume calculation

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_shear_stiffness: typing.Union[str, typing.Any]
    """ Vertex group for fine control over shear stiffness

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_shrink: typing.Union[str, typing.Any]
    """ Vertex Group for shrinking cloth

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_structural_stiffness: typing.Union[str, typing.Any]
    """ Vertex group for fine control over structural stiffness

    :type: typing.Union[str, typing.Any]
    """

    voxel_cell_size: float
    """ Size of the voxel grid cells for interaction effects

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ClothSolverResult(bpy_struct):
    """Result of cloth solver iteration"""

    avg_error: float
    """ Average error during substeps

    :type: float
    """

    avg_iterations: float
    """ Average iterations during substeps

    :type: float
    """

    max_error: float
    """ Maximum error during substeps

    :type: float
    """

    max_iterations: int
    """ Maximum iterations during substeps

    :type: int
    """

    min_error: float
    """ Minimum error during substeps

    :type: float
    """

    min_iterations: int
    """ Minimum iterations during substeps

    :type: int
    """

    status: typing.Any
    """ Status of the solver iteration

    :type: typing.Any
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CollectionChild(bpy_struct):
    """Child collection with its collection related settings"""

    light_linking: "CollectionLightLinking"
    """ Light linking settings of the collection object

    :type: 'CollectionLightLinking'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CollectionLightLinking(bpy_struct):
    """Light linking settings of objects and children collections of a collection"""

    link_state: typing.Union[int, str]
    """ Light or shadow receiving state of the object or collection

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CollectionObject(bpy_struct):
    """Object of a collection with its collection related settings"""

    light_linking: "CollectionLightLinking"
    """ Light linking settings of the collection

    :type: 'CollectionLightLinking'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CollisionSettings(bpy_struct):
    """Collision settings for object in physics simulation"""

    absorption: float
    """ How much of effector force gets lost during collision with this object (in percent)

    :type: float
    """

    cloth_friction: float
    """ Friction for cloth collisions

    :type: float
    """

    damping: float
    """ Amount of damping during collision

    :type: float
    """

    damping_factor: float
    """ Amount of damping during particle collision

    :type: float
    """

    damping_random: float
    """ Random variation of damping

    :type: float
    """

    friction_factor: float
    """ Amount of friction during particle collision

    :type: float
    """

    friction_random: float
    """ Random variation of friction

    :type: float
    """

    permeability: float
    """ Chance that the particle will pass through the mesh

    :type: float
    """

    stickiness: float
    """ Amount of stickiness to surface collision

    :type: float
    """

    thickness_inner: float
    """ Inner face thickness (only used by softbodies)

    :type: float
    """

    thickness_outer: float
    """ Outer face thickness

    :type: float
    """

    use: bool
    """ Enable this object as a collider for physics systems

    :type: bool
    """

    use_culling: bool
    """ Cloth collision acts with respect to the collider normals (improves penetration recovery)

    :type: bool
    """

    use_normal: bool
    """ Cloth collision impulses act in the direction of the collider normals (more reliable in some cases)

    :type: bool
    """

    use_particle_kill: bool
    """ Kill collided particles

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorManagedDisplaySettings(bpy_struct):
    """Color management specific to display device"""

    display_device: typing.Union[int, str]
    """ Display device name

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorManagedInputColorspaceSettings(bpy_struct):
    """Input color space settings"""

    is_data: bool
    """ Treat image as non-color data without color management, like normal or displacement maps

    :type: bool
    """

    name: typing.Union[int, str]
    """ Color space in the image file, to convert to and from when saving and loading the image

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorManagedSequencerColorspaceSettings(bpy_struct):
    """Input color space settings"""

    name: typing.Union[int, str]
    """ Color space that the sequencer operates in

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorManagedViewSettings(bpy_struct):
    """Color management settings used for displaying images on the display"""

    curve_mapping: "CurveMapping"
    """ Color curve mapping applied before display transform

    :type: 'CurveMapping'
    """

    exposure: float
    """ Exposure (stops) applied before display transform

    :type: float
    """

    gamma: float
    """ Amount of gamma modification applied after display transform

    :type: float
    """

    look: typing.Union[int, str]
    """ Additional transform applied before view transform for artistic needs

    :type: typing.Union[int, str]
    """

    use_curve_mapping: bool
    """ Use RGB curved for pre-display transformation

    :type: bool
    """

    use_hdr_view: bool
    """ Enable high dynamic range display in rendered viewport, uncapping display brightness. This requires a monitor with HDR support and a view transform designed for HDR. 'Filmic' and 'AgX' do not generate HDR colors

    :type: bool
    """

    view_transform: typing.Union[int, str]
    """ View used when converting image to a display space

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorMapping(bpy_struct):
    """Color mapping settings"""

    blend_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Blend color to mix with texture output color

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    blend_factor: float
    """ 

    :type: float
    """

    blend_type: typing.Union[int, str]
    """ Mode used to mix with texture output color

    :type: typing.Union[int, str]
    """

    brightness: float
    """ Adjust the brightness of the texture

    :type: float
    """

    color_ramp: "ColorRamp"
    """ 

    :type: 'ColorRamp'
    """

    contrast: float
    """ Adjust the contrast of the texture

    :type: float
    """

    saturation: float
    """ Adjust the saturation of colors in the texture

    :type: float
    """

    use_color_ramp: bool
    """ Toggle color ramp operations

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorRamp(bpy_struct):
    """Color ramp mapping a scalar value to a color"""

    color_mode: typing.Union[int, str]
    """ Set color mode to use for interpolation

    :type: typing.Union[int, str]
    """

    elements: "ColorRampElements"
    """ 

    :type: 'ColorRampElements'
    """

    hue_interpolation: typing.Union[int, str]
    """ Set color interpolation

    :type: typing.Union[int, str]
    """

    interpolation: typing.Union[int, str]
    """ Set interpolation between color stops

    :type: typing.Union[int, str]
    """

    def evaluate(self, position: typing.Optional[float]) -> bpy_prop_array[float]:
        """Evaluate Color Ramp

        :param position: Position, Evaluate Color Ramp at position
        :type position: typing.Optional[float]
        :rtype: bpy_prop_array[float]
        :return: Color, Color at given position
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ColorRampElement(bpy_struct):
    """Element defining a color at a position in the color ramp"""

    alpha: float
    """ Set alpha of selected color stop

    :type: float
    """

    color: bpy_prop_array[float]
    """ Set color of selected color stop

    :type: bpy_prop_array[float]
    """

    position: float
    """ Set position of selected color stop

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ConsoleLine(bpy_struct):
    """Input line for the interactive console"""

    body: typing.Union[str, typing.Any]
    """ Text in the line

    :type: typing.Union[str, typing.Any]
    """

    current_character: int
    """ 

    :type: int
    """

    type: typing.Union[int, str]
    """ Console line type when used in scrollback

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Constraint(bpy_struct):
    """Constraint modifying the transformation of objects and bones"""

    active: bool
    """ Constraint is the one being edited

    :type: bool
    """

    enabled: bool
    """ Use the results of this constraint

    :type: bool
    """

    error_location: float
    """ Amount of residual error in Blender space unit for constraints that work on position

    :type: float
    """

    error_rotation: float
    """ Amount of residual error in radians for constraints that work on orientation

    :type: float
    """

    influence: float
    """ Amount of influence constraint will have on the final solution

    :type: float
    """

    is_override_data: typing.Union[bool, typing.Any]
    """ In a local override object, whether this constraint comes from the linked reference object, or is local to the override

    :type: typing.Union[bool, typing.Any]
    """

    is_valid: typing.Union[bool, typing.Any]
    """ Constraint has valid settings and can be evaluated

    :type: typing.Union[bool, typing.Any]
    """

    mute: bool
    """ Enable/Disable Constraint

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Constraint name

    :type: typing.Union[str, typing.Any]
    """

    owner_space: typing.Union[int, str]
    """ Space that owner is evaluated in

    :type: typing.Union[int, str]
    """

    show_expanded: bool
    """ Constraint's panel is expanded in UI

    :type: bool
    """

    space_object: "Object"
    """ Object for Custom Space

    :type: 'Object'
    """

    space_subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target_space: typing.Union[int, str]
    """ Space that target is evaluated in

    :type: typing.Union[int, str]
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ConstraintTarget(bpy_struct):
    """Target object for multi-target constraints"""

    subtarget: typing.Union[str, typing.Any]
    """ Armature bone, mesh or lattice vertex group, ...

    :type: typing.Union[str, typing.Any]
    """

    target: "Object"
    """ Target object

    :type: 'Object'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ConstraintTargetBone(bpy_struct):
    """Target bone for multi-target constraints"""

    subtarget: typing.Union[str, typing.Any]
    """ Target armature bone

    :type: typing.Union[str, typing.Any]
    """

    target: "Object"
    """ Target armature

    :type: 'Object'
    """

    weight: float
    """ Blending weight of this bone

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Context(bpy_struct):
    """Current windowmanager and data context"""

    area: "Area"
    """ 

    :type: 'Area'
    """

    asset: "AssetRepresentation"
    """ 

    :type: 'AssetRepresentation'
    """

    blend_data: "BlendData"
    """ 

    :type: 'BlendData'
    """

    collection: "Collection"
    """ 

    :type: 'Collection'
    """

    engine: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    gizmo_group: "GizmoGroup"
    """ 

    :type: 'GizmoGroup'
    """

    layer_collection: "LayerCollection"
    """ 

    :type: 'LayerCollection'
    """

    mode: typing.Any
    """ 

    :type: typing.Any
    """

    preferences: "Preferences"
    """ 

    :type: 'Preferences'
    """

    region: "Region"
    """ 

    :type: 'Region'
    """

    region_data: "RegionView3D"
    """ 

    :type: 'RegionView3D'
    """

    scene: "Scene"
    """ 

    :type: 'Scene'
    """

    screen: "Screen"
    """ 

    :type: 'Screen'
    """

    space_data: "Space"
    """ The current space, may be None in background-mode, when the cursor is outside the window or when using menu-search

    :type: 'Space'
    """

    tool_settings: "ToolSettings"
    """ 

    :type: 'ToolSettings'
    """

    view_layer: "ViewLayer"
    """ 

    :type: 'ViewLayer'
    """

    window: "Window"
    """ 

    :type: 'Window'
    """

    window_manager: "WindowManager"
    """ 

    :type: 'WindowManager'
    """

    workspace: "WorkSpace"
    """ 

    :type: 'WorkSpace'
    """

    texture_slot: "TextureSlot"
    """ 

    :type: 'TextureSlot'
    """

    world: "World"
    """ 

    :type: 'World'
    """

    object: "Object"
    """ 

    :type: 'Object'
    """

    mesh: "Mesh"
    """ 

    :type: 'Mesh'
    """

    armature: "Armature"
    """ 

    :type: 'Armature'
    """

    lattice: "Lattice"
    """ 

    :type: 'Lattice'
    """

    curve: "Curve"
    """ 

    :type: 'Curve'
    """

    meta_ball: "MetaBall"
    """ 

    :type: 'MetaBall'
    """

    light: "Light"
    """ 

    :type: 'Light'
    """

    speaker: "Speaker"
    """ 

    :type: 'Speaker'
    """

    lightprobe: "LightProbe"
    """ 

    :type: 'LightProbe'
    """

    camera: "Camera"
    """ 

    :type: 'Camera'
    """

    material: "Material"
    """ 

    :type: 'Material'
    """

    material_slot: "MaterialSlot"
    """ 

    :type: 'MaterialSlot'
    """

    texture: "Texture"
    """ 

    :type: 'Texture'
    """

    texture_user: "ID"
    """ 

    :type: 'ID'
    """

    texture_user_property: "Property"
    """ 

    :type: 'Property'
    """

    texture_node: "Node"
    """ 

    :type: 'Node'
    """

    bone: "Bone"
    """ 

    :type: 'Bone'
    """

    edit_bone: "EditBone"
    """ 

    :type: 'EditBone'
    """

    pose_bone: "PoseBone"
    """ 

    :type: 'PoseBone'
    """

    particle_system: "ParticleSystem"
    """ 

    :type: 'ParticleSystem'
    """

    particle_system_editable: "ParticleSystem"
    """ 

    :type: 'ParticleSystem'
    """

    particle_settings: "ParticleSettings"
    """ 

    :type: 'ParticleSettings'
    """

    cloth: "ClothModifier"
    """ 

    :type: 'ClothModifier'
    """

    soft_body: "SoftBodyModifier"
    """ 

    :type: 'SoftBodyModifier'
    """

    fluid: typing.Any
    """ 

    :type: typing.Any
    """

    collision: "CollisionModifier"
    """ 

    :type: 'CollisionModifier'
    """

    brush: "Brush"
    """ 

    :type: 'Brush'
    """

    dynamic_paint: "DynamicPaintModifier"
    """ 

    :type: 'DynamicPaintModifier'
    """

    line_style: "FreestyleLineStyle"
    """ 

    :type: 'FreestyleLineStyle'
    """

    gpencil: "GreasePencil"
    """ 

    :type: 'GreasePencil'
    """

    grease_pencil: "GreasePencilv3"
    """ 

    :type: 'GreasePencilv3'
    """

    curves: "Curves"
    """ 

    :type: 'Curves'
    """

    pointcloud: "PointCloud"
    """ 

    :type: 'PointCloud'
    """

    volume: "Volume"
    """ 

    :type: 'Volume'
    """

    edit_movieclip: "MovieClip"
    """ 

    :type: 'MovieClip'
    """

    edit_mask: "Mask"
    """ 

    :type: 'Mask'
    """

    active_file: "FileSelectEntry"
    """ 

    :type: 'FileSelectEntry'
    """

    selected_files: typing.List["FileSelectEntry"]
    """ 

    :type: typing.List['FileSelectEntry']
    """

    asset_library_reference: "AssetLibraryReference"
    """ 

    :type: 'AssetLibraryReference'
    """

    selected_assets: typing.List["AssetRepresentation"]
    """ 

    :type: typing.List['AssetRepresentation']
    """

    id: "ID"
    """ 

    :type: 'ID'
    """

    selected_ids: typing.List["ID"]
    """ 

    :type: typing.List['ID']
    """

    edit_image: "Image"
    """ 

    :type: 'Image'
    """

    selected_nodes: typing.List["Node"]
    """ 

    :type: typing.List['Node']
    """

    active_node: "Node"
    """ 

    :type: 'Node'
    """

    visible_objects: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    selectable_objects: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    selected_objects: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    editable_objects: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    selected_editable_objects: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    objects_in_mode: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    objects_in_mode_unique_data: typing.List["Object"]
    """ 

    :type: typing.List['Object']
    """

    visible_bones: typing.List["EditBone"]
    """ 

    :type: typing.List['EditBone']
    """

    editable_bones: typing.List["EditBone"]
    """ 

    :type: typing.List['EditBone']
    """

    selected_bones: typing.List["EditBone"]
    """ 

    :type: typing.List['EditBone']
    """

    selected_editable_bones: typing.List["EditBone"]
    """ 

    :type: typing.List['EditBone']
    """

    visible_pose_bones: typing.List["PoseBone"]
    """ 

    :type: typing.List['PoseBone']
    """

    selected_pose_bones: typing.List["PoseBone"]
    """ 

    :type: typing.List['PoseBone']
    """

    selected_pose_bones_from_active_object: typing.List["PoseBone"]
    """ 

    :type: typing.List['PoseBone']
    """

    active_bone: "EditBone"
    """ 

    :type: 'EditBone'
    """

    active_pose_bone: "PoseBone"
    """ 

    :type: 'PoseBone'
    """

    active_object: "Object"
    """ 

    :type: 'Object'
    """

    edit_object: "Object"
    """ 

    :type: 'Object'
    """

    sculpt_object: "Object"
    """ 

    :type: 'Object'
    """

    vertex_paint_object: "Object"
    """ 

    :type: 'Object'
    """

    weight_paint_object: "Object"
    """ 

    :type: 'Object'
    """

    image_paint_object: "Object"
    """ 

    :type: 'Object'
    """

    particle_edit_object: "Object"
    """ 

    :type: 'Object'
    """

    pose_object: "Object"
    """ 

    :type: 'Object'
    """

    active_sequence_strip: "Sequence"
    """ 

    :type: 'Sequence'
    """

    sequences: typing.List["Sequence"]
    """ 

    :type: typing.List['Sequence']
    """

    selected_sequences: typing.List["Sequence"]
    """ 

    :type: typing.List['Sequence']
    """

    selected_editable_sequences: typing.List["Sequence"]
    """ 

    :type: typing.List['Sequence']
    """

    active_nla_track: "NlaTrack"
    """ 

    :type: 'NlaTrack'
    """

    active_nla_strip: "NlaStrip"
    """ 

    :type: 'NlaStrip'
    """

    selected_nla_strips: typing.List["NlaStrip"]
    """ 

    :type: typing.List['NlaStrip']
    """

    selected_movieclip_tracks: typing.List["MovieTrackingTrack"]
    """ 

    :type: typing.List['MovieTrackingTrack']
    """

    gpencil_data: "GreasePencil"
    """ 

    :type: 'GreasePencil'
    """

    gpencil_data_owner: "ID"
    """ 

    :type: 'ID'
    """

    annotation_data: "GreasePencil"
    """ 

    :type: 'GreasePencil'
    """

    annotation_data_owner: "ID"
    """ 

    :type: 'ID'
    """

    visible_gpencil_layers: typing.List["GPencilLayer"]
    """ 

    :type: typing.List['GPencilLayer']
    """

    editable_gpencil_layers: typing.List["GPencilLayer"]
    """ 

    :type: typing.List['GPencilLayer']
    """

    editable_gpencil_strokes: typing.List["GPencilStroke"]
    """ 

    :type: typing.List['GPencilStroke']
    """

    active_gpencil_layer: typing.List["GPencilLayer"]
    """ 

    :type: typing.List['GPencilLayer']
    """

    active_gpencil_frame: typing.List["GreasePencilLayer"]
    """ 

    :type: typing.List['GreasePencilLayer']
    """

    active_annotation_layer: "GPencilLayer"
    """ 

    :type: 'GPencilLayer'
    """

    active_operator: "Operator"
    """ 

    :type: 'Operator'
    """

    active_action: "Action"
    """ 

    :type: 'Action'
    """

    selected_visible_actions: typing.List["Action"]
    """ 

    :type: typing.List['Action']
    """

    selected_editable_actions: typing.List["Action"]
    """ 

    :type: typing.List['Action']
    """

    visible_fcurves: typing.List["FCurve"]
    """ 

    :type: typing.List['FCurve']
    """

    editable_fcurves: typing.List["FCurve"]
    """ 

    :type: typing.List['FCurve']
    """

    selected_visible_fcurves: typing.List["FCurve"]
    """ 

    :type: typing.List['FCurve']
    """

    selected_editable_fcurves: typing.List["FCurve"]
    """ 

    :type: typing.List['FCurve']
    """

    active_editable_fcurve: "FCurve"
    """ 

    :type: 'FCurve'
    """

    selected_editable_keyframes: typing.List["Keyframe"]
    """ 

    :type: typing.List['Keyframe']
    """

    ui_list: "UIList"
    """ 

    :type: 'UIList'
    """

    property: typing.Union["AnyType", int, str]
    """ Get the property associated with a hovered button.
Returns a tuple of the data-block, data path to the property, and array index.

    :type: typing.Union['AnyType', int, str]
    """

    edit_text: "Text"
    """ 

    :type: 'Text'
    """

    def evaluated_depsgraph_get(self) -> "Depsgraph":
        """Get the dependency graph for the current scene and view layer, to access to data-blocks with animation and modifiers applied. If any data-blocks have been edited, the dependency graph will be updated. This invalidates all references to evaluated data-blocks from the dependency graph.

        :rtype: 'Depsgraph'
        :return: Evaluated dependency graph
        """
        ...

    def copy(self): ...
    def path_resolve(
        self, path: typing.Optional[str], coerce: typing.Optional[bool] = True
    ):
        """Returns the property from the path, raise an exception when not found.

        :param path: patch which this property resolves.
        :type path: typing.Optional[str]
        :param coerce: optional argument, when True, the property will be converted into its Python representation.
        :type coerce: typing.Optional[bool]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

    def temp_override(
        self,
        window: typing.Optional["Window"],
        area: typing.Optional["Area"],
        region: typing.Optional["Region"],
        **keywords,
    ) -> "bpy.context":
        """Context manager to temporarily override members in the context.Overriding the context can be used to temporarily activate another window / area & region,
        as well as other members such as the active_object or bone.Notes:Overriding the context can be useful to set the context after loading files
        (which would otherwise by None). For example:This example shows how it's possible to add an object to the scene in another window.

                :param window: Window override or None.
                :type window: typing.Optional['Window']
                :param area: Area override or None.
                :type area: typing.Optional['Area']
                :param region: Region override or None.
                :type region: typing.Optional['Region']
                :param **keywords: Additional keywords override context members.
                :type **keywords:
                :rtype: 'bpy.context'
                :return: The context manager .
        """
        ...

class CryptomatteEntry(bpy_struct):
    encoded_hash: float
    """ 

    :type: float
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveMap(bpy_struct):
    """Curve in a curve mapping"""

    points: "CurveMapPoints"
    """ 

    :type: 'CurveMapPoints'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveMapPoint(bpy_struct):
    """Point of a curve used for a curve mapping"""

    handle_type: typing.Union[int, str]
    """ Curve interpolation at this point: Bézier or vector

    :type: typing.Union[int, str]
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ X/Y coordinates of the curve point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    select: bool
    """ Selection state of the curve point

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveMapping(bpy_struct):
    """Curve mapping to map color, vector and scalar values to other values using a user defined curve"""

    black_level: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ For RGB curves, the color that black is mapped to

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    clip_max_x: float
    """ 

    :type: float
    """

    clip_max_y: float
    """ 

    :type: float
    """

    clip_min_x: float
    """ 

    :type: float
    """

    clip_min_y: float
    """ 

    :type: float
    """

    curves: bpy_prop_collection["CurveMap"]
    """ 

    :type: bpy_prop_collection['CurveMap']
    """

    extend: typing.Union[int, str]
    """ Extrapolate the curve or extend it horizontally

    :type: typing.Union[int, str]
    """

    tone: typing.Union[int, str]
    """ Tone of the curve

    :type: typing.Union[int, str]
    """

    use_clip: bool
    """ Force the curve view to fit a defined boundary

    :type: bool
    """

    white_level: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ For RGB curves, the color that white is mapped to

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def update(self):
        """Update curve mapping after making changes"""
        ...

    def reset_view(self):
        """Reset the curve mapping grid to its clipping size"""
        ...

    def initialize(self):
        """Initialize curve"""
        ...

    def evaluate(self, curve: "CurveMap", position: typing.Optional[float]) -> float:
        """Evaluate curve at given location

        :param curve: curve, Curve to evaluate
        :type curve: 'CurveMap'
        :param position: Position, Position to evaluate curve at
        :type position: typing.Optional[float]
        :rtype: float
        :return: Value, Value of curve at given location
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurvePaintSettings(bpy_struct):
    corner_angle: float
    """ Angles above this are considered corners

    :type: float
    """

    curve_type: typing.Union[int, str]
    """ Type of curve to use for new strokes

    :type: typing.Union[int, str]
    """

    depth_mode: typing.Union[int, str]
    """ Method of projecting depth

    :type: typing.Union[int, str]
    """

    error_threshold: int
    """ Allow deviation for a smoother, less precise line

    :type: int
    """

    fit_method: typing.Union[int, str]
    """ Curve fitting method

    :type: typing.Union[int, str]
    """

    radius_max: float
    """ Radius to use when the maximum pressure is applied (or when a tablet isn't used)

    :type: float
    """

    radius_min: float
    """ Minimum radius when the minimum pressure is applied (also the minimum when tapering)

    :type: float
    """

    radius_taper_end: float
    """ Taper factor for the radius of each point along the curve

    :type: float
    """

    radius_taper_start: float
    """ Taper factor for the radius of each point along the curve

    :type: float
    """

    surface_offset: float
    """ Offset the stroke from the surface

    :type: float
    """

    surface_plane: typing.Union[int, str]
    """ Plane for projected stroke

    :type: typing.Union[int, str]
    """

    use_corners_detect: bool
    """ Detect corners and use non-aligned handles

    :type: bool
    """

    use_offset_absolute: bool
    """ Apply a fixed offset (don't scale by the radius)

    :type: bool
    """

    use_pressure_radius: bool
    """ Map tablet pressure to curve radius

    :type: bool
    """

    use_stroke_endpoints: bool
    """ Use the start of the stroke for the depth

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurvePoint(bpy_struct):
    """Curve control point"""

    index: int
    """ Index of this point

    :type: int
    """

    position: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    radius: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveProfile(bpy_struct):
    """Profile Path editor used to build a profile path"""

    points: "CurveProfilePoints"
    """ Profile control points

    :type: 'CurveProfilePoints'
    """

    preset: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    segments: bpy_prop_collection["CurveProfilePoint"]
    """ Segments sampled from control points

    :type: bpy_prop_collection['CurveProfilePoint']
    """

    use_clip: bool
    """ Force the path view to fit a defined boundary

    :type: bool
    """

    use_sample_even_lengths: bool
    """ Sample edges with even lengths

    :type: bool
    """

    use_sample_straight_edges: bool
    """ Sample edges with vector handles

    :type: bool
    """

    def update(self):
        """Refresh internal data, remove doubles and clip points"""
        ...

    def reset_view(self):
        """Reset the curve profile grid to its clipping size"""
        ...

    def initialize(self, totsegments: typing.Any):
        """Set the number of display segments and fill tables

        :param totsegments: The number of segment values to initialize the segments table with
        :type totsegments: typing.Any
        """
        ...

    def evaluate(
        self, length_portion: typing.Optional[float]
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]:
        """Evaluate the at the given portion of the path length

        :param length_portion: Length Portion, Portion of the path length to travel before evaluation
        :type length_portion: typing.Optional[float]
        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
        :return: Location, The location at the given portion of the profile
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveProfilePoint(bpy_struct):
    """Point of a path used to define a profile"""

    handle_type_1: typing.Union[int, str]
    """ Path interpolation at this point

    :type: typing.Union[int, str]
    """

    handle_type_2: typing.Union[int, str]
    """ Path interpolation at this point

    :type: typing.Union[int, str]
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ X/Y coordinates of the path point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    select: bool
    """ Selection state of the path point

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class CurveSlice(bpy_struct):
    """A single curve from a curves data-block"""

    first_point_index: int
    """ The index of this curve's first control point

    :type: int
    """

    index: int
    """ Index of this curve

    :type: int
    """

    points: bpy_prop_collection["CurvePoint"]
    """ Control points of the curve

    :type: bpy_prop_collection['CurvePoint']
    """

    points_length: int
    """ Number of control points in the curve

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DashGpencilModifierSegment(bpy_struct):
    """Configuration for a single dash segment"""

    dash: int
    """ The number of consecutive points from the original stroke to include in this segment

    :type: int
    """

    gap: int
    """ The number of points skipped after this segment

    :type: int
    """

    material_index: int
    """ Use this index on generated segment. -1 means using the existing material

    :type: int
    """

    name: typing.Union[str, typing.Any]
    """ Name of the dash segment

    :type: typing.Union[str, typing.Any]
    """

    opacity: float
    """ The factor to apply to the original point's opacity for the new points

    :type: float
    """

    radius: float
    """ The factor to apply to the original point's radius for the new points

    :type: float
    """

    use_cyclic: bool
    """ Enable cyclic on individual stroke dashes

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Depsgraph(bpy_struct):
    ids: bpy_prop_collection["ID"]
    """ All evaluated data-blocks

    :type: bpy_prop_collection['ID']
    """

    mode: typing.Union[int, str]
    """ Evaluation mode

    :type: typing.Union[int, str]
    """

    object_instances: bpy_prop_collection["DepsgraphObjectInstance"]
    """ All object instances to display or render (Warning: Only use this as an iterator, never as a sequence, and do not keep any references to its items)

    :type: bpy_prop_collection['DepsgraphObjectInstance']
    """

    objects: bpy_prop_collection["Object"]
    """ Evaluated objects in the dependency graph

    :type: bpy_prop_collection['Object']
    """

    scene: "Scene"
    """ Original scene dependency graph is built for

    :type: 'Scene'
    """

    scene_eval: "Scene"
    """ Scene at its evaluated state

    :type: 'Scene'
    """

    updates: bpy_prop_collection["DepsgraphUpdate"]
    """ Updates to data-blocks

    :type: bpy_prop_collection['DepsgraphUpdate']
    """

    view_layer: "ViewLayer"
    """ Original view layer dependency graph is built for

    :type: 'ViewLayer'
    """

    view_layer_eval: "ViewLayer"
    """ View layer at its evaluated state

    :type: 'ViewLayer'
    """

    def debug_relations_graphviz(self, filepath: typing.Union[str, typing.Any]):
        """debug_relations_graphviz

        :param filepath: File Name, Output path for the graphviz debug file
        :type filepath: typing.Union[str, typing.Any]
        """
        ...

    def debug_stats_gnuplot(
        self,
        filepath: typing.Union[str, typing.Any],
        output_filepath: typing.Union[str, typing.Any],
    ):
        """debug_stats_gnuplot

        :param filepath: File Name, Output path for the gnuplot debug file
        :type filepath: typing.Union[str, typing.Any]
        :param output_filepath: Output File Name, File name where gnuplot script will save the result
        :type output_filepath: typing.Union[str, typing.Any]
        """
        ...

    def debug_tag_update(self):
        """debug_tag_update"""
        ...

    def debug_stats(self) -> typing.Union[str, typing.Any]:
        """Report the number of elements in the Dependency Graph

        :rtype: typing.Union[str, typing.Any]
        :return: result
        """
        ...

    def update(self):
        """Re-evaluate any modified data-blocks, for example for animation or modifiers. This invalidates all references to evaluated data-blocks from this dependency graph."""
        ...

    def id_eval_get(self, id: typing.Optional["ID"]) -> "ID":
        """id_eval_get

        :param id: Original ID to get evaluated complementary part for
        :type id: typing.Optional['ID']
        :rtype: 'ID'
        :return: Evaluated ID for the given original one
        """
        ...

    def id_type_updated(self, id_type: typing.Optional[typing.Union[int, str]]) -> bool:
        """id_type_updated

        :param id_type: ID Type
        :type id_type: typing.Optional[typing.Union[int, str]]
        :rtype: bool
        :return: Updated, True if any datablock with this type was added, updated or removed
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DepsgraphObjectInstance(bpy_struct):
    """Extended information about dependency graph object iterator (Warning: All data here is 'evaluated' one, not original .blend IDs)"""

    instance_object: "Object"
    """ Evaluated object which is being instanced by this iterator

    :type: 'Object'
    """

    is_instance: typing.Union[bool, typing.Any]
    """ Denotes if the object is generated by another object

    :type: typing.Union[bool, typing.Any]
    """

    matrix_world: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Generated transform matrix in world space

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    object: "Object"
    """ Evaluated object the iterator points to

    :type: 'Object'
    """

    orco: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Generated coordinates in parent object space

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    parent: "Object"
    """ If the object is an instance, the parent object that generated it

    :type: 'Object'
    """

    particle_system: "ParticleSystem"
    """ Evaluated particle system that this object was instanced from

    :type: 'ParticleSystem'
    """

    persistent_id: bpy_prop_array[int]
    """ Persistent identifier for inter-frame matching of objects with motion blur

    :type: bpy_prop_array[int]
    """

    random_id: int
    """ Random id for this instance, typically for randomized shading

    :type: int
    """

    show_particles: typing.Union[bool, typing.Any]
    """ Particles part of the object should be visible in the render

    :type: typing.Union[bool, typing.Any]
    """

    show_self: typing.Union[bool, typing.Any]
    """ The object geometry itself should be visible in the render

    :type: typing.Union[bool, typing.Any]
    """

    uv: bpy_prop_array[float]
    """ UV coordinates in parent object space

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DepsgraphUpdate(bpy_struct):
    """Information about ID that was updated"""

    id: "ID"
    """ Updated data-block

    :type: 'ID'
    """

    is_updated_geometry: typing.Union[bool, typing.Any]
    """ Object geometry is updated

    :type: typing.Union[bool, typing.Any]
    """

    is_updated_shading: typing.Union[bool, typing.Any]
    """ Object shading is updated

    :type: typing.Union[bool, typing.Any]
    """

    is_updated_transform: typing.Union[bool, typing.Any]
    """ Object transformation is updated

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DisplaySafeAreas(bpy_struct):
    """Safe areas used in 3D view and the sequencer"""

    action: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Safe area for general elements

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    action_center: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Safe area for general elements in a different aspect ratio

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    title: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Safe area for text and graphics

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    title_center: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Safe area for text and graphics in a different aspect ratio

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DopeSheet(bpy_struct):
    """Settings for filtering the channels shown in animation editors"""

    filter_collection: "Collection"
    """ Collection that included object should be a member of

    :type: 'Collection'
    """

    filter_fcurve_name: typing.Union[str, typing.Any]
    """ F-Curve live filtering string

    :type: typing.Union[str, typing.Any]
    """

    filter_text: typing.Union[str, typing.Any]
    """ Live filtering string

    :type: typing.Union[str, typing.Any]
    """

    show_armatures: bool
    """ Include visualization of armature related animation data

    :type: bool
    """

    show_cache_files: bool
    """ Include visualization of cache file related animation data

    :type: bool
    """

    show_cameras: bool
    """ Include visualization of camera related animation data

    :type: bool
    """

    show_curves: bool
    """ Include visualization of curve related animation data

    :type: bool
    """

    show_datablock_filters: bool
    """ Show options for whether channels related to certain types of data are included

    :type: bool
    """

    show_driver_fallback_as_error: bool
    """ Include drivers that relied on any fallback values for their evaluation in the Only Show Errors filter, even if the driver evaluation succeeded

    :type: bool
    """

    show_expanded_summary: bool
    """ Collapse summary when shown, so all other channels get hidden (Dope Sheet editors only)

    :type: bool
    """

    show_gpencil: bool
    """ Include visualization of Grease Pencil related animation data and frames

    :type: bool
    """

    show_hair_curves: bool
    """ Include visualization of hair related animation data

    :type: bool
    """

    show_hidden: bool
    """ Include channels from objects/bone that are not visible

    :type: bool
    """

    show_lattices: bool
    """ Include visualization of lattice related animation data

    :type: bool
    """

    show_lights: bool
    """ Include visualization of light related animation data

    :type: bool
    """

    show_linestyles: bool
    """ Include visualization of Line Style related Animation data

    :type: bool
    """

    show_materials: bool
    """ Include visualization of material related animation data

    :type: bool
    """

    show_meshes: bool
    """ Include visualization of mesh related animation data

    :type: bool
    """

    show_metaballs: bool
    """ Include visualization of metaball related animation data

    :type: bool
    """

    show_missing_nla: bool
    """ Include animation data-blocks with no NLA data (NLA editor only)

    :type: bool
    """

    show_modifiers: bool
    """ Include visualization of animation data related to data-blocks linked to modifiers

    :type: bool
    """

    show_movieclips: bool
    """ Include visualization of movie clip related animation data

    :type: bool
    """

    show_nodes: bool
    """ Include visualization of node related animation data

    :type: bool
    """

    show_only_errors: bool
    """ Only include F-Curves and drivers that are disabled or have errors

    :type: bool
    """

    show_only_selected: bool
    """ Only include channels relating to selected objects and data

    :type: bool
    """

    show_particles: bool
    """ Include visualization of particle related animation data

    :type: bool
    """

    show_pointclouds: bool
    """ Include visualization of point cloud related animation data

    :type: bool
    """

    show_scenes: bool
    """ Include visualization of scene related animation data

    :type: bool
    """

    show_shapekeys: bool
    """ Include visualization of shape key related animation data

    :type: bool
    """

    show_speakers: bool
    """ Include visualization of speaker related animation data

    :type: bool
    """

    show_summary: bool
    """ Display an additional 'summary' line (Dope Sheet editors only)

    :type: bool
    """

    show_textures: bool
    """ Include visualization of texture related animation data

    :type: bool
    """

    show_transforms: bool
    """ Include visualization of object-level animation data (mostly transforms)

    :type: bool
    """

    show_volumes: bool
    """ Include visualization of volume related animation data

    :type: bool
    """

    show_worlds: bool
    """ Include visualization of world related animation data

    :type: bool
    """

    source: "ID"
    """ ID-Block representing source data, usually ID_SCE (i.e. Scene)

    :type: 'ID'
    """

    use_datablock_sort: bool
    """ Alphabetically sorts data-blocks - mainly objects in the scene (disable to increase viewport speed)

    :type: bool
    """

    use_filter_invert: bool
    """ Invert filter search

    :type: bool
    """

    use_multi_word_filter: bool
    """ Perform fuzzy/multi-word matching.
Warning: May be slow

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Driver(bpy_struct):
    """Driver for the value of a setting based on an external value"""

    expression: typing.Union[str, typing.Any]
    """ Expression to use for Scripted Expression

    :type: typing.Union[str, typing.Any]
    """

    is_simple_expression: typing.Union[bool, typing.Any]
    """ The scripted expression can be evaluated without using the full Python interpreter

    :type: typing.Union[bool, typing.Any]
    """

    is_valid: bool
    """ Driver could not be evaluated in past, so should be skipped

    :type: bool
    """

    type: typing.Union[int, str]
    """ Driver type

    :type: typing.Union[int, str]
    """

    use_self: bool
    """ Include a 'self' variable in the name-space, so drivers can easily reference the data being modified (object, bone, etc...)

    :type: bool
    """

    variables: "ChannelDriverVariables"
    """ Properties acting as inputs for this driver

    :type: 'ChannelDriverVariables'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DriverTarget(bpy_struct):
    """Source of input values for driver variables"""

    bone_target: typing.Union[str, typing.Any]
    """ Name of PoseBone to use as target

    :type: typing.Union[str, typing.Any]
    """

    context_property: typing.Union[int, str]
    """ Type of a context-dependent data-block to access property from

    :type: typing.Union[int, str]
    """

    data_path: typing.Union[str, typing.Any]
    """ RNA Path (from ID-block) to property used

    :type: typing.Union[str, typing.Any]
    """

    fallback_value: float
    """ The value to use if the data path can't be resolved

    :type: float
    """

    id: "ID"
    """ ID-block that the specific property used can be found from (id_type property must be set first)

    :type: 'ID'
    """

    id_type: typing.Union[int, str]
    """ Type of ID-block that can be used

    :type: typing.Union[int, str]
    """

    is_fallback_used: typing.Union[bool, typing.Any]
    """ Indicates that the most recent variable evaluation used the fallback value

    :type: typing.Union[bool, typing.Any]
    """

    rotation_mode: typing.Union[int, str]
    """ Mode for calculating rotation channel values

    :type: typing.Union[int, str]
    """

    transform_space: typing.Union[int, str]
    """ Space in which transforms are used

    :type: typing.Union[int, str]
    """

    transform_type: typing.Union[int, str]
    """ Driver variable type

    :type: typing.Union[int, str]
    """

    use_fallback_value: bool
    """ Use the fallback value if the data path can't be resolved, instead of failing to evaluate the driver

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DriverVariable(bpy_struct):
    """Variable from some source/target for driver relationship"""

    is_name_valid: typing.Union[bool, typing.Any]
    """ Is this a valid name for a driver variable

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Name to use in scripted expressions/functions (no spaces or dots are allowed, and must start with a letter)

    :type: typing.Union[str, typing.Any]
    """

    targets: bpy_prop_collection["DriverTarget"]
    """ Sources of input data for evaluating this variable

    :type: bpy_prop_collection['DriverTarget']
    """

    type: typing.Union[int, str]
    """ Driver variable type

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DynamicPaintBrushSettings(bpy_struct):
    """Brush settings"""

    invert_proximity: bool
    """ Proximity falloff is applied inside the volume

    :type: bool
    """

    paint_alpha: float
    """ Paint alpha

    :type: float
    """

    paint_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of the paint

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    paint_distance: float
    """ Maximum distance from brush to mesh surface to affect paint

    :type: float
    """

    paint_ramp: "ColorRamp"
    """ Color ramp used to define proximity falloff

    :type: 'ColorRamp'
    """

    paint_source: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    paint_wetness: float
    """ Paint wetness, visible in wetmap (some effects only affect wet paint)

    :type: float
    """

    particle_system: "ParticleSystem"
    """ The particle system to paint with

    :type: 'ParticleSystem'
    """

    proximity_falloff: typing.Union[int, str]
    """ Proximity falloff type

    :type: typing.Union[int, str]
    """

    ray_direction: typing.Union[int, str]
    """ Ray direction to use for projection (if brush object is located in that direction it's painted)

    :type: typing.Union[int, str]
    """

    smooth_radius: float
    """ Smooth falloff added after solid radius

    :type: float
    """

    smudge_strength: float
    """ Smudge effect strength

    :type: float
    """

    solid_radius: float
    """ Radius that will be painted solid

    :type: float
    """

    use_absolute_alpha: bool
    """ Only increase alpha value if paint alpha is higher than existing

    :type: bool
    """

    use_negative_volume: bool
    """ Negate influence inside the volume

    :type: bool
    """

    use_paint_erase: bool
    """ Erase / remove paint instead of adding it

    :type: bool
    """

    use_particle_radius: bool
    """ Use radius from particle settings

    :type: bool
    """

    use_proximity_project: bool
    """ Brush is projected to canvas from defined direction within brush proximity

    :type: bool
    """

    use_proximity_ramp_alpha: bool
    """ Only read color ramp alpha

    :type: bool
    """

    use_smudge: bool
    """ Make this brush to smudge existing paint as it moves

    :type: bool
    """

    use_velocity_alpha: bool
    """ Multiply brush influence by velocity color ramp alpha

    :type: bool
    """

    use_velocity_color: bool
    """ Replace brush color by velocity color ramp

    :type: bool
    """

    use_velocity_depth: bool
    """ Multiply brush intersection depth (displace, waves) by velocity ramp alpha

    :type: bool
    """

    velocity_max: float
    """ Velocity considered as maximum influence (Blender units per frame)

    :type: float
    """

    velocity_ramp: "ColorRamp"
    """ Color ramp used to define brush velocity effect

    :type: 'ColorRamp'
    """

    wave_clamp: float
    """ Maximum level of surface intersection used to influence waves (use 0.0 to disable)

    :type: float
    """

    wave_factor: float
    """ Multiplier for wave influence of this brush

    :type: float
    """

    wave_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DynamicPaintCanvasSettings(bpy_struct):
    """Dynamic Paint canvas settings"""

    canvas_surfaces: "DynamicPaintSurfaces"
    """ Paint surface list

    :type: 'DynamicPaintSurfaces'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class DynamicPaintSurface(bpy_struct):
    """A canvas surface layer"""

    brush_collection: "Collection"
    """ Only use brush objects from this collection

    :type: 'Collection'
    """

    brush_influence_scale: float
    """ Adjust influence brush objects have on this surface

    :type: float
    """

    brush_radius_scale: float
    """ Adjust radius of proximity brushes or particles for this surface

    :type: float
    """

    color_dry_threshold: float
    """ The wetness level when colors start to shift to the background

    :type: float
    """

    color_spread_speed: float
    """ How fast colors get mixed within wet paint

    :type: float
    """

    depth_clamp: float
    """ Maximum level of depth intersection in object space (use 0.0 to disable)

    :type: float
    """

    displace_factor: float
    """ Strength of displace when applied to the mesh

    :type: float
    """

    displace_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    dissolve_speed: int
    """ Approximately in how many frames should dissolve happen

    :type: int
    """

    drip_acceleration: float
    """ How much surface acceleration affects dripping

    :type: float
    """

    drip_velocity: float
    """ How much surface velocity affects dripping

    :type: float
    """

    dry_speed: int
    """ Approximately in how many frames should drying happen

    :type: int
    """

    effect_ui: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    effector_weights: "EffectorWeights"
    """ 

    :type: 'EffectorWeights'
    """

    frame_end: int
    """ Simulation end frame

    :type: int
    """

    frame_start: int
    """ Simulation start frame

    :type: int
    """

    frame_substeps: int
    """ Do extra frames between scene frames to ensure smooth motion

    :type: int
    """

    image_fileformat: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    image_output_path: typing.Union[str, typing.Any]
    """ Directory to save the textures

    :type: typing.Union[str, typing.Any]
    """

    image_resolution: int
    """ Output image resolution

    :type: int
    """

    init_color: bpy_prop_array[float]
    """ Initial color of the surface

    :type: bpy_prop_array[float]
    """

    init_color_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    init_layername: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    init_texture: "Texture"
    """ 

    :type: 'Texture'
    """

    is_active: bool
    """ Toggle whether surface is processed or ignored

    :type: bool
    """

    is_cache_user: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Surface name

    :type: typing.Union[str, typing.Any]
    """

    output_name_a: typing.Union[str, typing.Any]
    """ Name used to save output from this surface

    :type: typing.Union[str, typing.Any]
    """

    output_name_b: typing.Union[str, typing.Any]
    """ Name used to save output from this surface

    :type: typing.Union[str, typing.Any]
    """

    point_cache: "PointCache"
    """ 

    :type: 'PointCache'
    """

    shrink_speed: float
    """ How fast shrink effect moves on the canvas surface

    :type: float
    """

    spread_speed: float
    """ How fast spread effect moves on the canvas surface

    :type: float
    """

    surface_format: typing.Union[int, str]
    """ Surface Format

    :type: typing.Union[int, str]
    """

    surface_type: typing.Union[int, str]
    """ Surface Type

    :type: typing.Union[int, str]
    """

    use_antialiasing: bool
    """ Use 5× multisampling to smooth paint edges

    :type: bool
    """

    use_dissolve: bool
    """ Enable to make surface changes disappear over time

    :type: bool
    """

    use_dissolve_log: bool
    """ Use logarithmic dissolve (makes high values to fade faster than low values)

    :type: bool
    """

    use_drip: bool
    """ Process drip effect (drip wet paint to gravity direction)

    :type: bool
    """

    use_dry_log: bool
    """ Use logarithmic drying (makes high values to dry faster than low values)

    :type: bool
    """

    use_drying: bool
    """ Enable to make surface wetness dry over time

    :type: bool
    """

    use_incremental_displace: bool
    """ New displace is added cumulatively on top of existing

    :type: bool
    """

    use_output_a: bool
    """ Save this output layer

    :type: bool
    """

    use_output_b: bool
    """ Save this output layer

    :type: bool
    """

    use_premultiply: bool
    """ Multiply color by alpha (recommended for Blender input)

    :type: bool
    """

    use_shrink: bool
    """ Process shrink effect (shrink paint areas)

    :type: bool
    """

    use_spread: bool
    """ Process spread effect (spread wet paint around surface)

    :type: bool
    """

    use_wave_open_border: bool
    """ Pass waves through mesh edges

    :type: bool
    """

    uv_layer: typing.Union[str, typing.Any]
    """ UV map name

    :type: typing.Union[str, typing.Any]
    """

    wave_damping: float
    """ Wave damping factor

    :type: float
    """

    wave_smoothness: float
    """ Limit maximum steepness of wave slope between simulation points (use higher values for smoother waves at expense of reduced detail)

    :type: float
    """

    wave_speed: float
    """ Wave propagation speed

    :type: float
    """

    wave_spring: float
    """ Spring force that pulls water level back to zero

    :type: float
    """

    wave_timescale: float
    """ Wave time scaling factor

    :type: float
    """

    def output_exists(self, object: "Object", index: typing.Optional[int]) -> bool:
        """Checks if surface output layer of given name exists

        :param object:
        :type object: 'Object'
        :param index: Index
        :type index: typing.Optional[int]
        :rtype: bool
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class EQCurveMappingData(bpy_struct):
    """EQCurveMappingData"""

    curve_mapping: "CurveMapping"
    """ 

    :type: 'CurveMapping'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class EditBone(bpy_struct):
    """Edit mode bone in an armature data-block"""

    bbone_curveinx: float
    """ X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveinz: float
    """ Z-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutx: float
    """ X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutz: float
    """ Z-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_custom_handle_end: "EditBone"
    """ Bone that serves as the end handle for the B-Bone curve

    :type: 'EditBone'
    """

    bbone_custom_handle_start: "EditBone"
    """ Bone that serves as the start handle for the B-Bone curve

    :type: 'EditBone'
    """

    bbone_easein: float
    """ Length of first Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_easeout: float
    """ Length of second Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_handle_type_end: typing.Union[int, str]
    """ Selects how the end handle of the B-Bone is computed

    :type: typing.Union[int, str]
    """

    bbone_handle_type_start: typing.Union[int, str]
    """ Selects how the start handle of the B-Bone is computed

    :type: typing.Union[int, str]
    """

    bbone_handle_use_ease_end: bool
    """ Multiply the B-Bone Ease Out channel by the local Y scale value of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    """

    bbone_handle_use_ease_start: bool
    """ Multiply the B-Bone Ease In channel by the local Y scale value of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: bool
    """

    bbone_handle_use_scale_end: typing.List[bool]
    """ Multiply B-Bone Scale Out channels by the local scale values of the end handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    """

    bbone_handle_use_scale_start: typing.List[bool]
    """ Multiply B-Bone Scale In channels by the local scale values of the start handle. This is done after the Scale Easing option and isn't affected by it

    :type: typing.List[bool]
    """

    bbone_mapping_mode: typing.Union[int, str]
    """ Selects how the vertices are mapped to B-Bone segments based on their position

    :type: typing.Union[int, str]
    """

    bbone_rollin: float
    """ Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    """

    bbone_rollout: float
    """ Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    """

    bbone_scalein: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale factors for the start of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bbone_scaleout: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale factors for the end of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bbone_segments: int
    """ Number of subdivisions of bone (for B-Bones only)

    :type: int
    """

    bbone_x: float
    """ B-Bone X size

    :type: float
    """

    bbone_z: float
    """ B-Bone Z size

    :type: float
    """

    collections: bpy_prop_collection["BoneCollection"]
    """ Bone Collections that contain this bone

    :type: bpy_prop_collection['BoneCollection']
    """

    color: "BoneColor"
    """ 

    :type: 'BoneColor'
    """

    envelope_distance: float
    """ Bone deformation distance (for Envelope deform only)

    :type: float
    """

    envelope_weight: float
    """ Bone deformation weight (for Envelope deform only)

    :type: float
    """

    head: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of head end of the bone

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    head_radius: float
    """ Radius of head of bone (for Envelope deform only)

    :type: float
    """

    hide: bool
    """ Bone is not visible when in Edit Mode

    :type: bool
    """

    hide_select: bool
    """ Bone is able to be selected

    :type: bool
    """

    inherit_scale: typing.Union[int, str]
    """ Specifies how the bone inherits scaling from the parent bone

    :type: typing.Union[int, str]
    """

    length: float
    """ Length of the bone. Changing moves the tail end

    :type: float
    """

    lock: bool
    """ Bone is not able to be transformed when in Edit Mode

    :type: bool
    """

    matrix: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Matrix combining location and rotation of the bone (head position, direction and roll), in armature space (does not include/support bone's length/size)

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    parent: "EditBone"
    """ Parent edit bone (in same Armature)

    :type: 'EditBone'
    """

    roll: float
    """ Bone rotation around head-tail axis

    :type: float
    """

    select: bool
    """ 

    :type: bool
    """

    select_head: bool
    """ 

    :type: bool
    """

    select_tail: bool
    """ 

    :type: bool
    """

    show_wire: bool
    """ Bone is always displayed in wireframe regardless of viewport shading mode (useful for non-obstructive custom bone shapes)

    :type: bool
    """

    tail: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of tail end of the bone

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    tail_radius: float
    """ Radius of tail of bone (for Envelope deform only)

    :type: float
    """

    use_connect: bool
    """ When bone has a parent, bone's head is stuck to the parent's tail

    :type: bool
    """

    use_cyclic_offset: bool
    """ When bone doesn't have a parent, it receives cyclic offset effects (Deprecated)

    :type: bool
    """

    use_deform: bool
    """ Enable Bone to deform geometry

    :type: bool
    """

    use_endroll_as_inroll: bool
    """ Add Roll Out of the Start Handle bone to the Roll In value

    :type: bool
    """

    use_envelope_multiply: bool
    """ When deforming bone, multiply effects of Vertex Group weights with Envelope influence

    :type: bool
    """

    use_inherit_rotation: bool
    """ Bone inherits rotation or scale from parent bone

    :type: bool
    """

    use_local_location: bool
    """ Bone location is set in local space

    :type: bool
    """

    use_relative_parent: bool
    """ Object children will use relative transform, like deform

    :type: bool
    """

    use_scale_easing: bool
    """ Multiply the final easing values by the Scale In/Out Y factors

    :type: bool
    """

    basename: typing.Any
    """ The name of this bone before any '.' character(readonly)"""

    center: typing.Any
    """ The midpoint between the head and the tail.(readonly)"""

    children: typing.Any
    """ A list of all the bones children.(readonly)"""

    children_recursive: typing.Any
    """ A list of all children from this bone.(readonly)"""

    children_recursive_basename: typing.Any
    """ Returns a chain of children with the same base name as this bone.
Only direct chains are supported, forks caused by multiple children
with matching base names will terminate the function
and not be returned.(readonly)"""

    parent_recursive: typing.Any
    """ A list of parents, starting with the immediate parent(readonly)"""

    vector: typing.Any
    """ The direction this bone is pointing.
Utility function for (tail - head)(readonly)"""

    x_axis: typing.Any
    """ Vector pointing down the x-axis of the bone.(readonly)"""

    y_axis: typing.Any
    """ Vector pointing down the y-axis of the bone.(readonly)"""

    z_axis: typing.Any
    """ Vector pointing down the z-axis of the bone.(readonly)"""

    def align_roll(
        self,
        vector: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
    ):
        """Align the bone to a local-space roll so the Z axis points in the direction of the vector given

        :param vector: Vector
        :type vector: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
        """
        ...

    def align_orientation(self, other):
        """Align this bone to another by moving its tail and settings its roll
        the length of the other bone is not used.

                :param other:
                :type other:
        """
        ...

    def parent_index(self, parent_test):
        """The same as 'bone in other_bone.parent_recursive'
        but saved generating a list.

                :param parent_test:
                :type parent_test:
        """
        ...

    def transform(
        self,
        matrix: typing.Optional[
            typing.Union["mathutils.Matrix", typing.Sequence[float]]
        ],
        *,
        scale: typing.Optional[bool] = True,
        roll: typing.Optional[bool] = True,
    ):
        """Transform the the bones head, tail, roll and envelope
        (when the matrix has a scale component).

                :param matrix: 3x3 or 4x4 transformation matrix.
                :type matrix: typing.Optional[typing.Union['mathutils.Matrix', typing.Sequence[float]]]
                :param *:
                :type *:
                :param scale: Scale the bone envelope by the matrix.
                :type scale: typing.Optional[bool]
                :param roll: Correct the roll to point in the same relative
        direction to the head and tail.
                :type roll: typing.Optional[bool]
        """
        ...

    def translate(self, vec):
        """Utility function to add vec to the head and tail of this bone

        :param vec:
        :type vec:
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class EffectorWeights(bpy_struct):
    """Effector weights for physics simulation"""

    all: float
    """ All effector's weight

    :type: float
    """

    apply_to_hair_growing: bool
    """ Use force fields when growing hair

    :type: bool
    """

    boid: float
    """ Boid effector weight

    :type: float
    """

    charge: float
    """ Charge effector weight

    :type: float
    """

    collection: "Collection"
    """ Limit effectors to this collection

    :type: 'Collection'
    """

    curve_guide: float
    """ Curve guide effector weight

    :type: float
    """

    drag: float
    """ Drag effector weight

    :type: float
    """

    force: float
    """ Force effector weight

    :type: float
    """

    gravity: float
    """ Global gravity weight

    :type: float
    """

    harmonic: float
    """ Harmonic effector weight

    :type: float
    """

    lennardjones: float
    """ Lennard-Jones effector weight

    :type: float
    """

    magnetic: float
    """ Magnetic effector weight

    :type: float
    """

    smokeflow: float
    """ Fluid Flow effector weight

    :type: float
    """

    texture: float
    """ Texture effector weight

    :type: float
    """

    turbulence: float
    """ Turbulence effector weight

    :type: float
    """

    vortex: float
    """ Vortex effector weight

    :type: float
    """

    wind: float
    """ Wind effector weight

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class EnumPropertyItem(bpy_struct):
    """Definition of a choice in an RNA enum property"""

    description: typing.Union[str, typing.Any]
    """ Description of the item's purpose

    :type: typing.Union[str, typing.Any]
    """

    icon: typing.Any
    """ Icon of the item

    :type: typing.Any
    """

    identifier: typing.Union[str, typing.Any]
    """ Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Human readable name

    :type: typing.Union[str, typing.Any]
    """

    value: int
    """ Value of the item

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Event(bpy_struct):
    """Window Manager Event"""

    alt: typing.Union[bool, typing.Any]
    """ True when the Alt/Option key is held

    :type: typing.Union[bool, typing.Any]
    """

    ascii: typing.Union[str, typing.Any]
    """ Single ASCII character for this event

    :type: typing.Union[str, typing.Any]
    """

    ctrl: typing.Union[bool, typing.Any]
    """ True when the Ctrl key is held

    :type: typing.Union[bool, typing.Any]
    """

    direction: typing.Any
    """ The direction (only applies to drag events)

    :type: typing.Any
    """

    is_consecutive: typing.Union[bool, typing.Any]
    """ Part of a trackpad or NDOF motion, interrupted by cursor motion, button or key press events

    :type: typing.Union[bool, typing.Any]
    """

    is_mouse_absolute: typing.Union[bool, typing.Any]
    """ The last motion event was an absolute input

    :type: typing.Union[bool, typing.Any]
    """

    is_repeat: typing.Union[bool, typing.Any]
    """ The event is generated by holding a key down

    :type: typing.Union[bool, typing.Any]
    """

    is_tablet: typing.Union[bool, typing.Any]
    """ The event has tablet data

    :type: typing.Union[bool, typing.Any]
    """

    mouse_prev_press_x: int
    """ The window relative horizontal location of the last press event

    :type: int
    """

    mouse_prev_press_y: int
    """ The window relative vertical location of the last press event

    :type: int
    """

    mouse_prev_x: int
    """ The window relative horizontal location of the mouse

    :type: int
    """

    mouse_prev_y: int
    """ The window relative vertical location of the mouse

    :type: int
    """

    mouse_region_x: int
    """ The region relative horizontal location of the mouse

    :type: int
    """

    mouse_region_y: int
    """ The region relative vertical location of the mouse

    :type: int
    """

    mouse_x: int
    """ The window relative horizontal location of the mouse

    :type: int
    """

    mouse_y: int
    """ The window relative vertical location of the mouse

    :type: int
    """

    oskey: typing.Union[bool, typing.Any]
    """ True when the Cmd key is held

    :type: typing.Union[bool, typing.Any]
    """

    pressure: float
    """ The pressure of the tablet or 1.0 if no tablet present

    :type: float
    """

    shift: typing.Union[bool, typing.Any]
    """ True when the Shift key is held

    :type: typing.Union[bool, typing.Any]
    """

    tilt: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ The pressure of the tablet or zeroes if no tablet present

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    type_prev: typing.Any
    """ 

    :type: typing.Any
    """

    unicode: typing.Union[str, typing.Any]
    """ Single unicode character for this event

    :type: typing.Union[str, typing.Any]
    """

    value: typing.Any
    """ The type of event, only applies to some

    :type: typing.Any
    """

    value_prev: typing.Any
    """ The type of event, only applies to some

    :type: typing.Any
    """

    xr: "XrEventData"
    """ XR event data

    :type: 'XrEventData'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FCurve(bpy_struct):
    """F-Curve defining values of a period of time"""

    array_index: int
    """ Index to the specific property affected by F-Curve if applicable

    :type: int
    """

    auto_smoothing: typing.Union[int, str]
    """ Algorithm used to compute automatic handles

    :type: typing.Union[int, str]
    """

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of the F-Curve in the Graph Editor

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    color_mode: typing.Union[int, str]
    """ Method used to determine color of F-Curve in Graph Editor

    :type: typing.Union[int, str]
    """

    data_path: typing.Union[str, typing.Any]
    """ RNA Path to property affected by F-Curve

    :type: typing.Union[str, typing.Any]
    """

    driver: "Driver"
    """ Channel Driver (only set for Driver F-Curves)

    :type: 'Driver'
    """

    extrapolation: typing.Union[int, str]
    """ Method used for evaluating value of F-Curve outside first and last keyframes

    :type: typing.Union[int, str]
    """

    group: "ActionGroup"
    """ Action Group that this F-Curve belongs to

    :type: 'ActionGroup'
    """

    hide: bool
    """ F-Curve and its keyframes are hidden in the Graph Editor graphs

    :type: bool
    """

    is_empty: typing.Union[bool, typing.Any]
    """ True if the curve contributes no animation due to lack of keyframes or useful modifiers, and should be deleted

    :type: typing.Union[bool, typing.Any]
    """

    is_valid: bool
    """ False when F-Curve could not be evaluated in past, so should be skipped when evaluating

    :type: bool
    """

    keyframe_points: "FCurveKeyframePoints"
    """ User-editable keyframes

    :type: 'FCurveKeyframePoints'
    """

    lock: bool
    """ F-Curve's settings cannot be edited

    :type: bool
    """

    modifiers: "FCurveModifiers"
    """ Modifiers affecting the shape of the F-Curve

    :type: 'FCurveModifiers'
    """

    mute: bool
    """ Disable F-Curve evaluation

    :type: bool
    """

    sampled_points: bpy_prop_collection["FCurveSample"]
    """ Sampled animation data

    :type: bpy_prop_collection['FCurveSample']
    """

    select: bool
    """ F-Curve is selected for editing

    :type: bool
    """

    def evaluate(self, frame: typing.Optional[float]) -> float:
        """Evaluate F-Curve

        :param frame: Frame, Evaluate F-Curve at given frame
        :type frame: typing.Optional[float]
        :rtype: float
        :return: Value, Value of F-Curve specific frame
        """
        ...

    def update(self):
        """Ensure keyframes are sorted in chronological order and handles are set correctly"""
        ...

    def range(
        self,
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]:
        """Get the time extents for F-Curve

        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
        :return: Range, Min/Max values
        """
        ...

    def update_autoflags(self, data: typing.Any):
        """Update FCurve flags set automatically from affected property (currently, integer/discrete flags set when the property is not a float)

        :param data: Data, Data containing the property controlled by given FCurve
        :type data: typing.Any
        """
        ...

    def convert_to_samples(
        self, start: typing.Optional[int], end: typing.Optional[int]
    ):
        """Convert current FCurve from keyframes to sample points, if necessary

        :param start: Start Frame
        :type start: typing.Optional[int]
        :param end: End Frame
        :type end: typing.Optional[int]
        """
        ...

    def convert_to_keyframes(
        self, start: typing.Optional[int], end: typing.Optional[int]
    ):
        """Convert current FCurve from sample points to keyframes (linear interpolation), if necessary

        :param start: Start Frame
        :type start: typing.Optional[int]
        :param end: End Frame
        :type end: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FCurveSample(bpy_struct):
    """Sample point for F-Curve"""

    co: typing.Union["mathutils.Vector", typing.List[float], typing.Tuple[float, float]]
    """ Point coordinates

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    select: bool
    """ Selection status

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FFmpegSettings(bpy_struct):
    """FFmpeg related settings for the scene"""

    audio_bitrate: int
    """ Audio bitrate (kb/s)

    :type: int
    """

    audio_channels: typing.Union[int, str]
    """ Audio channel count

    :type: typing.Union[int, str]
    """

    audio_codec: typing.Union[int, str]
    """ FFmpeg audio codec to use

    :type: typing.Union[int, str]
    """

    audio_mixrate: int
    """ Audio sample rate (samples/s)

    :type: int
    """

    audio_volume: float
    """ Audio volume

    :type: float
    """

    buffersize: int
    """ Rate control: buffer size (kb)

    :type: int
    """

    codec: typing.Union[int, str]
    """ FFmpeg codec to use for video output

    :type: typing.Union[int, str]
    """

    constant_rate_factor: typing.Union[int, str]
    """ Constant Rate Factor (CRF); tradeoff between video quality and file size

    :type: typing.Union[int, str]
    """

    ffmpeg_preset: typing.Union[int, str]
    """ Tradeoff between encoding speed and compression ratio

    :type: typing.Union[int, str]
    """

    format: typing.Union[int, str]
    """ Output file container

    :type: typing.Union[int, str]
    """

    gopsize: int
    """ Distance between key frames, also known as GOP size; influences file size and seekability

    :type: int
    """

    max_b_frames: int
    """ Maximum number of B-frames between non-B-frames; influences file size and seekability

    :type: int
    """

    maxrate: int
    """ Rate control: max rate (kbit/s)

    :type: int
    """

    minrate: int
    """ Rate control: min rate (kbit/s)

    :type: int
    """

    muxrate: int
    """ Mux rate (bits/second)

    :type: int
    """

    packetsize: int
    """ Mux packet size (byte)

    :type: int
    """

    use_autosplit: bool
    """ Autosplit output at 2GB boundary

    :type: bool
    """

    use_lossless_output: bool
    """ Use lossless output for video streams

    :type: bool
    """

    use_max_b_frames: bool
    """ Set a maximum number of B-frames

    :type: bool
    """

    video_bitrate: int
    """ Video bitrate (kbit/s)

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FModifier(bpy_struct):
    """Modifier for values of F-Curve"""

    active: bool
    """ F-Curve modifier will show settings in the editor

    :type: bool
    """

    blend_in: float
    """ Number of frames from start frame for influence to take effect

    :type: float
    """

    blend_out: float
    """ Number of frames from end frame for influence to fade out

    :type: float
    """

    frame_end: float
    """ Frame that modifier's influence ends (if Restrict Frame Range is in use)

    :type: float
    """

    frame_start: float
    """ Frame that modifier's influence starts (if Restrict Frame Range is in use)

    :type: float
    """

    influence: float
    """ Amount of influence F-Curve Modifier will have when not fading in/out

    :type: float
    """

    is_valid: typing.Union[bool, typing.Any]
    """ F-Curve Modifier has invalid settings and will not be evaluated

    :type: typing.Union[bool, typing.Any]
    """

    mute: bool
    """ Enable F-Curve modifier evaluation

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ F-Curve Modifier name

    :type: typing.Union[str, typing.Any]
    """

    show_expanded: bool
    """ F-Curve Modifier's panel is expanded in UI

    :type: bool
    """

    type: typing.Any
    """ F-Curve Modifier Type

    :type: typing.Any
    """

    use_influence: bool
    """ F-Curve Modifier's effects will be tempered by a default factor

    :type: bool
    """

    use_restricted_range: bool
    """ F-Curve Modifier is only applied for the specified frame range to help mask off effects in order to chain them

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FModifierEnvelopeControlPoint(bpy_struct):
    """Control point for envelope F-Modifier"""

    frame: float
    """ Frame this control-point occurs on

    :type: float
    """

    max: float
    """ Upper bound of envelope at this control-point

    :type: float
    """

    min: float
    """ Lower bound of envelope at this control-point

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FieldSettings(bpy_struct):
    """Field settings for an object in physics simulation"""

    apply_to_location: bool
    """ Affect particle's location

    :type: bool
    """

    apply_to_rotation: bool
    """ Affect particle's dynamic rotation

    :type: bool
    """

    distance_max: float
    """ Maximum distance for the field to work

    :type: float
    """

    distance_min: float
    """ Minimum distance for the field's falloff

    :type: float
    """

    falloff_power: float
    """ How quickly strength falls off with distance from the force field

    :type: float
    """

    falloff_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    flow: float
    """ Convert effector force into air flow velocity

    :type: float
    """

    guide_clump_amount: float
    """ Amount of clumping

    :type: float
    """

    guide_clump_shape: float
    """ Shape of clumping

    :type: float
    """

    guide_free: float
    """ Guide-free time from particle life's end

    :type: float
    """

    guide_kink_amplitude: float
    """ The amplitude of the offset

    :type: float
    """

    guide_kink_axis: typing.Union[int, str]
    """ Which axis to use for offset

    :type: typing.Union[int, str]
    """

    guide_kink_frequency: float
    """ The frequency of the offset (1/total length)

    :type: float
    """

    guide_kink_shape: float
    """ Adjust the offset to the beginning/end

    :type: float
    """

    guide_kink_type: typing.Union[int, str]
    """ Type of periodic offset on the curve

    :type: typing.Union[int, str]
    """

    guide_minimum: float
    """ The distance from which particles are affected fully

    :type: float
    """

    harmonic_damping: float
    """ Damping of the harmonic force

    :type: float
    """

    inflow: float
    """ Inwards component of the vortex force

    :type: float
    """

    linear_drag: float
    """ Drag component proportional to velocity

    :type: float
    """

    noise: float
    """ Amount of noise for the force strength

    :type: float
    """

    quadratic_drag: float
    """ Drag component proportional to the square of velocity

    :type: float
    """

    radial_falloff: float
    """ Radial falloff power (real gravitational falloff = 2)

    :type: float
    """

    radial_max: float
    """ Maximum radial distance for the field to work

    :type: float
    """

    radial_min: float
    """ Minimum radial distance for the field's falloff

    :type: float
    """

    rest_length: float
    """ Rest length of the harmonic force

    :type: float
    """

    seed: int
    """ Seed of the noise

    :type: int
    """

    shape: typing.Union[int, str]
    """ Which direction is used to calculate the effector force

    :type: typing.Union[int, str]
    """

    size: float
    """ Size of the turbulence

    :type: float
    """

    source_object: "Object"
    """ Select domain object of the smoke simulation

    :type: 'Object'
    """

    strength: float
    """ Strength of force field

    :type: float
    """

    texture: "Texture"
    """ Texture to use as force

    :type: 'Texture'
    """

    texture_mode: typing.Union[int, str]
    """ How the texture effect is calculated (RGB and Curl need a RGB texture, else Gradient will be used instead)

    :type: typing.Union[int, str]
    """

    texture_nabla: float
    """ Defines size of derivative offset used for calculating gradient and curl

    :type: float
    """

    type: typing.Union[int, str]
    """ Type of field

    :type: typing.Union[int, str]
    """

    use_2d_force: bool
    """ Apply force only in 2D

    :type: bool
    """

    use_absorption: bool
    """ Force gets absorbed by collision objects

    :type: bool
    """

    use_global_coords: bool
    """ Use effector/global coordinates for turbulence

    :type: bool
    """

    use_gravity_falloff: bool
    """ Multiply force by 1/distance²

    :type: bool
    """

    use_guide_path_add: bool
    """ Based on distance/falloff it adds a portion of the entire path

    :type: bool
    """

    use_guide_path_weight: bool
    """ Use curve weights to influence the particle influence along the curve

    :type: bool
    """

    use_max_distance: bool
    """ Use a maximum distance for the field to work

    :type: bool
    """

    use_min_distance: bool
    """ Use a minimum distance for the field's falloff

    :type: bool
    """

    use_multiple_springs: bool
    """ Every point is affected by multiple springs

    :type: bool
    """

    use_object_coords: bool
    """ Use object/global coordinates for texture

    :type: bool
    """

    use_radial_max: bool
    """ Use a maximum radial distance for the field to work

    :type: bool
    """

    use_radial_min: bool
    """ Use a minimum radial distance for the field's falloff

    :type: bool
    """

    use_root_coords: bool
    """ Texture coordinates from root particle locations

    :type: bool
    """

    use_smoke_density: bool
    """ Adjust force strength based on smoke density

    :type: bool
    """

    wind_factor: float
    """ How much the force is reduced when acting parallel to a surface, e.g. cloth

    :type: float
    """

    z_direction: typing.Union[int, str]
    """ Effect in full or only positive/negative Z direction

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FileAssetSelectIDFilter(bpy_struct):
    """Which asset types to show/hide, when browsing an asset library"""

    experimental_filter_armature: bool
    """ Show Armature data-blocks

    :type: bool
    """

    experimental_filter_brush: bool
    """ Show Brushes data-blocks

    :type: bool
    """

    experimental_filter_cachefile: bool
    """ Show Cache File data-blocks

    :type: bool
    """

    experimental_filter_camera: bool
    """ Show Camera data-blocks

    :type: bool
    """

    experimental_filter_curve: bool
    """ Show Curve data-blocks

    :type: bool
    """

    experimental_filter_curves: bool
    """ Show/hide Curves data-blocks

    :type: bool
    """

    experimental_filter_font: bool
    """ Show Font data-blocks

    :type: bool
    """

    experimental_filter_grease_pencil: bool
    """ Show Grease pencil data-blocks

    :type: bool
    """

    experimental_filter_image: bool
    """ Show Image data-blocks

    :type: bool
    """

    experimental_filter_lattice: bool
    """ Show Lattice data-blocks

    :type: bool
    """

    experimental_filter_light: bool
    """ Show Light data-blocks

    :type: bool
    """

    experimental_filter_light_probe: bool
    """ Show Light Probe data-blocks

    :type: bool
    """

    experimental_filter_linestyle: bool
    """ Show Freestyle's Line Style data-blocks

    :type: bool
    """

    experimental_filter_mask: bool
    """ Show Mask data-blocks

    :type: bool
    """

    experimental_filter_mesh: bool
    """ Show Mesh data-blocks

    :type: bool
    """

    experimental_filter_metaball: bool
    """ Show Metaball data-blocks

    :type: bool
    """

    experimental_filter_movie_clip: bool
    """ Show Movie Clip data-blocks

    :type: bool
    """

    experimental_filter_paint_curve: bool
    """ Show Paint Curve data-blocks

    :type: bool
    """

    experimental_filter_palette: bool
    """ Show Palette data-blocks

    :type: bool
    """

    experimental_filter_particle_settings: bool
    """ Show Particle Settings data-blocks

    :type: bool
    """

    experimental_filter_pointcloud: bool
    """ Show/hide Point Cloud data-blocks

    :type: bool
    """

    experimental_filter_scene: bool
    """ Show Scene data-blocks

    :type: bool
    """

    experimental_filter_sound: bool
    """ Show Sound data-blocks

    :type: bool
    """

    experimental_filter_speaker: bool
    """ Show Speaker data-blocks

    :type: bool
    """

    experimental_filter_text: bool
    """ Show Text data-blocks

    :type: bool
    """

    experimental_filter_texture: bool
    """ Show Texture data-blocks

    :type: bool
    """

    experimental_filter_volume: bool
    """ Show/hide Volume data-blocks

    :type: bool
    """

    experimental_filter_work_space: bool
    """ Show workspace data-blocks

    :type: bool
    """

    filter_action: bool
    """ Show Action data-blocks

    :type: bool
    """

    filter_group: bool
    """ Show Collection data-blocks

    :type: bool
    """

    filter_material: bool
    """ Show Material data-blocks

    :type: bool
    """

    filter_node_tree: bool
    """ Show Node Tree data-blocks

    :type: bool
    """

    filter_object: bool
    """ Show Object data-blocks

    :type: bool
    """

    filter_world: bool
    """ Show World data-blocks

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FileBrowserFSMenuEntry(bpy_struct):
    """File Select Parameters"""

    icon: int
    """ 

    :type: int
    """

    is_valid: typing.Union[bool, typing.Any]
    """ Whether this path is currently reachable

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    path: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    use_save: typing.Union[bool, typing.Any]
    """ Whether this path is saved in bookmarks, or generated from OS

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FileHandler(bpy_struct):
    """Extends functionality to operators that manages files, such as adding drag and drop support"""

    bl_file_extensions: typing.Union[str, typing.Any]
    """ Formatted string of file extensions supported by the file handler, each extension should start with a "." and be separated by ";".
For Example: ".blend;.ble"

    :type: typing.Union[str, typing.Any]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the file handler gets a custom ID, otherwise it takes the name of the class used to define the file handler (for example, if the class name is "OBJECT_FH_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_FH_hello")

    :type: typing.Union[str, typing.Any]
    """

    bl_import_operator: typing.Union[str, typing.Any]
    """ Operator that can handle import files with the extensions given in bl_file_extensions

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ The file handler label

    :type: typing.Union[str, typing.Any]
    """

    def poll_drop(self, context: typing.Optional["Context"]) -> bool:
        """If this method returns True, can be used to handle the drop of a drag-and-drop action

        :param context:
        :type context: typing.Optional['Context']
        :rtype: bool
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FileSelectEntry(bpy_struct):
    """A file viewable in the File Browser"""

    asset_data: "AssetMetaData"
    """ Asset data, valid if the file represents an asset

    :type: 'AssetMetaData'
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    preview_icon_id: int
    """ Unique integer identifying the preview of this file as an icon (zero means invalid)

    :type: int
    """

    relative_path: typing.Union[str, typing.Any]
    """ Path relative to the directory currently displayed in the File Browser (includes the file name)

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FileSelectIDFilter(bpy_struct):
    """Which ID types to show/hide, when browsing a library"""

    category_animation: bool
    """ Show animation data

    :type: bool
    """

    category_environment: bool
    """ Show worlds, lights, cameras and speakers

    :type: bool
    """

    category_geometry: bool
    """ Show meshes, curves, lattice, armatures and metaballs data

    :type: bool
    """

    category_image: bool
    """ Show images, movie clips, sounds and masks

    :type: bool
    """

    category_misc: bool
    """ Show other data types

    :type: bool
    """

    category_object: bool
    """ Show objects and collections

    :type: bool
    """

    category_scene: bool
    """ Show scenes

    :type: bool
    """

    category_shading: bool
    """ Show materials, node-trees, textures and Freestyle's line-styles

    :type: bool
    """

    filter_action: bool
    """ Show Action data-blocks

    :type: bool
    """

    filter_armature: bool
    """ Show Armature data-blocks

    :type: bool
    """

    filter_brush: bool
    """ Show Brushes data-blocks

    :type: bool
    """

    filter_cachefile: bool
    """ Show Cache File data-blocks

    :type: bool
    """

    filter_camera: bool
    """ Show Camera data-blocks

    :type: bool
    """

    filter_curve: bool
    """ Show Curve data-blocks

    :type: bool
    """

    filter_curves: bool
    """ Show/hide Curves data-blocks

    :type: bool
    """

    filter_font: bool
    """ Show Font data-blocks

    :type: bool
    """

    filter_grease_pencil: bool
    """ Show Grease pencil data-blocks

    :type: bool
    """

    filter_group: bool
    """ Show Collection data-blocks

    :type: bool
    """

    filter_image: bool
    """ Show Image data-blocks

    :type: bool
    """

    filter_lattice: bool
    """ Show Lattice data-blocks

    :type: bool
    """

    filter_light: bool
    """ Show Light data-blocks

    :type: bool
    """

    filter_light_probe: bool
    """ Show Light Probe data-blocks

    :type: bool
    """

    filter_linestyle: bool
    """ Show Freestyle's Line Style data-blocks

    :type: bool
    """

    filter_mask: bool
    """ Show Mask data-blocks

    :type: bool
    """

    filter_material: bool
    """ Show Material data-blocks

    :type: bool
    """

    filter_mesh: bool
    """ Show Mesh data-blocks

    :type: bool
    """

    filter_metaball: bool
    """ Show Metaball data-blocks

    :type: bool
    """

    filter_movie_clip: bool
    """ Show Movie Clip data-blocks

    :type: bool
    """

    filter_node_tree: bool
    """ Show Node Tree data-blocks

    :type: bool
    """

    filter_object: bool
    """ Show Object data-blocks

    :type: bool
    """

    filter_paint_curve: bool
    """ Show Paint Curve data-blocks

    :type: bool
    """

    filter_palette: bool
    """ Show Palette data-blocks

    :type: bool
    """

    filter_particle_settings: bool
    """ Show Particle Settings data-blocks

    :type: bool
    """

    filter_pointcloud: bool
    """ Show/hide Point Cloud data-blocks

    :type: bool
    """

    filter_scene: bool
    """ Show Scene data-blocks

    :type: bool
    """

    filter_sound: bool
    """ Show Sound data-blocks

    :type: bool
    """

    filter_speaker: bool
    """ Show Speaker data-blocks

    :type: bool
    """

    filter_text: bool
    """ Show Text data-blocks

    :type: bool
    """

    filter_texture: bool
    """ Show Texture data-blocks

    :type: bool
    """

    filter_volume: bool
    """ Show/hide Volume data-blocks

    :type: bool
    """

    filter_work_space: bool
    """ Show workspace data-blocks

    :type: bool
    """

    filter_world: bool
    """ Show World data-blocks

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FileSelectParams(bpy_struct):
    """File Select Parameters"""

    directory: typing.Union[str, typing.Any]
    """ Directory displayed in the file browser

    :type: typing.Union[str, typing.Any]
    """

    display_size: int
    """ Change the size of thumbnails

    :type: int
    """

    display_size_discrete: typing.Union[int, str]
    """ Change the size of thumbnails in discrete steps

    :type: typing.Union[int, str]
    """

    display_type: typing.Union[int, str]
    """ Display mode for the file list

    :type: typing.Union[int, str]
    """

    filename: typing.Union[str, typing.Any]
    """ Active file in the file browser

    :type: typing.Union[str, typing.Any]
    """

    filter_glob: typing.Union[str, typing.Any]
    """ UNIX shell-like filename patterns matching, supports wildcards ('*') and list of patterns separated by ';'

    :type: typing.Union[str, typing.Any]
    """

    filter_id: "FileSelectIDFilter"
    """ Which ID types to show/hide, when browsing a library

    :type: 'FileSelectIDFilter'
    """

    filter_search: typing.Union[str, typing.Any]
    """ Filter by name or tag, supports '*' wildcard

    :type: typing.Union[str, typing.Any]
    """

    recursion_level: typing.Union[int, str]
    """ Numbers of dirtree levels to show simultaneously

    :type: typing.Union[int, str]
    """

    show_details_datetime: bool
    """ Show a column listing the date and time of modification for each file

    :type: bool
    """

    show_details_size: bool
    """ Show a column listing the size of each file

    :type: bool
    """

    show_hidden: bool
    """ Show hidden dot files

    :type: bool
    """

    sort_method: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    title: typing.Union[str, typing.Any]
    """ Title for the file browser

    :type: typing.Union[str, typing.Any]
    """

    use_filter: bool
    """ Enable filtering of files

    :type: bool
    """

    use_filter_asset_only: bool
    """ Hide .blend files items that are not data-blocks with asset metadata

    :type: bool
    """

    use_filter_backup: bool
    """ Show .blend1, .blend2, etc. files

    :type: bool
    """

    use_filter_blender: bool
    """ Show .blend files

    :type: bool
    """

    use_filter_blendid: bool
    """ Show .blend files items (objects, materials, etc.)

    :type: bool
    """

    use_filter_folder: bool
    """ Show folders

    :type: bool
    """

    use_filter_font: bool
    """ Show font files

    :type: bool
    """

    use_filter_image: bool
    """ Show image files

    :type: bool
    """

    use_filter_movie: bool
    """ Show movie files

    :type: bool
    """

    use_filter_script: bool
    """ Show script files

    :type: bool
    """

    use_filter_sound: bool
    """ Show sound files

    :type: bool
    """

    use_filter_text: bool
    """ Show text files

    :type: bool
    """

    use_filter_volume: bool
    """ Show 3D volume files

    :type: bool
    """

    use_library_browsing: typing.Union[bool, typing.Any]
    """ Whether we may browse Blender files' content or not

    :type: typing.Union[bool, typing.Any]
    """

    use_sort_invert: bool
    """ Sort items descending, from highest value to lowest

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Float2AttributeValue(bpy_struct):
    """2D Vector value in geometry attribute"""

    vector: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ 2D vector

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Float4x4AttributeValue(bpy_struct):
    """Matrix value in geometry attribute"""

    value: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FloatAttributeValue(bpy_struct):
    """Floating-point value in geometry attribute"""

    value: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FloatColorAttributeValue(bpy_struct):
    """Color value in geometry attribute"""

    color: bpy_prop_array[float]
    """ RGBA color in scene linear color space

    :type: bpy_prop_array[float]
    """

    color_srgb: bpy_prop_array[float]
    """ RGBA color in sRGB color space

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FloatVectorAttributeValue(bpy_struct):
    """Vector value in geometry attribute"""

    vector: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 3D vector

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FloatVectorValueReadOnly(bpy_struct):
    vector: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 3D vector

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FluidDomainSettings(bpy_struct):
    """Fluid domain settings"""

    adapt_margin: int
    """ Margin added around fluid to minimize boundary interference

    :type: int
    """

    adapt_threshold: float
    """ Minimum amount of fluid a cell can contain before it is considered empty

    :type: float
    """

    additional_res: int
    """ Maximum number of additional cells

    :type: int
    """

    alpha: float
    """ Buoyant force based on smoke density (higher value results in faster rising smoke)

    :type: float
    """

    beta: float
    """ Buoyant force based on smoke heat (higher value results in faster rising smoke)

    :type: float
    """

    burning_rate: float
    """ Speed of the burning reaction (higher value results in smaller flames)

    :type: float
    """

    cache_data_format: typing.Union[int, str]
    """ Select the file format to be used for caching volumetric data

    :type: typing.Union[int, str]
    """

    cache_directory: typing.Union[str, typing.Any]
    """ Directory that contains fluid cache files

    :type: typing.Union[str, typing.Any]
    """

    cache_frame_end: int
    """ Frame on which the simulation stops. This is the last frame that will be baked

    :type: int
    """

    cache_frame_offset: int
    """ Frame offset that is used when loading the simulation from the cache. It is not considered when baking the simulation, only when loading it

    :type: int
    """

    cache_frame_pause_data: int
    """ 

    :type: int
    """

    cache_frame_pause_guide: int
    """ 

    :type: int
    """

    cache_frame_pause_mesh: int
    """ 

    :type: int
    """

    cache_frame_pause_noise: int
    """ 

    :type: int
    """

    cache_frame_pause_particles: int
    """ 

    :type: int
    """

    cache_frame_start: int
    """ Frame on which the simulation starts. This is the first frame that will be baked

    :type: int
    """

    cache_mesh_format: typing.Union[int, str]
    """ Select the file format to be used for caching surface data

    :type: typing.Union[int, str]
    """

    cache_noise_format: typing.Union[int, str]
    """ Select the file format to be used for caching noise data

    :type: typing.Union[int, str]
    """

    cache_particle_format: typing.Union[int, str]
    """ Select the file format to be used for caching particle data

    :type: typing.Union[int, str]
    """

    cache_resumable: bool
    """ Additional data will be saved so that the bake jobs can be resumed after pausing. Because more data will be written to disk it is recommended to avoid enabling this option when baking at high resolutions

    :type: bool
    """

    cache_type: typing.Union[int, str]
    """ Change the cache type of the simulation

    :type: typing.Union[int, str]
    """

    cell_size: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Cell Size

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    cfl_condition: float
    """ Maximal velocity per cell (greater CFL numbers will minimize the number of simulation steps and the computation time.)

    :type: float
    """

    clipping: float
    """ Value under which voxels are considered empty space to optimize rendering

    :type: float
    """

    color_grid: bpy_prop_array[float]
    """ Smoke color grid

    :type: bpy_prop_array[float]
    """

    color_ramp: "ColorRamp"
    """ 

    :type: 'ColorRamp'
    """

    color_ramp_field: typing.Union[int, str]
    """ Simulation field to color map

    :type: typing.Union[int, str]
    """

    color_ramp_field_scale: float
    """ Multiplier for scaling the selected field to color map

    :type: float
    """

    delete_in_obstacle: bool
    """ Delete fluid inside obstacles

    :type: bool
    """

    density_grid: bpy_prop_array[float]
    """ Smoke density grid

    :type: bpy_prop_array[float]
    """

    display_interpolation: typing.Union[int, str]
    """ Interpolation method to use for smoke/fire volumes in solid mode

    :type: typing.Union[int, str]
    """

    display_thickness: float
    """ Thickness of smoke display in the viewport

    :type: float
    """

    dissolve_speed: int
    """ Determine how quickly the smoke dissolves (lower value makes smoke disappear faster)

    :type: int
    """

    domain_resolution: bpy_prop_array[int]
    """ Smoke Grid Resolution

    :type: bpy_prop_array[int]
    """

    domain_type: typing.Union[int, str]
    """ Change domain type of the simulation

    :type: typing.Union[int, str]
    """

    effector_group: "Collection"
    """ Limit effectors to this collection

    :type: 'Collection'
    """

    effector_weights: "EffectorWeights"
    """ 

    :type: 'EffectorWeights'
    """

    export_manta_script: bool
    """ Generate and export Mantaflow script from current domain settings during bake. This is only needed if you plan to analyze the cache (e.g. view grids, velocity vectors, particles) in Mantaflow directly (outside of Blender) after baking the simulation

    :type: bool
    """

    flame_grid: bpy_prop_array[float]
    """ Smoke flame grid

    :type: bpy_prop_array[float]
    """

    flame_ignition: float
    """ Minimum temperature of the flames (higher value results in faster rising flames)

    :type: float
    """

    flame_max_temp: float
    """ Maximum temperature of the flames (higher value results in faster rising flames)

    :type: float
    """

    flame_smoke: float
    """ Amount of smoke created by burning fuel

    :type: float
    """

    flame_smoke_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of smoke emitted from burning fuel

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    flame_vorticity: float
    """ Additional vorticity for the flames

    :type: float
    """

    flip_ratio: float
    """ PIC/FLIP Ratio. A value of 1.0 will result in a completely FLIP based simulation. Use a lower value for simulations which should produce smaller splashes

    :type: float
    """

    fluid_group: "Collection"
    """ Limit fluid objects to this collection

    :type: 'Collection'
    """

    force_collection: "Collection"
    """ Limit forces to this collection

    :type: 'Collection'
    """

    fractions_distance: float
    """ Determines how far apart fluid and obstacle are (higher values will result in fluid being further away from obstacles, smaller values will let fluid move towards the inside of obstacles)

    :type: float
    """

    fractions_threshold: float
    """ Determines how much fluid is allowed in an obstacle cell (higher values will tag a boundary cell as an obstacle easier and reduce the boundary smoothening effect)

    :type: float
    """

    gravity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Gravity in X, Y and Z direction

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    gridlines_cell_filter: typing.Union[int, str]
    """ Cell type to be highlighted

    :type: typing.Union[int, str]
    """

    gridlines_color_field: typing.Union[int, str]
    """ Simulation field to color map onto gridlines

    :type: typing.Union[int, str]
    """

    gridlines_lower_bound: float
    """ Lower bound of the highlighting range

    :type: float
    """

    gridlines_range_color: bpy_prop_array[float]
    """ Color used to highlight the range

    :type: bpy_prop_array[float]
    """

    gridlines_upper_bound: float
    """ Upper bound of the highlighting range

    :type: float
    """

    guide_alpha: float
    """ Guiding weight (higher value results in greater lag)

    :type: float
    """

    guide_beta: int
    """ Guiding size (higher value results in larger vortices)

    :type: int
    """

    guide_parent: "Object"
    """ Use velocities from this object for the guiding effect (object needs to have fluid modifier and be of type domain))

    :type: 'Object'
    """

    guide_source: typing.Union[int, str]
    """ Choose where to get guiding velocities from

    :type: typing.Union[int, str]
    """

    guide_vel_factor: float
    """ Guiding velocity factor (higher value results in greater guiding velocities)

    :type: float
    """

    has_cache_baked_any: bool
    """ 

    :type: bool
    """

    has_cache_baked_data: bool
    """ 

    :type: bool
    """

    has_cache_baked_guide: bool
    """ 

    :type: bool
    """

    has_cache_baked_mesh: bool
    """ 

    :type: bool
    """

    has_cache_baked_noise: bool
    """ 

    :type: bool
    """

    has_cache_baked_particles: bool
    """ 

    :type: bool
    """

    heat_grid: bpy_prop_array[float]
    """ Smoke heat grid

    :type: bpy_prop_array[float]
    """

    highres_sampling: typing.Union[int, str]
    """ Method for sampling the high resolution flow

    :type: typing.Union[int, str]
    """

    is_cache_baking_any: bool
    """ 

    :type: bool
    """

    is_cache_baking_data: bool
    """ 

    :type: bool
    """

    is_cache_baking_guide: bool
    """ 

    :type: bool
    """

    is_cache_baking_mesh: bool
    """ 

    :type: bool
    """

    is_cache_baking_noise: bool
    """ 

    :type: bool
    """

    is_cache_baking_particles: bool
    """ 

    :type: bool
    """

    mesh_concave_lower: float
    """ Lower mesh concavity bound (high values tend to smoothen and fill out concave regions)

    :type: float
    """

    mesh_concave_upper: float
    """ Upper mesh concavity bound (high values tend to smoothen and fill out concave regions)

    :type: float
    """

    mesh_generator: typing.Union[int, str]
    """ Which particle level set generator to use

    :type: typing.Union[int, str]
    """

    mesh_particle_radius: float
    """ Particle radius factor (higher value results in larger (meshed) particles). Needs to be adjusted after changing the mesh scale

    :type: float
    """

    mesh_scale: int
    """ The mesh simulation is scaled up by this factor (compared to the base resolution of the domain). For best meshing, it is recommended to adjust the mesh particle radius alongside this value

    :type: int
    """

    mesh_smoothen_neg: int
    """ Negative mesh smoothening

    :type: int
    """

    mesh_smoothen_pos: int
    """ Positive mesh smoothening

    :type: int
    """

    noise_pos_scale: float
    """ Scale of noise (higher value results in larger vortices)

    :type: float
    """

    noise_scale: int
    """ The noise simulation is scaled up by this factor (compared to the base resolution of the domain)

    :type: int
    """

    noise_strength: float
    """ Strength of noise

    :type: float
    """

    noise_time_anim: float
    """ Animation time of noise

    :type: float
    """

    openvdb_cache_compress_type: typing.Union[int, str]
    """ Compression method to be used

    :type: typing.Union[int, str]
    """

    openvdb_data_depth: typing.Union[int, str]
    """ Bit depth for fluid particles and grids (lower bit values reduce file size)

    :type: typing.Union[int, str]
    """

    particle_band_width: float
    """ Particle (narrow) band width (higher value results in thicker band and more particles)

    :type: float
    """

    particle_max: int
    """ Maximum number of particles per cell (ensures that each cell has at most this amount of particles)

    :type: int
    """

    particle_min: int
    """ Minimum number of particles per cell (ensures that each cell has at least this amount of particles)

    :type: int
    """

    particle_number: int
    """ Particle number factor (higher value results in more particles)

    :type: int
    """

    particle_radius: float
    """ Particle radius factor. Increase this value if the simulation appears to leak volume, decrease it if the simulation seems to gain volume

    :type: float
    """

    particle_randomness: float
    """ Randomness factor for particle sampling

    :type: float
    """

    particle_scale: int
    """ The particle simulation is scaled up by this factor (compared to the base resolution of the domain)

    :type: int
    """

    resolution_max: int
    """ Resolution used for the fluid domain. Value corresponds to the longest domain side (resolution for other domain sides is calculated automatically)

    :type: int
    """

    show_gridlines: bool
    """ Show gridlines

    :type: bool
    """

    show_velocity: bool
    """ Visualize vector fields

    :type: bool
    """

    simulation_method: typing.Union[int, str]
    """ Change the underlying simulation method

    :type: typing.Union[int, str]
    """

    slice_axis: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    slice_depth: float
    """ Position of the slice

    :type: float
    """

    slice_per_voxel: float
    """ How many slices per voxel should be generated

    :type: float
    """

    sndparticle_boundary: typing.Union[int, str]
    """ How particles that left the domain are treated

    :type: typing.Union[int, str]
    """

    sndparticle_bubble_buoyancy: float
    """ Amount of buoyancy force that rises bubbles (high value results in bubble movement mainly upwards)

    :type: float
    """

    sndparticle_bubble_drag: float
    """ Amount of drag force that moves bubbles along with the fluid (high value results in bubble movement mainly along with the fluid)

    :type: float
    """

    sndparticle_combined_export: typing.Union[int, str]
    """ Determines which particle systems are created from secondary particles

    :type: typing.Union[int, str]
    """

    sndparticle_life_max: float
    """ Highest possible particle lifetime

    :type: float
    """

    sndparticle_life_min: float
    """ Lowest possible particle lifetime

    :type: float
    """

    sndparticle_potential_max_energy: float
    """ Upper clamping threshold that indicates the fluid speed where cells no longer emit more particles (higher value results in generally less particles)

    :type: float
    """

    sndparticle_potential_max_trappedair: float
    """ Upper clamping threshold for marking fluid cells where air is trapped (higher value results in less marked cells)

    :type: float
    """

    sndparticle_potential_max_wavecrest: float
    """ Upper clamping threshold for marking fluid cells as wave crests (higher value results in less marked cells)

    :type: float
    """

    sndparticle_potential_min_energy: float
    """ Lower clamping threshold that indicates the fluid speed where cells start to emit particles (lower values result in generally more particles)

    :type: float
    """

    sndparticle_potential_min_trappedair: float
    """ Lower clamping threshold for marking fluid cells where air is trapped (lower value results in more marked cells)

    :type: float
    """

    sndparticle_potential_min_wavecrest: float
    """ Lower clamping threshold for marking fluid cells as wave crests (lower value results in more marked cells)

    :type: float
    """

    sndparticle_potential_radius: int
    """ Radius to compute potential for each cell (higher values are slower but create smoother potential grids)

    :type: int
    """

    sndparticle_sampling_trappedair: int
    """ Maximum number of particles generated per trapped air cell per frame

    :type: int
    """

    sndparticle_sampling_wavecrest: int
    """ Maximum number of particles generated per wave crest cell per frame

    :type: int
    """

    sndparticle_update_radius: int
    """ Radius to compute position update for each particle (higher values are slower but particles move less chaotic)

    :type: int
    """

    start_point: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Start point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    surface_tension: float
    """ Surface tension of liquid (higher value results in greater hydrophobic behavior)

    :type: float
    """

    sys_particle_maximum: int
    """ Maximum number of fluid particles that are allowed in this simulation

    :type: int
    """

    temperature_grid: bpy_prop_array[float]
    """ Smoke temperature grid, range 0 to 1 represents 0 to 1000K

    :type: bpy_prop_array[float]
    """

    time_scale: float
    """ Adjust simulation speed

    :type: float
    """

    timesteps_max: int
    """ Maximum number of simulation steps to perform for one frame

    :type: int
    """

    timesteps_min: int
    """ Minimum number of simulation steps to perform for one frame

    :type: int
    """

    use_adaptive_domain: bool
    """ Adapt simulation resolution and size to fluid

    :type: bool
    """

    use_adaptive_timesteps: bool
    """ 

    :type: bool
    """

    use_bubble_particles: bool
    """ Create bubble particle system

    :type: bool
    """

    use_collision_border_back: bool
    """ Enable collisions with back domain border

    :type: bool
    """

    use_collision_border_bottom: bool
    """ Enable collisions with bottom domain border

    :type: bool
    """

    use_collision_border_front: bool
    """ Enable collisions with front domain border

    :type: bool
    """

    use_collision_border_left: bool
    """ Enable collisions with left domain border

    :type: bool
    """

    use_collision_border_right: bool
    """ Enable collisions with right domain border

    :type: bool
    """

    use_collision_border_top: bool
    """ Enable collisions with top domain border

    :type: bool
    """

    use_color_ramp: bool
    """ Render a simulation field while mapping its voxels values to the colors of a ramp or using a predefined color code

    :type: bool
    """

    use_diffusion: bool
    """ Enable fluid diffusion settings (e.g. viscosity, surface tension)

    :type: bool
    """

    use_dissolve_smoke: bool
    """ Let smoke disappear over time

    :type: bool
    """

    use_dissolve_smoke_log: bool
    """ Dissolve smoke in a logarithmic fashion. Dissolves quickly at first, but lingers longer

    :type: bool
    """

    use_flip_particles: bool
    """ Create liquid particle system

    :type: bool
    """

    use_foam_particles: bool
    """ Create foam particle system

    :type: bool
    """

    use_fractions: bool
    """ Fractional obstacles improve and smoothen the fluid-obstacle boundary

    :type: bool
    """

    use_guide: bool
    """ Enable fluid guiding

    :type: bool
    """

    use_mesh: bool
    """ Enable fluid mesh (using amplification)

    :type: bool
    """

    use_noise: bool
    """ Enable fluid noise (using amplification)

    :type: bool
    """

    use_slice: bool
    """ Perform a single slice of the domain object

    :type: bool
    """

    use_speed_vectors: bool
    """ Caches velocities of mesh vertices. These will be used (automatically) when rendering with motion blur enabled

    :type: bool
    """

    use_spray_particles: bool
    """ Create spray particle system

    :type: bool
    """

    use_tracer_particles: bool
    """ Create tracer particle system

    :type: bool
    """

    use_viscosity: bool
    """ Simulate fluids with high viscosity using a special solver

    :type: bool
    """

    vector_display_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    vector_field: typing.Union[int, str]
    """ Vector field to be represented by the display vectors

    :type: typing.Union[int, str]
    """

    vector_scale: float
    """ Multiplier for scaling the vectors

    :type: float
    """

    vector_scale_with_magnitude: bool
    """ Scale vectors with their magnitudes

    :type: bool
    """

    vector_show_mac_x: bool
    """ Show X-component of MAC Grid

    :type: bool
    """

    vector_show_mac_y: bool
    """ Show Y-component of MAC Grid

    :type: bool
    """

    vector_show_mac_z: bool
    """ Show Z-component of MAC Grid

    :type: bool
    """

    velocity_grid: bpy_prop_array[float]
    """ Smoke velocity grid

    :type: bpy_prop_array[float]
    """

    velocity_scale: float
    """ Factor to control the amount of motion blur

    :type: float
    """

    viscosity_base: float
    """ Viscosity setting: value that is multiplied by 10 to the power of (exponent*-1)

    :type: float
    """

    viscosity_exponent: int
    """ Negative exponent for the viscosity value (to simplify entering small values e.g. 5*10^-6)

    :type: int
    """

    viscosity_value: float
    """ Viscosity of liquid (higher values result in more viscous fluids, a value of 0 will still apply some viscosity)

    :type: float
    """

    vorticity: float
    """ Amount of turbulence and rotation in smoke

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FluidEffectorSettings(bpy_struct):
    """Smoke collision settings"""

    effector_type: typing.Union[int, str]
    """ Change type of effector in the simulation

    :type: typing.Union[int, str]
    """

    guide_mode: typing.Union[int, str]
    """ How to create guiding velocities

    :type: typing.Union[int, str]
    """

    subframes: int
    """ Number of additional samples to take between frames to improve quality of fast moving effector objects

    :type: int
    """

    surface_distance: float
    """ Additional distance around mesh surface to consider as effector

    :type: float
    """

    use_effector: bool
    """ Control when to apply the effector

    :type: bool
    """

    use_plane_init: bool
    """ Treat this object as a planar, unclosed mesh

    :type: bool
    """

    velocity_factor: float
    """ Multiplier of obstacle velocity

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FluidFlowSettings(bpy_struct):
    """Fluid flow settings"""

    density: float
    """ 

    :type: float
    """

    density_vertex_group: typing.Union[str, typing.Any]
    """ Name of vertex group which determines surface emission rate

    :type: typing.Union[str, typing.Any]
    """

    flow_behavior: typing.Union[int, str]
    """ Change flow behavior in the simulation

    :type: typing.Union[int, str]
    """

    flow_source: typing.Union[int, str]
    """ Change how fluid is emitted

    :type: typing.Union[int, str]
    """

    flow_type: typing.Union[int, str]
    """ Change type of fluid in the simulation

    :type: typing.Union[int, str]
    """

    fuel_amount: float
    """ 

    :type: float
    """

    noise_texture: "Texture"
    """ Texture that controls emission strength

    :type: 'Texture'
    """

    particle_size: float
    """ Particle size in simulation cells

    :type: float
    """

    particle_system: "ParticleSystem"
    """ Particle systems emitted from the object

    :type: 'ParticleSystem'
    """

    smoke_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of smoke

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    subframes: int
    """ Number of additional samples to take between frames to improve quality of fast moving flows

    :type: int
    """

    surface_distance: float
    """ Controls fluid emission from the mesh surface (higher value results in emission further away from the mesh surface

    :type: float
    """

    temperature: float
    """ Temperature difference to ambient temperature

    :type: float
    """

    texture_map_type: typing.Union[int, str]
    """ Texture mapping type

    :type: typing.Union[int, str]
    """

    texture_offset: float
    """ Z-offset of texture mapping

    :type: float
    """

    texture_size: float
    """ Size of texture mapping

    :type: float
    """

    use_absolute: bool
    """ Only allow given density value in emitter area and will not add up

    :type: bool
    """

    use_inflow: bool
    """ Control when to apply fluid flow

    :type: bool
    """

    use_initial_velocity: bool
    """ Fluid has some initial velocity when it is emitted

    :type: bool
    """

    use_particle_size: bool
    """ Set particle size in simulation cells or use nearest cell

    :type: bool
    """

    use_plane_init: bool
    """ Treat this object as a planar and unclosed mesh. Fluid will only be emitted from the mesh surface and based on the surface emission value

    :type: bool
    """

    use_texture: bool
    """ Use a texture to control emission strength

    :type: bool
    """

    uv_layer: typing.Union[str, typing.Any]
    """ UV map name

    :type: typing.Union[str, typing.Any]
    """

    velocity_coord: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Additional initial velocity in X, Y and Z direction (added to source velocity)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    velocity_factor: float
    """ Multiplier of source velocity passed to fluid (source velocity is non-zero only if object is moving)

    :type: float
    """

    velocity_normal: float
    """ Amount of normal directional velocity

    :type: float
    """

    velocity_random: float
    """ Amount of random velocity

    :type: float
    """

    volume_density: float
    """ Controls fluid emission from within the mesh (higher value results in greater emissions from inside the mesh)

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FreestyleLineSet(bpy_struct):
    """Line set for associating lines and style parameters"""

    collection: "Collection"
    """ A collection of objects based on which feature edges are selected

    :type: 'Collection'
    """

    collection_negation: typing.Union[int, str]
    """ Specify either inclusion or exclusion of feature edges belonging to a collection of objects

    :type: typing.Union[int, str]
    """

    edge_type_combination: typing.Union[int, str]
    """ Specify a logical combination of selection conditions on feature edge types

    :type: typing.Union[int, str]
    """

    edge_type_negation: typing.Union[int, str]
    """ Specify either inclusion or exclusion of feature edges selected by edge types

    :type: typing.Union[int, str]
    """

    exclude_border: bool
    """ Exclude border edges

    :type: bool
    """

    exclude_contour: bool
    """ Exclude contours

    :type: bool
    """

    exclude_crease: bool
    """ Exclude crease edges

    :type: bool
    """

    exclude_edge_mark: bool
    """ Exclude edge marks

    :type: bool
    """

    exclude_external_contour: bool
    """ Exclude external contours

    :type: bool
    """

    exclude_material_boundary: bool
    """ Exclude edges at material boundaries

    :type: bool
    """

    exclude_ridge_valley: bool
    """ Exclude ridges and valleys

    :type: bool
    """

    exclude_silhouette: bool
    """ Exclude silhouette edges

    :type: bool
    """

    exclude_suggestive_contour: bool
    """ Exclude suggestive contours

    :type: bool
    """

    face_mark_condition: typing.Union[int, str]
    """ Specify a feature edge selection condition based on face marks

    :type: typing.Union[int, str]
    """

    face_mark_negation: typing.Union[int, str]
    """ Specify either inclusion or exclusion of feature edges selected by face marks

    :type: typing.Union[int, str]
    """

    linestyle: "FreestyleLineStyle"
    """ Line style settings

    :type: 'FreestyleLineStyle'
    """

    name: typing.Union[str, typing.Any]
    """ Line set name

    :type: typing.Union[str, typing.Any]
    """

    qi_end: int
    """ Last QI value of the QI range

    :type: int
    """

    qi_start: int
    """ First QI value of the QI range

    :type: int
    """

    select_border: bool
    """ Select border edges (open mesh edges)

    :type: bool
    """

    select_by_collection: bool
    """ Select feature edges based on a collection of objects

    :type: bool
    """

    select_by_edge_types: bool
    """ Select feature edges based on edge types

    :type: bool
    """

    select_by_face_marks: bool
    """ Select feature edges by face marks

    :type: bool
    """

    select_by_image_border: bool
    """ Select feature edges by image border (less memory consumption)

    :type: bool
    """

    select_by_visibility: bool
    """ Select feature edges based on visibility

    :type: bool
    """

    select_contour: bool
    """ Select contours (outer silhouettes of each object)

    :type: bool
    """

    select_crease: bool
    """ Select crease edges (those between two faces making an angle smaller than the Crease Angle)

    :type: bool
    """

    select_edge_mark: bool
    """ Select edge marks (edges annotated by Freestyle edge marks)

    :type: bool
    """

    select_external_contour: bool
    """ Select external contours (outer silhouettes of occluding and occluded objects)

    :type: bool
    """

    select_material_boundary: bool
    """ Select edges at material boundaries

    :type: bool
    """

    select_ridge_valley: bool
    """ Select ridges and valleys (boundary lines between convex and concave areas of surface)

    :type: bool
    """

    select_silhouette: bool
    """ Select silhouettes (edges at the boundary of visible and hidden faces)

    :type: bool
    """

    select_suggestive_contour: bool
    """ Select suggestive contours (almost silhouette/contour edges)

    :type: bool
    """

    show_render: bool
    """ Enable or disable this line set during stroke rendering

    :type: bool
    """

    visibility: typing.Union[int, str]
    """ Determine how to use visibility for feature edge selection

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FreestyleModuleSettings(bpy_struct):
    """Style module configuration for specifying a style module"""

    script: "Text"
    """ Python script to define a style module

    :type: 'Text'
    """

    use: bool
    """ Enable or disable this style module during stroke rendering

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class FreestyleSettings(bpy_struct):
    """Freestyle settings for a ViewLayer data-block"""

    as_render_pass: bool
    """ Renders Freestyle output to a separate pass instead of overlaying it on the Combined pass

    :type: bool
    """

    crease_angle: float
    """ Angular threshold for detecting crease edges

    :type: float
    """

    kr_derivative_epsilon: float
    """ Kr derivative epsilon for computing suggestive contours

    :type: float
    """

    linesets: "Linesets"
    """ 

    :type: 'Linesets'
    """

    mode: typing.Union[int, str]
    """ Select the Freestyle control mode

    :type: typing.Union[int, str]
    """

    modules: "FreestyleModules"
    """ A list of style modules (to be applied from top to bottom)

    :type: 'FreestyleModules'
    """

    sphere_radius: float
    """ Sphere radius for computing curvatures

    :type: float
    """

    use_culling: bool
    """ If enabled, out-of-view edges are ignored

    :type: bool
    """

    use_material_boundaries: bool
    """ Enable material boundaries

    :type: bool
    """

    use_ridges_and_valleys: bool
    """ Enable ridges and valleys

    :type: bool
    """

    use_smoothness: bool
    """ Take face smoothness into account in view map calculation

    :type: bool
    """

    use_suggestive_contours: bool
    """ Enable suggestive contours

    :type: bool
    """

    use_view_map_cache: bool
    """ Keep the computed view map and avoid recalculating it if mesh geometry is unchanged

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Function(bpy_struct):
    """RNA function definition"""

    description: typing.Union[str, typing.Any]
    """ Description of the Function's purpose

    :type: typing.Union[str, typing.Any]
    """

    identifier: typing.Union[str, typing.Any]
    """ Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    """

    is_registered: typing.Union[bool, typing.Any]
    """ Function is registered as callback as part of type registration

    :type: typing.Union[bool, typing.Any]
    """

    is_registered_optional: typing.Union[bool, typing.Any]
    """ Function is optionally registered as callback part of type registration

    :type: typing.Union[bool, typing.Any]
    """

    parameters: bpy_prop_collection["Property"]
    """ Parameters for the function

    :type: bpy_prop_collection['Property']
    """

    use_self: typing.Union[bool, typing.Any]
    """ Function does not pass itself as an argument (becomes a static method in Python)

    :type: typing.Union[bool, typing.Any]
    """

    use_self_type: typing.Union[bool, typing.Any]
    """ Function passes itself type as an argument (becomes a class method in Python if use_self is false)

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilEditCurve(bpy_struct):
    """Edition Curve"""

    curve_points: bpy_prop_collection["GPencilEditCurvePoint"]
    """ Curve data points

    :type: bpy_prop_collection['GPencilEditCurvePoint']
    """

    select: bool
    """ Curve is selected for viewport editing

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilEditCurvePoint(bpy_struct):
    """Bézier curve point with two handles"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Coordinates of the control point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_left: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Coordinates of the first handle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_right: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Coordinates of the second handle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    hide: bool
    """ Visibility status

    :type: bool
    """

    point_index: int
    """ Index of the corresponding grease pencil stroke point

    :type: int
    """

    pressure: float
    """ Pressure of the grease pencil stroke point

    :type: float
    """

    select_control_point: bool
    """ Control point selection status

    :type: bool
    """

    select_left_handle: bool
    """ Handle 1 selection status

    :type: bool
    """

    select_right_handle: bool
    """ Handle 2 selection status

    :type: bool
    """

    strength: float
    """ Color intensity (alpha factor) of the grease pencil stroke point

    :type: float
    """

    uv_factor: float
    """ Internal UV factor

    :type: float
    """

    uv_rotation: float
    """ Internal UV factor for dot mode

    :type: float
    """

    vertex_color: bpy_prop_array[float]
    """ Vertex color of the grease pencil stroke point

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilFrame(bpy_struct):
    """Collection of related sketches on a particular frame"""

    frame_number: int
    """ The frame on which this sketch appears

    :type: int
    """

    is_edited: bool
    """ Frame is being edited (painted on)

    :type: bool
    """

    keyframe_type: typing.Union[int, str]
    """ Type of keyframe

    :type: typing.Union[int, str]
    """

    select: bool
    """ Frame is selected for editing in the Dope Sheet

    :type: bool
    """

    strokes: "GPencilStrokes"
    """ Freehand curves defining the sketch on this frame

    :type: 'GPencilStrokes'
    """

    def clear(self):
        """Remove all the grease pencil frame data"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilInterpolateSettings(bpy_struct):
    """Settings for Grease Pencil interpolation tools"""

    interpolation_curve: "CurveMapping"
    """ Custom curve to control 'sequence' interpolation between Grease Pencil frames

    :type: 'CurveMapping'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilLayer(bpy_struct):
    """Collection of related sketches"""

    active_frame: "GPencilFrame"
    """ Frame currently being displayed for this layer

    :type: 'GPencilFrame'
    """

    annotation_hide: bool
    """ Set annotation Visibility

    :type: bool
    """

    annotation_onion_after_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Base color for ghosts after the active frame

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    annotation_onion_after_range: int
    """ Maximum number of frames to show after current frame

    :type: int
    """

    annotation_onion_before_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Base color for ghosts before the active frame

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    annotation_onion_before_range: int
    """ Maximum number of frames to show before current frame

    :type: int
    """

    annotation_opacity: float
    """ Annotation Layer Opacity

    :type: float
    """

    blend_mode: typing.Union[int, str]
    """ Blend mode

    :type: typing.Union[int, str]
    """

    channel_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Custom color for animation channel in Dopesheet

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color for all strokes in this layer

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    frames: "GPencilFrames"
    """ Sketches for this layer on different frames

    :type: 'GPencilFrames'
    """

    hide: bool
    """ Set layer Visibility

    :type: bool
    """

    info: typing.Union[str, typing.Any]
    """ Layer name

    :type: typing.Union[str, typing.Any]
    """

    is_parented: typing.Union[bool, typing.Any]
    """ True when the layer parent object is set

    :type: typing.Union[bool, typing.Any]
    """

    is_ruler: typing.Union[bool, typing.Any]
    """ This is a special ruler layer

    :type: typing.Union[bool, typing.Any]
    """

    line_change: int
    """ Thickness change to apply to current strokes (in pixels)

    :type: int
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Values for change location

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    lock: bool
    """ Protect layer from further editing and/or frame changes

    :type: bool
    """

    lock_frame: bool
    """ Lock current frame displayed by layer

    :type: bool
    """

    lock_material: bool
    """ Avoids editing locked materials in the layer

    :type: bool
    """

    mask_layers: "GreasePencilMaskLayers"
    """ List of Masking Layers

    :type: 'GreasePencilMaskLayers'
    """

    matrix_inverse: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Parent inverse transformation matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_inverse_layer: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Local Layer transformation inverse matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_layer: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Local Layer transformation matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    opacity: float
    """ Layer Opacity

    :type: float
    """

    parent: "Object"
    """ Parent object

    :type: 'Object'
    """

    parent_bone: typing.Union[str, typing.Any]
    """ Name of parent bone in case of a bone parenting relation

    :type: typing.Union[str, typing.Any]
    """

    parent_type: typing.Union[int, str]
    """ Type of parent relation

    :type: typing.Union[int, str]
    """

    pass_index: int
    """ Index number for the "Layer Index" pass

    :type: int
    """

    rotation: typing.Union[
        "mathutils.Euler", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Values for changes in rotation

    :type: typing.Union['mathutils.Euler', typing.List[float], typing.Tuple[float, float, float]]
    """

    scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Values for changes in scale

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    select: bool
    """ Layer is selected for editing in the Dope Sheet

    :type: bool
    """

    show_in_front: bool
    """ Make the layer display in front of objects

    :type: bool
    """

    show_points: bool
    """ Show the points which make up the strokes (for debugging purposes)

    :type: bool
    """

    thickness: int
    """ Thickness of annotation strokes

    :type: int
    """

    tint_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color for tinting stroke colors

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    tint_factor: float
    """ Factor of tinting color

    :type: float
    """

    use_annotation_onion_skinning: bool
    """ Display annotation onion skins before and after the current frame

    :type: bool
    """

    use_lights: bool
    """ Enable the use of lights on stroke and fill materials

    :type: bool
    """

    use_mask_layer: bool
    """ The visibility of drawings on this layer is affected by the layers in its masks list

    :type: bool
    """

    use_onion_skinning: bool
    """ Display onion skins before and after the current frame

    :type: bool
    """

    use_solo_mode: bool
    """ In Draw Mode only display layers with keyframe in current frame

    :type: bool
    """

    use_viewlayer_masks: bool
    """ Include the mask layers when rendering the view-layer

    :type: bool
    """

    vertex_paint_opacity: float
    """ Vertex Paint mix factor

    :type: float
    """

    viewlayer_render: typing.Union[str, typing.Any]
    """ Only include Layer in this View Layer render output (leave blank to include always)

    :type: typing.Union[str, typing.Any]
    """

    def clear(self):
        """Remove all the grease pencil layer data"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilLayerMask(bpy_struct):
    """List of Mask Layers"""

    hide: bool
    """ Set mask Visibility

    :type: bool
    """

    invert: bool
    """ Invert mask

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Mask layer name

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilSculptGuide(bpy_struct):
    """Guides for drawing"""

    angle: float
    """ Direction of lines

    :type: float
    """

    angle_snap: float
    """ Angle snapping

    :type: float
    """

    location: bpy_prop_array[float]
    """ Custom reference point for guides

    :type: bpy_prop_array[float]
    """

    reference_object: "Object"
    """ Object used for reference point

    :type: 'Object'
    """

    reference_point: typing.Union[int, str]
    """ Type of speed guide

    :type: typing.Union[int, str]
    """

    spacing: float
    """ Guide spacing

    :type: float
    """

    type: typing.Union[int, str]
    """ Type of speed guide

    :type: typing.Union[int, str]
    """

    use_guide: bool
    """ Enable speed guides

    :type: bool
    """

    use_snapping: bool
    """ Enable snapping to guides angle or spacing options

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilSculptSettings(bpy_struct):
    """General properties for Grease Pencil stroke sculpting tools"""

    guide: "GPencilSculptGuide"
    """ 

    :type: 'GPencilSculptGuide'
    """

    intersection_threshold: float
    """ Threshold for stroke intersections

    :type: float
    """

    lock_axis: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    multiframe_falloff_curve: "CurveMapping"
    """ Custom curve to control falloff of brush effect by Grease Pencil frames

    :type: 'CurveMapping'
    """

    thickness_primitive_curve: "CurveMapping"
    """ Custom curve to control primitive thickness

    :type: 'CurveMapping'
    """

    use_automasking_layer_active: bool
    """ Affect only the Active Layer

    :type: bool
    """

    use_automasking_layer_stroke: bool
    """ Affect only strokes below the cursor

    :type: bool
    """

    use_automasking_material_active: bool
    """ Affect only the Active Material

    :type: bool
    """

    use_automasking_material_stroke: bool
    """ Affect only strokes below the cursor

    :type: bool
    """

    use_automasking_stroke: bool
    """ Affect only strokes below the cursor

    :type: bool
    """

    use_multiframe_falloff: bool
    """ Use falloff effect when edit in multiframe mode to compute brush effect by frame

    :type: bool
    """

    use_scale_thickness: bool
    """ Scale the stroke thickness when transforming strokes

    :type: bool
    """

    use_thickness_curve: bool
    """ Use curve to define primitive stroke thickness

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilStroke(bpy_struct):
    """Freehand curve defining part of a sketch"""

    aspect: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    bound_box_max: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bound_box_min: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    display_mode: typing.Union[int, str]
    """ Coordinate space that stroke is in

    :type: typing.Union[int, str]
    """

    edit_curve: "GPencilEditCurve"
    """ Temporary data for Edit Curve

    :type: 'GPencilEditCurve'
    """

    end_cap_mode: typing.Union[int, str]
    """ Stroke end extreme cap style

    :type: typing.Union[int, str]
    """

    hardness: float
    """ Amount of gradient along section of stroke

    :type: float
    """

    has_edit_curve: typing.Union[bool, typing.Any]
    """ Stroke has Curve data to edit shape

    :type: typing.Union[bool, typing.Any]
    """

    is_nofill_stroke: bool
    """ Special stroke to use as boundary for filling areas

    :type: bool
    """

    line_width: int
    """ Thickness of stroke (in pixels)

    :type: int
    """

    material_index: int
    """ Material slot index of this stroke

    :type: int
    """

    points: "GPencilStrokePoints"
    """ Stroke data points

    :type: 'GPencilStrokePoints'
    """

    select: bool
    """ Stroke is selected for viewport editing

    :type: bool
    """

    select_index: int
    """ Index of selection used for interpolation

    :type: int
    """

    start_cap_mode: typing.Union[int, str]
    """ Stroke start extreme cap style

    :type: typing.Union[int, str]
    """

    time_start: float
    """ Initial time of the stroke

    :type: float
    """

    triangles: bpy_prop_collection["GPencilTriangle"]
    """ Triangulation data for HQ fill

    :type: bpy_prop_collection['GPencilTriangle']
    """

    use_cyclic: bool
    """ Enable cyclic drawing, closing the stroke

    :type: bool
    """

    uv_rotation: float
    """ Rotation of the UV

    :type: float
    """

    uv_scale: float
    """ Scale of the UV

    :type: float
    """

    uv_translation: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Translation of default UV position

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    vertex_color_fill: bpy_prop_array[float]
    """ Color used to mix with fill color to get final color

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilStrokePoint(bpy_struct):
    """Data point for freehand stroke curve"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    pressure: float
    """ Pressure of tablet at point when drawing it

    :type: float
    """

    select: bool
    """ Point is selected for viewport editing

    :type: bool
    """

    strength: float
    """ Color intensity (alpha factor)

    :type: float
    """

    time: float
    """ Time relative to stroke start

    :type: float
    """

    uv_factor: float
    """ Internal UV factor

    :type: float
    """

    uv_fill: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Internal UV factor for filling

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    uv_rotation: float
    """ Internal UV factor for dot mode

    :type: float
    """

    vertex_color: bpy_prop_array[float]
    """ Color used to mix with point color to get final color

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GPencilTriangle(bpy_struct):
    """Triangulation data for Grease Pencil fills"""

    v1: int
    """ First triangle vertex index

    :type: int
    """

    v2: int
    """ Second triangle vertex index

    :type: int
    """

    v3: int
    """ Third triangle vertex index

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Gizmo(bpy_struct):
    """Collection of gizmos"""

    alpha: float
    """ 

    :type: float
    """

    alpha_highlight: float
    """ 

    :type: float
    """

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    color_highlight: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    group: "GizmoGroup"
    """ Gizmo group this gizmo is a member of

    :type: 'GizmoGroup'
    """

    hide: bool
    """ 

    :type: bool
    """

    hide_keymap: bool
    """ Ignore the key-map for this gizmo

    :type: bool
    """

    hide_select: bool
    """ 

    :type: bool
    """

    is_highlight: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    is_modal: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    line_width: float
    """ 

    :type: float
    """

    matrix_basis: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ 

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_offset: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ 

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_space: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ 

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_world: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ 

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    properties: "GizmoProperties"
    """ 

    :type: 'GizmoProperties'
    """

    scale_basis: float
    """ 

    :type: float
    """

    select: bool
    """ 

    :type: bool
    """

    select_bias: float
    """ Depth bias used for selection

    :type: float
    """

    use_draw_hover: bool
    """ 

    :type: bool
    """

    use_draw_modal: bool
    """ Show while dragging

    :type: bool
    """

    use_draw_offset_scale: bool
    """ Scale the offset matrix (use to apply screen-space offset)

    :type: bool
    """

    use_draw_scale: bool
    """ Use scale when calculating the matrix

    :type: bool
    """

    use_draw_value: bool
    """ Show an indicator for the current value while dragging

    :type: bool
    """

    use_event_handle_all: bool
    """ When highlighted, do not pass events through to be handled by other keymaps

    :type: bool
    """

    use_grab_cursor: bool
    """ 

    :type: bool
    """

    use_operator_tool_properties: bool
    """ Merge active tool properties on activation (does not overwrite existing)

    :type: bool
    """

    use_select_background: bool
    """ Don't write into the depth buffer

    :type: bool
    """

    use_tooltip: bool
    """ Use tooltips when hovering over this gizmo

    :type: bool
    """

    def draw(self, context: "Context"):
        """

        :param context:
        :type context: 'Context'
        """
        ...

    def draw_select(
        self, context: "Context", select_id: typing.Optional[typing.Any] = 0
    ):
        """

        :param context:
        :type context: 'Context'
        :param select_id:
        :type select_id: typing.Optional[typing.Any]
        """
        ...

    def test_select(self, context: "Context", location: typing.Any) -> int:
        """

        :param context:
        :type context: 'Context'
        :param location: Location, Region coordinates
        :type location: typing.Any
        :rtype: int
        :return: Use -1 to skip this gizmo
        """
        ...

    def modal(
        self,
        context: "Context",
        event: "Event",
        tweak: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]],
    ) -> typing.Union[typing.Set[int], typing.Set[str]]:
        """

        :param context:
        :type context: 'Context'
        :param event:
        :type event: 'Event'
        :param tweak: Tweak
        :type tweak: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]]
        :rtype: typing.Union[typing.Set[int], typing.Set[str]]
        :return: result
        """
        ...

    def setup(self): ...
    def invoke(
        self, context: "Context", event: "Event"
    ) -> typing.Union[typing.Set[int], typing.Set[str]]:
        """

        :param context:
        :type context: 'Context'
        :param event:
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[int], typing.Set[str]]
        :return: result
        """
        ...

    def exit(self, context: "Context", cancel: typing.Optional[bool]):
        """

        :param context:
        :type context: 'Context'
        :param cancel: Cancel, otherwise confirm
        :type cancel: typing.Optional[bool]
        """
        ...

    def select_refresh(self): ...
    def draw_preset_box(
        self,
        matrix: typing.Optional[
            typing.Union[
                "mathutils.Matrix",
                typing.List[typing.List[float]],
                typing.Tuple[
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                ],
            ]
        ],
        select_id: typing.Optional[typing.Any] = -1,
    ):
        """Draw a box

        :param matrix: The matrix to transform
        :type matrix: typing.Optional[typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]]
        :param select_id: ID to use when gizmo is selectable. Use -1 when not selecting
        :type select_id: typing.Optional[typing.Any]
        """
        ...

    def draw_preset_arrow(
        self,
        matrix: typing.Optional[
            typing.Union[
                "mathutils.Matrix",
                typing.List[typing.List[float]],
                typing.Tuple[
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                ],
            ]
        ],
        axis: typing.Optional[typing.Any] = "POS_Z",
        select_id: typing.Optional[typing.Any] = -1,
    ):
        """Draw a box

        :param matrix: The matrix to transform
        :type matrix: typing.Optional[typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]]
        :param axis: Arrow Orientation
        :type axis: typing.Optional[typing.Any]
        :param select_id: ID to use when gizmo is selectable. Use -1 when not selecting
        :type select_id: typing.Optional[typing.Any]
        """
        ...

    def draw_preset_circle(
        self,
        matrix: typing.Optional[
            typing.Union[
                "mathutils.Matrix",
                typing.List[typing.List[float]],
                typing.Tuple[
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                    typing.Tuple[float, float, float, float],
                ],
            ]
        ],
        axis: typing.Optional[typing.Any] = "POS_Z",
        select_id: typing.Optional[typing.Any] = -1,
    ):
        """Draw a box

        :param matrix: The matrix to transform
        :type matrix: typing.Optional[typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]]
        :param axis: Arrow Orientation
        :type axis: typing.Optional[typing.Any]
        :param select_id: ID to use when gizmo is selectable. Use -1 when not selecting
        :type select_id: typing.Optional[typing.Any]
        """
        ...

    def target_set_prop(
        self,
        target: typing.Union[str, typing.Any],
        data: typing.Any,
        property: typing.Union[str, typing.Any],
        index: typing.Optional[typing.Any] = -1,
    ):
        """

        :param target: Target property
        :type target: typing.Union[str, typing.Any]
        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param index:
        :type index: typing.Optional[typing.Any]
        """
        ...

    def target_set_operator(
        self,
        operator: typing.Union[str, typing.Any],
        index: typing.Optional[typing.Any] = 0,
    ) -> "OperatorProperties":
        """Operator to run when activating the gizmo (overrides property targets)

        :param operator: Target operator
        :type operator: typing.Union[str, typing.Any]
        :param index: Part index
        :type index: typing.Optional[typing.Any]
        :rtype: 'OperatorProperties'
        :return: Operator properties to fill in
        """
        ...

    def target_is_valid(self, property: typing.Union[str, typing.Any]) -> bool:
        """

        :param property: Property identifier
        :type property: typing.Union[str, typing.Any]
        :rtype: bool
        """
        ...

    def draw_custom_shape(
        self,
        shape: typing.Optional[typing.Any],
        *,
        matrix: typing.Optional[
            typing.Union["mathutils.Matrix", typing.Sequence[float]]
        ] = None,
        select_id=None,
    ):
        """Draw a shape created form `Gizmo.draw_custom_shape`.

                :param shape: The cached shape to draw.
                :type shape: typing.Optional[typing.Any]
                :param *:
                :type *:
                :param matrix: 4x4 matrix, when not given `Gizmo.matrix_world` is used.
                :type matrix: typing.Optional[typing.Union['mathutils.Matrix', typing.Sequence[float]]]
                :param select_id: The selection id.
        Only use when drawing within `Gizmo.draw_select`.
                :type select_id:
        """
        ...

    def new_custom_shape(
        self, type: typing.Optional[str], verts: typing.Optional[typing.List]
    ) -> typing.Any:
        """Create a new shape that can be passed to `Gizmo.draw_custom_shape`.

        :param type: The type of shape to create in (POINTS, LINES, TRIS, LINE_STRIP).
        :type type: typing.Optional[str]
        :param verts: Coordinates.
        :type verts: typing.Optional[typing.List]
        :rtype: typing.Any
        :return: The newly created shape.
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

    def target_get_range(self, target) -> typing.Tuple:
        """Get the range for this target property.

        :param target: Target property name.
        :type target:
        :rtype: typing.Tuple
        :return: The range of this property (min, max).
        """
        ...

    def target_get_value(self, target: typing.Optional[str]) -> typing.List:
        """Get the value of this target property.

        :param target: Target property name.
        :type target: typing.Optional[str]
        :rtype: typing.List
        :return: The value of the target property.
        """
        ...

    def target_set_handler(
        self,
        target: typing.Optional[str],
        get: typing.Optional[typing.Callable],
        set: typing.Optional[typing.Callable],
        range: typing.Optional[typing.Callable] = None,
    ):
        """Assigns callbacks to a gizmos property.

        :param target: Target property name.
        :type target: typing.Optional[str]
        :param get: Function that returns the value for this property (single value or sequence).
        :type get: typing.Optional[typing.Callable]
        :param set: Function that takes a single value argument and applies it.
        :type set: typing.Optional[typing.Callable]
        :param range: Function that returns a (min, max) tuple for gizmos that use a range.
        :type range: typing.Optional[typing.Callable]
        """
        ...

    def target_set_value(self, target: typing.Optional[str]):
        """Set the value of this target property.

        :param target: Target property name.
        :type target: typing.Optional[str]
        """
        ...

class GizmoGroup(bpy_struct):
    """Storage of an operator being executed, or registered after execution"""

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Options for this operator type

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    bl_owner_id: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_region_type: typing.Union[int, str]
    """ The region where the panel is going to be used in

    :type: typing.Union[int, str]
    """

    bl_space_type: typing.Union[int, str]
    """ The space where the panel is going to be used in

    :type: typing.Union[int, str]
    """

    gizmos: "Gizmos"
    """ List of gizmos in the Gizmo Map

    :type: 'Gizmos'
    """

    has_reports: typing.Union[bool, typing.Any]
    """ GizmoGroup has a set of reports (warnings and errors) from last execution

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def poll(self, context: "Context") -> bool:
        """Test if the gizmo group can be called or not

        :param context:
        :type context: 'Context'
        :rtype: bool
        """
        ...

    def setup_keymap(self, keyconfig: "KeyConfig") -> "KeyMap":
        """Initialize keymaps for this gizmo group, use fallback keymap when not present

        :param keyconfig:
        :type keyconfig: 'KeyConfig'
        :rtype: 'KeyMap'
        """
        ...

    def setup(self, context: "Context"):
        """Create gizmos function for the gizmo group

        :param context:
        :type context: 'Context'
        """
        ...

    def refresh(self, context: "Context"):
        """Refresh data (called on common state changes such as selection)

        :param context:
        :type context: 'Context'
        """
        ...

    def draw_prepare(self, context: "Context"):
        """Run before each redraw

        :param context:
        :type context: 'Context'
        """
        ...

    def invoke_prepare(self, context: "Context", gizmo: "Gizmo"):
        """Run before invoke

        :param context:
        :type context: 'Context'
        :param gizmo:
        :type gizmo: 'Gizmo'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GizmoGroupProperties(bpy_struct):
    """Input properties of a Gizmo Group"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GizmoProperties(bpy_struct):
    """Input properties of a Gizmo"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GpencilModifier(bpy_struct):
    """Modifier affecting the Grease Pencil object"""

    is_override_data: typing.Union[bool, typing.Any]
    """ In a local override object, whether this modifier comes from the linked reference object, or is local to the override

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Modifier name

    :type: typing.Union[str, typing.Any]
    """

    show_expanded: bool
    """ Set modifier expanded in the user interface

    :type: bool
    """

    show_in_editmode: bool
    """ Display modifier in Edit mode

    :type: bool
    """

    show_render: bool
    """ Use modifier during render

    :type: bool
    """

    show_viewport: bool
    """ Display modifier in viewport

    :type: bool
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GpencilVertexGroupElement(bpy_struct):
    """Weight value of a vertex in a vertex group"""

    group: int
    """ 

    :type: int
    """

    weight: float
    """ Vertex Weight

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilDashModifierSegment(bpy_struct):
    """Configuration for a single dash segment"""

    dash: int
    """ The number of consecutive points from the original stroke to include in this segment

    :type: int
    """

    gap: int
    """ The number of points skipped after this segment

    :type: int
    """

    material_index: int
    """ Use this index on generated segment. -1 means using the existing material

    :type: int
    """

    name: typing.Union[str, typing.Any]
    """ Name of the dash segment

    :type: typing.Union[str, typing.Any]
    """

    opacity: float
    """ The factor to apply to the original point's opacity for the new points

    :type: float
    """

    radius: float
    """ The factor to apply to the original point's radius for the new points

    :type: float
    """

    use_cyclic: bool
    """ Enable cyclic on individual stroke dashes

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilGrid(bpy_struct):
    """Settings for grid and canvas in 3D viewport"""

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color for grid lines

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    lines: int
    """ Number of subdivisions in each side of symmetry line

    :type: int
    """

    offset: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Offset of the canvas

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Grid scale

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilLayer(bpy_struct):
    """Collection of related drawings"""

    hide: bool
    """ Set layer visibility

    :type: bool
    """

    lock: bool
    """ Protect layer from further editing and/or frame changes

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Layer name

    :type: typing.Union[str, typing.Any]
    """

    opacity: float
    """ Layer Opacity

    :type: float
    """

    parent: "Object"
    """ Parent object

    :type: 'Object'
    """

    parent_bone: typing.Union[str, typing.Any]
    """ Name of parent bone. Only used when the parent object is an armature

    :type: typing.Union[str, typing.Any]
    """

    rotation: typing.Union[
        "mathutils.Euler", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Euler rotation of the layer

    :type: typing.Union['mathutils.Euler', typing.List[float], typing.Tuple[float, float, float]]
    """

    scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale of the layer

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    translation: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Translation of the layer

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    use_onion_skinning: bool
    """ Display onion skins before and after the current frame

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class GreasePencilLayerGroup(bpy_struct):
    """Group of Grease Pencil layers"""

    hide: bool
    """ Set layer group visibility

    :type: bool
    """

    lock: bool
    """ Protect group from further editing and/or frame changes

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Group name

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Header(bpy_struct):
    """Editor header containing UI elements"""

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the header gets a custom ID, otherwise it takes the name of the class used to define the header; for example, if the class name is "OBJECT_HT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_HT_hello"

    :type: typing.Union[str, typing.Any]
    """

    bl_region_type: typing.Union[int, str]
    """ The region where the header is going to be used in (defaults to header region)

    :type: typing.Union[int, str]
    """

    bl_space_type: typing.Union[int, str]
    """ The space where the header is going to be used in

    :type: typing.Union[int, str]
    """

    layout: "UILayout"
    """ Structure of the header in the UI

    :type: 'UILayout'
    """

    def draw(self, context: typing.Optional["Context"]):
        """Draw UI elements into the header UI layout

        :param context:
        :type context: typing.Optional['Context']
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Histogram(bpy_struct):
    """Statistical view of the levels of color in an image"""

    mode: typing.Union[int, str]
    """ Channels to display in the histogram

    :type: typing.Union[int, str]
    """

    show_line: bool
    """ Display lines rather than filled shapes

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ID(bpy_struct):
    """Base type for data-blocks, defining a unique name, linking from other libraries and garbage collection"""

    asset_data: "AssetMetaData"
    """ Additional data for an asset data-block

    :type: 'AssetMetaData'
    """

    id_type: typing.Any
    """ Type identifier of this data-block

    :type: typing.Any
    """

    is_embedded_data: typing.Union[bool, typing.Any]
    """ This data-block is not an independent one, but is actually a sub-data of another ID (typical example: root node trees or master collections)

    :type: typing.Union[bool, typing.Any]
    """

    is_evaluated: typing.Union[bool, typing.Any]
    """ Whether this ID is runtime-only, evaluated data-block, or actual data from .blend file

    :type: typing.Union[bool, typing.Any]
    """

    is_library_indirect: typing.Union[bool, typing.Any]
    """ Is this ID block linked indirectly

    :type: typing.Union[bool, typing.Any]
    """

    is_missing: typing.Union[bool, typing.Any]
    """ This data-block is a place-holder for missing linked data (i.e. it is [an override of] a linked data that could not be found anymore)

    :type: typing.Union[bool, typing.Any]
    """

    is_runtime_data: bool
    """ This data-block is runtime data, i.e. it won't be saved in .blend file. Note that e.g. evaluated IDs are always runtime, so this value is only editable for data-blocks in Main data-base

    :type: bool
    """

    library: "Library"
    """ Library file the data-block is linked from

    :type: 'Library'
    """

    library_weak_reference: "LibraryWeakReference"
    """ Weak reference to a data-block in another library .blend file (used to re-use already appended data instead of appending new copies)

    :type: 'LibraryWeakReference'
    """

    name: typing.Union[str, typing.Any]
    """ Unique data-block ID name (within a same type and library)

    :type: typing.Union[str, typing.Any]
    """

    name_full: typing.Union[str, typing.Any]
    """ Unique data-block ID name, including library one is any

    :type: typing.Union[str, typing.Any]
    """

    original: "ID"
    """ Actual data-block from .blend file (Main database) that generated that evaluated one

    :type: 'ID'
    """

    override_library: "IDOverrideLibrary"
    """ Library override data

    :type: 'IDOverrideLibrary'
    """

    preview: "ImagePreview"
    """ Preview image and icon of this data-block (always None if not supported for this type of data)

    :type: 'ImagePreview'
    """

    session_uid: int
    """ A session-wide unique identifier for the data block that remains the same across renames and internal reallocations. It does change when reloading the file

    :type: int
    """

    tag: bool
    """ Tools can use this to tag data for their own purposes (initial state is undefined)

    :type: bool
    """

    use_extra_user: bool
    """ Indicates whether an extra user is set or not (mainly for internal/debug usages)

    :type: bool
    """

    use_fake_user: bool
    """ Save this data-block even if it has no users

    :type: bool
    """

    users: int
    """ Number of times this data-block is referenced

    :type: int
    """

    def evaluated_get(self, depsgraph: "Depsgraph") -> "ID":
        """Get corresponding evaluated ID from the given dependency graph. Note that this does not ensure the dependency graph is fully evaluated, it just returns the result of the last evaluation

        :param depsgraph: Dependency graph to perform lookup in
        :type depsgraph: 'Depsgraph'
        :rtype: 'ID'
        :return: New copy of the ID
        """
        ...

    def copy(self) -> "ID":
        """Create a copy of this data-block (not supported for all data-blocks). The result is added to the Blend-File Data (Main database), with all references to other data-blocks ensured to be from within the same Blend-File Data

        :rtype: 'ID'
        :return: New copy of the ID
        """
        ...

    def asset_mark(self):
        """Enable easier reuse of the data-block through the Asset Browser, with the help of customizable metadata (like previews, descriptions and tags)"""
        ...

    def asset_clear(self):
        """Delete all asset metadata and turn the asset data-block back into a normal data-block"""
        ...

    def asset_generate_preview(self):
        """Generate preview image (might be scheduled in a background thread)"""
        ...

    def override_create(
        self,
        remap_local_usages: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "ID":
        """Create an overridden local copy of this linked data-block (not supported for all data-blocks)

        :param remap_local_usages: Whether local usages of the linked ID should be remapped to the new library override of it
        :type remap_local_usages: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'ID'
        :return: New overridden local copy of the ID
        """
        ...

    def override_hierarchy_create(
        self,
        scene: "Scene",
        view_layer: "ViewLayer",
        reference: typing.Optional["ID"] = None,
        do_fully_editable: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "ID":
        """Create an overridden local copy of this linked data-block, and most of its dependencies when it is a Collection or and Object

        :param scene: In which scene the new overrides should be instantiated
        :type scene: 'Scene'
        :param view_layer: In which view layer the new overrides should be instantiated
        :type view_layer: 'ViewLayer'
        :param reference: Another ID (usually an Object or Collection) used as a hint to decide where to instantiate the new overrides
        :type reference: typing.Optional['ID']
        :param do_fully_editable: Make all library overrides generated by this call fully editable by the user (none will be 'system overrides')
        :type do_fully_editable: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'ID'
        :return: New overridden local copy of the root ID
        """
        ...

    def user_clear(self):
        """Clear the user count of a data-block so its not saved, on reload the data will be removedThis function is for advanced use only, misuse can crash blender since the user
        count is used to prevent data being removed when it is used.

        """
        ...

    def user_remap(self, new_id: "ID"):
        """Replace all usage in the .blend file of this ID by new given one

        :param new_id: New ID to use
        :type new_id: 'ID'
        """
        ...

    def make_local(
        self,
        clear_proxy: typing.Optional[typing.Union[bool, typing.Any]] = True,
        clear_liboverride: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "ID":
        """Make this datablock local, return local one (may be a copy of the original, in case it is also indirectly used)

        :param clear_proxy: Deprecated, has no effect
        :type clear_proxy: typing.Optional[typing.Union[bool, typing.Any]]
        :param clear_liboverride: Remove potential library override data from the newly made local data
        :type clear_liboverride: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'ID'
        :return: This ID, or the new ID if it was copied
        """
        ...

    def user_of_id(self, id: "ID") -> int:
        """Count the number of times that ID uses/references given one

        :param id: ID to count usages
        :type id: 'ID'
        :rtype: int
        :return: Number of usages/references of given id by current data-block
        """
        ...

    def animation_data_create(self) -> "AnimData":
        """Create animation data to this ID, note that not all ID types support this

        :rtype: 'AnimData'
        :return: New animation data or nullptr
        """
        ...

    def animation_data_clear(self):
        """Clear animation on this ID"""
        ...

    def update_tag(self, refresh: typing.Optional[typing.Any] = {}):
        """Tag the ID to update its display data, e.g. when calling `bpy.types.Scene.update`

        :param refresh: Type of updates to perform
        :type refresh: typing.Optional[typing.Any]
        """
        ...

    def preview_ensure(self) -> "ImagePreview":
        """Ensure that this ID has preview data (if ID type supports it)

        :rtype: 'ImagePreview'
        :return: The existing or created preview
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IDOverrideLibrary(bpy_struct):
    """Struct gathering all data needed by overridden linked IDs"""

    hierarchy_root: "ID"
    """ Library override ID used as root of the override hierarchy this ID is a member of

    :type: 'ID'
    """

    is_in_hierarchy: bool
    """ Whether this library override is defined as part of a library hierarchy, or as a single, isolated and autonomous override

    :type: bool
    """

    is_system_override: bool
    """ Whether this library override exists only for the override hierarchy, or if it is actually editable by the user

    :type: bool
    """

    properties: "IDOverrideLibraryProperties"
    """ List of overridden properties

    :type: 'IDOverrideLibraryProperties'
    """

    reference: "ID"
    """ Linked ID used as reference by this override

    :type: 'ID'
    """

    def operations_update(self):
        """Update the library override operations based on the differences between this override ID and its reference"""
        ...

    def reset(
        self,
        do_hierarchy: typing.Optional[typing.Union[bool, typing.Any]] = True,
        set_system_override: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ):
        """Reset this override to match again its linked reference ID

        :param do_hierarchy: Also reset all the dependencies of this override to match their reference linked IDs
        :type do_hierarchy: typing.Optional[typing.Union[bool, typing.Any]]
        :param set_system_override: Reset all user-editable overrides as (non-editable) system overrides
        :type set_system_override: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def destroy(
        self, do_hierarchy: typing.Optional[typing.Union[bool, typing.Any]] = True
    ):
        """Delete this override ID and remap its usages to its linked reference ID instead

        :param do_hierarchy: Also delete all the dependencies of this override and remap their usages to their reference linked IDs
        :type do_hierarchy: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def resync(
        self,
        scene: "Scene",
        view_layer: typing.Optional["ViewLayer"] = None,
        residual_storage: typing.Optional["Collection"] = None,
        do_hierarchy_enforce: typing.Optional[typing.Union[bool, typing.Any]] = False,
        do_whole_hierarchy: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> bool:
        """Resync the data-block and its sub-hierarchy, or the whole hierarchy if requested

        :param scene: The scene to operate in (for contextual things like keeping active object active, ensuring all overridden objects remain instantiated, etc.)
        :type scene: 'Scene'
        :param view_layer: The view layer to operate in (same usage as the scene data, in case it is not provided the scene's collection will be used instead)
        :type view_layer: typing.Optional['ViewLayer']
        :param residual_storage: Collection where to store objects that are instantiated in any other collection anymore (garbage collection, will be created if needed and none is provided)
        :type residual_storage: typing.Optional['Collection']
        :param do_hierarchy_enforce: Enforce restoring the dependency hierarchy between data-blocks to match the one from the reference linked hierarchy (WARNING: if some ID pointers have been purposedly overridden, these will be reset to their default value)
        :type do_hierarchy_enforce: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_whole_hierarchy: Resync the whole hierarchy this data-block belongs to, not only its own sub-hierarchy
        :type do_whole_hierarchy: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: bool
        :return: Success, Whether the resync process was successful or not
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IDOverrideLibraryProperty(bpy_struct):
    """Description of an overridden property"""

    operations: "IDOverrideLibraryPropertyOperations"
    """ List of overriding operations for a property

    :type: 'IDOverrideLibraryPropertyOperations'
    """

    rna_path: typing.Union[str, typing.Any]
    """ RNA path leading to that property, from owning ID

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IDOverrideLibraryPropertyOperation(bpy_struct):
    """Description of an override operation over an overridden property"""

    flag: typing.Any
    """ Status flags

    :type: typing.Any
    """

    operation: typing.Union[int, str]
    """ What override operation is performed

    :type: typing.Union[int, str]
    """

    subitem_local_id: "ID"
    """ Collection of IDs only, used to disambiguate between potential IDs with same name from different libraries

    :type: 'ID'
    """

    subitem_local_index: int
    """ Used to handle changes into collection

    :type: int
    """

    subitem_local_name: typing.Union[str, typing.Any]
    """ Used to handle changes into collection

    :type: typing.Union[str, typing.Any]
    """

    subitem_reference_id: "ID"
    """ Collection of IDs only, used to disambiguate between potential IDs with same name from different libraries

    :type: 'ID'
    """

    subitem_reference_index: int
    """ Used to handle changes into collection

    :type: int
    """

    subitem_reference_name: typing.Union[str, typing.Any]
    """ Used to handle changes into collection

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IDPropertyWrapPtr(bpy_struct):
    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IKParam(bpy_struct):
    """Base type for IK solver parameters"""

    ik_solver: typing.Union[int, str]
    """ IK solver for which these parameters are defined

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ImageFormatSettings(bpy_struct):
    """Settings for image formats"""

    cineon_black: int
    """ Log conversion reference blackpoint

    :type: int
    """

    cineon_gamma: float
    """ Log conversion gamma

    :type: float
    """

    cineon_white: int
    """ Log conversion reference whitepoint

    :type: int
    """

    color_depth: typing.Union[int, str]
    """ Bit depth per channel

    :type: typing.Union[int, str]
    """

    color_management: typing.Union[int, str]
    """ Which color management settings to use for file saving

    :type: typing.Union[int, str]
    """

    color_mode: typing.Union[int, str]
    """ Choose BW for saving grayscale images, RGB for saving red, green and blue channels, and RGBA for saving red, green, blue and alpha channels

    :type: typing.Union[int, str]
    """

    compression: int
    """ Amount of time to determine best compression: 0 = no compression with fast file output, 100 = maximum lossless compression with slow file output

    :type: int
    """

    display_settings: "ColorManagedDisplaySettings"
    """ Settings of device saved image would be displayed on

    :type: 'ColorManagedDisplaySettings'
    """

    exr_codec: typing.Union[int, str]
    """ Codec settings for OpenEXR

    :type: typing.Union[int, str]
    """

    file_format: typing.Union[int, str]
    """ File format to save the rendered images as

    :type: typing.Union[int, str]
    """

    has_linear_colorspace: typing.Union[bool, typing.Any]
    """ File format expects linear color space

    :type: typing.Union[bool, typing.Any]
    """

    jpeg2k_codec: typing.Union[int, str]
    """ Codec settings for JPEG 2000

    :type: typing.Union[int, str]
    """

    linear_colorspace_settings: "ColorManagedInputColorspaceSettings"
    """ Output color space settings

    :type: 'ColorManagedInputColorspaceSettings'
    """

    quality: int
    """ Quality for image formats that support lossy compression

    :type: int
    """

    stereo_3d_format: "Stereo3dFormat"
    """ Settings for stereo 3D

    :type: 'Stereo3dFormat'
    """

    tiff_codec: typing.Union[int, str]
    """ Compression mode for TIFF

    :type: typing.Union[int, str]
    """

    use_cineon_log: bool
    """ Convert to logarithmic color space

    :type: bool
    """

    use_jpeg2k_cinema_48: bool
    """ Use OpenJPEG Cinema Preset (48fps)

    :type: bool
    """

    use_jpeg2k_cinema_preset: bool
    """ Use OpenJPEG Cinema Preset

    :type: bool
    """

    use_jpeg2k_ycc: bool
    """ Save luminance-chrominance-chrominance channels instead of RGB colors

    :type: bool
    """

    use_preview: bool
    """ When rendering animations, save JPG preview images in same directory

    :type: bool
    """

    view_settings: "ColorManagedViewSettings"
    """ Color management settings applied on image before saving

    :type: 'ColorManagedViewSettings'
    """

    views_format: typing.Union[int, str]
    """ Format of multiview media

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ImagePackedFile(bpy_struct):
    filepath: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    packed_file: "PackedFile"
    """ 

    :type: 'PackedFile'
    """

    tile_number: int
    """ 

    :type: int
    """

    view: int
    """ 

    :type: int
    """

    def save(self):
        """Save the packed file to its filepath"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ImagePreview(bpy_struct):
    """Preview image and icon"""

    icon_id: int
    """ Unique integer identifying this preview as an icon (zero means invalid)

    :type: int
    """

    icon_pixels: int
    """ Icon pixels, as bytes (always 32-bit RGBA)

    :type: int
    """

    icon_pixels_float: float
    """ Icon pixels components, as floats (RGBA concatenated values)

    :type: float
    """

    icon_size: bpy_prop_array[int]
    """ Width and height in pixels

    :type: bpy_prop_array[int]
    """

    image_pixels: int
    """ Image pixels, as bytes (always 32-bit RGBA)

    :type: int
    """

    image_pixels_float: float
    """ Image pixels components, as floats (RGBA concatenated values)

    :type: float
    """

    image_size: bpy_prop_array[int]
    """ Width and height in pixels

    :type: bpy_prop_array[int]
    """

    is_icon_custom: bool
    """ True if this preview icon has been modified by py script, and is no more auto-generated by Blender

    :type: bool
    """

    is_image_custom: bool
    """ True if this preview image has been modified by py script, and is no more auto-generated by Blender

    :type: bool
    """

    def reload(self):
        """Reload the preview from its source path"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ImageUser(bpy_struct):
    """Parameters defining how an Image data-block is used by another data-block"""

    frame_current: int
    """ Current frame number in image sequence or movie

    :type: int
    """

    frame_duration: int
    """ Number of images of a movie to use

    :type: int
    """

    frame_offset: int
    """ Offset the number of the frame to use in the animation

    :type: int
    """

    frame_start: int
    """ Global starting frame of the movie/sequence, assuming first picture has a #1

    :type: int
    """

    multilayer_layer: int
    """ Layer in multilayer image

    :type: int
    """

    multilayer_pass: int
    """ Pass in multilayer image

    :type: int
    """

    multilayer_view: int
    """ View in multilayer image

    :type: int
    """

    tile: int
    """ Tile in tiled image

    :type: int
    """

    use_auto_refresh: bool
    """ Always refresh image on frame changes

    :type: bool
    """

    use_cyclic: bool
    """ Cycle the images in the movie

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IndexSwitchItem(bpy_struct):
    identifier: int
    """ Consistent identifier used for the item

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Int2AttributeValue(bpy_struct):
    """2D value in geometry attribute"""

    value: bpy_prop_array[int]
    """ 2D vector

    :type: bpy_prop_array[int]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class IntAttributeValue(bpy_struct):
    """Integer value in geometry attribute"""

    value: int
    """ 

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyConfig(bpy_struct):
    """Input configuration, including keymaps"""

    is_user_defined: typing.Union[bool, typing.Any]
    """ Indicates that a keyconfig was defined by the user

    :type: typing.Union[bool, typing.Any]
    """

    keymaps: "KeyMaps"
    """ Key maps configured as part of this configuration

    :type: 'KeyMaps'
    """

    name: typing.Union[str, typing.Any]
    """ Name of the key configuration

    :type: typing.Union[str, typing.Any]
    """

    preferences: "KeyConfigPreferences"
    """ 

    :type: 'KeyConfigPreferences'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyConfigPreferences(bpy_struct):
    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyMap(bpy_struct):
    """Input configuration, including keymaps"""

    bl_owner_id: typing.Union[str, typing.Any]
    """ Internal owner

    :type: typing.Union[str, typing.Any]
    """

    is_modal: typing.Union[bool, typing.Any]
    """ Indicates that a keymap is used for translate modal events for an operator

    :type: typing.Union[bool, typing.Any]
    """

    is_user_modified: bool
    """ Keymap is defined by the user

    :type: bool
    """

    keymap_items: "KeyMapItems"
    """ Items in the keymap, linking an operator to an input event

    :type: 'KeyMapItems'
    """

    modal_event_values: bpy_prop_collection["EnumPropertyItem"]
    """ Give access to the possible event values of this modal keymap's items (#KeyMapItem.propvalue), for API introspection

    :type: bpy_prop_collection['EnumPropertyItem']
    """

    name: typing.Union[str, typing.Any]
    """ Name of the key map

    :type: typing.Union[str, typing.Any]
    """

    region_type: typing.Any
    """ Optional region type keymap is associated with

    :type: typing.Any
    """

    show_expanded_children: bool
    """ Children expanded in the user interface

    :type: bool
    """

    show_expanded_items: bool
    """ Expanded in the user interface

    :type: bool
    """

    space_type: typing.Any
    """ Optional space type keymap is associated with

    :type: typing.Any
    """

    def active(self) -> "KeyMap":
        """active

        :rtype: 'KeyMap'
        :return: Key Map, Active key map
        """
        ...

    def restore_to_default(self):
        """restore_to_default"""
        ...

    def restore_item_to_default(self, item: "KeyMapItem"):
        """restore_item_to_default

        :param item: Item
        :type item: 'KeyMapItem'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyMapItem(bpy_struct):
    """Item in a Key Map"""

    active: bool
    """ Activate or deactivate item

    :type: bool
    """

    alt: int
    """ Alt key pressed, -1 for any state

    :type: int
    """

    alt_ui: bool
    """ Alt key pressed

    :type: bool
    """

    any: bool
    """ Any modifier keys pressed

    :type: bool
    """

    ctrl: int
    """ Control key pressed, -1 for any state

    :type: int
    """

    ctrl_ui: bool
    """ Control key pressed

    :type: bool
    """

    direction: typing.Union[int, str]
    """ The direction (only applies to drag events)

    :type: typing.Union[int, str]
    """

    id: int
    """ ID of the item

    :type: int
    """

    idname: typing.Union[str, typing.Any]
    """ Identifier of operator to call on input event

    :type: typing.Union[str, typing.Any]
    """

    is_user_defined: typing.Union[bool, typing.Any]
    """ Is this keymap item user defined (doesn't just replace a builtin item)

    :type: typing.Union[bool, typing.Any]
    """

    is_user_modified: typing.Union[bool, typing.Any]
    """ Is this keymap item modified by the user

    :type: typing.Union[bool, typing.Any]
    """

    key_modifier: typing.Union[int, str]
    """ Regular key pressed as a modifier

    :type: typing.Union[int, str]
    """

    map_type: typing.Union[int, str]
    """ Type of event mapping

    :type: typing.Union[int, str]
    """

    name: typing.Union[str, typing.Any]
    """ Name of operator (translated) to call on input event

    :type: typing.Union[str, typing.Any]
    """

    oskey: int
    """ Operating system key pressed, -1 for any state

    :type: int
    """

    oskey_ui: bool
    """ Operating system key pressed

    :type: bool
    """

    properties: "OperatorProperties"
    """ Properties to set when the operator is called

    :type: 'OperatorProperties'
    """

    propvalue: typing.Union[int, str]
    """ The value this event translates to in a modal keymap

    :type: typing.Union[int, str]
    """

    repeat: bool
    """ Active on key-repeat events (when a key is held)

    :type: bool
    """

    shift: int
    """ Shift key pressed, -1 for any state

    :type: int
    """

    shift_ui: bool
    """ Shift key pressed

    :type: bool
    """

    show_expanded: bool
    """ Show key map event and property details in the user interface

    :type: bool
    """

    type: typing.Union[int, str]
    """ Type of event

    :type: typing.Union[int, str]
    """

    value: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    def compare(self, item: typing.Optional["KeyMapItem"]) -> bool:
        """compare

        :param item: Item
        :type item: typing.Optional['KeyMapItem']
        :rtype: bool
        :return: Comparison result
        """
        ...

    def to_string(
        self, compact: typing.Optional[typing.Union[bool, typing.Any]] = False
    ) -> typing.Union[str, typing.Any]:
        """to_string

        :param compact: Compact
        :type compact: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: typing.Union[str, typing.Any]
        :return: result
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Keyframe(bpy_struct):
    """Bézier curve point with two handles defining a Keyframe on an F-Curve"""

    amplitude: float
    """ Amount to boost elastic bounces for 'elastic' easing

    :type: float
    """

    back: float
    """ Amount of overshoot for 'back' easing

    :type: float
    """

    co: typing.Union["mathutils.Vector", typing.List[float], typing.Tuple[float, float]]
    """ Coordinates of the control point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    co_ui: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Coordinates of the control point. Note: Changing this value also updates the handles similar to using the graph editor transform operator

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    easing: typing.Union[int, str]
    """ Which ends of the segment between this and the next keyframe easing interpolation is applied to

    :type: typing.Union[int, str]
    """

    handle_left: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Coordinates of the left handle (before the control point)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    handle_left_type: typing.Union[int, str]
    """ Handle types

    :type: typing.Union[int, str]
    """

    handle_right: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Coordinates of the right handle (after the control point)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    handle_right_type: typing.Union[int, str]
    """ Handle types

    :type: typing.Union[int, str]
    """

    interpolation: typing.Union[int, str]
    """ Interpolation method to use for segment of the F-Curve from this Keyframe until the next Keyframe

    :type: typing.Union[int, str]
    """

    period: float
    """ Time between bounces for elastic easing

    :type: float
    """

    select_control_point: bool
    """ Control point selection status

    :type: bool
    """

    select_left_handle: bool
    """ Left handle selection status

    :type: bool
    """

    select_right_handle: bool
    """ Right handle selection status

    :type: bool
    """

    type: typing.Union[int, str]
    """ Type of keyframe (for visual purposes only)

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyingSet(bpy_struct):
    """Settings that should be keyframed together"""

    bl_description: typing.Union[str, typing.Any]
    """ A short description of the keying set

    :type: typing.Union[str, typing.Any]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the Keying Set gets a custom ID, otherwise it takes the name of the class used to define the Keying Set (for example, if the class name is "BUILTIN_KSI_location", and bl_idname is not set by the script, then bl_idname = "BUILTIN_KSI_location")

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    is_path_absolute: typing.Union[bool, typing.Any]
    """ Keying Set defines specific paths/settings to be keyframed (i.e. is not reliant on context info)

    :type: typing.Union[bool, typing.Any]
    """

    paths: "KeyingSetPaths"
    """ Keying Set Paths to define settings that get keyframed together

    :type: 'KeyingSetPaths'
    """

    type_info: "KeyingSetInfo"
    """ Callback function defines for built-in Keying Sets

    :type: 'KeyingSetInfo'
    """

    use_insertkey_needed: bool
    """ Only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    """

    use_insertkey_override_needed: bool
    """ Override default setting to only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    """

    use_insertkey_override_visual: bool
    """ Override default setting to insert keyframes based on 'visual transforms'

    :type: bool
    """

    use_insertkey_visual: bool
    """ Insert keyframes based on 'visual transforms'

    :type: bool
    """

    def refresh(self):
        """Refresh Keying Set to ensure that it is valid for the current context (call before each use of one)"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyingSetInfo(bpy_struct):
    """Callback function defines for builtin Keying Sets"""

    bl_description: typing.Union[str, typing.Any]
    """ A short description of the keying set

    :type: typing.Union[str, typing.Any]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the Keying Set gets a custom ID, otherwise it takes the name of the class used to define the Keying Set (for example, if the class name is "BUILTIN_KSI_location", and bl_idname is not set by the script, then bl_idname = "BUILTIN_KSI_location")

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Keying Set options to use when inserting keyframes

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    def poll(self, context: typing.Optional["Context"]) -> bool:
        """Test if Keying Set can be used or not

        :param context:
        :type context: typing.Optional['Context']
        :rtype: bool
        """
        ...

    def iterator(
        self, context: typing.Optional["Context"], ks: typing.Optional["KeyingSet"]
    ):
        """Call generate() on the structs which have properties to be keyframed

        :param context:
        :type context: typing.Optional['Context']
        :param ks:
        :type ks: typing.Optional['KeyingSet']
        """
        ...

    def generate(
        self,
        context: typing.Optional["Context"],
        ks: typing.Optional["KeyingSet"],
        data: typing.Any,
    ):
        """Add Paths to the Keying Set to keyframe the properties of the given data

        :param context:
        :type context: typing.Optional['Context']
        :param ks:
        :type ks: typing.Optional['KeyingSet']
        :param data:
        :type data: typing.Any
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class KeyingSetPath(bpy_struct):
    """Path to a setting for use in a Keying Set"""

    array_index: int
    """ Index to the specific setting if applicable

    :type: int
    """

    data_path: typing.Union[str, typing.Any]
    """ Path to property setting

    :type: typing.Union[str, typing.Any]
    """

    group: typing.Union[str, typing.Any]
    """ Name of Action Group to assign setting(s) for this path to

    :type: typing.Union[str, typing.Any]
    """

    group_method: typing.Union[int, str]
    """ Method used to define which Group-name to use

    :type: typing.Union[int, str]
    """

    id: "ID"
    """ ID-Block that keyframes for Keying Set should be added to (for Absolute Keying Sets only)

    :type: 'ID'
    """

    id_type: typing.Union[int, str]
    """ Type of ID-block that can be used

    :type: typing.Union[int, str]
    """

    use_entire_array: bool
    """ When an 'array/vector' type is chosen (Location, Rotation, Color, etc.), entire array is to be used

    :type: bool
    """

    use_insertkey_needed: bool
    """ Only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    """

    use_insertkey_override_needed: bool
    """ Override default setting to only insert keyframes where they're needed in the relevant F-Curves

    :type: bool
    """

    use_insertkey_override_visual: bool
    """ Override default setting to insert keyframes based on 'visual transforms'

    :type: bool
    """

    use_insertkey_visual: bool
    """ Insert keyframes based on 'visual transforms'

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LatticePoint(bpy_struct):
    """Point in the lattice grid"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Original undeformed location used to calculate the strength of the deform effect (edit/animate the Deformed Location instead)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    co_deform: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    groups: bpy_prop_collection["VertexGroupElement"]
    """ Weights for the vertex groups this point is member of

    :type: bpy_prop_collection['VertexGroupElement']
    """

    select: bool
    """ Selection status

    :type: bool
    """

    weight_softbody: float
    """ Softbody goal weight

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LayerCollection(bpy_struct):
    """Layer collection"""

    children: bpy_prop_collection["LayerCollection"]
    """ Layer collection children

    :type: bpy_prop_collection['LayerCollection']
    """

    collection: "Collection"
    """ Collection this layer collection is wrapping

    :type: 'Collection'
    """

    exclude: bool
    """ Exclude from view layer

    :type: bool
    """

    hide_viewport: bool
    """ Temporarily hide in viewport

    :type: bool
    """

    holdout: bool
    """ Mask out objects in collection from view layer

    :type: bool
    """

    indirect_only: bool
    """ Objects in collection only contribute indirectly (through shadows and reflections) in the view layer

    :type: bool
    """

    is_visible: typing.Union[bool, typing.Any]
    """ Whether this collection is visible for the view layer, take into account the collection parent

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Name of this layer collection (same as its collection one)

    :type: typing.Union[str, typing.Any]
    """

    def visible_get(self) -> bool:
        """Whether this collection is visible, take into account the collection parent and the viewport

        :rtype: bool
        """
        ...

    def has_objects(self) -> bool:
        """

        :rtype: bool
        """
        ...

    def has_selected_objects(self, view_layer: typing.Optional["ViewLayer"]) -> bool:
        """

        :param view_layer: View layer the layer collection belongs to
        :type view_layer: typing.Optional['ViewLayer']
        :rtype: bool
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LayoutPanelState(bpy_struct):
    is_open: bool
    """ 

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LibraryWeakReference(bpy_struct):
    """Read-only external reference to a linked data-block and its library file"""

    filepath: typing.Union[str, typing.Any]
    """ Path to the library .blend file

    :type: typing.Union[str, typing.Any]
    """

    id_name: typing.Union[str, typing.Any]
    """ Full ID name in the library .blend file (including the two leading 'id type' chars)

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Lightgroup(bpy_struct):
    name: typing.Union[str, typing.Any]
    """ Name of the Lightgroup

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class LineStyleModifier(bpy_struct):
    """Base type to define modifiers"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Macro(bpy_struct):
    """Storage of a macro operator being executed, or registered after execution"""

    bl_cursor_pending: typing.Union[int, str]
    """ Cursor to use when waiting for the user to select a location to activate the operator (when bl_options has DEPENDS_ON_CURSOR set)

    :type: typing.Union[int, str]
    """

    bl_description: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Options for this operator type

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    bl_translation_context: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_undo_group: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    has_reports: typing.Union[bool, typing.Any]
    """ Operator has a set of reports (warnings and errors) from last execution

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    properties: "OperatorProperties"
    """ 

    :type: 'OperatorProperties'
    """

    def report(
        self,
        type: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]],
        message: typing.Union[str, typing.Any],
    ):
        """report

        :param type: Type
        :type type: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]]
        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        """
        ...

    def poll(self, context: "Context") -> bool:
        """Test if the operator can be called or not

        :param context:
        :type context: 'Context'
        :rtype: bool
        """
        ...

    def draw(self, context: "Context"):
        """Draw function for the operator

        :param context:
        :type context: 'Context'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaskLayer(bpy_struct):
    """Single layer used for masking pixels"""

    alpha: float
    """ Render Opacity

    :type: float
    """

    blend: typing.Union[int, str]
    """ Method of blending mask layers

    :type: typing.Union[int, str]
    """

    falloff: typing.Union[int, str]
    """ Falloff type the feather

    :type: typing.Union[int, str]
    """

    hide: bool
    """ Restrict visibility in the viewport

    :type: bool
    """

    hide_render: bool
    """ Restrict renderability

    :type: bool
    """

    hide_select: bool
    """ Restrict selection in the viewport

    :type: bool
    """

    invert: bool
    """ Invert the mask black/white

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Unique name of layer

    :type: typing.Union[str, typing.Any]
    """

    select: bool
    """ Layer is selected for editing in the Dope Sheet

    :type: bool
    """

    splines: "MaskSplines"
    """ Collection of splines which defines this layer

    :type: 'MaskSplines'
    """

    use_fill_holes: bool
    """ Calculate holes when filling overlapping curves

    :type: bool
    """

    use_fill_overlap: bool
    """ Calculate self intersections and overlap before filling

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaskParent(bpy_struct):
    """Parenting settings for masking element"""

    id: "ID"
    """ ID-block to which masking element would be parented to or to its property

    :type: 'ID'
    """

    id_type: typing.Union[int, str]
    """ Type of ID-block that can be used

    :type: typing.Union[int, str]
    """

    parent: typing.Union[str, typing.Any]
    """ Name of parent object in specified data-block to which parenting happens

    :type: typing.Union[str, typing.Any]
    """

    sub_parent: typing.Union[str, typing.Any]
    """ Name of parent sub-object in specified data-block to which parenting happens

    :type: typing.Union[str, typing.Any]
    """

    type: typing.Union[int, str]
    """ Parent Type

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaskSpline(bpy_struct):
    """Single spline used for defining mask shape"""

    offset_mode: typing.Union[int, str]
    """ The method used for calculating the feather offset

    :type: typing.Union[int, str]
    """

    points: "MaskSplinePoints"
    """ Collection of points

    :type: 'MaskSplinePoints'
    """

    use_cyclic: bool
    """ Make this spline a closed loop

    :type: bool
    """

    use_fill: bool
    """ Make this spline filled

    :type: bool
    """

    use_self_intersection_check: bool
    """ Prevent feather from self-intersections

    :type: bool
    """

    weight_interpolation: typing.Union[int, str]
    """ The type of weight interpolation for spline

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaskSplinePoint(bpy_struct):
    """Single point in spline used for defining mask"""

    co: typing.Union["mathutils.Vector", typing.List[float], typing.Tuple[float, float]]
    """ Coordinates of the control point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    feather_points: bpy_prop_collection["MaskSplinePointUW"]
    """ Points defining feather

    :type: bpy_prop_collection['MaskSplinePointUW']
    """

    handle_left: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Coordinates of the first handle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    handle_left_type: typing.Union[int, str]
    """ Handle type

    :type: typing.Union[int, str]
    """

    handle_right: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Coordinates of the second handle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    handle_right_type: typing.Union[int, str]
    """ Handle type

    :type: typing.Union[int, str]
    """

    handle_type: typing.Union[int, str]
    """ Handle type

    :type: typing.Union[int, str]
    """

    parent: "MaskParent"
    """ 

    :type: 'MaskParent'
    """

    select: bool
    """ Selection status

    :type: bool
    """

    weight: float
    """ Weight of the point

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaskSplinePointUW(bpy_struct):
    """Single point in spline segment defining feather"""

    select: bool
    """ Selection status

    :type: bool
    """

    u: float
    """ U coordinate of point along spline segment

    :type: float
    """

    weight: float
    """ Weight of feather point

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaterialGPencilStyle(bpy_struct):
    alignment_mode: typing.Union[int, str]
    """ Defines how align Dots and Boxes with drawing path and object rotation

    :type: typing.Union[int, str]
    """

    alignment_rotation: float
    """ Additional rotation applied to dots and square texture of strokes. Only applies in texture shading mode

    :type: float
    """

    color: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    fill_color: bpy_prop_array[float]
    """ Color for filling region bounded by each stroke

    :type: bpy_prop_array[float]
    """

    fill_image: "Image"
    """ 

    :type: 'Image'
    """

    fill_style: typing.Union[int, str]
    """ Select style used to fill strokes

    :type: typing.Union[int, str]
    """

    flip: bool
    """ Flip filling colors

    :type: bool
    """

    ghost: bool
    """ Display strokes using this color when showing onion skins

    :type: bool
    """

    gradient_type: typing.Union[int, str]
    """ Select type of gradient used to fill strokes

    :type: typing.Union[int, str]
    """

    hide: bool
    """ Set color Visibility

    :type: bool
    """

    is_fill_visible: typing.Union[bool, typing.Any]
    """ True when opacity of fill is set high enough to be visible

    :type: typing.Union[bool, typing.Any]
    """

    is_stroke_visible: typing.Union[bool, typing.Any]
    """ True when opacity of stroke is set high enough to be visible

    :type: typing.Union[bool, typing.Any]
    """

    lock: bool
    """ Protect color from further editing and/or frame changes

    :type: bool
    """

    mix_color: bpy_prop_array[float]
    """ Color for mixing with primary filling color

    :type: bpy_prop_array[float]
    """

    mix_factor: float
    """ Mix Factor

    :type: float
    """

    mix_stroke_factor: float
    """ Mix Stroke Factor

    :type: float
    """

    mode: typing.Union[int, str]
    """ Select line type for strokes

    :type: typing.Union[int, str]
    """

    pass_index: int
    """ Index number for the "Color Index" pass

    :type: int
    """

    pixel_size: float
    """ Texture Pixel Size factor along the stroke

    :type: float
    """

    show_fill: bool
    """ Show stroke fills of this material

    :type: bool
    """

    show_stroke: bool
    """ Show stroke lines of this material

    :type: bool
    """

    stroke_image: "Image"
    """ 

    :type: 'Image'
    """

    stroke_style: typing.Union[int, str]
    """ Select style used to draw strokes

    :type: typing.Union[int, str]
    """

    texture_angle: float
    """ Texture Orientation Angle

    :type: float
    """

    texture_clamp: bool
    """ Do not repeat texture and clamp to one instance only

    :type: bool
    """

    texture_offset: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Shift Texture in 2d Space

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    texture_scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Scale Factor for Texture

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    use_fill_holdout: bool
    """ Remove the color from underneath this stroke by using it as a mask

    :type: bool
    """

    use_overlap_strokes: bool
    """ Disable stencil and overlap self intersections with alpha materials

    :type: bool
    """

    use_stroke_holdout: bool
    """ Remove the color from underneath this stroke by using it as a mask

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaterialLineArt(bpy_struct):
    intersection_priority: int
    """ The intersection line will be included into the object with the higher intersection priority value

    :type: int
    """

    mat_occlusion: int
    """ Faces with this material will behave as if it has set number of layers in occlusion

    :type: int
    """

    use_intersection_priority_override: bool
    """ Override object and collection intersection priority value

    :type: bool
    """

    use_material_mask: bool
    """ Use material masks to filter out occluded strokes

    :type: bool
    """

    use_material_mask_bits: typing.List[bool]
    """ 

    :type: typing.List[bool]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MaterialSlot(bpy_struct):
    """Material slot in an object"""

    link: typing.Union[int, str]
    """ Link material to object or the object's data

    :type: typing.Union[int, str]
    """

    material: "Material"
    """ Material data-block used by this material slot

    :type: 'Material'
    """

    name: typing.Union[str, typing.Any]
    """ Material slot name

    :type: typing.Union[str, typing.Any]
    """

    slot_index: int
    """ 

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Menu(bpy_struct):
    """Editor menu containing buttons"""

    bl_description: str
    """ 

    :type: str
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the menu gets a custom ID, otherwise it takes the name of the class used to define the menu (for example, if the class name is "OBJECT_MT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_MT_hello")

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ The menu label

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Options for this menu type

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    bl_owner_id: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_translation_context: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    layout: "UILayout"
    """ Defines the structure of the menu in the UI

    :type: 'UILayout'
    """

    def poll(self, context: typing.Optional["Context"]) -> bool:
        """If this method returns a non-null output, then the menu can be drawn

        :param context:
        :type context: typing.Optional['Context']
        :rtype: bool
        """
        ...

    def draw(self, context: typing.Optional["Context"]):
        """Draw UI elements into the menu UI layout

        :param context:
        :type context: typing.Optional['Context']
        """
        ...

    def draw_preset(self, _context):
        """Define these on the subclass:
        - preset_operator (string)
        - preset_subdir (string)Optionally:
        - preset_add_operator (string)
        - preset_extensions (set of strings)
        - preset_operator_defaults (dict of keyword args)

                :param _context:
                :type _context:
        """
        ...

    def path_menu(
        self,
        searchpaths: typing.Optional[typing.List[str]],
        operator: typing.Optional[str],
        *,
        props_default: typing.Optional[typing.Dict] = None,
        prop_filepath: typing.Optional[str] = "filepath",
        filter_ext: typing.Optional[typing.Callable] = None,
        filter_path=None,
        display_name: typing.Optional[typing.Callable] = None,
        add_operator=None,
    ):
        """Populate a menu from a list of paths.

                :param searchpaths: Paths to scan.
                :type searchpaths: typing.Optional[typing.List[str]]
                :param operator: The operator id to use with each file.
                :type operator: typing.Optional[str]
                :param *:
                :type *:
                :param props_default: Properties to assign to each operator.
                :type props_default: typing.Optional[typing.Dict]
                :param prop_filepath: Optional operator filepath property (defaults to "filepath").
                :type prop_filepath: typing.Optional[str]
                :param filter_ext: Optional callback that takes the file extensions.

        Returning false excludes the file from the list.
                :type filter_ext: typing.Optional[typing.Callable]
                :param filter_path:
                :type filter_path:
                :param display_name: Optional callback that takes the full path, returns the name to display.
                :type display_name: typing.Optional[typing.Callable]
                :param add_operator:
                :type add_operator:
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

    @classmethod
    def append(cls, draw_func): ...
    @classmethod
    def prepend(cls, draw_func): ...
    @classmethod
    def remove(cls, draw_func): ...

class MeshEdge(bpy_struct):
    """Edge in a Mesh data-block"""

    hide: bool
    """ 

    :type: bool
    """

    index: int
    """ Index of this edge

    :type: int
    """

    is_loose: typing.Union[bool, typing.Any]
    """ Edge is not connected to any faces

    :type: typing.Union[bool, typing.Any]
    """

    select: bool
    """ 

    :type: bool
    """

    use_edge_sharp: bool
    """ Sharp edge for shading

    :type: bool
    """

    use_freestyle_mark: bool
    """ Edge mark for Freestyle line rendering

    :type: bool
    """

    use_seam: bool
    """ Seam edge for UV unwrapping

    :type: bool
    """

    vertices: bpy_prop_array[int]
    """ Vertex indices

    :type: bpy_prop_array[int]
    """

    key: typing.Any
    """ (readonly)"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshLoop(bpy_struct):
    """Loop in a Mesh data-block"""

    bitangent: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Bitangent vector of this vertex for this face (must be computed beforehand using calc_tangents, use it only if really needed, slower access than bitangent_sign)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bitangent_sign: float
    """ Sign of the bitangent vector of this vertex for this face (must be computed beforehand using calc_tangents, bitangent = bitangent_sign * cross(normal, tangent))

    :type: float
    """

    edge_index: int
    """ Edge index

    :type: int
    """

    index: int
    """ Index of this loop

    :type: int
    """

    normal: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ The normal direction of the face corner, taking into account sharp faces, sharp edges, and custom normal data

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    tangent: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Local space unit length tangent vector of this vertex for this face (must be computed beforehand using calc_tangents)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_index: int
    """ Vertex index

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshLoopColor(bpy_struct):
    """Vertex loop colors in a Mesh"""

    color: bpy_prop_array[float]
    """ Color in sRGB color space

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshLoopColorLayer(bpy_struct):
    """Layer of vertex colors in a Mesh data-block"""

    active: bool
    """ Sets the layer as active for display and editing

    :type: bool
    """

    active_render: bool
    """ Sets the layer as active for rendering

    :type: bool
    """

    data: bpy_prop_collection["MeshLoopColor"]
    """ 

    :type: bpy_prop_collection['MeshLoopColor']
    """

    name: typing.Union[str, typing.Any]
    """ Name of Vertex color layer

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshLoopTriangle(bpy_struct):
    """Tessellated triangle in a Mesh data-block"""

    area: float
    """ Area of this triangle

    :type: float
    """

    index: int
    """ Index of this loop triangle

    :type: int
    """

    loops: bpy_prop_array[int]
    """ Indices of mesh loops that make up the triangle

    :type: bpy_prop_array[int]
    """

    material_index: int
    """ Material slot index of this triangle

    :type: int
    """

    normal: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Local space unit length normal vector for this triangle

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    polygon_index: int
    """ Index of mesh face that the triangle is a part of

    :type: int
    """

    split_normals: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
        ],
    ]
    """ Local space unit length split normal vectors of the face corners of this triangle

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]]]
    """

    use_smooth: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    vertices: bpy_prop_array[int]
    """ Indices of triangle vertices

    :type: bpy_prop_array[int]
    """

    center: typing.Any
    """ The midpoint of the face.(readonly)"""

    edge_keys: typing.Any
    """ (readonly)"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshNormalValue(bpy_struct):
    """Vector in a mesh normal array"""

    vector: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 3D vector

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshPolygon(bpy_struct):
    """Polygon in a Mesh data-block"""

    area: float
    """ Read only area of this face

    :type: float
    """

    center: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Center of this face

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    hide: bool
    """ 

    :type: bool
    """

    index: int
    """ Index of this face

    :type: int
    """

    loop_start: int
    """ Index of the first loop of this face

    :type: int
    """

    loop_total: int
    """ Number of loops used by this face

    :type: int
    """

    material_index: int
    """ Material slot index of this face

    :type: int
    """

    normal: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Local space unit length normal vector for this face

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    select: bool
    """ 

    :type: bool
    """

    use_freestyle_mark: bool
    """ Face mark for Freestyle line rendering

    :type: bool
    """

    use_smooth: bool
    """ 

    :type: bool
    """

    vertices: bpy_prop_array[int]
    """ Vertex indices

    :type: bpy_prop_array[int]
    """

    edge_keys: typing.Any
    """ (readonly)"""

    loop_indices: typing.Any
    """ (readonly)"""

    def flip(self):
        """Invert winding of this face (flip its normal)"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshSkinVertex(bpy_struct):
    """Per-vertex skin data for use with the Skin modifier"""

    radius: bpy_prop_array[float]
    """ Radius of the skin

    :type: bpy_prop_array[float]
    """

    use_loose: bool
    """ If vertex has multiple adjacent edges, it is hulled to them directly

    :type: bool
    """

    use_root: bool
    """ Vertex is a root for rotation calculations and armature generation, setting this flag does not clear other roots in the same mesh island

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshSkinVertexLayer(bpy_struct):
    """Per-vertex skin data for use with the Skin modifier"""

    data: bpy_prop_collection["MeshSkinVertex"]
    """ 

    :type: bpy_prop_collection['MeshSkinVertex']
    """

    name: typing.Union[str, typing.Any]
    """ Name of skin layer

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshStatVis(bpy_struct):
    distort_max: float
    """ Maximum angle to display

    :type: float
    """

    distort_min: float
    """ Minimum angle to display

    :type: float
    """

    overhang_axis: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    overhang_max: float
    """ Maximum angle to display

    :type: float
    """

    overhang_min: float
    """ Minimum angle to display

    :type: float
    """

    sharp_max: float
    """ Maximum angle to display

    :type: float
    """

    sharp_min: float
    """ Minimum angle to display

    :type: float
    """

    thickness_max: float
    """ Maximum for measuring thickness

    :type: float
    """

    thickness_min: float
    """ Minimum for measuring thickness

    :type: float
    """

    thickness_samples: int
    """ Number of samples to test per face

    :type: int
    """

    type: typing.Union[int, str]
    """ Type of data to visualize/check

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshUVLoop(bpy_struct):
    """(Deprecated) Layer of UV coordinates in a Mesh data-block"""

    pin_uv: bool
    """ 

    :type: bool
    """

    select: bool
    """ 

    :type: bool
    """

    select_edge: bool
    """ 

    :type: bool
    """

    uv: typing.Union["mathutils.Vector", typing.List[float], typing.Tuple[float, float]]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshUVLoopLayer(bpy_struct):
    active: bool
    """ Set the map as active for display and editing

    :type: bool
    """

    active_clone: bool
    """ Set the map as active for cloning

    :type: bool
    """

    active_render: bool
    """ Set the UV map as active for rendering

    :type: bool
    """

    data: bpy_prop_collection["MeshUVLoop"]
    """ Deprecated, use 'uv', 'vertex_select', 'edge_select' or 'pin' properties instead

    :type: bpy_prop_collection['MeshUVLoop']
    """

    edge_selection: bpy_prop_collection["BoolAttributeValue"]
    """ Selection state of the edge in the UV editor

    :type: bpy_prop_collection['BoolAttributeValue']
    """

    name: typing.Union[str, typing.Any]
    """ Name of UV map

    :type: typing.Union[str, typing.Any]
    """

    pin: bpy_prop_collection["BoolAttributeValue"]
    """ UV pinned state in the UV editor

    :type: bpy_prop_collection['BoolAttributeValue']
    """

    uv: bpy_prop_collection["Float2AttributeValue"]
    """ UV coordinates on face corners

    :type: bpy_prop_collection['Float2AttributeValue']
    """

    vertex_selection: bpy_prop_collection["BoolAttributeValue"]
    """ Selection state of the face corner the UV editor

    :type: bpy_prop_collection['BoolAttributeValue']
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MeshVertex(bpy_struct):
    """Vertex in a Mesh data-block"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    groups: bpy_prop_collection["VertexGroupElement"]
    """ Weights for the vertex groups this vertex is member of

    :type: bpy_prop_collection['VertexGroupElement']
    """

    hide: bool
    """ 

    :type: bool
    """

    index: int
    """ Index of this vertex

    :type: int
    """

    normal: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Vertex Normal

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    select: bool
    """ 

    :type: bool
    """

    undeformed_co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ For meshes with modifiers applied, the coordinate of the vertex with no deforming modifiers applied, as used for generated texture coordinates

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MetaElement(bpy_struct):
    """Blobby element in a metaball data-block"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    hide: bool
    """ Hide element

    :type: bool
    """

    radius: float
    """ 

    :type: float
    """

    rotation: typing.Union[
        "mathutils.Quaternion",
        typing.List[float],
        typing.Tuple[float, float, float, float],
    ]
    """ Normalized quaternion rotation

    :type: typing.Union['mathutils.Quaternion', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    select: bool
    """ Select element

    :type: bool
    """

    size_x: float
    """ Size of element, use of components depends on element type

    :type: float
    """

    size_y: float
    """ Size of element, use of components depends on element type

    :type: float
    """

    size_z: float
    """ Size of element, use of components depends on element type

    :type: float
    """

    stiffness: float
    """ Stiffness defines how much of the element to fill

    :type: float
    """

    type: typing.Union[int, str]
    """ Metaball type

    :type: typing.Union[int, str]
    """

    use_negative: bool
    """ Set metaball as negative one

    :type: bool
    """

    use_scale_stiffness: bool
    """ Scale stiffness instead of radius

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Modifier(bpy_struct):
    """Modifier affecting the geometry data of an object"""

    execution_time: float
    """ Time in seconds that the modifier took to evaluate. This is only set on evaluated objects. If multiple modifiers run in parallel, execution time is not a reliable metric

    :type: float
    """

    is_active: bool
    """ The active modifier in the list

    :type: bool
    """

    is_override_data: typing.Union[bool, typing.Any]
    """ In a local override object, whether this modifier comes from the linked reference object, or is local to the override

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Modifier name

    :type: typing.Union[str, typing.Any]
    """

    persistent_uid: int
    """ Uniquely identifies the modifier within the modifier stack that it is part of

    :type: int
    """

    show_expanded: bool
    """ Set modifier expanded in the user interface

    :type: bool
    """

    show_in_editmode: bool
    """ Display modifier in Edit mode

    :type: bool
    """

    show_on_cage: bool
    """ Adjust edit cage to modifier result

    :type: bool
    """

    show_render: bool
    """ Use modifier during render

    :type: bool
    """

    show_viewport: bool
    """ Display modifier in viewport

    :type: bool
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    use_apply_on_spline: bool
    """ Apply this and all preceding deformation modifiers on splines' points rather than on filled curve/surface

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MotionPath(bpy_struct):
    """Cache of the world-space positions of an element over a frame range"""

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Custom color for motion path

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    frame_end: int
    """ End frame of the stored range

    :type: int
    """

    frame_start: int
    """ Starting frame of the stored range

    :type: int
    """

    is_modified: bool
    """ Path is being edited

    :type: bool
    """

    length: int
    """ Number of frames cached

    :type: int
    """

    line_thickness: int
    """ Line thickness for motion path

    :type: int
    """

    lines: bool
    """ Use straight lines between keyframe points

    :type: bool
    """

    points: bpy_prop_collection["MotionPathVert"]
    """ Cached positions per frame

    :type: bpy_prop_collection['MotionPathVert']
    """

    use_bone_head: typing.Union[bool, typing.Any]
    """ For PoseBone paths, use the bone head location when calculating this path

    :type: typing.Union[bool, typing.Any]
    """

    use_custom_color: bool
    """ Use custom color for this motion path

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MotionPathVert(bpy_struct):
    """Cached location on path"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    select: bool
    """ Path point is selected for editing

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieClipProxy(bpy_struct):
    """Proxy parameters for a movie clip"""

    build_100: bool
    """ Build proxy resolution 100% of the original footage dimension

    :type: bool
    """

    build_25: bool
    """ Build proxy resolution 25% of the original footage dimension

    :type: bool
    """

    build_50: bool
    """ Build proxy resolution 50% of the original footage dimension

    :type: bool
    """

    build_75: bool
    """ Build proxy resolution 75% of the original footage dimension

    :type: bool
    """

    build_free_run: bool
    """ Build free run time code index

    :type: bool
    """

    build_free_run_rec_date: bool
    """ Build free run time code index using Record Date/Time

    :type: bool
    """

    build_record_run: bool
    """ Build record run time code index

    :type: bool
    """

    build_undistorted_100: bool
    """ Build proxy resolution 100% of the original undistorted footage dimension

    :type: bool
    """

    build_undistorted_25: bool
    """ Build proxy resolution 25% of the original undistorted footage dimension

    :type: bool
    """

    build_undistorted_50: bool
    """ Build proxy resolution 50% of the original undistorted footage dimension

    :type: bool
    """

    build_undistorted_75: bool
    """ Build proxy resolution 75% of the original undistorted footage dimension

    :type: bool
    """

    directory: typing.Union[str, typing.Any]
    """ Location to store the proxy files

    :type: typing.Union[str, typing.Any]
    """

    quality: int
    """ JPEG quality of proxy images

    :type: int
    """

    timecode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieClipScopes(bpy_struct):
    """Scopes for statistical view of a movie clip"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieClipUser(bpy_struct):
    """Parameters defining how a MovieClip data-block is used by another data-block"""

    frame_current: int
    """ Current frame number in movie or image sequence

    :type: int
    """

    proxy_render_size: typing.Union[int, str]
    """ Display preview using full resolution or different proxy resolutions

    :type: typing.Union[int, str]
    """

    use_render_undistorted: bool
    """ Render preview using undistorted proxy

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieReconstructedCamera(bpy_struct):
    """Match-moving reconstructed camera data from tracker"""

    average_error: float
    """ Average error of reconstruction

    :type: float
    """

    frame: int
    """ Frame number marker is keyframed on

    :type: int
    """

    matrix: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Worldspace transformation matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTracking(bpy_struct):
    """Match-moving data for tracking"""

    active_object_index: int
    """ Index of active object

    :type: int
    """

    camera: "MovieTrackingCamera"
    """ 

    :type: 'MovieTrackingCamera'
    """

    dopesheet: "MovieTrackingDopesheet"
    """ 

    :type: 'MovieTrackingDopesheet'
    """

    objects: "MovieTrackingObjects"
    """ Collection of objects in this tracking data object

    :type: 'MovieTrackingObjects'
    """

    plane_tracks: "MovieTrackingPlaneTracks"
    """ Collection of plane tracks in this tracking data object. Deprecated, use objects[name].plane_tracks

    :type: 'MovieTrackingPlaneTracks'
    """

    reconstruction: "MovieTrackingReconstruction"
    """ 

    :type: 'MovieTrackingReconstruction'
    """

    settings: "MovieTrackingSettings"
    """ 

    :type: 'MovieTrackingSettings'
    """

    stabilization: "MovieTrackingStabilization"
    """ 

    :type: 'MovieTrackingStabilization'
    """

    tracks: "MovieTrackingTracks"
    """ Collection of tracks in this tracking data object. Deprecated, use objects[name].tracks

    :type: 'MovieTrackingTracks'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingCamera(bpy_struct):
    """Match-moving camera data for tracking"""

    brown_k1: float
    """ First coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    """

    brown_k2: float
    """ Second coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    """

    brown_k3: float
    """ Third coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    """

    brown_k4: float
    """ Fourth coefficient of fourth order Brown-Conrady radial distortion

    :type: float
    """

    brown_p1: float
    """ First coefficient of second order Brown-Conrady tangential distortion

    :type: float
    """

    brown_p2: float
    """ Second coefficient of second order Brown-Conrady tangential distortion

    :type: float
    """

    distortion_model: typing.Union[int, str]
    """ Distortion model used for camera lenses

    :type: typing.Union[int, str]
    """

    division_k1: float
    """ First coefficient of second order division distortion

    :type: float
    """

    division_k2: float
    """ Second coefficient of second order division distortion

    :type: float
    """

    focal_length: float
    """ Camera's focal length

    :type: float
    """

    focal_length_pixels: float
    """ Camera's focal length

    :type: float
    """

    k1: float
    """ First coefficient of third order polynomial radial distortion

    :type: float
    """

    k2: float
    """ Second coefficient of third order polynomial radial distortion

    :type: float
    """

    k3: float
    """ Third coefficient of third order polynomial radial distortion

    :type: float
    """

    nuke_k1: float
    """ First coefficient of second order Nuke distortion

    :type: float
    """

    nuke_k2: float
    """ Second coefficient of second order Nuke distortion

    :type: float
    """

    pixel_aspect: float
    """ Pixel aspect ratio

    :type: float
    """

    principal_point: bpy_prop_array[float]
    """ Optical center of lens

    :type: bpy_prop_array[float]
    """

    principal_point_pixels: bpy_prop_array[float]
    """ Optical center of lens in pixels

    :type: bpy_prop_array[float]
    """

    sensor_width: float
    """ Width of CCD sensor in millimeters

    :type: float
    """

    units: typing.Union[int, str]
    """ Units used for camera focal length

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingDopesheet(bpy_struct):
    """Match-moving dopesheet data"""

    show_hidden: bool
    """ Include channels from objects/bone that are not visible

    :type: bool
    """

    show_only_selected: bool
    """ Only include channels relating to selected objects and data

    :type: bool
    """

    sort_method: typing.Union[int, str]
    """ Method to be used to sort channels in dopesheet view

    :type: typing.Union[int, str]
    """

    use_invert_sort: bool
    """ Invert sort order of dopesheet channels

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingMarker(bpy_struct):
    """Match-moving marker data for tracking"""

    co: typing.Union["mathutils.Vector", typing.List[float], typing.Tuple[float, float]]
    """ Marker position at frame in normalized coordinates

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    frame: int
    """ Frame number marker is keyframed on

    :type: int
    """

    is_keyed: bool
    """ Whether the position of the marker is keyframed or tracked

    :type: bool
    """

    mute: bool
    """ Is marker muted for current frame

    :type: bool
    """

    pattern_bound_box: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[typing.Tuple[float, float], typing.Tuple[float, float]],
    ]
    """ Pattern area bounding box in normalized coordinates

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float], typing.Tuple[float, float]]]
    """

    pattern_corners: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Array of coordinates which represents pattern's corners in normalized coordinates relative to marker position

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    search_max: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Right-bottom corner of search area in normalized coordinates relative to marker position

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    search_min: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Left-bottom corner of search area in normalized coordinates relative to marker position

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingObject(bpy_struct):
    """Match-moving object tracking and reconstruction data"""

    is_camera: typing.Union[bool, typing.Any]
    """ Object is used for camera tracking

    :type: typing.Union[bool, typing.Any]
    """

    keyframe_a: int
    """ First keyframe used for reconstruction initialization

    :type: int
    """

    keyframe_b: int
    """ Second keyframe used for reconstruction initialization

    :type: int
    """

    name: typing.Union[str, typing.Any]
    """ Unique name of object

    :type: typing.Union[str, typing.Any]
    """

    plane_tracks: "MovieTrackingObjectPlaneTracks"
    """ Collection of plane tracks in this tracking data object

    :type: 'MovieTrackingObjectPlaneTracks'
    """

    reconstruction: "MovieTrackingReconstruction"
    """ 

    :type: 'MovieTrackingReconstruction'
    """

    scale: float
    """ Scale of object solution in camera space

    :type: float
    """

    tracks: "MovieTrackingObjectTracks"
    """ Collection of tracks in this tracking data object

    :type: 'MovieTrackingObjectTracks'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingPlaneMarker(bpy_struct):
    """Match-moving plane marker data for tracking"""

    corners: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Array of coordinates which represents UI rectangle corners in frame normalized coordinates

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    frame: int
    """ Frame number marker is keyframed on

    :type: int
    """

    mute: bool
    """ Is marker muted for current frame

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingPlaneTrack(bpy_struct):
    """Match-moving plane track data for tracking"""

    image: "Image"
    """ Image displayed in the track during editing in clip editor

    :type: 'Image'
    """

    image_opacity: float
    """ Opacity of the image

    :type: float
    """

    markers: "MovieTrackingPlaneMarkers"
    """ Collection of markers in track

    :type: 'MovieTrackingPlaneMarkers'
    """

    name: typing.Union[str, typing.Any]
    """ Unique name of track

    :type: typing.Union[str, typing.Any]
    """

    select: bool
    """ Plane track is selected

    :type: bool
    """

    use_auto_keying: bool
    """ Automatic keyframe insertion when moving plane corners

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingReconstruction(bpy_struct):
    """Match-moving reconstruction data from tracker"""

    average_error: float
    """ Average error of reconstruction

    :type: float
    """

    cameras: "MovieTrackingReconstructedCameras"
    """ Collection of solved cameras

    :type: 'MovieTrackingReconstructedCameras'
    """

    is_valid: typing.Union[bool, typing.Any]
    """ Is tracking data contains valid reconstruction information

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingSettings(bpy_struct):
    """Match moving settings"""

    clean_action: typing.Union[int, str]
    """ Cleanup action to execute

    :type: typing.Union[int, str]
    """

    clean_error: float
    """ Effect on tracks which have a larger re-projection error

    :type: float
    """

    clean_frames: int
    """ Effect on tracks which are tracked less than the specified amount of frames

    :type: int
    """

    default_correlation_min: float
    """ Default minimum value of correlation between matched pattern and reference that is still treated as successful tracking

    :type: float
    """

    default_frames_limit: int
    """ Every tracking cycle, this number of frames are tracked

    :type: int
    """

    default_margin: int
    """ Default distance from image boundary at which marker stops tracking

    :type: int
    """

    default_motion_model: typing.Union[int, str]
    """ Default motion model to use for tracking

    :type: typing.Union[int, str]
    """

    default_pattern_match: typing.Union[int, str]
    """ Track pattern from given frame when tracking marker to next frame

    :type: typing.Union[int, str]
    """

    default_pattern_size: int
    """ Size of pattern area for newly created tracks

    :type: int
    """

    default_search_size: int
    """ Size of search area for newly created tracks

    :type: int
    """

    default_weight: float
    """ Influence of newly created track on a final solution

    :type: float
    """

    distance: float
    """ Distance between two bundles used for scene scaling

    :type: float
    """

    object_distance: float
    """ Distance between two bundles used for object scaling

    :type: float
    """

    refine_intrinsics_focal_length: bool
    """ Refine focal length during camera solving

    :type: bool
    """

    refine_intrinsics_principal_point: bool
    """ Refine principal point during camera solving

    :type: bool
    """

    refine_intrinsics_radial_distortion: bool
    """ Refine radial coefficients of distortion model during camera solving

    :type: bool
    """

    refine_intrinsics_tangential_distortion: bool
    """ Refine tangential coefficients of distortion model during camera solving

    :type: bool
    """

    speed: typing.Union[int, str]
    """ Limit speed of tracking to make visual feedback easier (this does not affect the tracking quality)

    :type: typing.Union[int, str]
    """

    use_default_blue_channel: bool
    """ Use blue channel from footage for tracking

    :type: bool
    """

    use_default_brute: bool
    """ Use a brute-force translation-only initialization when tracking

    :type: bool
    """

    use_default_green_channel: bool
    """ Use green channel from footage for tracking

    :type: bool
    """

    use_default_mask: bool
    """ Use a grease pencil data-block as a mask to use only specified areas of pattern when tracking

    :type: bool
    """

    use_default_normalization: bool
    """ Normalize light intensities while tracking (slower)

    :type: bool
    """

    use_default_red_channel: bool
    """ Use red channel from footage for tracking

    :type: bool
    """

    use_keyframe_selection: bool
    """ Automatically select keyframes when solving camera/object motion

    :type: bool
    """

    use_tripod_solver: bool
    """ Use special solver to track a stable camera position, such as a tripod

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingStabilization(bpy_struct):
    """2D stabilization based on tracking markers"""

    active_rotation_track_index: int
    """ Index of active track in rotation stabilization tracks list

    :type: int
    """

    active_track_index: int
    """ Index of active track in translation stabilization tracks list

    :type: int
    """

    anchor_frame: int
    """ Reference point to anchor stabilization (other frames will be adjusted relative to this frame's position)

    :type: int
    """

    filter_type: typing.Union[int, str]
    """ Interpolation to use for sub-pixel shifts and rotations due to stabilization

    :type: typing.Union[int, str]
    """

    influence_location: float
    """ Influence of stabilization algorithm on footage location

    :type: float
    """

    influence_rotation: float
    """ Influence of stabilization algorithm on footage rotation

    :type: float
    """

    influence_scale: float
    """ Influence of stabilization algorithm on footage scale

    :type: float
    """

    rotation_tracks: bpy_prop_collection["MovieTrackingTrack"]
    """ Collection of tracks used for 2D stabilization (translation)

    :type: bpy_prop_collection['MovieTrackingTrack']
    """

    scale_max: float
    """ Limit the amount of automatic scaling

    :type: float
    """

    show_tracks_expanded: bool
    """ Show UI list of tracks participating in stabilization

    :type: bool
    """

    target_position: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Known relative offset of original shot, will be subtracted (e.g. for panning shot, can be animated)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    target_rotation: float
    """ Rotation present on original shot, will be compensated (e.g. for deliberate tilting)

    :type: float
    """

    target_scale: float
    """ Explicitly scale resulting frame to compensate zoom of original shot

    :type: float
    """

    tracks: bpy_prop_collection["MovieTrackingTrack"]
    """ Collection of tracks used for 2D stabilization (translation)

    :type: bpy_prop_collection['MovieTrackingTrack']
    """

    use_2d_stabilization: bool
    """ Use 2D stabilization for footage

    :type: bool
    """

    use_autoscale: bool
    """ Automatically scale footage to cover unfilled areas when stabilizing

    :type: bool
    """

    use_stabilize_rotation: bool
    """ Stabilize detected rotation around center of frame

    :type: bool
    """

    use_stabilize_scale: bool
    """ Compensate any scale changes relative to center of rotation

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class MovieTrackingTrack(bpy_struct):
    """Match-moving track data for tracking"""

    average_error: float
    """ Average error of re-projection

    :type: float
    """

    bundle: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Position of bundle reconstructed from this track

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of the track in the Movie Clip Editor and the 3D viewport after a solve

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    correlation_min: float
    """ Minimal value of correlation between matched pattern and reference that is still treated as successful tracking

    :type: float
    """

    frames_limit: int
    """ Every tracking cycle, this number of frames are tracked

    :type: int
    """

    grease_pencil: "GreasePencil"
    """ Grease pencil data for this track

    :type: 'GreasePencil'
    """

    has_bundle: typing.Union[bool, typing.Any]
    """ True if track has a valid bundle

    :type: typing.Union[bool, typing.Any]
    """

    hide: bool
    """ Track is hidden

    :type: bool
    """

    lock: bool
    """ Track is locked and all changes to it are disabled

    :type: bool
    """

    margin: int
    """ Distance from image boundary at which marker stops tracking

    :type: int
    """

    markers: "MovieTrackingMarkers"
    """ Collection of markers in track

    :type: 'MovieTrackingMarkers'
    """

    motion_model: typing.Union[int, str]
    """ Default motion model to use for tracking

    :type: typing.Union[int, str]
    """

    name: typing.Union[str, typing.Any]
    """ Unique name of track

    :type: typing.Union[str, typing.Any]
    """

    offset: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Offset of track from the parenting point

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    pattern_match: typing.Union[int, str]
    """ Track pattern from given frame when tracking marker to next frame

    :type: typing.Union[int, str]
    """

    select: bool
    """ Track is selected

    :type: bool
    """

    select_anchor: bool
    """ Track's anchor point is selected

    :type: bool
    """

    select_pattern: bool
    """ Track's pattern area is selected

    :type: bool
    """

    select_search: bool
    """ Track's search area is selected

    :type: bool
    """

    use_alpha_preview: bool
    """ Apply track's mask on displaying preview

    :type: bool
    """

    use_blue_channel: bool
    """ Use blue channel from footage for tracking

    :type: bool
    """

    use_brute: bool
    """ Use a brute-force translation only pre-track before refinement

    :type: bool
    """

    use_custom_color: bool
    """ Use custom color instead of theme-defined

    :type: bool
    """

    use_grayscale_preview: bool
    """ Display what the tracking algorithm sees in the preview

    :type: bool
    """

    use_green_channel: bool
    """ Use green channel from footage for tracking

    :type: bool
    """

    use_mask: bool
    """ Use a grease pencil data-block as a mask to use only specified areas of pattern when tracking

    :type: bool
    """

    use_normalization: bool
    """ Normalize light intensities while tracking. Slower

    :type: bool
    """

    use_red_channel: bool
    """ Use red channel from footage for tracking

    :type: bool
    """

    weight: float
    """ Influence of this track on a final solution

    :type: float
    """

    weight_stab: float
    """ Influence of this track on 2D stabilization

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NlaStrip(bpy_struct):
    """A container referencing an existing Action"""

    action: "Action"
    """ Action referenced by this strip

    :type: 'Action'
    """

    action_frame_end: float
    """ Last frame from action to use

    :type: float
    """

    action_frame_start: float
    """ First frame from action to use

    :type: float
    """

    active: typing.Union[bool, typing.Any]
    """ NLA Strip is active

    :type: typing.Union[bool, typing.Any]
    """

    blend_in: float
    """ Number of frames at start of strip to fade in influence

    :type: float
    """

    blend_out: float
    """ 

    :type: float
    """

    blend_type: typing.Union[int, str]
    """ Method used for combining strip's result with accumulated result

    :type: typing.Union[int, str]
    """

    extrapolation: typing.Union[int, str]
    """ Action to take for gaps past the strip extents

    :type: typing.Union[int, str]
    """

    fcurves: "NlaStripFCurves"
    """ F-Curves for controlling the strip's influence and timing

    :type: 'NlaStripFCurves'
    """

    frame_end: float
    """ 

    :type: float
    """

    frame_end_raw: float
    """ Same as frame_end, except that any value can be set, including ones that create an invalid state

    :type: float
    """

    frame_end_ui: float
    """ End frame of the NLA strip. Note: changing this value also updates the value of the strip's repeats or its action's end frame. If only the end frame should be changed, see the "frame_end" property instead

    :type: float
    """

    frame_start: float
    """ 

    :type: float
    """

    frame_start_raw: float
    """ Same as frame_start, except that any value can be set, including ones that create an invalid state

    :type: float
    """

    frame_start_ui: float
    """ Start frame of the NLA strip. Note: changing this value also updates the value of the strip's end frame. If only the start frame should be changed, see the "frame_start" property instead

    :type: float
    """

    influence: float
    """ Amount the strip contributes to the current result

    :type: float
    """

    modifiers: bpy_prop_collection["FModifier"]
    """ Modifiers affecting all the F-Curves in the referenced Action

    :type: bpy_prop_collection['FModifier']
    """

    mute: bool
    """ Disable NLA Strip evaluation

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    repeat: float
    """ Number of times to repeat the action range

    :type: float
    """

    scale: float
    """ Scaling factor for action

    :type: float
    """

    select: bool
    """ NLA Strip is selected

    :type: bool
    """

    strip_time: float
    """ Frame of referenced Action to evaluate

    :type: float
    """

    strips: bpy_prop_collection["NlaStrip"]
    """ NLA Strips that this strip acts as a container for (if it is of type Meta)

    :type: bpy_prop_collection['NlaStrip']
    """

    type: typing.Union[int, str]
    """ Type of NLA Strip

    :type: typing.Union[int, str]
    """

    use_animated_influence: bool
    """ Influence setting is controlled by an F-Curve rather than automatically determined

    :type: bool
    """

    use_animated_time: bool
    """ Strip time is controlled by an F-Curve rather than automatically determined

    :type: bool
    """

    use_animated_time_cyclic: bool
    """ Cycle the animated time within the action start and end

    :type: bool
    """

    use_auto_blend: bool
    """ Number of frames for Blending In/Out is automatically determined from overlapping strips

    :type: bool
    """

    use_reverse: bool
    """ NLA Strip is played back in reverse order (only when timing is automatically determined)

    :type: bool
    """

    use_sync_length: bool
    """ Update range of frames referenced from action after tweaking strip and its keyframes

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NlaTrack(bpy_struct):
    """An animation layer containing Actions referenced as NLA strips"""

    active: typing.Union[bool, typing.Any]
    """ NLA Track is active

    :type: typing.Union[bool, typing.Any]
    """

    is_override_data: typing.Union[bool, typing.Any]
    """ In a local override data, whether this NLA track comes from the linked reference data, or is local to the override

    :type: typing.Union[bool, typing.Any]
    """

    is_solo: bool
    """ NLA Track is evaluated itself (i.e. active Action and all other NLA Tracks in the same AnimData block are disabled)

    :type: bool
    """

    lock: bool
    """ NLA Track is locked

    :type: bool
    """

    mute: bool
    """ Disable NLA Track evaluation

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    select: bool
    """ NLA Track is selected

    :type: bool
    """

    strips: "NlaStrips"
    """ NLA Strips on this NLA-track

    :type: 'NlaStrips'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Node(bpy_struct):
    """Node in a node tree"""

    bl_description: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_height_default: float
    """ 

    :type: float
    """

    bl_height_max: float
    """ 

    :type: float
    """

    bl_height_min: float
    """ 

    :type: float
    """

    bl_icon: typing.Union[int, str]
    """ The node icon

    :type: typing.Union[int, str]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ The node label

    :type: typing.Union[str, typing.Any]
    """

    bl_static_type: typing.Union[int, str]
    """ Node type (deprecated, use with care)

    :type: typing.Union[int, str]
    """

    bl_width_default: float
    """ 

    :type: float
    """

    bl_width_max: float
    """ 

    :type: float
    """

    bl_width_min: float
    """ 

    :type: float
    """

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Custom color of the node body

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    dimensions: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ Absolute bounding box dimensions of the node

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    height: float
    """ Height of the node

    :type: float
    """

    hide: bool
    """ 

    :type: bool
    """

    inputs: "NodeInputs"
    """ 

    :type: 'NodeInputs'
    """

    internal_links: bpy_prop_collection["NodeLink"]
    """ Internal input-to-output connections for muting

    :type: bpy_prop_collection['NodeLink']
    """

    label: typing.Union[str, typing.Any]
    """ Optional custom node label

    :type: typing.Union[str, typing.Any]
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
    """

    mute: bool
    """ 

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Unique node identifier

    :type: typing.Union[str, typing.Any]
    """

    outputs: "NodeOutputs"
    """ 

    :type: 'NodeOutputs'
    """

    parent: "Node"
    """ Parent this node is attached to

    :type: 'Node'
    """

    select: bool
    """ Node selection state

    :type: bool
    """

    show_options: bool
    """ 

    :type: bool
    """

    show_preview: bool
    """ 

    :type: bool
    """

    show_texture: bool
    """ Display node in viewport textured shading mode

    :type: bool
    """

    type: typing.Union[int, str]
    """ Node type (deprecated, use bl_static_type or bl_idname for the actual identifier string)

    :type: typing.Union[int, str]
    """

    use_custom_color: bool
    """ Use custom color for the node

    :type: bool
    """

    width: float
    """ Width of the node

    :type: float
    """

    def socket_value_update(self, context: "Context"):
        """Update after property changes

        :param context:
        :type context: 'Context'
        """
        ...

    def is_registered_node_type(self) -> bool:
        """True if a registered node type

        :rtype: bool
        :return: Result
        """
        ...

    def poll(self, node_tree: typing.Optional["NodeTree"]) -> bool:
        """If non-null output is returned, the node type can be added to the tree

        :param node_tree: Node Tree
        :type node_tree: typing.Optional['NodeTree']
        :rtype: bool
        """
        ...

    def poll_instance(self, node_tree: typing.Optional["NodeTree"]) -> bool:
        """If non-null output is returned, the node can be added to the tree

        :param node_tree: Node Tree
        :type node_tree: typing.Optional['NodeTree']
        :rtype: bool
        """
        ...

    def update(self):
        """Update on node graph topology changes (adding or removing nodes and links)"""
        ...

    def insert_link(self, link: "NodeLink"):
        """Handle creation of a link to or from the node

        :param link: Link, Node link that will be inserted
        :type link: 'NodeLink'
        """
        ...

    def init(self, context: "Context"):
        """Initialize a new instance of this node

        :param context:
        :type context: 'Context'
        """
        ...

    def copy(self, node: "Node"):
        """Initialize a new instance of this node from an existing node

        :param node: Node, Existing node to copy
        :type node: 'Node'
        """
        ...

    def free(self):
        """Clean up node on removal"""
        ...

    def draw_buttons(self, context: "Context", layout: "UILayout"):
        """Draw node buttons

        :param context:
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        """
        ...

    def draw_buttons_ext(self, context: "Context", layout: "UILayout"):
        """Draw node buttons in the sidebar

        :param context:
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        """
        ...

    def draw_label(self) -> typing.Union[str, typing.Any]:
        """Returns a dynamic label string

        :rtype: typing.Union[str, typing.Any]
        :return: Label
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeEnumDefinition(bpy_struct):
    """Definition of an enumeration for nodes"""

    active_index: int
    """ Index of the active item

    :type: int
    """

    active_item: "NodeEnumItem"
    """ Active item

    :type: 'NodeEnumItem'
    """

    enum_items: "NodeEnumDefinitionItems"
    """ 

    :type: 'NodeEnumDefinitionItems'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeEnumItem(bpy_struct):
    description: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeGeometryBakeItem(bpy_struct):
    attribute_domain: typing.Union[int, str]
    """ Attribute domain where the attribute is stored in the baked data

    :type: typing.Union[int, str]
    """

    color: bpy_prop_array[float]
    """ Color of the corresponding socket type in the node editor

    :type: bpy_prop_array[float]
    """

    is_attribute: bool
    """ Bake item is an attribute stored on a geometry

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    socket_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeInstanceHash(bpy_struct):
    """Hash table containing node instance data"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeInternalSocketTemplate(bpy_struct):
    """Type and default value of a node socket"""

    identifier: typing.Union[str, typing.Any]
    """ Identifier of the socket

    :type: typing.Union[str, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Name of the socket

    :type: typing.Union[str, typing.Any]
    """

    type: typing.Any
    """ Data type of the socket

    :type: typing.Any
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeLink(bpy_struct):
    """Link between nodes in a node tree"""

    from_node: "Node"
    """ 

    :type: 'Node'
    """

    from_socket: "NodeSocket"
    """ 

    :type: 'NodeSocket'
    """

    is_hidden: typing.Union[bool, typing.Any]
    """ Link is hidden due to invisible sockets

    :type: typing.Union[bool, typing.Any]
    """

    is_muted: bool
    """ Link is muted and can be ignored

    :type: bool
    """

    is_valid: bool
    """ Link is valid

    :type: bool
    """

    to_node: "Node"
    """ 

    :type: 'Node'
    """

    to_socket: "NodeSocket"
    """ 

    :type: 'NodeSocket'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeOutputFileSlotFile(bpy_struct):
    """Single layer file slot of the file output node"""

    format: "ImageFormatSettings"
    """ 

    :type: 'ImageFormatSettings'
    """

    path: typing.Union[str, typing.Any]
    """ Subpath used for this slot

    :type: typing.Union[str, typing.Any]
    """

    save_as_render: bool
    """ Apply render part of display transform when saving byte image

    :type: bool
    """

    use_node_format: bool
    """ 

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeOutputFileSlotLayer(bpy_struct):
    """Multilayer slot of the file output node"""

    name: typing.Union[str, typing.Any]
    """ OpenEXR layer name used for this slot

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeSocket(bpy_struct):
    """Input or output socket of a node"""

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ Label to display for the socket type in the UI

    :type: typing.Union[str, typing.Any]
    """

    bl_subtype_label: typing.Union[str, typing.Any]
    """ Label to display for the socket subtype in the UI

    :type: typing.Union[str, typing.Any]
    """

    description: typing.Union[str, typing.Any]
    """ Socket tooltip

    :type: typing.Union[str, typing.Any]
    """

    display_shape: typing.Union[int, str]
    """ Socket shape

    :type: typing.Union[int, str]
    """

    enabled: bool
    """ Enable the socket

    :type: bool
    """

    hide: bool
    """ Hide the socket

    :type: bool
    """

    hide_value: bool
    """ Hide the socket input value

    :type: bool
    """

    identifier: typing.Union[str, typing.Any]
    """ Unique identifier for mapping sockets

    :type: typing.Union[str, typing.Any]
    """

    is_linked: typing.Union[bool, typing.Any]
    """ True if the socket is connected

    :type: typing.Union[bool, typing.Any]
    """

    is_multi_input: typing.Union[bool, typing.Any]
    """ True if the socket can accept multiple ordered input links

    :type: typing.Union[bool, typing.Any]
    """

    is_output: typing.Union[bool, typing.Any]
    """ True if the socket is an output, otherwise input

    :type: typing.Union[bool, typing.Any]
    """

    is_unavailable: typing.Union[bool, typing.Any]
    """ True if the socket is unavailable

    :type: typing.Union[bool, typing.Any]
    """

    label: typing.Union[str, typing.Any]
    """ Custom dynamic defined socket label

    :type: typing.Union[str, typing.Any]
    """

    link_limit: int
    """ Max number of links allowed for this socket

    :type: int
    """

    name: typing.Union[str, typing.Any]
    """ Socket name

    :type: typing.Union[str, typing.Any]
    """

    node: "Node"
    """ Node owning this socket

    :type: 'Node'
    """

    show_expanded: bool
    """ Socket links are expanded in the user interface

    :type: bool
    """

    type: typing.Union[int, str]
    """ Data type

    :type: typing.Union[int, str]
    """

    links: typing.Any
    """ List of node links from or to this socket.(readonly)"""

    def draw(
        self,
        context: "Context",
        layout: "UILayout",
        node: "Node",
        text: typing.Union[str, typing.Any],
    ):
        """Draw socket

        :param context:
        :type context: 'Context'
        :param layout: Layout, Layout in the UI
        :type layout: 'UILayout'
        :param node: Node, Node the socket belongs to
        :type node: 'Node'
        :param text: Text, Text label to draw alongside properties
        :type text: typing.Union[str, typing.Any]
        """
        ...

    def draw_color(self, context: "Context", node: "Node") -> bpy_prop_array[float]:
        """Color of the socket icon

        :param context:
        :type context: 'Context'
        :param node: Node, Node the socket belongs to
        :type node: 'Node'
        :rtype: bpy_prop_array[float]
        :return: Color
        """
        ...

    def draw_color_simple(self) -> bpy_prop_array[float]:
        """Color of the socket icon. Used to draw sockets in places where the socket does not belong to a node, like the node interface panel. Also used to draw node sockets if draw_color is not defined

        :rtype: bpy_prop_array[float]
        :return: Color
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeTreeInterface(bpy_struct):
    """Declaration of sockets and ui panels of a node group"""

    active: "NodeTreeInterfaceItem"
    """ Active item

    :type: 'NodeTreeInterfaceItem'
    """

    active_index: int
    """ Index of the active item

    :type: int
    """

    items_tree: bpy_prop_collection["NodeTreeInterfaceItem"]
    """ Items in the node interface

    :type: bpy_prop_collection['NodeTreeInterfaceItem']
    """

    def new_socket(
        self,
        name: typing.Union[str, typing.Any],
        description: typing.Union[str, typing.Any] = "",
        in_out: typing.Optional[typing.Any] = "INPUT",
        socket_type: typing.Optional[typing.Union[int, str, typing.Any]] = "DEFAULT",
        parent: typing.Optional["NodeTreeInterfacePanel"] = None,
    ) -> "NodeTreeInterfaceSocket":
        """Add a new socket to the interface

                :param name: Name, Name of the socket
                :type name: typing.Union[str, typing.Any]
                :param description: Description, Description of the socket
                :type description: typing.Union[str, typing.Any]
                :param in_out: Input/Output Type, Create an input or output socket

        INPUT
        Input -- Generate a input node socket.

        OUTPUT
        Output -- Generate a output node socket.
                :type in_out: typing.Optional[typing.Any]
                :param socket_type: Socket Type, Type of socket generated on nodes
                :type socket_type: typing.Optional[typing.Union[int, str, typing.Any]]
                :param parent: Parent, Panel to add the socket in
                :type parent: typing.Optional['NodeTreeInterfacePanel']
                :rtype: 'NodeTreeInterfaceSocket'
                :return: Socket, New socket
        """
        ...

    def new_panel(
        self,
        name: typing.Union[str, typing.Any],
        description: typing.Union[str, typing.Any] = "",
        default_closed: typing.Optional[typing.Union[bool, typing.Any]] = False,
        parent: typing.Optional["NodeTreeInterfacePanel"] = None,
    ) -> "NodeTreeInterfacePanel":
        """Add a new panel to the interface

        :param name: Name, Name of the new panel
        :type name: typing.Union[str, typing.Any]
        :param description: Description, Description of the panel
        :type description: typing.Union[str, typing.Any]
        :param default_closed: Default Closed, Panel is closed by default on new nodes
        :type default_closed: typing.Optional[typing.Union[bool, typing.Any]]
        :param parent: Parent, Add panel as a child of the parent panel
        :type parent: typing.Optional['NodeTreeInterfacePanel']
        :rtype: 'NodeTreeInterfacePanel'
        :return: Panel, New panel
        """
        ...

    def copy(self, item: "NodeTreeInterfaceItem") -> "NodeTreeInterfaceItem":
        """Add a copy of an item to the interface

        :param item: Item, Item to copy
        :type item: 'NodeTreeInterfaceItem'
        :rtype: 'NodeTreeInterfaceItem'
        :return: Item Copy, Copy of the item
        """
        ...

    def remove(
        self,
        item: "NodeTreeInterfaceItem",
        move_content_to_parent: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ):
        """Remove an item from the interface

        :param item: Item, The item to remove
        :type item: 'NodeTreeInterfaceItem'
        :param move_content_to_parent: Move Content, If the item is a panel, move the contents to the parent instead of deleting it
        :type move_content_to_parent: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def clear(self):
        """Remove all items from the interface"""
        ...

    def move(self, item: "NodeTreeInterfaceItem", to_position: typing.Optional[int]):
        """Move an item to another position

        :param item: Item, The item to move
        :type item: 'NodeTreeInterfaceItem'
        :param to_position: To Position, Target position for the item in its current panel
        :type to_position: typing.Optional[int]
        """
        ...

    def move_to_parent(
        self,
        item: "NodeTreeInterfaceItem",
        parent: typing.Optional["NodeTreeInterfacePanel"],
        to_position: typing.Optional[int],
    ):
        """Move an item to a new panel and/or position.

        :param item: Item, The item to move
        :type item: 'NodeTreeInterfaceItem'
        :param parent: Parent, New parent of the item
        :type parent: typing.Optional['NodeTreeInterfacePanel']
        :param to_position: To Position, Target position for the item in the new parent panel
        :type to_position: typing.Optional[int]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeTreeInterfaceItem(bpy_struct):
    """Item in a node tree interface"""

    index: int
    """ Global index of the item among all items in the interface

    :type: int
    """

    item_type: typing.Any
    """ Type of interface item

    :type: typing.Any
    """

    parent: "NodeTreeInterfacePanel"
    """ Panel that contains the item

    :type: 'NodeTreeInterfacePanel'
    """

    position: int
    """ Position of the item in its parent panel

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodeTreePath(bpy_struct):
    """Element of the node space tree path"""

    node_tree: "NodeTree"
    """ Base node tree from context

    :type: 'NodeTree'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodesModifierBake(bpy_struct):
    bake_id: int
    """ Identifier for this bake which remains unchanged even when the bake node is renamed, grouped or ungrouped

    :type: int
    """

    bake_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    data_blocks: "NodesModifierBakeDataBlocks"
    """ 

    :type: 'NodesModifierBakeDataBlocks'
    """

    directory: typing.Union[str, typing.Any]
    """ Location on disk where the bake data is stored

    :type: typing.Union[str, typing.Any]
    """

    frame_end: int
    """ Frame where the baking ends

    :type: int
    """

    frame_start: int
    """ Frame where the baking starts

    :type: int
    """

    node: "Node"
    """ Bake node or simulation output node that corresponds to this bake. This node may be deeply nested in the modifier node group. It can be none in some cases like missing linked data blocks

    :type: 'Node'
    """

    use_custom_path: bool
    """ Specify a path where the baked data should be stored manually

    :type: bool
    """

    use_custom_simulation_frame_range: bool
    """ Override the simulation frame range from the scene

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodesModifierDataBlock(bpy_struct):
    id: "ID"
    """ 

    :type: 'ID'
    """

    id_name: typing.Union[str, typing.Any]
    """ Name that is mapped to the referenced data-block

    :type: typing.Union[str, typing.Any]
    """

    id_type: typing.Any
    """ 

    :type: typing.Any
    """

    lib_name: typing.Union[str, typing.Any]
    """ Used when the data block is not local to the current .blend file but is linked from some library

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class NodesModifierPanel(bpy_struct):
    is_open: bool
    """ Whether the panel is expanded or closed

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ObjectBase(bpy_struct):
    """An object instance in a render layer"""

    hide_viewport: bool
    """ Temporarily hide in viewport

    :type: bool
    """

    object: "Object"
    """ Object this base links to

    :type: 'Object'
    """

    select: bool
    """ Object base selection state

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ObjectDisplay(bpy_struct):
    """Object display settings for 3D viewport"""

    show_shadows: bool
    """ Object cast shadows in the 3D viewport

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ObjectLightLinking(bpy_struct):
    blocker_collection: "Collection"
    """ Collection which defines objects which block light from this emitter

    :type: 'Collection'
    """

    receiver_collection: "Collection"
    """ Collection which defines light linking relation of this emitter

    :type: 'Collection'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ObjectLineArt(bpy_struct):
    """Object line art settings"""

    crease_threshold: float
    """ Angles smaller than this will be treated as creases

    :type: float
    """

    intersection_priority: int
    """ The intersection line will be included into the object with the higher intersection priority value

    :type: int
    """

    usage: typing.Union[int, str]
    """ How to use this object in line art calculation

    :type: typing.Union[int, str]
    """

    use_crease_override: bool
    """ Use this object's crease setting to overwrite scene global

    :type: bool
    """

    use_intersection_priority_override: bool
    """ Use this object's intersection priority to override collection setting

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Operator(bpy_struct):
    """Storage of an operator being executed, or registered after execution"""

    bl_cursor_pending: typing.Union[int, str]
    """ Cursor to use when waiting for the user to select a location to activate the operator (when bl_options has DEPENDS_ON_CURSOR set)

    :type: typing.Union[int, str]
    """

    bl_description: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Options for this operator type

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    bl_translation_context: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_undo_group: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    has_reports: typing.Union[bool, typing.Any]
    """ Operator has a set of reports (warnings and errors) from last execution

    :type: typing.Union[bool, typing.Any]
    """

    layout: "UILayout"
    """ 

    :type: 'UILayout'
    """

    macros: bpy_prop_collection["Macro"]
    """ 

    :type: bpy_prop_collection['Macro']
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    options: "OperatorOptions"
    """ Runtime options

    :type: 'OperatorOptions'
    """

    properties: "OperatorProperties"
    """ 

    :type: 'OperatorProperties'
    """

    bl_property: typing.Any
    """ The name of a property to use as this operators primary property.
Currently this is only used to select the default property when
expanding an operator into a menu.
:type: string"""

    def report(
        self,
        type: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]],
        message: typing.Union[str, typing.Any],
    ):
        """report

        :param type: Type
        :type type: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]]
        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        """
        ...

    def is_repeat(self) -> bool:
        """is_repeat

        :rtype: bool
        :return: result
        """
        ...

    def poll(self, context: "Context") -> bool:
        """Test if the operator can be called or not

        :param context:
        :type context: 'Context'
        :rtype: bool
        """
        ...

    def execute(
        self, context: "Context"
    ) -> typing.Union[typing.Set[int], typing.Set[str]]:
        """Execute the operator

        :param context:
        :type context: 'Context'
        :rtype: typing.Union[typing.Set[int], typing.Set[str]]
        :return: result
        """
        ...

    def check(self, context: "Context") -> bool:
        """Check the operator settings, return True to signal a change to redraw

        :param context:
        :type context: 'Context'
        :rtype: bool
        :return: result
        """
        ...

    def invoke(
        self, context: "Context", event: "Event"
    ) -> typing.Union[typing.Set[int], typing.Set[str]]:
        """Invoke the operator

        :param context:
        :type context: 'Context'
        :param event:
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[int], typing.Set[str]]
        :return: result
        """
        ...

    def modal(
        self, context: "Context", event: "Event"
    ) -> typing.Union[typing.Set[int], typing.Set[str]]:
        """Modal operator function

        :param context:
        :type context: 'Context'
        :param event:
        :type event: 'Event'
        :rtype: typing.Union[typing.Set[int], typing.Set[str]]
        :return: result
        """
        ...

    def draw(self, context: "Context"):
        """Draw function for the operator

        :param context:
        :type context: 'Context'
        """
        ...

    def cancel(self, context: "Context"):
        """Called when the operator is canceled

        :param context:
        :type context: 'Context'
        """
        ...

    def description(self, context: "Context", properties: "OperatorProperties") -> str:
        """Compute a description string that depends on parameters

        :param context:
        :type context: 'Context'
        :param properties:
        :type properties: 'OperatorProperties'
        :rtype: str
        :return: result
        """
        ...

    def as_keywords(self, *, ignore=()):
        """Return a copy of the properties as a dictionary

        :param *:
        :type *:
        :param ignore:
        :type ignore:
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

    def poll_message_set(self, message: typing.Optional[str], *args):
        """Set the message to show in the tool-tip when poll fails.When message is callable, additional user defined positional arguments are passed to the message function.

        :param message: The message or a function that returns the message.
        :type message: typing.Optional[str]
        :param *args:
        :type *args:
        """
        ...

class OperatorMacro(bpy_struct):
    """Storage of a sub operator in a macro after it has been added"""

    properties: "OperatorProperties"
    """ 

    :type: 'OperatorProperties'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class OperatorOptions(bpy_struct):
    """Runtime options"""

    is_grab_cursor: typing.Union[bool, typing.Any]
    """ True when the cursor is grabbed

    :type: typing.Union[bool, typing.Any]
    """

    is_invoke: typing.Union[bool, typing.Any]
    """ True when invoked (even if only the execute callbacks available)

    :type: typing.Union[bool, typing.Any]
    """

    is_repeat: typing.Union[bool, typing.Any]
    """ True when run from the 'Adjust Last Operation' panel

    :type: typing.Union[bool, typing.Any]
    """

    is_repeat_last: typing.Union[bool, typing.Any]
    """ True when run from the operator 'Repeat Last'

    :type: typing.Union[bool, typing.Any]
    """

    use_cursor_region: bool
    """ Enable to use the region under the cursor for modal execution

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class OperatorProperties(bpy_struct):
    """Input properties of an operator"""

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PackedFile(bpy_struct):
    """External file packed into the .blend file"""

    data: typing.Union[str, typing.Any]
    """ Raw data (bytes, exact content of the embedded file)

    :type: typing.Union[str, typing.Any]
    """

    size: int
    """ Size of packed file in bytes

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Paint(bpy_struct):
    brush: "Brush"
    """ Active Brush

    :type: 'Brush'
    """

    cavity_curve: "CurveMapping"
    """ Editable cavity curve

    :type: 'CurveMapping'
    """

    palette: "Palette"
    """ Active Palette

    :type: 'Palette'
    """

    show_brush: bool
    """ 

    :type: bool
    """

    show_brush_on_surface: bool
    """ 

    :type: bool
    """

    show_low_resolution: bool
    """ For multires, show low resolution while navigating the view

    :type: bool
    """

    tile_offset: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Stride at which tiled strokes are copied

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    tile_x: bool
    """ Tile along X axis

    :type: bool
    """

    tile_y: bool
    """ Tile along Y axis

    :type: bool
    """

    tile_z: bool
    """ Tile along Z axis

    :type: bool
    """

    tool_slots: bpy_prop_collection["PaintToolSlot"]
    """ 

    :type: bpy_prop_collection['PaintToolSlot']
    """

    use_cavity: bool
    """ Mask painting according to mesh geometry cavity

    :type: bool
    """

    use_sculpt_delay_updates: bool
    """ Update the geometry when it enters the view, providing faster view navigation

    :type: bool
    """

    use_symmetry_feather: bool
    """ Reduce the strength of the brush where it overlaps symmetrical daubs

    :type: bool
    """

    use_symmetry_x: bool
    """ Mirror brush across the X axis

    :type: bool
    """

    use_symmetry_y: bool
    """ Mirror brush across the Y axis

    :type: bool
    """

    use_symmetry_z: bool
    """ Mirror brush across the Z axis

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PaintModeSettings(bpy_struct):
    """Properties of paint mode"""

    canvas_image: "Image"
    """ Image used as painting target

    :type: 'Image'
    """

    canvas_source: typing.Union[int, str]
    """ Source to select canvas from

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PaintToolSlot(bpy_struct):
    brush: "Brush"
    """ 

    :type: 'Brush'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PaletteColor(bpy_struct):
    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    strength: float
    """ 

    :type: float
    """

    weight: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Panel(bpy_struct):
    """Panel containing UI elements"""

    bl_category: typing.Union[str, typing.Any]
    """ The category (tab) in which the panel will be displayed, when applicable

    :type: typing.Union[str, typing.Any]
    """

    bl_context: typing.Union[str, typing.Any]
    """ The context in which the panel belongs to. (TODO: explain the possible combinations bl_context/bl_region_type/bl_space_type)

    :type: typing.Union[str, typing.Any]
    """

    bl_description: str
    """ The panel tooltip

    :type: str
    """

    bl_idname: typing.Union[str, typing.Any]
    """ If this is set, the panel gets a custom ID, otherwise it takes the name of the class used to define the panel. For example, if the class name is "OBJECT_PT_hello", and bl_idname is not set by the script, then bl_idname = "OBJECT_PT_hello"

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ The panel label, shows up in the panel header at the right of the triangle used to collapse the panel

    :type: typing.Union[str, typing.Any]
    """

    bl_options: typing.Union[typing.Set[int], typing.Set[str]]
    """ Options for this panel type

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    bl_order: int
    """ Panels with lower numbers are default ordered before panels with higher numbers

    :type: int
    """

    bl_owner_id: typing.Union[str, typing.Any]
    """ The ID owning the data displayed in the panel, if any

    :type: typing.Union[str, typing.Any]
    """

    bl_parent_id: typing.Union[str, typing.Any]
    """ If this is set, the panel becomes a sub-panel

    :type: typing.Union[str, typing.Any]
    """

    bl_region_type: typing.Union[int, str]
    """ The region where the panel is going to be used in

    :type: typing.Union[int, str]
    """

    bl_space_type: typing.Union[int, str]
    """ The space where the panel is going to be used in

    :type: typing.Union[int, str]
    """

    bl_translation_context: typing.Union[str, typing.Any]
    """ Specific translation context, only define when the label needs to be disambiguated from others using the exact same label

    :type: typing.Union[str, typing.Any]
    """

    bl_ui_units_x: int
    """ When set, defines popup panel width

    :type: int
    """

    custom_data: "Constraint"
    """ Panel data

    :type: 'Constraint'
    """

    is_popover: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    layout: "UILayout"
    """ Defines the structure of the panel in the UI

    :type: 'UILayout'
    """

    text: typing.Union[str, typing.Any]
    """ XXX todo

    :type: typing.Union[str, typing.Any]
    """

    use_pin: bool
    """ Show the panel on all tabs

    :type: bool
    """

    def poll(self, context: "Context") -> bool:
        """If this method returns a non-null output, then the panel can be drawn

        :param context:
        :type context: 'Context'
        :rtype: bool
        """
        ...

    def draw(self, context: "Context"):
        """Draw UI elements into the panel UI layout

        :param context:
        :type context: 'Context'
        """
        ...

    def draw_header(self, context: "Context"):
        """Draw UI elements into the panel's header UI layout

        :param context:
        :type context: 'Context'
        """
        ...

    def draw_header_preset(self, context: "Context"):
        """Draw UI elements for presets in the panel's header

        :param context:
        :type context: 'Context'
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Particle(bpy_struct):
    """Particle in a particle system"""

    alive_state: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    angular_velocity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    birth_time: float
    """ 

    :type: float
    """

    die_time: float
    """ 

    :type: float
    """

    hair_keys: bpy_prop_collection["ParticleHairKey"]
    """ 

    :type: bpy_prop_collection['ParticleHairKey']
    """

    is_exist: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    is_visible: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    lifetime: float
    """ 

    :type: float
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    particle_keys: bpy_prop_collection["ParticleKey"]
    """ 

    :type: bpy_prop_collection['ParticleKey']
    """

    prev_angular_velocity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    prev_location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    prev_rotation: typing.Union[
        "mathutils.Quaternion",
        typing.List[float],
        typing.Tuple[float, float, float, float],
    ]
    """ 

    :type: typing.Union['mathutils.Quaternion', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    prev_velocity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    rotation: typing.Union[
        "mathutils.Quaternion",
        typing.List[float],
        typing.Tuple[float, float, float, float],
    ]
    """ 

    :type: typing.Union['mathutils.Quaternion', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    size: float
    """ 

    :type: float
    """

    velocity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    def uv_on_emitter(
        self, modifier: "ParticleSystemModifier"
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]:
        """Obtain UV coordinates for a particle on an evaluated mesh.

        :param modifier: Particle modifier from an evaluated object
        :type modifier: 'ParticleSystemModifier'
        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
        :return: uv
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleBrush(bpy_struct):
    """Particle editing brush"""

    count: int
    """ Particle count

    :type: int
    """

    curve: "CurveMapping"
    """ 

    :type: 'CurveMapping'
    """

    length_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    puff_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    size: int
    """ Radius of the brush in pixels

    :type: int
    """

    steps: int
    """ Brush steps

    :type: int
    """

    strength: float
    """ Brush strength

    :type: float
    """

    use_puff_volume: bool
    """ Apply puff to unselected end-points (helps maintain hair volume when puffing root)

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleDupliWeight(bpy_struct):
    """Weight of a particle instance object in a collection"""

    count: int
    """ The number of times this object is repeated with respect to other objects

    :type: int
    """

    name: typing.Union[str, typing.Any]
    """ Particle instance object name

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleEdit(bpy_struct):
    """Properties of particle editing mode"""

    brush: "ParticleBrush"
    """ 

    :type: 'ParticleBrush'
    """

    default_key_count: int
    """ How many keys to make new particles with

    :type: int
    """

    display_step: int
    """ How many steps to display the path with

    :type: int
    """

    emitter_distance: float
    """ Distance to keep particles away from the emitter

    :type: float
    """

    fade_frames: int
    """ How many frames to fade

    :type: int
    """

    is_editable: typing.Union[bool, typing.Any]
    """ A valid edit mode exists

    :type: typing.Union[bool, typing.Any]
    """

    is_hair: typing.Union[bool, typing.Any]
    """ Editing hair

    :type: typing.Union[bool, typing.Any]
    """

    object: "Object"
    """ The edited object

    :type: 'Object'
    """

    select_mode: typing.Union[int, str]
    """ Particle select and display mode

    :type: typing.Union[int, str]
    """

    shape_object: "Object"
    """ Outer shape to use for tools

    :type: 'Object'
    """

    show_particles: bool
    """ Display actual particles

    :type: bool
    """

    tool: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    use_auto_velocity: bool
    """ Calculate point velocities automatically

    :type: bool
    """

    use_default_interpolate: bool
    """ Interpolate new particles from the existing ones

    :type: bool
    """

    use_emitter_deflect: bool
    """ Keep paths from intersecting the emitter

    :type: bool
    """

    use_fade_time: bool
    """ Fade paths and keys further away from current frame

    :type: bool
    """

    use_preserve_length: bool
    """ Keep path lengths constant

    :type: bool
    """

    use_preserve_root: bool
    """ Keep root keys unmodified

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleHairKey(bpy_struct):
    """Particle key for hair particle system"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of the hair key in object space

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    co_local: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of the hair key in its local coordinate system, relative to the emitting face

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    time: float
    """ Relative time of key over hair length

    :type: float
    """

    weight: float
    """ Weight for cloth simulation

    :type: float
    """

    def co_object(
        self, object: "Object", modifier: "ParticleSystemModifier", particle: "Particle"
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]:
        """Obtain hairkey location with particle and modifier data

        :param object: Object
        :type object: 'Object'
        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: hair particle
        :type particle: 'Particle'
        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
        :return: Co, Exported hairkey location
        """
        ...

    def co_object_set(
        self,
        object: "Object",
        modifier: "ParticleSystemModifier",
        particle: "Particle",
        co: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
    ):
        """Set hairkey location with particle and modifier data

        :param object: Object
        :type object: 'Object'
        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: hair particle
        :type particle: 'Particle'
        :param co: Co, Specified hairkey location
        :type co: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleKey(bpy_struct):
    """Key location for a particle over time"""

    angular_velocity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Key angular velocity

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Key location

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    rotation: typing.Union[
        "mathutils.Quaternion",
        typing.List[float],
        typing.Tuple[float, float, float, float],
    ]
    """ Key rotation quaternion

    :type: typing.Union['mathutils.Quaternion', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    time: float
    """ Time of key over the simulation

    :type: float
    """

    velocity: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Key velocity

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleSystem(bpy_struct):
    """Particle system in an object"""

    active_particle_target: "ParticleTarget"
    """ 

    :type: 'ParticleTarget'
    """

    active_particle_target_index: int
    """ 

    :type: int
    """

    child_particles: bpy_prop_collection["ChildParticle"]
    """ Child particles generated by the particle system

    :type: bpy_prop_collection['ChildParticle']
    """

    child_seed: int
    """ Offset in the random number table for child particles, to get a different randomized result

    :type: int
    """

    cloth: "ClothModifier"
    """ Cloth dynamics for hair

    :type: 'ClothModifier'
    """

    dt_frac: float
    """ The current simulation time step size, as a fraction of a frame

    :type: float
    """

    has_multiple_caches: typing.Union[bool, typing.Any]
    """ Particle system has multiple point caches

    :type: typing.Union[bool, typing.Any]
    """

    invert_vertex_group_clump: bool
    """ Negate the effect of the clump vertex group

    :type: bool
    """

    invert_vertex_group_density: bool
    """ Negate the effect of the density vertex group

    :type: bool
    """

    invert_vertex_group_field: bool
    """ Negate the effect of the field vertex group

    :type: bool
    """

    invert_vertex_group_kink: bool
    """ Negate the effect of the kink vertex group

    :type: bool
    """

    invert_vertex_group_length: bool
    """ Negate the effect of the length vertex group

    :type: bool
    """

    invert_vertex_group_rotation: bool
    """ Negate the effect of the rotation vertex group

    :type: bool
    """

    invert_vertex_group_roughness_1: bool
    """ Negate the effect of the roughness 1 vertex group

    :type: bool
    """

    invert_vertex_group_roughness_2: bool
    """ Negate the effect of the roughness 2 vertex group

    :type: bool
    """

    invert_vertex_group_roughness_end: bool
    """ Negate the effect of the roughness end vertex group

    :type: bool
    """

    invert_vertex_group_size: bool
    """ Negate the effect of the size vertex group

    :type: bool
    """

    invert_vertex_group_tangent: bool
    """ Negate the effect of the tangent vertex group

    :type: bool
    """

    invert_vertex_group_twist: bool
    """ Negate the effect of the twist vertex group

    :type: bool
    """

    invert_vertex_group_velocity: bool
    """ Negate the effect of the velocity vertex group

    :type: bool
    """

    is_editable: typing.Union[bool, typing.Any]
    """ Particle system can be edited in particle mode

    :type: typing.Union[bool, typing.Any]
    """

    is_edited: typing.Union[bool, typing.Any]
    """ Particle system has been edited in particle mode

    :type: typing.Union[bool, typing.Any]
    """

    is_global_hair: typing.Union[bool, typing.Any]
    """ Hair keys are in global coordinate space

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Particle system name

    :type: typing.Union[str, typing.Any]
    """

    parent: "Object"
    """ Use this object's coordinate system instead of global coordinate system

    :type: 'Object'
    """

    particles: bpy_prop_collection["Particle"]
    """ Particles generated by the particle system

    :type: bpy_prop_collection['Particle']
    """

    point_cache: "PointCache"
    """ 

    :type: 'PointCache'
    """

    reactor_target_object: "Object"
    """ For reactor systems, the object that has the target particle system (empty if same object)

    :type: 'Object'
    """

    reactor_target_particle_system: int
    """ For reactor systems, index of particle system on the target object

    :type: int
    """

    seed: int
    """ Offset in the random number table, to get a different randomized result

    :type: int
    """

    settings: "ParticleSettings"
    """ Particle system settings

    :type: 'ParticleSettings'
    """

    targets: bpy_prop_collection["ParticleTarget"]
    """ Target particle systems

    :type: bpy_prop_collection['ParticleTarget']
    """

    use_hair_dynamics: bool
    """ Enable hair dynamics using cloth simulation

    :type: bool
    """

    use_keyed_timing: bool
    """ Use key times

    :type: bool
    """

    vertex_group_clump: typing.Union[str, typing.Any]
    """ Vertex group to control clump

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_density: typing.Union[str, typing.Any]
    """ Vertex group to control density

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_field: typing.Union[str, typing.Any]
    """ Vertex group to control field

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_kink: typing.Union[str, typing.Any]
    """ Vertex group to control kink

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_length: typing.Union[str, typing.Any]
    """ Vertex group to control length

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_rotation: typing.Union[str, typing.Any]
    """ Vertex group to control rotation

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_roughness_1: typing.Union[str, typing.Any]
    """ Vertex group to control roughness 1

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_roughness_2: typing.Union[str, typing.Any]
    """ Vertex group to control roughness 2

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_roughness_end: typing.Union[str, typing.Any]
    """ Vertex group to control roughness end

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_size: typing.Union[str, typing.Any]
    """ Vertex group to control size

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_tangent: typing.Union[str, typing.Any]
    """ Vertex group to control tangent

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_twist: typing.Union[str, typing.Any]
    """ Vertex group to control twist

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_velocity: typing.Union[str, typing.Any]
    """ Vertex group to control velocity

    :type: typing.Union[str, typing.Any]
    """

    def co_hair(
        self,
        object: "Object",
        particle_no: typing.Optional[typing.Any] = 0,
        step: typing.Optional[typing.Any] = 0,
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]:
        """Obtain cache hair data

        :param object: Object
        :type object: 'Object'
        :param particle_no: Particle no
        :type particle_no: typing.Optional[typing.Any]
        :param step: step no
        :type step: typing.Optional[typing.Any]
        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
        :return: Co, Exported hairkey location
        """
        ...

    def uv_on_emitter(
        self,
        modifier: "ParticleSystemModifier",
        particle: "Particle",
        particle_no: typing.Optional[typing.Any] = 0,
        uv_no: typing.Optional[typing.Any] = 0,
    ) -> typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float]
    ]:
        """Obtain uv for all particles

        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: Particle
        :type particle: 'Particle'
        :param particle_no: Particle no
        :type particle_no: typing.Optional[typing.Any]
        :param uv_no: UV no
        :type uv_no: typing.Optional[typing.Any]
        :rtype: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float]]
        :return: uv
        """
        ...

    def mcol_on_emitter(
        self,
        modifier: "ParticleSystemModifier",
        particle: "Particle",
        particle_no: typing.Optional[typing.Any] = 0,
        vcol_no: typing.Optional[typing.Any] = 0,
    ) -> typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]:
        """Obtain mcol for all particles

        :param modifier: Particle modifier
        :type modifier: 'ParticleSystemModifier'
        :param particle: Particle
        :type particle: 'Particle'
        :param particle_no: Particle no
        :type particle_no: typing.Optional[typing.Any]
        :param vcol_no: vcol no
        :type vcol_no: typing.Optional[typing.Any]
        :rtype: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
        :return: mcol
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ParticleTarget(bpy_struct):
    """Target particle system"""

    alliance: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    duration: float
    """ 

    :type: float
    """

    is_valid: bool
    """ Keyed particles target is valid

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Particle target name

    :type: typing.Union[str, typing.Any]
    """

    object: "Object"
    """ The object that has the target particle system (empty if same object)

    :type: 'Object'
    """

    system: int
    """ The index of particle system on the target object

    :type: int
    """

    time: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PathCompare(bpy_struct):
    """Match paths against this value"""

    path: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    use_glob: bool
    """ Enable wildcard globbing

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Point(bpy_struct):
    """Point in a point cloud"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    index: int
    """ Index of this point

    :type: int
    """

    radius: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PointCache(bpy_struct):
    """Active point cache for physics simulations"""

    compression: typing.Union[int, str]
    """ Compression method to be used

    :type: typing.Union[int, str]
    """

    filepath: typing.Union[str, typing.Any]
    """ Cache file path

    :type: typing.Union[str, typing.Any]
    """

    frame_end: int
    """ Frame on which the simulation stops

    :type: int
    """

    frame_start: int
    """ Frame on which the simulation starts

    :type: int
    """

    frame_step: int
    """ Number of frames between cached frames

    :type: int
    """

    index: int
    """ Index number of cache files

    :type: int
    """

    info: typing.Union[str, typing.Any]
    """ Info on current cache status

    :type: typing.Union[str, typing.Any]
    """

    is_baked: typing.Union[bool, typing.Any]
    """ The cache is baked

    :type: typing.Union[bool, typing.Any]
    """

    is_baking: typing.Union[bool, typing.Any]
    """ The cache is being baked

    :type: typing.Union[bool, typing.Any]
    """

    is_frame_skip: typing.Union[bool, typing.Any]
    """ Some frames were skipped while baking/saving that cache

    :type: typing.Union[bool, typing.Any]
    """

    is_outdated: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Cache name

    :type: typing.Union[str, typing.Any]
    """

    point_caches: "PointCaches"
    """ 

    :type: 'PointCaches'
    """

    use_disk_cache: bool
    """ Save cache files to disk (.blend file must be saved first)

    :type: bool
    """

    use_external: bool
    """ Read cache from an external location

    :type: bool
    """

    use_library_path: bool
    """ Use this file's path for the disk cache when library linked into another file (for local bakes per scene file, disable this option)

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PointCacheItem(bpy_struct):
    """Point cache for physics simulations"""

    compression: typing.Union[int, str]
    """ Compression method to be used

    :type: typing.Union[int, str]
    """

    filepath: typing.Union[str, typing.Any]
    """ Cache file path

    :type: typing.Union[str, typing.Any]
    """

    frame_end: int
    """ Frame on which the simulation stops

    :type: int
    """

    frame_start: int
    """ Frame on which the simulation starts

    :type: int
    """

    frame_step: int
    """ Number of frames between cached frames

    :type: int
    """

    index: int
    """ Index number of cache files

    :type: int
    """

    info: typing.Union[str, typing.Any]
    """ Info on current cache status

    :type: typing.Union[str, typing.Any]
    """

    is_baked: typing.Union[bool, typing.Any]
    """ The cache is baked

    :type: typing.Union[bool, typing.Any]
    """

    is_baking: typing.Union[bool, typing.Any]
    """ The cache is being baked

    :type: typing.Union[bool, typing.Any]
    """

    is_frame_skip: typing.Union[bool, typing.Any]
    """ Some frames were skipped while baking/saving that cache

    :type: typing.Union[bool, typing.Any]
    """

    is_outdated: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Cache name

    :type: typing.Union[str, typing.Any]
    """

    use_disk_cache: bool
    """ Save cache files to disk (.blend file must be saved first)

    :type: bool
    """

    use_external: bool
    """ Read cache from an external location

    :type: bool
    """

    use_library_path: bool
    """ Use this file's path for the disk cache when library linked into another file (for local bakes per scene file, disable this option)

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Pose(bpy_struct):
    """A collection of pose channels, including settings for animating bones"""

    animation_visualization: "AnimViz"
    """ Animation data for this data-block

    :type: 'AnimViz'
    """

    bones: bpy_prop_collection["PoseBone"]
    """ Individual pose bones for the armature

    :type: bpy_prop_collection['PoseBone']
    """

    ik_param: "IKParam"
    """ Parameters for IK solver

    :type: 'IKParam'
    """

    ik_solver: typing.Union[int, str]
    """ Selection of IK solver for IK chain

    :type: typing.Union[int, str]
    """

    use_auto_ik: bool
    """ Add temporary IK constraints while grabbing bones in Pose Mode

    :type: bool
    """

    use_mirror_relative: bool
    """ Apply relative transformations in X-mirror mode (not supported with Auto IK)

    :type: bool
    """

    use_mirror_x: bool
    """ Apply changes to matching bone on opposite side of X-Axis

    :type: bool
    """

    def apply_pose_from_action(
        self,
        action: typing.Optional["Action"],
        evaluation_time: typing.Optional[typing.Any] = 0.0,
    ):
        """Apply the given action to this pose by evaluating it at a specific time. Only updates the pose of selected bones, or all bones if none are selected.

        :param action: Action, The Action containing the pose
        :type action: typing.Optional['Action']
        :param evaluation_time: Evaluation Time, Time at which the given action is evaluated to obtain the pose
        :type evaluation_time: typing.Optional[typing.Any]
        """
        ...

    def blend_pose_from_action(
        self,
        action: typing.Optional["Action"],
        blend_factor: typing.Optional[typing.Any] = 1.0,
        evaluation_time: typing.Optional[typing.Any] = 0.0,
    ):
        """Blend the given action into this pose by evaluating it at a specific time. Only updates the pose of selected bones, or all bones if none are selected.

        :param action: Action, The Action containing the pose
        :type action: typing.Optional['Action']
        :param blend_factor: Blend Factor, How much the given Action affects the final pose
        :type blend_factor: typing.Optional[typing.Any]
        :param evaluation_time: Evaluation Time, Time at which the given action is evaluated to obtain the pose
        :type evaluation_time: typing.Optional[typing.Any]
        """
        ...

    def backup_create(self, action: typing.Optional["Action"]):
        """Create a backup of the current pose. Only those bones that are animated in the Action are backed up. The object owns the backup, and each object can have only one backup at a time. When you no longer need it, it must be freed use backup_clear()

        :param action: Action, An Action with animation data for the bones. Only the animated bones will be included in the backup
        :type action: typing.Optional['Action']
        """
        ...

    def backup_restore(self) -> bool:
        """Restore the previously made pose backup. This can be called multiple times. See Pose.backup_create() for more info

        :rtype: bool
        :return: True when the backup was restored, False if there was no backup to restore
        """
        ...

    def backup_clear(self):
        """Free a previously made pose backup. See Pose.backup_create() for more info."""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PoseBone(bpy_struct):
    """Channel defining pose data for a bone in a Pose"""

    bbone_curveinx: float
    """ X-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveinz: float
    """ Z-axis handle offset for start of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutx: float
    """ X-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_curveoutz: float
    """ Z-axis handle offset for end of the B-Bone's curve, adjusts curvature

    :type: float
    """

    bbone_custom_handle_end: "PoseBone"
    """ Bone that serves as the end handle for the B-Bone curve

    :type: 'PoseBone'
    """

    bbone_custom_handle_start: "PoseBone"
    """ Bone that serves as the start handle for the B-Bone curve

    :type: 'PoseBone'
    """

    bbone_easein: float
    """ Length of first Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_easeout: float
    """ Length of second Bézier Handle (for B-Bones only)

    :type: float
    """

    bbone_rollin: float
    """ Roll offset for the start of the B-Bone, adjusts twist

    :type: float
    """

    bbone_rollout: float
    """ Roll offset for the end of the B-Bone, adjusts twist

    :type: float
    """

    bbone_scalein: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale factors for the start of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bbone_scaleout: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Scale factors for the end of the B-Bone, adjusts thickness (for tapering effects)

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    bone: "Bone"
    """ Bone associated with this PoseBone

    :type: 'Bone'
    """

    child: "PoseBone"
    """ Child of this pose bone

    :type: 'PoseBone'
    """

    color: "BoneColor"
    """ 

    :type: 'BoneColor'
    """

    constraints: "PoseBoneConstraints"
    """ Constraints that act on this pose channel

    :type: 'PoseBoneConstraints'
    """

    custom_shape: "Object"
    """ Object that defines custom display shape for this bone

    :type: 'Object'
    """

    custom_shape_rotation_euler: typing.Union[
        "mathutils.Euler", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Adjust the rotation of the custom shape

    :type: typing.Union['mathutils.Euler', typing.List[float], typing.Tuple[float, float, float]]
    """

    custom_shape_scale_xyz: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Adjust the size of the custom shape

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    custom_shape_transform: "PoseBone"
    """ Bone that defines the display transform of this custom shape

    :type: 'PoseBone'
    """

    custom_shape_translation: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Adjust the location of the custom shape

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    head: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of head of the channel's bone

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    ik_linear_weight: float
    """ Weight of scale constraint for IK

    :type: float
    """

    ik_max_x: float
    """ Maximum angles for IK Limit

    :type: float
    """

    ik_max_y: float
    """ Maximum angles for IK Limit

    :type: float
    """

    ik_max_z: float
    """ Maximum angles for IK Limit

    :type: float
    """

    ik_min_x: float
    """ Minimum angles for IK Limit

    :type: float
    """

    ik_min_y: float
    """ Minimum angles for IK Limit

    :type: float
    """

    ik_min_z: float
    """ Minimum angles for IK Limit

    :type: float
    """

    ik_rotation_weight: float
    """ Weight of rotation constraint for IK

    :type: float
    """

    ik_stiffness_x: float
    """ IK stiffness around the X axis

    :type: float
    """

    ik_stiffness_y: float
    """ IK stiffness around the Y axis

    :type: float
    """

    ik_stiffness_z: float
    """ IK stiffness around the Z axis

    :type: float
    """

    ik_stretch: float
    """ Allow scaling of the bone for IK

    :type: float
    """

    is_in_ik_chain: typing.Union[bool, typing.Any]
    """ Is part of an IK chain

    :type: typing.Union[bool, typing.Any]
    """

    length: float
    """ Length of the bone

    :type: float
    """

    location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    lock_ik_x: bool
    """ Disallow movement around the X axis

    :type: bool
    """

    lock_ik_y: bool
    """ Disallow movement around the Y axis

    :type: bool
    """

    lock_ik_z: bool
    """ Disallow movement around the Z axis

    :type: bool
    """

    lock_location: typing.List[bool]
    """ Lock editing of location when transforming

    :type: typing.List[bool]
    """

    lock_rotation: typing.List[bool]
    """ Lock editing of rotation when transforming

    :type: typing.List[bool]
    """

    lock_rotation_w: bool
    """ Lock editing of 'angle' component of four-component rotations when transforming

    :type: bool
    """

    lock_rotations_4d: bool
    """ Lock editing of four component rotations by components (instead of as Eulers)

    :type: bool
    """

    lock_scale: typing.List[bool]
    """ Lock editing of scale when transforming

    :type: typing.List[bool]
    """

    matrix: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Final 4×4 matrix after constraints and drivers are applied, in the armature object space

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_basis: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Alternative access to location/scale/rotation relative to the parent and own rest bone

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    matrix_channel: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ 4×4 matrix of the bone's location/rotation/scale channels (including animation and drivers) and the effect of bone constraints

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    motion_path: "MotionPath"
    """ Motion Path for this element

    :type: 'MotionPath'
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    parent: "PoseBone"
    """ Parent of this pose bone

    :type: 'PoseBone'
    """

    rotation_axis_angle: bpy_prop_array[float]
    """ Angle of Rotation for Axis-Angle rotation representation

    :type: bpy_prop_array[float]
    """

    rotation_euler: typing.Union[
        "mathutils.Euler", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Rotation in Eulers

    :type: typing.Union['mathutils.Euler', typing.List[float], typing.Tuple[float, float, float]]
    """

    rotation_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    rotation_quaternion: typing.Union[
        "mathutils.Quaternion",
        typing.List[float],
        typing.Tuple[float, float, float, float],
    ]
    """ Rotation in Quaternions

    :type: typing.Union['mathutils.Quaternion', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    tail: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of tail of the channel's bone

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    use_custom_shape_bone_size: bool
    """ Scale the custom object by the bone length

    :type: bool
    """

    use_ik_limit_x: bool
    """ Limit movement around the X axis

    :type: bool
    """

    use_ik_limit_y: bool
    """ Limit movement around the Y axis

    :type: bool
    """

    use_ik_limit_z: bool
    """ Limit movement around the Z axis

    :type: bool
    """

    use_ik_linear_control: bool
    """ Apply channel size as IK constraint if stretching is enabled

    :type: bool
    """

    use_ik_rotation_control: bool
    """ Apply channel rotation as IK constraint

    :type: bool
    """

    basename: typing.Any
    """ The name of this bone before any '.' character(readonly)"""

    center: typing.Any
    """ The midpoint between the head and the tail.(readonly)"""

    children: typing.Any
    """ (readonly)"""

    children_recursive: typing.Any
    """ A list of all children from this bone.(readonly)"""

    children_recursive_basename: typing.Any
    """ Returns a chain of children with the same base name as this bone.
Only direct chains are supported, forks caused by multiple children
with matching base names will terminate the function
and not be returned.(readonly)"""

    parent_recursive: typing.Any
    """ A list of parents, starting with the immediate parent(readonly)"""

    vector: typing.Any
    """ The direction this bone is pointing.
Utility function for (tail - head)(readonly)"""

    x_axis: typing.Any
    """ Vector pointing down the x-axis of the bone.(readonly)"""

    y_axis: typing.Any
    """ Vector pointing down the y-axis of the bone.(readonly)"""

    z_axis: typing.Any
    """ Vector pointing down the z-axis of the bone.(readonly)"""

    def evaluate_envelope(
        self,
        point: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
    ) -> float:
        """Calculate bone envelope at given point

        :param point: Point, Position in 3d space to evaluate
        :type point: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
        :rtype: float
        :return: Factor, Envelope factor
        """
        ...

    def bbone_segment_index(
        self,
        point: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
    ):
        """Retrieve the index and blend factor of the B-Bone segments based on vertex position

                :param point: Point, Vertex position in armature pose space
                :type point: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
                :return: index, The index of the first segment joint affecting the point, int in [-inf, inf]

        blend_next, The blend factor between the given and the following joint, float in [-inf, inf]
        """
        ...

    def bbone_segment_matrix(
        self,
        index: typing.Optional[int],
        rest: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]:
        """Retrieve the matrix of the joint between B-Bone segments if availableThis example shows how to use B-Bone segment matrices to emulate deformation
        produced by the Armature modifier or constraint when assigned to the given bone
        (without Preserve Volume). The coordinates are processed in armature Pose space:

                :param index: Index of the segment endpoint
                :type index: typing.Optional[int]
                :param rest: Return the rest pose matrix
                :type rest: typing.Optional[typing.Union[bool, typing.Any]]
                :rtype: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
                :return: The resulting matrix in bone local space
        """
        ...

    def compute_bbone_handles(
        self,
        rest: typing.Optional[typing.Union[bool, typing.Any]] = False,
        ease: typing.Optional[typing.Union[bool, typing.Any]] = False,
        offsets: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ):
        """Retrieve the vectors and rolls coming from B-Bone custom handles

                :param rest: Return the rest pose state
                :type rest: typing.Optional[typing.Union[bool, typing.Any]]
                :param ease: Apply scale from ease values
                :type ease: typing.Optional[typing.Union[bool, typing.Any]]
                :param offsets: Apply roll and curve offsets from bone properties
                :type offsets: typing.Optional[typing.Union[bool, typing.Any]]
                :return: handle1, The direction vector of the start handle in bone local space, `mathutils.Vector` of 3 items in [-inf, inf]

        roll1, Roll of the start handle, float in [-inf, inf]

        handle2, The direction vector of the end handle in bone local space, `mathutils.Vector` of 3 items in [-inf, inf]

        roll2, Roll of the end handle, float in [-inf, inf]
        """
        ...

    def parent_index(self, parent_test):
        """The same as 'bone in other_bone.parent_recursive'
        but saved generating a list.

                :param parent_test:
                :type parent_test:
        """
        ...

    def translate(self, vec):
        """Utility function to add vec to the head and tail of this bone

        :param vec:
        :type vec:
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Preferences(bpy_struct):
    """Global preferences"""

    active_section: typing.Union[int, str]
    """ Active section of the preferences shown in the user interface

    :type: typing.Union[int, str]
    """

    addons: "Addons"
    """ 

    :type: 'Addons'
    """

    app_template: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    apps: "PreferencesApps"
    """ Preferences that work only for apps

    :type: 'PreferencesApps'
    """

    autoexec_paths: "PathCompareCollection"
    """ 

    :type: 'PathCompareCollection'
    """

    edit: "PreferencesEdit"
    """ Settings for interacting with Blender data

    :type: 'PreferencesEdit'
    """

    experimental: "PreferencesExperimental"
    """ Settings for features that are still early in their development stage

    :type: 'PreferencesExperimental'
    """

    filepaths: "PreferencesFilePaths"
    """ Default paths for external files

    :type: 'PreferencesFilePaths'
    """

    inputs: "PreferencesInput"
    """ Settings for input devices

    :type: 'PreferencesInput'
    """

    is_dirty: bool
    """ Preferences have changed

    :type: bool
    """

    keymap: "PreferencesKeymap"
    """ Shortcut setup for keyboards and other input devices

    :type: 'PreferencesKeymap'
    """

    studio_lights: "StudioLights"
    """ 

    :type: 'StudioLights'
    """

    system: "PreferencesSystem"
    """ Graphics driver and operating system settings

    :type: 'PreferencesSystem'
    """

    themes: bpy_prop_collection["Theme"]
    """ 

    :type: bpy_prop_collection['Theme']
    """

    ui_styles: bpy_prop_collection["ThemeStyle"]
    """ 

    :type: bpy_prop_collection['ThemeStyle']
    """

    use_preferences_save: bool
    """ Save preferences on exit when modified (unless factory settings have been loaded)

    :type: bool
    """

    use_recent_searches: bool
    """ Sort the recently searched items at the top

    :type: bool
    """

    version: bpy_prop_array[int]
    """ Version of Blender the userpref.blend was saved with

    :type: bpy_prop_array[int]
    """

    view: "PreferencesView"
    """ Preferences related to viewing data

    :type: 'PreferencesView'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PreferencesApps(bpy_struct):
    """Preferences that work only for apps"""

    show_corner_split: bool
    """ Split and join editors by dragging from corners

    :type: bool
    """

    show_edge_resize: bool
    """ Resize editors by dragging from the edges

    :type: bool
    """

    show_regions_visibility_toggle: bool
    """ Header and side bars visibility toggles

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PreferencesEdit(bpy_struct):
    """Settings for interacting with Blender data"""

    auto_keying_mode: typing.Union[int, str]
    """ Mode of automatic keyframe insertion for Objects and Bones (default setting used for new Scenes)

    :type: typing.Union[int, str]
    """

    collection_instance_empty_size: float
    """ Display size of the empty when new collection instances are created

    :type: float
    """

    fcurve_new_auto_smoothing: typing.Union[int, str]
    """ Auto Handle Smoothing mode used for newly added F-Curves

    :type: typing.Union[int, str]
    """

    fcurve_unselected_alpha: float
    """ The opacity of unselected F-Curves against the background of the Graph Editor

    :type: float
    """

    grease_pencil_default_color: bpy_prop_array[float]
    """ Color of new annotation layers

    :type: bpy_prop_array[float]
    """

    grease_pencil_eraser_radius: int
    """ Radius of eraser 'brush'

    :type: int
    """

    grease_pencil_euclidean_distance: int
    """ Distance moved by mouse when drawing stroke to include

    :type: int
    """

    grease_pencil_manhattan_distance: int
    """ Pixels moved by mouse per axis when drawing stroke

    :type: int
    """

    key_insert_channels: typing.Union[typing.Set[int], typing.Set[str]]
    """ Which channels to insert keys at when no keying set is active

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    keyframe_new_handle_type: typing.Union[int, str]
    """ Handle type for handles of new keyframes

    :type: typing.Union[int, str]
    """

    keyframe_new_interpolation_type: typing.Union[int, str]
    """ Interpolation mode used for first keyframe on newly added F-Curves (subsequent keyframes take interpolation from preceding keyframe)

    :type: typing.Union[int, str]
    """

    material_link: typing.Union[int, str]
    """ Toggle whether the material is linked to object data or the object block

    :type: typing.Union[int, str]
    """

    node_margin: int
    """ Minimum distance between nodes for Auto-offsetting nodes

    :type: int
    """

    node_preview_resolution: int
    """ Resolution used for Shader node previews (should be changed for performance convenience)

    :type: int
    """

    node_use_insert_offset: bool
    """ Automatically offset the following or previous nodes in a chain when inserting a new node

    :type: bool
    """

    object_align: typing.Union[int, str]
    """ The default alignment for objects added from a 3D viewport menu

    :type: typing.Union[int, str]
    """

    sculpt_paint_overlay_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of texture overlay

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    show_only_selected_curve_keyframes: bool
    """ Only keyframes of selected F-Curves are visible and editable

    :type: bool
    """

    undo_memory_limit: int
    """ Maximum memory usage in megabytes (0 means unlimited)

    :type: int
    """

    undo_steps: int
    """ Number of undo steps available (smaller values conserve memory)

    :type: int
    """

    use_anim_channel_group_colors: bool
    """ Use animation channel group colors; generally this is used to show bone group colors

    :type: bool
    """

    use_auto_keyframe_insert_needed: bool
    """ Auto-Keying will skip inserting keys that don't affect the animation

    :type: bool
    """

    use_auto_keying: bool
    """ Automatic keyframe insertion for Objects and Bones (default setting used for new Scenes)

    :type: bool
    """

    use_auto_keying_warning: bool
    """ Show warning indicators when transforming objects and bones if auto keying is enabled

    :type: bool
    """

    use_cursor_lock_adjust: bool
    """ Place the cursor without 'jumping' to the new location (when lock-to-cursor is used)

    :type: bool
    """

    use_duplicate_action: bool
    """ Causes actions to be duplicated with the data-blocks

    :type: bool
    """

    use_duplicate_armature: bool
    """ Causes armature data to be duplicated with the object

    :type: bool
    """

    use_duplicate_camera: bool
    """ Causes camera data to be duplicated with the object

    :type: bool
    """

    use_duplicate_curve: bool
    """ Causes curve data to be duplicated with the object

    :type: bool
    """

    use_duplicate_curves: bool
    """ Causes curves data to be duplicated with the object

    :type: bool
    """

    use_duplicate_grease_pencil: bool
    """ Causes grease pencil data to be duplicated with the object

    :type: bool
    """

    use_duplicate_lattice: bool
    """ Causes lattice data to be duplicated with the object

    :type: bool
    """

    use_duplicate_light: bool
    """ Causes light data to be duplicated with the object

    :type: bool
    """

    use_duplicate_lightprobe: bool
    """ Causes light probe data to be duplicated with the object

    :type: bool
    """

    use_duplicate_material: bool
    """ Causes material data to be duplicated with the object

    :type: bool
    """

    use_duplicate_mesh: bool
    """ Causes mesh data to be duplicated with the object

    :type: bool
    """

    use_duplicate_metaball: bool
    """ Causes metaball data to be duplicated with the object

    :type: bool
    """

    use_duplicate_node_tree: bool
    """ Make copies of node groups when duplicating nodes in the node editor

    :type: bool
    """

    use_duplicate_particle: bool
    """ Causes particle systems to be duplicated with the object

    :type: bool
    """

    use_duplicate_pointcloud: bool
    """ Causes point cloud data to be duplicated with the object

    :type: bool
    """

    use_duplicate_speaker: bool
    """ Causes speaker data to be duplicated with the object

    :type: bool
    """

    use_duplicate_surface: bool
    """ Causes surface data to be duplicated with the object

    :type: bool
    """

    use_duplicate_text: bool
    """ Causes text data to be duplicated with the object

    :type: bool
    """

    use_duplicate_volume: bool
    """ Causes volume data to be duplicated with the object

    :type: bool
    """

    use_enter_edit_mode: bool
    """ Enter edit mode automatically after adding a new object

    :type: bool
    """

    use_fcurve_high_quality_drawing: bool
    """ Draw F-Curves using Anti-Aliasing (disable for better performance)

    :type: bool
    """

    use_global_undo: bool
    """ Global undo works by keeping a full copy of the file itself in memory, so takes extra memory

    :type: bool
    """

    use_insertkey_xyz_to_rgb: bool
    """ Color for newly added transformation F-Curves (Location, Rotation, Scale) and also Color is based on the transform axis

    :type: bool
    """

    use_keyframe_insert_available: bool
    """ Insert Keyframes only for properties that are already animated

    :type: bool
    """

    use_keyframe_insert_needed: bool
    """ When keying manually, skip inserting keys that don't affect the animation

    :type: bool
    """

    use_mouse_depth_cursor: bool
    """ Use the surface depth for cursor placement

    :type: bool
    """

    use_negative_frames: bool
    """ Current frame number can be manually set to a negative value

    :type: bool
    """

    use_text_edit_auto_close: bool
    """ Automatically close relevant character pairs when typing in the text editor

    :type: bool
    """

    use_visual_keying: bool
    """ Use Visual keying automatically for constrained objects

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PreferencesExperimental(bpy_struct):
    """Experimental features"""

    enable_overlay_next: bool
    """ Enable the new Overlay codebase, requires restart

    :type: bool
    """

    override_auto_resync: bool
    """ Disable library overrides automatic resync detection and process on file load (can be useful to help fixing broken files)

    :type: bool
    """

    show_asset_debug_info: bool
    """ Enable some extra fields in the Asset Browser to aid in debugging

    :type: bool
    """

    use_all_linked_data_direct: bool
    """ Forces all linked data to be considered as directly linked. Workaround for current issues/limitations in BAT (Blender studio pipeline tool)

    :type: bool
    """

    use_asset_indexing: bool
    """ Disable the asset indexer, to force every asset library refresh to completely reread assets from disk

    :type: bool
    """

    use_cycles_debug: bool
    """ Enable Cycles debugging options for developers

    :type: bool
    """

    use_eevee_debug: bool
    """ Enable EEVEE debugging options for developers

    :type: bool
    """

    use_experimental_compositors: bool
    """ Enable compositor full frame and realtime GPU execution mode options (no tiling, reduces execution time and memory usage)

    :type: bool
    """

    use_extended_asset_browser: bool
    """ Enable Asset Browser editor and operators to manage regular data-blocks as assets, not just poses

    :type: bool
    """

    use_extension_repos: bool
    """ Enables support for extensions, accessible from the "Extensions" section of the preferences

    :type: bool
    """

    use_grease_pencil_version3: bool
    """ Enable the new grease pencil 3.0 codebase

    :type: bool
    """

    use_new_curves_tools: bool
    """ Enable additional features for the new curves data block

    :type: bool
    """

    use_new_matrix_socket: bool
    """ Enable the matrix socket type for geometry nodes

    :type: bool
    """

    use_new_point_cloud_type: bool
    """ Enable the new point cloud type in the ui

    :type: bool
    """

    use_new_volume_nodes: bool
    """ Enables visibility of the new Volume nodes in the UI

    :type: bool
    """

    use_sculpt_texture_paint: bool
    """ Use texture painting in Sculpt Mode

    :type: bool
    """

    use_sculpt_tools_tilt: bool
    """ Support for pen tablet tilt events in Sculpt Mode

    :type: bool
    """

    use_shader_node_previews: bool
    """ Enables previews in the shader node editor

    :type: bool
    """

    use_undo_legacy: bool
    """ Use legacy undo (slower than the new default one, but may be more stable in some cases)

    :type: bool
    """

    use_viewport_debug: bool
    """ Enable viewport debugging options for developers in the overlays pop-over

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PreferencesFilePaths(bpy_struct):
    """Default paths for external files"""

    active_asset_library: int
    """ Index of the asset library being edited in the Preferences UI

    :type: int
    """

    active_extension_repo: int
    """ Index of the extensions repository being edited in the Preferences UI

    :type: int
    """

    animation_player: typing.Union[str, typing.Any]
    """ Path to a custom animation/frame sequence player

    :type: typing.Union[str, typing.Any]
    """

    animation_player_preset: typing.Union[int, str]
    """ Preset configs for external animation players

    :type: typing.Union[int, str]
    """

    asset_libraries: "AssetLibraryCollection"
    """ 

    :type: 'AssetLibraryCollection'
    """

    auto_save_time: int
    """ The time (in minutes) to wait between automatic temporary saves

    :type: int
    """

    extension_repos: "UserExtensionRepoCollection"
    """ 

    :type: 'UserExtensionRepoCollection'
    """

    file_preview_type: typing.Union[int, str]
    """ What type of blend preview to create

    :type: typing.Union[int, str]
    """

    font_directory: typing.Union[str, typing.Any]
    """ The default directory to search for loading fonts

    :type: typing.Union[str, typing.Any]
    """

    i18n_branches_directory: typing.Union[str, typing.Any]
    """ The path to the '/branches' directory of your local svn-translation copy, to allow translating from the UI

    :type: typing.Union[str, typing.Any]
    """

    image_editor: typing.Union[str, typing.Any]
    """ Path to an image editor

    :type: typing.Union[str, typing.Any]
    """

    recent_files: int
    """ Maximum number of recently opened files to remember

    :type: int
    """

    render_cache_directory: typing.Union[str, typing.Any]
    """ Where to cache raw render results

    :type: typing.Union[str, typing.Any]
    """

    render_output_directory: typing.Union[str, typing.Any]
    """ The default directory for rendering output, for new scenes

    :type: typing.Union[str, typing.Any]
    """

    save_version: int
    """ The number of old versions to maintain in the current directory, when manually saving

    :type: int
    """

    script_directories: "ScriptDirectoryCollection"
    """ 

    :type: 'ScriptDirectoryCollection'
    """

    show_hidden_files_datablocks: bool
    """ Show files and data-blocks that are normally hidden

    :type: bool
    """

    show_recent_locations: bool
    """ Show Recent locations list in the File Browser

    :type: bool
    """

    show_system_bookmarks: bool
    """ Show System locations list in the File Browser

    :type: bool
    """

    sound_directory: typing.Union[str, typing.Any]
    """ The default directory to search for sounds

    :type: typing.Union[str, typing.Any]
    """

    temporary_directory: typing.Union[str, typing.Any]
    """ The directory for storing temporary save files

    :type: typing.Union[str, typing.Any]
    """

    text_editor: typing.Union[str, typing.Any]
    """ Command to launch the text editor, either a full path or a command in $PATH.
Use the internal editor when left blank

    :type: typing.Union[str, typing.Any]
    """

    text_editor_args: typing.Union[str, typing.Any]
    """ Defines the specific format of the arguments with which the text editor opens files. The supported expansions are as follows:$filepath The absolute path of the file.
$line The line to open at (Optional).
$column The column to open from the beginning of the line (Optional).
$line0 & column0 start at zero.
Example: -f $filepath -l $line -c $column

    :type: typing.Union[str, typing.Any]
    """

    texture_directory: typing.Union[str, typing.Any]
    """ The default directory to search for textures

    :type: typing.Union[str, typing.Any]
    """

    use_auto_save_temporary_files: bool
    """ Automatic saving of temporary files in temp directory, uses process ID.
Warning: Sculpt and edit mode data won't be saved

    :type: bool
    """

    use_file_compression: bool
    """ Enable file compression when saving .blend files

    :type: bool
    """

    use_filter_files: bool
    """ Enable filtering of files in the File Browser

    :type: bool
    """

    use_load_ui: bool
    """ Load user interface setup when loading .blend files

    :type: bool
    """

    use_relative_paths: bool
    """ Default relative path option for the file selector, when no path is defined yet

    :type: bool
    """

    use_scripts_auto_execute: bool
    """ Allow any .blend file to run scripts automatically (unsafe with blend files from an untrusted source)

    :type: bool
    """

    use_tabs_as_spaces: bool
    """ Automatically convert all new tabs into spaces for new and loaded text files

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PreferencesInput(bpy_struct):
    """Settings for input devices"""

    drag_threshold: int
    """ Number of pixels to drag before a drag event is triggered for keyboard and other non mouse/tablet input (otherwise click events are detected)

    :type: int
    """

    drag_threshold_mouse: int
    """ Number of pixels to drag before a drag event is triggered for mouse/trackpad input (otherwise click events are detected)

    :type: int
    """

    drag_threshold_tablet: int
    """ Number of pixels to drag before a drag event is triggered for tablet input (otherwise click events are detected)

    :type: int
    """

    invert_mouse_zoom: bool
    """ Invert the axis of mouse movement for zooming

    :type: bool
    """

    invert_zoom_wheel: bool
    """ Swap the Mouse Wheel zoom direction

    :type: bool
    """

    mouse_double_click_time: int
    """ Time/delay (in ms) for a double click

    :type: int
    """

    mouse_emulate_3_button_modifier: typing.Union[int, str]
    """ Hold this modifier to emulate the middle mouse button

    :type: typing.Union[int, str]
    """

    move_threshold: int
    """ Number of pixels to before the cursor is considered to have moved (used for cycling selected items on successive clicks)

    :type: int
    """

    navigation_mode: typing.Union[int, str]
    """ Which method to use for viewport navigation

    :type: typing.Union[int, str]
    """

    ndof_deadzone: float
    """ Threshold of initial movement needed from the device's rest position

    :type: float
    """

    ndof_fly_helicopter: bool
    """ Device up/down directly controls the Z position of the 3D viewport

    :type: bool
    """

    ndof_lock_camera_pan_zoom: bool
    """ Pan/zoom the camera view instead of leaving the camera view when orbiting

    :type: bool
    """

    ndof_lock_horizon: bool
    """ Keep horizon level while flying with 3D Mouse

    :type: bool
    """

    ndof_orbit_sensitivity: float
    """ Overall sensitivity of the 3D Mouse for orbiting

    :type: float
    """

    ndof_pan_yz_swap_axis: bool
    """ Pan using up/down on the device (otherwise forward/backward)

    :type: bool
    """

    ndof_panx_invert_axis: bool
    """ 

    :type: bool
    """

    ndof_pany_invert_axis: bool
    """ 

    :type: bool
    """

    ndof_panz_invert_axis: bool
    """ 

    :type: bool
    """

    ndof_rotx_invert_axis: bool
    """ 

    :type: bool
    """

    ndof_roty_invert_axis: bool
    """ 

    :type: bool
    """

    ndof_rotz_invert_axis: bool
    """ 

    :type: bool
    """

    ndof_sensitivity: float
    """ Overall sensitivity of the 3D Mouse for panning

    :type: float
    """

    ndof_show_guide: bool
    """ Display the center and axis during rotation

    :type: bool
    """

    ndof_view_navigate_method: typing.Union[int, str]
    """ Navigation style in the viewport

    :type: typing.Union[int, str]
    """

    ndof_view_rotate_method: typing.Union[int, str]
    """ Rotation style in the viewport

    :type: typing.Union[int, str]
    """

    ndof_zoom_invert: bool
    """ Zoom using opposite direction

    :type: bool
    """

    pressure_softness: float
    """ Adjusts softness of the low pressure response onset using a gamma curve

    :type: float
    """

    pressure_threshold_max: float
    """ Raw input pressure value that is interpreted as 100% by Blender

    :type: float
    """

    tablet_api: typing.Union[int, str]
    """ Select the tablet API to use for pressure sensitivity (may require restarting Blender for changes to take effect)

    :type: typing.Union[int, str]
    """

    use_auto_perspective: bool
    """ Automatically switch between orthographic and perspective when changing from top/front/side views

    :type: bool
    """

    use_drag_immediately: bool
    """ Moving things with a mouse drag confirms when releasing the button

    :type: bool
    """

    use_emulate_numpad: bool
    """ Main 1 to 0 keys act as the numpad ones (useful for laptops)

    :type: bool
    """

    use_mouse_continuous: bool
    """ Let the mouse wrap around the view boundaries so mouse movements are not limited by the screen size (used by transform, dragging of UI controls, etc.)

    :type: bool
    """

    use_mouse_depth_navigate: bool
    """ Use the depth under the mouse to improve view pan/rotate/zoom functionality

    :type: bool
    """

    use_mouse_emulate_3_button: bool
    """ Emulate Middle Mouse with Alt+Left Mouse

    :type: bool
    """

    use_multitouch_gestures: bool
    """ Use multi-touch gestures for navigation with touchpad, instead of scroll wheel emulation

    :type: bool
    """

    use_ndof: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    use_numeric_input_advanced: bool
    """ When entering numbers while transforming, default to advanced mode for full math expression evaluation

    :type: bool
    """

    use_rotate_around_active: bool
    """ Use selection as the pivot point

    :type: bool
    """

    use_zoom_to_mouse: bool
    """ Zoom in towards the mouse pointer's position in the 3D view, rather than the 2D window center

    :type: bool
    """

    view_rotate_method: typing.Union[int, str]
    """ Orbit method in the viewport

    :type: typing.Union[int, str]
    """

    view_rotate_sensitivity_trackball: float
    """ Scale trackball orbit sensitivity

    :type: float
    """

    view_rotate_sensitivity_turntable: float
    """ Rotation amount per pixel to control how fast the viewport orbits

    :type: float
    """

    view_zoom_axis: typing.Union[int, str]
    """ Axis of mouse movement to zoom in or out on

    :type: typing.Union[int, str]
    """

    view_zoom_method: typing.Union[int, str]
    """ Which style to use for viewport scaling

    :type: typing.Union[int, str]
    """

    walk_navigation: "WalkNavigation"
    """ Settings for walk navigation mode

    :type: 'WalkNavigation'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PreferencesKeymap(bpy_struct):
    """Shortcut setup for keyboards and other input devices"""

    active_keyconfig: typing.Union[str, typing.Any]
    """ The name of the active key configuration

    :type: typing.Union[str, typing.Any]
    """

    show_ui_keyconfig: bool
    """ 

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PreferencesSystem(bpy_struct):
    """Graphics driver and operating system settings"""

    anisotropic_filter: typing.Union[int, str]
    """ Quality of anisotropic filtering

    :type: typing.Union[int, str]
    """

    audio_channels: typing.Union[int, str]
    """ Audio channel count

    :type: typing.Union[int, str]
    """

    audio_device: typing.Union[int, str]
    """ Audio output device

    :type: typing.Union[int, str]
    """

    audio_mixing_buffer: typing.Union[int, str]
    """ Number of samples used by the audio mixing buffer

    :type: typing.Union[int, str]
    """

    audio_sample_format: typing.Union[int, str]
    """ Audio sample format

    :type: typing.Union[int, str]
    """

    audio_sample_rate: typing.Union[int, str]
    """ Audio sample rate

    :type: typing.Union[int, str]
    """

    dpi: int
    """ 

    :type: int
    """

    gl_clip_alpha: float
    """ Clip alpha below this threshold in the 3D textured view

    :type: float
    """

    gl_texture_limit: typing.Union[int, str]
    """ Limit the texture size to save graphics memory

    :type: typing.Union[int, str]
    """

    gpu_backend: typing.Union[int, str]
    """ GPU backend to use (requires restarting Blender for changes to take effect)

    :type: typing.Union[int, str]
    """

    image_draw_method: typing.Union[int, str]
    """ Method used for displaying images on the screen

    :type: typing.Union[int, str]
    """

    is_microsoft_store_install: typing.Union[bool, typing.Any]
    """ Whether this blender installation is a sandboxed Microsoft Store version

    :type: typing.Union[bool, typing.Any]
    """

    legacy_compute_device_type: int
    """ For backwards compatibility only

    :type: int
    """

    light_ambient: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of the ambient light that uniformly lit the scene

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    memory_cache_limit: int
    """ Memory cache limit (in megabytes)

    :type: int
    """

    pixel_size: float
    """ 

    :type: float
    """

    register_all_users: bool
    """ Make this Blender version open blend files for all users. Requires elevated privileges

    :type: bool
    """

    scrollback: int
    """ Maximum number of lines to store for the console buffer

    :type: int
    """

    sequencer_disk_cache_compression: typing.Union[int, str]
    """ Smaller compression will result in larger files, but less decoding overhead

    :type: typing.Union[int, str]
    """

    sequencer_disk_cache_dir: typing.Union[str, typing.Any]
    """ Override default directory

    :type: typing.Union[str, typing.Any]
    """

    sequencer_disk_cache_size_limit: int
    """ Disk cache limit (in gigabytes)

    :type: int
    """

    sequencer_proxy_setup: typing.Union[int, str]
    """ When and how proxies are created

    :type: typing.Union[int, str]
    """

    solid_lights: bpy_prop_collection["UserSolidLight"]
    """ Lights used to display objects in solid shading mode

    :type: bpy_prop_collection['UserSolidLight']
    """

    texture_collection_rate: int
    """ Number of seconds between each run of the GL texture garbage collector

    :type: int
    """

    texture_time_out: int
    """ Time since last access of a GL texture in seconds after which it is freed (set to 0 to keep textures allocated)

    :type: int
    """

    ui_line_width: float
    """ Suggested line thickness and point size in pixels, for add-ons displaying custom user interface elements, based on operating system settings and Blender UI scale

    :type: float
    """

    ui_scale: float
    """ Size multiplier to use when displaying custom user interface elements, so that they are scaled correctly on screens with different DPI. This value is based on operating system DPI settings and Blender display scale

    :type: float
    """

    use_edit_mode_smooth_wire: bool
    """ Enable edit mode edge smoothing, reducing aliasing (requires restart)

    :type: bool
    """

    use_gpu_subdivision: bool
    """ Enable GPU acceleration for evaluating the last subdivision surface modifiers in the stack

    :type: bool
    """

    use_overlay_smooth_wire: bool
    """ Enable overlay smooth wires, reducing aliasing

    :type: bool
    """

    use_region_overlap: bool
    """ Display tool/property regions over the main region

    :type: bool
    """

    use_select_pick_depth: bool
    """ When making a selection in 3D View, use the GPU depth buffer to ensure the frontmost object is selected first

    :type: bool
    """

    use_sequencer_disk_cache: bool
    """ Store cached images to disk

    :type: bool
    """

    use_studio_light_edit: bool
    """ View the result of the studio light editor in the viewport

    :type: bool
    """

    vbo_collection_rate: int
    """ Number of seconds between each run of the GL vertex buffer object garbage collector

    :type: int
    """

    vbo_time_out: int
    """ Time since last access of a GL vertex buffer object in seconds after which it is freed (set to 0 to keep VBO allocated)

    :type: int
    """

    viewport_aa: typing.Union[int, str]
    """ Method of anti-aliasing in 3d viewport

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PreferencesView(bpy_struct):
    """Preferences related to viewing data"""

    color_picker_type: typing.Union[int, str]
    """ Different styles of displaying the color picker widget

    :type: typing.Union[int, str]
    """

    factor_display_type: typing.Union[int, str]
    """ How factor values are displayed

    :type: typing.Union[int, str]
    """

    filebrowser_display_type: typing.Union[int, str]
    """ Default location where the File Editor will be displayed in

    :type: typing.Union[int, str]
    """

    font_path_ui: typing.Union[str, typing.Any]
    """ Path to interface font

    :type: typing.Union[str, typing.Any]
    """

    font_path_ui_mono: typing.Union[str, typing.Any]
    """ Path to interface monospaced Font

    :type: typing.Union[str, typing.Any]
    """

    gizmo_size: int
    """ Diameter of the gizmo

    :type: int
    """

    gizmo_size_navigate_v3d: int
    """ The Navigate Gizmo size

    :type: int
    """

    header_align: typing.Union[int, str]
    """ Default header position for new space-types

    :type: typing.Union[int, str]
    """

    language: typing.Union[int, str]
    """ Language used for translation

    :type: typing.Union[int, str]
    """

    lookdev_sphere_size: int
    """ Diameter of the HDRI preview spheres

    :type: int
    """

    mini_axis_brightness: int
    """ Brightness of the icon

    :type: int
    """

    mini_axis_size: int
    """ The axes icon's size

    :type: int
    """

    mini_axis_type: typing.Union[int, str]
    """ Show small rotating 3D axes in the top right corner of the 3D viewport

    :type: typing.Union[int, str]
    """

    open_sublevel_delay: int
    """ Time delay in 1/10 seconds before automatically opening sub level menus

    :type: int
    """

    open_toplevel_delay: int
    """ Time delay in 1/10 seconds before automatically opening top level menus

    :type: int
    """

    pie_animation_timeout: int
    """ Time needed to fully animate the pie to unfolded state (in 1/100ths of sec)

    :type: int
    """

    pie_initial_timeout: int
    """ Pie menus will use the initial mouse position as center for this amount of time (in 1/100ths of sec)

    :type: int
    """

    pie_menu_confirm: int
    """ Distance threshold after which selection is made (zero to disable)

    :type: int
    """

    pie_menu_radius: int
    """ Pie menu size in pixels

    :type: int
    """

    pie_menu_threshold: int
    """ Distance from center needed before a selection can be made

    :type: int
    """

    pie_tap_timeout: int
    """ Pie menu button held longer than this will dismiss menu on release (in 1/100ths of sec)

    :type: int
    """

    playback_fps_samples: int
    """ The number of frames to use for calculating FPS average. Zero to calculate this automatically, where the number of samples matches the target FPS

    :type: int
    """

    render_display_type: typing.Union[int, str]
    """ Default location where rendered images will be displayed in

    :type: typing.Union[int, str]
    """

    rotation_angle: float
    """ Rotation step for numerical pad keys (2 4 6 8)

    :type: float
    """

    show_addons_enabled_only: bool
    """ Only show enabled add-ons. Un-check to see all installed add-ons

    :type: bool
    """

    show_column_layout: bool
    """ Use a column layout for toolbox

    :type: bool
    """

    show_developer_ui: bool
    """ Show options for developers (edit source in context menu, geometry indices)

    :type: bool
    """

    show_gizmo: bool
    """ Use transform gizmos by default

    :type: bool
    """

    show_navigate_ui: bool
    """ Show navigation controls in 2D and 3D views which do not have scroll bars

    :type: bool
    """

    show_object_info: bool
    """ Include the name of the active object and the current frame number in the text info overlay

    :type: bool
    """

    show_playback_fps: bool
    """ Include the number of frames displayed per second in the text info overlay while animation is played back

    :type: bool
    """

    show_splash: bool
    """ Display splash screen on startup

    :type: bool
    """

    show_statusbar_memory: bool
    """ Show Blender memory usage

    :type: bool
    """

    show_statusbar_scene_duration: bool
    """ Show scene duration

    :type: bool
    """

    show_statusbar_stats: bool
    """ Show scene statistics

    :type: bool
    """

    show_statusbar_version: bool
    """ Show Blender version string

    :type: bool
    """

    show_statusbar_vram: bool
    """ Show GPU video memory usage

    :type: bool
    """

    show_tooltips: bool
    """ Display tooltips (when disabled, hold Alt to force display)

    :type: bool
    """

    show_tooltips_python: bool
    """ Show Python references in tooltips

    :type: bool
    """

    show_view_name: bool
    """ Include the name of the view orientation in the text info overlay

    :type: bool
    """

    smooth_view: int
    """ Time to animate the view in milliseconds, zero to disable

    :type: int
    """

    text_hinting: typing.Union[int, str]
    """ Method for making user interface text render sharp

    :type: typing.Union[int, str]
    """

    timecode_style: typing.Union[int, str]
    """ Format of timecode displayed when not displaying timing in terms of frames

    :type: typing.Union[int, str]
    """

    ui_line_width: typing.Union[int, str]
    """ Changes the thickness of widget outlines, lines and dots in the interface

    :type: typing.Union[int, str]
    """

    ui_scale: float
    """ Changes the size of the fonts and widgets in the interface

    :type: float
    """

    use_fresnel_edit: bool
    """ Enable a fresnel effect on edit mesh overlays.
It improves shape readability of very dense meshes, but increases eye fatigue when modeling lower poly

    :type: bool
    """

    use_mouse_over_open: bool
    """ Open menu buttons and pulldowns automatically when the mouse is hovering

    :type: bool
    """

    use_save_prompt: bool
    """ Ask for confirmation when quitting with unsaved changes

    :type: bool
    """

    use_text_antialiasing: bool
    """ Smooth jagged edges of user interface text

    :type: bool
    """

    use_text_render_subpixelaa: bool
    """ Render text for optimal horizontal placement

    :type: bool
    """

    use_translate_interface: bool
    """ Translate all labels in menus, buttons and panels (note that this might make it hard to follow tutorials or the manual)

    :type: bool
    """

    use_translate_new_dataname: bool
    """ Translate the names of new data-blocks (objects, materials...)

    :type: bool
    """

    use_translate_reports: bool
    """ Translate additional information, such as error messages

    :type: bool
    """

    use_translate_tooltips: bool
    """ Translate the descriptions when hovering UI elements (recommended)

    :type: bool
    """

    use_weight_color_range: bool
    """ Enable color range used for weight visualization in weight painting mode

    :type: bool
    """

    view2d_grid_spacing_min: int
    """ Minimum number of pixels between each gridline in 2D Viewports

    :type: int
    """

    view_frame_keyframes: int
    """ Keyframes around cursor that we zoom around

    :type: int
    """

    view_frame_seconds: float
    """ Seconds around cursor that we zoom around

    :type: float
    """

    view_frame_type: typing.Union[int, str]
    """ How zooming to frame focuses around current frame

    :type: typing.Union[int, str]
    """

    weight_color_range: "ColorRamp"
    """ Color range used for weight visualization in weight painting mode

    :type: 'ColorRamp'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PrimitiveBoolean(bpy_struct):
    """RNA wrapped boolean"""

    value: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PrimitiveFloat(bpy_struct):
    """RNA wrapped float"""

    value: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PrimitiveInt(bpy_struct):
    """RNA wrapped int"""

    value: int
    """ 

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PrimitiveString(bpy_struct):
    """RNA wrapped string"""

    value: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Property(bpy_struct):
    """RNA property definition"""

    description: typing.Union[str, typing.Any]
    """ Description of the property for tooltips

    :type: typing.Union[str, typing.Any]
    """

    icon: typing.Any
    """ Icon of the item

    :type: typing.Any
    """

    identifier: typing.Union[str, typing.Any]
    """ Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    """

    is_animatable: typing.Union[bool, typing.Any]
    """ Property is animatable through RNA

    :type: typing.Union[bool, typing.Any]
    """

    is_argument_optional: typing.Union[bool, typing.Any]
    """ True when the property is optional in a Python function implementing an RNA function

    :type: typing.Union[bool, typing.Any]
    """

    is_enum_flag: typing.Union[bool, typing.Any]
    """ True when multiple enums

    :type: typing.Union[bool, typing.Any]
    """

    is_hidden: typing.Union[bool, typing.Any]
    """ True when the property is hidden

    :type: typing.Union[bool, typing.Any]
    """

    is_library_editable: typing.Union[bool, typing.Any]
    """ Property is editable from linked instances (changes not saved)

    :type: typing.Union[bool, typing.Any]
    """

    is_never_none: typing.Union[bool, typing.Any]
    """ True when this value can't be set to None

    :type: typing.Union[bool, typing.Any]
    """

    is_output: typing.Union[bool, typing.Any]
    """ True when this property is an output value from an RNA function

    :type: typing.Union[bool, typing.Any]
    """

    is_overridable: typing.Union[bool, typing.Any]
    """ Property is overridable through RNA

    :type: typing.Union[bool, typing.Any]
    """

    is_path_output: typing.Union[bool, typing.Any]
    """ Property is a filename, filepath or directory output

    :type: typing.Union[bool, typing.Any]
    """

    is_readonly: typing.Union[bool, typing.Any]
    """ Property is editable through RNA

    :type: typing.Union[bool, typing.Any]
    """

    is_registered: typing.Union[bool, typing.Any]
    """ Property is registered as part of type registration

    :type: typing.Union[bool, typing.Any]
    """

    is_registered_optional: typing.Union[bool, typing.Any]
    """ Property is optionally registered as part of type registration

    :type: typing.Union[bool, typing.Any]
    """

    is_required: typing.Union[bool, typing.Any]
    """ False when this property is an optional argument in an RNA function

    :type: typing.Union[bool, typing.Any]
    """

    is_runtime: typing.Union[bool, typing.Any]
    """ Property has been dynamically created at runtime

    :type: typing.Union[bool, typing.Any]
    """

    is_skip_preset: typing.Union[bool, typing.Any]
    """ True when the property is not saved in presets

    :type: typing.Union[bool, typing.Any]
    """

    is_skip_save: typing.Union[bool, typing.Any]
    """ True when the property uses ghost values

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Human readable name

    :type: typing.Union[str, typing.Any]
    """

    srna: "Struct"
    """ Struct definition used for properties assigned to this item

    :type: 'Struct'
    """

    subtype: typing.Any
    """ Semantic interpretation of the property

    :type: typing.Any
    """

    tags: typing.Union[typing.Any, typing.Set[int], typing.Set[str]]
    """ Subset of tags (defined in parent struct) that are set for this property

    :type: typing.Union[typing.Any, typing.Set[int], typing.Set[str]]
    """

    translation_context: typing.Union[str, typing.Any]
    """ Translation context of the property's name

    :type: typing.Union[str, typing.Any]
    """

    type: typing.Any
    """ Data type of the property

    :type: typing.Any
    """

    unit: typing.Any
    """ Type of units for this property

    :type: typing.Any
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PropertyGroup(bpy_struct):
    """Group of ID properties"""

    name: typing.Union[str, typing.Any]
    """ Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class PropertyGroupItem(bpy_struct):
    """Property that stores arbitrary, user defined properties"""

    bool: bool
    """ 

    :type: bool
    """

    bool_array: typing.List[bool]
    """ 

    :type: typing.List[bool]
    """

    collection: bpy_prop_collection["PropertyGroup"]
    """ 

    :type: bpy_prop_collection['PropertyGroup']
    """

    double: float
    """ 

    :type: float
    """

    double_array: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    enum: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    float: float
    """ 

    :type: float
    """

    float_array: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    group: "PropertyGroup"
    """ 

    :type: 'PropertyGroup'
    """

    id: "ID"
    """ 

    :type: 'ID'
    """

    idp_array: bpy_prop_collection["PropertyGroup"]
    """ 

    :type: bpy_prop_collection['PropertyGroup']
    """

    int: int
    """ 

    :type: int
    """

    int_array: bpy_prop_array[int]
    """ 

    :type: bpy_prop_array[int]
    """

    string: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class QuaternionAttributeValue(bpy_struct):
    """Rotation value in geometry attribute"""

    value: bpy_prop_array[float]
    """ Quaternion

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RaytraceEEVEE(bpy_struct):
    denoise_bilateral: bool
    """ Blur the resolved radiance using a bilateral filter

    :type: bool
    """

    denoise_spatial: bool
    """ Reuse neighbor pixels' rays

    :type: bool
    """

    denoise_temporal: bool
    """ Accumulate samples by reprojecting last tracing results

    :type: bool
    """

    resolution_scale: typing.Union[int, str]
    """ Number of rays per pixel

    :type: typing.Union[int, str]
    """

    sample_clamp: float
    """ Clamp ray intensity to reduce noise (0 to disable)

    :type: float
    """

    screen_trace_max_roughness: float
    """ Maximum roughness to use the tracing pipeline for. Higher roughness surfaces will use horizon scan. A value of 1 will disable horizon scan

    :type: float
    """

    screen_trace_quality: float
    """ Precision of the screen space ray-tracing

    :type: float
    """

    screen_trace_thickness: float
    """ Surface thickness used to detect intersection when using screen-tracing

    :type: float
    """

    use_denoise: bool
    """ Enable noise reduction techniques for raytraced effects

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ReadOnlyInteger(bpy_struct):
    value: int
    """ 

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Region(bpy_struct):
    """Region in a subdivided screen area"""

    active_panel_category: typing.Union[int, str]
    """ The current active panel category, may be Null if the region does not support this feature (NOTE: these categories are generated at runtime, so list may be empty at initialization, before any drawing took place)

    :type: typing.Union[int, str]
    """

    alignment: typing.Union[int, str]
    """ Alignment of the region within the area

    :type: typing.Union[int, str]
    """

    data: typing.Any
    """ Region specific data (the type depends on the region type)

    :type: typing.Any
    """

    height: int
    """ Region height

    :type: int
    """

    type: typing.Any
    """ Type of this region

    :type: typing.Any
    """

    view2d: "View2D"
    """ 2D view of the region

    :type: 'View2D'
    """

    width: int
    """ Region width

    :type: int
    """

    x: int
    """ The window relative vertical location of the region

    :type: int
    """

    y: int
    """ The window relative horizontal location of the region

    :type: int
    """

    def tag_redraw(self):
        """tag_redraw"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RegionView3D(bpy_struct):
    """3D View region data"""

    clip_planes: typing.Union[
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float, float, float],
            typing.Tuple[float, float, float, float, float, float],
            typing.Tuple[float, float, float, float, float, float],
            typing.Tuple[float, float, float, float, float, float],
        ],
    ]
    """ 

    :type: typing.Union[typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float, float, float], typing.Tuple[float, float, float, float, float, float], typing.Tuple[float, float, float, float, float, float], typing.Tuple[float, float, float, float, float, float]]]
    """

    is_orthographic_side_view: bool
    """ Whether the current view is aligned to an axis (does not check whether the view is orthographic, use "is_perspective" for that). Setting this will rotate the view to the closest axis

    :type: bool
    """

    is_perspective: bool
    """ 

    :type: bool
    """

    lock_rotation: bool
    """ Lock view rotation of side views to Top/Front/Right

    :type: bool
    """

    perspective_matrix: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Current perspective matrix (window_matrix * view_matrix)

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    show_sync_view: bool
    """ Sync view position between side views

    :type: bool
    """

    use_box_clip: bool
    """ Clip view contents based on what is visible in other side views

    :type: bool
    """

    use_clip_planes: bool
    """ 

    :type: bool
    """

    view_camera_offset: bpy_prop_array[float]
    """ View shift in camera view

    :type: bpy_prop_array[float]
    """

    view_camera_zoom: float
    """ Zoom factor in camera view

    :type: float
    """

    view_distance: float
    """ Distance to the view location

    :type: float
    """

    view_location: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ View pivot location

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    view_matrix: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Current view matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    view_perspective: typing.Union[int, str]
    """ View Perspective

    :type: typing.Union[int, str]
    """

    view_rotation: typing.Union[
        "mathutils.Quaternion",
        typing.List[float],
        typing.Tuple[float, float, float, float],
    ]
    """ Rotation in quaternions (keep normalized)

    :type: typing.Union['mathutils.Quaternion', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    window_matrix: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]
    """ Current window matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
    """

    def update(self):
        """Recalculate the view matrices"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RenderEngine(bpy_struct):
    """Render engine"""

    bl_idname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_label: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    bl_use_alembic_procedural: bool
    """ Support loading Alembic data at render time

    :type: bool
    """

    bl_use_custom_freestyle: bool
    """ Handles freestyle rendering on its own, instead of delegating it to EEVEE

    :type: bool
    """

    bl_use_eevee_viewport: bool
    """ Uses EEVEE for viewport shading in Material Preview shading mode

    :type: bool
    """

    bl_use_gpu_context: bool
    """ Enable OpenGL context for the render method, for engines that render using OpenGL

    :type: bool
    """

    bl_use_image_save: bool
    """ Save images/movie to disk while rendering an animation. Disabling image saving is only supported when bl_use_postprocess is also disabled

    :type: bool
    """

    bl_use_materialx: bool
    """ Use MaterialX for exporting materials to Hydra

    :type: bool
    """

    bl_use_postprocess: bool
    """ Apply compositing on render results

    :type: bool
    """

    bl_use_preview: bool
    """ Render engine supports being used for rendering previews of materials, lights and worlds

    :type: bool
    """

    bl_use_shading_nodes_custom: bool
    """ Don't expose Cycles and EEVEE shading nodes in the node editor user interface, so own nodes can be used instead

    :type: bool
    """

    bl_use_spherical_stereo: bool
    """ Support spherical stereo camera models

    :type: bool
    """

    bl_use_stereo_viewport: bool
    """ Support rendering stereo 3D viewport

    :type: bool
    """

    camera_override: "Object"
    """ 

    :type: 'Object'
    """

    is_animation: bool
    """ 

    :type: bool
    """

    is_preview: bool
    """ 

    :type: bool
    """

    layer_override: typing.List[bool]
    """ 

    :type: typing.List[bool]
    """

    render: "RenderSettings"
    """ 

    :type: 'RenderSettings'
    """

    resolution_x: int
    """ 

    :type: int
    """

    resolution_y: int
    """ 

    :type: int
    """

    temporary_directory: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    use_highlight_tiles: bool
    """ 

    :type: bool
    """

    def update(
        self,
        data: typing.Optional["BlendData"] = None,
        depsgraph: typing.Optional["Depsgraph"] = None,
    ):
        """Export scene data for render

        :param data:
        :type data: typing.Optional['BlendData']
        :param depsgraph:
        :type depsgraph: typing.Optional['Depsgraph']
        """
        ...

    def render(self, depsgraph: typing.Optional["Depsgraph"]):
        """Render scene into an image

        :param depsgraph:
        :type depsgraph: typing.Optional['Depsgraph']
        """
        ...

    def render_frame_finish(self):
        """Perform finishing operations after all view layers in a frame were rendered"""
        ...

    def draw(
        self,
        context: typing.Optional["Context"],
        depsgraph: typing.Optional["Depsgraph"],
    ):
        """Draw render image

        :param context:
        :type context: typing.Optional['Context']
        :param depsgraph:
        :type depsgraph: typing.Optional['Depsgraph']
        """
        ...

    def bake(
        self,
        depsgraph: typing.Optional["Depsgraph"],
        object: typing.Optional["Object"],
        pass_type: typing.Optional[typing.Union[int, str]],
        pass_filter: typing.Optional[int],
        width: typing.Optional[int],
        height: typing.Optional[int],
    ):
        """Bake passes

        :param depsgraph:
        :type depsgraph: typing.Optional['Depsgraph']
        :param object:
        :type object: typing.Optional['Object']
        :param pass_type: Pass, Pass to bake
        :type pass_type: typing.Optional[typing.Union[int, str]]
        :param pass_filter: Pass Filter, Filter to combined, diffuse, glossy and transmission passes
        :type pass_filter: typing.Optional[int]
        :param width: Width, Image width
        :type width: typing.Optional[int]
        :param height: Height, Image height
        :type height: typing.Optional[int]
        """
        ...

    def view_update(
        self,
        context: typing.Optional["Context"],
        depsgraph: typing.Optional["Depsgraph"],
    ):
        """Update on data changes for viewport render

        :param context:
        :type context: typing.Optional['Context']
        :param depsgraph:
        :type depsgraph: typing.Optional['Depsgraph']
        """
        ...

    def view_draw(
        self,
        context: typing.Optional["Context"],
        depsgraph: typing.Optional["Depsgraph"],
    ):
        """Draw viewport render

        :param context:
        :type context: typing.Optional['Context']
        :param depsgraph:
        :type depsgraph: typing.Optional['Depsgraph']
        """
        ...

    def update_script_node(self, node: typing.Optional["Node"] = None):
        """Compile shader script node

        :param node:
        :type node: typing.Optional['Node']
        """
        ...

    def update_render_passes(
        self,
        scene: typing.Optional["Scene"] = None,
        renderlayer: typing.Optional["ViewLayer"] = None,
    ):
        """Update the render passes that will be generated

        :param scene:
        :type scene: typing.Optional['Scene']
        :param renderlayer:
        :type renderlayer: typing.Optional['ViewLayer']
        """
        ...

    def tag_redraw(self):
        """Request redraw for viewport rendering"""
        ...

    def tag_update(self):
        """Request update call for viewport rendering"""
        ...

    def begin_result(
        self,
        x: typing.Optional[int],
        y: typing.Optional[int],
        w: typing.Optional[int],
        h: typing.Optional[int],
        layer: typing.Union[str, typing.Any] = "",
        view: typing.Union[str, typing.Any] = "",
    ) -> "RenderResult":
        """Create render result to write linear floating-point render layers and passes

        :param x: X
        :type x: typing.Optional[int]
        :param y: Y
        :type y: typing.Optional[int]
        :param w: Width
        :type w: typing.Optional[int]
        :param h: Height
        :type h: typing.Optional[int]
        :param layer: Layer, Single layer to get render result for
        :type layer: typing.Union[str, typing.Any]
        :param view: View, Single view to get render result for
        :type view: typing.Union[str, typing.Any]
        :rtype: 'RenderResult'
        :return: Result
        """
        ...

    def update_result(self, result: typing.Optional["RenderResult"]):
        """Signal that pixels have been updated and can be redrawn in the user interface

        :param result: Result
        :type result: typing.Optional['RenderResult']
        """
        ...

    def end_result(
        self,
        result: typing.Optional["RenderResult"],
        cancel: typing.Optional[typing.Union[bool, typing.Any]] = False,
        highlight: typing.Optional[typing.Union[bool, typing.Any]] = False,
        do_merge_results: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ):
        """All pixels in the render result have been set and are final

        :param result: Result
        :type result: typing.Optional['RenderResult']
        :param cancel: Cancel, Don't mark tile as done, don't merge results unless forced
        :type cancel: typing.Optional[typing.Union[bool, typing.Any]]
        :param highlight: Highlight, Don't mark tile as done yet
        :type highlight: typing.Optional[typing.Union[bool, typing.Any]]
        :param do_merge_results: Merge Results, Merge results even if cancel=true
        :type do_merge_results: typing.Optional[typing.Union[bool, typing.Any]]
        """
        ...

    def add_pass(
        self,
        name: typing.Union[str, typing.Any],
        channels: typing.Optional[int],
        chan_id: typing.Union[str, typing.Any],
        layer: typing.Union[str, typing.Any] = "",
    ):
        """Add a pass to the render layer

        :param name: Name, Name of the Pass, without view or channel tag
        :type name: typing.Union[str, typing.Any]
        :param channels: Channels
        :type channels: typing.Optional[int]
        :param chan_id: Channel IDs, Channel names, one character per channel
        :type chan_id: typing.Union[str, typing.Any]
        :param layer: Layer, Single layer to add render pass to
        :type layer: typing.Union[str, typing.Any]
        """
        ...

    def get_result(self) -> "RenderResult":
        """Get final result for non-pixel operations

        :rtype: 'RenderResult'
        :return: Result
        """
        ...

    def test_break(self) -> bool:
        """Test if the render operation should been canceled, this is a fast call that should be used regularly for responsiveness

        :rtype: bool
        :return: Break
        """
        ...

    def pass_by_index_get(
        self, layer: typing.Union[str, typing.Any], index: typing.Optional[int]
    ) -> "RenderPass":
        """pass_by_index_get

        :param layer: Layer, Name of render layer to get pass for
        :type layer: typing.Union[str, typing.Any]
        :param index: Index, Index of pass to get
        :type index: typing.Optional[int]
        :rtype: 'RenderPass'
        :return: Index, Index of pass to get
        """
        ...

    def active_view_get(self) -> typing.Union[str, typing.Any]:
        """active_view_get

        :rtype: typing.Union[str, typing.Any]
        :return: View, Single view active
        """
        ...

    def active_view_set(self, view: typing.Union[str, typing.Any]):
        """active_view_set

        :param view: View, Single view to set as active
        :type view: typing.Union[str, typing.Any]
        """
        ...

    def camera_shift_x(
        self,
        camera: typing.Optional["Object"],
        use_spherical_stereo: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> float:
        """camera_shift_x

        :param camera:
        :type camera: typing.Optional['Object']
        :param use_spherical_stereo: Spherical Stereo
        :type use_spherical_stereo: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: float
        :return: Shift X
        """
        ...

    def camera_model_matrix(
        self,
        camera: typing.Optional["Object"],
        use_spherical_stereo: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
            typing.Tuple[float, float, float, float],
        ],
    ]:
        """camera_model_matrix

        :param camera:
        :type camera: typing.Optional['Object']
        :param use_spherical_stereo: Spherical Stereo
        :type use_spherical_stereo: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float], typing.Tuple[float, float, float, float]]]
        :return: Model Matrix, Normalized camera model matrix
        """
        ...

    def use_spherical_stereo(self, camera: typing.Optional["Object"]) -> bool:
        """use_spherical_stereo

        :param camera:
        :type camera: typing.Optional['Object']
        :rtype: bool
        :return: Spherical Stereo
        """
        ...

    def update_stats(
        self, stats: typing.Union[str, typing.Any], info: typing.Union[str, typing.Any]
    ):
        """Update and signal to redraw render status text

        :param stats: Stats
        :type stats: typing.Union[str, typing.Any]
        :param info: Info
        :type info: typing.Union[str, typing.Any]
        """
        ...

    def frame_set(self, frame: typing.Optional[int], subframe: typing.Optional[float]):
        """Evaluate scene at a different frame (for motion blur)

        :param frame: Frame
        :type frame: typing.Optional[int]
        :param subframe: Subframe
        :type subframe: typing.Optional[float]
        """
        ...

    def update_progress(self, progress: typing.Optional[float]):
        """Update progress percentage of render

        :param progress: Percentage of render that's done
        :type progress: typing.Optional[float]
        """
        ...

    def update_memory_stats(
        self,
        memory_used: typing.Optional[typing.Any] = 0.0,
        memory_peak: typing.Optional[typing.Any] = 0.0,
    ):
        """Update memory usage statistics

        :param memory_used: Current memory usage in megabytes
        :type memory_used: typing.Optional[typing.Any]
        :param memory_peak: Peak memory usage in megabytes
        :type memory_peak: typing.Optional[typing.Any]
        """
        ...

    def report(
        self,
        type: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]],
        message: typing.Union[str, typing.Any],
    ):
        """Report info, warning or error messages

        :param type: Type
        :type type: typing.Optional[typing.Union[typing.Set[int], typing.Set[str]]]
        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        """
        ...

    def error_set(self, message: typing.Union[str, typing.Any]):
        """Set error message displaying after the render is finished

        :param message: Report Message
        :type message: typing.Union[str, typing.Any]
        """
        ...

    def bind_display_space_shader(self, scene: typing.Optional["Scene"]):
        """Bind GLSL fragment shader that converts linear colors to display space colors using scene color management settings

        :param scene:
        :type scene: typing.Optional['Scene']
        """
        ...

    def unbind_display_space_shader(self):
        """Unbind GLSL display space shader, must always be called after binding the shader"""
        ...

    def support_display_space_shader(self, scene: typing.Optional["Scene"]) -> bool:
        """Test if GLSL display space shader is supported for the combination of graphics card and scene settings

        :param scene:
        :type scene: typing.Optional['Scene']
        :rtype: bool
        :return: Supported
        """
        ...

    def get_preview_pixel_size(self, scene: typing.Optional["Scene"]) -> int:
        """Get the pixel size that should be used for preview rendering

        :param scene:
        :type scene: typing.Optional['Scene']
        :rtype: int
        :return: Pixel Size
        """
        ...

    def free_blender_memory(self):
        """Free Blender side memory of render engine"""
        ...

    def tile_highlight_set(
        self,
        x: typing.Optional[int],
        y: typing.Optional[int],
        width: typing.Optional[int],
        height: typing.Optional[int],
        highlight: typing.Optional[bool],
    ):
        """Set highlighted state of the given tile

        :param x: X
        :type x: typing.Optional[int]
        :param y: Y
        :type y: typing.Optional[int]
        :param width: Width
        :type width: typing.Optional[int]
        :param height: Height
        :type height: typing.Optional[int]
        :param highlight: Highlight
        :type highlight: typing.Optional[bool]
        """
        ...

    def tile_highlight_clear_all(self):
        """The temp directory used by Blender"""
        ...

    def register_pass(
        self,
        scene: typing.Optional["Scene"],
        view_layer: typing.Optional["ViewLayer"],
        name: typing.Union[str, typing.Any],
        channels: typing.Optional[int],
        chanid: typing.Union[str, typing.Any],
        type: typing.Optional[typing.Union[int, str]],
    ):
        """Register a render pass that will be part of the render with the current settings

        :param scene:
        :type scene: typing.Optional['Scene']
        :param view_layer:
        :type view_layer: typing.Optional['ViewLayer']
        :param name: Name
        :type name: typing.Union[str, typing.Any]
        :param channels: Channels
        :type channels: typing.Optional[int]
        :param chanid: Channel IDs
        :type chanid: typing.Union[str, typing.Any]
        :param type: Type
        :type type: typing.Optional[typing.Union[int, str]]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RenderLayer(bpy_struct):
    name: typing.Union[str, typing.Any]
    """ View layer name

    :type: typing.Union[str, typing.Any]
    """

    passes: "RenderPasses"
    """ 

    :type: 'RenderPasses'
    """

    use_ao: typing.Union[bool, typing.Any]
    """ Render Ambient Occlusion in this Layer

    :type: typing.Union[bool, typing.Any]
    """

    use_motion_blur: typing.Union[bool, typing.Any]
    """ Render motion blur in this Layer, if enabled in the scene

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_ambient_occlusion: typing.Union[bool, typing.Any]
    """ Deliver Ambient Occlusion pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_combined: typing.Union[bool, typing.Any]
    """ Deliver full combined RGBA buffer

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_diffuse_color: typing.Union[bool, typing.Any]
    """ Deliver diffuse color pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_diffuse_direct: typing.Union[bool, typing.Any]
    """ Deliver diffuse direct pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_diffuse_indirect: typing.Union[bool, typing.Any]
    """ Deliver diffuse indirect pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_emit: typing.Union[bool, typing.Any]
    """ Deliver emission pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_environment: typing.Union[bool, typing.Any]
    """ Deliver environment lighting pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_glossy_color: typing.Union[bool, typing.Any]
    """ Deliver glossy color pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_glossy_direct: typing.Union[bool, typing.Any]
    """ Deliver glossy direct pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_glossy_indirect: typing.Union[bool, typing.Any]
    """ Deliver glossy indirect pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_material_index: typing.Union[bool, typing.Any]
    """ Deliver material index pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_mist: typing.Union[bool, typing.Any]
    """ Deliver mist factor pass (0.0 to 1.0)

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_normal: typing.Union[bool, typing.Any]
    """ Deliver normal pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_object_index: typing.Union[bool, typing.Any]
    """ Deliver object index pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_position: typing.Union[bool, typing.Any]
    """ Deliver position pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_shadow: typing.Union[bool, typing.Any]
    """ Deliver shadow pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_subsurface_color: typing.Union[bool, typing.Any]
    """ Deliver subsurface color pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_subsurface_direct: typing.Union[bool, typing.Any]
    """ Deliver subsurface direct pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_subsurface_indirect: typing.Union[bool, typing.Any]
    """ Deliver subsurface indirect pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_transmission_color: typing.Union[bool, typing.Any]
    """ Deliver transmission color pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_transmission_direct: typing.Union[bool, typing.Any]
    """ Deliver transmission direct pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_transmission_indirect: typing.Union[bool, typing.Any]
    """ Deliver transmission indirect pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_uv: typing.Union[bool, typing.Any]
    """ Deliver texture UV pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_vector: typing.Union[bool, typing.Any]
    """ Deliver speed vector pass

    :type: typing.Union[bool, typing.Any]
    """

    use_pass_z: typing.Union[bool, typing.Any]
    """ Deliver Z values pass

    :type: typing.Union[bool, typing.Any]
    """

    use_sky: typing.Union[bool, typing.Any]
    """ Render Sky in this Layer

    :type: typing.Union[bool, typing.Any]
    """

    use_solid: typing.Union[bool, typing.Any]
    """ Render Solid faces in this Layer

    :type: typing.Union[bool, typing.Any]
    """

    use_strand: typing.Union[bool, typing.Any]
    """ Render Strands in this Layer

    :type: typing.Union[bool, typing.Any]
    """

    use_volumes: typing.Union[bool, typing.Any]
    """ Render volumes in this Layer

    :type: typing.Union[bool, typing.Any]
    """

    def load_from_file(
        self,
        filepath: typing.Union[str, typing.Any],
        x: typing.Optional[typing.Any] = 0,
        y: typing.Optional[typing.Any] = 0,
    ):
        """Copies the pixels of this renderlayer from an image file

        :param filepath: File Path, File path to load into this render tile, must be no smaller than the renderlayer
        :type filepath: typing.Union[str, typing.Any]
        :param x: Offset X, Offset the position to copy from if the image is larger than the render layer
        :type x: typing.Optional[typing.Any]
        :param y: Offset Y, Offset the position to copy from if the image is larger than the render layer
        :type y: typing.Optional[typing.Any]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RenderPass(bpy_struct):
    channel_id: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    channels: int
    """ 

    :type: int
    """

    fullname: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    rect: float
    """ 

    :type: float
    """

    view_id: int
    """ 

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RenderResult(bpy_struct):
    """Result of rendering, including all layers and passes"""

    layers: bpy_prop_collection["RenderLayer"]
    """ 

    :type: bpy_prop_collection['RenderLayer']
    """

    resolution_x: int
    """ 

    :type: int
    """

    resolution_y: int
    """ 

    :type: int
    """

    views: bpy_prop_collection["RenderView"]
    """ 

    :type: bpy_prop_collection['RenderView']
    """

    def load_from_file(self, filepath: typing.Union[str, typing.Any]):
        """Copies the pixels of this render result from an image file

        :param filepath: File Name, Filename to load into this render tile, must be no smaller than the render result
        :type filepath: typing.Union[str, typing.Any]
        """
        ...

    def stamp_data_add_field(
        self, field: typing.Union[str, typing.Any], value: typing.Union[str, typing.Any]
    ):
        """Add engine-specific stamp data to the result

        :param field: Field, Name of the stamp field to add
        :type field: typing.Union[str, typing.Any]
        :param value: Value, Value of the stamp data
        :type value: typing.Union[str, typing.Any]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RenderSettings(bpy_struct):
    """Rendering settings for a Scene data-block"""

    bake: "BakeSettings"
    """ 

    :type: 'BakeSettings'
    """

    bake_bias: float
    """ Bias towards faces further away from the object (in Blender units)

    :type: float
    """

    bake_margin: int
    """ Extends the baked result as a post process filter

    :type: int
    """

    bake_margin_type: typing.Union[int, str]
    """ Algorithm to generate the margin

    :type: typing.Union[int, str]
    """

    bake_samples: int
    """ Number of samples used for ambient occlusion baking from multires

    :type: int
    """

    bake_type: typing.Union[int, str]
    """ Choose shading information to bake into the image

    :type: typing.Union[int, str]
    """

    bake_user_scale: float
    """ Instead of automatically normalizing to the range 0 to 1, apply a user scale to the derivative map

    :type: float
    """

    border_max_x: float
    """ Maximum X value for the render region

    :type: float
    """

    border_max_y: float
    """ Maximum Y value for the render region

    :type: float
    """

    border_min_x: float
    """ Minimum X value for the render region

    :type: float
    """

    border_min_y: float
    """ Minimum Y value for the render region

    :type: float
    """

    dither_intensity: float
    """ Amount of dithering noise added to the rendered image to break up banding

    :type: float
    """

    engine: typing.Union[int, str]
    """ Engine to use for rendering

    :type: typing.Union[int, str]
    """

    ffmpeg: "FFmpegSettings"
    """ FFmpeg related settings for the scene

    :type: 'FFmpegSettings'
    """

    file_extension: typing.Union[str, typing.Any]
    """ The file extension used for saving renders

    :type: typing.Union[str, typing.Any]
    """

    filepath: typing.Union[str, typing.Any]
    """ Directory/name to save animations, # characters define the position and padding of frame numbers

    :type: typing.Union[str, typing.Any]
    """

    film_transparent: bool
    """ World background is transparent, for compositing the render over another background

    :type: bool
    """

    filter_size: float
    """ Width over which the reconstruction filter combines samples

    :type: float
    """

    fps: int
    """ Framerate, expressed in frames per second

    :type: int
    """

    fps_base: float
    """ Framerate base

    :type: float
    """

    frame_map_new: int
    """ How many frames the Map Old will last

    :type: int
    """

    frame_map_old: int
    """ Old mapping value in frames

    :type: int
    """

    hair_subdiv: int
    """ Additional subdivision along the curves

    :type: int
    """

    hair_type: typing.Union[int, str]
    """ Curves shape type

    :type: typing.Union[int, str]
    """

    has_multiple_engines: typing.Union[bool, typing.Any]
    """ More than one rendering engine is available

    :type: typing.Union[bool, typing.Any]
    """

    image_settings: "ImageFormatSettings"
    """ 

    :type: 'ImageFormatSettings'
    """

    is_movie_format: typing.Union[bool, typing.Any]
    """ When true the format is a movie

    :type: typing.Union[bool, typing.Any]
    """

    line_thickness: float
    """ Line thickness in pixels

    :type: float
    """

    line_thickness_mode: typing.Union[int, str]
    """ Line thickness mode for Freestyle line drawing

    :type: typing.Union[int, str]
    """

    metadata_input: typing.Union[int, str]
    """ Where to take the metadata from

    :type: typing.Union[int, str]
    """

    motion_blur_position: typing.Union[int, str]
    """ Offset for the shutter's time interval, allows to change the motion blur trails

    :type: typing.Union[int, str]
    """

    motion_blur_shutter: float
    """ Time taken in frames between shutter open and close

    :type: float
    """

    motion_blur_shutter_curve: "CurveMapping"
    """ Curve defining the shutter's openness over time

    :type: 'CurveMapping'
    """

    pixel_aspect_x: float
    """ Horizontal aspect ratio - for anamorphic or non-square pixel output

    :type: float
    """

    pixel_aspect_y: float
    """ Vertical aspect ratio - for anamorphic or non-square pixel output

    :type: float
    """

    preview_pixel_size: typing.Union[int, str]
    """ Pixel size for viewport rendering

    :type: typing.Union[int, str]
    """

    resolution_percentage: int
    """ Percentage scale for render resolution

    :type: int
    """

    resolution_x: int
    """ Number of horizontal pixels in the rendered image

    :type: int
    """

    resolution_y: int
    """ Number of vertical pixels in the rendered image

    :type: int
    """

    sequencer_gl_preview: typing.Union[int, str]
    """ Display method used in the sequencer view

    :type: typing.Union[int, str]
    """

    simplify_child_particles: float
    """ Global child particles percentage

    :type: float
    """

    simplify_child_particles_render: float
    """ Global child particles percentage during rendering

    :type: float
    """

    simplify_gpencil: bool
    """ Simplify Grease Pencil drawing

    :type: bool
    """

    simplify_gpencil_antialiasing: bool
    """ Use Antialiasing to smooth stroke edges

    :type: bool
    """

    simplify_gpencil_modifier: bool
    """ Display modifiers

    :type: bool
    """

    simplify_gpencil_onplay: bool
    """ Simplify Grease Pencil only during animation playback

    :type: bool
    """

    simplify_gpencil_shader_fx: bool
    """ Display Shader Effects

    :type: bool
    """

    simplify_gpencil_tint: bool
    """ Display layer tint

    :type: bool
    """

    simplify_gpencil_view_fill: bool
    """ Display fill strokes in the viewport

    :type: bool
    """

    simplify_shadows: float
    """ Resolution percentage of shadows in viewport

    :type: float
    """

    simplify_shadows_render: float
    """ Resolution percentage of shadows in viewport

    :type: float
    """

    simplify_subdivision: int
    """ Global maximum subdivision level

    :type: int
    """

    simplify_subdivision_render: int
    """ Global maximum subdivision level during rendering

    :type: int
    """

    simplify_volumes: float
    """ Resolution percentage of volume objects in viewport

    :type: float
    """

    stamp_background: bpy_prop_array[float]
    """ Color to use behind stamp text

    :type: bpy_prop_array[float]
    """

    stamp_font_size: int
    """ Size of the font used when rendering stamp text

    :type: int
    """

    stamp_foreground: bpy_prop_array[float]
    """ Color to use for stamp text

    :type: bpy_prop_array[float]
    """

    stamp_note_text: typing.Union[str, typing.Any]
    """ Custom text to appear in the stamp note

    :type: typing.Union[str, typing.Any]
    """

    stereo_views: bpy_prop_collection["SceneRenderView"]
    """ 

    :type: bpy_prop_collection['SceneRenderView']
    """

    threads: int
    """ Maximum number of CPU cores to use simultaneously while rendering (for multi-core/CPU systems)

    :type: int
    """

    threads_mode: typing.Union[int, str]
    """ Determine the amount of render threads used

    :type: typing.Union[int, str]
    """

    use_bake_clear: bool
    """ Clear Images before baking

    :type: bool
    """

    use_bake_lores_mesh: bool
    """ Calculate heights against unsubdivided low resolution mesh

    :type: bool
    """

    use_bake_multires: bool
    """ Bake directly from multires object

    :type: bool
    """

    use_bake_selected_to_active: bool
    """ Bake shading on the surface of selected objects to the active object

    :type: bool
    """

    use_bake_user_scale: bool
    """ Use a user scale for the derivative map

    :type: bool
    """

    use_border: bool
    """ Render a user-defined render region, within the frame size

    :type: bool
    """

    use_compositing: bool
    """ Process the render result through the compositing pipeline, if compositing nodes are enabled

    :type: bool
    """

    use_crop_to_border: bool
    """ Crop the rendered frame to the defined render region size

    :type: bool
    """

    use_file_extension: bool
    """ Add the file format extensions to the rendered file name (eg: filename + .jpg)

    :type: bool
    """

    use_freestyle: bool
    """ Draw stylized strokes using Freestyle

    :type: bool
    """

    use_high_quality_normals: bool
    """ Use high quality tangent space at the cost of lower performance

    :type: bool
    """

    use_lock_interface: bool
    """ Lock interface during rendering in favor of giving more memory to the renderer

    :type: bool
    """

    use_motion_blur: bool
    """ Use multi-sampled 3D scene motion blur

    :type: bool
    """

    use_multiview: bool
    """ Use multiple views in the scene

    :type: bool
    """

    use_overwrite: bool
    """ Overwrite existing files while rendering

    :type: bool
    """

    use_persistent_data: bool
    """ Keep render data around for faster re-renders and animation renders, at the cost of increased memory usage

    :type: bool
    """

    use_placeholder: bool
    """ Create empty placeholder files while rendering frames (similar to Unix 'touch')

    :type: bool
    """

    use_render_cache: bool
    """ Save render cache to EXR files (useful for heavy compositing, Note: affects indirectly rendered scenes)

    :type: bool
    """

    use_sequencer: bool
    """ Process the render (and composited) result through the video sequence editor pipeline, if sequencer strips exist

    :type: bool
    """

    use_sequencer_override_scene_strip: bool
    """ Use workbench render settings from the sequencer scene, instead of each individual scene used in the strip

    :type: bool
    """

    use_simplify: bool
    """ Enable simplification of scene for quicker preview renders

    :type: bool
    """

    use_simplify_normals: bool
    """ Skip computing custom normals and face corner normals for displaying meshes in the viewport

    :type: bool
    """

    use_single_layer: bool
    """ Only render the active layer. Only affects rendering from the interface, ignored for rendering from command line

    :type: bool
    """

    use_spherical_stereo: typing.Union[bool, typing.Any]
    """ Active render engine supports spherical stereo rendering

    :type: typing.Union[bool, typing.Any]
    """

    use_stamp: bool
    """ Render the stamp info text in the rendered image

    :type: bool
    """

    use_stamp_camera: bool
    """ Include the name of the active camera in image metadata

    :type: bool
    """

    use_stamp_date: bool
    """ Include the current date in image/video metadata

    :type: bool
    """

    use_stamp_filename: bool
    """ Include the .blend filename in image/video metadata

    :type: bool
    """

    use_stamp_frame: bool
    """ Include the frame number in image metadata

    :type: bool
    """

    use_stamp_frame_range: bool
    """ Include the rendered frame range in image/video metadata

    :type: bool
    """

    use_stamp_hostname: bool
    """ Include the hostname of the machine that rendered the frame

    :type: bool
    """

    use_stamp_labels: bool
    """ Display stamp labels ("Camera" in front of camera name, etc.)

    :type: bool
    """

    use_stamp_lens: bool
    """ Include the active camera's lens in image metadata

    :type: bool
    """

    use_stamp_marker: bool
    """ Include the name of the last marker in image metadata

    :type: bool
    """

    use_stamp_memory: bool
    """ Include the peak memory usage in image metadata

    :type: bool
    """

    use_stamp_note: bool
    """ Include a custom note in image/video metadata

    :type: bool
    """

    use_stamp_render_time: bool
    """ Include the render time in image metadata

    :type: bool
    """

    use_stamp_scene: bool
    """ Include the name of the active scene in image/video metadata

    :type: bool
    """

    use_stamp_sequencer_strip: bool
    """ Include the name of the foreground sequence strip in image metadata

    :type: bool
    """

    use_stamp_time: bool
    """ Include the rendered frame timecode as HH:MM:SS.FF in image metadata

    :type: bool
    """

    views: "RenderViews"
    """ 

    :type: 'RenderViews'
    """

    views_format: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    def frame_path(
        self,
        frame: typing.Optional[typing.Any] = -2147483648,
        preview: typing.Optional[typing.Union[bool, typing.Any]] = False,
        view: typing.Union[str, typing.Any] = "",
    ) -> typing.Union[str, typing.Any]:
        """Return the absolute path to the filename to be written for a given frame

        :param frame: Frame number to use, if unset the current frame will be used
        :type frame: typing.Optional[typing.Any]
        :param preview: Preview, Use preview range
        :type preview: typing.Optional[typing.Union[bool, typing.Any]]
        :param view: View, The name of the view to use to replace the "%" chars
        :type view: typing.Union[str, typing.Any]
        :rtype: typing.Union[str, typing.Any]
        :return: File Path, The resulting filepath from the scenes render settings
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RenderSlot(bpy_struct):
    """Parameters defining the render slot"""

    name: typing.Union[str, typing.Any]
    """ Render slot name

    :type: typing.Union[str, typing.Any]
    """

    def clear(self, iuser: typing.Optional["ImageUser"]):
        """Clear the render slot

        :param iuser: ImageUser
        :type iuser: typing.Optional['ImageUser']
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RenderView(bpy_struct):
    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RepeatItem(bpy_struct):
    color: bpy_prop_array[float]
    """ Color of the corresponding socket type in the node editor

    :type: bpy_prop_array[float]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    socket_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RetimingKey(bpy_struct):
    """Key mapped to particular frame that can be moved to change playback speed"""

    timeline_frame: int
    """ Position of retiming key in timeline

    :type: int
    """

    def remove(self):
        """Remove retiming key"""
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RigidBodyConstraint(bpy_struct):
    """Constraint influencing Objects inside Rigid Body Simulation"""

    breaking_threshold: float
    """ Impulse threshold that must be reached for the constraint to break

    :type: float
    """

    disable_collisions: bool
    """ Disable collisions between constrained rigid bodies

    :type: bool
    """

    enabled: bool
    """ Enable this constraint

    :type: bool
    """

    limit_ang_x_lower: float
    """ Lower limit of X axis rotation

    :type: float
    """

    limit_ang_x_upper: float
    """ Upper limit of X axis rotation

    :type: float
    """

    limit_ang_y_lower: float
    """ Lower limit of Y axis rotation

    :type: float
    """

    limit_ang_y_upper: float
    """ Upper limit of Y axis rotation

    :type: float
    """

    limit_ang_z_lower: float
    """ Lower limit of Z axis rotation

    :type: float
    """

    limit_ang_z_upper: float
    """ Upper limit of Z axis rotation

    :type: float
    """

    limit_lin_x_lower: float
    """ Lower limit of X axis translation

    :type: float
    """

    limit_lin_x_upper: float
    """ Upper limit of X axis translation

    :type: float
    """

    limit_lin_y_lower: float
    """ Lower limit of Y axis translation

    :type: float
    """

    limit_lin_y_upper: float
    """ Upper limit of Y axis translation

    :type: float
    """

    limit_lin_z_lower: float
    """ Lower limit of Z axis translation

    :type: float
    """

    limit_lin_z_upper: float
    """ Upper limit of Z axis translation

    :type: float
    """

    motor_ang_max_impulse: float
    """ Maximum angular motor impulse

    :type: float
    """

    motor_ang_target_velocity: float
    """ Target angular motor velocity

    :type: float
    """

    motor_lin_max_impulse: float
    """ Maximum linear motor impulse

    :type: float
    """

    motor_lin_target_velocity: float
    """ Target linear motor velocity

    :type: float
    """

    object1: "Object"
    """ First Rigid Body Object to be constrained

    :type: 'Object'
    """

    object2: "Object"
    """ Second Rigid Body Object to be constrained

    :type: 'Object'
    """

    solver_iterations: int
    """ Number of constraint solver iterations made per simulation step (higher values are more accurate but slower)

    :type: int
    """

    spring_damping_ang_x: float
    """ Damping on the X rotational axis

    :type: float
    """

    spring_damping_ang_y: float
    """ Damping on the Y rotational axis

    :type: float
    """

    spring_damping_ang_z: float
    """ Damping on the Z rotational axis

    :type: float
    """

    spring_damping_x: float
    """ Damping on the X axis

    :type: float
    """

    spring_damping_y: float
    """ Damping on the Y axis

    :type: float
    """

    spring_damping_z: float
    """ Damping on the Z axis

    :type: float
    """

    spring_stiffness_ang_x: float
    """ Stiffness on the X rotational axis

    :type: float
    """

    spring_stiffness_ang_y: float
    """ Stiffness on the Y rotational axis

    :type: float
    """

    spring_stiffness_ang_z: float
    """ Stiffness on the Z rotational axis

    :type: float
    """

    spring_stiffness_x: float
    """ Stiffness on the X axis

    :type: float
    """

    spring_stiffness_y: float
    """ Stiffness on the Y axis

    :type: float
    """

    spring_stiffness_z: float
    """ Stiffness on the Z axis

    :type: float
    """

    spring_type: typing.Union[int, str]
    """ Which implementation of spring to use

    :type: typing.Union[int, str]
    """

    type: typing.Union[int, str]
    """ Type of Rigid Body Constraint

    :type: typing.Union[int, str]
    """

    use_breaking: bool
    """ Constraint can be broken if it receives an impulse above the threshold

    :type: bool
    """

    use_limit_ang_x: bool
    """ Limit rotation around X axis

    :type: bool
    """

    use_limit_ang_y: bool
    """ Limit rotation around Y axis

    :type: bool
    """

    use_limit_ang_z: bool
    """ Limit rotation around Z axis

    :type: bool
    """

    use_limit_lin_x: bool
    """ Limit translation on X axis

    :type: bool
    """

    use_limit_lin_y: bool
    """ Limit translation on Y axis

    :type: bool
    """

    use_limit_lin_z: bool
    """ Limit translation on Z axis

    :type: bool
    """

    use_motor_ang: bool
    """ Enable angular motor

    :type: bool
    """

    use_motor_lin: bool
    """ Enable linear motor

    :type: bool
    """

    use_override_solver_iterations: bool
    """ Override the number of solver iterations for this constraint

    :type: bool
    """

    use_spring_ang_x: bool
    """ Enable spring on X rotational axis

    :type: bool
    """

    use_spring_ang_y: bool
    """ Enable spring on Y rotational axis

    :type: bool
    """

    use_spring_ang_z: bool
    """ Enable spring on Z rotational axis

    :type: bool
    """

    use_spring_x: bool
    """ Enable spring on X axis

    :type: bool
    """

    use_spring_y: bool
    """ Enable spring on Y axis

    :type: bool
    """

    use_spring_z: bool
    """ Enable spring on Z axis

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RigidBodyObject(bpy_struct):
    """Settings for object participating in Rigid Body Simulation"""

    angular_damping: float
    """ Amount of angular velocity that is lost over time

    :type: float
    """

    collision_collections: typing.List[bool]
    """ Collision collections rigid body belongs to

    :type: typing.List[bool]
    """

    collision_margin: float
    """ Threshold of distance near surface where collisions are still considered (best results when non-zero)

    :type: float
    """

    collision_shape: typing.Union[int, str]
    """ Collision Shape of object in Rigid Body Simulations

    :type: typing.Union[int, str]
    """

    deactivate_angular_velocity: float
    """ Angular Velocity below which simulation stops simulating object

    :type: float
    """

    deactivate_linear_velocity: float
    """ Linear Velocity below which simulation stops simulating object

    :type: float
    """

    enabled: bool
    """ Rigid Body actively participates to the simulation

    :type: bool
    """

    friction: float
    """ Resistance of object to movement

    :type: float
    """

    kinematic: bool
    """ Allow rigid body to be controlled by the animation system

    :type: bool
    """

    linear_damping: float
    """ Amount of linear velocity that is lost over time

    :type: float
    """

    mass: float
    """ How much the object 'weighs' irrespective of gravity

    :type: float
    """

    mesh_source: typing.Union[int, str]
    """ Source of the mesh used to create collision shape

    :type: typing.Union[int, str]
    """

    restitution: float
    """ Tendency of object to bounce after colliding with another (0 = stays still, 1 = perfectly elastic)

    :type: float
    """

    type: typing.Union[int, str]
    """ Role of object in Rigid Body Simulations

    :type: typing.Union[int, str]
    """

    use_deactivation: bool
    """ Enable deactivation of resting rigid bodies (increases performance and stability but can cause glitches)

    :type: bool
    """

    use_deform: bool
    """ Rigid body deforms during simulation

    :type: bool
    """

    use_margin: bool
    """ Use custom collision margin (some shapes will have a visible gap around them)

    :type: bool
    """

    use_start_deactivated: bool
    """ Deactivate rigid body at the start of the simulation

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class RigidBodyWorld(bpy_struct):
    """Self-contained rigid body simulation environment and settings"""

    collection: "Collection"
    """ Collection containing objects participating in this simulation

    :type: 'Collection'
    """

    constraints: "Collection"
    """ Collection containing rigid body constraint objects

    :type: 'Collection'
    """

    effector_weights: "EffectorWeights"
    """ 

    :type: 'EffectorWeights'
    """

    enabled: bool
    """ Simulation will be evaluated

    :type: bool
    """

    point_cache: "PointCache"
    """ 

    :type: 'PointCache'
    """

    solver_iterations: int
    """ Number of constraint solver iterations made per simulation step (higher values are more accurate but slower)

    :type: int
    """

    substeps_per_frame: int
    """ Number of simulation steps taken per frame (higher values are more accurate but slower)

    :type: int
    """

    time_scale: float
    """ Change the speed of the simulation

    :type: float
    """

    use_split_impulse: bool
    """ Reduce extra velocity that can build up when objects collide (lowers simulation stability a little so use only when necessary)

    :type: bool
    """

    def convex_sweep_test(
        self,
        object: "Object",
        start: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
        end: typing.Optional[
            typing.Union[
                "mathutils.Vector",
                typing.List[float],
                typing.Tuple[float, float, float],
            ]
        ],
    ):
        """Sweep test convex rigidbody against the current rigidbody world

                :param object: Rigidbody object with a convex collision shape
                :type object: 'Object'
                :param start:
                :type start: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
                :param end:
                :type end: typing.Optional[typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]]
                :return: object_location, The hit location of this sweep test, `mathutils.Vector` of 3 items in [-inf, inf]

        hitpoint, The hit location of this sweep test, `mathutils.Vector` of 3 items in [-inf, inf]

        normal, The face normal at the sweep test hit location, `mathutils.Vector` of 3 items in [-inf, inf]

        has_hit, If the function has found collision point, value is 1, otherwise 0, int in [-inf, inf]
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SPHFluidSettings(bpy_struct):
    """Settings for particle fluids physics"""

    buoyancy: float
    """ Artificial buoyancy force in negative gravity direction based on pressure differences inside the fluid

    :type: float
    """

    fluid_radius: float
    """ Fluid interaction radius

    :type: float
    """

    linear_viscosity: float
    """ Linear viscosity

    :type: float
    """

    plasticity: float
    """ How much the spring rest length can change after the elastic limit is crossed

    :type: float
    """

    repulsion: float
    """ How strongly the fluid tries to keep from clustering (factor of stiffness)

    :type: float
    """

    rest_density: float
    """ Fluid rest density

    :type: float
    """

    rest_length: float
    """ Spring rest length (factor of particle radius)

    :type: float
    """

    solver: typing.Union[int, str]
    """ The code used to calculate internal forces on particles

    :type: typing.Union[int, str]
    """

    spring_force: float
    """ Spring force

    :type: float
    """

    spring_frames: int
    """ Create springs for this number of frames since particles birth (0 is always)

    :type: int
    """

    stiff_viscosity: float
    """ Creates viscosity for expanding fluid

    :type: float
    """

    stiffness: float
    """ How incompressible the fluid is (speed of sound)

    :type: float
    """

    use_factor_density: bool
    """ Density is calculated as a factor of default density (depends on particle size)

    :type: bool
    """

    use_factor_radius: bool
    """ Interaction radius is a factor of 4 * particle size

    :type: bool
    """

    use_factor_repulsion: bool
    """ Repulsion is a factor of stiffness

    :type: bool
    """

    use_factor_rest_length: bool
    """ Spring rest length is a factor of 2 * particle size

    :type: bool
    """

    use_factor_stiff_viscosity: bool
    """ Stiff viscosity is a factor of normal viscosity

    :type: bool
    """

    use_initial_rest_length: bool
    """ Use the initial length as spring rest length instead of 2 * particle size

    :type: bool
    """

    use_viscoelastic_springs: bool
    """ Use viscoelastic springs instead of Hooke's springs

    :type: bool
    """

    yield_ratio: float
    """ How much the spring has to be stretched/compressed in order to change its rest length

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SceneDisplay(bpy_struct):
    """Scene display settings for 3D viewport"""

    light_direction: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Direction of the light for shadows and highlights

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    matcap_ssao_attenuation: float
    """ Attenuation constant

    :type: float
    """

    matcap_ssao_distance: float
    """ Distance of object that contribute to the Cavity/Edge effect

    :type: float
    """

    matcap_ssao_samples: int
    """ Number of samples

    :type: int
    """

    render_aa: typing.Union[int, str]
    """ Method of anti-aliasing when rendering final image

    :type: typing.Union[int, str]
    """

    shading: "View3DShading"
    """ Shading settings for OpenGL render engine

    :type: 'View3DShading'
    """

    shadow_focus: float
    """ Shadow factor hardness

    :type: float
    """

    shadow_shift: float
    """ Shadow termination angle

    :type: float
    """

    viewport_aa: typing.Union[int, str]
    """ Method of anti-aliasing when rendering 3d viewport

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SceneEEVEE(bpy_struct):
    """Scene display settings for 3D viewport"""

    bloom_clamp: float
    """ Maximum intensity a bloom pixel can have (0 to disable)

    :type: float
    """

    bloom_color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color applied to the bloom effect

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    bloom_intensity: float
    """ Blend factor

    :type: float
    """

    bloom_knee: float
    """ Makes transition between under/over-threshold gradual

    :type: float
    """

    bloom_radius: float
    """ Bloom spread distance

    :type: float
    """

    bloom_threshold: float
    """ Filters out pixels under this level of brightness

    :type: float
    """

    bokeh_denoise_fac: float
    """ Amount of flicker removal applied to bokeh highlights

    :type: float
    """

    bokeh_max_size: float
    """ Max size of the bokeh shape for the depth of field (lower is faster)

    :type: float
    """

    bokeh_neighbor_max: float
    """ Maximum brightness to consider when rejecting bokeh sprites based on neighborhood (lower is faster)

    :type: float
    """

    bokeh_overblur: float
    """ Apply blur to each jittered sample to reduce under-sampling artifacts

    :type: float
    """

    bokeh_threshold: float
    """ Brightness threshold for using sprite base depth of field

    :type: float
    """

    gi_auto_bake: bool
    """ Auto bake indirect lighting when editing probes

    :type: bool
    """

    gi_cache_info: typing.Union[str, typing.Any]
    """ Info on current cache status

    :type: typing.Union[str, typing.Any]
    """

    gi_cubemap_display_size: float
    """ Size of the cubemap spheres to debug captured light

    :type: float
    """

    gi_cubemap_resolution: typing.Union[int, str]
    """ Size of every cubemaps

    :type: typing.Union[int, str]
    """

    gi_diffuse_bounces: int
    """ Number of times the light is reinjected inside light grids, 0 disable indirect diffuse light

    :type: int
    """

    gi_filter_quality: float
    """ Take more samples during cubemap filtering to remove artifacts

    :type: float
    """

    gi_glossy_clamp: float
    """ Clamp pixel intensity to reduce noise inside glossy reflections from reflection cubemaps (0 to disable)

    :type: float
    """

    gi_irradiance_display_size: float
    """ Size of the irradiance sample spheres to debug captured light

    :type: float
    """

    gi_irradiance_pool_size: typing.Union[int, str]
    """ Size of the irradiance pool, a bigger pool size allows for more irradiance grid in the scene but might not fit into GPU memory and decrease performance

    :type: typing.Union[int, str]
    """

    gi_irradiance_smoothing: float
    """ Smoother irradiance interpolation but introduce light bleeding

    :type: float
    """

    gi_show_cubemaps: bool
    """ Display captured cubemaps in the viewport

    :type: bool
    """

    gi_show_irradiance: bool
    """ Display irradiance samples in the viewport

    :type: bool
    """

    gi_visibility_resolution: typing.Union[int, str]
    """ Size of the shadow map applied to each irradiance sample

    :type: typing.Union[int, str]
    """

    gtao_distance: float
    """ Distance of object that contribute to the ambient occlusion effect

    :type: float
    """

    gtao_factor: float
    """ Factor for ambient occlusion blending

    :type: float
    """

    gtao_quality: float
    """ Precision of the horizon search

    :type: float
    """

    horizon_bias: float
    """ Bias the horizon angles to reduce self intersection artifacts

    :type: float
    """

    horizon_quality: float
    """ Precision of the horizon scan

    :type: float
    """

    horizon_thickness: float
    """ Constant thickness of the surfaces considered when doing horizon scan and by extension ambient occlusion

    :type: float
    """

    light_threshold: float
    """ Minimum light intensity for a light to contribute to the lighting

    :type: float
    """

    motion_blur_depth_scale: float
    """ Lower values will reduce background bleeding onto foreground elements

    :type: float
    """

    motion_blur_max: int
    """ Maximum blur distance a pixel can spread over

    :type: int
    """

    motion_blur_steps: int
    """ Controls accuracy of motion blur, more steps means longer render time

    :type: int
    """

    overscan_size: float
    """ Percentage of render size to add as overscan to the internal render buffers

    :type: float
    """

    ray_tracing_method: typing.Union[int, str]
    """ Select the tracing method used to find scene-ray intersections

    :type: typing.Union[int, str]
    """

    ray_tracing_options: "RaytraceEEVEE"
    """ EEVEE settings for tracing reflections

    :type: 'RaytraceEEVEE'
    """

    shadow_cascade_size: typing.Union[int, str]
    """ Size of sun light shadow maps

    :type: typing.Union[int, str]
    """

    shadow_cube_size: typing.Union[int, str]
    """ Size of point and area light shadow maps

    :type: typing.Union[int, str]
    """

    shadow_normal_bias: float
    """ Move shadows along their normal

    :type: float
    """

    shadow_pool_size: typing.Union[int, str]
    """ Size of the shadow pool, a bigger pool size allows for more shadows in the scene but might not fit into GPU memory

    :type: typing.Union[int, str]
    """

    shadow_ray_count: int
    """ Amount of shadow ray to trace for each light

    :type: int
    """

    shadow_step_count: int
    """ Amount of shadow map sample per shadow ray

    :type: int
    """

    ssr_border_fade: float
    """ Screen percentage used to fade the SSR

    :type: float
    """

    ssr_firefly_fac: float
    """ Clamp pixel intensity to remove noise (0 to disable)

    :type: float
    """

    ssr_max_roughness: float
    """ Do not raytrace reflections for roughness above this value

    :type: float
    """

    ssr_quality: float
    """ Precision of the screen space ray-tracing

    :type: float
    """

    ssr_thickness: float
    """ Pixel thickness used to detect intersection

    :type: float
    """

    sss_jitter_threshold: float
    """ Rotate samples that are below this threshold

    :type: float
    """

    sss_samples: int
    """ Number of samples to compute the scattering effect

    :type: int
    """

    taa_render_samples: int
    """ Number of samples per pixel for rendering

    :type: int
    """

    taa_samples: int
    """ Number of samples, unlimited if 0

    :type: int
    """

    use_bloom: bool
    """ High brightness pixels generate a glowing effect

    :type: bool
    """

    use_bokeh_high_quality_slight_defocus: bool
    """ Sample all pixels in almost in-focus regions to eliminate noise

    :type: bool
    """

    use_bokeh_jittered: bool
    """ Jitter camera position to create accurate blurring using render samples

    :type: bool
    """

    use_gtao: bool
    """ Enable ambient occlusion to simulate medium scale indirect shadowing

    :type: bool
    """

    use_gtao_bent_normals: bool
    """ Compute main non occluded direction to sample the environment

    :type: bool
    """

    use_gtao_bounce: bool
    """ An approximation to simulate light bounces giving less occlusion on brighter objects

    :type: bool
    """

    use_overscan: bool
    """ Internally render past the image border to avoid screen-space effects disappearing

    :type: bool
    """

    use_raytracing: bool
    """ Enable the ray-tracing module

    :type: bool
    """

    use_shadow_high_bitdepth: bool
    """ Use 32-bit shadows

    :type: bool
    """

    use_shadows: bool
    """ Enable shadow casting from lights

    :type: bool
    """

    use_soft_shadows: bool
    """ Randomize shadowmaps origin to create soft shadows

    :type: bool
    """

    use_ssr: bool
    """ Enable screen space reflection

    :type: bool
    """

    use_ssr_halfres: bool
    """ Raytrace at a lower resolution

    :type: bool
    """

    use_ssr_refraction: bool
    """ Enable screen space Refractions

    :type: bool
    """

    use_taa_reprojection: bool
    """ Denoise image using temporal reprojection (can leave some ghosting)

    :type: bool
    """

    use_volumetric_lights: bool
    """ Enable scene light interactions with volumetrics

    :type: bool
    """

    use_volumetric_shadows: bool
    """ Generate shadows from volumetric material (Very expensive)

    :type: bool
    """

    volumetric_end: float
    """ End distance of the volumetric effect

    :type: float
    """

    volumetric_light_clamp: float
    """ Maximum light contribution, reducing noise

    :type: float
    """

    volumetric_ray_depth: int
    """ Maximum surface intersection count used by the accurate volume intersection method. Will create artifact if it is exceeded

    :type: int
    """

    volumetric_sample_distribution: float
    """ Distribute more samples closer to the camera

    :type: float
    """

    volumetric_samples: int
    """ Number of samples to compute volumetric effects

    :type: int
    """

    volumetric_shadow_samples: int
    """ Number of samples to compute volumetric shadowing

    :type: int
    """

    volumetric_start: float
    """ Start distance of the volumetric effect

    :type: float
    """

    volumetric_tile_size: typing.Union[int, str]
    """ Control the quality of the volumetric effects (lower size increase vram usage and quality)

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SceneGpencil(bpy_struct):
    """Render settings"""

    antialias_threshold: float
    """ Threshold for edge detection algorithm (higher values might over-blur some part of the image)

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SceneHydra(bpy_struct):
    """Scene Hydra render engine settings"""

    export_method: typing.Union[int, str]
    """ How to export the Blender scene to the Hydra render engine

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SceneRenderView(bpy_struct):
    """Render viewpoint for 3D stereo and multiview rendering"""

    camera_suffix: typing.Union[str, typing.Any]
    """ Suffix to identify the cameras to use, and added to the render images for this view

    :type: typing.Union[str, typing.Any]
    """

    file_suffix: typing.Union[str, typing.Any]
    """ Suffix added to the render images for this view

    :type: typing.Union[str, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Render view name

    :type: typing.Union[str, typing.Any]
    """

    use: bool
    """ Disable or enable the render view

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Scopes(bpy_struct):
    """Scopes for statistical view of an image"""

    accuracy: float
    """ Proportion of original image source pixel lines to sample

    :type: float
    """

    histogram: "Histogram"
    """ Histogram for viewing image statistics

    :type: 'Histogram'
    """

    use_full_resolution: bool
    """ Sample every pixel of the image

    :type: bool
    """

    vectorscope_alpha: float
    """ Opacity of the points

    :type: float
    """

    vectorscope_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    waveform_alpha: float
    """ Opacity of the points

    :type: float
    """

    waveform_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ScriptDirectory(bpy_struct):
    directory: typing.Union[str, typing.Any]
    """ Alternate script path, matching the default layout with sub-directories: startup, add-ons, modules, and presets (requires restart)

    :type: typing.Union[str, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Identifier for the Python scripts directory

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Sequence(bpy_struct):
    """Sequence strip in the sequence editor"""

    blend_alpha: float
    """ Percentage of how much the strip's colors affect other strips

    :type: float
    """

    blend_type: typing.Union[int, str]
    """ Method for controlling how the strip combines with other strips

    :type: typing.Union[int, str]
    """

    channel: int
    """ Y position of the sequence strip

    :type: int
    """

    color_tag: typing.Union[int, str]
    """ Color tag for a strip

    :type: typing.Union[int, str]
    """

    effect_fader: float
    """ Custom fade value

    :type: float
    """

    frame_duration: int
    """ The length of the contents of this strip before the handles are applied

    :type: int
    """

    frame_final_duration: int
    """ The length of the contents of this strip after the handles are applied

    :type: int
    """

    frame_final_end: int
    """ End frame displayed in the sequence editor after offsets are applied

    :type: int
    """

    frame_final_start: int
    """ Start frame displayed in the sequence editor after offsets are applied, setting this is equivalent to moving the handle, not the actual start frame

    :type: int
    """

    frame_offset_end: float
    """ 

    :type: float
    """

    frame_offset_start: float
    """ 

    :type: float
    """

    frame_start: float
    """ X position where the strip begins

    :type: float
    """

    lock: bool
    """ Lock strip so that it cannot be transformed

    :type: bool
    """

    modifiers: "SequenceModifiers"
    """ Modifiers affecting this strip

    :type: 'SequenceModifiers'
    """

    mute: bool
    """ Disable strip so that it cannot be viewed in the output

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    override_cache_settings: bool
    """ Override global cache settings

    :type: bool
    """

    select: bool
    """ 

    :type: bool
    """

    select_left_handle: bool
    """ 

    :type: bool
    """

    select_right_handle: bool
    """ 

    :type: bool
    """

    show_retiming_keys: bool
    """ Show retiming keys, so they can be moved

    :type: bool
    """

    type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    use_cache_composite: bool
    """ Cache intermediate composited images, for faster tweaking of stacked strips at the cost of memory usage

    :type: bool
    """

    use_cache_preprocessed: bool
    """ Cache preprocessed images, for faster tweaking of effects at the cost of memory usage

    :type: bool
    """

    use_cache_raw: bool
    """ Cache raw images read from disk, for faster tweaking of strip parameters at the cost of memory usage

    :type: bool
    """

    use_default_fade: bool
    """ Fade effect using the built-in default (usually make transition as long as effect strip)

    :type: bool
    """

    use_linear_modifiers: bool
    """ Calculate modifiers in linear space instead of sequencer's space

    :type: bool
    """

    def strip_elem_from_frame(self, frame: typing.Optional[int]) -> "SequenceElement":
        """Return the strip element from a given frame or None

        :param frame: Frame, The frame to get the strip element from
        :type frame: typing.Optional[int]
        :rtype: 'SequenceElement'
        :return: strip element of the current frame
        """
        ...

    def swap(self, other: "Sequence"):
        """swap

        :param other: Other
        :type other: 'Sequence'
        """
        ...

    def move_to_meta(self, meta_sequence: "Sequence"):
        """move_to_meta

        :param meta_sequence: Destination Meta Sequence, Meta to move the strip into
        :type meta_sequence: 'Sequence'
        """
        ...

    def parent_meta(self) -> "Sequence":
        """Parent meta

        :rtype: 'Sequence'
        :return: Parent Meta
        """
        ...

    def invalidate_cache(self, type: typing.Any):
        """Invalidate cached images for strip and all dependent strips

        :param type: Type, Cache Type
        :type type: typing.Any
        """
        ...

    def split(
        self, frame: typing.Optional[int], split_method: typing.Any
    ) -> "Sequence":
        """Split Sequence

        :param frame: Frame where to split the strip
        :type frame: typing.Optional[int]
        :param split_method:
        :type split_method: typing.Any
        :rtype: 'Sequence'
        :return: Right side Sequence
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SequenceColorBalanceData(bpy_struct):
    """Color balance parameters for a sequence strip and its modifiers"""

    correction_method: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    gain: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color balance gain (highlights)

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    gamma: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color balance gamma (midtones)

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    invert_gain: bool
    """ Invert the gain color

    :type: bool
    """

    invert_gamma: bool
    """ Invert the gamma color

    :type: bool
    """

    invert_lift: bool
    """ Invert the lift color

    :type: bool
    """

    invert_offset: bool
    """ Invert the offset color

    :type: bool
    """

    invert_power: bool
    """ Invert the power color

    :type: bool
    """

    invert_slope: bool
    """ Invert the slope color

    :type: bool
    """

    lift: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color balance lift (shadows)

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    offset: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Correction for entire tonal range

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    power: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Correction for midtones

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    slope: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Correction for highlights

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SequenceCrop(bpy_struct):
    """Cropping parameters for a sequence strip"""

    max_x: int
    """ Number of pixels to crop from the right side

    :type: int
    """

    max_y: int
    """ Number of pixels to crop from the top

    :type: int
    """

    min_x: int
    """ Number of pixels to crop from the left side

    :type: int
    """

    min_y: int
    """ Number of pixels to crop from the bottom

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SequenceEditor(bpy_struct):
    """Sequence editing data for a Scene data-block"""

    active_strip: "Sequence"
    """ Sequencer's active strip

    :type: 'Sequence'
    """

    channels: bpy_prop_collection["SequenceTimelineChannel"]
    """ 

    :type: bpy_prop_collection['SequenceTimelineChannel']
    """

    meta_stack: bpy_prop_collection["Sequence"]
    """ Meta strip stack, last is currently edited meta strip

    :type: bpy_prop_collection['Sequence']
    """

    overlay_frame: int
    """ Number of frames to offset

    :type: int
    """

    proxy_dir: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    proxy_storage: typing.Union[int, str]
    """ How to store proxies for this project

    :type: typing.Union[int, str]
    """

    selected_retiming_keys: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    sequences: "SequencesTopLevel"
    """ Top-level strips only

    :type: 'SequencesTopLevel'
    """

    sequences_all: bpy_prop_collection["Sequence"]
    """ All strips, recursively including those inside metastrips

    :type: bpy_prop_collection['Sequence']
    """

    show_cache: bool
    """ Visualize cached images on the timeline

    :type: bool
    """

    show_cache_composite: bool
    """ Visualize cached composite images

    :type: bool
    """

    show_cache_final_out: bool
    """ Visualize cached complete frames

    :type: bool
    """

    show_cache_preprocessed: bool
    """ Visualize cached pre-processed images

    :type: bool
    """

    show_cache_raw: bool
    """ Visualize cached raw images

    :type: bool
    """

    show_overlay_frame: bool
    """ Partial overlay on top of the sequencer with a frame offset

    :type: bool
    """

    use_cache_composite: bool
    """ Cache intermediate composited images, for faster tweaking of stacked strips at the cost of memory usage

    :type: bool
    """

    use_cache_final: bool
    """ Cache final image for each frame

    :type: bool
    """

    use_cache_preprocessed: bool
    """ Cache preprocessed images, for faster tweaking of effects at the cost of memory usage

    :type: bool
    """

    use_cache_raw: bool
    """ Cache raw images read from disk, for faster tweaking of strip parameters at the cost of memory usage

    :type: bool
    """

    use_overlay_frame_lock: bool
    """ 

    :type: bool
    """

    use_prefetch: bool
    """ Render frames ahead of current frame in the background for faster playback

    :type: bool
    """

    def display_stack(self, meta_sequence: typing.Optional["Sequence"]):
        """Display sequences stack

        :param meta_sequence: Meta Sequence, Meta to display its stack
        :type meta_sequence: typing.Optional['Sequence']
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SequenceElement(bpy_struct):
    """Sequence strip data for a single frame"""

    filename: typing.Union[str, typing.Any]
    """ Name of the source file

    :type: typing.Union[str, typing.Any]
    """

    orig_fps: float
    """ Original frames per second

    :type: float
    """

    orig_height: int
    """ Original image height

    :type: int
    """

    orig_width: int
    """ Original image width

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SequenceModifier(bpy_struct):
    """Modifier for sequence strip"""

    input_mask_id: "Mask"
    """ Mask ID used as mask input for the modifier

    :type: 'Mask'
    """

    input_mask_strip: "Sequence"
    """ Strip used as mask input for the modifier

    :type: 'Sequence'
    """

    input_mask_type: typing.Union[int, str]
    """ Type of input data used for mask

    :type: typing.Union[int, str]
    """

    mask_time: typing.Union[int, str]
    """ Time to use for the Mask animation

    :type: typing.Union[int, str]
    """

    mute: bool
    """ Mute this modifier

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    show_expanded: bool
    """ Mute expanded settings for the modifier

    :type: bool
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SequenceProxy(bpy_struct):
    """Proxy parameters for a sequence strip"""

    build_100: bool
    """ Build 100% proxy resolution

    :type: bool
    """

    build_25: bool
    """ Build 25% proxy resolution

    :type: bool
    """

    build_50: bool
    """ Build 50% proxy resolution

    :type: bool
    """

    build_75: bool
    """ Build 75% proxy resolution

    :type: bool
    """

    build_free_run: bool
    """ Build free run time code index

    :type: bool
    """

    build_free_run_rec_date: bool
    """ Build free run time code index using Record Date/Time

    :type: bool
    """

    build_record_run: bool
    """ Build record run time code index

    :type: bool
    """

    directory: typing.Union[str, typing.Any]
    """ Location to store the proxy files

    :type: typing.Union[str, typing.Any]
    """

    filepath: typing.Union[str, typing.Any]
    """ Location of custom proxy file

    :type: typing.Union[str, typing.Any]
    """

    quality: int
    """ Quality of proxies to build

    :type: int
    """

    timecode: typing.Union[int, str]
    """ Method for reading the inputs timecode

    :type: typing.Union[int, str]
    """

    use_overwrite: bool
    """ Overwrite existing proxy files when building

    :type: bool
    """

    use_proxy_custom_directory: bool
    """ Use a custom directory to store data

    :type: bool
    """

    use_proxy_custom_file: bool
    """ Use a custom file to read proxy data from

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SequenceTimelineChannel(bpy_struct):
    lock: bool
    """ 

    :type: bool
    """

    mute: bool
    """ 

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SequenceTransform(bpy_struct):
    """Transform parameters for a sequence strip"""

    filter: typing.Union[int, str]
    """ Type of filter to use for image transformation

    :type: typing.Union[int, str]
    """

    offset_x: float
    """ Move along X axis

    :type: float
    """

    offset_y: float
    """ Move along Y axis

    :type: float
    """

    origin: bpy_prop_array[float]
    """ Origin of image for transformation

    :type: bpy_prop_array[float]
    """

    rotation: float
    """ Rotate around image center

    :type: float
    """

    scale_x: float
    """ Scale along X axis

    :type: float
    """

    scale_y: float
    """ Scale along Y axis

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SequencerPreviewOverlay(bpy_struct):
    show_annotation: bool
    """ Show annotations for this view

    :type: bool
    """

    show_cursor: bool
    """ 

    :type: bool
    """

    show_image_outline: bool
    """ 

    :type: bool
    """

    show_metadata: bool
    """ Show metadata of first visible strip

    :type: bool
    """

    show_safe_areas: bool
    """ Show TV title safe and action safe areas in preview

    :type: bool
    """

    show_safe_center: bool
    """ Show safe areas to fit content in a different aspect ratio

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SequencerTimelineOverlay(bpy_struct):
    show_fcurves: bool
    """ Display strip opacity/volume curve

    :type: bool
    """

    show_grid: bool
    """ Show vertical grid lines

    :type: bool
    """

    show_strip_duration: bool
    """ 

    :type: bool
    """

    show_strip_name: bool
    """ 

    :type: bool
    """

    show_strip_offset: bool
    """ Display strip in/out offsets

    :type: bool
    """

    show_strip_retiming: bool
    """ Display retiming keys on top of strips

    :type: bool
    """

    show_strip_source: bool
    """ Display path to source file, or name of source datablock

    :type: bool
    """

    show_strip_tag_color: bool
    """ Display the strip color tags in the sequencer

    :type: bool
    """

    show_thumbnails: bool
    """ Show strip thumbnails

    :type: bool
    """

    waveform_display_style: typing.Union[int, str]
    """ How Waveforms are displayed

    :type: typing.Union[int, str]
    """

    waveform_display_type: typing.Union[int, str]
    """ How Waveforms are displayed

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SequencerToolSettings(bpy_struct):
    fit_method: typing.Union[int, str]
    """ Scale fit method

    :type: typing.Union[int, str]
    """

    overlap_mode: typing.Union[int, str]
    """ How to resolve overlap after transformation

    :type: typing.Union[int, str]
    """

    pivot_point: typing.Union[int, str]
    """ Rotation or scaling pivot point

    :type: typing.Union[int, str]
    """

    snap_distance: int
    """ Maximum distance for snapping in pixels

    :type: int
    """

    snap_ignore_muted: bool
    """ Don't snap to hidden strips

    :type: bool
    """

    snap_ignore_sound: bool
    """ Don't snap to sound strips

    :type: bool
    """

    snap_to_current_frame: bool
    """ Snap to current frame

    :type: bool
    """

    snap_to_hold_offset: bool
    """ Snap to strip hold offsets

    :type: bool
    """

    use_snap_current_frame_to_strips: bool
    """ Snap current frame to strip start or end

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ShaderFx(bpy_struct):
    """Effect affecting the grease pencil object"""

    name: typing.Union[str, typing.Any]
    """ Effect name

    :type: typing.Union[str, typing.Any]
    """

    show_expanded: bool
    """ Set effect expansion in the user interface

    :type: bool
    """

    show_in_editmode: bool
    """ Display effect in Edit mode

    :type: bool
    """

    show_render: bool
    """ Use effect during render

    :type: bool
    """

    show_viewport: bool
    """ Display effect in viewport

    :type: bool
    """

    type: typing.Any
    """ 

    :type: typing.Any
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ShapeKey(bpy_struct):
    """Shape key in a shape keys data-block"""

    data: bpy_prop_collection["UnknownType"]
    """ 

    :type: bpy_prop_collection['UnknownType']
    """

    frame: float
    """ Frame for absolute keys

    :type: float
    """

    interpolation: typing.Union[int, str]
    """ Interpolation type for absolute shape keys

    :type: typing.Union[int, str]
    """

    lock_shape: bool
    """ Protect the shape key from accidental sculpting and editing

    :type: bool
    """

    mute: bool
    """ Toggle this shape key

    :type: bool
    """

    name: typing.Union[str, typing.Any]
    """ Name of Shape Key

    :type: typing.Union[str, typing.Any]
    """

    points: bpy_prop_collection["ShapeKeyPoint"]
    """ Optimized access to shape keys point data, when using foreach_get/foreach_set accessors. (Warning: Does not support legacy Curve shape keys)

    :type: bpy_prop_collection['ShapeKeyPoint']
    """

    relative_key: "ShapeKey"
    """ Shape used as a relative key

    :type: 'ShapeKey'
    """

    slider_max: float
    """ Maximum for slider

    :type: float
    """

    slider_min: float
    """ Minimum for slider

    :type: float
    """

    value: float
    """ Value of shape key at the current frame

    :type: float
    """

    vertex_group: typing.Union[str, typing.Any]
    """ Vertex weight group, to blend with basis shape

    :type: typing.Union[str, typing.Any]
    """

    def normals_vertex_get(self) -> float:
        """Compute local space vertices' normals for this shape key

        :rtype: float
        :return: normals
        """
        ...

    def normals_polygon_get(self) -> float:
        """Compute local space faces' normals for this shape key

        :rtype: float
        :return: normals
        """
        ...

    def normals_split_get(self) -> float:
        """Compute local space face corners' normals for this shape key

        :rtype: float
        :return: normals
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ShapeKeyBezierPoint(bpy_struct):
    """Point in a shape key for Bézier curves"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_left: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_right: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    radius: float
    """ Radius for beveling

    :type: float
    """

    tilt: float
    """ Tilt in 3D View

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ShapeKeyCurvePoint(bpy_struct):
    """Point in a shape key for curves"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    radius: float
    """ Radius for beveling

    :type: float
    """

    tilt: float
    """ Tilt in 3D View

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ShapeKeyPoint(bpy_struct):
    """Point in a shape key"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SimulationStateItem(bpy_struct):
    attribute_domain: typing.Union[int, str]
    """ Attribute domain where the attribute is stored in the simulation state

    :type: typing.Union[int, str]
    """

    color: bpy_prop_array[float]
    """ Color of the corresponding socket type in the node editor

    :type: bpy_prop_array[float]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    socket_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SoftBodySettings(bpy_struct):
    """Soft body simulation settings for an object"""

    aero: int
    """ Make edges 'sail'

    :type: int
    """

    aerodynamics_type: typing.Union[int, str]
    """ Method of calculating aerodynamic interaction

    :type: typing.Union[int, str]
    """

    ball_damp: float
    """ Blending to inelastic collision

    :type: float
    """

    ball_size: float
    """ Absolute ball size or factor if not manually adjusted

    :type: float
    """

    ball_stiff: float
    """ Ball inflating pressure

    :type: float
    """

    bend: float
    """ Bending Stiffness

    :type: float
    """

    choke: int
    """ 'Viscosity' inside collision target

    :type: int
    """

    collision_collection: "Collection"
    """ Limit colliders to this collection

    :type: 'Collection'
    """

    collision_type: typing.Union[int, str]
    """ Choose Collision Type

    :type: typing.Union[int, str]
    """

    damping: float
    """ Edge spring friction

    :type: float
    """

    effector_weights: "EffectorWeights"
    """ 

    :type: 'EffectorWeights'
    """

    error_threshold: float
    """ The Runge-Kutta ODE solver error limit, low value gives more precision, high values speed

    :type: float
    """

    friction: float
    """ General media friction for point movements

    :type: float
    """

    fuzzy: int
    """ Fuzziness while on collision, high values make collision handling faster but less stable

    :type: int
    """

    goal_default: float
    """ Default Goal (vertex target position) value

    :type: float
    """

    goal_friction: float
    """ Goal (vertex target position) friction

    :type: float
    """

    goal_max: float
    """ Goal maximum, vertex weights are scaled to match this range

    :type: float
    """

    goal_min: float
    """ Goal minimum, vertex weights are scaled to match this range

    :type: float
    """

    goal_spring: float
    """ Goal (vertex target position) spring stiffness

    :type: float
    """

    gravity: float
    """ Apply gravitation to point movement

    :type: float
    """

    location_mass_center: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Location of center of mass

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    mass: float
    """ General Mass value

    :type: float
    """

    plastic: int
    """ Permanent deform

    :type: int
    """

    pull: float
    """ Edge spring stiffness when longer than rest length

    :type: float
    """

    push: float
    """ Edge spring stiffness when shorter than rest length

    :type: float
    """

    rotation_estimate: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
        ],
    ]
    """ Estimated rotation matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]]]
    """

    scale_estimate: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
        ],
    ]
    """ Estimated scale matrix

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]]]
    """

    shear: float
    """ Shear Stiffness

    :type: float
    """

    speed: float
    """ Tweak timing for physics to control frequency and speed

    :type: float
    """

    spring_length: int
    """ Alter spring length to shrink/blow up (unit %) 0 to disable

    :type: int
    """

    step_max: int
    """ Maximal # solver steps/frame

    :type: int
    """

    step_min: int
    """ Minimal # solver steps/frame

    :type: int
    """

    use_auto_step: bool
    """ Use velocities for automagic step sizes

    :type: bool
    """

    use_diagnose: bool
    """ Turn on SB diagnose console prints

    :type: bool
    """

    use_edge_collision: bool
    """ Edges collide too

    :type: bool
    """

    use_edges: bool
    """ Use Edges as springs

    :type: bool
    """

    use_estimate_matrix: bool
    """ Store the estimated transforms in the soft body settings

    :type: bool
    """

    use_face_collision: bool
    """ Faces collide too, can be very slow

    :type: bool
    """

    use_goal: bool
    """ Define forces for vertices to stick to animated position

    :type: bool
    """

    use_self_collision: bool
    """ Enable naive vertex ball self collision

    :type: bool
    """

    use_stiff_quads: bool
    """ Add diagonal springs on 4-gons

    :type: bool
    """

    vertex_group_goal: typing.Union[str, typing.Any]
    """ Control point weight values

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_mass: typing.Union[str, typing.Any]
    """ Control point mass values

    :type: typing.Union[str, typing.Any]
    """

    vertex_group_spring: typing.Union[str, typing.Any]
    """ Control point spring strength values

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Space(bpy_struct):
    """Space data for a screen area"""

    show_locked_time: bool
    """ Synchronize the visible timeline range with other time-based editors

    :type: bool
    """

    show_region_header: bool
    """ 

    :type: bool
    """

    type: typing.Any
    """ Space data type

    :type: typing.Any
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

    def draw_handler_add(
        self,
        callback: typing.Optional[typing.Any],
        args: typing.Optional[typing.Tuple],
        region_type: typing.Optional[str],
        draw_type: typing.Optional[str],
    ) -> typing.Any:
        """Add a new draw handler to this space type.
        It will be called every time the specified region in the space type will be drawn.
        Note: All arguments are positional only for now.

                :param callback: A function that will be called when the region is drawn.
        It gets the specified arguments as input.
                :type callback: typing.Optional[typing.Any]
                :param args: Arguments that will be passed to the callback.
                :type args: typing.Optional[typing.Tuple]
                :param region_type: The region type the callback draws in; usually WINDOW. (`bpy.types.Region.type`)
                :type region_type: typing.Optional[str]
                :param draw_type: Usually POST_PIXEL for 2D drawing and POST_VIEW for 3D drawing. In some cases PRE_VIEW can be used. BACKDROP can be used for backdrops in the node editor.
                :type draw_type: typing.Optional[str]
                :rtype: typing.Any
                :return: Handler that can be removed later on.
        """
        ...

    def draw_handler_remove(
        self, handler: typing.Optional[typing.Any], region_type: typing.Optional[str]
    ):
        """Remove a draw handler that was added previously.

        :param handler: The draw handler that should be removed.
        :type handler: typing.Optional[typing.Any]
        :param region_type: Region type the callback was added to.
        :type region_type: typing.Optional[str]
        """
        ...

class SpaceImageOverlay(bpy_struct):
    """Settings for display of overlays in the UV/Image editor"""

    show_grid_background: bool
    """ Show the grid background and borders

    :type: bool
    """

    show_overlays: bool
    """ Display overlays like UV Maps and Metadata

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SpaceNodeOverlay(bpy_struct):
    """Settings for display of overlays in the Node Editor"""

    preview_shape: typing.Union[int, str]
    """ Preview shape used by the node previews

    :type: typing.Union[int, str]
    """

    show_context_path: bool
    """ Display breadcrumbs for the editor's context

    :type: bool
    """

    show_named_attributes: bool
    """ Show when nodes are using named attributes

    :type: bool
    """

    show_overlays: bool
    """ Display overlays like colored or dashed wires

    :type: bool
    """

    show_previews: bool
    """ Display each node's preview if node is toggled

    :type: bool
    """

    show_timing: bool
    """ Display each node's last execution time

    :type: bool
    """

    show_wire_color: bool
    """ Color node links based on their connected sockets

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SpaceUVEditor(bpy_struct):
    """UV editor data for the image editor space"""

    custom_grid_subdivisions: bpy_prop_array[int]
    """ Number of grid units in UV space that make one UV Unit

    :type: bpy_prop_array[int]
    """

    display_stretch_type: typing.Union[int, str]
    """ Type of stretch to display

    :type: typing.Union[int, str]
    """

    edge_display_type: typing.Union[int, str]
    """ Display style for UV edges

    :type: typing.Union[int, str]
    """

    grid_shape_source: typing.Union[int, str]
    """ Specify source for the grid shape

    :type: typing.Union[int, str]
    """

    lock_bounds: bool
    """ Constraint to stay within the image bounds while editing

    :type: bool
    """

    pixel_round_mode: typing.Union[int, str]
    """ Round UVs to pixels while editing

    :type: typing.Union[int, str]
    """

    show_faces: bool
    """ Display faces over the image

    :type: bool
    """

    show_grid_over_image: bool
    """ Show the grid over the image

    :type: bool
    """

    show_metadata: bool
    """ Display metadata properties of the image

    :type: bool
    """

    show_modified_edges: bool
    """ Display edges after modifiers are applied

    :type: bool
    """

    show_pixel_coords: bool
    """ Display UV coordinates in pixels rather than from 0.0 to 1.0

    :type: bool
    """

    show_stretch: bool
    """ Display faces colored according to the difference in shape between UVs and their 3D coordinates (blue for low distortion, red for high distortion)

    :type: bool
    """

    show_texpaint: bool
    """ Display overlay of texture paint UV layer

    :type: bool
    """

    tile_grid_shape: bpy_prop_array[int]
    """ How many tiles will be shown in the background

    :type: bpy_prop_array[int]
    """

    use_live_unwrap: bool
    """ Continuously unwrap the selected UV island while transforming pinned vertices

    :type: bool
    """

    uv_opacity: float
    """ Opacity of UV overlays

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Spline(bpy_struct):
    """Element of a curve, either NURBS, Bézier or Polyline or a character with text objects"""

    bezier_points: "SplineBezierPoints"
    """ Collection of points for Bézier curves only

    :type: 'SplineBezierPoints'
    """

    character_index: int
    """ Location of this character in the text data (only for text curves)

    :type: int
    """

    hide: bool
    """ Hide this curve in Edit mode

    :type: bool
    """

    material_index: int
    """ Material slot index of this curve

    :type: int
    """

    order_u: int
    """ NURBS order in the U direction. Higher values make each point influence a greater area, but have worse performance

    :type: int
    """

    order_v: int
    """ NURBS order in the V direction. Higher values make each point influence a greater area, but have worse performance

    :type: int
    """

    point_count_u: int
    """ Total number points for the curve or surface in the U direction

    :type: int
    """

    point_count_v: int
    """ Total number points for the surface on the V direction

    :type: int
    """

    points: "SplinePoints"
    """ Collection of points that make up this poly or nurbs spline

    :type: 'SplinePoints'
    """

    radius_interpolation: typing.Union[int, str]
    """ The type of radius interpolation for Bézier curves

    :type: typing.Union[int, str]
    """

    resolution_u: int
    """ Curve or Surface subdivisions per segment

    :type: int
    """

    resolution_v: int
    """ Surface subdivisions per segment

    :type: int
    """

    tilt_interpolation: typing.Union[int, str]
    """ The type of tilt interpolation for 3D, Bézier curves

    :type: typing.Union[int, str]
    """

    type: typing.Union[int, str]
    """ The interpolation type for this curve element

    :type: typing.Union[int, str]
    """

    use_bezier_u: bool
    """ Make this nurbs curve or surface act like a Bézier spline in the U direction

    :type: bool
    """

    use_bezier_v: bool
    """ Make this nurbs surface act like a Bézier spline in the V direction

    :type: bool
    """

    use_cyclic_u: bool
    """ Make this curve or surface a closed loop in the U direction

    :type: bool
    """

    use_cyclic_v: bool
    """ Make this surface a closed loop in the V direction

    :type: bool
    """

    use_endpoint_u: bool
    """ Make this nurbs curve or surface meet the endpoints in the U direction

    :type: bool
    """

    use_endpoint_v: bool
    """ Make this nurbs surface meet the endpoints in the V direction

    :type: bool
    """

    use_smooth: bool
    """ Smooth the normals of the surface or beveled curve

    :type: bool
    """

    def calc_length(self, resolution: typing.Optional[typing.Any] = 0) -> float:
        """Calculate spline length

        :param resolution: Resolution, Spline resolution to be used, 0 defaults to the resolution_u
        :type resolution: typing.Optional[typing.Any]
        :rtype: float
        :return: Length, Length of the polygonaly approximated spline
        """
        ...

    def valid_message(self, direction: typing.Optional[int]) -> str:
        """Return the message

        :param direction: Direction, The direction where 0-1 maps to U-V
        :type direction: typing.Optional[int]
        :rtype: str
        :return: Return value, The message or an empty string when there is no error
        """
        ...

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SplinePoint(bpy_struct):
    """Spline point without handles"""

    co: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float, float]
    ]
    """ Point coordinates

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float, float]]
    """

    hide: bool
    """ Visibility status

    :type: bool
    """

    radius: float
    """ Radius for beveling

    :type: float
    """

    select: bool
    """ Selection status

    :type: bool
    """

    tilt: float
    """ Tilt in 3D View

    :type: float
    """

    weight: float
    """ NURBS weight

    :type: float
    """

    weight_softbody: float
    """ Softbody goal weight

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SpreadsheetColumn(bpy_struct):
    """Persistent data associated with a spreadsheet column"""

    data_type: typing.Union[int, str]
    """ The data type of the corresponding column visible in the spreadsheet

    :type: typing.Union[int, str]
    """

    id: "SpreadsheetColumnID"
    """ Data used to identify the corresponding data from the data source

    :type: 'SpreadsheetColumnID'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SpreadsheetColumnID(bpy_struct):
    """Data used to identify a spreadsheet column"""

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class SpreadsheetRowFilter(bpy_struct):
    column_name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    enabled: bool
    """ 

    :type: bool
    """

    operation: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    show_expanded: bool
    """ 

    :type: bool
    """

    threshold: float
    """ How close float values need to be to be equal

    :type: float
    """

    value_boolean: bool
    """ 

    :type: bool
    """

    value_color: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    value_float: float
    """ 

    :type: float
    """

    value_float2: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    value_float3: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    value_int: int
    """ 

    :type: int
    """

    value_int2: bpy_prop_array[int]
    """ 

    :type: bpy_prop_array[int]
    """

    value_int8: int
    """ 

    :type: int
    """

    value_string: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Stereo3dDisplay(bpy_struct):
    """Settings for stereo 3D display"""

    anaglyph_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    display_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    interlace_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    use_interlace_swap: bool
    """ Swap left and right stereo channels

    :type: bool
    """

    use_sidebyside_crosseyed: bool
    """ Right eye should see left image and vice versa

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Stereo3dFormat(bpy_struct):
    """Settings for stereo output"""

    anaglyph_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    display_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    interlace_type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    use_interlace_swap: bool
    """ Swap left and right stereo channels

    :type: bool
    """

    use_sidebyside_crosseyed: bool
    """ Right eye should see left image and vice versa

    :type: bool
    """

    use_squeezed_frame: bool
    """ Combine both views in a squeezed image

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class StringAttributeValue(bpy_struct):
    """String value in geometry attribute"""

    value: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Struct(bpy_struct):
    """RNA structure definition"""

    base: "Struct"
    """ Struct definition this is derived from

    :type: 'Struct'
    """

    description: typing.Union[str, typing.Any]
    """ Description of the Struct's purpose

    :type: typing.Union[str, typing.Any]
    """

    functions: bpy_prop_collection["Function"]
    """ 

    :type: bpy_prop_collection['Function']
    """

    identifier: typing.Union[str, typing.Any]
    """ Unique name used in the code and scripting

    :type: typing.Union[str, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Human readable name

    :type: typing.Union[str, typing.Any]
    """

    name_property: "StringProperty"
    """ Property that gives the name of the struct

    :type: 'StringProperty'
    """

    nested: "Struct"
    """ Struct in which this struct is always nested, and to which it logically belongs

    :type: 'Struct'
    """

    properties: bpy_prop_collection["Property"]
    """ Properties in the struct

    :type: bpy_prop_collection['Property']
    """

    property_tags: bpy_prop_collection["EnumPropertyItem"]
    """ Tags that properties can use to influence behavior

    :type: bpy_prop_collection['EnumPropertyItem']
    """

    translation_context: typing.Union[str, typing.Any]
    """ Translation context of the struct's name

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class StudioLight(bpy_struct):
    """Studio light"""

    has_specular_highlight_pass: typing.Union[bool, typing.Any]
    """ Studio light image file has separate "diffuse" and "specular" passes

    :type: typing.Union[bool, typing.Any]
    """

    index: int
    """ 

    :type: int
    """

    is_user_defined: typing.Union[bool, typing.Any]
    """ 

    :type: typing.Union[bool, typing.Any]
    """

    light_ambient: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of the ambient light that uniformly lit the scene

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    path: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    solid_lights: bpy_prop_collection["UserSolidLight"]
    """ Lights used to display objects in solid draw mode

    :type: bpy_prop_collection['UserSolidLight']
    """

    type: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class TexMapping(bpy_struct):
    """Texture coordinate mapping settings"""

    mapping: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    mapping_x: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    mapping_y: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    mapping_z: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    max: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Maximum value for clipping

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    min: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Minimum value for clipping

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    rotation: typing.Union[
        "mathutils.Euler", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Euler', typing.List[float], typing.Tuple[float, float, float]]
    """

    scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    translation: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    use_max: bool
    """ Whether to use maximum clipping value

    :type: bool
    """

    use_min: bool
    """ Whether to use minimum clipping value

    :type: bool
    """

    vector_type: typing.Union[int, str]
    """ Type of vector that the mapping transforms

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class TexPaintSlot(bpy_struct):
    """Slot that contains information about texture painting"""

    icon_value: int
    """ Paint slot icon

    :type: int
    """

    is_valid: typing.Union[bool, typing.Any]
    """ Slot has a valid image and UV map

    :type: typing.Union[bool, typing.Any]
    """

    name: typing.Union[str, typing.Any]
    """ Name of the slot

    :type: typing.Union[str, typing.Any]
    """

    uv_layer: typing.Union[str, typing.Any]
    """ Name of UV map

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class TextBox(bpy_struct):
    """Text bounding box for layout"""

    height: float
    """ 

    :type: float
    """

    width: float
    """ 

    :type: float
    """

    x: float
    """ 

    :type: float
    """

    y: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class TextCharacterFormat(bpy_struct):
    """Text character formatting settings"""

    kerning: float
    """ Spacing between characters

    :type: float
    """

    material_index: int
    """ Material slot index of this character

    :type: int
    """

    use_bold: bool
    """ 

    :type: bool
    """

    use_italic: bool
    """ 

    :type: bool
    """

    use_small_caps: bool
    """ 

    :type: bool
    """

    use_underline: bool
    """ 

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class TextLine(bpy_struct):
    """Line of text in a Text data-block"""

    body: typing.Union[str, typing.Any]
    """ Text in the line

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class TextureSlot(bpy_struct):
    """Texture slot defining the mapping and influence of a texture"""

    blend_type: typing.Union[int, str]
    """ Mode used to apply the texture

    :type: typing.Union[int, str]
    """

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Default color for textures that don't return RGB or when RGB to intensity is enabled

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    default_value: float
    """ Value to use for Ref, Spec, Amb, Emit, Alpha, RayMir, TransLu and Hard

    :type: float
    """

    name: typing.Union[str, typing.Any]
    """ Texture slot name

    :type: typing.Union[str, typing.Any]
    """

    offset: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Fine tune of the texture mapping X, Y and Z locations

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    output_node: typing.Union[int, str]
    """ Which output node to use, for node-based textures

    :type: typing.Union[int, str]
    """

    scale: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Set scaling for the texture's X, Y and Z sizes

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    texture: "Texture"
    """ Texture data-block used by this texture slot

    :type: 'Texture'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Theme(bpy_struct):
    """User interface styling and color settings"""

    bone_color_sets: bpy_prop_collection["ThemeBoneColorSet"]
    """ 

    :type: bpy_prop_collection['ThemeBoneColorSet']
    """

    clip_editor: "ThemeClipEditor"
    """ 

    :type: 'ThemeClipEditor'
    """

    collection_color: bpy_prop_collection["ThemeCollectionColor"]
    """ 

    :type: bpy_prop_collection['ThemeCollectionColor']
    """

    console: "ThemeConsole"
    """ 

    :type: 'ThemeConsole'
    """

    dopesheet_editor: "ThemeDopeSheet"
    """ 

    :type: 'ThemeDopeSheet'
    """

    file_browser: "ThemeFileBrowser"
    """ 

    :type: 'ThemeFileBrowser'
    """

    graph_editor: "ThemeGraphEditor"
    """ 

    :type: 'ThemeGraphEditor'
    """

    image_editor: "ThemeImageEditor"
    """ 

    :type: 'ThemeImageEditor'
    """

    info: "ThemeInfo"
    """ 

    :type: 'ThemeInfo'
    """

    name: typing.Union[str, typing.Any]
    """ Name of the theme

    :type: typing.Union[str, typing.Any]
    """

    nla_editor: "ThemeNLAEditor"
    """ 

    :type: 'ThemeNLAEditor'
    """

    node_editor: "ThemeNodeEditor"
    """ 

    :type: 'ThemeNodeEditor'
    """

    outliner: "ThemeOutliner"
    """ 

    :type: 'ThemeOutliner'
    """

    preferences: "ThemePreferences"
    """ 

    :type: 'ThemePreferences'
    """

    properties: "ThemeProperties"
    """ 

    :type: 'ThemeProperties'
    """

    sequence_editor: "ThemeSequenceEditor"
    """ 

    :type: 'ThemeSequenceEditor'
    """

    spreadsheet: "ThemeSpreadsheet"
    """ 

    :type: 'ThemeSpreadsheet'
    """

    statusbar: "ThemeStatusBar"
    """ 

    :type: 'ThemeStatusBar'
    """

    strip_color: bpy_prop_collection["ThemeStripColor"]
    """ 

    :type: bpy_prop_collection['ThemeStripColor']
    """

    text_editor: "ThemeTextEditor"
    """ 

    :type: 'ThemeTextEditor'
    """

    theme_area: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    topbar: "ThemeTopBar"
    """ 

    :type: 'ThemeTopBar'
    """

    user_interface: "ThemeUserInterface"
    """ 

    :type: 'ThemeUserInterface'
    """

    view_3d: "ThemeView3D"
    """ 

    :type: 'ThemeView3D'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeAssetShelf(bpy_struct):
    """Theme settings for asset shelves"""

    back: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    header_back: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeBoneColorSet(bpy_struct):
    """Theme settings for bone color sets"""

    active: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color used for active bones

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    normal: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color used for the surface of bones

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    select: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color used for selected bones

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    show_colored_constraints: bool
    """ Allow the use of colors indicating constraints/keyed status

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeClipEditor(bpy_struct):
    """Theme settings for the Movie Clip Editor"""

    active_marker: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of active marker

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    disabled_marker: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of disabled marker

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    frame_current: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    grid: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    handle_align: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_auto: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_auto_clamped: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_free: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_align: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_auto: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_auto_clamped: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_free: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_vertex: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_vertex_select: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_vertex_size: int
    """ 

    :type: int
    """

    locked_marker: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of locked marker

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    marker: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of marker

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    marker_outline: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of marker's outline

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    metadatabg: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    metadatatext: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    path_after: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of path after current frame

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    path_before: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of path before current frame

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    path_keyframe_after: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of path after current frame

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    path_keyframe_before: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of path before current frame

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    selected_marker: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of selected marker

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    space_list: "ThemeSpaceListGeneric"
    """ Settings for space list

    :type: 'ThemeSpaceListGeneric'
    """

    strips: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    strips_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    time_marker_line: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    time_marker_line_selected: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    time_scrub_background: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeCollectionColor(bpy_struct):
    """Theme settings for collection colors"""

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Collection Color Tag

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeConsole(bpy_struct):
    """Theme settings for the Console"""

    cursor: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    line_error: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    line_info: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    line_input: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    line_output: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    select: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeDopeSheet(bpy_struct):
    """Theme settings for the Dope Sheet"""

    active_channels_group: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    channel_group: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    channels: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    channels_selected: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    dopesheet_channel: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    dopesheet_subchannel: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    frame_current: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    grid: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    interpolation_line: bpy_prop_array[float]
    """ Color of lines showing non-Bézier interpolation modes

    :type: bpy_prop_array[float]
    """

    keyframe: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of Keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_border: bpy_prop_array[float]
    """ Color of keyframe border

    :type: bpy_prop_array[float]
    """

    keyframe_border_selected: bpy_prop_array[float]
    """ Color of selected keyframe border

    :type: bpy_prop_array[float]
    """

    keyframe_breakdown: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of breakdown keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_breakdown_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of selected breakdown keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_extreme: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of extreme keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_extreme_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of selected extreme keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_jitter: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of jitter keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_jitter_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of selected jitter keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_movehold: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of moving hold keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_movehold_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of selected moving hold keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_scale_factor: float
    """ Scale factor for adjusting the height of keyframes

    :type: float
    """

    keyframe_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of selected keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    long_key: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    long_key_selected: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    preview_range: bpy_prop_array[float]
    """ Color of preview range overlay

    :type: bpy_prop_array[float]
    """

    simulated_frames: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    space_list: "ThemeSpaceListGeneric"
    """ Settings for space list

    :type: 'ThemeSpaceListGeneric'
    """

    summary: bpy_prop_array[float]
    """ Color of summary channel

    :type: bpy_prop_array[float]
    """

    time_marker_line: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    time_marker_line_selected: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    time_scrub_background: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    value_sliders: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    view_sliders: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeFileBrowser(bpy_struct):
    """Theme settings for the File Browser"""

    row_alternate: bpy_prop_array[float]
    """ Overlay color on every other row

    :type: bpy_prop_array[float]
    """

    selected_file: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeFontStyle(bpy_struct):
    """Theme settings for Font"""

    character_weight: int
    """ Weight of the characters. 100-900, 400 is normal

    :type: int
    """

    points: float
    """ Font size in points

    :type: float
    """

    shadow: int
    """ Shadow size (0, 3 and 5 supported)

    :type: int
    """

    shadow_alpha: float
    """ 

    :type: float
    """

    shadow_offset_x: int
    """ Shadow offset in pixels

    :type: int
    """

    shadow_offset_y: int
    """ Shadow offset in pixels

    :type: int
    """

    shadow_value: float
    """ Shadow color in gray value

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeGradientColors(bpy_struct):
    """Theme settings for background colors and gradient"""

    background_type: typing.Union[int, str]
    """ Type of background in the 3D viewport

    :type: typing.Union[int, str]
    """

    gradient: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    high_gradient: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeGraphEditor(bpy_struct):
    """Theme settings for the graph editor"""

    active_channels_group: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    channel_group: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    channels_region: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    dopesheet_channel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    dopesheet_subchannel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    frame_current: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    grid: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_align: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_auto: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_auto_clamped: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_free: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_align: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_auto: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_auto_clamped: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_free: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_vect: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_vect: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_vertex: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_vertex_select: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_vertex_size: int
    """ 

    :type: int
    """

    lastsel_point: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    preview_range: bpy_prop_array[float]
    """ Color of preview range overlay

    :type: bpy_prop_array[float]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    space_list: "ThemeSpaceListGeneric"
    """ Settings for space list

    :type: 'ThemeSpaceListGeneric'
    """

    time_marker_line: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    time_marker_line_selected: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    time_scrub_background: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    vertex: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_active: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_bevel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_select: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_size: int
    """ 

    :type: int
    """

    vertex_unreferenced: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    window_sliders: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeImageEditor(bpy_struct):
    """Theme settings for the Image Editor"""

    edge_select: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    edge_width: int
    """ 

    :type: int
    """

    editmesh_active: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    face: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    face_back: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    face_dot: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    face_front: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    face_mode_select: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    face_retopology: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    face_select: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    facedot_size: int
    """ 

    :type: int
    """

    frame_current: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    freestyle_face_mark: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    grid: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    handle_align: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_auto: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_auto_clamped: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_free: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_align: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_auto: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_auto_clamped: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_free: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_vertex: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_vertex_select: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_vertex_size: int
    """ 

    :type: int
    """

    metadatabg: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    metadatatext: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    paint_curve_handle: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    paint_curve_pivot: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    preview_stitch_active: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    preview_stitch_edge: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    preview_stitch_face: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    preview_stitch_stitchable: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    preview_stitch_unstitchable: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    preview_stitch_vert: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    scope_back: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    uv_shadow: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    vertex: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_active: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_bevel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_select: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_size: int
    """ 

    :type: int
    """

    vertex_unreferenced: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    wire_edit: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeInfo(bpy_struct):
    """Theme settings for Info"""

    info_debug: bpy_prop_array[float]
    """ Background color of Debug icon

    :type: bpy_prop_array[float]
    """

    info_debug_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Foreground color of Debug icon

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    info_error: bpy_prop_array[float]
    """ Background color of Error icon

    :type: bpy_prop_array[float]
    """

    info_error_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Foreground color of Error icon

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    info_info: bpy_prop_array[float]
    """ Background color of Info icon

    :type: bpy_prop_array[float]
    """

    info_info_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Foreground color of Info icon

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    info_operator: bpy_prop_array[float]
    """ Background color of Operator icon

    :type: bpy_prop_array[float]
    """

    info_operator_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Foreground color of Operator icon

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    info_property: bpy_prop_array[float]
    """ Background color of Property icon

    :type: bpy_prop_array[float]
    """

    info_property_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Foreground color of Property icon

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    info_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Background color of selected line

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    info_selected_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Text color of selected line

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    info_warning: bpy_prop_array[float]
    """ Background color of Warning icon

    :type: bpy_prop_array[float]
    """

    info_warning_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Foreground color of Warning icon

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeNLAEditor(bpy_struct):
    """Theme settings for the NLA Editor"""

    active_action: bpy_prop_array[float]
    """ Animation data-block has active action

    :type: bpy_prop_array[float]
    """

    active_action_unset: bpy_prop_array[float]
    """ Animation data-block doesn't have active action

    :type: bpy_prop_array[float]
    """

    dopesheet_channel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Nonlinear Animation Channel

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    dopesheet_subchannel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    frame_current: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    grid: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_border: bpy_prop_array[float]
    """ Color of keyframe border

    :type: bpy_prop_array[float]
    """

    keyframe_border_selected: bpy_prop_array[float]
    """ Color of selected keyframe border

    :type: bpy_prop_array[float]
    """

    meta_strips: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Unselected Meta Strip (for grouping related strips)

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    meta_strips_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Selected Meta Strip (for grouping related strips)

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    nla_track: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Nonlinear Animation Track

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    preview_range: bpy_prop_array[float]
    """ Color of preview range overlay

    :type: bpy_prop_array[float]
    """

    sound_strips: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Unselected Sound Strip (for timing speaker sounds)

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    sound_strips_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Selected Sound Strip (for timing speaker sounds)

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    space_list: "ThemeSpaceListGeneric"
    """ Settings for space list

    :type: 'ThemeSpaceListGeneric'
    """

    strips: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Unselected Action-Clip Strip

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    strips_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Selected Action-Clip Strip

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    time_marker_line: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    time_marker_line_selected: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    time_scrub_background: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    transition_strips: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Unselected Transition Strip

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    transition_strips_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Selected Transition Strip

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    tweak: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color for strip/action being "tweaked" or edited

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    tweak_duplicate: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Warning/error indicator color for strips referencing the strip being tweaked

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    view_sliders: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeNodeEditor(bpy_struct):
    """Theme settings for the Node Editor"""

    attribute_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    color_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    converter_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    dash_alpha: float
    """ Opacity for the dashed lines in wires

    :type: float
    """

    distor_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    filter_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    frame_node: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    geometry_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    grid: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    grid_levels: int
    """ Number of subdivisions for the dot grid displayed in the background

    :type: int
    """

    group_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    group_socket_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    input_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    layout_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    matte_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    node_active: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    node_backdrop: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    node_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    noodle_curving: int
    """ Curving of the noodle

    :type: int
    """

    output_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    pattern_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    repeat_zone: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    script_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    selected_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    shader_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    simulation_zone: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    space_list: "ThemeSpaceListGeneric"
    """ Settings for space list

    :type: 'ThemeSpaceListGeneric'
    """

    texture_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vector_node: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    wire: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    wire_inner: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    wire_select: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeOutliner(bpy_struct):
    """Theme settings for the Outliner"""

    active: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    active_object: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    edited_object: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    match: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    row_alternate: bpy_prop_array[float]
    """ Overlay color on every other row

    :type: bpy_prop_array[float]
    """

    selected_highlight: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    selected_object: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemePanelColors(bpy_struct):
    """Theme settings for panel colors"""

    back: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    header: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    sub_back: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemePreferences(bpy_struct):
    """Theme settings for the Blender Preferences"""

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeProperties(bpy_struct):
    """Theme settings for the Properties"""

    active_modifier: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    match: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeSequenceEditor(bpy_struct):
    """Theme settings for the Sequence Editor"""

    active_strip: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    audio_strip: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    color_strip: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    draw_action: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    effect_strip: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    frame_current: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    grid: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    image_strip: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of Keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_border: bpy_prop_array[float]
    """ Color of keyframe border

    :type: bpy_prop_array[float]
    """

    keyframe_border_selected: bpy_prop_array[float]
    """ Color of selected keyframe border

    :type: bpy_prop_array[float]
    """

    keyframe_breakdown: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of breakdown keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_breakdown_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of selected breakdown keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_movehold: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of moving hold keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_movehold_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of selected moving hold keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    keyframe_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of selected keyframe

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    mask_strip: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    meta_strip: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    metadatabg: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    metadatatext: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    movie_strip: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    movieclip_strip: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    preview_back: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    preview_range: bpy_prop_array[float]
    """ Color of preview range overlay

    :type: bpy_prop_array[float]
    """

    row_alternate: bpy_prop_array[float]
    """ Overlay color on every other row

    :type: bpy_prop_array[float]
    """

    scene_strip: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    selected_strip: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    space_list: "ThemeSpaceListGeneric"
    """ Settings for space list

    :type: 'ThemeSpaceListGeneric'
    """

    text_strip: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    time_marker_line: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    time_marker_line_selected: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    time_scrub_background: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    transition_strip: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    window_sliders: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeSpaceGeneric(bpy_struct):
    back: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    button: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    button_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    button_text_hi: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    button_title: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    execution_buts: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    header: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    header_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    header_text_hi: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    navigation_bar: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    panelcolors: "ThemePanelColors"
    """ 

    :type: 'ThemePanelColors'
    """

    tab_active: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    tab_back: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    tab_inactive: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    tab_outline: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    text_hi: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    title: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeSpaceGradient(bpy_struct):
    button: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    button_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    button_text_hi: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    button_title: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    execution_buts: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    gradients: "ThemeGradientColors"
    """ 

    :type: 'ThemeGradientColors'
    """

    header: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    header_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    header_text_hi: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    navigation_bar: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    panelcolors: "ThemePanelColors"
    """ 

    :type: 'ThemePanelColors'
    """

    tab_active: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    tab_back: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    tab_inactive: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    tab_outline: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    text_hi: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    title: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeSpaceListGeneric(bpy_struct):
    list: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    list_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    list_text_hi: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    list_title: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeSpreadsheet(bpy_struct):
    """Theme settings for the Spreadsheet"""

    row_alternate: bpy_prop_array[float]
    """ Overlay color on every other row

    :type: bpy_prop_array[float]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    space_list: "ThemeSpaceListGeneric"
    """ Settings for space list

    :type: 'ThemeSpaceListGeneric'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeStatusBar(bpy_struct):
    """Theme settings for the Status Bar"""

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeStripColor(bpy_struct):
    """Theme settings for strip colors"""

    color: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Strip Color

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeStyle(bpy_struct):
    """Theme settings for style sets"""

    panel_title: "ThemeFontStyle"
    """ 

    :type: 'ThemeFontStyle'
    """

    widget: "ThemeFontStyle"
    """ 

    :type: 'ThemeFontStyle'
    """

    widget_label: "ThemeFontStyle"
    """ 

    :type: 'ThemeFontStyle'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeTextEditor(bpy_struct):
    """Theme settings for the Text Editor"""

    cursor: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    line_numbers: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    line_numbers_background: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    selected_text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    syntax_builtin: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    syntax_comment: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    syntax_numbers: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    syntax_preprocessor: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    syntax_reserved: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    syntax_special: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    syntax_string: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    syntax_symbols: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeTopBar(bpy_struct):
    """Theme settings for the Top Bar"""

    space: "ThemeSpaceGeneric"
    """ Settings for space

    :type: 'ThemeSpaceGeneric'
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeUserInterface(bpy_struct):
    """Theme settings for user interface elements"""

    axis_x: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    axis_y: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    axis_z: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    editor_outline: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of the outline of the editors and their round corners

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    gizmo_a: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    gizmo_b: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    gizmo_hi: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    gizmo_primary: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    gizmo_secondary: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    gizmo_view_align: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    icon_alpha: float
    """ Transparency of icons in the interface, to reduce contrast

    :type: float
    """

    icon_border_intensity: float
    """ Control the intensity of the border around themes icons

    :type: float
    """

    icon_collection: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    icon_folder: bpy_prop_array[float]
    """ Color of folders in the file browser

    :type: bpy_prop_array[float]
    """

    icon_modifier: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    icon_object: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    icon_object_data: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    icon_saturation: float
    """ Saturation of icons in the interface

    :type: float
    """

    icon_scene: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    icon_shading: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    menu_shadow_fac: float
    """ Blending factor for menu shadows

    :type: float
    """

    menu_shadow_width: int
    """ Width of menu shadows, set to zero to disable

    :type: int
    """

    panel_roundness: float
    """ Roundness of the corners of panels and sub-panels

    :type: float
    """

    transparent_checker_primary: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Primary color of checkerboard pattern indicating transparent areas

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    transparent_checker_secondary: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Secondary color of checkerboard pattern indicating transparent areas

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    transparent_checker_size: int
    """ Size of checkerboard pattern indicating transparent areas

    :type: int
    """

    wcol_box: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_list_item: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_menu: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_menu_back: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_menu_item: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_num: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_numslider: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_option: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_pie_menu: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_progress: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_pulldown: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_radio: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_regular: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_scroll: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_state: "ThemeWidgetStateColors"
    """ 

    :type: 'ThemeWidgetStateColors'
    """

    wcol_tab: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_text: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_toggle: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_tool: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_toolbar_item: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    wcol_tooltip: "ThemeWidgetColors"
    """ 

    :type: 'ThemeWidgetColors'
    """

    widget_emboss: bpy_prop_array[float]
    """ Color of the 1px shadow line underlying widgets

    :type: bpy_prop_array[float]
    """

    widget_text_cursor: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color of the text insertion cursor (caret)

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeView3D(bpy_struct):
    """Theme settings for the 3D viewport"""

    act_spline: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    asset_shelf: "ThemeAssetShelf"
    """ Settings for asset shelf

    :type: 'ThemeAssetShelf'
    """

    bone_locked_weight: bpy_prop_array[float]
    """ Shade for bones corresponding to a locked weight group during painting

    :type: bpy_prop_array[float]
    """

    bone_pose: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Outline color of selected pose bones

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    bone_pose_active: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Outline color of active pose bones

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    bone_solid: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Default color of the solid shapes of bones

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    bundle_solid: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    camera: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    camera_passepartout: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    camera_path: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    clipping_border_3d: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    edge_bevel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    edge_crease: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    edge_facesel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    edge_mode_select: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    edge_seam: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    edge_select: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    edge_sharp: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    edge_width: int
    """ 

    :type: int
    """

    editmesh_active: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    empty: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    extra_edge_angle: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    extra_edge_len: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    extra_face_angle: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    extra_face_area: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    face: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    face_back: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    face_dot: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    face_front: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    face_mode_select: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    face_retopology: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    face_select: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    facedot_size: int
    """ 

    :type: int
    """

    frame_current: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    freestyle_edge_mark: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    freestyle_face_mark: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    gp_vertex: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    gp_vertex_select: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    gp_vertex_size: int
    """ 

    :type: int
    """

    grid: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    handle_align: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_auto: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_free: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_align: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_auto: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_free: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_sel_vect: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    handle_vect: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    lastsel_point: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    light: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    normal: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    nurb_sel_uline: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    nurb_sel_vline: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    nurb_uline: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    nurb_vline: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    object_active: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    object_origin_size: int
    """ Diameter in pixels for object/light origin display

    :type: int
    """

    object_selected: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    outline_width: int
    """ 

    :type: int
    """

    paint_curve_handle: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    paint_curve_pivot: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    skin_root: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    space: "ThemeSpaceGradient"
    """ Settings for space

    :type: 'ThemeSpaceGradient'
    """

    speaker: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    split_normal: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    text_grease_pencil: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color for indicating Grease Pencil keyframes

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    text_keyframe: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color for indicating object keyframes

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    transform: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_active: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_bevel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_normal: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_select: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    vertex_size: int
    """ 

    :type: int
    """

    vertex_unreferenced: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    view_overlay: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    wire: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    wire_edit: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Color for wireframe when in edit mode, but edge selection is active

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeWidgetColors(bpy_struct):
    """Theme settings for widget color sets"""

    inner: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    inner_sel: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    item: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    outline: bpy_prop_array[float]
    """ 

    :type: bpy_prop_array[float]
    """

    roundness: float
    """ Amount of edge rounding

    :type: float
    """

    shadedown: int
    """ 

    :type: int
    """

    shadetop: int
    """ 

    :type: int
    """

    show_shaded: bool
    """ 

    :type: bool
    """

    text: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    text_sel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ThemeWidgetStateColors(bpy_struct):
    """Theme settings for widget state colors"""

    blend: float
    """ 

    :type: float
    """

    inner_anim: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    inner_anim_sel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    inner_changed: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    inner_changed_sel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    inner_driven: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    inner_driven_sel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    inner_key: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    inner_key_sel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    inner_overridden: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    inner_overridden_sel: typing.Union[
        "mathutils.Color", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ 

    :type: typing.Union['mathutils.Color', typing.List[float], typing.Tuple[float, float, float]]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class TimeGpencilModifierSegment(bpy_struct):
    """Configuration for a single dash segment"""

    name: typing.Union[str, typing.Any]
    """ Name of the dash segment

    :type: typing.Union[str, typing.Any]
    """

    seg_end: int
    """ Last frame of the segment

    :type: int
    """

    seg_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    seg_repeat: int
    """ Number of cycle repeats

    :type: int
    """

    seg_start: int
    """ First frame of the segment

    :type: int
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class TimelineMarker(bpy_struct):
    """Marker for noting points in the timeline"""

    camera: "Object"
    """ Camera that becomes active on this frame

    :type: 'Object'
    """

    frame: int
    """ The frame on which the timeline marker appears

    :type: int
    """

    name: typing.Union[str, typing.Any]
    """ 

    :type: typing.Union[str, typing.Any]
    """

    select: bool
    """ Marker selection state

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class Timer(bpy_struct):
    """Window event timer"""

    time_delta: float
    """ Time since last step in seconds

    :type: float
    """

    time_duration: float
    """ Time since the timer started seconds

    :type: float
    """

    time_step: float
    """ 

    :type: float
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class ToolSettings(bpy_struct):
    annotation_stroke_placement_view2d: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    annotation_stroke_placement_view3d: typing.Union[int, str]
    """ How annotation strokes are orientated in 3D space

    :type: typing.Union[int, str]
    """

    annotation_thickness: int
    """ Thickness of annotation strokes

    :type: int
    """

    auto_keying_mode: typing.Union[int, str]
    """ Mode of automatic keyframe insertion for Objects, Bones and Masks

    :type: typing.Union[int, str]
    """

    curve_paint_settings: "CurvePaintSettings"
    """ 

    :type: 'CurvePaintSettings'
    """

    curves_sculpt: "CurvesSculpt"
    """ 

    :type: 'CurvesSculpt'
    """

    custom_bevel_profile_preset: "CurveProfile"
    """ Used for defining a profile's path

    :type: 'CurveProfile'
    """

    double_threshold: float
    """ Threshold distance for Auto Merge

    :type: float
    """

    gpencil_interpolate: "GPencilInterpolateSettings"
    """ Settings for Grease Pencil Interpolation tools

    :type: 'GPencilInterpolateSettings'
    """

    gpencil_paint: "GpPaint"
    """ 

    :type: 'GpPaint'
    """

    gpencil_sculpt: "GPencilSculptSettings"
    """ Settings for stroke sculpting tools and brushes

    :type: 'GPencilSculptSettings'
    """

    gpencil_sculpt_paint: "GpSculptPaint"
    """ 

    :type: 'GpSculptPaint'
    """

    gpencil_selectmode_edit: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    gpencil_stroke_placement_view3d: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    gpencil_stroke_snap_mode: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    gpencil_surface_offset: float
    """ Offset along normal when drawing on surfaces

    :type: float
    """

    gpencil_vertex_paint: "GpVertexPaint"
    """ 

    :type: 'GpVertexPaint'
    """

    gpencil_weight_paint: "GpWeightPaint"
    """ 

    :type: 'GpWeightPaint'
    """

    image_paint: "ImagePaint"
    """ 

    :type: 'ImagePaint'
    """

    keyframe_type: typing.Union[int, str]
    """ Type of keyframes to create when inserting keyframes

    :type: typing.Union[int, str]
    """

    lock_markers: bool
    """ Prevent marker editing

    :type: bool
    """

    lock_object_mode: bool
    """ Restrict selection to objects using the same mode as the active object, to prevent accidental mode switch when selecting

    :type: bool
    """

    mesh_select_mode: typing.List[bool]
    """ Which mesh elements selection works on

    :type: typing.List[bool]
    """

    normal_vector: typing.Union[
        "mathutils.Vector", typing.List[float], typing.Tuple[float, float, float]
    ]
    """ Normal Vector used to copy, add or multiply

    :type: typing.Union['mathutils.Vector', typing.List[float], typing.Tuple[float, float, float]]
    """

    paint_mode: "PaintModeSettings"
    """ 

    :type: 'PaintModeSettings'
    """

    particle_edit: "ParticleEdit"
    """ 

    :type: 'ParticleEdit'
    """

    plane_axis: typing.Union[int, str]
    """ The axis used for placing the base region

    :type: typing.Union[int, str]
    """

    plane_axis_auto: bool
    """ Select the closest axis when placing objects (surface overrides)

    :type: bool
    """

    plane_depth: typing.Union[int, str]
    """ The initial depth used when placing the cursor

    :type: typing.Union[int, str]
    """

    plane_orientation: typing.Union[int, str]
    """ The initial depth used when placing the cursor

    :type: typing.Union[int, str]
    """

    proportional_distance: float
    """ Display size for proportional editing circle

    :type: float
    """

    proportional_edit_falloff: typing.Union[int, str]
    """ Falloff type for proportional editing mode

    :type: typing.Union[int, str]
    """

    proportional_size: float
    """ Display size for proportional editing circle

    :type: float
    """

    sculpt: "Sculpt"
    """ 

    :type: 'Sculpt'
    """

    sequencer_tool_settings: "SequencerToolSettings"
    """ 

    :type: 'SequencerToolSettings'
    """

    show_uv_local_view: bool
    """ Display only faces with the currently displayed image assigned

    :type: bool
    """

    snap_anim_element: typing.Union[int, str]
    """ Type of element to snap to

    :type: typing.Union[int, str]
    """

    snap_elements: typing.Union[typing.Set[int], typing.Set[str]]
    """ Type of element to snap to

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    snap_elements_base: typing.Union[typing.Set[int], typing.Set[str]]
    """ Type of element for the 'Snap With' to snap to

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    snap_elements_individual: typing.Union[typing.Set[int], typing.Set[str]]
    """ Type of element for individual transformed elements to snap to

    :type: typing.Union[typing.Set[int], typing.Set[str]]
    """

    snap_elements_tool: typing.Union[int, str]
    """ The target to use while snapping

    :type: typing.Union[int, str]
    """

    snap_face_nearest_steps: int
    """ Number of steps to break transformation into for face nearest snapping

    :type: int
    """

    snap_node_element: typing.Union[int, str]
    """ Type of element to snap to

    :type: typing.Union[int, str]
    """

    snap_target: typing.Union[int, str]
    """ Which part to snap onto the target

    :type: typing.Union[int, str]
    """

    snap_uv_element: typing.Union[int, str]
    """ Type of element to snap to

    :type: typing.Union[int, str]
    """

    statvis: "MeshStatVis"
    """ 

    :type: 'MeshStatVis'
    """

    transform_pivot_point: typing.Union[int, str]
    """ Pivot center for rotation/scaling

    :type: typing.Union[int, str]
    """

    unified_paint_settings: "UnifiedPaintSettings"
    """ 

    :type: 'UnifiedPaintSettings'
    """

    use_auto_normalize: bool
    """ Ensure all bone-deforming vertex groups add up to 1.0 while weight painting

    :type: bool
    """

    use_edge_path_live_unwrap: bool
    """ Changing edge seams recalculates UV unwrap

    :type: bool
    """

    use_gpencil_automerge_strokes: bool
    """ Join by distance last drawn stroke with previous strokes in the active layer

    :type: bool
    """

    use_gpencil_draw_additive: bool
    """ When creating new frames, the strokes from the previous/active frame are included as the basis for the new one

    :type: bool
    """

    use_gpencil_draw_onback: bool
    """ When draw new strokes, the new stroke is drawn below of all strokes in the layer

    :type: bool
    """

    use_gpencil_select_mask_point: bool
    """ Only sculpt selected stroke points

    :type: bool
    """

    use_gpencil_select_mask_segment: bool
    """ Only sculpt selected stroke points between other strokes

    :type: bool
    """

    use_gpencil_select_mask_stroke: bool
    """ Only sculpt selected stroke

    :type: bool
    """

    use_gpencil_stroke_endpoints: bool
    """ Only use the first and last parts of the stroke for snapping

    :type: bool
    """

    use_gpencil_thumbnail_list: bool
    """ Show compact list of color instead of thumbnails

    :type: bool
    """

    use_gpencil_vertex_select_mask_point: bool
    """ Only paint selected stroke points

    :type: bool
    """

    use_gpencil_vertex_select_mask_segment: bool
    """ Only paint selected stroke points between other strokes

    :type: bool
    """

    use_gpencil_vertex_select_mask_stroke: bool
    """ Only paint selected stroke

    :type: bool
    """

    use_gpencil_weight_data_add: bool
    """ When creating new strokes, the weight data is added according to the current vertex group and weight, if no vertex group selected, weight is not added

    :type: bool
    """

    use_grease_pencil_multi_frame_editing: bool
    """ Enable multi-frame editing

    :type: bool
    """

    use_keyframe_cycle_aware: bool
    """ For channels with cyclic extrapolation, keyframe insertion is automatically remapped inside the cycle time range, and keeps ends in sync. Curves newly added to actions with a Manual Frame Range and Cyclic Animation are automatically made cyclic

    :type: bool
    """

    use_keyframe_insert_auto: bool
    """ Automatic keyframe insertion for Objects, Bones and Masks

    :type: bool
    """

    use_keyframe_insert_keyingset: bool
    """ Automatic keyframe insertion using active Keying Set only

    :type: bool
    """

    use_lock_relative: bool
    """ Display bone-deforming groups as if all locked deform groups were deleted, and the remaining ones were re-normalized

    :type: bool
    """

    use_mesh_automerge: bool
    """ Automatically merge vertices moved to the same location

    :type: bool
    """

    use_mesh_automerge_and_split: bool
    """ Automatically split edges and faces

    :type: bool
    """

    use_multipaint: bool
    """ Paint across the weights of all selected bones, maintaining their relative influence

    :type: bool
    """

    use_proportional_action: bool
    """ Proportional editing in action editor

    :type: bool
    """

    use_proportional_connected: bool
    """ Proportional Editing using connected geometry only

    :type: bool
    """

    use_proportional_edit: bool
    """ Proportional edit mode

    :type: bool
    """

    use_proportional_edit_mask: bool
    """ Proportional editing mask mode

    :type: bool
    """

    use_proportional_edit_objects: bool
    """ Proportional editing object mode

    :type: bool
    """

    use_proportional_fcurve: bool
    """ Proportional editing in F-Curve editor

    :type: bool
    """

    use_proportional_projected: bool
    """ Proportional Editing using screen space locations

    :type: bool
    """

    use_record_with_nla: bool
    """ Add a new NLA Track + Strip for every loop/pass made over the animation to allow non-destructive tweaking

    :type: bool
    """

    use_snap: bool
    """ Snap during transform

    :type: bool
    """

    use_snap_align_rotation: bool
    """ Align rotation with the snapping target

    :type: bool
    """

    use_snap_anim: bool
    """ Enable snapping when transforming keyframes

    :type: bool
    """

    use_snap_backface_culling: bool
    """ Exclude back facing geometry from snapping

    :type: bool
    """

    use_snap_edit: bool
    """ Snap onto non-active objects in Edit Mode (Edit Mode Only)

    :type: bool
    """

    use_snap_grid_absolute: bool
    """ Absolute grid alignment while translating (based on the pivot center)

    :type: bool
    """

    use_snap_node: bool
    """ Snap Node during transform

    :type: bool
    """

    use_snap_nonedit: bool
    """ Snap onto objects not in Edit Mode (Edit Mode Only)

    :type: bool
    """

    use_snap_peel_object: bool
    """ Consider objects as whole when finding volume center

    :type: bool
    """

    use_snap_rotate: bool
    """ Rotate is affected by the snapping settings

    :type: bool
    """

    use_snap_scale: bool
    """ Scale is affected by snapping settings

    :type: bool
    """

    use_snap_selectable: bool
    """ Snap only onto objects that are selectable

    :type: bool
    """

    use_snap_self: bool
    """ Snap onto itself only if enabled (Edit Mode Only)

    :type: bool
    """

    use_snap_sequencer: bool
    """ Snap to strip edges or current frame

    :type: bool
    """

    use_snap_time_absolute: bool
    """ Absolute time alignment when transforming keyframes

    :type: bool
    """

    use_snap_to_same_target: bool
    """ Snap only to target that source was initially near (Face Nearest Only)

    :type: bool
    """

    use_snap_translate: bool
    """ Move is affected by snapping settings

    :type: bool
    """

    use_snap_uv: bool
    """ Snap UV during transform

    :type: bool
    """

    use_snap_uv_grid_absolute: bool
    """ Absolute grid alignment while translating (based on the pivot center)

    :type: bool
    """

    use_transform_correct_face_attributes: bool
    """ Correct data such as UVs and color attributes when transforming

    :type: bool
    """

    use_transform_correct_keep_connected: bool
    """ During the Face Attributes correction, merge attributes connected to the same vertex

    :type: bool
    """

    use_transform_data_origin: bool
    """ Transform object origins, while leaving the shape in place

    :type: bool
    """

    use_transform_pivot_point_align: bool
    """ Only transform object locations, without affecting rotation or scaling

    :type: bool
    """

    use_transform_skip_children: bool
    """ Transform the parents, leaving the children in place

    :type: bool
    """

    use_uv_select_sync: bool
    """ Keep UV and edit mode mesh selection in sync

    :type: bool
    """

    uv_relax_method: typing.Union[int, str]
    """ Algorithm used for UV relaxation

    :type: typing.Union[int, str]
    """

    uv_sculpt: "UvSculpt"
    """ 

    :type: 'UvSculpt'
    """

    uv_sculpt_all_islands: bool
    """ Brush operates on all islands

    :type: bool
    """

    uv_sculpt_lock_borders: bool
    """ Disable editing of boundary edges

    :type: bool
    """

    uv_select_mode: typing.Union[int, str]
    """ UV selection and display mode

    :type: typing.Union[int, str]
    """

    uv_sticky_select_mode: typing.Union[int, str]
    """ Method for extending UV vertex selection

    :type: typing.Union[int, str]
    """

    vertex_group_subset: typing.Union[int, str]
    """ Filter Vertex groups for Display

    :type: typing.Union[int, str]
    """

    vertex_group_user: typing.Union[int, str]
    """ Display unweighted vertices

    :type: typing.Union[int, str]
    """

    vertex_group_weight: float
    """ Weight to assign in vertex groups

    :type: float
    """

    vertex_paint: "VertexPaint"
    """ 

    :type: 'VertexPaint'
    """

    weight_paint: "VertexPaint"
    """ 

    :type: 'VertexPaint'
    """

    workspace_tool_type: typing.Union[int, str]
    """ Action when dragging in the viewport

    :type: typing.Union[int, str]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class TransformOrientation(bpy_struct):
    matrix: typing.Union[
        "mathutils.Matrix",
        typing.List[typing.List[float]],
        typing.Tuple[
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
            typing.Tuple[float, float, float],
        ],
    ]
    """ 

    :type: typing.Union['mathutils.Matrix', typing.List[typing.List[float]], typing.Tuple[typing.Tuple[float, float, float], typing.Tuple[float, float, float], typing.Tuple[float, float, float]]]
    """

    name: typing.Union[str, typing.Any]
    """ Name of the custom transform orientation

    :type: typing.Union[str, typing.Any]
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class TransformOrientationSlot(bpy_struct):
    custom_orientation: "TransformOrientation"
    """ 

    :type: 'TransformOrientation'
    """

    type: typing.Union[int, str]
    """ Transformation orientation

    :type: typing.Union[int, str]
    """

    use: bool
    """ Use scene orientation instead of a custom setting

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class UDIMTile(bpy_struct):
    """Properties of the UDIM tile"""

    channels: int
    """ Number of channels in the tile pixels buffer

    :type: int
    """

    generated_color: bpy_prop_array[float]
    """ Fill color for the generated image

    :type: bpy_prop_array[float]
    """

    generated_height: int
    """ Generated image height

    :type: int
    """

    generated_type: typing.Union[int, str]
    """ Generated image type

    :type: typing.Union[int, str]
    """

    generated_width: int
    """ Generated image width

    :type: int
    """

    label: typing.Union[str, typing.Any]
    """ Tile label

    :type: typing.Union[str, typing.Any]
    """

    number: int
    """ Number of the position that this tile covers

    :type: int
    """

    size: bpy_prop_array[int]
    """ Width and height of the tile buffer in pixels, zero when image data can't be loaded

    :type: bpy_prop_array[int]
    """

    use_generated_float: bool
    """ Generate floating-point buffer

    :type: bool
    """

    def bl_rna_get_subclass(self, id: typing.Optional[str], default=None) -> "Struct":
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: 'Struct'
        :return: The RNA type or default when not found.
        """
        ...

    def bl_rna_get_subclass_py(
        self, id: typing.Optional[str], default=None
    ) -> typing.Any:
        """

        :param id: The RNA type identifier.
        :type id: typing.Optional[str]
        :param default:
        :type default:
        :rtype: typing.Any
        :return: The class or default when not found.
        """
        ...

class UILayout(bpy_struct):
    """User interface layout in a panel or header"""

    activate_init: bool
    """ When true, buttons defined in popups will be activated on first display (use so you can type into a field without having to click on it first)

    :type: bool
    """

    active: bool
    """ 

    :type: bool
    """

    active_default: bool
    """ When true, an operator button defined after this will be activated when pressing return(use with popup dialogs)

    :type: bool
    """

    alert: bool
    """ 

    :type: bool
    """

    alignment: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    direction: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    emboss: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    enabled: bool
    """ When false, this (sub)layout is grayed out

    :type: bool
    """

    operator_context: typing.Union[int, str]
    """ 

    :type: typing.Union[int, str]
    """

    scale_x: float
    """ Scale factor along the X for items in this (sub)layout

    :type: float
    """

    scale_y: float
    """ Scale factor along the Y for items in this (sub)layout

    :type: float
    """

    ui_units_x: float
    """ Fixed size along the X for items in this (sub)layout

    :type: float
    """

    ui_units_y: float
    """ Fixed size along the Y for items in this (sub)layout

    :type: float
    """

    use_property_decorate: bool
    """ 

    :type: bool
    """

    use_property_split: bool
    """ 

    :type: bool
    """

    def row(
        self,
        align: typing.Optional[typing.Union[bool, typing.Any]] = False,
        heading: typing.Union[str, typing.Any] = "",
        heading_ctxt: typing.Union[str, typing.Any] = "",
        translate: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ) -> "UILayout":
        """Sub-layout. Items placed in this sublayout are placed next to each other in a row

        :param align: Align buttons to each other
        :type align: typing.Optional[typing.Union[bool, typing.Any]]
        :param heading: Heading, Label to insert into the layout for this sub-layout
        :type heading: typing.Union[str, typing.Any]
        :param heading_ctxt: Override automatic translation context of the given heading
        :type heading_ctxt: typing.Union[str, typing.Any]
        :param translate: Translate the given heading, when UI translation is enabled
        :type translate: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        """
        ...

    def column(
        self,
        align: typing.Optional[typing.Union[bool, typing.Any]] = False,
        heading: typing.Union[str, typing.Any] = "",
        heading_ctxt: typing.Union[str, typing.Any] = "",
        translate: typing.Optional[typing.Union[bool, typing.Any]] = True,
    ) -> "UILayout":
        """Sub-layout. Items placed in this sublayout are placed under each other in a column

        :param align: Align buttons to each other
        :type align: typing.Optional[typing.Union[bool, typing.Any]]
        :param heading: Heading, Label to insert into the layout for this sub-layout
        :type heading: typing.Union[str, typing.Any]
        :param heading_ctxt: Override automatic translation context of the given heading
        :type heading_ctxt: typing.Union[str, typing.Any]
        :param translate: Translate the given heading, when UI translation is enabled
        :type translate: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        """
        ...

    def panel(
        self,
        idname: typing.Union[str, typing.Any],
        default_closed: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ):
        """Creates a collapsable panel. Whether it is open or closed is stored in the region using the given idname. This can only be used when the panel has the full width of the panel region available to it. So it can't be used in e.g. in a box or columns

                :param idname: Identifier of the panel
                :type idname: typing.Union[str, typing.Any]
                :param default_closed: Open by Default, When true, the panel will be open the first time it is shown
                :type default_closed: typing.Optional[typing.Union[bool, typing.Any]]
                :return: layout_header, Sub-layout to put items in, `UILayout`

        layout_body, Sub-layout to put items in. Will be none if the panel is collapsed, `UILayout`
        """
        ...

    def panel_prop(self, data: typing.Any, property: typing.Union[str, typing.Any]):
        """Similar to .panel(...) but instead of storing whether it is open or closed in the region, it is stored in the provided boolean property. This should be used when multiple instances of the same panel can exist. For example one for every item in a collection property or list. This can only be used when the panel has the full width of the panel region available to it. So it can't be used in e.g. in a box or columns

                :param data: Data from which to take the open-state property
                :type data: typing.Any
                :param property: Identifier of the boolean property that determines whether the panel is open or closed
                :type property: typing.Union[str, typing.Any]
                :return: layout_header, Sub-layout to put items in, `UILayout`

        layout_body, Sub-layout to put items in. Will be none if the panel is collapsed, `UILayout`
        """
        ...

    def column_flow(
        self,
        columns: typing.Optional[typing.Any] = 0,
        align: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "UILayout":
        """column_flow

        :param columns: Number of columns, 0 is automatic
        :type columns: typing.Optional[typing.Any]
        :param align: Align buttons to each other
        :type align: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        """
        ...

    def grid_flow(
        self,
        row_major: typing.Optional[typing.Union[bool, typing.Any]] = False,
        columns: typing.Optional[typing.Any] = 0,
        even_columns: typing.Optional[typing.Union[bool, typing.Any]] = False,
        even_rows: typing.Optional[typing.Union[bool, typing.Any]] = False,
        align: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "UILayout":
        """grid_flow

        :param row_major: Fill row by row, instead of column by column
        :type row_major: typing.Optional[typing.Union[bool, typing.Any]]
        :param columns: Number of columns, positive are absolute fixed numbers, 0 is automatic, negative are automatic multiple numbers along major axis (e.g. -2 will only produce 2, 4, 6 etc. columns for row major layout, and 2, 4, 6 etc. rows for column major layout)
        :type columns: typing.Optional[typing.Any]
        :param even_columns: All columns will have the same width
        :type even_columns: typing.Optional[typing.Union[bool, typing.Any]]
        :param even_rows: All rows will have the same height
        :type even_rows: typing.Optional[typing.Union[bool, typing.Any]]
        :param align: Align buttons to each other
        :type align: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        """
        ...

    def box(self) -> "UILayout":
        """Sublayout (items placed in this sublayout are placed under each other in a column and are surrounded by a box)

        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        """
        ...

    def split(
        self,
        factor: typing.Optional[typing.Any] = 0.0,
        align: typing.Optional[typing.Union[bool, typing.Any]] = False,
    ) -> "UILayout":
        """split

        :param factor: Percentage, Percentage of width to split at (leave unset for automatic calculation)
        :type factor: typing.Optional[typing.Any]
        :param align: Align buttons to each other
        :type align: typing.Optional[typing.Union[bool, typing.Any]]
        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        """
        ...

    def menu_pie(self) -> "UILayout":
        """Sublayout. Items placed in this sublayout are placed in a radial fashion around the menu center)

        :rtype: 'UILayout'
        :return: Sub-layout to put items in
        """
        ...

    def icon(self, data: typing.Any) -> int:
        """Return the custom icon for this data, use it e.g. to get materials or texture icons

        :param data: Data from which to take the icon
        :type data: typing.Any
        :rtype: int
        :return: Icon identifier
        """
        ...

    def enum_item_name(
        self,
        data: typing.Any,
        property: typing.Union[str, typing.Any],
        identifier: typing.Union[str, typing.Any],
    ) -> typing.Union[str, typing.Any]:
        """Return the UI name for this enum item

        :param data: Data from which to take property
        :type data: typing.Any
        :param property: Identifier of property in data
        :type property: typing.Union[str, typing.Any]
        :param id