COMFYUI_BUILTIN_NODES = {
  "metadata": {
    "description": "Built-in ComfyUI node mappings",
    "total_nodes": 481,
    "categories": [
      "core",
      "extras",
      "api",
      "custom",
      "frontend"
    ]
  },
  "nodes_by_category": {
    "core": {
      "source": "nodes.py",
      "nodes": [
        "CLIPLoader",
        "CLIPSetLastLayer",
        "CLIPTextEncode",
        "CLIPVisionEncode",
        "CLIPVisionLoader",
        "CheckpointLoader",
        "CheckpointLoaderSimple",
        "ConditioningAverage",
        "ConditioningCombine",
        "ConditioningConcat",
        "ConditioningSetArea",
        "ConditioningSetAreaPercentage",
        "ConditioningSetAreaStrength",
        "ConditioningSetMask",
        "ConditioningSetTimestepRange",
        "ConditioningZeroOut",
        "ControlNetApply",
        "ControlNetApplyAdvanced",
        "ControlNetLoader",
        "DiffControlNetLoader",
        "DiffusersLoader",
        "DualCLIPLoader",
        "EmptyImage",
        "EmptyLatentImage",
        "GLIGENLoader",
        "GLIGENTextBoxApply",
        "ImageBatch",
        "ImageInvert",
        "ImagePadForOutpaint",
        "ImageScale",
        "ImageScaleBy",
        "InpaintModelConditioning",
        "KSampler",
        "KSamplerAdvanced",
        "LatentBlend",
        "LatentComposite",
        "LatentCrop",
        "LatentFlip",
        "LatentFromBatch",
        "LatentRotate",
        "LatentUpscale",
        "LatentUpscaleBy",
        "LoadImage",
        "LoadImageMask",
        "LoadImageOutput",
        "LoadLatent",
        "LoraLoader",
        "LoraLoaderModelOnly",
        "PreviewImage",
        "RepeatLatentBatch",
        "SaveImage",
        "SaveLatent",
        "SetLatentNoiseMask",
        "StyleModelApply",
        "StyleModelLoader",
        "UNETLoader",
        "VAEDecode",
        "VAEDecodeTiled",
        "VAEEncode",
        "VAEEncodeForInpaint",
        "VAEEncodeTiled",
        "VAELoader",
        "unCLIPCheckpointLoader",
        "unCLIPConditioning"
      ],
      "count": 64
    },
    "extras": {
      "source": "comfy_extras",
      "nodes": [
        "APG",
        "AddNoise",
        "AlignYourStepsScheduler",
        "AudioEncoderEncode",
        "AudioEncoderLoader",
        "BasicGuider",
        "BasicScheduler",
        "BetaSamplingScheduler",
        "CFGGuider",
        "CFGNorm",
        "CFGZeroStar",
        "CLIPAttentionMultiply",
        "CLIPMergeAdd",
        "CLIPMergeSimple",
        "CLIPMergeSubtract",
        "CLIPSave",
        "CLIPTextEncodeControlnet",
        "CLIPTextEncodeFlux",
        "CLIPTextEncodeHiDream",
        "CLIPTextEncodeHunyuanDiT",
        "CLIPTextEncodeLumina2",
        "CLIPTextEncodePixArtAlpha",
        "CLIPTextEncodeSD3",
        "CLIPTextEncodeSDXL",
        "CLIPTextEncodeSDXLRefiner",
        "Canny",
        "CaseConverter",
        "CheckpointSave",
        "CombineHooks2",
        "CombineHooks4",
        "CombineHooks8",
        "ConditioningSetAreaPercentageVideo",
        "ConditioningSetDefaultCombine",
        "ConditioningSetProperties",
        "ConditioningSetPropertiesAndCombine",
        "ConditioningStableAudio",
        "ConditioningTimestepsRange",
        "ContextWindowsManual",
        "ControlNetApplySD3",
        "ControlNetInpaintingAliMamaApply",
        "CosmosImageToVideoLatent",
        "CosmosPredict2ImageToVideoLatent",
        "CreateHookKeyframe",
        "CreateHookKeyframesFromFloats",
        "CreateHookKeyframesInterpolated",
        "CreateHookLora",
        "CreateHookLoraModelOnly",
        "CreateHookModelAsLora",
        "CreateHookModelAsLoraModelOnly",
        "CreateVideo",
        "CropMask",
        "DifferentialDiffusion",
        "DisableNoise",
        "DualCFGGuider",
        "EasyCache",
        "EmptyAceStepLatentAudio",
        "EmptyCosmosLatentVideo",
        "EmptyHunyuanImageLatent",
        "EmptyHunyuanLatentVideo",
        "EmptyLTXVLatentVideo",
        "EmptyLatentAudio",
        "EmptyLatentHunyuan3Dv2",
        "EmptyMochiLatentVideo",
        "EmptySD3LatentImage",
        "ExponentialScheduler",
        "ExtendIntermediateSigmas",
        "FeatherMask",
        "FlipSigmas",
        "FluxDisableGuidance",
        "FluxGuidance",
        "FluxKontextImageScale",
        "FluxKontextMultiReferenceLatentMethod",
        "FreSca",
        "FreeU",
        "FreeU_V2",
        "GITSScheduler",
        "GetImageSize",
        "GetVideoComponents",
        "GrowMask",
        "Hunyuan3Dv2Conditioning",
        "Hunyuan3Dv2ConditioningMultiView",
        "HunyuanImageToVideo",
        "HyperTile",
        "HypernetworkLoader",
        "ImageAddNoise",
        "ImageBlend",
        "ImageBlur",
        "ImageColorToMask",
        "ImageCompositeMasked",
        "ImageCrop",
        "ImageFlip",
        "ImageFromBatch",
        "ImageOnlyCheckpointLoader",
        "ImageOnlyCheckpointSave",
        "ImageQuantize",
        "ImageRGBToYUV",
        "ImageRotate",
        "ImageScaleToMaxDimension",
        "ImageScaleToTotalPixels",
        "ImageSharpen",
        "ImageStitch",
        "ImageToMask",
        "ImageUpscaleWithModel",
        "ImageYUVToRGB",
        "InstructPixToPixConditioning",
        "InvertMask",
        "JoinImageWithAlpha",
        "KSamplerSelect",
        "KarrasScheduler",
        "LTXVAddGuide",
        "LTXVConditioning",
        "LTXVCropGuides",
        "LTXVImgToVideo",
        "LTXVPreprocess",
        "LTXVScheduler",
        "LaplaceScheduler",
        "LatentAdd",
        "LatentApplyOperation",
        "LatentApplyOperationCFG",
        "LatentBatch",
        "LatentBatchSeedBehavior",
        "LatentCompositeMasked",
        "LatentConcat",
        "LatentCut",
        "LatentInterpolate",
        "LatentMultiply",
        "LatentOperationSharpen",
        "LatentOperationTonemapReinhard",
        "LatentSubtract",
        "LazyCache",
        "Load3D",
        "Load3DAnimation",
        "LoadAudio",
        "LoadImageSetFromFolderNode",
        "LoadImageTextSetFromFolderNode",
        "LoadVideo",
        "LoraModelLoader",
        "LoraSave",
        "LossGraphNode",
        "LotusConditioning",
        "Mahiro",
        "MaskComposite",
        "MaskPreview",
        "MaskToImage",
        "ModelComputeDtype",
        "ModelMergeAdd",
        "ModelMergeAuraflow",
        "ModelMergeBlocks",
        "ModelMergeCosmos14B",
        "ModelMergeCosmos7B",
        "ModelMergeCosmosPredict2_14B",
        "ModelMergeCosmosPredict2_2B",
        "ModelMergeFlux1",
        "ModelMergeLTXV",
        "ModelMergeMochiPreview",
        "ModelMergeQwenImage",
        "ModelMergeSD1",
        "ModelMergeSD2",
        "ModelMergeSD35_Large",
        "ModelMergeSD3_2B",
        "ModelMergeSDXL",
        "ModelMergeSimple",
        "ModelMergeSubtract",
        "ModelMergeWAN2_1",
        "ModelPatchLoader",
        "ModelSamplingAuraFlow",
        "ModelSamplingContinuousEDM",
        "ModelSamplingContinuousV",
        "ModelSamplingDiscrete",
        "ModelSamplingFlux",
        "ModelSamplingLTXV",
        "ModelSamplingSD3",
        "ModelSamplingStableCascade",
        "ModelSave",
        "Morphology",
        "OptimalStepsScheduler",
        "PairConditioningCombine",
        "PairConditioningSetDefaultCombine",
        "PairConditioningSetProperties",
        "PairConditioningSetPropertiesAndCombine",
        "PatchModelAddDownscale",
        "PerpNeg",
        "PerpNegGuider",
        "PerturbedAttentionGuidance",
        "PhotoMakerEncode",
        "PhotoMakerLoader",
        "PolyexponentialScheduler",
        "PorterDuffImageComposite",
        "Preview3D",
        "Preview3DAnimation",
        "PreviewAny",
        "PreviewAudio",
        "PrimitiveBoolean",
        "PrimitiveFloat",
        "PrimitiveInt",
        "PrimitiveString",
        "PrimitiveStringMultiline",
        "QuadrupleCLIPLoader",
        "QwenImageDiffsynthControlnet",
        "RandomNoise",
        "RebatchImages",
        "RebatchLatents",
        "RecordAudio",
        "ReferenceLatent",
        "RegexExtract",
        "RegexMatch",
        "RegexReplace",
        "RenormCFG",
        "RepeatImageBatch",
        "RescaleCFG",
        "ResizeAndPadImage",
        "SDTurboScheduler",
        "SD_4XUpscale_Conditioning",
        "SV3D_Conditioning",
        "SVD_img2vid_Conditioning",
        "SamplerCustom",
        "SamplerCustomAdvanced",
        "SamplerDPMAdaptative",
        "SamplerDPMPP_2M_SDE",
        "SamplerDPMPP_2S_Ancestral",
        "SamplerDPMPP_3M_SDE",
        "SamplerDPMPP_SDE",
        "SamplerER_SDE",
        "SamplerEulerAncestral",
        "SamplerEulerAncestralCFGPP",
        "SamplerEulerCFGpp",
        "SamplerLCMUpscale",
        "SamplerLMS",
        "SamplerSASolver",
        "SamplingPercentToSigma",
        "SaveAnimatedPNG",
        "SaveAnimatedWEBP",
        "SaveAudio",
        "SaveAudioMP3",
        "SaveAudioOpus",
        "SaveGLB",
        "SaveLoRANode",
        "SaveSVGNode",
        "SaveVideo",
        "SaveWEBM",
        "SelfAttentionGuidance",
        "SetClipHooks",
        "SetFirstSigma",
        "SetHookKeyframes",
        "SetUnionControlNetType",
        "SkipLayerGuidanceDiT",
        "SkipLayerGuidanceDiTSimple",
        "SkipLayerGuidanceSD3",
        "SolidMask",
        "SplitImageWithAlpha",
        "SplitSigmas",
        "SplitSigmasDenoise",
        "StableCascade_EmptyLatentImage",
        "StableCascade_StageB_Conditioning",
        "StableCascade_StageC_VAEEncode",
        "StableCascade_SuperResolutionControlnet",
        "StableZero123_Conditioning",
        "StableZero123_Conditioning_Batched",
        "StringCompare",
        "StringConcatenate",
        "StringContains",
        "StringLength",
        "StringReplace",
        "StringSubstring",
        "StringTrim",
        "T5TokenizerOptions",
        "TCFG",
        "TextEncodeAceStepAudio",
        "TextEncodeHunyuanVideo_ImageToVideo",
        "TextEncodeQwenImageEdit",
        "ThresholdMask",
        "TomePatchModel",
        "TorchCompileModel",
        "TrainLoraNode",
        "TrimVideoLatent",
        "TripleCLIPLoader",
        "UNetCrossAttentionMultiply",
        "UNetSelfAttentionMultiply",
        "UNetTemporalAttentionMultiply",
        "USOStyleReference",
        "UpscaleModelLoader",
        "VAEDecodeAudio",
        "VAEDecodeHunyuan3D",
        "VAEEncodeAudio",
        "VAESave",
        "VPScheduler",
        "VideoLinearCFGGuidance",
        "VideoTriangleCFGGuidance",
        "VoxelToMesh",
        "VoxelToMeshBasic",
        "Wan22FunControlToVideo",
        "Wan22ImageToVideoLatent",
        "WanCameraEmbedding",
        "WanCameraImageToVideo",
        "WanContextWindowsManual",
        "WanFirstLastFrameToVideo",
        "WanFunControlToVideo",
        "WanFunInpaintToVideo",
        "WanImageToVideo",
        "WanPhantomSubjectToVideo",
        "WanSoundImageToVideo",
        "WanSoundImageToVideoExtend",
        "WanTrackToVideo",
        "WanVaceToVideo",
        "WebcamCapture"
      ],
      "count": 305,
      "by_file": {
        "nodes_ace.py": [
          "EmptyAceStepLatentAudio",
          "TextEncodeAceStepAudio"
        ],
        "nodes_advanced_samplers.py": [
          "SamplerEulerCFGpp",
          "SamplerLCMUpscale"
        ],
        "nodes_align_your_steps.py": [
          "AlignYourStepsScheduler"
        ],
        "nodes_apg.py": [
          "APG"
        ],
        "nodes_attention_multiply.py": [
          "CLIPAttentionMultiply",
          "UNetCrossAttentionMultiply",
          "UNetSelfAttentionMultiply",
          "UNetTemporalAttentionMultiply"
        ],
        "nodes_audio.py": [
          "ConditioningStableAudio",
          "EmptyLatentAudio",
          "LoadAudio",
          "PreviewAudio",
          "RecordAudio",
          "SaveAudio",
          "SaveAudioMP3",
          "SaveAudioOpus",
          "VAEDecodeAudio",
          "VAEEncodeAudio"
        ],
        "nodes_audio_encoder.py": [
          "AudioEncoderEncode",
          "AudioEncoderLoader"
        ],
        "nodes_camera_trajectory.py": [
          "WanCameraEmbedding"
        ],
        "nodes_canny.py": [
          "Canny"
        ],
        "nodes_cfg.py": [
          "CFGNorm",
          "CFGZeroStar"
        ],
        "nodes_clip_sdxl.py": [
          "CLIPTextEncodeSDXL",
          "CLIPTextEncodeSDXLRefiner"
        ],
        "nodes_compositing.py": [
          "JoinImageWithAlpha",
          "PorterDuffImageComposite",
          "SplitImageWithAlpha"
        ],
        "nodes_cond.py": [
          "CLIPTextEncodeControlnet",
          "T5TokenizerOptions"
        ],
        "nodes_context_windows.py": [
          "ContextWindowsManual",
          "WanContextWindowsManual"
        ],
        "nodes_controlnet.py": [
          "ControlNetInpaintingAliMamaApply",
          "SetUnionControlNetType"
        ],
        "nodes_cosmos.py": [
          "CosmosImageToVideoLatent",
          "CosmosPredict2ImageToVideoLatent",
          "EmptyCosmosLatentVideo"
        ],
        "nodes_custom_sampler.py": [
          "AddNoise",
          "BasicGuider",
          "BasicScheduler",
          "BetaSamplingScheduler",
          "CFGGuider",
          "DisableNoise",
          "DualCFGGuider",
          "ExponentialScheduler",
          "ExtendIntermediateSigmas",
          "FlipSigmas",
          "KSamplerSelect",
          "KarrasScheduler",
          "LaplaceScheduler",
          "PolyexponentialScheduler",
          "RandomNoise",
          "SDTurboScheduler",
          "SamplerCustom",
          "SamplerCustomAdvanced",
          "SamplerDPMAdaptative",
          "SamplerDPMPP_2M_SDE",
          "SamplerDPMPP_2S_Ancestral",
          "SamplerDPMPP_3M_SDE",
          "SamplerDPMPP_SDE",
          "SamplerER_SDE",
          "SamplerEulerAncestral",
          "SamplerEulerAncestralCFGPP",
          "SamplerLMS",
          "SamplerSASolver",
          "SamplingPercentToSigma",
          "SetFirstSigma",
          "SplitSigmas",
          "SplitSigmasDenoise",
          "VPScheduler"
        ],
        "nodes_differential_diffusion.py": [
          "DifferentialDiffusion"
        ],
        "nodes_easycache.py": [
          "EasyCache",
          "LazyCache"
        ],
        "nodes_edit_model.py": [
          "ReferenceLatent"
        ],
        "nodes_flux.py": [
          "CLIPTextEncodeFlux",
          "FluxDisableGuidance",
          "FluxGuidance",
          "FluxKontextImageScale",
          "FluxKontextMultiReferenceLatentMethod"
        ],
        "nodes_freelunch.py": [
          "FreeU",
          "FreeU_V2"
        ],
        "nodes_fresca.py": [
          "FreSca"
        ],
        "nodes_gits.py": [
          "GITSScheduler"
        ],
        "nodes_hidream.py": [
          "CLIPTextEncodeHiDream",
          "QuadrupleCLIPLoader"
        ],
        "nodes_hooks.py": [
          "CombineHooks2",
          "CombineHooks4",
          "CombineHooks8",
          "ConditioningSetDefaultCombine",
          "ConditioningSetProperties",
          "ConditioningSetPropertiesAndCombine",
          "ConditioningTimestepsRange",
          "CreateHookKeyframe",
          "CreateHookKeyframesFromFloats",
          "CreateHookKeyframesInterpolated",
          "CreateHookLora",
          "CreateHookLoraModelOnly",
          "CreateHookModelAsLora",
          "CreateHookModelAsLoraModelOnly",
          "PairConditioningCombine",
          "PairConditioningSetDefaultCombine",
          "PairConditioningSetProperties",
          "PairConditioningSetPropertiesAndCombine",
          "SetClipHooks",
          "SetHookKeyframes"
        ],
        "nodes_hunyuan.py": [
          "CLIPTextEncodeHunyuanDiT",
          "EmptyHunyuanImageLatent",
          "EmptyHunyuanLatentVideo",
          "HunyuanImageToVideo",
          "TextEncodeHunyuanVideo_ImageToVideo"
        ],
        "nodes_hunyuan3d.py": [
          "EmptyLatentHunyuan3Dv2",
          "Hunyuan3Dv2Conditioning",
          "Hunyuan3Dv2ConditioningMultiView",
          "SaveGLB",
          "VAEDecodeHunyuan3D",
          "VoxelToMesh",
          "VoxelToMeshBasic"
        ],
        "nodes_hypernetwork.py": [
          "HypernetworkLoader"
        ],
        "nodes_hypertile.py": [
          "HyperTile"
        ],
        "nodes_images.py": [
          "GetImageSize",
          "ImageAddNoise",
          "ImageCrop",
          "ImageFlip",
          "ImageFromBatch",
          "ImageRotate",
          "ImageScaleToMaxDimension",
          "ImageStitch",
          "RepeatImageBatch",
          "ResizeAndPadImage",
          "SaveAnimatedPNG",
          "SaveAnimatedWEBP",
          "SaveSVGNode"
        ],
        "nodes_ip2p.py": [
          "InstructPixToPixConditioning"
        ],
        "nodes_latent.py": [
          "LatentAdd",
          "LatentApplyOperation",
          "LatentApplyOperationCFG",
          "LatentBatch",
          "LatentBatchSeedBehavior",
          "LatentConcat",
          "LatentCut",
          "LatentInterpolate",
          "LatentMultiply",
          "LatentOperationSharpen",
          "LatentOperationTonemapReinhard",
          "LatentSubtract"
        ],
        "nodes_load_3d.py": [
          "Load3D",
          "Load3DAnimation",
          "Preview3D",
          "Preview3DAnimation"
        ],
        "nodes_lora_extract.py": [
          "LoraSave"
        ],
        "nodes_lotus.py": [
          "LotusConditioning"
        ],
        "nodes_lt.py": [
          "EmptyLTXVLatentVideo",
          "LTXVAddGuide",
          "LTXVConditioning",
          "LTXVCropGuides",
          "LTXVImgToVideo",
          "LTXVPreprocess",
          "LTXVScheduler",
          "ModelSamplingLTXV"
        ],
        "nodes_lumina2.py": [
          "CLIPTextEncodeLumina2",
          "RenormCFG"
        ],
        "nodes_mahiro.py": [
          "Mahiro"
        ],
        "nodes_mask.py": [
          "CropMask",
          "FeatherMask",
          "GrowMask",
          "ImageColorToMask",
          "ImageCompositeMasked",
          "ImageToMask",
          "InvertMask",
          "LatentCompositeMasked",
          "MaskComposite",
          "MaskPreview",
          "MaskToImage",
          "SolidMask",
          "ThresholdMask"
        ],
        "nodes_mochi.py": [
          "EmptyMochiLatentVideo"
        ],
        "nodes_model_advanced.py": [
          "ModelComputeDtype",
          "ModelSamplingAuraFlow",
          "ModelSamplingContinuousEDM",
          "ModelSamplingContinuousV",
          "ModelSamplingDiscrete",
          "ModelSamplingFlux",
          "ModelSamplingSD3",
          "ModelSamplingStableCascade",
          "RescaleCFG"
        ],
        "nodes_model_downscale.py": [
          "PatchModelAddDownscale"
        ],
        "nodes_model_merging.py": [
          "CLIPMergeAdd",
          "CLIPMergeSimple",
          "CLIPMergeSubtract",
          "CLIPSave",
          "CheckpointSave",
          "ModelMergeAdd",
          "ModelMergeBlocks",
          "ModelMergeSimple",
          "ModelMergeSubtract",
          "ModelSave",
          "VAESave"
        ],
        "nodes_model_merging_model_specific.py": [
          "ModelMergeAuraflow",
          "ModelMergeCosmos14B",
          "ModelMergeCosmos7B",
          "ModelMergeCosmosPredict2_14B",
          "ModelMergeCosmosPredict2_2B",
          "ModelMergeFlux1",
          "ModelMergeLTXV",
          "ModelMergeMochiPreview",
          "ModelMergeQwenImage",
          "ModelMergeSD1",
          "ModelMergeSD2",
          "ModelMergeSD35_Large",
          "ModelMergeSD3_2B",
          "ModelMergeSDXL",
          "ModelMergeWAN2_1"
        ],
        "nodes_model_patch.py": [
          "ModelPatchLoader",
          "QwenImageDiffsynthControlnet",
          "USOStyleReference"
        ],
        "nodes_morphology.py": [
          "ImageRGBToYUV",
          "ImageYUVToRGB",
          "Morphology"
        ],
        "nodes_optimalsteps.py": [
          "OptimalStepsScheduler"
        ],
        "nodes_pag.py": [
          "PerturbedAttentionGuidance"
        ],
        "nodes_perpneg.py": [
          "PerpNeg",
          "PerpNegGuider"
        ],
        "nodes_photomaker.py": [
          "PhotoMakerEncode",
          "PhotoMakerLoader"
        ],
        "nodes_pixart.py": [
          "CLIPTextEncodePixArtAlpha"
        ],
        "nodes_post_processing.py": [
          "ImageBlend",
          "ImageBlur",
          "ImageQuantize",
          "ImageScaleToTotalPixels",
          "ImageSharpen"
        ],
        "nodes_preview_any.py": [
          "PreviewAny"
        ],
        "nodes_primitive.py": [
          "PrimitiveBoolean",
          "PrimitiveFloat",
          "PrimitiveInt",
          "PrimitiveString",
          "PrimitiveStringMultiline"
        ],
        "nodes_qwen.py": [
          "TextEncodeQwenImageEdit"
        ],
        "nodes_rebatch.py": [
          "RebatchImages",
          "RebatchLatents"
        ],
        "nodes_sag.py": [
          "SelfAttentionGuidance"
        ],
        "nodes_sd3.py": [
          "CLIPTextEncodeSD3",
          "ControlNetApplySD3",
          "EmptySD3LatentImage",
          "SkipLayerGuidanceSD3",
          "TripleCLIPLoader"
        ],
        "nodes_sdupscale.py": [
          "SD_4XUpscale_Conditioning"
        ],
        "nodes_slg.py": [
          "SkipLayerGuidanceDiT",
          "SkipLayerGuidanceDiTSimple"
        ],
        "nodes_stable3d.py": [
          "SV3D_Conditioning",
          "StableZero123_Conditioning",
          "StableZero123_Conditioning_Batched"
        ],
        "nodes_stable_cascade.py": [
          "StableCascade_EmptyLatentImage",
          "StableCascade_StageB_Conditioning",
          "StableCascade_StageC_VAEEncode",
          "StableCascade_SuperResolutionControlnet"
        ],
        "nodes_string.py": [
          "CaseConverter",
          "RegexExtract",
          "RegexMatch",
          "RegexReplace",
          "StringCompare",
          "StringConcatenate",
          "StringContains",
          "StringLength",
          "StringReplace",
          "StringSubstring",
          "StringTrim"
        ],
        "nodes_tcfg.py": [
          "TCFG"
        ],
        "nodes_tomesd.py": [
          "TomePatchModel"
        ],
        "nodes_torch_compile.py": [
          "TorchCompileModel"
        ],
        "nodes_train.py": [
          "LoadImageSetFromFolderNode",
          "LoadImageTextSetFromFolderNode",
          "LoraModelLoader",
          "LossGraphNode",
          "SaveLoRANode",
          "TrainLoraNode"
        ],
        "nodes_upscale_model.py": [
          "ImageUpscaleWithModel",
          "UpscaleModelLoader"
        ],
        "nodes_video.py": [
          "CreateVideo",
          "GetVideoComponents",
          "LoadVideo",
          "SaveVideo",
          "SaveWEBM"
        ],
        "nodes_video_model.py": [
          "ConditioningSetAreaPercentageVideo",
          "ImageOnlyCheckpointLoader",
          "ImageOnlyCheckpointSave",
          "SVD_img2vid_Conditioning",
          "VideoLinearCFGGuidance",
          "VideoTriangleCFGGuidance"
        ],
        "nodes_wan.py": [
          "TrimVideoLatent",
          "Wan22FunControlToVideo",
          "Wan22ImageToVideoLatent",
          "WanCameraImageToVideo",
          "WanFirstLastFrameToVideo",
          "WanFunControlToVideo",
          "WanFunInpaintToVideo",
          "WanImageToVideo",
          "WanPhantomSubjectToVideo",
          "WanSoundImageToVideo",
          "WanSoundImageToVideoExtend",
          "WanTrackToVideo",
          "WanVaceToVideo"
        ],
        "nodes_webcam.py": [
          "WebcamCapture"
        ]
      }
    },
    "api": {
      "source": "comfy_api_nodes",
      "nodes": [
        "ByteDanceFirstLastFrameNode",
        "ByteDanceImageEditNode",
        "ByteDanceImageNode",
        "ByteDanceImageReferenceNode",
        "ByteDanceImageToVideoNode",
        "ByteDanceSeedreamNode",
        "ByteDanceTextToVideoNode",
        "FluxKontextMaxImageNode",
        "FluxKontextProImageNode",
        "FluxProCannyNode",
        "FluxProDepthNode",
        "FluxProExpandNode",
        "FluxProFillNode",
        "FluxProUltraImageNode",
        "GeminiImageNode",
        "GeminiInputFiles",
        "GeminiNode",
        "IdeogramV1",
        "IdeogramV2",
        "IdeogramV3",
        "KlingCameraControlI2VNode",
        "KlingCameraControlT2VNode",
        "KlingCameraControls",
        "KlingDualCharacterVideoEffectNode",
        "KlingImage2VideoNode",
        "KlingImageGenerationNode",
        "KlingLipSyncAudioToVideoNode",
        "KlingLipSyncTextToVideoNode",
        "KlingSingleImageVideoEffectNode",
        "KlingStartEndFrameNode",
        "KlingTextToVideoNode",
        "KlingVideoExtendNode",
        "KlingVirtualTryOnNode",
        "LumaConceptsNode",
        "LumaImageModifyNode",
        "LumaImageNode",
        "LumaImageToVideoNode",
        "LumaReferenceNode",
        "LumaVideoNode",
        "MinimaxHailuoVideoNode",
        "MinimaxImageToVideoNode",
        "MinimaxTextToVideoNode",
        "MoonvalleyImg2VideoNode",
        "MoonvalleyTxt2VideoNode",
        "MoonvalleyVideo2VideoNode",
        "OpenAIChatConfig",
        "OpenAIChatNode",
        "OpenAIDalle2",
        "OpenAIDalle3",
        "OpenAIGPTImage1",
        "OpenAIInputFiles",
        "PikaImageToVideoNode2_2",
        "PikaScenesV2_2",
        "PikaStartEndFrameNode2_2",
        "PikaTextToVideoNode2_2",
        "Pikadditions",
        "Pikaffects",
        "Pikaswaps",
        "PixverseImageToVideoNode",
        "PixverseTemplateNode",
        "PixverseTextToVideoNode",
        "PixverseTransitionVideoNode",
        "RecraftColorRGB",
        "RecraftControls",
        "RecraftCreativeUpscaleNode",
        "RecraftCrispUpscaleNode",
        "RecraftImageInpaintingNode",
        "RecraftImageToImageNode",
        "RecraftRemoveBackgroundNode",
        "RecraftReplaceBackgroundNode",
        "RecraftStyleV3DigitalIllustration",
        "RecraftStyleV3InfiniteStyleLibrary",
        "RecraftStyleV3LogoRaster",
        "RecraftStyleV3RealisticImage",
        "RecraftTextToImageNode",
        "RecraftTextToVectorNode",
        "RecraftVectorizeImageNode",
        "Rodin3D_Detail",
        "Rodin3D_Regular",
        "Rodin3D_Sketch",
        "Rodin3D_Smooth",
        "RunwayFirstLastFrameNode",
        "RunwayImageToVideoNodeGen3a",
        "RunwayImageToVideoNodeGen4",
        "RunwayTextToImageNode",
        "StabilityAudioInpaint",
        "StabilityAudioToAudio",
        "StabilityStableImageSD_3_5Node",
        "StabilityStableImageUltraNode",
        "StabilityTextToAudio",
        "StabilityUpscaleConservativeNode",
        "StabilityUpscaleCreativeNode",
        "StabilityUpscaleFastNode",
        "TripoConversionNode",
        "TripoImageToModelNode",
        "TripoMultiviewToModelNode",
        "TripoRefineNode",
        "TripoRetargetNode",
        "TripoRigNode",
        "TripoTextToModelNode",
        "TripoTextureNode",
        "Veo3VideoGenerationNode",
        "VeoVideoGenerationNode",
        "ViduImageToVideoNode",
        "ViduReferenceVideoNode",
        "ViduStartEndToVideoNode",
        "ViduTextToVideoNode"
      ],
      "count": 107,
      "by_file": {
        "nodes_bfl.py": [
          "FluxKontextMaxImageNode",
          "FluxKontextProImageNode",
          "FluxProCannyNode",
          "FluxProDepthNode",
          "FluxProExpandNode",
          "FluxProFillNode",
          "FluxProUltraImageNode"
        ],
        "nodes_bytedance.py": [
          "ByteDanceFirstLastFrameNode",
          "ByteDanceImageEditNode",
          "ByteDanceImageNode",
          "ByteDanceImageReferenceNode",
          "ByteDanceImageToVideoNode",
          "ByteDanceSeedreamNode",
          "ByteDanceTextToVideoNode"
        ],
        "nodes_gemini.py": [
          "GeminiImageNode",
          "GeminiInputFiles",
          "GeminiNode"
        ],
        "nodes_ideogram.py": [
          "IdeogramV1",
          "IdeogramV2",
          "IdeogramV3"
        ],
        "nodes_kling.py": [
          "KlingCameraControlI2VNode",
          "KlingCameraControlT2VNode",
          "KlingCameraControls",
          "KlingDualCharacterVideoEffectNode",
          "KlingImage2VideoNode",
          "KlingImageGenerationNode",
          "KlingLipSyncAudioToVideoNode",
          "KlingLipSyncTextToVideoNode",
          "KlingSingleImageVideoEffectNode",
          "KlingStartEndFrameNode",
          "KlingTextToVideoNode",
          "KlingVideoExtendNode",
          "KlingVirtualTryOnNode"
        ],
        "nodes_luma.py": [
          "LumaConceptsNode",
          "LumaImageModifyNode",
          "LumaImageNode",
          "LumaImageToVideoNode",
          "LumaReferenceNode",
          "LumaVideoNode"
        ],
        "nodes_minimax.py": [
          "MinimaxHailuoVideoNode",
          "MinimaxImageToVideoNode",
          "MinimaxTextToVideoNode"
        ],
        "nodes_moonvalley.py": [
          "MoonvalleyImg2VideoNode",
          "MoonvalleyTxt2VideoNode",
          "MoonvalleyVideo2VideoNode"
        ],
        "nodes_openai.py": [
          "OpenAIChatConfig",
          "OpenAIChatNode",
          "OpenAIDalle2",
          "OpenAIDalle3",
          "OpenAIGPTImage1",
          "OpenAIInputFiles"
        ],
        "nodes_pika.py": [
          "PikaImageToVideoNode2_2",
          "PikaScenesV2_2",
          "PikaStartEndFrameNode2_2",
          "PikaTextToVideoNode2_2",
          "Pikadditions",
          "Pikaffects",
          "Pikaswaps"
        ],
        "nodes_pixverse.py": [
          "PixverseImageToVideoNode",
          "PixverseTemplateNode",
          "PixverseTextToVideoNode",
          "PixverseTransitionVideoNode"
        ],
        "nodes_recraft.py": [
          "RecraftColorRGB",
          "RecraftControls",
          "RecraftCreativeUpscaleNode",
          "RecraftCrispUpscaleNode",
          "RecraftImageInpaintingNode",
          "RecraftImageToImageNode",
          "RecraftRemoveBackgroundNode",
          "RecraftReplaceBackgroundNode",
          "RecraftStyleV3DigitalIllustration",
          "RecraftStyleV3InfiniteStyleLibrary",
          "RecraftStyleV3LogoRaster",
          "RecraftStyleV3RealisticImage",
          "RecraftTextToImageNode",
          "RecraftTextToVectorNode",
          "RecraftVectorizeImageNode"
        ],
        "nodes_rodin.py": [
          "Rodin3D_Detail",
          "Rodin3D_Regular",
          "Rodin3D_Sketch",
          "Rodin3D_Smooth"
        ],
        "nodes_runway.py": [
          "RunwayFirstLastFrameNode",
          "RunwayImageToVideoNodeGen3a",
          "RunwayImageToVideoNodeGen4",
          "RunwayTextToImageNode"
        ],
        "nodes_stability.py": [
          "StabilityAudioInpaint",
          "StabilityAudioToAudio",
          "StabilityStableImageSD_3_5Node",
          "StabilityStableImageUltraNode",
          "StabilityTextToAudio",
          "StabilityUpscaleConservativeNode",
          "StabilityUpscaleCreativeNode",
          "StabilityUpscaleFastNode"
        ],
        "nodes_tripo.py": [
          "TripoConversionNode",
          "TripoImageToModelNode",
          "TripoMultiviewToModelNode",
          "TripoRefineNode",
          "TripoRetargetNode",
          "TripoRigNode",
          "TripoTextToModelNode",
          "TripoTextureNode"
        ],
        "nodes_veo2.py": [
          "Veo3VideoGenerationNode",
          "VeoVideoGenerationNode"
        ],
        "nodes_vidu.py": [
          "ViduImageToVideoNode",
          "ViduReferenceVideoNode",
          "ViduStartEndToVideoNode",
          "ViduTextToVideoNode"
        ]
      }
    },
    "custom": {
      "source": "custom_nodes",
      "nodes": [
        "SaveImageWebsocket"
      ],
      "count": 1,
      "by_file": {
        "websocket_image_save.py": [
          "SaveImageWebsocket"
        ]
      }
    },
    "frontend": {
      "source": "known_frontend_and_custom",
      "nodes": [
        "MarkdownNote",
        "Note",
        "PrimitiveNode",
        "Reroute",
        "SaveImageWebsocket"
      ],
      "count": 5,
      "description": "Frontend-only UI nodes and native custom nodes that exist in ComfyUI but are not backend-defined"
    }
  },
  "all_builtin_nodes": [
    "APG",
    "AddNoise",
    "AlignYourStepsScheduler",
    "AudioEncoderEncode",
    "AudioEncoderLoader",
    "BasicGuider",
    "BasicScheduler",
    "BetaSamplingScheduler",
    "ByteDanceFirstLastFrameNode",
    "ByteDanceImageEditNode",
    "ByteDanceImageNode",
    "ByteDanceImageReferenceNode",
    "ByteDanceImageToVideoNode",
    "ByteDanceSeedreamNode",
    "ByteDanceTextToVideoNode",
    "CFGGuider",
    "CFGNorm",
    "CFGZeroStar",
    "CLIPAttentionMultiply",
    "CLIPLoader",
    "CLIPMergeAdd",
    "CLIPMergeSimple",
    "CLIPMergeSubtract",
    "CLIPSave",
    "CLIPSetLastLayer",
    "CLIPTextEncode",
    "CLIPTextEncodeControlnet",
    "CLIPTextEncodeFlux",
    "CLIPTextEncodeHiDream",
    "CLIPTextEncodeHunyuanDiT",
    "CLIPTextEncodeLumina2",
    "CLIPTextEncodePixArtAlpha",
    "CLIPTextEncodeSD3",
    "CLIPTextEncodeSDXL",
    "CLIPTextEncodeSDXLRefiner",
    "CLIPVisionEncode",
    "CLIPVisionLoader",
    "Canny",
    "CaseConverter",
    "CheckpointLoader",
    "CheckpointLoaderSimple",
    "CheckpointSave",
    "CombineHooks2",
    "CombineHooks4",
    "CombineHooks8",
    "ConditioningAverage",
    "ConditioningCombine",
    "ConditioningConcat",
    "ConditioningSetArea",
    "ConditioningSetAreaPercentage",
    "ConditioningSetAreaPercentageVideo",
    "ConditioningSetAreaStrength",
    "ConditioningSetDefaultCombine",
    "ConditioningSetMask",
    "ConditioningSetProperties",
    "ConditioningSetPropertiesAndCombine",
    "ConditioningSetTimestepRange",
    "ConditioningStableAudio",
    "ConditioningTimestepsRange",
    "ConditioningZeroOut",
    "ContextWindowsManual",
    "ControlNetApply",
    "ControlNetApplyAdvanced",
    "ControlNetApplySD3",
    "ControlNetInpaintingAliMamaApply",
    "ControlNetLoader",
    "CosmosImageToVideoLatent",
    "CosmosPredict2ImageToVideoLatent",
    "CreateHookKeyframe",
    "CreateHookKeyframesFromFloats",
    "CreateHookKeyframesInterpolated",
    "CreateHookLora",
    "CreateHookLoraModelOnly",
    "CreateHookModelAsLora",
    "CreateHookModelAsLoraModelOnly",
    "CreateVideo",
    "CropMask",
    "DiffControlNetLoader",
    "DifferentialDiffusion",
    "DiffusersLoader",
    "DisableNoise",
    "DualCFGGuider",
    "DualCLIPLoader",
    "EasyCache",
    "EmptyAceStepLatentAudio",
    "EmptyCosmosLatentVideo",
    "EmptyHunyuanImageLatent",
    "EmptyHunyuanLatentVideo",
    "EmptyImage",
    "EmptyLTXVLatentVideo",
    "EmptyLatentAudio",
    "EmptyLatentHunyuan3Dv2",
    "EmptyLatentImage",
    "EmptyMochiLatentVideo",
    "EmptySD3LatentImage",
    "ExponentialScheduler",
    "ExtendIntermediateSigmas",
    "FeatherMask",
    "FlipSigmas",
    "FluxDisableGuidance",
    "FluxGuidance",
    "FluxKontextImageScale",
    "FluxKontextMaxImageNode",
    "FluxKontextMultiReferenceLatentMethod",
    "FluxKontextProImageNode",
    "FluxProCannyNode",
    "FluxProDepthNode",
    "FluxProExpandNode",
    "FluxProFillNode",
    "FluxProUltraImageNode",
    "FreSca",
    "FreeU",
    "FreeU_V2",
    "GITSScheduler",
    "GLIGENLoader",
    "GLIGENTextBoxApply",
    "GeminiImageNode",
    "GeminiInputFiles",
    "GeminiNode",
    "GetImageSize",
    "GetVideoComponents",
    "GrowMask",
    "Hunyuan3Dv2Conditioning",
    "Hunyuan3Dv2ConditioningMultiView",
    "HunyuanImageToVideo",
    "HyperTile",
    "HypernetworkLoader",
    "IdeogramV1",
    "IdeogramV2",
    "IdeogramV3",
    "ImageAddNoise",
    "ImageBatch",
    "ImageBlend",
    "ImageBlur",
    "ImageColorToMask",
    "ImageCompositeMasked",
    "ImageCrop",
    "ImageFlip",
    "ImageFromBatch",
    "ImageInvert",
    "ImageOnlyCheckpointLoader",
    "ImageOnlyCheckpointSave",
    "ImagePadForOutpaint",
    "ImageQuantize",
    "ImageRGBToYUV",
    "ImageRotate",
    "ImageScale",
    "ImageScaleBy",
    "ImageScaleToMaxDimension",
    "ImageScaleToTotalPixels",
    "ImageSharpen",
    "ImageStitch",
    "ImageToMask",
    "ImageUpscaleWithModel",
    "ImageYUVToRGB",
    "InpaintModelConditioning",
    "InstructPixToPixConditioning",
    "InvertMask",
    "JoinImageWithAlpha",
    "KSampler",
    "KSamplerAdvanced",
    "KSamplerSelect",
    "KarrasScheduler",
    "KlingCameraControlI2VNode",
    "KlingCameraControlT2VNode",
    "KlingCameraControls",
    "KlingDualCharacterVideoEffectNode",
    "KlingImage2VideoNode",
    "KlingImageGenerationNode",
    "KlingLipSyncAudioToVideoNode",
    "KlingLipSyncTextToVideoNode",
    "KlingSingleImageVideoEffectNode",
    "KlingStartEndFrameNode",
    "KlingTextToVideoNode",
    "KlingVideoExtendNode",
    "KlingVirtualTryOnNode",
    "LTXVAddGuide",
    "LTXVConditioning",
    "LTXVCropGuides",
    "LTXVImgToVideo",
    "LTXVPreprocess",
    "LTXVScheduler",
    "LaplaceScheduler",
    "LatentAdd",
    "LatentApplyOperation",
    "LatentApplyOperationCFG",
    "LatentBatch",
    "LatentBatchSeedBehavior",
    "LatentBlend",
    "LatentComposite",
    "LatentCompositeMasked",
    "LatentConcat",
    "LatentCrop",
    "LatentCut",
    "LatentFlip",
    "LatentFromBatch",
    "LatentInterpolate",
    "LatentMultiply",
    "LatentOperationSharpen",
    "LatentOperationTonemapReinhard",
    "LatentRotate",
    "LatentSubtract",
    "LatentUpscale",
    "LatentUpscaleBy",
    "LazyCache",
    "Load3D",
    "Load3DAnimation",
    "LoadAudio",
    "LoadImage",
    "LoadImageMask",
    "LoadImageOutput",
    "LoadImageSetFromFolderNode",
    "LoadImageTextSetFromFolderNode",
    "LoadLatent",
    "LoadVideo",
    "LoraLoader",
    "LoraLoaderModelOnly",
    "LoraModelLoader",
    "LoraSave",
    "LossGraphNode",
    "LotusConditioning",
    "LumaConceptsNode",
    "LumaImageModifyNode",
    "LumaImageNode",
    "LumaImageToVideoNode",
    "LumaReferenceNode",
    "LumaVideoNode",
    "Mahiro",
    "MarkdownNote",
    "MaskComposite",
    "MaskPreview",
    "MaskToImage",
    "MinimaxHailuoVideoNode",
    "MinimaxImageToVideoNode",
    "MinimaxTextToVideoNode",
    "ModelComputeDtype",
    "ModelMergeAdd",
    "ModelMergeAuraflow",
    "ModelMergeBlocks",
    "ModelMergeCosmos14B",
    "ModelMergeCosmos7B",
    "ModelMergeCosmosPredict2_14B",
    "ModelMergeCosmosPredict2_2B",
    "ModelMergeFlux1",
    "ModelMergeLTXV",
    "ModelMergeMochiPreview",
    "ModelMergeQwenImage",
    "ModelMergeSD1",
    "ModelMergeSD2",
    "ModelMergeSD35_Large",
    "ModelMergeSD3_2B",
    "ModelMergeSDXL",
    "ModelMergeSimple",
    "ModelMergeSubtract",
    "ModelMergeWAN2_1",
    "ModelPatchLoader",
    "ModelSamplingAuraFlow",
    "ModelSamplingContinuousEDM",
    "ModelSamplingContinuousV",
    "ModelSamplingDiscrete",
    "ModelSamplingFlux",
    "ModelSamplingLTXV",
    "ModelSamplingSD3",
    "ModelSamplingStableCascade",
    "ModelSave",
    "MoonvalleyImg2VideoNode",
    "MoonvalleyTxt2VideoNode",
    "MoonvalleyVideo2VideoNode",
    "Morphology",
    "Note",
    "OpenAIChatConfig",
    "OpenAIChatNode",
    "OpenAIDalle2",
    "OpenAIDalle3",
    "OpenAIGPTImage1",
    "OpenAIInputFiles",
    "OptimalStepsScheduler",
    "PairConditioningCombine",
    "PairConditioningSetDefaultCombine",
    "PairConditioningSetProperties",
    "PairConditioningSetPropertiesAndCombine",
    "PatchModelAddDownscale",
    "PerpNeg",
    "PerpNegGuider",
    "PerturbedAttentionGuidance",
    "PhotoMakerEncode",
    "PhotoMakerLoader",
    "PikaImageToVideoNode2_2",
    "PikaScenesV2_2",
    "PikaStartEndFrameNode2_2",
    "PikaTextToVideoNode2_2",
    "Pikadditions",
    "Pikaffects",
    "Pikaswaps",
    "PixverseImageToVideoNode",
    "PixverseTemplateNode",
    "PixverseTextToVideoNode",
    "PixverseTransitionVideoNode",
    "PolyexponentialScheduler",
    "PorterDuffImageComposite",
    "Preview3D",
    "Preview3DAnimation",
    "PreviewAny",
    "PreviewAudio",
    "PreviewImage",
    "PrimitiveBoolean",
    "PrimitiveFloat",
    "PrimitiveInt",
    "PrimitiveNode",
    "PrimitiveString",
    "PrimitiveStringMultiline",
    "QuadrupleCLIPLoader",
    "QwenImageDiffsynthControlnet",
    "RandomNoise",
    "RebatchImages",
    "RebatchLatents",
    "RecordAudio",
    "RecraftColorRGB",
    "RecraftControls",
    "RecraftCreativeUpscaleNode",
    "RecraftCrispUpscaleNode",
    "RecraftImageInpaintingNode",
    "RecraftImageToImageNode",
    "RecraftRemoveBackgroundNode",
    "RecraftReplaceBackgroundNode",
    "RecraftStyleV3DigitalIllustration",
    "RecraftStyleV3InfiniteStyleLibrary",
    "RecraftStyleV3LogoRaster",
    "RecraftStyleV3RealisticImage",
    "RecraftTextToImageNode",
    "RecraftTextToVectorNode",
    "RecraftVectorizeImageNode",
    "ReferenceLatent",
    "RegexExtract",
    "RegexMatch",
    "RegexReplace",
    "RenormCFG",
    "RepeatImageBatch",
    "RepeatLatentBatch",
    "Reroute",
    "RescaleCFG",
    "ResizeAndPadImage",
    "Rodin3D_Detail",
    "Rodin3D_Regular",
    "Rodin3D_Sketch",
    "Rodin3D_Smooth",
    "RunwayFirstLastFrameNode",
    "RunwayImageToVideoNodeGen3a",
    "RunwayImageToVideoNodeGen4",
    "RunwayTextToImageNode",
    "SDTurboScheduler",
    "SD_4XUpscale_Conditioning",
    "SV3D_Conditioning",
    "SVD_img2vid_Conditioning",
    "SamplerCustom",
    "SamplerCustomAdvanced",
    "SamplerDPMAdaptative",
    "SamplerDPMPP_2M_SDE",
    "SamplerDPMPP_2S_Ancestral",
    "SamplerDPMPP_3M_SDE",
    "SamplerDPMPP_SDE",
    "SamplerER_SDE",
    "SamplerEulerAncestral",
    "SamplerEulerAncestralCFGPP",
    "SamplerEulerCFGpp",
    "SamplerLCMUpscale",
    "SamplerLMS",
    "SamplerSASolver",
    "SamplingPercentToSigma",
    "SaveAnimatedPNG",
    "SaveAnimatedWEBP",
    "SaveAudio",
    "SaveAudioMP3",
    "SaveAudioOpus",
    "SaveGLB",
    "SaveImage",
    "SaveImageWebsocket",
    "SaveLatent",
    "SaveLoRANode",
    "SaveSVGNode",
    "SaveVideo",
    "SaveWEBM",
    "SelfAttentionGuidance",
    "SetClipHooks",
    "SetFirstSigma",
    "SetHookKeyframes",
    "SetLatentNoiseMask",
    "SetUnionControlNetType",
    "SkipLayerGuidanceDiT",
    "SkipLayerGuidanceDiTSimple",
    "SkipLayerGuidanceSD3",
    "SolidMask",
    "SplitImageWithAlpha",
    "SplitSigmas",
    "SplitSigmasDenoise",
    "StabilityAudioInpaint",
    "StabilityAudioToAudio",
    "StabilityStableImageSD_3_5Node",
    "StabilityStableImageUltraNode",
    "StabilityTextToAudio",
    "StabilityUpscaleConservativeNode",
    "StabilityUpscaleCreativeNode",
    "StabilityUpscaleFastNode",
    "StableCascade_EmptyLatentImage",
    "StableCascade_StageB_Conditioning",
    "StableCascade_StageC_VAEEncode",
    "StableCascade_SuperResolutionControlnet",
    "StableZero123_Conditioning",
    "StableZero123_Conditioning_Batched",
    "StringCompare",
    "StringConcatenate",
    "StringContains",
    "StringLength",
    "StringReplace",
    "StringSubstring",
    "StringTrim",
    "StyleModelApply",
    "StyleModelLoader",
    "T5TokenizerOptions",
    "TCFG",
    "TextEncodeAceStepAudio",
    "TextEncodeHunyuanVideo_ImageToVideo",
    "TextEncodeQwenImageEdit",
    "ThresholdMask",
    "TomePatchModel",
    "TorchCompileModel",
    "TrainLoraNode",
    "TrimVideoLatent",
    "TripleCLIPLoader",
    "TripoConversionNode",
    "TripoImageToModelNode",
    "TripoMultiviewToModelNode",
    "TripoRefineNode",
    "TripoRetargetNode",
    "TripoRigNode",
    "TripoTextToModelNode",
    "TripoTextureNode",
    "UNETLoader",
    "UNetCrossAttentionMultiply",
    "UNetSelfAttentionMultiply",
    "UNetTemporalAttentionMultiply",
    "USOStyleReference",
    "UpscaleModelLoader",
    "VAEDecode",
    "VAEDecodeAudio",
    "VAEDecodeHunyuan3D",
    "VAEDecodeTiled",
    "VAEEncode",
    "VAEEncodeAudio",
    "VAEEncodeForInpaint",
    "VAEEncodeTiled",
    "VAELoader",
    "VAESave",
    "VPScheduler",
    "Veo3VideoGenerationNode",
    "VeoVideoGenerationNode",
    "VideoLinearCFGGuidance",
    "VideoTriangleCFGGuidance",
    "ViduImageToVideoNode",
    "ViduReferenceVideoNode",
    "ViduStartEndToVideoNode",
    "ViduTextToVideoNode",
    "VoxelToMesh",
    "VoxelToMeshBasic",
    "Wan22FunControlToVideo",
    "Wan22ImageToVideoLatent",
    "WanCameraEmbedding",
    "WanCameraImageToVideo",
    "WanContextWindowsManual",
    "WanFirstLastFrameToVideo",
    "WanFunControlToVideo",
    "WanFunInpaintToVideo",
    "WanImageToVideo",
    "WanPhantomSubjectToVideo",
    "WanSoundImageToVideo",
    "WanSoundImageToVideoExtend",
    "WanTrackToVideo",
    "WanVaceToVideo",
    "WebcamCapture",
    "unCLIPCheckpointLoader",
    "unCLIPConditioning"
  ]
}