"""Simplified sync models for ComfyDock - workflow sync removed."""

from dataclasses import dataclass, field
from typing import List


@dataclass
class SyncResult:
    """Result from environment sync operation - no workflow sync anymore."""

    # Package sync
    packages_synced: bool = False

    # Dependency groups
    dependency_groups_installed: List[str] = field(default_factory=list)  # Group names
    dependency_groups_failed: List[tuple[str, str]] = field(default_factory=list)  # (group_name, error)

    # Node sync
    nodes_installed: List[str] = field(default_factory=list)
    nodes_removed: List[str] = field(default_factory=list)
    nodes_updated: List[str] = field(default_factory=list)

    # Model paths
    model_paths_configured: bool = False

    # Model downloads
    models_downloaded: List[str] = field(default_factory=list)  # Filenames
    models_failed: List[tuple[str, str]] = field(default_factory=list)  # (filename, error)

    # Overall status
    success: bool = True
    errors: List[str] = field(default_factory=list)

    @property
    def has_changes(self) -> bool:
        """Check if any changes were made during sync."""
        return (
            self.packages_synced or
            bool(self.nodes_installed) or
            bool(self.nodes_removed) or
            bool(self.nodes_updated)
        )