"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineExportDialog = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const React = __importStar(require("react"));
const PipelineService_1 = require("./PipelineService");
const KFP_FILE_TYPES = [
    { label: 'KFP domain-specific language Python code', key: 'py' },
    { label: 'KFP static configuration file (YAML formatted)', key: 'yaml' }
];
const AIRFLOW_FILE_TYPES = [
    { label: 'Airflow domain-specific language Python code', key: 'py' }
];
class PipelineExportDialog extends React.Component {
    constructor() {
        super(...arguments);
        this.state = {
            displayedRuntimeOptions: new Array(),
            fileTypes: new Array(),
            validSchemas: new Array()
        };
        this.handleUpdate = (event) => {
            const selectedPlatform = event.target.value;
            this.setState({
                displayedRuntimeOptions: this.updateRuntimeOptions(selectedPlatform),
                fileTypes: this.updateFileTypeOptions(selectedPlatform)
            });
        };
        this.updateRuntimeOptions = (platformSelection) => {
            const filteredRuntimeOptions = PipelineService_1.PipelineService.filterRuntimes(this.props.runtimes, platformSelection);
            PipelineService_1.PipelineService.sortRuntimesByDisplayName(filteredRuntimeOptions);
            return filteredRuntimeOptions;
        };
        this.updateFileTypeOptions = (platformSelection) => {
            if (!platformSelection) {
                return new Array();
            }
            else if (platformSelection === PipelineService_1.KFP_SCHEMA) {
                // TODO: remove temporary workaround for KFP Python DSL export option
                // See https://github.com/elyra-ai/elyra/issues/1760 for context.
                if (this.props.runtime === PipelineService_1.KFP_SCHEMA) {
                    return [KFP_FILE_TYPES[1]];
                }
                return KFP_FILE_TYPES;
            }
            return AIRFLOW_FILE_TYPES;
        };
    }
    componentDidMount() {
        var _a;
        const { schema, runtimes } = this.props;
        const validSchemas = PipelineService_1.PipelineService.filterValidSchema(runtimes, schema);
        const selectedRuntimePlatform = (_a = this.props.runtime) !== null && _a !== void 0 ? _a : (validSchemas[0] && validSchemas[0].name);
        const displayedRuntimeOptions = this.updateRuntimeOptions(selectedRuntimePlatform);
        const fileTypes = this.updateFileTypeOptions(selectedRuntimePlatform);
        this.setState({
            displayedRuntimeOptions: displayedRuntimeOptions,
            fileTypes: fileTypes,
            validSchemas: validSchemas
        });
    }
    render() {
        const { displayedRuntimeOptions, fileTypes, validSchemas } = this.state;
        return (jsx_runtime_1.jsxs("form", Object.assign({ className: "elyra-dialog-form" }, { children: [!this.props.runtime && (jsx_runtime_1.jsxs("div", { children: [jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "runtime_platform" }, { children: "Runtime Platform:" }), void 0),
                        jsx_runtime_1.jsx("br", {}, void 0),
                        jsx_runtime_1.jsx("select", Object.assign({ id: "runtime_platform", name: "runtime_platform", className: "elyra-form-runtime-platform", "data-form-required": true, onChange: this.handleUpdate }, { children: validSchemas.map(schema => (jsx_runtime_1.jsx("option", Object.assign({ value: schema.name }, { children: schema.display_name }), schema.name))) }), void 0)] }, void 0)),
                jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "runtime_config" }, { children: "Runtime Configuration:" }), void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsx("select", Object.assign({ id: "runtime_config", name: "runtime_config", className: "elyra-form-runtime-config", "data-form-required": true }, { children: displayedRuntimeOptions.map(runtime => (jsx_runtime_1.jsx("option", Object.assign({ value: runtime.name }, { children: runtime.display_name }), runtime.name))) }), void 0),
                jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "pipeline_filetype" }, { children: "Export Pipeline as:" }), void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsx("select", Object.assign({ id: "pipeline_filetype", name: "pipeline_filetype", className: "elyra-form-export-filetype", "data-form-required": true }, { children: fileTypes.map(filetype => (jsx_runtime_1.jsx("option", Object.assign({ value: filetype['key'] }, { children: filetype['label'] }), filetype['key']))) }), void 0),
                jsx_runtime_1.jsx("input", { type: "checkbox", className: "elyra-Dialog-checkbox", id: "overwrite", name: "overwrite" }, void 0),
                jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "overwrite" }, { children: "Replace if file already exists" }), void 0),
                jsx_runtime_1.jsx("br", {}, void 0)] }), void 0));
    }
}
exports.PipelineExportDialog = PipelineExportDialog;
//# sourceMappingURL=PipelineExportDialog.js.map