"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineSubmissionDialog = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const React = __importStar(require("react"));
const PipelineService_1 = require("./PipelineService");
class PipelineSubmissionDialog extends React.Component {
    constructor() {
        super(...arguments);
        this.state = {
            validSchemas: new Array()
        };
        this.handleUpdate = (event) => {
            const selectedPlatform = event.target.value;
            this.setState({
                selectedRuntimePlatform: selectedPlatform
            });
        };
        this.getRuntimeOptions = (platformSelection) => {
            var _a;
            const filteredRuntimeOptions = PipelineService_1.PipelineService.filterRuntimes(this.props.runtimes, (_a = platformSelection !== null && platformSelection !== void 0 ? platformSelection : this.props.runtime) !== null && _a !== void 0 ? _a : (this.props.schema[0] && this.props.schema[0].name));
            PipelineService_1.PipelineService.sortRuntimesByDisplayName(filteredRuntimeOptions);
            return filteredRuntimeOptions;
        };
    }
    componentDidMount() {
        const { schema, runtimes } = this.props;
        this.setState({
            validSchemas: PipelineService_1.PipelineService.filterValidSchema(runtimes, schema)
        });
    }
    render() {
        var _a;
        const { name } = this.props;
        const { selectedRuntimePlatform, validSchemas } = this.state;
        const displayedRuntimeOptions = this.getRuntimeOptions(selectedRuntimePlatform);
        return (jsx_runtime_1.jsxs("form", Object.assign({ className: "elyra-dialog-form" }, { children: [jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "pipeline_name" }, { children: "Pipeline Name:" }), void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsx("input", { type: "text", id: "pipeline_name", name: "pipeline_name", defaultValue: name, "data-form-required": true }, void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                !this.props.runtime && (jsx_runtime_1.jsxs("div", { children: [jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "runtime_platform" }, { children: "Runtime Platform:" }), void 0),
                        jsx_runtime_1.jsx("br", {}, void 0),
                        jsx_runtime_1.jsx("select", Object.assign({ id: "runtime_platform", name: "runtime_platform", className: "elyra-form-runtime-platform", "data-form-required": true, value: (_a = selectedRuntimePlatform !== null && selectedRuntimePlatform !== void 0 ? selectedRuntimePlatform : this.props.runtime) !== null && _a !== void 0 ? _a : (this.props.schema[0] && this.props.schema[0].name), onChange: this.handleUpdate }, { children: validSchemas.map(schema => (jsx_runtime_1.jsx("option", Object.assign({ value: schema.name }, { children: schema.display_name }), schema.name))) }), void 0)] }, void 0)),
                jsx_runtime_1.jsx("label", Object.assign({ htmlFor: "runtime_config" }, { children: "Runtime Configuration:" }), void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsx("select", Object.assign({ id: "runtime_config", name: "runtime_config", className: "elyra-form-runtime-config", "data-form-required": true }, { children: displayedRuntimeOptions.map(runtime => (jsx_runtime_1.jsx("option", Object.assign({ value: runtime.name }, { children: runtime.display_name }), runtime.name))) }), void 0)] }), void 0));
    }
}
exports.PipelineSubmissionDialog = PipelineSubmissionDialog;
//# sourceMappingURL=PipelineSubmissionDialog.js.map