"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RuntimesWidget = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const metadata_common_1 = require("@elyra/metadata-common");
const ui_components_1 = require("@elyra/ui-components");
const PipelineService_1 = require("./PipelineService");
const RUNTIMES_METADATA_CLASS = 'elyra-metadata-runtimes';
const addTrailingSlash = (url) => {
    return url.endsWith('/') ? url : url + '/';
};
const getGithubURLFromAPI = (apiEndpoint) => {
    // For Enterprise Server the api is located at <hostname>/api/
    let baseURL = new URL(apiEndpoint).origin;
    // For Github.com and Github AE the api is located at api.<hostname>
    baseURL = baseURL.replace('api.', '');
    return addTrailingSlash(baseURL);
};
/**
 * A React Component for displaying the runtimes list.
 */
class RuntimesDisplay extends metadata_common_1.MetadataDisplay {
    renderExpandableContent(metadata) {
        var _a;
        const apiEndpoint = addTrailingSlash(metadata.metadata.api_endpoint);
        const cosEndpoint = addTrailingSlash(metadata.metadata.cos_endpoint);
        let githubRepoElement = null;
        let metadata_props = null;
        for (const schema of (_a = this.props.schemas) !== null && _a !== void 0 ? _a : []) {
            if (schema.name === metadata.schema_name) {
                metadata_props = schema.properties.metadata.properties;
            }
        }
        if (metadata.schema_name === 'airflow' && metadata_props) {
            const githubRepoUrl = getGithubURLFromAPI(metadata.metadata.github_api_endpoint) +
                metadata.metadata.github_repo +
                '/tree/' +
                metadata.metadata.github_branch +
                '/';
            githubRepoElement = (jsx_runtime_1.jsxs("span", { children: [jsx_runtime_1.jsx("h6", { children: metadata_props.github_repo.title }, void 0),
                    jsx_runtime_1.jsx("a", Object.assign({ href: githubRepoUrl, target: "_blank", rel: "noreferrer noopener" }, { children: githubRepoUrl }), void 0),
                    jsx_runtime_1.jsx("br", {}, void 0),
                    jsx_runtime_1.jsx("br", {}, void 0)] }, void 0));
        }
        return (jsx_runtime_1.jsxs("div", { children: [jsx_runtime_1.jsx("h6", { children: metadata_props ? metadata_props.api_endpoint.title : 'API Endpoint' }, void 0),
                jsx_runtime_1.jsx("a", Object.assign({ href: apiEndpoint, target: "_blank", rel: "noreferrer noopener" }, { children: apiEndpoint }), void 0),
                jsx_runtime_1.jsx("br", {}, void 0),
                jsx_runtime_1.jsx("br", {}, void 0), githubRepoElement, jsx_runtime_1.jsx("h6", { children: metadata_props
                        ? metadata_props.cos_endpoint.title
                        : 'Cloud Object Storage' }, void 0),
                jsx_runtime_1.jsx("a", Object.assign({ href: cosEndpoint, target: "_blank", rel: "noreferrer noopener" }, { children: cosEndpoint }), void 0)] }, void 0));
    }
}
/**
 * A widget for displaying runtimes.
 */
class RuntimesWidget extends metadata_common_1.MetadataWidget {
    constructor(props) {
        super(props);
        this.getSchemaTitle = (metadata) => {
            if (this.schemas) {
                for (const schema of this.schemas) {
                    if (schema.name === metadata.schema_name) {
                        return schema.title;
                    }
                }
            }
            return 'runtime configuration';
        };
    }
    fetchMetadata() {
        return __awaiter(this, void 0, void 0, function* () {
            return yield PipelineService_1.PipelineService.getRuntimes(false).catch(error => ui_components_1.RequestErrors.serverError(error));
        });
    }
    renderDisplay(metadata) {
        if (Array.isArray(metadata) && !metadata.length) {
            // Empty metadata
            return (jsx_runtime_1.jsxs("div", { children: [jsx_runtime_1.jsx("br", {}, void 0),
                    jsx_runtime_1.jsx("h6", Object.assign({ className: "elyra-no-metadata-msg" }, { children: "Click the + button to add a new Runtime" }), void 0)] }, void 0));
        }
        return (jsx_runtime_1.jsx(RuntimesDisplay, { metadata: metadata, updateMetadata: this.updateMetadata, openMetadataEditor: this.openMetadataEditor, schemaspace: PipelineService_1.RUNTIMES_SCHEMASPACE, sortMetadata: true, schemas: this.schemas, className: RUNTIMES_METADATA_CLASS, labelName: this.getSchemaTitle }, void 0));
    }
}
exports.RuntimesWidget = RuntimesWidget;
//# sourceMappingURL=RuntimesWidget.js.map