"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SubmitScriptButtonExtension = void 0;
const jsx_runtime_1 = require("react/jsx-runtime");
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const services_1 = require("@elyra/services");
const ui_components_1 = require("@elyra/ui-components");
const apputils_1 = require("@jupyterlab/apputils");
const coreutils_1 = require("@jupyterlab/coreutils");
const FileSubmissionDialog_1 = require("./FileSubmissionDialog");
const formDialogWidget_1 = require("./formDialogWidget");
const PipelineService_1 = require("./PipelineService");
const utils_1 = __importDefault(require("./utils"));
/**
 * Submit script button extension
 *  - Attach button to FileEditor toolbar and launch a dialog requesting
 *  information where submit the script for execution
 */
class SubmitScriptButtonExtension {
    constructor() {
        this.showWidget = (editor) => __awaiter(this, void 0, void 0, function* () {
            if (editor.context.model.dirty) {
                const dialogResult = yield apputils_1.showDialog({
                    title: 'This script contains unsaved changes. To run the script as a pipeline the changes need to be saved.',
                    buttons: [
                        apputils_1.Dialog.cancelButton(),
                        apputils_1.Dialog.okButton({ label: 'Save and Submit' })
                    ]
                });
                if (dialogResult.button && dialogResult.button.accept === true) {
                    yield editor.context.save();
                }
                else {
                    // Don't proceed if cancel button pressed
                    return;
                }
            }
            const env = yield services_1.ContentParser.getEnvVars(editor.context.path.toString()).catch(error => ui_components_1.RequestErrors.serverError(error));
            const action = 'run script as pipeline';
            const runtimes = yield PipelineService_1.PipelineService.getRuntimes(true, action).catch(error => ui_components_1.RequestErrors.serverError(error));
            if (utils_1.default.isDialogResult(runtimes)) {
                if (runtimes.button.label.includes(PipelineService_1.RUNTIMES_SCHEMASPACE)) {
                    // Open the runtimes widget
                    utils_1.default.getLabShell(editor).activateById(`elyra-metadata:${PipelineService_1.RUNTIMES_SCHEMASPACE}`);
                }
                return;
            }
            const images = yield PipelineService_1.PipelineService.getRuntimeImages().catch(error => ui_components_1.RequestErrors.serverError(error));
            const schema = yield PipelineService_1.PipelineService.getRuntimesSchema().catch(error => ui_components_1.RequestErrors.serverError(error));
            const fileExtension = coreutils_1.PathExt.extname(editor.context.path);
            const dialogOptions = {
                title: 'Run script as pipeline',
                body: formDialogWidget_1.formDialogWidget(jsx_runtime_1.jsx(FileSubmissionDialog_1.FileSubmissionDialog, { env: env, dependencyFileExtension: fileExtension, images: images, runtimes: runtimes, schema: schema }, void 0)),
                buttons: [apputils_1.Dialog.cancelButton(), apputils_1.Dialog.okButton()]
            };
            const dialogResult = yield ui_components_1.showFormDialog(dialogOptions);
            if (dialogResult.value == null) {
                // When Cancel is clicked on the dialog, just return
                return;
            }
            const _a = dialogResult.value, { runtime_platform, runtime_config, framework, cpu, gpu, memory, dependency_include, dependencies } = _a, envObject = __rest(_a, ["runtime_platform", "runtime_config", "framework", "cpu", "gpu", "memory", "dependency_include", "dependencies"]);
            // prepare submission details
            const pipeline = utils_1.default.generateSingleFilePipeline(editor.context.path, runtime_platform, runtime_config, framework, dependency_include ? dependencies.split(',') : undefined, envObject, cpu, gpu, memory);
            const displayName = PipelineService_1.PipelineService.getDisplayName(runtime_config, runtimes);
            PipelineService_1.PipelineService.submitPipeline(pipeline, displayName).catch(error => ui_components_1.RequestErrors.serverError(error));
        });
    }
    createNew(editor, context) {
        // Create the toolbar button
        const submitScriptButton = new apputils_1.ToolbarButton({
            label: 'Run as Pipeline',
            onClick: () => this.showWidget(editor),
            tooltip: 'Run script as batch'
        });
        // Add the toolbar button to editor
        editor.toolbar.insertItem(10, 'submitScript', submitScriptButton);
        // The ToolbarButton class implements `IDisposable`, so the
        // button *is* the extension for the purposes of this method.
        return submitScriptButton;
    }
}
exports.SubmitScriptButtonExtension = SubmitScriptButtonExtension;
//# sourceMappingURL=SubmitScriptButtonExtension.js.map