"use strict";
/*
 * Copyright 2018-2021 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.usePalette = exports.getRuntimeIcon = exports.useRuntimesSchema = exports.useRuntimeImages = void 0;
const services_1 = require("@elyra/services");
const ui_components_1 = require("@elyra/ui-components");
const ui_components_2 = require("@jupyterlab/ui-components");
const immer_1 = __importDefault(require("immer"));
const swr_1 = __importDefault(require("swr"));
const metadataFetcher = (key) => __awaiter(void 0, void 0, void 0, function* () {
    return yield services_1.MetadataService.getMetadata(key);
});
const useRuntimeImages = () => {
    const { data, error } = swr_1.default('runtime-images', metadataFetcher);
    data === null || data === void 0 ? void 0 : data.sort((a, b) => 0 - (a.name > b.name ? -1 : 1));
    return { data, error };
};
exports.useRuntimeImages = useRuntimeImages;
const schemaFetcher = (key) => __awaiter(void 0, void 0, void 0, function* () {
    return yield services_1.MetadataService.getSchema(key);
});
// TODO: type this
const useRuntimesSchema = () => {
    const { data, error } = swr_1.default('runtimes', schemaFetcher);
    return { data, error };
};
exports.useRuntimesSchema = useRuntimesSchema;
// TODO: We should decouple components and properties to support lazy loading.
// TODO: type this
const componentFetcher = (runtime) => __awaiter(void 0, void 0, void 0, function* () {
    const palette = yield services_1.RequestHandler.makeGetRequest(`elyra/pipeline/components/${runtime}`);
    // Gather list of component IDs to fetch properties for.
    const componentList = [];
    for (const category of palette.categories) {
        for (const node of category.node_types) {
            componentList.push(node.id);
        }
    }
    const propertiesPromises = componentList.map((componentID) => __awaiter(void 0, void 0, void 0, function* () {
        const res = yield services_1.RequestHandler.makeGetRequest(`elyra/pipeline/components/${runtime}/${componentID}/properties`);
        return {
            id: componentID,
            properties: res
        };
    }));
    // load all of the properties in parallel instead of serially
    const properties = yield Promise.all(propertiesPromises);
    // inject properties
    for (const category of palette.categories) {
        // TODO: The server will provide this in a later release
        switch (category.id) {
            case 'kfp':
                category.image = ui_components_1.IconUtil.encode(ui_components_1.kubeflowIcon);
                break;
            case 'airflow':
                category.image = ui_components_1.IconUtil.encode(ui_components_1.airflowIcon);
                break;
            case 'argo':
                category.image = ui_components_1.IconUtil.encode(ui_components_1.argoIcon);
                break;
            default:
                category.image = ui_components_1.IconUtil.encode(ui_components_1.IconUtil.colorize(ui_components_1.pipelineIcon, '#808080'));
                break;
        }
        for (const node of category.node_types) {
            const prop = properties.find(p => p.id === node.id);
            node.app_data.properties = prop === null || prop === void 0 ? void 0 : prop.properties;
        }
    }
    return palette;
});
// TODO: This should be enabled through `extensions`
const NodeIcons = new Map([
    [
        'execute-notebook-node',
        'data:image/svg+xml;utf8,' + encodeURIComponent(ui_components_2.notebookIcon.svgstr)
    ],
    [
        'execute-python-node',
        'data:image/svg+xml;utf8,' + encodeURIComponent(ui_components_1.pyIcon.svgstr)
    ],
    [
        'execute-r-node',
        'data:image/svg+xml;utf8,' + encodeURIComponent(ui_components_1.rIcon.svgstr)
    ]
]);
const getRuntimeIcon = (runtime) => {
    const runtimeIcons = [ui_components_1.kubeflowIcon, ui_components_1.airflowIcon, ui_components_1.argoIcon];
    for (const runtimeIcon of runtimeIcons) {
        if (`elyra:${runtime}` === runtimeIcon.name) {
            return runtimeIcon;
        }
    }
    return ui_components_1.pipelineIcon;
};
exports.getRuntimeIcon = getRuntimeIcon;
const usePalette = (pipelineRuntime = 'local') => {
    const { data: runtimeImages, error: runtimeError } = exports.useRuntimeImages();
    const { data: palette, error: paletteError } = swr_1.default(pipelineRuntime, componentFetcher);
    let updatedPalette;
    if (palette !== undefined) {
        updatedPalette = immer_1.default(palette, (draft) => {
            for (const category of draft.categories) {
                for (const node of category.node_types) {
                    // update icon
                    let nodeIcon = NodeIcons.get(node.op);
                    if (nodeIcon === undefined || nodeIcon === '') {
                        nodeIcon =
                            'data:image/svg+xml;utf8,' +
                                encodeURIComponent(exports.getRuntimeIcon(pipelineRuntime).svgstr);
                    }
                    // Not sure which is needed...
                    node.image = nodeIcon;
                    node.app_data.image = nodeIcon;
                    node.app_data.ui_data.image = nodeIcon;
                    // update runtime images
                    const runtimeImageIndex = node.app_data.properties.uihints.parameter_info.findIndex((p) => p.parameter_ref === 'elyra_runtime_image');
                    const displayNames = (runtimeImages !== null && runtimeImages !== void 0 ? runtimeImages : []).map(i => i.display_name);
                    if (runtimeImageIndex !== -1) {
                        node.app_data.properties.uihints.parameter_info[runtimeImageIndex].data.items = displayNames;
                    }
                }
            }
        });
    }
    return { data: updatedPalette, error: runtimeError !== null && runtimeError !== void 0 ? runtimeError : paletteError };
};
exports.usePalette = usePalette;
//# sourceMappingURL=pipeline-hooks.js.map