# coding: utf-8

import six

from huaweicloudsdkcore.sdk_response import SdkResponse
from huaweicloudsdkcore.utils.http_utils import sanitize_for_serialization


class ShowAppliedTemplateRecordResponse(SdkResponse):

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    sensitive_list = []

    openapi_types = {
        'total': 'int',
        'elements': 'list[ApplyRecord]'
    }

    attribute_map = {
        'total': 'total',
        'elements': 'elements'
    }

    def __init__(self, total=None, elements=None):
        r"""ShowAppliedTemplateRecordResponse

        The model defined in huaweicloud sdk

        :param total: **参数解释：** 查询域名模板总数 **约束限制：** 不涉及 **取值范围：** 不涉及 **默认取值：** 不涉及
        :type total: int
        :param elements: 
        :type elements: list[:class:`huaweicloudsdkcdn.v2.ApplyRecord`]
        """
        
        super(ShowAppliedTemplateRecordResponse, self).__init__()

        self._total = None
        self._elements = None
        self.discriminator = None

        if total is not None:
            self.total = total
        if elements is not None:
            self.elements = elements

    @property
    def total(self):
        r"""Gets the total of this ShowAppliedTemplateRecordResponse.

        **参数解释：** 查询域名模板总数 **约束限制：** 不涉及 **取值范围：** 不涉及 **默认取值：** 不涉及

        :return: The total of this ShowAppliedTemplateRecordResponse.
        :rtype: int
        """
        return self._total

    @total.setter
    def total(self, total):
        r"""Sets the total of this ShowAppliedTemplateRecordResponse.

        **参数解释：** 查询域名模板总数 **约束限制：** 不涉及 **取值范围：** 不涉及 **默认取值：** 不涉及

        :param total: The total of this ShowAppliedTemplateRecordResponse.
        :type total: int
        """
        self._total = total

    @property
    def elements(self):
        r"""Gets the elements of this ShowAppliedTemplateRecordResponse.

        :return: The elements of this ShowAppliedTemplateRecordResponse.
        :rtype: list[:class:`huaweicloudsdkcdn.v2.ApplyRecord`]
        """
        return self._elements

    @elements.setter
    def elements(self, elements):
        r"""Sets the elements of this ShowAppliedTemplateRecordResponse.

        :param elements: The elements of this ShowAppliedTemplateRecordResponse.
        :type elements: list[:class:`huaweicloudsdkcdn.v2.ApplyRecord`]
        """
        self._elements = elements

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                if attr in self.sensitive_list:
                    result[attr] = "****"
                else:
                    result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        import simplejson as json
        if six.PY2:
            import sys
            reload(sys)
            sys.setdefaultencoding("utf-8")
        return json.dumps(sanitize_for_serialization(self), ensure_ascii=False)

    def __repr__(self):
        """For `print`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ShowAppliedTemplateRecordResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
