#  PommeKit - Python library with various tools for interacting with Apple services and APIs
#  Copyright (C) 2024  Cypheriel
"""Status codes used by Apple's various services."""

from __future__ import annotations

from enum import IntEnum


class AppleStatusCode(IntEnum):
    """List of status codes used by Apple's various services."""

    SUCCESS = 0
    NO_RESULT_CODE = 1
    LEGACY_TUNNEL_OK = 200
    LEGACY_TUNNEL_BAD_REQUEST = 400
    PARSE_FAILURE = 1000
    INVALID_FIELD = 1001
    MESSAGE_REMOVED = 1002
    MESSAGE_INHIBITED = 1003
    DECODE_FAILURE_BASE_64 = 1004
    DECODE_FAILURE_HEX = 1005
    AUTH_FAILURE = 1006
    STORAGE_FAILURE = 1007
    INTERNAL_ERROR = 5001
    SERVER_TOO_BUSY = 5004
    BAD_PUSH_TOKEN = 5006
    MISSING_REQUIRED_KEY = 5008
    UPLUSONE_DISABLED = 5010
    BAD_SIGNATURE = 5032
    WEB_TUNNEL_SERVICE_DISABLED = 5200
    WEB_TUNNEL_SERVICE_INTERNAL_ERROR = 5201
    WEB_TUNNEL_SERVICE_TOO_BUSY = 5202
    WEB_TUNNEL_SERVICE_MISSING_KEY = 5203
    WEB_TUNNEL_SERVICE_MALFORMED_URL = 5204
    WEB_TUNNEL_SERVICE_UNAUTHORIZED_URL = 5205
    WEB_TUNNEL_SERVICE_RESPONSE_TOO_LARGE = 5206
    WEB_TUNNEL_SERVICE_ORIGIN_SERVER_TIMEOUT = 5207
    UNKNOWN_COMMAND = 6000
    RATE_LIMITED = 7000
    SERVICE_DISABLED = 7001
    ALIAS_EMPTY = 5035
    EMAIL_INVALID = 5036
    EMAIL_IN_REQUIRED = 5037
    EMAIL_IN_USE = 5038
    EMAIL_IN_USE_ALT = 5055
    EMAIL_LEGACY_OR_INACTIVE = 5088
    EMAIL_VETTED = 5051
    EMAIL_NOT_VETTED = 5052
    HTTP_SUCCESS = 200
    BAD_REQUEST = 5003
    CANCELLED_BY_USER = 5013
    UNSUPPORTED_MANAGED_ID = 5100
    UNSUPPORTED_AUDITOR_ID = 5103
    VALIDATION_FAILURE = 8000
    VALIDATION_CERT_FETCH_FAILURE = 8001
    NO_NETWORK_AVAILABLE = 10000
    FAILED_REQUEST = 20000
    PUSH_REQUEST_FAILED = 20001
    ACTION_DO_NOT_RETRY = 6001
    ACTION_RETRY_WITH_DELAY = 6002
    ACTION_RETRY_WITH_CORRECTED_TIME = 6003
    ACTION_RETRY_WITH_NEW_ABSINTHE_CONTEXT = 6004
    ACTION_REFRESH_CREDENTIALS = 6005
    ACTION_REFRESH_REGISTRATION = 6006
    ACTION_AUTHENTICATION_FAILED = 6008
    ACTION_PERMANENT_FAILURE = 6009
    ACTION_ID_MS_SESSION_REFRESH_EXCEPTION = 6010
    ACTION_PROVISION_LIMIT_REACHED = 6011
    ACTION_PROVISION_REPLACE_ALL_SESSION_KEYS = 6012
    UNAUTHENTICATED = 5000
    INVALID_NAME_OR_PASSWORD = 5012
    ACCOUNT_DISABLED_FOR_SECURITY_REASONS = 5046
    VERSION_MISMATCH = 5002
    NO_SUCH_PLAYER_ID = 5005
    NO_SUCH_ACHIEVEMENT = 5007
    MISSING_REQUIRED_HEADER = 5009
    UNRECOGNIZED_GAME_DESCRIPTOR_HEADERS = 5010
    MUST_ACCEPT_TERMS_OF_SERVICE = 5011
    NO_SUCH_FRIEND_RELATIONSHIP = 5014
    NO_SUCH_ALIAS = 5015
    EMAIL_NOT_IN_NETWORK = 5016
    REQUEST_DISALLOWED = 5017
    NO_SUCH_RID = 5018
    NO_SUCH_GAME = 5019
    MIXED_RESPONSE = 5020
    PROFILE_EXISTS = 5021
    ALIAS_EXISTS = 5022
    ACCOUNT_NAME_NOT_EMAIL_ADDRESS = 5023
    ALIAS_TOO_LONG = 5024
    ALIAS_TOO_FREQUENT_UPDATES = 5025
    PLAYER_STATUS_NOT_ALLOWED = 5026
    PLAYER_STATUS_TOO_LONG = 5027
    NO_SUCH_BUCKET_ID = 5028
    AUTHENTICATED_NOT_AUTHORIZED = 5029
    NO_PUSH_TOKEN_FOR_ID = 5030
    PUSH_PAYLOAD_TOO_BIG = 5031
    NEW_SIGNATURE_REQUIRED = 5033
    NEW_LINKED_SIGNATURE_REQUIRED = 5099
    NEW_REGISTRATION_REQUIRED = 5034
    EXPIRED_RELAY_TOKEN = 5039
    BAD_SESSION_TOKEN = 5040
    EXPIRED_SESSION_TOKEN = 5041
    FORCE_PASSWORD_CHANGE = 5047
    PROFILE_BLOCKLISTED = 5048
    SELF_VERSION_TOO_OLD = 5057
    PEER_VERSION_TOO_OLD = 5058
    PHONE_NUMBER_TOO_SHORT = 5059
    PHONE_NUMBER_TOO_LONG = 5060
    PHONE_NUMBER_BAD_COUNTRY_CODE = 5061
    PHONE_NUMBER_MALFORMED = 5062
    BAD_INVITATION_CONTEXT = 5063
    UNPROMOTABLE_PHONE_NUMBER = 5064
    REGISTRATION_LIMIT_REACHED = 5068
    ABSINTHE_INTERNAL_ERROR = 5078
    ABSINTHE_SESSION_CREATION_FAILED = 5079
    ABSINTHE_VALIDATION_FAILED = 5080
    ALBERT_INTERNAL_ERROR = 5089
    ALBERT_VALIDATION_FAILED = 5090
    NEEDS_BREAK_BEFORE_MAKE = 5076
    BAD_CERT = 5085
    BAD_NONCE = 5086
    BAD_NONCE_TIMESTAMP = 5087
    SERVER_REGISTRATION_UNSUPPORTED = 5092
    NONE = 255

    UNKNOWN = -1

    def __str__(self: AppleStatusCode) -> str:
        """Return a human-readable representation of the status code."""
        return f"{self.name} ({self.value})"

    @classmethod
    def _missing_(cls: type[AppleStatusCode], value: object) -> AppleStatusCode:
        """Return the `UNKNOWN` status code for any unknown value."""
        del value
        return cls.UNKNOWN
