import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataBagItemConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/data_bag_item#content_json DataBagItem#content_json}
    */
    readonly contentJson: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/data_bag_item#data_bag_name DataBagItem#data_bag_name}
    */
    readonly dataBagName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/data_bag_item#id DataBagItem#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/data_bag_item chef_data_bag_item}
*/
export declare class DataBagItem extends cdktf.TerraformResource {
    static readonly tfResourceType = "chef_data_bag_item";
    /**
    * Generates CDKTF code for importing a DataBagItem resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataBagItem to import
    * @param importFromId The id of the existing DataBagItem that should be imported. Refer to the {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/data_bag_item#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataBagItem to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/data_bag_item chef_data_bag_item} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataBagItemConfig
    */
    constructor(scope: Construct, id: string, config: DataBagItemConfig);
    private _contentJson?;
    get contentJson(): string;
    set contentJson(value: string);
    get contentJsonInput(): string | undefined;
    private _dataBagName?;
    get dataBagName(): string;
    set dataBagName(value: string);
    get dataBagNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
