import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/environment#cookbook_constraints Environment#cookbook_constraints}
    */
    readonly cookbookConstraints?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/environment#default_attributes_json Environment#default_attributes_json}
    */
    readonly defaultAttributesJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/environment#description Environment#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/environment#id Environment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/environment#name Environment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/environment#override_attributes_json Environment#override_attributes_json}
    */
    readonly overrideAttributesJson?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/environment chef_environment}
*/
export declare class Environment extends cdktf.TerraformResource {
    static readonly tfResourceType = "chef_environment";
    /**
    * Generates CDKTF code for importing a Environment resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Environment to import
    * @param importFromId The id of the existing Environment that should be imported. Refer to the {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/environment#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Environment to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/environment chef_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: EnvironmentConfig);
    private _cookbookConstraints?;
    get cookbookConstraints(): {
        [key: string]: string;
    };
    set cookbookConstraints(value: {
        [key: string]: string;
    });
    resetCookbookConstraints(): void;
    get cookbookConstraintsInput(): {
        [key: string]: string;
    } | undefined;
    private _defaultAttributesJson?;
    get defaultAttributesJson(): string;
    set defaultAttributesJson(value: string);
    resetDefaultAttributesJson(): void;
    get defaultAttributesJsonInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _overrideAttributesJson?;
    get overrideAttributesJson(): string;
    set overrideAttributesJson(value: string);
    resetOverrideAttributesJson(): void;
    get overrideAttributesJsonInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
