import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NodeConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/node#automatic_attributes_json Node#automatic_attributes_json}
    */
    readonly automaticAttributesJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/node#client_name Node#client_name}
    */
    readonly clientName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/node#default_attributes_json Node#default_attributes_json}
    */
    readonly defaultAttributesJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/node#environment_name Node#environment_name}
    */
    readonly environmentName?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/node#id Node#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/node#key_material Node#key_material}
    */
    readonly keyMaterial?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/node#name Node#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/node#normal_attributes_json Node#normal_attributes_json}
    */
    readonly normalAttributesJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/node#override_attributes_json Node#override_attributes_json}
    */
    readonly overrideAttributesJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/node#run_list Node#run_list}
    */
    readonly runList?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/node chef_node}
*/
export declare class Node extends cdktf.TerraformResource {
    static readonly tfResourceType = "chef_node";
    /**
    * Generates CDKTF code for importing a Node resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Node to import
    * @param importFromId The id of the existing Node that should be imported. Refer to the {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/node#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Node to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/node chef_node} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NodeConfig
    */
    constructor(scope: Construct, id: string, config: NodeConfig);
    private _automaticAttributesJson?;
    get automaticAttributesJson(): string;
    set automaticAttributesJson(value: string);
    resetAutomaticAttributesJson(): void;
    get automaticAttributesJsonInput(): string | undefined;
    private _clientName?;
    get clientName(): string;
    set clientName(value: string);
    resetClientName(): void;
    get clientNameInput(): string | undefined;
    private _defaultAttributesJson?;
    get defaultAttributesJson(): string;
    set defaultAttributesJson(value: string);
    resetDefaultAttributesJson(): void;
    get defaultAttributesJsonInput(): string | undefined;
    private _environmentName?;
    get environmentName(): string;
    set environmentName(value: string);
    resetEnvironmentName(): void;
    get environmentNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _keyMaterial?;
    get keyMaterial(): string;
    set keyMaterial(value: string);
    resetKeyMaterial(): void;
    get keyMaterialInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _normalAttributesJson?;
    get normalAttributesJson(): string;
    set normalAttributesJson(value: string);
    resetNormalAttributesJson(): void;
    get normalAttributesJsonInput(): string | undefined;
    private _overrideAttributesJson?;
    get overrideAttributesJson(): string;
    set overrideAttributesJson(value: string);
    resetOverrideAttributesJson(): void;
    get overrideAttributesJsonInput(): string | undefined;
    private _runList?;
    get runList(): string[];
    set runList(value: string[]);
    resetRunList(): void;
    get runListInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
