import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ChefProviderConfig {
    /**
    * If set, the Chef client will permit unverifiable SSL certificates.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs#allow_unverified_ssl ChefProvider#allow_unverified_ssl}
    */
    readonly allowUnverifiedSsl?: boolean | cdktf.IResolvable;
    /**
    * Name of a registered client within the Chef server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs#client_name ChefProvider#client_name}
    */
    readonly clientName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs#key_material ChefProvider#key_material}
    */
    readonly keyMaterial?: string;
    /**
    * PEM-formatted private key for client authentication.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs#private_key_pem ChefProvider#private_key_pem}
    */
    readonly privateKeyPem?: string;
    /**
    * URL of the root of the target Chef server or organization.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs#server_url ChefProvider#server_url}
    */
    readonly serverUrl: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs#alias ChefProvider#alias}
    */
    readonly alias?: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs chef}
*/
export declare class ChefProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "chef";
    /**
    * Generates CDKTF code for importing a ChefProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ChefProvider to import
    * @param importFromId The id of the existing ChefProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ChefProvider to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs chef} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ChefProviderConfig
    */
    constructor(scope: Construct, id: string, config: ChefProviderConfig);
    private _allowUnverifiedSsl?;
    get allowUnverifiedSsl(): boolean | cdktf.IResolvable | undefined;
    set allowUnverifiedSsl(value: boolean | cdktf.IResolvable | undefined);
    resetAllowUnverifiedSsl(): void;
    get allowUnverifiedSslInput(): boolean | cdktf.IResolvable | undefined;
    private _clientName?;
    get clientName(): string | undefined;
    set clientName(value: string | undefined);
    get clientNameInput(): string | undefined;
    private _keyMaterial?;
    get keyMaterial(): string | undefined;
    set keyMaterial(value: string | undefined);
    resetKeyMaterial(): void;
    get keyMaterialInput(): string | undefined;
    private _privateKeyPem?;
    get privateKeyPem(): string | undefined;
    set privateKeyPem(value: string | undefined);
    resetPrivateKeyPem(): void;
    get privateKeyPemInput(): string | undefined;
    private _serverUrl?;
    get serverUrl(): string | undefined;
    set serverUrl(value: string | undefined);
    get serverUrlInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
