import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface RoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/role#default_attributes_json Role#default_attributes_json}
    */
    readonly defaultAttributesJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/role#description Role#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/role#id Role#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/role#name Role#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/role#override_attributes_json Role#override_attributes_json}
    */
    readonly overrideAttributesJson?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/role#run_list Role#run_list}
    */
    readonly runList?: string[];
}
/**
* Represents a {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/role chef_role}
*/
export declare class Role extends cdktf.TerraformResource {
    static readonly tfResourceType = "chef_role";
    /**
    * Generates CDKTF code for importing a Role resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Role to import
    * @param importFromId The id of the existing Role that should be imported. Refer to the {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/role#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Role to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/dbresson/chef/0.4.6/docs/resources/role chef_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options RoleConfig
    */
    constructor(scope: Construct, id: string, config: RoleConfig);
    private _defaultAttributesJson?;
    get defaultAttributesJson(): string;
    set defaultAttributesJson(value: string);
    resetDefaultAttributesJson(): void;
    get defaultAttributesJsonInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _overrideAttributesJson?;
    get overrideAttributesJson(): string;
    set overrideAttributesJson(value: string);
    resetOverrideAttributesJson(): void;
    get overrideAttributesJsonInput(): string | undefined;
    private _runList?;
    get runList(): string[];
    set runList(value: string[]);
    resetRunList(): void;
    get runListInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
