# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['EgressMatrixCellDefaultArgs', 'EgressMatrixCellDefault']

@pulumi.input_type
class EgressMatrixCellDefaultArgs:
    def __init__(__self__, *,
                 default_rule: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 matrix_cell_status: Optional[pulumi.Input[str]] = None,
                 sgacls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a EgressMatrixCellDefault resource.
        :param pulumi.Input[str] default_rule: Can be used only if sgacls not specified. Final Catch All Rule - Choices: `NONE`, `DENY_IP`, `PERMIT_IP`
        :param pulumi.Input[str] description: Description
        :param pulumi.Input[str] matrix_cell_status: Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sgacls: List of TrustSec Security Groups ACLs
        """
        if default_rule is not None:
            pulumi.set(__self__, "default_rule", default_rule)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if matrix_cell_status is not None:
            pulumi.set(__self__, "matrix_cell_status", matrix_cell_status)
        if sgacls is not None:
            pulumi.set(__self__, "sgacls", sgacls)

    @property
    @pulumi.getter(name="defaultRule")
    def default_rule(self) -> Optional[pulumi.Input[str]]:
        """
        Can be used only if sgacls not specified. Final Catch All Rule - Choices: `NONE`, `DENY_IP`, `PERMIT_IP`
        """
        return pulumi.get(self, "default_rule")

    @default_rule.setter
    def default_rule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_rule", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="matrixCellStatus")
    def matrix_cell_status(self) -> Optional[pulumi.Input[str]]:
        """
        Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        """
        return pulumi.get(self, "matrix_cell_status")

    @matrix_cell_status.setter
    def matrix_cell_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "matrix_cell_status", value)

    @property
    @pulumi.getter
    def sgacls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of TrustSec Security Groups ACLs
        """
        return pulumi.get(self, "sgacls")

    @sgacls.setter
    def sgacls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sgacls", value)


@pulumi.input_type
class _EgressMatrixCellDefaultState:
    def __init__(__self__, *,
                 default_rule: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 matrix_cell_status: Optional[pulumi.Input[str]] = None,
                 sgacls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering EgressMatrixCellDefault resources.
        :param pulumi.Input[str] default_rule: Can be used only if sgacls not specified. Final Catch All Rule - Choices: `NONE`, `DENY_IP`, `PERMIT_IP`
        :param pulumi.Input[str] description: Description
        :param pulumi.Input[str] matrix_cell_status: Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sgacls: List of TrustSec Security Groups ACLs
        """
        if default_rule is not None:
            pulumi.set(__self__, "default_rule", default_rule)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if matrix_cell_status is not None:
            pulumi.set(__self__, "matrix_cell_status", matrix_cell_status)
        if sgacls is not None:
            pulumi.set(__self__, "sgacls", sgacls)

    @property
    @pulumi.getter(name="defaultRule")
    def default_rule(self) -> Optional[pulumi.Input[str]]:
        """
        Can be used only if sgacls not specified. Final Catch All Rule - Choices: `NONE`, `DENY_IP`, `PERMIT_IP`
        """
        return pulumi.get(self, "default_rule")

    @default_rule.setter
    def default_rule(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_rule", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="matrixCellStatus")
    def matrix_cell_status(self) -> Optional[pulumi.Input[str]]:
        """
        Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        """
        return pulumi.get(self, "matrix_cell_status")

    @matrix_cell_status.setter
    def matrix_cell_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "matrix_cell_status", value)

    @property
    @pulumi.getter
    def sgacls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of TrustSec Security Groups ACLs
        """
        return pulumi.get(self, "sgacls")

    @sgacls.setter
    def sgacls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "sgacls", value)


class EgressMatrixCellDefault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_rule: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 matrix_cell_status: Optional[pulumi.Input[str]] = None,
                 sgacls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Allows modifications to the default egress policy matrix rule

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.trustsec.EgressMatrixCellDefault("example",
            description="Default egress rule",
            default_rule="PERMIT_IP",
            matrix_cell_status="ENABLED")
        ```

        ## Import

        ```sh
        $ pulumi import ise:trustsec/egressMatrixCellDefault:EgressMatrixCellDefault example "92c1a900-8c01-11e6-996c-525400b48521"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_rule: Can be used only if sgacls not specified. Final Catch All Rule - Choices: `NONE`, `DENY_IP`, `PERMIT_IP`
        :param pulumi.Input[str] description: Description
        :param pulumi.Input[str] matrix_cell_status: Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sgacls: List of TrustSec Security Groups ACLs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[EgressMatrixCellDefaultArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Allows modifications to the default egress policy matrix rule

        ## Example Usage

        ```python
        import pulumi
        import pulumi_ise as ise

        example = ise.trustsec.EgressMatrixCellDefault("example",
            description="Default egress rule",
            default_rule="PERMIT_IP",
            matrix_cell_status="ENABLED")
        ```

        ## Import

        ```sh
        $ pulumi import ise:trustsec/egressMatrixCellDefault:EgressMatrixCellDefault example "92c1a900-8c01-11e6-996c-525400b48521"
        ```

        :param str resource_name: The name of the resource.
        :param EgressMatrixCellDefaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(EgressMatrixCellDefaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 default_rule: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 matrix_cell_status: Optional[pulumi.Input[str]] = None,
                 sgacls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = EgressMatrixCellDefaultArgs.__new__(EgressMatrixCellDefaultArgs)

            __props__.__dict__["default_rule"] = default_rule
            __props__.__dict__["description"] = description
            __props__.__dict__["matrix_cell_status"] = matrix_cell_status
            __props__.__dict__["sgacls"] = sgacls
        super(EgressMatrixCellDefault, __self__).__init__(
            'ise:trustsec/egressMatrixCellDefault:EgressMatrixCellDefault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            default_rule: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            matrix_cell_status: Optional[pulumi.Input[str]] = None,
            sgacls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'EgressMatrixCellDefault':
        """
        Get an existing EgressMatrixCellDefault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] default_rule: Can be used only if sgacls not specified. Final Catch All Rule - Choices: `NONE`, `DENY_IP`, `PERMIT_IP`
        :param pulumi.Input[str] description: Description
        :param pulumi.Input[str] matrix_cell_status: Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        :param pulumi.Input[Sequence[pulumi.Input[str]]] sgacls: List of TrustSec Security Groups ACLs
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _EgressMatrixCellDefaultState.__new__(_EgressMatrixCellDefaultState)

        __props__.__dict__["default_rule"] = default_rule
        __props__.__dict__["description"] = description
        __props__.__dict__["matrix_cell_status"] = matrix_cell_status
        __props__.__dict__["sgacls"] = sgacls
        return EgressMatrixCellDefault(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="defaultRule")
    def default_rule(self) -> pulumi.Output[Optional[str]]:
        """
        Can be used only if sgacls not specified. Final Catch All Rule - Choices: `NONE`, `DENY_IP`, `PERMIT_IP`
        """
        return pulumi.get(self, "default_rule")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="matrixCellStatus")
    def matrix_cell_status(self) -> pulumi.Output[str]:
        """
        Matrix Cell Status - Choices: `DISABLED`, `ENABLED`, `MONITOR` - Default value: `DISABLED`
        """
        return pulumi.get(self, "matrix_cell_status")

    @property
    @pulumi.getter
    def sgacls(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of TrustSec Security Groups ACLs
        """
        return pulumi.get(self, "sgacls")

