# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['AuditArchiveRetrievalArgs', 'AuditArchiveRetrieval']

@pulumi.input_type
class AuditArchiveRetrievalArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 end_date: pulumi.Input[str],
                 start_date: pulumi.Input[str],
                 target_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a AuditArchiveRetrieval resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the archival retrieval.
        :param pulumi.Input[str] end_date: End month of the archive retrieval, in the format defined by RFC3339.
        :param pulumi.Input[str] start_date: Start month of the archive retrieval, in the format defined by RFC3339.
        :param pulumi.Input[str] target_id: The OCID of the target associated with the archive retrieval.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Description of the archive retrieval.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the archive retrieval. The name does not have to be unique, and is changeable.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)
        pulumi.set(__self__, "target_id", target_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment that contains the archival retrieval.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> pulumi.Input[str]:
        """
        End month of the archive retrieval, in the format defined by RFC3339.
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_date", value)

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Input[str]:
        """
        Start month of the archive retrieval, in the format defined by RFC3339.
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_date", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Input[str]:
        """
        The OCID of the target associated with the archive retrieval.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description of the archive retrieval.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the archive retrieval. The name does not have to be unique, and is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _AuditArchiveRetrievalState:
    def __init__(__self__, *,
                 audit_event_count: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 end_date: Optional[pulumi.Input[str]] = None,
                 error_info: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 start_date: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 time_completed: Optional[pulumi.Input[str]] = None,
                 time_of_expiry: Optional[pulumi.Input[str]] = None,
                 time_requested: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuditArchiveRetrieval resources.
        :param pulumi.Input[str] audit_event_count: Total count of audit events to be retrieved from the archive for the specified date range.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the archival retrieval.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Description of the archive retrieval.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the archive retrieval. The name does not have to be unique, and is changeable.
        :param pulumi.Input[str] end_date: End month of the archive retrieval, in the format defined by RFC3339.
        :param pulumi.Input[str] error_info: The Error details of a failed archive retrieval.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the archive retrieval.
        :param pulumi.Input[str] start_date: Start month of the archive retrieval, in the format defined by RFC3339.
        :param pulumi.Input[str] state: The current state of the archive retrieval.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: The OCID of the target associated with the archive retrieval.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_completed: The date time when archive retrieval request was fulfilled, in the format defined by RFC3339.
        :param pulumi.Input[str] time_of_expiry: The date time when retrieved archive data will be deleted from Data Safe and unloaded back into archival.
        :param pulumi.Input[str] time_requested: The date time when archive retrieval was requested, in the format defined by RFC3339.
        """
        if audit_event_count is not None:
            pulumi.set(__self__, "audit_event_count", audit_event_count)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)
        if error_info is not None:
            pulumi.set(__self__, "error_info", error_info)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if start_date is not None:
            pulumi.set(__self__, "start_date", start_date)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if target_id is not None:
            pulumi.set(__self__, "target_id", target_id)
        if time_completed is not None:
            pulumi.set(__self__, "time_completed", time_completed)
        if time_of_expiry is not None:
            pulumi.set(__self__, "time_of_expiry", time_of_expiry)
        if time_requested is not None:
            pulumi.set(__self__, "time_requested", time_requested)

    @property
    @pulumi.getter(name="auditEventCount")
    def audit_event_count(self) -> Optional[pulumi.Input[str]]:
        """
        Total count of audit events to be retrieved from the archive for the specified date range.
        """
        return pulumi.get(self, "audit_event_count")

    @audit_event_count.setter
    def audit_event_count(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audit_event_count", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that contains the archival retrieval.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Description of the archive retrieval.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the archive retrieval. The name does not have to be unique, and is changeable.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[pulumi.Input[str]]:
        """
        End month of the archive retrieval, in the format defined by RFC3339.
        """
        return pulumi.get(self, "end_date")

    @end_date.setter
    def end_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_date", value)

    @property
    @pulumi.getter(name="errorInfo")
    def error_info(self) -> Optional[pulumi.Input[str]]:
        """
        The Error details of a failed archive retrieval.
        """
        return pulumi.get(self, "error_info")

    @error_info.setter
    def error_info(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_info", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the current state of the archive retrieval.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> Optional[pulumi.Input[str]]:
        """
        Start month of the archive retrieval, in the format defined by RFC3339.
        """
        return pulumi.get(self, "start_date")

    @start_date.setter
    def start_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_date", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the archive retrieval.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the target associated with the archive retrieval.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_id")

    @target_id.setter
    def target_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_id", value)

    @property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> Optional[pulumi.Input[str]]:
        """
        The date time when archive retrieval request was fulfilled, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_completed")

    @time_completed.setter
    def time_completed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_completed", value)

    @property
    @pulumi.getter(name="timeOfExpiry")
    def time_of_expiry(self) -> Optional[pulumi.Input[str]]:
        """
        The date time when retrieved archive data will be deleted from Data Safe and unloaded back into archival.
        """
        return pulumi.get(self, "time_of_expiry")

    @time_of_expiry.setter
    def time_of_expiry(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_expiry", value)

    @property
    @pulumi.getter(name="timeRequested")
    def time_requested(self) -> Optional[pulumi.Input[str]]:
        """
        The date time when archive retrieval was requested, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_requested")

    @time_requested.setter
    def time_requested(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_requested", value)


class AuditArchiveRetrieval(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 end_date: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 start_date: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Audit Archive Retrieval resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a work request to retrieve archived audit data. This asynchronous process will usually take over an hour to complete.
        Save the id from the response of this operation. Call GetAuditArchiveRetrieval operation after an hour, passing the id to know the status of
        this operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_audit_archive_retrieval = oci.data_safe.AuditArchiveRetrieval("test_audit_archive_retrieval",
            compartment_id=compartment_id,
            end_date=audit_archive_retrieval_end_date,
            start_date=audit_archive_retrieval_start_date,
            target_id=test_target["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=audit_archive_retrieval_description,
            display_name=audit_archive_retrieval_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        AuditArchiveRetrievals can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/auditArchiveRetrieval:AuditArchiveRetrieval test_audit_archive_retrieval "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the archival retrieval.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Description of the archive retrieval.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the archive retrieval. The name does not have to be unique, and is changeable.
        :param pulumi.Input[str] end_date: End month of the archive retrieval, in the format defined by RFC3339.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] start_date: Start month of the archive retrieval, in the format defined by RFC3339.
        :param pulumi.Input[str] target_id: The OCID of the target associated with the archive retrieval.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuditArchiveRetrievalArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Audit Archive Retrieval resource in Oracle Cloud Infrastructure Data Safe service.

        Creates a work request to retrieve archived audit data. This asynchronous process will usually take over an hour to complete.
        Save the id from the response of this operation. Call GetAuditArchiveRetrieval operation after an hour, passing the id to know the status of
        this operation.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_audit_archive_retrieval = oci.data_safe.AuditArchiveRetrieval("test_audit_archive_retrieval",
            compartment_id=compartment_id,
            end_date=audit_archive_retrieval_end_date,
            start_date=audit_archive_retrieval_start_date,
            target_id=test_target["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=audit_archive_retrieval_description,
            display_name=audit_archive_retrieval_display_name,
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        AuditArchiveRetrievals can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:DataSafe/auditArchiveRetrieval:AuditArchiveRetrieval test_audit_archive_retrieval "id"
        ```

        :param str resource_name: The name of the resource.
        :param AuditArchiveRetrievalArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuditArchiveRetrievalArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 end_date: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 start_date: Optional[pulumi.Input[str]] = None,
                 target_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuditArchiveRetrievalArgs.__new__(AuditArchiveRetrievalArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if end_date is None and not opts.urn:
                raise TypeError("Missing required property 'end_date'")
            __props__.__dict__["end_date"] = end_date
            __props__.__dict__["freeform_tags"] = freeform_tags
            if start_date is None and not opts.urn:
                raise TypeError("Missing required property 'start_date'")
            __props__.__dict__["start_date"] = start_date
            if target_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_id'")
            __props__.__dict__["target_id"] = target_id
            __props__.__dict__["audit_event_count"] = None
            __props__.__dict__["error_info"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_completed"] = None
            __props__.__dict__["time_of_expiry"] = None
            __props__.__dict__["time_requested"] = None
        super(AuditArchiveRetrieval, __self__).__init__(
            'oci:DataSafe/auditArchiveRetrieval:AuditArchiveRetrieval',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            audit_event_count: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            end_date: Optional[pulumi.Input[str]] = None,
            error_info: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            start_date: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            target_id: Optional[pulumi.Input[str]] = None,
            time_completed: Optional[pulumi.Input[str]] = None,
            time_of_expiry: Optional[pulumi.Input[str]] = None,
            time_requested: Optional[pulumi.Input[str]] = None) -> 'AuditArchiveRetrieval':
        """
        Get an existing AuditArchiveRetrieval resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] audit_event_count: Total count of audit events to be retrieved from the archive for the specified date range.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the archival retrieval.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Description of the archive retrieval.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the archive retrieval. The name does not have to be unique, and is changeable.
        :param pulumi.Input[str] end_date: End month of the archive retrieval, in the format defined by RFC3339.
        :param pulumi.Input[str] error_info: The Error details of a failed archive retrieval.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the archive retrieval.
        :param pulumi.Input[str] start_date: Start month of the archive retrieval, in the format defined by RFC3339.
        :param pulumi.Input[str] state: The current state of the archive retrieval.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] target_id: The OCID of the target associated with the archive retrieval.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_completed: The date time when archive retrieval request was fulfilled, in the format defined by RFC3339.
        :param pulumi.Input[str] time_of_expiry: The date time when retrieved archive data will be deleted from Data Safe and unloaded back into archival.
        :param pulumi.Input[str] time_requested: The date time when archive retrieval was requested, in the format defined by RFC3339.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuditArchiveRetrievalState.__new__(_AuditArchiveRetrievalState)

        __props__.__dict__["audit_event_count"] = audit_event_count
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["end_date"] = end_date
        __props__.__dict__["error_info"] = error_info
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["start_date"] = start_date
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["target_id"] = target_id
        __props__.__dict__["time_completed"] = time_completed
        __props__.__dict__["time_of_expiry"] = time_of_expiry
        __props__.__dict__["time_requested"] = time_requested
        return AuditArchiveRetrieval(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="auditEventCount")
    def audit_event_count(self) -> pulumi.Output[str]:
        """
        Total count of audit events to be retrieved from the archive for the specified date range.
        """
        return pulumi.get(self, "audit_event_count")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment that contains the archival retrieval.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Description of the archive retrieval.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the archive retrieval. The name does not have to be unique, and is changeable.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="endDate")
    def end_date(self) -> pulumi.Output[str]:
        """
        End month of the archive retrieval, in the format defined by RFC3339.
        """
        return pulumi.get(self, "end_date")

    @property
    @pulumi.getter(name="errorInfo")
    def error_info(self) -> pulumi.Output[str]:
        """
        The Error details of a failed archive retrieval.
        """
        return pulumi.get(self, "error_info")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm)  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the current state of the archive retrieval.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="startDate")
    def start_date(self) -> pulumi.Output[str]:
        """
        Start month of the archive retrieval, in the format defined by RFC3339.
        """
        return pulumi.get(self, "start_date")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the archive retrieval.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> pulumi.Output[str]:
        """
        The OCID of the target associated with the archive retrieval.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "target_id")

    @property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> pulumi.Output[str]:
        """
        The date time when archive retrieval request was fulfilled, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_completed")

    @property
    @pulumi.getter(name="timeOfExpiry")
    def time_of_expiry(self) -> pulumi.Output[str]:
        """
        The date time when retrieved archive data will be deleted from Data Safe and unloaded back into archival.
        """
        return pulumi.get(self, "time_of_expiry")

    @property
    @pulumi.getter(name="timeRequested")
    def time_requested(self) -> pulumi.Output[str]:
        """
        The date time when archive retrieval was requested, in the format defined by RFC3339.
        """
        return pulumi.get(self, "time_requested")

