# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WirelessRfProfilesArgs', 'WirelessRfProfiles']

@pulumi.input_type
class WirelessRfProfilesArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[builtins.str],
                 ap_band_settings: Optional[pulumi.Input['WirelessRfProfilesApBandSettingsArgs']] = None,
                 band_selection_type: Optional[pulumi.Input[builtins.str]] = None,
                 client_balancing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 five_ghz_settings: Optional[pulumi.Input['WirelessRfProfilesFiveGhzSettingsArgs']] = None,
                 flex_radios: Optional[pulumi.Input['WirelessRfProfilesFlexRadiosArgs']] = None,
                 min_bitrate_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 per_ssid_settings: Optional[pulumi.Input['WirelessRfProfilesPerSsidSettingsArgs']] = None,
                 rf_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 six_ghz_settings: Optional[pulumi.Input['WirelessRfProfilesSixGhzSettingsArgs']] = None,
                 transmission: Optional[pulumi.Input['WirelessRfProfilesTransmissionArgs']] = None,
                 two_four_ghz_settings: Optional[pulumi.Input['WirelessRfProfilesTwoFourGhzSettingsArgs']] = None):
        """
        The set of arguments for constructing a WirelessRfProfiles resource.
        :param pulumi.Input[builtins.str] network_id: The network ID of the RF Profile
        :param pulumi.Input['WirelessRfProfilesApBandSettingsArgs'] ap_band_settings: Settings that will be enabled if selectionType is set to 'ap'.
        :param pulumi.Input[builtins.str] band_selection_type: Band selection can be set to either 'ssid' or 'ap'. This param is required on creation.
        :param pulumi.Input[builtins.bool] client_balancing_enabled: Steers client to best available access point. Can be either true or false. Defaults to true.
        :param pulumi.Input['WirelessRfProfilesFiveGhzSettingsArgs'] five_ghz_settings: Settings related to 5Ghz band
        :param pulumi.Input['WirelessRfProfilesFlexRadiosArgs'] flex_radios: Flex radio settings.
        :param pulumi.Input[builtins.str] min_bitrate_type: Minimum bitrate can be set to either 'band' or 'ssid'. Defaults to band.
        :param pulumi.Input[builtins.str] name: The name of the new profile. Must be unique. This param is required on creation.
        :param pulumi.Input['WirelessRfProfilesPerSsidSettingsArgs'] per_ssid_settings: Per-SSID radio settings by number.
        :param pulumi.Input[builtins.str] rf_profile_id: rfProfileId path parameter. Rf profile ID
        :param pulumi.Input['WirelessRfProfilesSixGhzSettingsArgs'] six_ghz_settings: Settings related to 6Ghz band. Only applicable to networks with 6Ghz capable APs
        :param pulumi.Input['WirelessRfProfilesTransmissionArgs'] transmission: Settings related to radio transmission.
        :param pulumi.Input['WirelessRfProfilesTwoFourGhzSettingsArgs'] two_four_ghz_settings: Settings related to 2.4Ghz band
        """
        pulumi.set(__self__, "network_id", network_id)
        if ap_band_settings is not None:
            pulumi.set(__self__, "ap_band_settings", ap_band_settings)
        if band_selection_type is not None:
            pulumi.set(__self__, "band_selection_type", band_selection_type)
        if client_balancing_enabled is not None:
            pulumi.set(__self__, "client_balancing_enabled", client_balancing_enabled)
        if five_ghz_settings is not None:
            pulumi.set(__self__, "five_ghz_settings", five_ghz_settings)
        if flex_radios is not None:
            pulumi.set(__self__, "flex_radios", flex_radios)
        if min_bitrate_type is not None:
            pulumi.set(__self__, "min_bitrate_type", min_bitrate_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if per_ssid_settings is not None:
            pulumi.set(__self__, "per_ssid_settings", per_ssid_settings)
        if rf_profile_id is not None:
            pulumi.set(__self__, "rf_profile_id", rf_profile_id)
        if six_ghz_settings is not None:
            pulumi.set(__self__, "six_ghz_settings", six_ghz_settings)
        if transmission is not None:
            pulumi.set(__self__, "transmission", transmission)
        if two_four_ghz_settings is not None:
            pulumi.set(__self__, "two_four_ghz_settings", two_four_ghz_settings)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[builtins.str]:
        """
        The network ID of the RF Profile
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[builtins.str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="apBandSettings")
    def ap_band_settings(self) -> Optional[pulumi.Input['WirelessRfProfilesApBandSettingsArgs']]:
        """
        Settings that will be enabled if selectionType is set to 'ap'.
        """
        return pulumi.get(self, "ap_band_settings")

    @ap_band_settings.setter
    def ap_band_settings(self, value: Optional[pulumi.Input['WirelessRfProfilesApBandSettingsArgs']]):
        pulumi.set(self, "ap_band_settings", value)

    @property
    @pulumi.getter(name="bandSelectionType")
    def band_selection_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Band selection can be set to either 'ssid' or 'ap'. This param is required on creation.
        """
        return pulumi.get(self, "band_selection_type")

    @band_selection_type.setter
    def band_selection_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "band_selection_type", value)

    @property
    @pulumi.getter(name="clientBalancingEnabled")
    def client_balancing_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Steers client to best available access point. Can be either true or false. Defaults to true.
        """
        return pulumi.get(self, "client_balancing_enabled")

    @client_balancing_enabled.setter
    def client_balancing_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "client_balancing_enabled", value)

    @property
    @pulumi.getter(name="fiveGhzSettings")
    def five_ghz_settings(self) -> Optional[pulumi.Input['WirelessRfProfilesFiveGhzSettingsArgs']]:
        """
        Settings related to 5Ghz band
        """
        return pulumi.get(self, "five_ghz_settings")

    @five_ghz_settings.setter
    def five_ghz_settings(self, value: Optional[pulumi.Input['WirelessRfProfilesFiveGhzSettingsArgs']]):
        pulumi.set(self, "five_ghz_settings", value)

    @property
    @pulumi.getter(name="flexRadios")
    def flex_radios(self) -> Optional[pulumi.Input['WirelessRfProfilesFlexRadiosArgs']]:
        """
        Flex radio settings.
        """
        return pulumi.get(self, "flex_radios")

    @flex_radios.setter
    def flex_radios(self, value: Optional[pulumi.Input['WirelessRfProfilesFlexRadiosArgs']]):
        pulumi.set(self, "flex_radios", value)

    @property
    @pulumi.getter(name="minBitrateType")
    def min_bitrate_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Minimum bitrate can be set to either 'band' or 'ssid'. Defaults to band.
        """
        return pulumi.get(self, "min_bitrate_type")

    @min_bitrate_type.setter
    def min_bitrate_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "min_bitrate_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the new profile. Must be unique. This param is required on creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="perSsidSettings")
    def per_ssid_settings(self) -> Optional[pulumi.Input['WirelessRfProfilesPerSsidSettingsArgs']]:
        """
        Per-SSID radio settings by number.
        """
        return pulumi.get(self, "per_ssid_settings")

    @per_ssid_settings.setter
    def per_ssid_settings(self, value: Optional[pulumi.Input['WirelessRfProfilesPerSsidSettingsArgs']]):
        pulumi.set(self, "per_ssid_settings", value)

    @property
    @pulumi.getter(name="rfProfileId")
    def rf_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        rfProfileId path parameter. Rf profile ID
        """
        return pulumi.get(self, "rf_profile_id")

    @rf_profile_id.setter
    def rf_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rf_profile_id", value)

    @property
    @pulumi.getter(name="sixGhzSettings")
    def six_ghz_settings(self) -> Optional[pulumi.Input['WirelessRfProfilesSixGhzSettingsArgs']]:
        """
        Settings related to 6Ghz band. Only applicable to networks with 6Ghz capable APs
        """
        return pulumi.get(self, "six_ghz_settings")

    @six_ghz_settings.setter
    def six_ghz_settings(self, value: Optional[pulumi.Input['WirelessRfProfilesSixGhzSettingsArgs']]):
        pulumi.set(self, "six_ghz_settings", value)

    @property
    @pulumi.getter
    def transmission(self) -> Optional[pulumi.Input['WirelessRfProfilesTransmissionArgs']]:
        """
        Settings related to radio transmission.
        """
        return pulumi.get(self, "transmission")

    @transmission.setter
    def transmission(self, value: Optional[pulumi.Input['WirelessRfProfilesTransmissionArgs']]):
        pulumi.set(self, "transmission", value)

    @property
    @pulumi.getter(name="twoFourGhzSettings")
    def two_four_ghz_settings(self) -> Optional[pulumi.Input['WirelessRfProfilesTwoFourGhzSettingsArgs']]:
        """
        Settings related to 2.4Ghz band
        """
        return pulumi.get(self, "two_four_ghz_settings")

    @two_four_ghz_settings.setter
    def two_four_ghz_settings(self, value: Optional[pulumi.Input['WirelessRfProfilesTwoFourGhzSettingsArgs']]):
        pulumi.set(self, "two_four_ghz_settings", value)


@pulumi.input_type
class _WirelessRfProfilesState:
    def __init__(__self__, *,
                 ap_band_settings: Optional[pulumi.Input['WirelessRfProfilesApBandSettingsArgs']] = None,
                 band_selection_type: Optional[pulumi.Input[builtins.str]] = None,
                 client_balancing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 five_ghz_settings: Optional[pulumi.Input['WirelessRfProfilesFiveGhzSettingsArgs']] = None,
                 flex_radios: Optional[pulumi.Input['WirelessRfProfilesFlexRadiosArgs']] = None,
                 min_bitrate_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 per_ssid_settings: Optional[pulumi.Input['WirelessRfProfilesPerSsidSettingsArgs']] = None,
                 rf_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 six_ghz_settings: Optional[pulumi.Input['WirelessRfProfilesSixGhzSettingsArgs']] = None,
                 transmission: Optional[pulumi.Input['WirelessRfProfilesTransmissionArgs']] = None,
                 two_four_ghz_settings: Optional[pulumi.Input['WirelessRfProfilesTwoFourGhzSettingsArgs']] = None):
        """
        Input properties used for looking up and filtering WirelessRfProfiles resources.
        :param pulumi.Input['WirelessRfProfilesApBandSettingsArgs'] ap_band_settings: Settings that will be enabled if selectionType is set to 'ap'.
        :param pulumi.Input[builtins.str] band_selection_type: Band selection can be set to either 'ssid' or 'ap'. This param is required on creation.
        :param pulumi.Input[builtins.bool] client_balancing_enabled: Steers client to best available access point. Can be either true or false. Defaults to true.
        :param pulumi.Input['WirelessRfProfilesFiveGhzSettingsArgs'] five_ghz_settings: Settings related to 5Ghz band
        :param pulumi.Input['WirelessRfProfilesFlexRadiosArgs'] flex_radios: Flex radio settings.
        :param pulumi.Input[builtins.str] min_bitrate_type: Minimum bitrate can be set to either 'band' or 'ssid'. Defaults to band.
        :param pulumi.Input[builtins.str] name: The name of the new profile. Must be unique. This param is required on creation.
        :param pulumi.Input[builtins.str] network_id: The network ID of the RF Profile
        :param pulumi.Input['WirelessRfProfilesPerSsidSettingsArgs'] per_ssid_settings: Per-SSID radio settings by number.
        :param pulumi.Input[builtins.str] rf_profile_id: rfProfileId path parameter. Rf profile ID
        :param pulumi.Input['WirelessRfProfilesSixGhzSettingsArgs'] six_ghz_settings: Settings related to 6Ghz band. Only applicable to networks with 6Ghz capable APs
        :param pulumi.Input['WirelessRfProfilesTransmissionArgs'] transmission: Settings related to radio transmission.
        :param pulumi.Input['WirelessRfProfilesTwoFourGhzSettingsArgs'] two_four_ghz_settings: Settings related to 2.4Ghz band
        """
        if ap_band_settings is not None:
            pulumi.set(__self__, "ap_band_settings", ap_band_settings)
        if band_selection_type is not None:
            pulumi.set(__self__, "band_selection_type", band_selection_type)
        if client_balancing_enabled is not None:
            pulumi.set(__self__, "client_balancing_enabled", client_balancing_enabled)
        if five_ghz_settings is not None:
            pulumi.set(__self__, "five_ghz_settings", five_ghz_settings)
        if flex_radios is not None:
            pulumi.set(__self__, "flex_radios", flex_radios)
        if min_bitrate_type is not None:
            pulumi.set(__self__, "min_bitrate_type", min_bitrate_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if per_ssid_settings is not None:
            pulumi.set(__self__, "per_ssid_settings", per_ssid_settings)
        if rf_profile_id is not None:
            pulumi.set(__self__, "rf_profile_id", rf_profile_id)
        if six_ghz_settings is not None:
            pulumi.set(__self__, "six_ghz_settings", six_ghz_settings)
        if transmission is not None:
            pulumi.set(__self__, "transmission", transmission)
        if two_four_ghz_settings is not None:
            pulumi.set(__self__, "two_four_ghz_settings", two_four_ghz_settings)

    @property
    @pulumi.getter(name="apBandSettings")
    def ap_band_settings(self) -> Optional[pulumi.Input['WirelessRfProfilesApBandSettingsArgs']]:
        """
        Settings that will be enabled if selectionType is set to 'ap'.
        """
        return pulumi.get(self, "ap_band_settings")

    @ap_band_settings.setter
    def ap_band_settings(self, value: Optional[pulumi.Input['WirelessRfProfilesApBandSettingsArgs']]):
        pulumi.set(self, "ap_band_settings", value)

    @property
    @pulumi.getter(name="bandSelectionType")
    def band_selection_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Band selection can be set to either 'ssid' or 'ap'. This param is required on creation.
        """
        return pulumi.get(self, "band_selection_type")

    @band_selection_type.setter
    def band_selection_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "band_selection_type", value)

    @property
    @pulumi.getter(name="clientBalancingEnabled")
    def client_balancing_enabled(self) -> Optional[pulumi.Input[builtins.bool]]:
        """
        Steers client to best available access point. Can be either true or false. Defaults to true.
        """
        return pulumi.get(self, "client_balancing_enabled")

    @client_balancing_enabled.setter
    def client_balancing_enabled(self, value: Optional[pulumi.Input[builtins.bool]]):
        pulumi.set(self, "client_balancing_enabled", value)

    @property
    @pulumi.getter(name="fiveGhzSettings")
    def five_ghz_settings(self) -> Optional[pulumi.Input['WirelessRfProfilesFiveGhzSettingsArgs']]:
        """
        Settings related to 5Ghz band
        """
        return pulumi.get(self, "five_ghz_settings")

    @five_ghz_settings.setter
    def five_ghz_settings(self, value: Optional[pulumi.Input['WirelessRfProfilesFiveGhzSettingsArgs']]):
        pulumi.set(self, "five_ghz_settings", value)

    @property
    @pulumi.getter(name="flexRadios")
    def flex_radios(self) -> Optional[pulumi.Input['WirelessRfProfilesFlexRadiosArgs']]:
        """
        Flex radio settings.
        """
        return pulumi.get(self, "flex_radios")

    @flex_radios.setter
    def flex_radios(self, value: Optional[pulumi.Input['WirelessRfProfilesFlexRadiosArgs']]):
        pulumi.set(self, "flex_radios", value)

    @property
    @pulumi.getter(name="minBitrateType")
    def min_bitrate_type(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        Minimum bitrate can be set to either 'band' or 'ssid'. Defaults to band.
        """
        return pulumi.get(self, "min_bitrate_type")

    @min_bitrate_type.setter
    def min_bitrate_type(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "min_bitrate_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The name of the new profile. Must be unique. This param is required on creation.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        The network ID of the RF Profile
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="perSsidSettings")
    def per_ssid_settings(self) -> Optional[pulumi.Input['WirelessRfProfilesPerSsidSettingsArgs']]:
        """
        Per-SSID radio settings by number.
        """
        return pulumi.get(self, "per_ssid_settings")

    @per_ssid_settings.setter
    def per_ssid_settings(self, value: Optional[pulumi.Input['WirelessRfProfilesPerSsidSettingsArgs']]):
        pulumi.set(self, "per_ssid_settings", value)

    @property
    @pulumi.getter(name="rfProfileId")
    def rf_profile_id(self) -> Optional[pulumi.Input[builtins.str]]:
        """
        rfProfileId path parameter. Rf profile ID
        """
        return pulumi.get(self, "rf_profile_id")

    @rf_profile_id.setter
    def rf_profile_id(self, value: Optional[pulumi.Input[builtins.str]]):
        pulumi.set(self, "rf_profile_id", value)

    @property
    @pulumi.getter(name="sixGhzSettings")
    def six_ghz_settings(self) -> Optional[pulumi.Input['WirelessRfProfilesSixGhzSettingsArgs']]:
        """
        Settings related to 6Ghz band. Only applicable to networks with 6Ghz capable APs
        """
        return pulumi.get(self, "six_ghz_settings")

    @six_ghz_settings.setter
    def six_ghz_settings(self, value: Optional[pulumi.Input['WirelessRfProfilesSixGhzSettingsArgs']]):
        pulumi.set(self, "six_ghz_settings", value)

    @property
    @pulumi.getter
    def transmission(self) -> Optional[pulumi.Input['WirelessRfProfilesTransmissionArgs']]:
        """
        Settings related to radio transmission.
        """
        return pulumi.get(self, "transmission")

    @transmission.setter
    def transmission(self, value: Optional[pulumi.Input['WirelessRfProfilesTransmissionArgs']]):
        pulumi.set(self, "transmission", value)

    @property
    @pulumi.getter(name="twoFourGhzSettings")
    def two_four_ghz_settings(self) -> Optional[pulumi.Input['WirelessRfProfilesTwoFourGhzSettingsArgs']]:
        """
        Settings related to 2.4Ghz band
        """
        return pulumi.get(self, "two_four_ghz_settings")

    @two_four_ghz_settings.setter
    def two_four_ghz_settings(self, value: Optional[pulumi.Input['WirelessRfProfilesTwoFourGhzSettingsArgs']]):
        pulumi.set(self, "two_four_ghz_settings", value)


@pulumi.type_token("meraki:networks/wirelessRfProfiles:WirelessRfProfiles")
class WirelessRfProfiles(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ap_band_settings: Optional[pulumi.Input[Union['WirelessRfProfilesApBandSettingsArgs', 'WirelessRfProfilesApBandSettingsArgsDict']]] = None,
                 band_selection_type: Optional[pulumi.Input[builtins.str]] = None,
                 client_balancing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 five_ghz_settings: Optional[pulumi.Input[Union['WirelessRfProfilesFiveGhzSettingsArgs', 'WirelessRfProfilesFiveGhzSettingsArgsDict']]] = None,
                 flex_radios: Optional[pulumi.Input[Union['WirelessRfProfilesFlexRadiosArgs', 'WirelessRfProfilesFlexRadiosArgsDict']]] = None,
                 min_bitrate_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 per_ssid_settings: Optional[pulumi.Input[Union['WirelessRfProfilesPerSsidSettingsArgs', 'WirelessRfProfilesPerSsidSettingsArgsDict']]] = None,
                 rf_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 six_ghz_settings: Optional[pulumi.Input[Union['WirelessRfProfilesSixGhzSettingsArgs', 'WirelessRfProfilesSixGhzSettingsArgsDict']]] = None,
                 transmission: Optional[pulumi.Input[Union['WirelessRfProfilesTransmissionArgs', 'WirelessRfProfilesTransmissionArgsDict']]] = None,
                 two_four_ghz_settings: Optional[pulumi.Input[Union['WirelessRfProfilesTwoFourGhzSettingsArgs', 'WirelessRfProfilesTwoFourGhzSettingsArgsDict']]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessRfProfiles:WirelessRfProfiles example "network_id,rf_profile_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WirelessRfProfilesApBandSettingsArgs', 'WirelessRfProfilesApBandSettingsArgsDict']] ap_band_settings: Settings that will be enabled if selectionType is set to 'ap'.
        :param pulumi.Input[builtins.str] band_selection_type: Band selection can be set to either 'ssid' or 'ap'. This param is required on creation.
        :param pulumi.Input[builtins.bool] client_balancing_enabled: Steers client to best available access point. Can be either true or false. Defaults to true.
        :param pulumi.Input[Union['WirelessRfProfilesFiveGhzSettingsArgs', 'WirelessRfProfilesFiveGhzSettingsArgsDict']] five_ghz_settings: Settings related to 5Ghz band
        :param pulumi.Input[Union['WirelessRfProfilesFlexRadiosArgs', 'WirelessRfProfilesFlexRadiosArgsDict']] flex_radios: Flex radio settings.
        :param pulumi.Input[builtins.str] min_bitrate_type: Minimum bitrate can be set to either 'band' or 'ssid'. Defaults to band.
        :param pulumi.Input[builtins.str] name: The name of the new profile. Must be unique. This param is required on creation.
        :param pulumi.Input[builtins.str] network_id: The network ID of the RF Profile
        :param pulumi.Input[Union['WirelessRfProfilesPerSsidSettingsArgs', 'WirelessRfProfilesPerSsidSettingsArgsDict']] per_ssid_settings: Per-SSID radio settings by number.
        :param pulumi.Input[builtins.str] rf_profile_id: rfProfileId path parameter. Rf profile ID
        :param pulumi.Input[Union['WirelessRfProfilesSixGhzSettingsArgs', 'WirelessRfProfilesSixGhzSettingsArgsDict']] six_ghz_settings: Settings related to 6Ghz band. Only applicable to networks with 6Ghz capable APs
        :param pulumi.Input[Union['WirelessRfProfilesTransmissionArgs', 'WirelessRfProfilesTransmissionArgsDict']] transmission: Settings related to radio transmission.
        :param pulumi.Input[Union['WirelessRfProfilesTwoFourGhzSettingsArgs', 'WirelessRfProfilesTwoFourGhzSettingsArgsDict']] two_four_ghz_settings: Settings related to 2.4Ghz band
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WirelessRfProfilesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/wirelessRfProfiles:WirelessRfProfiles example "network_id,rf_profile_id"
        ```

        :param str resource_name: The name of the resource.
        :param WirelessRfProfilesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WirelessRfProfilesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ap_band_settings: Optional[pulumi.Input[Union['WirelessRfProfilesApBandSettingsArgs', 'WirelessRfProfilesApBandSettingsArgsDict']]] = None,
                 band_selection_type: Optional[pulumi.Input[builtins.str]] = None,
                 client_balancing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
                 five_ghz_settings: Optional[pulumi.Input[Union['WirelessRfProfilesFiveGhzSettingsArgs', 'WirelessRfProfilesFiveGhzSettingsArgsDict']]] = None,
                 flex_radios: Optional[pulumi.Input[Union['WirelessRfProfilesFlexRadiosArgs', 'WirelessRfProfilesFlexRadiosArgsDict']]] = None,
                 min_bitrate_type: Optional[pulumi.Input[builtins.str]] = None,
                 name: Optional[pulumi.Input[builtins.str]] = None,
                 network_id: Optional[pulumi.Input[builtins.str]] = None,
                 per_ssid_settings: Optional[pulumi.Input[Union['WirelessRfProfilesPerSsidSettingsArgs', 'WirelessRfProfilesPerSsidSettingsArgsDict']]] = None,
                 rf_profile_id: Optional[pulumi.Input[builtins.str]] = None,
                 six_ghz_settings: Optional[pulumi.Input[Union['WirelessRfProfilesSixGhzSettingsArgs', 'WirelessRfProfilesSixGhzSettingsArgsDict']]] = None,
                 transmission: Optional[pulumi.Input[Union['WirelessRfProfilesTransmissionArgs', 'WirelessRfProfilesTransmissionArgsDict']]] = None,
                 two_four_ghz_settings: Optional[pulumi.Input[Union['WirelessRfProfilesTwoFourGhzSettingsArgs', 'WirelessRfProfilesTwoFourGhzSettingsArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WirelessRfProfilesArgs.__new__(WirelessRfProfilesArgs)

            __props__.__dict__["ap_band_settings"] = ap_band_settings
            __props__.__dict__["band_selection_type"] = band_selection_type
            __props__.__dict__["client_balancing_enabled"] = client_balancing_enabled
            __props__.__dict__["five_ghz_settings"] = five_ghz_settings
            __props__.__dict__["flex_radios"] = flex_radios
            __props__.__dict__["min_bitrate_type"] = min_bitrate_type
            __props__.__dict__["name"] = name
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["per_ssid_settings"] = per_ssid_settings
            __props__.__dict__["rf_profile_id"] = rf_profile_id
            __props__.__dict__["six_ghz_settings"] = six_ghz_settings
            __props__.__dict__["transmission"] = transmission
            __props__.__dict__["two_four_ghz_settings"] = two_four_ghz_settings
        super(WirelessRfProfiles, __self__).__init__(
            'meraki:networks/wirelessRfProfiles:WirelessRfProfiles',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ap_band_settings: Optional[pulumi.Input[Union['WirelessRfProfilesApBandSettingsArgs', 'WirelessRfProfilesApBandSettingsArgsDict']]] = None,
            band_selection_type: Optional[pulumi.Input[builtins.str]] = None,
            client_balancing_enabled: Optional[pulumi.Input[builtins.bool]] = None,
            five_ghz_settings: Optional[pulumi.Input[Union['WirelessRfProfilesFiveGhzSettingsArgs', 'WirelessRfProfilesFiveGhzSettingsArgsDict']]] = None,
            flex_radios: Optional[pulumi.Input[Union['WirelessRfProfilesFlexRadiosArgs', 'WirelessRfProfilesFlexRadiosArgsDict']]] = None,
            min_bitrate_type: Optional[pulumi.Input[builtins.str]] = None,
            name: Optional[pulumi.Input[builtins.str]] = None,
            network_id: Optional[pulumi.Input[builtins.str]] = None,
            per_ssid_settings: Optional[pulumi.Input[Union['WirelessRfProfilesPerSsidSettingsArgs', 'WirelessRfProfilesPerSsidSettingsArgsDict']]] = None,
            rf_profile_id: Optional[pulumi.Input[builtins.str]] = None,
            six_ghz_settings: Optional[pulumi.Input[Union['WirelessRfProfilesSixGhzSettingsArgs', 'WirelessRfProfilesSixGhzSettingsArgsDict']]] = None,
            transmission: Optional[pulumi.Input[Union['WirelessRfProfilesTransmissionArgs', 'WirelessRfProfilesTransmissionArgsDict']]] = None,
            two_four_ghz_settings: Optional[pulumi.Input[Union['WirelessRfProfilesTwoFourGhzSettingsArgs', 'WirelessRfProfilesTwoFourGhzSettingsArgsDict']]] = None) -> 'WirelessRfProfiles':
        """
        Get an existing WirelessRfProfiles resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['WirelessRfProfilesApBandSettingsArgs', 'WirelessRfProfilesApBandSettingsArgsDict']] ap_band_settings: Settings that will be enabled if selectionType is set to 'ap'.
        :param pulumi.Input[builtins.str] band_selection_type: Band selection can be set to either 'ssid' or 'ap'. This param is required on creation.
        :param pulumi.Input[builtins.bool] client_balancing_enabled: Steers client to best available access point. Can be either true or false. Defaults to true.
        :param pulumi.Input[Union['WirelessRfProfilesFiveGhzSettingsArgs', 'WirelessRfProfilesFiveGhzSettingsArgsDict']] five_ghz_settings: Settings related to 5Ghz band
        :param pulumi.Input[Union['WirelessRfProfilesFlexRadiosArgs', 'WirelessRfProfilesFlexRadiosArgsDict']] flex_radios: Flex radio settings.
        :param pulumi.Input[builtins.str] min_bitrate_type: Minimum bitrate can be set to either 'band' or 'ssid'. Defaults to band.
        :param pulumi.Input[builtins.str] name: The name of the new profile. Must be unique. This param is required on creation.
        :param pulumi.Input[builtins.str] network_id: The network ID of the RF Profile
        :param pulumi.Input[Union['WirelessRfProfilesPerSsidSettingsArgs', 'WirelessRfProfilesPerSsidSettingsArgsDict']] per_ssid_settings: Per-SSID radio settings by number.
        :param pulumi.Input[builtins.str] rf_profile_id: rfProfileId path parameter. Rf profile ID
        :param pulumi.Input[Union['WirelessRfProfilesSixGhzSettingsArgs', 'WirelessRfProfilesSixGhzSettingsArgsDict']] six_ghz_settings: Settings related to 6Ghz band. Only applicable to networks with 6Ghz capable APs
        :param pulumi.Input[Union['WirelessRfProfilesTransmissionArgs', 'WirelessRfProfilesTransmissionArgsDict']] transmission: Settings related to radio transmission.
        :param pulumi.Input[Union['WirelessRfProfilesTwoFourGhzSettingsArgs', 'WirelessRfProfilesTwoFourGhzSettingsArgsDict']] two_four_ghz_settings: Settings related to 2.4Ghz band
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WirelessRfProfilesState.__new__(_WirelessRfProfilesState)

        __props__.__dict__["ap_band_settings"] = ap_band_settings
        __props__.__dict__["band_selection_type"] = band_selection_type
        __props__.__dict__["client_balancing_enabled"] = client_balancing_enabled
        __props__.__dict__["five_ghz_settings"] = five_ghz_settings
        __props__.__dict__["flex_radios"] = flex_radios
        __props__.__dict__["min_bitrate_type"] = min_bitrate_type
        __props__.__dict__["name"] = name
        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["per_ssid_settings"] = per_ssid_settings
        __props__.__dict__["rf_profile_id"] = rf_profile_id
        __props__.__dict__["six_ghz_settings"] = six_ghz_settings
        __props__.__dict__["transmission"] = transmission
        __props__.__dict__["two_four_ghz_settings"] = two_four_ghz_settings
        return WirelessRfProfiles(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="apBandSettings")
    def ap_band_settings(self) -> pulumi.Output['outputs.WirelessRfProfilesApBandSettings']:
        """
        Settings that will be enabled if selectionType is set to 'ap'.
        """
        return pulumi.get(self, "ap_band_settings")

    @property
    @pulumi.getter(name="bandSelectionType")
    def band_selection_type(self) -> pulumi.Output[builtins.str]:
        """
        Band selection can be set to either 'ssid' or 'ap'. This param is required on creation.
        """
        return pulumi.get(self, "band_selection_type")

    @property
    @pulumi.getter(name="clientBalancingEnabled")
    def client_balancing_enabled(self) -> pulumi.Output[builtins.bool]:
        """
        Steers client to best available access point. Can be either true or false. Defaults to true.
        """
        return pulumi.get(self, "client_balancing_enabled")

    @property
    @pulumi.getter(name="fiveGhzSettings")
    def five_ghz_settings(self) -> pulumi.Output['outputs.WirelessRfProfilesFiveGhzSettings']:
        """
        Settings related to 5Ghz band
        """
        return pulumi.get(self, "five_ghz_settings")

    @property
    @pulumi.getter(name="flexRadios")
    def flex_radios(self) -> pulumi.Output[Optional['outputs.WirelessRfProfilesFlexRadios']]:
        """
        Flex radio settings.
        """
        return pulumi.get(self, "flex_radios")

    @property
    @pulumi.getter(name="minBitrateType")
    def min_bitrate_type(self) -> pulumi.Output[builtins.str]:
        """
        Minimum bitrate can be set to either 'band' or 'ssid'. Defaults to band.
        """
        return pulumi.get(self, "min_bitrate_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[builtins.str]:
        """
        The name of the new profile. Must be unique. This param is required on creation.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[builtins.str]:
        """
        The network ID of the RF Profile
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="perSsidSettings")
    def per_ssid_settings(self) -> pulumi.Output['outputs.WirelessRfProfilesPerSsidSettings']:
        """
        Per-SSID radio settings by number.
        """
        return pulumi.get(self, "per_ssid_settings")

    @property
    @pulumi.getter(name="rfProfileId")
    def rf_profile_id(self) -> pulumi.Output[builtins.str]:
        """
        rfProfileId path parameter. Rf profile ID
        """
        return pulumi.get(self, "rf_profile_id")

    @property
    @pulumi.getter(name="sixGhzSettings")
    def six_ghz_settings(self) -> pulumi.Output['outputs.WirelessRfProfilesSixGhzSettings']:
        """
        Settings related to 6Ghz band. Only applicable to networks with 6Ghz capable APs
        """
        return pulumi.get(self, "six_ghz_settings")

    @property
    @pulumi.getter
    def transmission(self) -> pulumi.Output['outputs.WirelessRfProfilesTransmission']:
        """
        Settings related to radio transmission.
        """
        return pulumi.get(self, "transmission")

    @property
    @pulumi.getter(name="twoFourGhzSettings")
    def two_four_ghz_settings(self) -> pulumi.Output['outputs.WirelessRfProfilesTwoFourGhzSettings']:
        """
        Settings related to 2.4Ghz band
        """
        return pulumi.get(self, "two_four_ghz_settings")

