import warnings

from .times import timeout


def deprecated(func):
    """This is a decorator which can be used to mark functions
    as deprecated. It will result in a warning being emitted
    when the function is used."""
    def new_func(*args, **kwargs):
        warnings.warn("Call to deprecated function {}.".format(func.__name__),
                      category=DeprecationWarning)
        return func(*args, **kwargs)
    new_func.__name__ = func.__name__
    new_func.__doc__ = func.__doc__
    new_func.__dict__.update(func.__dict__)
    return new_func

# === Examples of use ===
"""
@deprecated
def some_old_function(x,y):
 return x + y

class SomeClass:
 @deprecated
 def some_old_method(self, x,y):
     return x + y
"""

