# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'DeploymentApm',
    'DeploymentApmConfig',
    'DeploymentElasticsearch',
    'DeploymentElasticsearchCold',
    'DeploymentElasticsearchColdAutoscaling',
    'DeploymentElasticsearchConfig',
    'DeploymentElasticsearchCoordinating',
    'DeploymentElasticsearchCoordinatingAutoscaling',
    'DeploymentElasticsearchExtension',
    'DeploymentElasticsearchFrozen',
    'DeploymentElasticsearchFrozenAutoscaling',
    'DeploymentElasticsearchHot',
    'DeploymentElasticsearchHotAutoscaling',
    'DeploymentElasticsearchKeystoreContents',
    'DeploymentElasticsearchMaster',
    'DeploymentElasticsearchMasterAutoscaling',
    'DeploymentElasticsearchMl',
    'DeploymentElasticsearchMlAutoscaling',
    'DeploymentElasticsearchRemoteCluster',
    'DeploymentElasticsearchSnapshot',
    'DeploymentElasticsearchSnapshotRepository',
    'DeploymentElasticsearchSnapshotRepositoryReference',
    'DeploymentElasticsearchSnapshotSource',
    'DeploymentElasticsearchTrustAccount',
    'DeploymentElasticsearchTrustExternal',
    'DeploymentElasticsearchWarm',
    'DeploymentElasticsearchWarmAutoscaling',
    'DeploymentEnterpriseSearch',
    'DeploymentEnterpriseSearchConfig',
    'DeploymentIntegrationsServer',
    'DeploymentIntegrationsServerConfig',
    'DeploymentIntegrationsServerEndpoints',
    'DeploymentKibana',
    'DeploymentKibanaConfig',
    'DeploymentObservability',
    'DeploymentTrafficFilterRule',
    'ElasticsearchProjectCredentials',
    'ElasticsearchProjectEndpoints',
    'ElasticsearchProjectMetadata',
    'ElasticsearchProjectSearchLake',
    'ObservabilityProjectCredentials',
    'ObservabilityProjectEndpoints',
    'ObservabilityProjectMetadata',
    'OrganizationMembers',
    'OrganizationMembersDeploymentRole',
    'OrganizationMembersProjectElasticsearchRole',
    'OrganizationMembersProjectObservabilityRole',
    'OrganizationMembersProjectSecurityRole',
    'SecurityProjectCredentials',
    'SecurityProjectEndpoints',
    'SecurityProjectMetadata',
    'SecurityProjectProductType',
    'SnapshotRepositoryGeneric',
    'SnapshotRepositoryS3',
    'GetDeploymentApmResult',
    'GetDeploymentApmTopologyResult',
    'GetDeploymentElasticsearchResult',
    'GetDeploymentElasticsearchTopologyResult',
    'GetDeploymentElasticsearchTopologyAutoscalingResult',
    'GetDeploymentEnterpriseSearchResult',
    'GetDeploymentEnterpriseSearchTopologyResult',
    'GetDeploymentIntegrationsServerResult',
    'GetDeploymentIntegrationsServerTopologyResult',
    'GetDeploymentKibanaResult',
    'GetDeploymentKibanaTopologyResult',
    'GetDeploymentObservabilityResult',
    'GetDeploymentTemplatesTemplateResult',
    'GetDeploymentTemplatesTemplateApmResult',
    'GetDeploymentTemplatesTemplateElasticsearchResult',
    'GetDeploymentTemplatesTemplateElasticsearchColdResult',
    'GetDeploymentTemplatesTemplateElasticsearchColdAutoscalingResult',
    'GetDeploymentTemplatesTemplateElasticsearchCoordinatingResult',
    'GetDeploymentTemplatesTemplateElasticsearchCoordinatingAutoscalingResult',
    'GetDeploymentTemplatesTemplateElasticsearchFrozenResult',
    'GetDeploymentTemplatesTemplateElasticsearchFrozenAutoscalingResult',
    'GetDeploymentTemplatesTemplateElasticsearchHotResult',
    'GetDeploymentTemplatesTemplateElasticsearchHotAutoscalingResult',
    'GetDeploymentTemplatesTemplateElasticsearchMasterResult',
    'GetDeploymentTemplatesTemplateElasticsearchMasterAutoscalingResult',
    'GetDeploymentTemplatesTemplateElasticsearchMlResult',
    'GetDeploymentTemplatesTemplateElasticsearchMlAutoscalingResult',
    'GetDeploymentTemplatesTemplateElasticsearchWarmResult',
    'GetDeploymentTemplatesTemplateElasticsearchWarmAutoscalingResult',
    'GetDeploymentTemplatesTemplateEnterpriseSearchResult',
    'GetDeploymentTemplatesTemplateIntegrationsServerResult',
    'GetDeploymentTemplatesTemplateKibanaResult',
    'GetDeploymentsApmResult',
    'GetDeploymentsDeploymentResult',
    'GetDeploymentsElasticsearchResult',
    'GetDeploymentsEnterpriseSearchResult',
    'GetDeploymentsIntegrationsServerResult',
    'GetDeploymentsKibanaResult',
    'GetStackApmResult',
    'GetStackElasticsearchResult',
    'GetStackEnterpriseSearchResult',
    'GetStackKibanaResult',
    'GetTrafficFilterRulesetResult',
    'GetTrafficFilterRulesetRuleResult',
]

@pulumi.output_type
class DeploymentApm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elasticsearchClusterRefId":
            suggest = "elasticsearch_cluster_ref_id"
        elif key == "httpEndpoint":
            suggest = "http_endpoint"
        elif key == "httpsEndpoint":
            suggest = "https_endpoint"
        elif key == "instanceConfigurationId":
            suggest = "instance_configuration_id"
        elif key == "instanceConfigurationVersion":
            suggest = "instance_configuration_version"
        elif key == "latestInstanceConfigurationId":
            suggest = "latest_instance_configuration_id"
        elif key == "latestInstanceConfigurationVersion":
            suggest = "latest_instance_configuration_version"
        elif key == "refId":
            suggest = "ref_id"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "sizeResource":
            suggest = "size_resource"
        elif key == "zoneCount":
            suggest = "zone_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentApm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentApm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentApm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: Optional['outputs.DeploymentApmConfig'] = None,
                 elasticsearch_cluster_ref_id: Optional[builtins.str] = None,
                 http_endpoint: Optional[builtins.str] = None,
                 https_endpoint: Optional[builtins.str] = None,
                 instance_configuration_id: Optional[builtins.str] = None,
                 instance_configuration_version: Optional[builtins.int] = None,
                 latest_instance_configuration_id: Optional[builtins.str] = None,
                 latest_instance_configuration_version: Optional[builtins.int] = None,
                 ref_id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 resource_id: Optional[builtins.str] = None,
                 size: Optional[builtins.str] = None,
                 size_resource: Optional[builtins.str] = None,
                 zone_count: Optional[builtins.int] = None):
        """
        :param 'DeploymentApmConfigArgs' config: Optionally define the Apm configuration options for the APM Server
        :param builtins.str size_resource: Optional size type, defaults to "memory".
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if elasticsearch_cluster_ref_id is not None:
            pulumi.set(__self__, "elasticsearch_cluster_ref_id", elasticsearch_cluster_ref_id)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_configuration_version is not None:
            pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        if latest_instance_configuration_id is not None:
            pulumi.set(__self__, "latest_instance_configuration_id", latest_instance_configuration_id)
        if latest_instance_configuration_version is not None:
            pulumi.set(__self__, "latest_instance_configuration_version", latest_instance_configuration_version)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def config(self) -> Optional['outputs.DeploymentApmConfig']:
        """
        Optionally define the Apm configuration options for the APM Server
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="elasticsearchClusterRefId")
    def elasticsearch_cluster_ref_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "elasticsearch_cluster_ref_id")

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "http_endpoint")

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "https_endpoint")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> Optional[builtins.int]:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="latestInstanceConfigurationId")
    def latest_instance_configuration_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "latest_instance_configuration_id")

    @property
    @pulumi.getter(name="latestInstanceConfigurationVersion")
    def latest_instance_configuration_version(self) -> Optional[builtins.int]:
        return pulumi.get(self, "latest_instance_configuration_version")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[builtins.str]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[builtins.int]:
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class DeploymentApmConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "debugEnabled":
            suggest = "debug_enabled"
        elif key == "dockerImage":
            suggest = "docker_image"
        elif key == "userSettingsJson":
            suggest = "user_settings_json"
        elif key == "userSettingsOverrideJson":
            suggest = "user_settings_override_json"
        elif key == "userSettingsOverrideYaml":
            suggest = "user_settings_override_yaml"
        elif key == "userSettingsYaml":
            suggest = "user_settings_yaml"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentApmConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentApmConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentApmConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 debug_enabled: Optional[builtins.bool] = None,
                 docker_image: Optional[builtins.str] = None,
                 user_settings_json: Optional[builtins.str] = None,
                 user_settings_override_json: Optional[builtins.str] = None,
                 user_settings_override_yaml: Optional[builtins.str] = None,
                 user_settings_yaml: Optional[builtins.str] = None):
        """
        :param builtins.bool debug_enabled: Optionally enable debug mode for APM servers - defaults to false
        :param builtins.str docker_image: Optionally override the docker image the APM nodes will use. This option will not work in ESS customers and should only be changed if you know what you're doing.
        :param builtins.str user_settings_json: An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        :param builtins.str user_settings_override_json: An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param builtins.str user_settings_override_yaml: An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param builtins.str user_settings_yaml: An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        if debug_enabled is not None:
            pulumi.set(__self__, "debug_enabled", debug_enabled)
        if docker_image is not None:
            pulumi.set(__self__, "docker_image", docker_image)
        if user_settings_json is not None:
            pulumi.set(__self__, "user_settings_json", user_settings_json)
        if user_settings_override_json is not None:
            pulumi.set(__self__, "user_settings_override_json", user_settings_override_json)
        if user_settings_override_yaml is not None:
            pulumi.set(__self__, "user_settings_override_yaml", user_settings_override_yaml)
        if user_settings_yaml is not None:
            pulumi.set(__self__, "user_settings_yaml", user_settings_yaml)

    @property
    @pulumi.getter(name="debugEnabled")
    def debug_enabled(self) -> Optional[builtins.bool]:
        """
        Optionally enable debug mode for APM servers - defaults to false
        """
        return pulumi.get(self, "debug_enabled")

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> Optional[builtins.str]:
        """
        Optionally override the docker image the APM nodes will use. This option will not work in ESS customers and should only be changed if you know what you're doing.
        """
        return pulumi.get(self, "docker_image")

    @property
    @pulumi.getter(name="userSettingsJson")
    def user_settings_json(self) -> Optional[builtins.str]:
        """
        An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_json")

    @property
    @pulumi.getter(name="userSettingsOverrideJson")
    def user_settings_override_json(self) -> Optional[builtins.str]:
        """
        An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_json")

    @property
    @pulumi.getter(name="userSettingsOverrideYaml")
    def user_settings_override_yaml(self) -> Optional[builtins.str]:
        """
        An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_yaml")

    @property
    @pulumi.getter(name="userSettingsYaml")
    def user_settings_yaml(self) -> Optional[builtins.str]:
        """
        An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_yaml")


@pulumi.output_type
class DeploymentElasticsearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudId":
            suggest = "cloud_id"
        elif key == "httpEndpoint":
            suggest = "http_endpoint"
        elif key == "httpsEndpoint":
            suggest = "https_endpoint"
        elif key == "keystoreContents":
            suggest = "keystore_contents"
        elif key == "refId":
            suggest = "ref_id"
        elif key == "remoteClusters":
            suggest = "remote_clusters"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "snapshotSource":
            suggest = "snapshot_source"
        elif key == "trustAccounts":
            suggest = "trust_accounts"
        elif key == "trustExternals":
            suggest = "trust_externals"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hot: 'outputs.DeploymentElasticsearchHot',
                 autoscale: Optional[builtins.bool] = None,
                 cloud_id: Optional[builtins.str] = None,
                 cold: Optional['outputs.DeploymentElasticsearchCold'] = None,
                 config: Optional['outputs.DeploymentElasticsearchConfig'] = None,
                 coordinating: Optional['outputs.DeploymentElasticsearchCoordinating'] = None,
                 extensions: Optional[Sequence['outputs.DeploymentElasticsearchExtension']] = None,
                 frozen: Optional['outputs.DeploymentElasticsearchFrozen'] = None,
                 http_endpoint: Optional[builtins.str] = None,
                 https_endpoint: Optional[builtins.str] = None,
                 keystore_contents: Optional[Mapping[str, 'outputs.DeploymentElasticsearchKeystoreContents']] = None,
                 master: Optional['outputs.DeploymentElasticsearchMaster'] = None,
                 ml: Optional['outputs.DeploymentElasticsearchMl'] = None,
                 ref_id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 remote_clusters: Optional[Sequence['outputs.DeploymentElasticsearchRemoteCluster']] = None,
                 resource_id: Optional[builtins.str] = None,
                 snapshot: Optional['outputs.DeploymentElasticsearchSnapshot'] = None,
                 snapshot_source: Optional['outputs.DeploymentElasticsearchSnapshotSource'] = None,
                 strategy: Optional[builtins.str] = None,
                 trust_accounts: Optional[Sequence['outputs.DeploymentElasticsearchTrustAccount']] = None,
                 trust_externals: Optional[Sequence['outputs.DeploymentElasticsearchTrustExternal']] = None,
                 warm: Optional['outputs.DeploymentElasticsearchWarm'] = None):
        """
        :param 'DeploymentElasticsearchHotArgs' hot: 'hot' topology element
        :param builtins.bool autoscale: Enable or disable autoscaling. Defaults to the setting coming from the deployment template.
        :param builtins.str cloud_id: The encoded Elasticsearch credentials to use in Beats or Logstash
        :param 'DeploymentElasticsearchColdArgs' cold: 'cold' topology element
        :param 'DeploymentElasticsearchConfigArgs' config: Elasticsearch settings which will be applied to all topologies
        :param 'DeploymentElasticsearchCoordinatingArgs' coordinating: 'coordinating' topology element
        :param Sequence['DeploymentElasticsearchExtensionArgs'] extensions: Optional Elasticsearch extensions such as custom bundles or plugins.
        :param 'DeploymentElasticsearchFrozenArgs' frozen: 'frozen' topology element
        :param builtins.str http_endpoint: The Elasticsearch resource HTTP endpoint
        :param builtins.str https_endpoint: The Elasticsearch resource HTTPs endpoint
        :param Mapping[str, 'DeploymentElasticsearchKeystoreContentsArgs'] keystore_contents: Keystore contents that are controlled by the deployment resource.
        :param 'DeploymentElasticsearchMasterArgs' master: 'master' topology element
        :param 'DeploymentElasticsearchMlArgs' ml: 'ml' topology element
        :param builtins.str ref_id: A human readable reference for the Elasticsearch resource. The default value `main-elasticsearch` is recommended.
        :param builtins.str region: Elasticsearch Service (ESS) region where the deployment should be hosted. For Elastic Cloud Enterprise (ECE) installations, set to `"ece-region".
        :param Sequence['DeploymentElasticsearchRemoteClusterArgs'] remote_clusters: Optional Elasticsearch remote clusters to configure for the Elasticsearch resource, can be set multiple times
        :param builtins.str resource_id: The Elasticsearch resource unique identifier
        :param 'DeploymentElasticsearchSnapshotArgs' snapshot: (ECE only) Snapshot configuration settings for an Elasticsearch cluster.
        :param builtins.str strategy: Configuration strategy type autodetect, grow_and_shrink, rolling_grow_and_shrink, rolling_all
        :param Sequence['DeploymentElasticsearchTrustAccountArgs'] trust_accounts: Optional Elasticsearch account trust settings.
        :param Sequence['DeploymentElasticsearchTrustExternalArgs'] trust_externals: Optional Elasticsearch external trust settings.
        :param 'DeploymentElasticsearchWarmArgs' warm: 'warm' topology element
        """
        pulumi.set(__self__, "hot", hot)
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if cloud_id is not None:
            pulumi.set(__self__, "cloud_id", cloud_id)
        if cold is not None:
            pulumi.set(__self__, "cold", cold)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if coordinating is not None:
            pulumi.set(__self__, "coordinating", coordinating)
        if extensions is not None:
            pulumi.set(__self__, "extensions", extensions)
        if frozen is not None:
            pulumi.set(__self__, "frozen", frozen)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if keystore_contents is not None:
            pulumi.set(__self__, "keystore_contents", keystore_contents)
        if master is not None:
            pulumi.set(__self__, "master", master)
        if ml is not None:
            pulumi.set(__self__, "ml", ml)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if remote_clusters is not None:
            pulumi.set(__self__, "remote_clusters", remote_clusters)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if snapshot is not None:
            pulumi.set(__self__, "snapshot", snapshot)
        if snapshot_source is not None:
            pulumi.set(__self__, "snapshot_source", snapshot_source)
        if strategy is not None:
            pulumi.set(__self__, "strategy", strategy)
        if trust_accounts is not None:
            pulumi.set(__self__, "trust_accounts", trust_accounts)
        if trust_externals is not None:
            pulumi.set(__self__, "trust_externals", trust_externals)
        if warm is not None:
            pulumi.set(__self__, "warm", warm)

    @property
    @pulumi.getter
    def hot(self) -> 'outputs.DeploymentElasticsearchHot':
        """
        'hot' topology element
        """
        return pulumi.get(self, "hot")

    @property
    @pulumi.getter
    def autoscale(self) -> Optional[builtins.bool]:
        """
        Enable or disable autoscaling. Defaults to the setting coming from the deployment template.
        """
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> Optional[builtins.str]:
        """
        The encoded Elasticsearch credentials to use in Beats or Logstash
        """
        return pulumi.get(self, "cloud_id")

    @property
    @pulumi.getter
    def cold(self) -> Optional['outputs.DeploymentElasticsearchCold']:
        """
        'cold' topology element
        """
        return pulumi.get(self, "cold")

    @property
    @pulumi.getter
    def config(self) -> Optional['outputs.DeploymentElasticsearchConfig']:
        """
        Elasticsearch settings which will be applied to all topologies
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def coordinating(self) -> Optional['outputs.DeploymentElasticsearchCoordinating']:
        """
        'coordinating' topology element
        """
        return pulumi.get(self, "coordinating")

    @property
    @pulumi.getter
    def extensions(self) -> Optional[Sequence['outputs.DeploymentElasticsearchExtension']]:
        """
        Optional Elasticsearch extensions such as custom bundles or plugins.
        """
        return pulumi.get(self, "extensions")

    @property
    @pulumi.getter
    def frozen(self) -> Optional['outputs.DeploymentElasticsearchFrozen']:
        """
        'frozen' topology element
        """
        return pulumi.get(self, "frozen")

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[builtins.str]:
        """
        The Elasticsearch resource HTTP endpoint
        """
        return pulumi.get(self, "http_endpoint")

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[builtins.str]:
        """
        The Elasticsearch resource HTTPs endpoint
        """
        return pulumi.get(self, "https_endpoint")

    @property
    @pulumi.getter(name="keystoreContents")
    def keystore_contents(self) -> Optional[Mapping[str, 'outputs.DeploymentElasticsearchKeystoreContents']]:
        """
        Keystore contents that are controlled by the deployment resource.
        """
        return pulumi.get(self, "keystore_contents")

    @property
    @pulumi.getter
    def master(self) -> Optional['outputs.DeploymentElasticsearchMaster']:
        """
        'master' topology element
        """
        return pulumi.get(self, "master")

    @property
    @pulumi.getter
    def ml(self) -> Optional['outputs.DeploymentElasticsearchMl']:
        """
        'ml' topology element
        """
        return pulumi.get(self, "ml")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[builtins.str]:
        """
        A human readable reference for the Elasticsearch resource. The default value `main-elasticsearch` is recommended.
        """
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        Elasticsearch Service (ESS) region where the deployment should be hosted. For Elastic Cloud Enterprise (ECE) installations, set to `"ece-region".
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="remoteClusters")
    def remote_clusters(self) -> Optional[Sequence['outputs.DeploymentElasticsearchRemoteCluster']]:
        """
        Optional Elasticsearch remote clusters to configure for the Elasticsearch resource, can be set multiple times
        """
        return pulumi.get(self, "remote_clusters")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        """
        The Elasticsearch resource unique identifier
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def snapshot(self) -> Optional['outputs.DeploymentElasticsearchSnapshot']:
        """
        (ECE only) Snapshot configuration settings for an Elasticsearch cluster.
        """
        return pulumi.get(self, "snapshot")

    @property
    @pulumi.getter(name="snapshotSource")
    def snapshot_source(self) -> Optional['outputs.DeploymentElasticsearchSnapshotSource']:
        return pulumi.get(self, "snapshot_source")

    @property
    @pulumi.getter
    def strategy(self) -> Optional[builtins.str]:
        """
        Configuration strategy type autodetect, grow_and_shrink, rolling_grow_and_shrink, rolling_all
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter(name="trustAccounts")
    def trust_accounts(self) -> Optional[Sequence['outputs.DeploymentElasticsearchTrustAccount']]:
        """
        Optional Elasticsearch account trust settings.
        """
        return pulumi.get(self, "trust_accounts")

    @property
    @pulumi.getter(name="trustExternals")
    def trust_externals(self) -> Optional[Sequence['outputs.DeploymentElasticsearchTrustExternal']]:
        """
        Optional Elasticsearch external trust settings.
        """
        return pulumi.get(self, "trust_externals")

    @property
    @pulumi.getter
    def warm(self) -> Optional['outputs.DeploymentElasticsearchWarm']:
        """
        'warm' topology element
        """
        return pulumi.get(self, "warm")


@pulumi.output_type
class DeploymentElasticsearchCold(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceConfigurationId":
            suggest = "instance_configuration_id"
        elif key == "instanceConfigurationVersion":
            suggest = "instance_configuration_version"
        elif key == "latestInstanceConfigurationId":
            suggest = "latest_instance_configuration_id"
        elif key == "latestInstanceConfigurationVersion":
            suggest = "latest_instance_configuration_version"
        elif key == "nodeRoles":
            suggest = "node_roles"
        elif key == "nodeTypeData":
            suggest = "node_type_data"
        elif key == "nodeTypeIngest":
            suggest = "node_type_ingest"
        elif key == "nodeTypeMaster":
            suggest = "node_type_master"
        elif key == "nodeTypeMl":
            suggest = "node_type_ml"
        elif key == "sizeResource":
            suggest = "size_resource"
        elif key == "zoneCount":
            suggest = "zone_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchCold. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchCold.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchCold.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling: 'outputs.DeploymentElasticsearchColdAutoscaling',
                 instance_configuration_id: Optional[builtins.str] = None,
                 instance_configuration_version: Optional[builtins.int] = None,
                 latest_instance_configuration_id: Optional[builtins.str] = None,
                 latest_instance_configuration_version: Optional[builtins.int] = None,
                 node_roles: Optional[Sequence[builtins.str]] = None,
                 node_type_data: Optional[builtins.str] = None,
                 node_type_ingest: Optional[builtins.str] = None,
                 node_type_master: Optional[builtins.str] = None,
                 node_type_ml: Optional[builtins.str] = None,
                 size: Optional[builtins.str] = None,
                 size_resource: Optional[builtins.str] = None,
                 zone_count: Optional[builtins.int] = None):
        """
        :param 'DeploymentElasticsearchColdAutoscalingArgs' autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param builtins.str instance_configuration_id: Instance Configuration ID of the topology element
        :param builtins.int instance_configuration_version: Instance Configuration version of the topology element
        :param builtins.str latest_instance_configuration_id: Latest Instance Configuration ID available on the deployment template for the topology element
        :param builtins.int latest_instance_configuration_version: Latest version available for the Instance Configuration with the latest*instance*configuration_id
        :param Sequence[builtins.str] node_roles: The computed list of node roles for the current topology element
        :param builtins.str node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param builtins.str node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param builtins.str node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param builtins.str node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param builtins.str size: Amount of "size_resource" per node in the "\\n\\ng" notation
        :param builtins.str size_resource: Size type, defaults to "memory".
        :param builtins.int zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_configuration_version is not None:
            pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        if latest_instance_configuration_id is not None:
            pulumi.set(__self__, "latest_instance_configuration_id", latest_instance_configuration_id)
        if latest_instance_configuration_version is not None:
            pulumi.set(__self__, "latest_instance_configuration_version", latest_instance_configuration_version)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.DeploymentElasticsearchColdAutoscaling':
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Instance Configuration version of the topology element
        """
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="latestInstanceConfigurationId")
    def latest_instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Latest Instance Configuration ID available on the deployment template for the topology element
        """
        return pulumi.get(self, "latest_instance_configuration_id")

    @property
    @pulumi.getter(name="latestInstanceConfigurationVersion")
    def latest_instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Latest version available for the Instance Configuration with the latest*instance*configuration_id
        """
        return pulumi.get(self, "latest_instance_configuration_version")

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[Sequence[builtins.str]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        """
        Amount of "size_resource" per node in the "\\n\\ng" notation
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[builtins.str]:
        """
        Size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[builtins.int]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class DeploymentElasticsearchColdAutoscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSize":
            suggest = "max_size"
        elif key == "maxSizeResource":
            suggest = "max_size_resource"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "minSizeResource":
            suggest = "min_size_resource"
        elif key == "policyOverrideJson":
            suggest = "policy_override_json"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchColdAutoscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchColdAutoscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchColdAutoscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale: Optional[builtins.bool] = None,
                 max_size: Optional[builtins.str] = None,
                 max_size_resource: Optional[builtins.str] = None,
                 min_size: Optional[builtins.str] = None,
                 min_size_resource: Optional[builtins.str] = None,
                 policy_override_json: Optional[builtins.str] = None):
        """
        :param builtins.bool autoscale: Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        :param builtins.str max_size: Maximum size value for the maximum autoscaling setting.
        :param builtins.str max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param builtins.str min_size: Minimum size value for the minimum autoscaling setting.
        :param builtins.str min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param builtins.str policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter
    def autoscale(self) -> Optional[builtins.bool]:
        """
        Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        """
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.str]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[builtins.str]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.str]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[builtins.str]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[builtins.str]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")


@pulumi.output_type
class DeploymentElasticsearchConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerImage":
            suggest = "docker_image"
        elif key == "userSettingsJson":
            suggest = "user_settings_json"
        elif key == "userSettingsOverrideJson":
            suggest = "user_settings_override_json"
        elif key == "userSettingsOverrideYaml":
            suggest = "user_settings_override_yaml"
        elif key == "userSettingsYaml":
            suggest = "user_settings_yaml"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 docker_image: Optional[builtins.str] = None,
                 plugins: Optional[Sequence[builtins.str]] = None,
                 user_settings_json: Optional[builtins.str] = None,
                 user_settings_override_json: Optional[builtins.str] = None,
                 user_settings_override_yaml: Optional[builtins.str] = None,
                 user_settings_yaml: Optional[builtins.str] = None):
        """
        :param builtins.str docker_image: Overrides the docker image the Elasticsearch nodes will use. Note that this field will only work for internal users only.
        :param Sequence[builtins.str] plugins: List of Elasticsearch supported plugins, which vary from version to version. Check the Stack Pack version to see which plugins are supported for each version. This is currently only available from the UI and [ecctl](https://www.elastic.co/guide/en/ecctl/master/ecctl_stack_list.html)
        :param builtins.str user_settings_json: JSON-formatted user level "elasticsearch.yml" setting overrides
        :param builtins.str user_settings_override_json: JSON-formatted admin (ECE) level "elasticsearch.yml" setting overrides
        :param builtins.str user_settings_override_yaml: YAML-formatted admin (ECE) level "elasticsearch.yml" setting overrides
        :param builtins.str user_settings_yaml: YAML-formatted user level "elasticsearch.yml" setting overrides
        """
        if docker_image is not None:
            pulumi.set(__self__, "docker_image", docker_image)
        if plugins is not None:
            pulumi.set(__self__, "plugins", plugins)
        if user_settings_json is not None:
            pulumi.set(__self__, "user_settings_json", user_settings_json)
        if user_settings_override_json is not None:
            pulumi.set(__self__, "user_settings_override_json", user_settings_override_json)
        if user_settings_override_yaml is not None:
            pulumi.set(__self__, "user_settings_override_yaml", user_settings_override_yaml)
        if user_settings_yaml is not None:
            pulumi.set(__self__, "user_settings_yaml", user_settings_yaml)

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> Optional[builtins.str]:
        """
        Overrides the docker image the Elasticsearch nodes will use. Note that this field will only work for internal users only.
        """
        return pulumi.get(self, "docker_image")

    @property
    @pulumi.getter
    def plugins(self) -> Optional[Sequence[builtins.str]]:
        """
        List of Elasticsearch supported plugins, which vary from version to version. Check the Stack Pack version to see which plugins are supported for each version. This is currently only available from the UI and [ecctl](https://www.elastic.co/guide/en/ecctl/master/ecctl_stack_list.html)
        """
        return pulumi.get(self, "plugins")

    @property
    @pulumi.getter(name="userSettingsJson")
    def user_settings_json(self) -> Optional[builtins.str]:
        """
        JSON-formatted user level "elasticsearch.yml" setting overrides
        """
        return pulumi.get(self, "user_settings_json")

    @property
    @pulumi.getter(name="userSettingsOverrideJson")
    def user_settings_override_json(self) -> Optional[builtins.str]:
        """
        JSON-formatted admin (ECE) level "elasticsearch.yml" setting overrides
        """
        return pulumi.get(self, "user_settings_override_json")

    @property
    @pulumi.getter(name="userSettingsOverrideYaml")
    def user_settings_override_yaml(self) -> Optional[builtins.str]:
        """
        YAML-formatted admin (ECE) level "elasticsearch.yml" setting overrides
        """
        return pulumi.get(self, "user_settings_override_yaml")

    @property
    @pulumi.getter(name="userSettingsYaml")
    def user_settings_yaml(self) -> Optional[builtins.str]:
        """
        YAML-formatted user level "elasticsearch.yml" setting overrides
        """
        return pulumi.get(self, "user_settings_yaml")


@pulumi.output_type
class DeploymentElasticsearchCoordinating(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceConfigurationId":
            suggest = "instance_configuration_id"
        elif key == "instanceConfigurationVersion":
            suggest = "instance_configuration_version"
        elif key == "latestInstanceConfigurationId":
            suggest = "latest_instance_configuration_id"
        elif key == "latestInstanceConfigurationVersion":
            suggest = "latest_instance_configuration_version"
        elif key == "nodeRoles":
            suggest = "node_roles"
        elif key == "nodeTypeData":
            suggest = "node_type_data"
        elif key == "nodeTypeIngest":
            suggest = "node_type_ingest"
        elif key == "nodeTypeMaster":
            suggest = "node_type_master"
        elif key == "nodeTypeMl":
            suggest = "node_type_ml"
        elif key == "sizeResource":
            suggest = "size_resource"
        elif key == "zoneCount":
            suggest = "zone_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchCoordinating. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchCoordinating.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchCoordinating.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling: 'outputs.DeploymentElasticsearchCoordinatingAutoscaling',
                 instance_configuration_id: Optional[builtins.str] = None,
                 instance_configuration_version: Optional[builtins.int] = None,
                 latest_instance_configuration_id: Optional[builtins.str] = None,
                 latest_instance_configuration_version: Optional[builtins.int] = None,
                 node_roles: Optional[Sequence[builtins.str]] = None,
                 node_type_data: Optional[builtins.str] = None,
                 node_type_ingest: Optional[builtins.str] = None,
                 node_type_master: Optional[builtins.str] = None,
                 node_type_ml: Optional[builtins.str] = None,
                 size: Optional[builtins.str] = None,
                 size_resource: Optional[builtins.str] = None,
                 zone_count: Optional[builtins.int] = None):
        """
        :param 'DeploymentElasticsearchCoordinatingAutoscalingArgs' autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param builtins.str instance_configuration_id: Instance Configuration ID of the topology element
        :param builtins.int instance_configuration_version: Instance Configuration version of the topology element
        :param builtins.str latest_instance_configuration_id: Latest Instance Configuration ID available on the deployment template for the topology element
        :param builtins.int latest_instance_configuration_version: Latest version available for the Instance Configuration with the latest*instance*configuration_id
        :param Sequence[builtins.str] node_roles: The computed list of node roles for the current topology element
        :param builtins.str node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param builtins.str node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param builtins.str node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param builtins.str node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param builtins.str size: Amount of "size_resource" per node in the "\\n\\ng" notation
        :param builtins.str size_resource: Size type, defaults to "memory".
        :param builtins.int zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_configuration_version is not None:
            pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        if latest_instance_configuration_id is not None:
            pulumi.set(__self__, "latest_instance_configuration_id", latest_instance_configuration_id)
        if latest_instance_configuration_version is not None:
            pulumi.set(__self__, "latest_instance_configuration_version", latest_instance_configuration_version)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.DeploymentElasticsearchCoordinatingAutoscaling':
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Instance Configuration version of the topology element
        """
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="latestInstanceConfigurationId")
    def latest_instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Latest Instance Configuration ID available on the deployment template for the topology element
        """
        return pulumi.get(self, "latest_instance_configuration_id")

    @property
    @pulumi.getter(name="latestInstanceConfigurationVersion")
    def latest_instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Latest version available for the Instance Configuration with the latest*instance*configuration_id
        """
        return pulumi.get(self, "latest_instance_configuration_version")

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[Sequence[builtins.str]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        """
        Amount of "size_resource" per node in the "\\n\\ng" notation
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[builtins.str]:
        """
        Size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[builtins.int]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class DeploymentElasticsearchCoordinatingAutoscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSize":
            suggest = "max_size"
        elif key == "maxSizeResource":
            suggest = "max_size_resource"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "minSizeResource":
            suggest = "min_size_resource"
        elif key == "policyOverrideJson":
            suggest = "policy_override_json"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchCoordinatingAutoscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchCoordinatingAutoscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchCoordinatingAutoscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale: Optional[builtins.bool] = None,
                 max_size: Optional[builtins.str] = None,
                 max_size_resource: Optional[builtins.str] = None,
                 min_size: Optional[builtins.str] = None,
                 min_size_resource: Optional[builtins.str] = None,
                 policy_override_json: Optional[builtins.str] = None):
        """
        :param builtins.bool autoscale: Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        :param builtins.str max_size: Maximum size value for the maximum autoscaling setting.
        :param builtins.str max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param builtins.str min_size: Minimum size value for the minimum autoscaling setting.
        :param builtins.str min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param builtins.str policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter
    def autoscale(self) -> Optional[builtins.bool]:
        """
        Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        """
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.str]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[builtins.str]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.str]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[builtins.str]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[builtins.str]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")


@pulumi.output_type
class DeploymentElasticsearchExtension(dict):
    def __init__(__self__, *,
                 name: builtins.str,
                 type: builtins.str,
                 url: builtins.str,
                 version: builtins.str):
        """
        :param builtins.str name: Extension name.
        :param builtins.str type: Extension type, only `bundle` or `plugin` are supported.
        :param builtins.str url: Bundle or plugin URL, the extension URL can be obtained from the `ec_deployment_extension.<name>.url` attribute or the API and cannot be a random HTTP address that is hosted elsewhere.
        :param builtins.str version: Elasticsearch compatibility version. Bundles should specify major or minor versions with wildcards, such as `7.*` or `*` but **plugins must use full version notation down to the patch level**, such as `7.10.1` and wildcards are not allowed.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "url", url)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        Extension name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Extension type, only `bundle` or `plugin` are supported.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def url(self) -> builtins.str:
        """
        Bundle or plugin URL, the extension URL can be obtained from the `ec_deployment_extension.<name>.url` attribute or the API and cannot be a random HTTP address that is hosted elsewhere.
        """
        return pulumi.get(self, "url")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Elasticsearch compatibility version. Bundles should specify major or minor versions with wildcards, such as `7.*` or `*` but **plugins must use full version notation down to the patch level**, such as `7.10.1` and wildcards are not allowed.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class DeploymentElasticsearchFrozen(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceConfigurationId":
            suggest = "instance_configuration_id"
        elif key == "instanceConfigurationVersion":
            suggest = "instance_configuration_version"
        elif key == "latestInstanceConfigurationId":
            suggest = "latest_instance_configuration_id"
        elif key == "latestInstanceConfigurationVersion":
            suggest = "latest_instance_configuration_version"
        elif key == "nodeRoles":
            suggest = "node_roles"
        elif key == "nodeTypeData":
            suggest = "node_type_data"
        elif key == "nodeTypeIngest":
            suggest = "node_type_ingest"
        elif key == "nodeTypeMaster":
            suggest = "node_type_master"
        elif key == "nodeTypeMl":
            suggest = "node_type_ml"
        elif key == "sizeResource":
            suggest = "size_resource"
        elif key == "zoneCount":
            suggest = "zone_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchFrozen. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchFrozen.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchFrozen.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling: 'outputs.DeploymentElasticsearchFrozenAutoscaling',
                 instance_configuration_id: Optional[builtins.str] = None,
                 instance_configuration_version: Optional[builtins.int] = None,
                 latest_instance_configuration_id: Optional[builtins.str] = None,
                 latest_instance_configuration_version: Optional[builtins.int] = None,
                 node_roles: Optional[Sequence[builtins.str]] = None,
                 node_type_data: Optional[builtins.str] = None,
                 node_type_ingest: Optional[builtins.str] = None,
                 node_type_master: Optional[builtins.str] = None,
                 node_type_ml: Optional[builtins.str] = None,
                 size: Optional[builtins.str] = None,
                 size_resource: Optional[builtins.str] = None,
                 zone_count: Optional[builtins.int] = None):
        """
        :param 'DeploymentElasticsearchFrozenAutoscalingArgs' autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param builtins.str instance_configuration_id: Instance Configuration ID of the topology element
        :param builtins.int instance_configuration_version: Instance Configuration version of the topology element
        :param builtins.str latest_instance_configuration_id: Latest Instance Configuration ID available on the deployment template for the topology element
        :param builtins.int latest_instance_configuration_version: Latest version available for the Instance Configuration with the latest*instance*configuration_id
        :param Sequence[builtins.str] node_roles: The computed list of node roles for the current topology element
        :param builtins.str node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param builtins.str node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param builtins.str node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param builtins.str node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param builtins.str size: Amount of "size_resource" per node in the "\\n\\ng" notation
        :param builtins.str size_resource: Size type, defaults to "memory".
        :param builtins.int zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_configuration_version is not None:
            pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        if latest_instance_configuration_id is not None:
            pulumi.set(__self__, "latest_instance_configuration_id", latest_instance_configuration_id)
        if latest_instance_configuration_version is not None:
            pulumi.set(__self__, "latest_instance_configuration_version", latest_instance_configuration_version)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.DeploymentElasticsearchFrozenAutoscaling':
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Instance Configuration version of the topology element
        """
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="latestInstanceConfigurationId")
    def latest_instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Latest Instance Configuration ID available on the deployment template for the topology element
        """
        return pulumi.get(self, "latest_instance_configuration_id")

    @property
    @pulumi.getter(name="latestInstanceConfigurationVersion")
    def latest_instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Latest version available for the Instance Configuration with the latest*instance*configuration_id
        """
        return pulumi.get(self, "latest_instance_configuration_version")

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[Sequence[builtins.str]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        """
        Amount of "size_resource" per node in the "\\n\\ng" notation
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[builtins.str]:
        """
        Size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[builtins.int]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class DeploymentElasticsearchFrozenAutoscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSize":
            suggest = "max_size"
        elif key == "maxSizeResource":
            suggest = "max_size_resource"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "minSizeResource":
            suggest = "min_size_resource"
        elif key == "policyOverrideJson":
            suggest = "policy_override_json"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchFrozenAutoscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchFrozenAutoscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchFrozenAutoscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale: Optional[builtins.bool] = None,
                 max_size: Optional[builtins.str] = None,
                 max_size_resource: Optional[builtins.str] = None,
                 min_size: Optional[builtins.str] = None,
                 min_size_resource: Optional[builtins.str] = None,
                 policy_override_json: Optional[builtins.str] = None):
        """
        :param builtins.bool autoscale: Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        :param builtins.str max_size: Maximum size value for the maximum autoscaling setting.
        :param builtins.str max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param builtins.str min_size: Minimum size value for the minimum autoscaling setting.
        :param builtins.str min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param builtins.str policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter
    def autoscale(self) -> Optional[builtins.bool]:
        """
        Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        """
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.str]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[builtins.str]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.str]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[builtins.str]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[builtins.str]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")


@pulumi.output_type
class DeploymentElasticsearchHot(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceConfigurationId":
            suggest = "instance_configuration_id"
        elif key == "instanceConfigurationVersion":
            suggest = "instance_configuration_version"
        elif key == "latestInstanceConfigurationId":
            suggest = "latest_instance_configuration_id"
        elif key == "latestInstanceConfigurationVersion":
            suggest = "latest_instance_configuration_version"
        elif key == "nodeRoles":
            suggest = "node_roles"
        elif key == "nodeTypeData":
            suggest = "node_type_data"
        elif key == "nodeTypeIngest":
            suggest = "node_type_ingest"
        elif key == "nodeTypeMaster":
            suggest = "node_type_master"
        elif key == "nodeTypeMl":
            suggest = "node_type_ml"
        elif key == "sizeResource":
            suggest = "size_resource"
        elif key == "zoneCount":
            suggest = "zone_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchHot. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchHot.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchHot.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling: 'outputs.DeploymentElasticsearchHotAutoscaling',
                 instance_configuration_id: Optional[builtins.str] = None,
                 instance_configuration_version: Optional[builtins.int] = None,
                 latest_instance_configuration_id: Optional[builtins.str] = None,
                 latest_instance_configuration_version: Optional[builtins.int] = None,
                 node_roles: Optional[Sequence[builtins.str]] = None,
                 node_type_data: Optional[builtins.str] = None,
                 node_type_ingest: Optional[builtins.str] = None,
                 node_type_master: Optional[builtins.str] = None,
                 node_type_ml: Optional[builtins.str] = None,
                 size: Optional[builtins.str] = None,
                 size_resource: Optional[builtins.str] = None,
                 zone_count: Optional[builtins.int] = None):
        """
        :param 'DeploymentElasticsearchHotAutoscalingArgs' autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param builtins.str instance_configuration_id: Instance Configuration ID of the topology element
        :param builtins.int instance_configuration_version: Instance Configuration version of the topology element
        :param builtins.str latest_instance_configuration_id: Latest Instance Configuration ID available on the deployment template for the topology element
        :param builtins.int latest_instance_configuration_version: Latest version available for the Instance Configuration with the latest*instance*configuration_id
        :param Sequence[builtins.str] node_roles: The computed list of node roles for the current topology element
        :param builtins.str node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param builtins.str node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param builtins.str node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param builtins.str node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param builtins.str size: Amount of "size_resource" per node in the "\\n\\ng" notation
        :param builtins.str size_resource: Size type, defaults to "memory".
        :param builtins.int zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_configuration_version is not None:
            pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        if latest_instance_configuration_id is not None:
            pulumi.set(__self__, "latest_instance_configuration_id", latest_instance_configuration_id)
        if latest_instance_configuration_version is not None:
            pulumi.set(__self__, "latest_instance_configuration_version", latest_instance_configuration_version)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.DeploymentElasticsearchHotAutoscaling':
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Instance Configuration version of the topology element
        """
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="latestInstanceConfigurationId")
    def latest_instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Latest Instance Configuration ID available on the deployment template for the topology element
        """
        return pulumi.get(self, "latest_instance_configuration_id")

    @property
    @pulumi.getter(name="latestInstanceConfigurationVersion")
    def latest_instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Latest version available for the Instance Configuration with the latest*instance*configuration_id
        """
        return pulumi.get(self, "latest_instance_configuration_version")

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[Sequence[builtins.str]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        """
        Amount of "size_resource" per node in the "\\n\\ng" notation
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[builtins.str]:
        """
        Size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[builtins.int]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class DeploymentElasticsearchHotAutoscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSize":
            suggest = "max_size"
        elif key == "maxSizeResource":
            suggest = "max_size_resource"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "minSizeResource":
            suggest = "min_size_resource"
        elif key == "policyOverrideJson":
            suggest = "policy_override_json"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchHotAutoscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchHotAutoscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchHotAutoscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale: Optional[builtins.bool] = None,
                 max_size: Optional[builtins.str] = None,
                 max_size_resource: Optional[builtins.str] = None,
                 min_size: Optional[builtins.str] = None,
                 min_size_resource: Optional[builtins.str] = None,
                 policy_override_json: Optional[builtins.str] = None):
        """
        :param builtins.bool autoscale: Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        :param builtins.str max_size: Maximum size value for the maximum autoscaling setting.
        :param builtins.str max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param builtins.str min_size: Minimum size value for the minimum autoscaling setting.
        :param builtins.str min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param builtins.str policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter
    def autoscale(self) -> Optional[builtins.bool]:
        """
        Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        """
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.str]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[builtins.str]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.str]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[builtins.str]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[builtins.str]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")


@pulumi.output_type
class DeploymentElasticsearchKeystoreContents(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "asFile":
            suggest = "as_file"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchKeystoreContents. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchKeystoreContents.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchKeystoreContents.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: builtins.str,
                 as_file: Optional[builtins.bool] = None):
        """
        :param builtins.str value: Secret value. This can either be a string or a JSON object that is stored as a JSON string in the keystore.
        :param builtins.bool as_file: If true, the secret is handled as a file. Otherwise, it's handled as a plain string.
        """
        pulumi.set(__self__, "value", value)
        if as_file is not None:
            pulumi.set(__self__, "as_file", as_file)

    @property
    @pulumi.getter
    def value(self) -> builtins.str:
        """
        Secret value. This can either be a string or a JSON object that is stored as a JSON string in the keystore.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="asFile")
    def as_file(self) -> Optional[builtins.bool]:
        """
        If true, the secret is handled as a file. Otherwise, it's handled as a plain string.
        """
        return pulumi.get(self, "as_file")


@pulumi.output_type
class DeploymentElasticsearchMaster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceConfigurationId":
            suggest = "instance_configuration_id"
        elif key == "instanceConfigurationVersion":
            suggest = "instance_configuration_version"
        elif key == "latestInstanceConfigurationId":
            suggest = "latest_instance_configuration_id"
        elif key == "latestInstanceConfigurationVersion":
            suggest = "latest_instance_configuration_version"
        elif key == "nodeRoles":
            suggest = "node_roles"
        elif key == "nodeTypeData":
            suggest = "node_type_data"
        elif key == "nodeTypeIngest":
            suggest = "node_type_ingest"
        elif key == "nodeTypeMaster":
            suggest = "node_type_master"
        elif key == "nodeTypeMl":
            suggest = "node_type_ml"
        elif key == "sizeResource":
            suggest = "size_resource"
        elif key == "zoneCount":
            suggest = "zone_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchMaster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchMaster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchMaster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling: 'outputs.DeploymentElasticsearchMasterAutoscaling',
                 instance_configuration_id: Optional[builtins.str] = None,
                 instance_configuration_version: Optional[builtins.int] = None,
                 latest_instance_configuration_id: Optional[builtins.str] = None,
                 latest_instance_configuration_version: Optional[builtins.int] = None,
                 node_roles: Optional[Sequence[builtins.str]] = None,
                 node_type_data: Optional[builtins.str] = None,
                 node_type_ingest: Optional[builtins.str] = None,
                 node_type_master: Optional[builtins.str] = None,
                 node_type_ml: Optional[builtins.str] = None,
                 size: Optional[builtins.str] = None,
                 size_resource: Optional[builtins.str] = None,
                 zone_count: Optional[builtins.int] = None):
        """
        :param 'DeploymentElasticsearchMasterAutoscalingArgs' autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param builtins.str instance_configuration_id: Instance Configuration ID of the topology element
        :param builtins.int instance_configuration_version: Instance Configuration version of the topology element
        :param builtins.str latest_instance_configuration_id: Latest Instance Configuration ID available on the deployment template for the topology element
        :param builtins.int latest_instance_configuration_version: Latest version available for the Instance Configuration with the latest*instance*configuration_id
        :param Sequence[builtins.str] node_roles: The computed list of node roles for the current topology element
        :param builtins.str node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param builtins.str node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param builtins.str node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param builtins.str node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param builtins.str size: Amount of "size_resource" per node in the "\\n\\ng" notation
        :param builtins.str size_resource: Size type, defaults to "memory".
        :param builtins.int zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_configuration_version is not None:
            pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        if latest_instance_configuration_id is not None:
            pulumi.set(__self__, "latest_instance_configuration_id", latest_instance_configuration_id)
        if latest_instance_configuration_version is not None:
            pulumi.set(__self__, "latest_instance_configuration_version", latest_instance_configuration_version)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.DeploymentElasticsearchMasterAutoscaling':
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Instance Configuration version of the topology element
        """
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="latestInstanceConfigurationId")
    def latest_instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Latest Instance Configuration ID available on the deployment template for the topology element
        """
        return pulumi.get(self, "latest_instance_configuration_id")

    @property
    @pulumi.getter(name="latestInstanceConfigurationVersion")
    def latest_instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Latest version available for the Instance Configuration with the latest*instance*configuration_id
        """
        return pulumi.get(self, "latest_instance_configuration_version")

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[Sequence[builtins.str]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        """
        Amount of "size_resource" per node in the "\\n\\ng" notation
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[builtins.str]:
        """
        Size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[builtins.int]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class DeploymentElasticsearchMasterAutoscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSize":
            suggest = "max_size"
        elif key == "maxSizeResource":
            suggest = "max_size_resource"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "minSizeResource":
            suggest = "min_size_resource"
        elif key == "policyOverrideJson":
            suggest = "policy_override_json"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchMasterAutoscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchMasterAutoscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchMasterAutoscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale: Optional[builtins.bool] = None,
                 max_size: Optional[builtins.str] = None,
                 max_size_resource: Optional[builtins.str] = None,
                 min_size: Optional[builtins.str] = None,
                 min_size_resource: Optional[builtins.str] = None,
                 policy_override_json: Optional[builtins.str] = None):
        """
        :param builtins.bool autoscale: Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        :param builtins.str max_size: Maximum size value for the maximum autoscaling setting.
        :param builtins.str max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param builtins.str min_size: Minimum size value for the minimum autoscaling setting.
        :param builtins.str min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param builtins.str policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter
    def autoscale(self) -> Optional[builtins.bool]:
        """
        Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        """
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.str]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[builtins.str]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.str]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[builtins.str]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[builtins.str]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")


@pulumi.output_type
class DeploymentElasticsearchMl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceConfigurationId":
            suggest = "instance_configuration_id"
        elif key == "instanceConfigurationVersion":
            suggest = "instance_configuration_version"
        elif key == "latestInstanceConfigurationId":
            suggest = "latest_instance_configuration_id"
        elif key == "latestInstanceConfigurationVersion":
            suggest = "latest_instance_configuration_version"
        elif key == "nodeRoles":
            suggest = "node_roles"
        elif key == "nodeTypeData":
            suggest = "node_type_data"
        elif key == "nodeTypeIngest":
            suggest = "node_type_ingest"
        elif key == "nodeTypeMaster":
            suggest = "node_type_master"
        elif key == "nodeTypeMl":
            suggest = "node_type_ml"
        elif key == "sizeResource":
            suggest = "size_resource"
        elif key == "zoneCount":
            suggest = "zone_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchMl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchMl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchMl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling: 'outputs.DeploymentElasticsearchMlAutoscaling',
                 instance_configuration_id: Optional[builtins.str] = None,
                 instance_configuration_version: Optional[builtins.int] = None,
                 latest_instance_configuration_id: Optional[builtins.str] = None,
                 latest_instance_configuration_version: Optional[builtins.int] = None,
                 node_roles: Optional[Sequence[builtins.str]] = None,
                 node_type_data: Optional[builtins.str] = None,
                 node_type_ingest: Optional[builtins.str] = None,
                 node_type_master: Optional[builtins.str] = None,
                 node_type_ml: Optional[builtins.str] = None,
                 size: Optional[builtins.str] = None,
                 size_resource: Optional[builtins.str] = None,
                 zone_count: Optional[builtins.int] = None):
        """
        :param 'DeploymentElasticsearchMlAutoscalingArgs' autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param builtins.str instance_configuration_id: Instance Configuration ID of the topology element
        :param builtins.int instance_configuration_version: Instance Configuration version of the topology element
        :param builtins.str latest_instance_configuration_id: Latest Instance Configuration ID available on the deployment template for the topology element
        :param builtins.int latest_instance_configuration_version: Latest version available for the Instance Configuration with the latest*instance*configuration_id
        :param Sequence[builtins.str] node_roles: The computed list of node roles for the current topology element
        :param builtins.str node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param builtins.str node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param builtins.str node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param builtins.str node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param builtins.str size: Amount of "size_resource" per node in the "\\n\\ng" notation
        :param builtins.str size_resource: Size type, defaults to "memory".
        :param builtins.int zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_configuration_version is not None:
            pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        if latest_instance_configuration_id is not None:
            pulumi.set(__self__, "latest_instance_configuration_id", latest_instance_configuration_id)
        if latest_instance_configuration_version is not None:
            pulumi.set(__self__, "latest_instance_configuration_version", latest_instance_configuration_version)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.DeploymentElasticsearchMlAutoscaling':
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Instance Configuration version of the topology element
        """
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="latestInstanceConfigurationId")
    def latest_instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Latest Instance Configuration ID available on the deployment template for the topology element
        """
        return pulumi.get(self, "latest_instance_configuration_id")

    @property
    @pulumi.getter(name="latestInstanceConfigurationVersion")
    def latest_instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Latest version available for the Instance Configuration with the latest*instance*configuration_id
        """
        return pulumi.get(self, "latest_instance_configuration_version")

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[Sequence[builtins.str]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        """
        Amount of "size_resource" per node in the "\\n\\ng" notation
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[builtins.str]:
        """
        Size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[builtins.int]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class DeploymentElasticsearchMlAutoscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSize":
            suggest = "max_size"
        elif key == "maxSizeResource":
            suggest = "max_size_resource"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "minSizeResource":
            suggest = "min_size_resource"
        elif key == "policyOverrideJson":
            suggest = "policy_override_json"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchMlAutoscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchMlAutoscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchMlAutoscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale: Optional[builtins.bool] = None,
                 max_size: Optional[builtins.str] = None,
                 max_size_resource: Optional[builtins.str] = None,
                 min_size: Optional[builtins.str] = None,
                 min_size_resource: Optional[builtins.str] = None,
                 policy_override_json: Optional[builtins.str] = None):
        """
        :param builtins.bool autoscale: Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        :param builtins.str max_size: Maximum size value for the maximum autoscaling setting.
        :param builtins.str max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param builtins.str min_size: Minimum size value for the minimum autoscaling setting.
        :param builtins.str min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param builtins.str policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter
    def autoscale(self) -> Optional[builtins.bool]:
        """
        Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        """
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.str]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[builtins.str]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.str]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[builtins.str]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[builtins.str]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")


@pulumi.output_type
class DeploymentElasticsearchRemoteCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentId":
            suggest = "deployment_id"
        elif key == "refId":
            suggest = "ref_id"
        elif key == "skipUnavailable":
            suggest = "skip_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchRemoteCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchRemoteCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchRemoteCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 alias: builtins.str,
                 deployment_id: builtins.str,
                 ref_id: Optional[builtins.str] = None,
                 skip_unavailable: Optional[builtins.bool] = None):
        """
        :param builtins.str alias: Alias for this Cross Cluster Search binding
        :param builtins.str deployment_id: Remote deployment ID
        :param builtins.str ref_id: Remote elasticsearch "ref_id", it is best left to the default value
        :param builtins.bool skip_unavailable: If true, skip the cluster during search when disconnected
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "deployment_id", deployment_id)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)
        if skip_unavailable is not None:
            pulumi.set(__self__, "skip_unavailable", skip_unavailable)

    @property
    @pulumi.getter
    def alias(self) -> builtins.str:
        """
        Alias for this Cross Cluster Search binding
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> builtins.str:
        """
        Remote deployment ID
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[builtins.str]:
        """
        Remote elasticsearch "ref_id", it is best left to the default value
        """
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter(name="skipUnavailable")
    def skip_unavailable(self) -> Optional[builtins.bool]:
        """
        If true, skip the cluster during search when disconnected
        """
        return pulumi.get(self, "skip_unavailable")


@pulumi.output_type
class DeploymentElasticsearchSnapshot(dict):
    def __init__(__self__, *,
                 enabled: builtins.bool,
                 repository: Optional['outputs.DeploymentElasticsearchSnapshotRepository'] = None):
        """
        :param builtins.bool enabled: Indicates if Snapshotting is enabled.
        :param 'DeploymentElasticsearchSnapshotRepositoryArgs' repository: Snapshot repository configuration
        """
        pulumi.set(__self__, "enabled", enabled)
        if repository is not None:
            pulumi.set(__self__, "repository", repository)

    @property
    @pulumi.getter
    def enabled(self) -> builtins.bool:
        """
        Indicates if Snapshotting is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def repository(self) -> Optional['outputs.DeploymentElasticsearchSnapshotRepository']:
        """
        Snapshot repository configuration
        """
        return pulumi.get(self, "repository")


@pulumi.output_type
class DeploymentElasticsearchSnapshotRepository(dict):
    def __init__(__self__, *,
                 reference: Optional['outputs.DeploymentElasticsearchSnapshotRepositoryReference'] = None):
        """
        :param 'DeploymentElasticsearchSnapshotRepositoryReferenceArgs' reference: Cluster snapshot reference repository settings, containing the repository name in ECE fashion
        """
        if reference is not None:
            pulumi.set(__self__, "reference", reference)

    @property
    @pulumi.getter
    def reference(self) -> Optional['outputs.DeploymentElasticsearchSnapshotRepositoryReference']:
        """
        Cluster snapshot reference repository settings, containing the repository name in ECE fashion
        """
        return pulumi.get(self, "reference")


@pulumi.output_type
class DeploymentElasticsearchSnapshotRepositoryReference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repositoryName":
            suggest = "repository_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchSnapshotRepositoryReference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchSnapshotRepositoryReference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchSnapshotRepositoryReference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 repository_name: builtins.str):
        """
        :param builtins.str repository_name: ECE snapshot repository name, from the '/platform/configuration/snapshots/repositories' endpoint
        """
        pulumi.set(__self__, "repository_name", repository_name)

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> builtins.str:
        """
        ECE snapshot repository name, from the '/platform/configuration/snapshots/repositories' endpoint
        """
        return pulumi.get(self, "repository_name")


@pulumi.output_type
class DeploymentElasticsearchSnapshotSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceElasticsearchClusterId":
            suggest = "source_elasticsearch_cluster_id"
        elif key == "snapshotName":
            suggest = "snapshot_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchSnapshotSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchSnapshotSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchSnapshotSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_elasticsearch_cluster_id: builtins.str,
                 snapshot_name: Optional[builtins.str] = None):
        """
        :param builtins.str source_elasticsearch_cluster_id: ID of the Elasticsearch cluster that will be used as the source of the snapshot
        :param builtins.str snapshot_name: Name of the snapshot to restore. Use '**latest_success**' to get the most recent successful snapshot.
        """
        pulumi.set(__self__, "source_elasticsearch_cluster_id", source_elasticsearch_cluster_id)
        if snapshot_name is not None:
            pulumi.set(__self__, "snapshot_name", snapshot_name)

    @property
    @pulumi.getter(name="sourceElasticsearchClusterId")
    def source_elasticsearch_cluster_id(self) -> builtins.str:
        """
        ID of the Elasticsearch cluster that will be used as the source of the snapshot
        """
        return pulumi.get(self, "source_elasticsearch_cluster_id")

    @property
    @pulumi.getter(name="snapshotName")
    def snapshot_name(self) -> Optional[builtins.str]:
        """
        Name of the snapshot to restore. Use '**latest_success**' to get the most recent successful snapshot.
        """
        return pulumi.get(self, "snapshot_name")


@pulumi.output_type
class DeploymentElasticsearchTrustAccount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "trustAll":
            suggest = "trust_all"
        elif key == "trustAllowlists":
            suggest = "trust_allowlists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchTrustAccount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchTrustAccount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchTrustAccount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_id: builtins.str,
                 trust_all: builtins.bool,
                 trust_allowlists: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str account_id: The ID of the Account.
        :param builtins.bool trust_all: If true, all clusters in this account will by default be trusted and the `trust_allowlist` is ignored.
        :param Sequence[builtins.str] trust_allowlists: The list of clusters to trust. Only used when `trust_all` is false.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "trust_all", trust_all)
        if trust_allowlists is not None:
            pulumi.set(__self__, "trust_allowlists", trust_allowlists)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> builtins.str:
        """
        The ID of the Account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="trustAll")
    def trust_all(self) -> builtins.bool:
        """
        If true, all clusters in this account will by default be trusted and the `trust_allowlist` is ignored.
        """
        return pulumi.get(self, "trust_all")

    @property
    @pulumi.getter(name="trustAllowlists")
    def trust_allowlists(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of clusters to trust. Only used when `trust_all` is false.
        """
        return pulumi.get(self, "trust_allowlists")


@pulumi.output_type
class DeploymentElasticsearchTrustExternal(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "relationshipId":
            suggest = "relationship_id"
        elif key == "trustAll":
            suggest = "trust_all"
        elif key == "trustAllowlists":
            suggest = "trust_allowlists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchTrustExternal. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchTrustExternal.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchTrustExternal.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 relationship_id: builtins.str,
                 trust_all: builtins.bool,
                 trust_allowlists: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str relationship_id: The ID of the external trust relationship.
        :param builtins.bool trust_all: If true, all clusters in this account will by default be trusted and the `trust_allowlist` is ignored.
        :param Sequence[builtins.str] trust_allowlists: The list of clusters to trust. Only used when `trust_all` is false.
        """
        pulumi.set(__self__, "relationship_id", relationship_id)
        pulumi.set(__self__, "trust_all", trust_all)
        if trust_allowlists is not None:
            pulumi.set(__self__, "trust_allowlists", trust_allowlists)

    @property
    @pulumi.getter(name="relationshipId")
    def relationship_id(self) -> builtins.str:
        """
        The ID of the external trust relationship.
        """
        return pulumi.get(self, "relationship_id")

    @property
    @pulumi.getter(name="trustAll")
    def trust_all(self) -> builtins.bool:
        """
        If true, all clusters in this account will by default be trusted and the `trust_allowlist` is ignored.
        """
        return pulumi.get(self, "trust_all")

    @property
    @pulumi.getter(name="trustAllowlists")
    def trust_allowlists(self) -> Optional[Sequence[builtins.str]]:
        """
        The list of clusters to trust. Only used when `trust_all` is false.
        """
        return pulumi.get(self, "trust_allowlists")


@pulumi.output_type
class DeploymentElasticsearchWarm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceConfigurationId":
            suggest = "instance_configuration_id"
        elif key == "instanceConfigurationVersion":
            suggest = "instance_configuration_version"
        elif key == "latestInstanceConfigurationId":
            suggest = "latest_instance_configuration_id"
        elif key == "latestInstanceConfigurationVersion":
            suggest = "latest_instance_configuration_version"
        elif key == "nodeRoles":
            suggest = "node_roles"
        elif key == "nodeTypeData":
            suggest = "node_type_data"
        elif key == "nodeTypeIngest":
            suggest = "node_type_ingest"
        elif key == "nodeTypeMaster":
            suggest = "node_type_master"
        elif key == "nodeTypeMl":
            suggest = "node_type_ml"
        elif key == "sizeResource":
            suggest = "size_resource"
        elif key == "zoneCount":
            suggest = "zone_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchWarm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchWarm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchWarm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling: 'outputs.DeploymentElasticsearchWarmAutoscaling',
                 instance_configuration_id: Optional[builtins.str] = None,
                 instance_configuration_version: Optional[builtins.int] = None,
                 latest_instance_configuration_id: Optional[builtins.str] = None,
                 latest_instance_configuration_version: Optional[builtins.int] = None,
                 node_roles: Optional[Sequence[builtins.str]] = None,
                 node_type_data: Optional[builtins.str] = None,
                 node_type_ingest: Optional[builtins.str] = None,
                 node_type_master: Optional[builtins.str] = None,
                 node_type_ml: Optional[builtins.str] = None,
                 size: Optional[builtins.str] = None,
                 size_resource: Optional[builtins.str] = None,
                 zone_count: Optional[builtins.int] = None):
        """
        :param 'DeploymentElasticsearchWarmAutoscalingArgs' autoscaling: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param builtins.str instance_configuration_id: Instance Configuration ID of the topology element
        :param builtins.int instance_configuration_version: Instance Configuration version of the topology element
        :param builtins.str latest_instance_configuration_id: Latest Instance Configuration ID available on the deployment template for the topology element
        :param builtins.int latest_instance_configuration_version: Latest version available for the Instance Configuration with the latest*instance*configuration_id
        :param Sequence[builtins.str] node_roles: The computed list of node roles for the current topology element
        :param builtins.str node_type_data: The node type for the Elasticsearch Topology element (data node)
        :param builtins.str node_type_ingest: The node type for the Elasticsearch Topology element (ingest node)
        :param builtins.str node_type_master: The node type for the Elasticsearch Topology element (master node)
        :param builtins.str node_type_ml: The node type for the Elasticsearch Topology element (machine learning node)
        :param builtins.str size: Amount of "size_resource" per node in the "\\n\\ng" notation
        :param builtins.str size_resource: Size type, defaults to "memory".
        :param builtins.int zone_count: Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        pulumi.set(__self__, "autoscaling", autoscaling)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_configuration_version is not None:
            pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        if latest_instance_configuration_id is not None:
            pulumi.set(__self__, "latest_instance_configuration_id", latest_instance_configuration_id)
        if latest_instance_configuration_version is not None:
            pulumi.set(__self__, "latest_instance_configuration_version", latest_instance_configuration_version)
        if node_roles is not None:
            pulumi.set(__self__, "node_roles", node_roles)
        if node_type_data is not None:
            pulumi.set(__self__, "node_type_data", node_type_data)
        if node_type_ingest is not None:
            pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        if node_type_master is not None:
            pulumi.set(__self__, "node_type_master", node_type_master)
        if node_type_ml is not None:
            pulumi.set(__self__, "node_type_ml", node_type_ml)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.DeploymentElasticsearchWarmAutoscaling':
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Instance Configuration ID of the topology element
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Instance Configuration version of the topology element
        """
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="latestInstanceConfigurationId")
    def latest_instance_configuration_id(self) -> Optional[builtins.str]:
        """
        Latest Instance Configuration ID available on the deployment template for the topology element
        """
        return pulumi.get(self, "latest_instance_configuration_id")

    @property
    @pulumi.getter(name="latestInstanceConfigurationVersion")
    def latest_instance_configuration_version(self) -> Optional[builtins.int]:
        """
        Latest version available for the Instance Configuration with the latest*instance*configuration_id
        """
        return pulumi.get(self, "latest_instance_configuration_version")

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Optional[Sequence[builtins.str]]:
        """
        The computed list of node roles for the current topology element
        """
        return pulumi.get(self, "node_roles")

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (data node)
        """
        return pulumi.get(self, "node_type_data")

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (ingest node)
        """
        return pulumi.get(self, "node_type_ingest")

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (master node)
        """
        return pulumi.get(self, "node_type_master")

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> Optional[builtins.str]:
        """
        The node type for the Elasticsearch Topology element (machine learning node)
        """
        return pulumi.get(self, "node_type_ml")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        """
        Amount of "size_resource" per node in the "\\n\\ng" notation
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[builtins.str]:
        """
        Size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[builtins.int]:
        """
        Number of zones that the Elasticsearch cluster will span. This is used to set HA
        """
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class DeploymentElasticsearchWarmAutoscaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxSize":
            suggest = "max_size"
        elif key == "maxSizeResource":
            suggest = "max_size_resource"
        elif key == "minSize":
            suggest = "min_size"
        elif key == "minSizeResource":
            suggest = "min_size_resource"
        elif key == "policyOverrideJson":
            suggest = "policy_override_json"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentElasticsearchWarmAutoscaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentElasticsearchWarmAutoscaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentElasticsearchWarmAutoscaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscale: Optional[builtins.bool] = None,
                 max_size: Optional[builtins.str] = None,
                 max_size_resource: Optional[builtins.str] = None,
                 min_size: Optional[builtins.str] = None,
                 min_size_resource: Optional[builtins.str] = None,
                 policy_override_json: Optional[builtins.str] = None):
        """
        :param builtins.bool autoscale: Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        :param builtins.str max_size: Maximum size value for the maximum autoscaling setting.
        :param builtins.str max_size_resource: Maximum resource type for the maximum autoscaling setting.
        :param builtins.str min_size: Minimum size value for the minimum autoscaling setting.
        :param builtins.str min_size_resource: Minimum resource type for the minimum autoscaling setting.
        :param builtins.str policy_override_json: Computed policy overrides set directly via the API or other clients.
        """
        if autoscale is not None:
            pulumi.set(__self__, "autoscale", autoscale)
        if max_size is not None:
            pulumi.set(__self__, "max_size", max_size)
        if max_size_resource is not None:
            pulumi.set(__self__, "max_size_resource", max_size_resource)
        if min_size is not None:
            pulumi.set(__self__, "min_size", min_size)
        if min_size_resource is not None:
            pulumi.set(__self__, "min_size_resource", min_size_resource)
        if policy_override_json is not None:
            pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter
    def autoscale(self) -> Optional[builtins.bool]:
        """
        Whether this specific tier should be auto-scaled, overrides deployment-wide setting. Allowed for `ml` tier only.
        """
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> Optional[builtins.str]:
        """
        Maximum size value for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> Optional[builtins.str]:
        """
        Maximum resource type for the maximum autoscaling setting.
        """
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> Optional[builtins.str]:
        """
        Minimum size value for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> Optional[builtins.str]:
        """
        Minimum resource type for the minimum autoscaling setting.
        """
        return pulumi.get(self, "min_size_resource")

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> Optional[builtins.str]:
        """
        Computed policy overrides set directly via the API or other clients.
        """
        return pulumi.get(self, "policy_override_json")


@pulumi.output_type
class DeploymentEnterpriseSearch(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elasticsearchClusterRefId":
            suggest = "elasticsearch_cluster_ref_id"
        elif key == "httpEndpoint":
            suggest = "http_endpoint"
        elif key == "httpsEndpoint":
            suggest = "https_endpoint"
        elif key == "instanceConfigurationId":
            suggest = "instance_configuration_id"
        elif key == "instanceConfigurationVersion":
            suggest = "instance_configuration_version"
        elif key == "latestInstanceConfigurationId":
            suggest = "latest_instance_configuration_id"
        elif key == "latestInstanceConfigurationVersion":
            suggest = "latest_instance_configuration_version"
        elif key == "nodeTypeAppserver":
            suggest = "node_type_appserver"
        elif key == "nodeTypeConnector":
            suggest = "node_type_connector"
        elif key == "nodeTypeWorker":
            suggest = "node_type_worker"
        elif key == "refId":
            suggest = "ref_id"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "sizeResource":
            suggest = "size_resource"
        elif key == "zoneCount":
            suggest = "zone_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentEnterpriseSearch. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentEnterpriseSearch.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentEnterpriseSearch.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: Optional['outputs.DeploymentEnterpriseSearchConfig'] = None,
                 elasticsearch_cluster_ref_id: Optional[builtins.str] = None,
                 http_endpoint: Optional[builtins.str] = None,
                 https_endpoint: Optional[builtins.str] = None,
                 instance_configuration_id: Optional[builtins.str] = None,
                 instance_configuration_version: Optional[builtins.int] = None,
                 latest_instance_configuration_id: Optional[builtins.str] = None,
                 latest_instance_configuration_version: Optional[builtins.int] = None,
                 node_type_appserver: Optional[builtins.bool] = None,
                 node_type_connector: Optional[builtins.bool] = None,
                 node_type_worker: Optional[builtins.bool] = None,
                 ref_id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 resource_id: Optional[builtins.str] = None,
                 size: Optional[builtins.str] = None,
                 size_resource: Optional[builtins.str] = None,
                 zone_count: Optional[builtins.int] = None):
        """
        :param 'DeploymentEnterpriseSearchConfigArgs' config: Optionally define the Enterprise Search configuration options for the Enterprise Search Server
        :param builtins.str size_resource: Optional size type, defaults to "memory".
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if elasticsearch_cluster_ref_id is not None:
            pulumi.set(__self__, "elasticsearch_cluster_ref_id", elasticsearch_cluster_ref_id)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_configuration_version is not None:
            pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        if latest_instance_configuration_id is not None:
            pulumi.set(__self__, "latest_instance_configuration_id", latest_instance_configuration_id)
        if latest_instance_configuration_version is not None:
            pulumi.set(__self__, "latest_instance_configuration_version", latest_instance_configuration_version)
        if node_type_appserver is not None:
            pulumi.set(__self__, "node_type_appserver", node_type_appserver)
        if node_type_connector is not None:
            pulumi.set(__self__, "node_type_connector", node_type_connector)
        if node_type_worker is not None:
            pulumi.set(__self__, "node_type_worker", node_type_worker)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def config(self) -> Optional['outputs.DeploymentEnterpriseSearchConfig']:
        """
        Optionally define the Enterprise Search configuration options for the Enterprise Search Server
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="elasticsearchClusterRefId")
    def elasticsearch_cluster_ref_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "elasticsearch_cluster_ref_id")

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "http_endpoint")

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "https_endpoint")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> Optional[builtins.int]:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="latestInstanceConfigurationId")
    def latest_instance_configuration_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "latest_instance_configuration_id")

    @property
    @pulumi.getter(name="latestInstanceConfigurationVersion")
    def latest_instance_configuration_version(self) -> Optional[builtins.int]:
        return pulumi.get(self, "latest_instance_configuration_version")

    @property
    @pulumi.getter(name="nodeTypeAppserver")
    def node_type_appserver(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "node_type_appserver")

    @property
    @pulumi.getter(name="nodeTypeConnector")
    def node_type_connector(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "node_type_connector")

    @property
    @pulumi.getter(name="nodeTypeWorker")
    def node_type_worker(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "node_type_worker")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[builtins.str]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[builtins.int]:
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class DeploymentEnterpriseSearchConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerImage":
            suggest = "docker_image"
        elif key == "userSettingsJson":
            suggest = "user_settings_json"
        elif key == "userSettingsOverrideJson":
            suggest = "user_settings_override_json"
        elif key == "userSettingsOverrideYaml":
            suggest = "user_settings_override_yaml"
        elif key == "userSettingsYaml":
            suggest = "user_settings_yaml"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentEnterpriseSearchConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentEnterpriseSearchConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentEnterpriseSearchConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 docker_image: Optional[builtins.str] = None,
                 user_settings_json: Optional[builtins.str] = None,
                 user_settings_override_json: Optional[builtins.str] = None,
                 user_settings_override_yaml: Optional[builtins.str] = None,
                 user_settings_yaml: Optional[builtins.str] = None):
        """
        :param builtins.str docker_image: Optionally override the docker image the Enterprise Search nodes will use. Note that this field will only work for internal users only.
        :param builtins.str user_settings_json: An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        :param builtins.str user_settings_override_json: An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param builtins.str user_settings_override_yaml: An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param builtins.str user_settings_yaml: An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        if docker_image is not None:
            pulumi.set(__self__, "docker_image", docker_image)
        if user_settings_json is not None:
            pulumi.set(__self__, "user_settings_json", user_settings_json)
        if user_settings_override_json is not None:
            pulumi.set(__self__, "user_settings_override_json", user_settings_override_json)
        if user_settings_override_yaml is not None:
            pulumi.set(__self__, "user_settings_override_yaml", user_settings_override_yaml)
        if user_settings_yaml is not None:
            pulumi.set(__self__, "user_settings_yaml", user_settings_yaml)

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> Optional[builtins.str]:
        """
        Optionally override the docker image the Enterprise Search nodes will use. Note that this field will only work for internal users only.
        """
        return pulumi.get(self, "docker_image")

    @property
    @pulumi.getter(name="userSettingsJson")
    def user_settings_json(self) -> Optional[builtins.str]:
        """
        An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_json")

    @property
    @pulumi.getter(name="userSettingsOverrideJson")
    def user_settings_override_json(self) -> Optional[builtins.str]:
        """
        An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_json")

    @property
    @pulumi.getter(name="userSettingsOverrideYaml")
    def user_settings_override_yaml(self) -> Optional[builtins.str]:
        """
        An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_yaml")

    @property
    @pulumi.getter(name="userSettingsYaml")
    def user_settings_yaml(self) -> Optional[builtins.str]:
        """
        An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_yaml")


@pulumi.output_type
class DeploymentIntegrationsServer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elasticsearchClusterRefId":
            suggest = "elasticsearch_cluster_ref_id"
        elif key == "httpEndpoint":
            suggest = "http_endpoint"
        elif key == "httpsEndpoint":
            suggest = "https_endpoint"
        elif key == "instanceConfigurationId":
            suggest = "instance_configuration_id"
        elif key == "instanceConfigurationVersion":
            suggest = "instance_configuration_version"
        elif key == "latestInstanceConfigurationId":
            suggest = "latest_instance_configuration_id"
        elif key == "latestInstanceConfigurationVersion":
            suggest = "latest_instance_configuration_version"
        elif key == "refId":
            suggest = "ref_id"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "sizeResource":
            suggest = "size_resource"
        elif key == "zoneCount":
            suggest = "zone_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentIntegrationsServer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentIntegrationsServer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentIntegrationsServer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: Optional['outputs.DeploymentIntegrationsServerConfig'] = None,
                 elasticsearch_cluster_ref_id: Optional[builtins.str] = None,
                 endpoints: Optional['outputs.DeploymentIntegrationsServerEndpoints'] = None,
                 http_endpoint: Optional[builtins.str] = None,
                 https_endpoint: Optional[builtins.str] = None,
                 instance_configuration_id: Optional[builtins.str] = None,
                 instance_configuration_version: Optional[builtins.int] = None,
                 latest_instance_configuration_id: Optional[builtins.str] = None,
                 latest_instance_configuration_version: Optional[builtins.int] = None,
                 ref_id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 resource_id: Optional[builtins.str] = None,
                 size: Optional[builtins.str] = None,
                 size_resource: Optional[builtins.str] = None,
                 zone_count: Optional[builtins.int] = None):
        """
        :param 'DeploymentIntegrationsServerConfigArgs' config: Optionally define the Integrations Server configuration options for the IntegrationsServer Server
        :param 'DeploymentIntegrationsServerEndpointsArgs' endpoints: URLs for the accessing the Fleet and APM API's within this Integrations Server resource.
        :param builtins.str size_resource: Optional size type, defaults to "memory".
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if elasticsearch_cluster_ref_id is not None:
            pulumi.set(__self__, "elasticsearch_cluster_ref_id", elasticsearch_cluster_ref_id)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_configuration_version is not None:
            pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        if latest_instance_configuration_id is not None:
            pulumi.set(__self__, "latest_instance_configuration_id", latest_instance_configuration_id)
        if latest_instance_configuration_version is not None:
            pulumi.set(__self__, "latest_instance_configuration_version", latest_instance_configuration_version)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def config(self) -> Optional['outputs.DeploymentIntegrationsServerConfig']:
        """
        Optionally define the Integrations Server configuration options for the IntegrationsServer Server
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="elasticsearchClusterRefId")
    def elasticsearch_cluster_ref_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "elasticsearch_cluster_ref_id")

    @property
    @pulumi.getter
    def endpoints(self) -> Optional['outputs.DeploymentIntegrationsServerEndpoints']:
        """
        URLs for the accessing the Fleet and APM API's within this Integrations Server resource.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "http_endpoint")

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "https_endpoint")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> Optional[builtins.int]:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="latestInstanceConfigurationId")
    def latest_instance_configuration_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "latest_instance_configuration_id")

    @property
    @pulumi.getter(name="latestInstanceConfigurationVersion")
    def latest_instance_configuration_version(self) -> Optional[builtins.int]:
        return pulumi.get(self, "latest_instance_configuration_version")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[builtins.str]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[builtins.int]:
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class DeploymentIntegrationsServerConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "debugEnabled":
            suggest = "debug_enabled"
        elif key == "dockerImage":
            suggest = "docker_image"
        elif key == "userSettingsJson":
            suggest = "user_settings_json"
        elif key == "userSettingsOverrideJson":
            suggest = "user_settings_override_json"
        elif key == "userSettingsOverrideYaml":
            suggest = "user_settings_override_yaml"
        elif key == "userSettingsYaml":
            suggest = "user_settings_yaml"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentIntegrationsServerConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentIntegrationsServerConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentIntegrationsServerConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 debug_enabled: Optional[builtins.bool] = None,
                 docker_image: Optional[builtins.str] = None,
                 user_settings_json: Optional[builtins.str] = None,
                 user_settings_override_json: Optional[builtins.str] = None,
                 user_settings_override_yaml: Optional[builtins.str] = None,
                 user_settings_yaml: Optional[builtins.str] = None):
        """
        :param builtins.bool debug_enabled: Optionally enable debug mode for Integrations Server instances - defaults to false
        :param builtins.str docker_image: Optionally override the docker image the Integrations Server nodes will use. Note that this field will only work for internal users only.
        :param builtins.str user_settings_json: An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        :param builtins.str user_settings_override_json: An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param builtins.str user_settings_override_yaml: An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param builtins.str user_settings_yaml: An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        if debug_enabled is not None:
            pulumi.set(__self__, "debug_enabled", debug_enabled)
        if docker_image is not None:
            pulumi.set(__self__, "docker_image", docker_image)
        if user_settings_json is not None:
            pulumi.set(__self__, "user_settings_json", user_settings_json)
        if user_settings_override_json is not None:
            pulumi.set(__self__, "user_settings_override_json", user_settings_override_json)
        if user_settings_override_yaml is not None:
            pulumi.set(__self__, "user_settings_override_yaml", user_settings_override_yaml)
        if user_settings_yaml is not None:
            pulumi.set(__self__, "user_settings_yaml", user_settings_yaml)

    @property
    @pulumi.getter(name="debugEnabled")
    def debug_enabled(self) -> Optional[builtins.bool]:
        """
        Optionally enable debug mode for Integrations Server instances - defaults to false
        """
        return pulumi.get(self, "debug_enabled")

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> Optional[builtins.str]:
        """
        Optionally override the docker image the Integrations Server nodes will use. Note that this field will only work for internal users only.
        """
        return pulumi.get(self, "docker_image")

    @property
    @pulumi.getter(name="userSettingsJson")
    def user_settings_json(self) -> Optional[builtins.str]:
        """
        An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_json")

    @property
    @pulumi.getter(name="userSettingsOverrideJson")
    def user_settings_override_json(self) -> Optional[builtins.str]:
        """
        An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_json")

    @property
    @pulumi.getter(name="userSettingsOverrideYaml")
    def user_settings_override_yaml(self) -> Optional[builtins.str]:
        """
        An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_yaml")

    @property
    @pulumi.getter(name="userSettingsYaml")
    def user_settings_yaml(self) -> Optional[builtins.str]:
        """
        An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_yaml")


@pulumi.output_type
class DeploymentIntegrationsServerEndpoints(dict):
    def __init__(__self__, *,
                 apm: builtins.str,
                 fleet: builtins.str,
                 profiling: builtins.str,
                 symbols: builtins.str):
        pulumi.set(__self__, "apm", apm)
        pulumi.set(__self__, "fleet", fleet)
        pulumi.set(__self__, "profiling", profiling)
        pulumi.set(__self__, "symbols", symbols)

    @property
    @pulumi.getter
    def apm(self) -> builtins.str:
        return pulumi.get(self, "apm")

    @property
    @pulumi.getter
    def fleet(self) -> builtins.str:
        return pulumi.get(self, "fleet")

    @property
    @pulumi.getter
    def profiling(self) -> builtins.str:
        return pulumi.get(self, "profiling")

    @property
    @pulumi.getter
    def symbols(self) -> builtins.str:
        return pulumi.get(self, "symbols")


@pulumi.output_type
class DeploymentKibana(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "elasticsearchClusterRefId":
            suggest = "elasticsearch_cluster_ref_id"
        elif key == "httpEndpoint":
            suggest = "http_endpoint"
        elif key == "httpsEndpoint":
            suggest = "https_endpoint"
        elif key == "instanceConfigurationId":
            suggest = "instance_configuration_id"
        elif key == "instanceConfigurationVersion":
            suggest = "instance_configuration_version"
        elif key == "latestInstanceConfigurationId":
            suggest = "latest_instance_configuration_id"
        elif key == "latestInstanceConfigurationVersion":
            suggest = "latest_instance_configuration_version"
        elif key == "refId":
            suggest = "ref_id"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "sizeResource":
            suggest = "size_resource"
        elif key == "zoneCount":
            suggest = "zone_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentKibana. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentKibana.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentKibana.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 config: Optional['outputs.DeploymentKibanaConfig'] = None,
                 elasticsearch_cluster_ref_id: Optional[builtins.str] = None,
                 http_endpoint: Optional[builtins.str] = None,
                 https_endpoint: Optional[builtins.str] = None,
                 instance_configuration_id: Optional[builtins.str] = None,
                 instance_configuration_version: Optional[builtins.int] = None,
                 latest_instance_configuration_id: Optional[builtins.str] = None,
                 latest_instance_configuration_version: Optional[builtins.int] = None,
                 ref_id: Optional[builtins.str] = None,
                 region: Optional[builtins.str] = None,
                 resource_id: Optional[builtins.str] = None,
                 size: Optional[builtins.str] = None,
                 size_resource: Optional[builtins.str] = None,
                 zone_count: Optional[builtins.int] = None):
        """
        :param 'DeploymentKibanaConfigArgs' config: Optionally define the Kibana configuration options for the Kibana Server
        :param builtins.str size_resource: Optional size type, defaults to "memory".
        """
        if config is not None:
            pulumi.set(__self__, "config", config)
        if elasticsearch_cluster_ref_id is not None:
            pulumi.set(__self__, "elasticsearch_cluster_ref_id", elasticsearch_cluster_ref_id)
        if http_endpoint is not None:
            pulumi.set(__self__, "http_endpoint", http_endpoint)
        if https_endpoint is not None:
            pulumi.set(__self__, "https_endpoint", https_endpoint)
        if instance_configuration_id is not None:
            pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        if instance_configuration_version is not None:
            pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        if latest_instance_configuration_id is not None:
            pulumi.set(__self__, "latest_instance_configuration_id", latest_instance_configuration_id)
        if latest_instance_configuration_version is not None:
            pulumi.set(__self__, "latest_instance_configuration_version", latest_instance_configuration_version)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if size_resource is not None:
            pulumi.set(__self__, "size_resource", size_resource)
        if zone_count is not None:
            pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def config(self) -> Optional['outputs.DeploymentKibanaConfig']:
        """
        Optionally define the Kibana configuration options for the Kibana Server
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="elasticsearchClusterRefId")
    def elasticsearch_cluster_ref_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "elasticsearch_cluster_ref_id")

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "http_endpoint")

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> Optional[builtins.str]:
        return pulumi.get(self, "https_endpoint")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> Optional[builtins.int]:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="latestInstanceConfigurationId")
    def latest_instance_configuration_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "latest_instance_configuration_id")

    @property
    @pulumi.getter(name="latestInstanceConfigurationVersion")
    def latest_instance_configuration_version(self) -> Optional[builtins.int]:
        return pulumi.get(self, "latest_instance_configuration_version")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def size(self) -> Optional[builtins.str]:
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> Optional[builtins.str]:
        """
        Optional size type, defaults to "memory".
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> Optional[builtins.int]:
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class DeploymentKibanaConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dockerImage":
            suggest = "docker_image"
        elif key == "userSettingsJson":
            suggest = "user_settings_json"
        elif key == "userSettingsOverrideJson":
            suggest = "user_settings_override_json"
        elif key == "userSettingsOverrideYaml":
            suggest = "user_settings_override_yaml"
        elif key == "userSettingsYaml":
            suggest = "user_settings_yaml"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentKibanaConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentKibanaConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentKibanaConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 docker_image: Optional[builtins.str] = None,
                 user_settings_json: Optional[builtins.str] = None,
                 user_settings_override_json: Optional[builtins.str] = None,
                 user_settings_override_yaml: Optional[builtins.str] = None,
                 user_settings_yaml: Optional[builtins.str] = None):
        """
        :param builtins.str docker_image: Optionally override the docker image the Kibana nodes will use. Note that this field will only work for internal users only.
        :param builtins.str user_settings_json: An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        :param builtins.str user_settings_override_json: An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param builtins.str user_settings_override_yaml: An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        :param builtins.str user_settings_yaml: An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        if docker_image is not None:
            pulumi.set(__self__, "docker_image", docker_image)
        if user_settings_json is not None:
            pulumi.set(__self__, "user_settings_json", user_settings_json)
        if user_settings_override_json is not None:
            pulumi.set(__self__, "user_settings_override_json", user_settings_override_json)
        if user_settings_override_yaml is not None:
            pulumi.set(__self__, "user_settings_override_yaml", user_settings_override_yaml)
        if user_settings_yaml is not None:
            pulumi.set(__self__, "user_settings_yaml", user_settings_yaml)

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> Optional[builtins.str]:
        """
        Optionally override the docker image the Kibana nodes will use. Note that this field will only work for internal users only.
        """
        return pulumi.get(self, "docker_image")

    @property
    @pulumi.getter(name="userSettingsJson")
    def user_settings_json(self) -> Optional[builtins.str]:
        """
        An arbitrary JSON object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*yaml' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (This field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_json")

    @property
    @pulumi.getter(name="userSettingsOverrideJson")
    def user_settings_override_json(self) -> Optional[builtins.str]:
        """
        An arbitrary JSON object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*yaml' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_json")

    @property
    @pulumi.getter(name="userSettingsOverrideYaml")
    def user_settings_override_yaml(self) -> Optional[builtins.str]:
        """
        An arbitrary YAML object allowing ECE admins owners to set clusters' parameters (only one of this and 'user*settings*override*json' is allowed), ie in addition to the documented 'system*settings'. (This field together with 'system*settings' and 'user*settings*' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_override_yaml")

    @property
    @pulumi.getter(name="userSettingsYaml")
    def user_settings_yaml(self) -> Optional[builtins.str]:
        """
        An arbitrary YAML object allowing (non-admin) cluster owners to set their parameters (only one of this and 'user*settings*json' is allowed), provided they are on the whitelist ('user*settings*whitelist') and not on the blacklist ('user*settings*blacklist'). (These field together with 'user*settings*override*' and 'system_settings' defines the total set of resource settings)
        """
        return pulumi.get(self, "user_settings_yaml")


@pulumi.output_type
class DeploymentObservability(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentId":
            suggest = "deployment_id"
        elif key == "refId":
            suggest = "ref_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentObservability. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentObservability.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentObservability.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_id: builtins.str,
                 logs: Optional[builtins.bool] = None,
                 metrics: Optional[builtins.bool] = None,
                 ref_id: Optional[builtins.str] = None):
        pulumi.set(__self__, "deployment_id", deployment_id)
        if logs is not None:
            pulumi.set(__self__, "logs", logs)
        if metrics is not None:
            pulumi.set(__self__, "metrics", metrics)
        if ref_id is not None:
            pulumi.set(__self__, "ref_id", ref_id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> builtins.str:
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def logs(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter
    def metrics(self) -> Optional[builtins.bool]:
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> Optional[builtins.str]:
        return pulumi.get(self, "ref_id")


@pulumi.output_type
class DeploymentTrafficFilterRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "azureEndpointGuid":
            suggest = "azure_endpoint_guid"
        elif key == "azureEndpointName":
            suggest = "azure_endpoint_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeploymentTrafficFilterRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeploymentTrafficFilterRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeploymentTrafficFilterRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 azure_endpoint_guid: Optional[builtins.str] = None,
                 azure_endpoint_name: Optional[builtins.str] = None,
                 description: Optional[builtins.str] = None,
                 id: Optional[builtins.str] = None,
                 source: Optional[builtins.str] = None):
        """
        :param builtins.str azure_endpoint_guid: Azure endpoint GUID. Only applicable when the ruleset type is set to `azure_private_endpoint`
        :param builtins.str azure_endpoint_name: Azure endpoint name. Only applicable when the ruleset type is set to `azure_private_endpoint`
        :param builtins.str description: Description of this individual rule
        :param builtins.str id: Computed rule ID
        :param builtins.str source: Traffic filter source: IP address, CIDR mask, or VPC endpoint ID, **only required** when the type is not `azure_private_endpoint`
        """
        if azure_endpoint_guid is not None:
            pulumi.set(__self__, "azure_endpoint_guid", azure_endpoint_guid)
        if azure_endpoint_name is not None:
            pulumi.set(__self__, "azure_endpoint_name", azure_endpoint_name)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter(name="azureEndpointGuid")
    def azure_endpoint_guid(self) -> Optional[builtins.str]:
        """
        Azure endpoint GUID. Only applicable when the ruleset type is set to `azure_private_endpoint`
        """
        return pulumi.get(self, "azure_endpoint_guid")

    @property
    @pulumi.getter(name="azureEndpointName")
    def azure_endpoint_name(self) -> Optional[builtins.str]:
        """
        Azure endpoint name. Only applicable when the ruleset type is set to `azure_private_endpoint`
        """
        return pulumi.get(self, "azure_endpoint_name")

    @property
    @pulumi.getter
    def description(self) -> Optional[builtins.str]:
        """
        Description of this individual rule
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> Optional[builtins.str]:
        """
        Computed rule ID
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def source(self) -> Optional[builtins.str]:
        """
        Traffic filter source: IP address, CIDR mask, or VPC endpoint ID, **only required** when the type is not `azure_private_endpoint`
        """
        return pulumi.get(self, "source")


@pulumi.output_type
class ElasticsearchProjectCredentials(dict):
    def __init__(__self__, *,
                 password: Optional[builtins.str] = None,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str password: Basic auth password that can be used to access the Elasticsearch API.
        :param builtins.str username: Basic auth username that can be used to access the Elasticsearch API.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        Basic auth password that can be used to access the Elasticsearch API.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        Basic auth username that can be used to access the Elasticsearch API.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ElasticsearchProjectEndpoints(dict):
    def __init__(__self__, *,
                 elasticsearch: Optional[builtins.str] = None,
                 kibana: Optional[builtins.str] = None):
        """
        :param builtins.str elasticsearch: The endpoint to access elasticsearch.
        :param builtins.str kibana: The endpoint to access kibana.
        """
        if elasticsearch is not None:
            pulumi.set(__self__, "elasticsearch", elasticsearch)
        if kibana is not None:
            pulumi.set(__self__, "kibana", kibana)

    @property
    @pulumi.getter
    def elasticsearch(self) -> Optional[builtins.str]:
        """
        The endpoint to access elasticsearch.
        """
        return pulumi.get(self, "elasticsearch")

    @property
    @pulumi.getter
    def kibana(self) -> Optional[builtins.str]:
        """
        The endpoint to access kibana.
        """
        return pulumi.get(self, "kibana")


@pulumi.output_type
class ElasticsearchProjectMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "organizationId":
            suggest = "organization_id"
        elif key == "suspendedAt":
            suggest = "suspended_at"
        elif key == "suspendedReason":
            suggest = "suspended_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElasticsearchProjectMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElasticsearchProjectMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElasticsearchProjectMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[builtins.str] = None,
                 created_by: Optional[builtins.str] = None,
                 organization_id: Optional[builtins.str] = None,
                 suspended_at: Optional[builtins.str] = None,
                 suspended_reason: Optional[builtins.str] = None):
        """
        :param builtins.str created_at: Date and time when the project was created.
        :param builtins.str created_by: ID of the user.
        :param builtins.str organization_id: The Organization ID who owns the project.
        :param builtins.str suspended_at: Date and time when the project was suspended.
        :param builtins.str suspended_reason: Reason why the project was suspended.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if suspended_at is not None:
            pulumi.set(__self__, "suspended_at", suspended_at)
        if suspended_reason is not None:
            pulumi.set(__self__, "suspended_reason", suspended_reason)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        Date and time when the project was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[builtins.str]:
        """
        ID of the user.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[builtins.str]:
        """
        The Organization ID who owns the project.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="suspendedAt")
    def suspended_at(self) -> Optional[builtins.str]:
        """
        Date and time when the project was suspended.
        """
        return pulumi.get(self, "suspended_at")

    @property
    @pulumi.getter(name="suspendedReason")
    def suspended_reason(self) -> Optional[builtins.str]:
        """
        Reason why the project was suspended.
        """
        return pulumi.get(self, "suspended_reason")


@pulumi.output_type
class ElasticsearchProjectSearchLake(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "boostWindow":
            suggest = "boost_window"
        elif key == "searchPower":
            suggest = "search_power"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ElasticsearchProjectSearchLake. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ElasticsearchProjectSearchLake.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ElasticsearchProjectSearchLake.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boost_window: Optional[builtins.int] = None,
                 search_power: Optional[builtins.int] = None):
        """
        :param builtins.int boost_window: Determines how much data can benefit from faster search. When ingested, a certain amount of data is loaded into a cache that makes it super fast to query. The system dynamically adjusts the cache allocated to your project based on how much data you ingest during the period defined by your Search Boost Window.
        :param builtins.int search_power: Controls how fast searches are against your project data. When ingested, a certain amount of data is loaded into a cache that makes it super fast to query. You can either increase the performance of searches on cached data by adding replicas, or reduce the quantity of cached data by a static factor to save on costs.
        """
        if boost_window is not None:
            pulumi.set(__self__, "boost_window", boost_window)
        if search_power is not None:
            pulumi.set(__self__, "search_power", search_power)

    @property
    @pulumi.getter(name="boostWindow")
    def boost_window(self) -> Optional[builtins.int]:
        """
        Determines how much data can benefit from faster search. When ingested, a certain amount of data is loaded into a cache that makes it super fast to query. The system dynamically adjusts the cache allocated to your project based on how much data you ingest during the period defined by your Search Boost Window.
        """
        return pulumi.get(self, "boost_window")

    @property
    @pulumi.getter(name="searchPower")
    def search_power(self) -> Optional[builtins.int]:
        """
        Controls how fast searches are against your project data. When ingested, a certain amount of data is loaded into a cache that makes it super fast to query. You can either increase the performance of searches on cached data by adding replicas, or reduce the quantity of cached data by a static factor to save on costs.
        """
        return pulumi.get(self, "search_power")


@pulumi.output_type
class ObservabilityProjectCredentials(dict):
    def __init__(__self__, *,
                 password: Optional[builtins.str] = None,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str password: Basic auth password that can be used to access the Elasticsearch API.
        :param builtins.str username: Basic auth username that can be used to access the Elasticsearch API.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        Basic auth password that can be used to access the Elasticsearch API.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        Basic auth username that can be used to access the Elasticsearch API.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ObservabilityProjectEndpoints(dict):
    def __init__(__self__, *,
                 apm: Optional[builtins.str] = None,
                 elasticsearch: Optional[builtins.str] = None,
                 kibana: Optional[builtins.str] = None):
        """
        :param builtins.str apm: The endpoint to access apm.
        :param builtins.str elasticsearch: The endpoint to access elasticsearch.
        :param builtins.str kibana: The endpoint to access kibana.
        """
        if apm is not None:
            pulumi.set(__self__, "apm", apm)
        if elasticsearch is not None:
            pulumi.set(__self__, "elasticsearch", elasticsearch)
        if kibana is not None:
            pulumi.set(__self__, "kibana", kibana)

    @property
    @pulumi.getter
    def apm(self) -> Optional[builtins.str]:
        """
        The endpoint to access apm.
        """
        return pulumi.get(self, "apm")

    @property
    @pulumi.getter
    def elasticsearch(self) -> Optional[builtins.str]:
        """
        The endpoint to access elasticsearch.
        """
        return pulumi.get(self, "elasticsearch")

    @property
    @pulumi.getter
    def kibana(self) -> Optional[builtins.str]:
        """
        The endpoint to access kibana.
        """
        return pulumi.get(self, "kibana")


@pulumi.output_type
class ObservabilityProjectMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "organizationId":
            suggest = "organization_id"
        elif key == "suspendedAt":
            suggest = "suspended_at"
        elif key == "suspendedReason":
            suggest = "suspended_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ObservabilityProjectMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ObservabilityProjectMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ObservabilityProjectMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[builtins.str] = None,
                 created_by: Optional[builtins.str] = None,
                 organization_id: Optional[builtins.str] = None,
                 suspended_at: Optional[builtins.str] = None,
                 suspended_reason: Optional[builtins.str] = None):
        """
        :param builtins.str created_at: Date and time when the project was created.
        :param builtins.str created_by: ID of the user.
        :param builtins.str organization_id: The Organization ID who owns the project.
        :param builtins.str suspended_at: Date and time when the project was suspended.
        :param builtins.str suspended_reason: Reason why the project was suspended.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if suspended_at is not None:
            pulumi.set(__self__, "suspended_at", suspended_at)
        if suspended_reason is not None:
            pulumi.set(__self__, "suspended_reason", suspended_reason)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        Date and time when the project was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[builtins.str]:
        """
        ID of the user.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[builtins.str]:
        """
        The Organization ID who owns the project.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="suspendedAt")
    def suspended_at(self) -> Optional[builtins.str]:
        """
        Date and time when the project was suspended.
        """
        return pulumi.get(self, "suspended_at")

    @property
    @pulumi.getter(name="suspendedReason")
    def suspended_reason(self) -> Optional[builtins.str]:
        """
        Reason why the project was suspended.
        """
        return pulumi.get(self, "suspended_reason")


@pulumi.output_type
class OrganizationMembers(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deploymentRoles":
            suggest = "deployment_roles"
        elif key == "invitationPending":
            suggest = "invitation_pending"
        elif key == "organizationRole":
            suggest = "organization_role"
        elif key == "projectElasticsearchRoles":
            suggest = "project_elasticsearch_roles"
        elif key == "projectObservabilityRoles":
            suggest = "project_observability_roles"
        elif key == "projectSecurityRoles":
            suggest = "project_security_roles"
        elif key == "userId":
            suggest = "user_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationMembers. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationMembers.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationMembers.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 deployment_roles: Optional[Sequence['outputs.OrganizationMembersDeploymentRole']] = None,
                 email: Optional[builtins.str] = None,
                 invitation_pending: Optional[builtins.bool] = None,
                 organization_role: Optional[builtins.str] = None,
                 project_elasticsearch_roles: Optional[Sequence['outputs.OrganizationMembersProjectElasticsearchRole']] = None,
                 project_observability_roles: Optional[Sequence['outputs.OrganizationMembersProjectObservabilityRole']] = None,
                 project_security_roles: Optional[Sequence['outputs.OrganizationMembersProjectSecurityRole']] = None,
                 user_id: Optional[builtins.str] = None):
        """
        :param Sequence['OrganizationMembersDeploymentRoleArgs'] deployment_roles: Grant access to one or more deployments. For more info see: [Deployment instance roles](https://www.elastic.co/guide/en/cloud/current/ec-user-privileges.html#ec_instance_access_roles).
        :param builtins.str email: Email address of the user.
        :param builtins.bool invitation_pending: Set to true while the user has not yet accepted their invitation to the organization.
        :param builtins.str organization_role: The optional organization role for the member. Can be one of `organization-admin`, `billing-admin`. For more info see: [Organization roles](https://www.elastic.co/guide/en/cloud/current/ec-user-privileges.html#ec_organization_level_roles)
        :param Sequence['OrganizationMembersProjectElasticsearchRoleArgs'] project_elasticsearch_roles: Roles assigned for elasticsearch projects. For more info see: [Serverless elasticsearch roles](https://www.elastic.co/docs/current/serverless/general/assign-user-roles#es)
        :param Sequence['OrganizationMembersProjectObservabilityRoleArgs'] project_observability_roles: Roles assigned for observability projects. For more info see: [Serverless observability roles](https://www.elastic.co/docs/current/serverless/general/assign-user-roles#observability)
        :param Sequence['OrganizationMembersProjectSecurityRoleArgs'] project_security_roles: Roles assigned for security projects. For more info see: [Serverless security roles](https://www.elastic.co/docs/current/serverless/general/assign-user-roles#security)
        :param builtins.str user_id: User ID.
        """
        if deployment_roles is not None:
            pulumi.set(__self__, "deployment_roles", deployment_roles)
        if email is not None:
            pulumi.set(__self__, "email", email)
        if invitation_pending is not None:
            pulumi.set(__self__, "invitation_pending", invitation_pending)
        if organization_role is not None:
            pulumi.set(__self__, "organization_role", organization_role)
        if project_elasticsearch_roles is not None:
            pulumi.set(__self__, "project_elasticsearch_roles", project_elasticsearch_roles)
        if project_observability_roles is not None:
            pulumi.set(__self__, "project_observability_roles", project_observability_roles)
        if project_security_roles is not None:
            pulumi.set(__self__, "project_security_roles", project_security_roles)
        if user_id is not None:
            pulumi.set(__self__, "user_id", user_id)

    @property
    @pulumi.getter(name="deploymentRoles")
    def deployment_roles(self) -> Optional[Sequence['outputs.OrganizationMembersDeploymentRole']]:
        """
        Grant access to one or more deployments. For more info see: [Deployment instance roles](https://www.elastic.co/guide/en/cloud/current/ec-user-privileges.html#ec_instance_access_roles).
        """
        return pulumi.get(self, "deployment_roles")

    @property
    @pulumi.getter
    def email(self) -> Optional[builtins.str]:
        """
        Email address of the user.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="invitationPending")
    def invitation_pending(self) -> Optional[builtins.bool]:
        """
        Set to true while the user has not yet accepted their invitation to the organization.
        """
        return pulumi.get(self, "invitation_pending")

    @property
    @pulumi.getter(name="organizationRole")
    def organization_role(self) -> Optional[builtins.str]:
        """
        The optional organization role for the member. Can be one of `organization-admin`, `billing-admin`. For more info see: [Organization roles](https://www.elastic.co/guide/en/cloud/current/ec-user-privileges.html#ec_organization_level_roles)
        """
        return pulumi.get(self, "organization_role")

    @property
    @pulumi.getter(name="projectElasticsearchRoles")
    def project_elasticsearch_roles(self) -> Optional[Sequence['outputs.OrganizationMembersProjectElasticsearchRole']]:
        """
        Roles assigned for elasticsearch projects. For more info see: [Serverless elasticsearch roles](https://www.elastic.co/docs/current/serverless/general/assign-user-roles#es)
        """
        return pulumi.get(self, "project_elasticsearch_roles")

    @property
    @pulumi.getter(name="projectObservabilityRoles")
    def project_observability_roles(self) -> Optional[Sequence['outputs.OrganizationMembersProjectObservabilityRole']]:
        """
        Roles assigned for observability projects. For more info see: [Serverless observability roles](https://www.elastic.co/docs/current/serverless/general/assign-user-roles#observability)
        """
        return pulumi.get(self, "project_observability_roles")

    @property
    @pulumi.getter(name="projectSecurityRoles")
    def project_security_roles(self) -> Optional[Sequence['outputs.OrganizationMembersProjectSecurityRole']]:
        """
        Roles assigned for security projects. For more info see: [Serverless security roles](https://www.elastic.co/docs/current/serverless/general/assign-user-roles#security)
        """
        return pulumi.get(self, "project_security_roles")

    @property
    @pulumi.getter(name="userId")
    def user_id(self) -> Optional[builtins.str]:
        """
        User ID.
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class OrganizationMembersDeploymentRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allDeployments":
            suggest = "all_deployments"
        elif key == "applicationRoles":
            suggest = "application_roles"
        elif key == "deploymentIds":
            suggest = "deployment_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationMembersDeploymentRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationMembersDeploymentRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationMembersDeploymentRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role: builtins.str,
                 all_deployments: Optional[builtins.bool] = None,
                 application_roles: Optional[Sequence[builtins.str]] = None,
                 deployment_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str role: Assigned role. Must be on of `viewer`, `editor` or `admin`.
        :param builtins.bool all_deployments: Role applies to all deployments in the organization.
        :param Sequence[builtins.str] application_roles: If provided, the user assigned this role assignment will be granted this application role when signing in to the deployment(s) specified in the role assignment.
        :param Sequence[builtins.str] deployment_ids: Role applies to deployments listed here.
        """
        pulumi.set(__self__, "role", role)
        if all_deployments is not None:
            pulumi.set(__self__, "all_deployments", all_deployments)
        if application_roles is not None:
            pulumi.set(__self__, "application_roles", application_roles)
        if deployment_ids is not None:
            pulumi.set(__self__, "deployment_ids", deployment_ids)

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        Assigned role. Must be on of `viewer`, `editor` or `admin`.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="allDeployments")
    def all_deployments(self) -> Optional[builtins.bool]:
        """
        Role applies to all deployments in the organization.
        """
        return pulumi.get(self, "all_deployments")

    @property
    @pulumi.getter(name="applicationRoles")
    def application_roles(self) -> Optional[Sequence[builtins.str]]:
        """
        If provided, the user assigned this role assignment will be granted this application role when signing in to the deployment(s) specified in the role assignment.
        """
        return pulumi.get(self, "application_roles")

    @property
    @pulumi.getter(name="deploymentIds")
    def deployment_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Role applies to deployments listed here.
        """
        return pulumi.get(self, "deployment_ids")


@pulumi.output_type
class OrganizationMembersProjectElasticsearchRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allProjects":
            suggest = "all_projects"
        elif key == "applicationRoles":
            suggest = "application_roles"
        elif key == "projectIds":
            suggest = "project_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationMembersProjectElasticsearchRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationMembersProjectElasticsearchRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationMembersProjectElasticsearchRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role: builtins.str,
                 all_projects: Optional[builtins.bool] = None,
                 application_roles: Optional[Sequence[builtins.str]] = None,
                 project_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str role: Assigned role. (Allowed values: `admin`, `developer`, `viewer`)
        :param builtins.bool all_projects: Role applies to all projects in the organization.
        :param Sequence[builtins.str] application_roles: If provided, the user assigned this role assignment will be granted this application role when signing in to the project(s) specified in the role assignment.
        :param Sequence[builtins.str] project_ids: Role applies to projects listed here.
        """
        pulumi.set(__self__, "role", role)
        if all_projects is not None:
            pulumi.set(__self__, "all_projects", all_projects)
        if application_roles is not None:
            pulumi.set(__self__, "application_roles", application_roles)
        if project_ids is not None:
            pulumi.set(__self__, "project_ids", project_ids)

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        Assigned role. (Allowed values: `admin`, `developer`, `viewer`)
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> Optional[builtins.bool]:
        """
        Role applies to all projects in the organization.
        """
        return pulumi.get(self, "all_projects")

    @property
    @pulumi.getter(name="applicationRoles")
    def application_roles(self) -> Optional[Sequence[builtins.str]]:
        """
        If provided, the user assigned this role assignment will be granted this application role when signing in to the project(s) specified in the role assignment.
        """
        return pulumi.get(self, "application_roles")

    @property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Role applies to projects listed here.
        """
        return pulumi.get(self, "project_ids")


@pulumi.output_type
class OrganizationMembersProjectObservabilityRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allProjects":
            suggest = "all_projects"
        elif key == "applicationRoles":
            suggest = "application_roles"
        elif key == "projectIds":
            suggest = "project_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationMembersProjectObservabilityRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationMembersProjectObservabilityRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationMembersProjectObservabilityRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role: builtins.str,
                 all_projects: Optional[builtins.bool] = None,
                 application_roles: Optional[Sequence[builtins.str]] = None,
                 project_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str role: Assigned role. (Allowed values: `admin`, `editor`, `viewer`)
        :param builtins.bool all_projects: Role applies to all projects in the organization.
        :param Sequence[builtins.str] application_roles: If provided, the user assigned this role assignment will be granted this application role when signing in to the project(s) specified in the role assignment.
        :param Sequence[builtins.str] project_ids: Role applies to projects listed here.
        """
        pulumi.set(__self__, "role", role)
        if all_projects is not None:
            pulumi.set(__self__, "all_projects", all_projects)
        if application_roles is not None:
            pulumi.set(__self__, "application_roles", application_roles)
        if project_ids is not None:
            pulumi.set(__self__, "project_ids", project_ids)

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        Assigned role. (Allowed values: `admin`, `editor`, `viewer`)
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> Optional[builtins.bool]:
        """
        Role applies to all projects in the organization.
        """
        return pulumi.get(self, "all_projects")

    @property
    @pulumi.getter(name="applicationRoles")
    def application_roles(self) -> Optional[Sequence[builtins.str]]:
        """
        If provided, the user assigned this role assignment will be granted this application role when signing in to the project(s) specified in the role assignment.
        """
        return pulumi.get(self, "application_roles")

    @property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Role applies to projects listed here.
        """
        return pulumi.get(self, "project_ids")


@pulumi.output_type
class OrganizationMembersProjectSecurityRole(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allProjects":
            suggest = "all_projects"
        elif key == "applicationRoles":
            suggest = "application_roles"
        elif key == "projectIds":
            suggest = "project_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrganizationMembersProjectSecurityRole. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrganizationMembersProjectSecurityRole.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrganizationMembersProjectSecurityRole.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 role: builtins.str,
                 all_projects: Optional[builtins.bool] = None,
                 application_roles: Optional[Sequence[builtins.str]] = None,
                 project_ids: Optional[Sequence[builtins.str]] = None):
        """
        :param builtins.str role: Assigned role. (Allowed values: `admin`, `editor`, `viewer`, `t1-analyst`, `t2-analyst`, `t3-analyst`, `threat-intel-analyst`, `rule-author`, `soc-manager`, `endpoint-operations-analyst`, `platform-engineer`, `detections-admin`, `endpoint-policy-manager`)
        :param builtins.bool all_projects: Role applies to all projects in the organization.
        :param Sequence[builtins.str] application_roles: If provided, the user assigned this role assignment will be granted this application role when signing in to the project(s) specified in the role assignment.
        :param Sequence[builtins.str] project_ids: Role applies to projects listed here.
        """
        pulumi.set(__self__, "role", role)
        if all_projects is not None:
            pulumi.set(__self__, "all_projects", all_projects)
        if application_roles is not None:
            pulumi.set(__self__, "application_roles", application_roles)
        if project_ids is not None:
            pulumi.set(__self__, "project_ids", project_ids)

    @property
    @pulumi.getter
    def role(self) -> builtins.str:
        """
        Assigned role. (Allowed values: `admin`, `editor`, `viewer`, `t1-analyst`, `t2-analyst`, `t3-analyst`, `threat-intel-analyst`, `rule-author`, `soc-manager`, `endpoint-operations-analyst`, `platform-engineer`, `detections-admin`, `endpoint-policy-manager`)
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter(name="allProjects")
    def all_projects(self) -> Optional[builtins.bool]:
        """
        Role applies to all projects in the organization.
        """
        return pulumi.get(self, "all_projects")

    @property
    @pulumi.getter(name="applicationRoles")
    def application_roles(self) -> Optional[Sequence[builtins.str]]:
        """
        If provided, the user assigned this role assignment will be granted this application role when signing in to the project(s) specified in the role assignment.
        """
        return pulumi.get(self, "application_roles")

    @property
    @pulumi.getter(name="projectIds")
    def project_ids(self) -> Optional[Sequence[builtins.str]]:
        """
        Role applies to projects listed here.
        """
        return pulumi.get(self, "project_ids")


@pulumi.output_type
class SecurityProjectCredentials(dict):
    def __init__(__self__, *,
                 password: Optional[builtins.str] = None,
                 username: Optional[builtins.str] = None):
        """
        :param builtins.str password: Basic auth password that can be used to access the Elasticsearch API.
        :param builtins.str username: Basic auth username that can be used to access the Elasticsearch API.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[builtins.str]:
        """
        Basic auth password that can be used to access the Elasticsearch API.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> Optional[builtins.str]:
        """
        Basic auth username that can be used to access the Elasticsearch API.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class SecurityProjectEndpoints(dict):
    def __init__(__self__, *,
                 elasticsearch: Optional[builtins.str] = None,
                 kibana: Optional[builtins.str] = None):
        """
        :param builtins.str elasticsearch: The endpoint to access elasticsearch.
        :param builtins.str kibana: The endpoint to access kibana.
        """
        if elasticsearch is not None:
            pulumi.set(__self__, "elasticsearch", elasticsearch)
        if kibana is not None:
            pulumi.set(__self__, "kibana", kibana)

    @property
    @pulumi.getter
    def elasticsearch(self) -> Optional[builtins.str]:
        """
        The endpoint to access elasticsearch.
        """
        return pulumi.get(self, "elasticsearch")

    @property
    @pulumi.getter
    def kibana(self) -> Optional[builtins.str]:
        """
        The endpoint to access kibana.
        """
        return pulumi.get(self, "kibana")


@pulumi.output_type
class SecurityProjectMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "createdBy":
            suggest = "created_by"
        elif key == "organizationId":
            suggest = "organization_id"
        elif key == "suspendedAt":
            suggest = "suspended_at"
        elif key == "suspendedReason":
            suggest = "suspended_reason"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityProjectMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityProjectMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityProjectMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[builtins.str] = None,
                 created_by: Optional[builtins.str] = None,
                 organization_id: Optional[builtins.str] = None,
                 suspended_at: Optional[builtins.str] = None,
                 suspended_reason: Optional[builtins.str] = None):
        """
        :param builtins.str created_at: Date and time when the project was created.
        :param builtins.str created_by: ID of the user.
        :param builtins.str organization_id: The Organization ID who owns the project.
        :param builtins.str suspended_at: Date and time when the project was suspended.
        :param builtins.str suspended_reason: Reason why the project was suspended.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if created_by is not None:
            pulumi.set(__self__, "created_by", created_by)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if suspended_at is not None:
            pulumi.set(__self__, "suspended_at", suspended_at)
        if suspended_reason is not None:
            pulumi.set(__self__, "suspended_reason", suspended_reason)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[builtins.str]:
        """
        Date and time when the project was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> Optional[builtins.str]:
        """
        ID of the user.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[builtins.str]:
        """
        The Organization ID who owns the project.
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="suspendedAt")
    def suspended_at(self) -> Optional[builtins.str]:
        """
        Date and time when the project was suspended.
        """
        return pulumi.get(self, "suspended_at")

    @property
    @pulumi.getter(name="suspendedReason")
    def suspended_reason(self) -> Optional[builtins.str]:
        """
        Reason why the project was suspended.
        """
        return pulumi.get(self, "suspended_reason")


@pulumi.output_type
class SecurityProjectProductType(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "productLine":
            suggest = "product_line"
        elif key == "productTier":
            suggest = "product_tier"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityProjectProductType. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityProjectProductType.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityProjectProductType.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 product_line: builtins.str,
                 product_tier: builtins.str):
        """
        :param builtins.str product_line: The identifier of the Security Solution product line.
        :param builtins.str product_tier: The identifier of the Security Solution product tier.
        """
        pulumi.set(__self__, "product_line", product_line)
        pulumi.set(__self__, "product_tier", product_tier)

    @property
    @pulumi.getter(name="productLine")
    def product_line(self) -> builtins.str:
        """
        The identifier of the Security Solution product line.
        """
        return pulumi.get(self, "product_line")

    @property
    @pulumi.getter(name="productTier")
    def product_tier(self) -> builtins.str:
        """
        The identifier of the Security Solution product tier.
        """
        return pulumi.get(self, "product_tier")


@pulumi.output_type
class SnapshotRepositoryGeneric(dict):
    def __init__(__self__, *,
                 settings: builtins.str,
                 type: builtins.str):
        """
        :param builtins.str settings: An arbitrary JSON object containing the repository settings.
        :param builtins.str type: Repository type
        """
        pulumi.set(__self__, "settings", settings)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def settings(self) -> builtins.str:
        """
        An arbitrary JSON object containing the repository settings.
        """
        return pulumi.get(self, "settings")

    @property
    @pulumi.getter
    def type(self) -> builtins.str:
        """
        Repository type
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SnapshotRepositoryS3(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accessKey":
            suggest = "access_key"
        elif key == "pathStyleAccess":
            suggest = "path_style_access"
        elif key == "secretKey":
            suggest = "secret_key"
        elif key == "serverSideEncryption":
            suggest = "server_side_encryption"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotRepositoryS3. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotRepositoryS3.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotRepositoryS3.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: builtins.str,
                 access_key: Optional[builtins.str] = None,
                 endpoint: Optional[builtins.str] = None,
                 path_style_access: Optional[builtins.bool] = None,
                 region: Optional[builtins.str] = None,
                 secret_key: Optional[builtins.str] = None,
                 server_side_encryption: Optional[builtins.bool] = None):
        """
        :param builtins.str bucket: Name of the S3 bucket to use for snapshots.
        :param builtins.str access_key: An S3 access key. If set, the secret_key setting must also be specified. If unset, the client will use the instance or container role instead.
        :param builtins.str endpoint: The S3 service endpoint to connect to. This defaults to s3.amazonaws.com but the AWS documentation lists alternative S3 endpoints. If you are using an S3-compatible service then you should set this to the service’s endpoint.
        :param builtins.bool path_style_access: Whether to force the use of the path style access pattern. If true, the path style access pattern will be used. If false, the access pattern will be automatically determined by the AWS Java SDK (See AWS documentation for details). Defaults to false.
        :param builtins.str region: Allows specifying the signing region to use. Specifying this setting manually should not be necessary for most use cases. Generally, the SDK will correctly guess the signing region to use. It should be considered an expert level setting to support S3-compatible APIs that require v4 signatures and use a region other than the default us-east-1. Defaults to empty string which means that the SDK will try to automatically determine the correct signing region.
        :param builtins.str secret_key: An S3 secret key. If set, the access_key setting must also be specified.
        :param builtins.bool server_side_encryption: When set to true files are encrypted on server side using AES256 algorithm. Defaults to false.
        """
        pulumi.set(__self__, "bucket", bucket)
        if access_key is not None:
            pulumi.set(__self__, "access_key", access_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if path_style_access is not None:
            pulumi.set(__self__, "path_style_access", path_style_access)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_key is not None:
            pulumi.set(__self__, "secret_key", secret_key)
        if server_side_encryption is not None:
            pulumi.set(__self__, "server_side_encryption", server_side_encryption)

    @property
    @pulumi.getter
    def bucket(self) -> builtins.str:
        """
        Name of the S3 bucket to use for snapshots.
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="accessKey")
    def access_key(self) -> Optional[builtins.str]:
        """
        An S3 access key. If set, the secret_key setting must also be specified. If unset, the client will use the instance or container role instead.
        """
        return pulumi.get(self, "access_key")

    @property
    @pulumi.getter
    def endpoint(self) -> Optional[builtins.str]:
        """
        The S3 service endpoint to connect to. This defaults to s3.amazonaws.com but the AWS documentation lists alternative S3 endpoints. If you are using an S3-compatible service then you should set this to the service’s endpoint.
        """
        return pulumi.get(self, "endpoint")

    @property
    @pulumi.getter(name="pathStyleAccess")
    def path_style_access(self) -> Optional[builtins.bool]:
        """
        Whether to force the use of the path style access pattern. If true, the path style access pattern will be used. If false, the access pattern will be automatically determined by the AWS Java SDK (See AWS documentation for details). Defaults to false.
        """
        return pulumi.get(self, "path_style_access")

    @property
    @pulumi.getter
    def region(self) -> Optional[builtins.str]:
        """
        Allows specifying the signing region to use. Specifying this setting manually should not be necessary for most use cases. Generally, the SDK will correctly guess the signing region to use. It should be considered an expert level setting to support S3-compatible APIs that require v4 signatures and use a region other than the default us-east-1. Defaults to empty string which means that the SDK will try to automatically determine the correct signing region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretKey")
    def secret_key(self) -> Optional[builtins.str]:
        """
        An S3 secret key. If set, the access_key setting must also be specified.
        """
        return pulumi.get(self, "secret_key")

    @property
    @pulumi.getter(name="serverSideEncryption")
    def server_side_encryption(self) -> Optional[builtins.bool]:
        """
        When set to true files are encrypted on server side using AES256 algorithm. Defaults to false.
        """
        return pulumi.get(self, "server_side_encryption")


@pulumi.output_type
class GetDeploymentApmResult(dict):
    def __init__(__self__, *,
                 elasticsearch_cluster_ref_id: builtins.str,
                 healthy: builtins.bool,
                 http_endpoint: builtins.str,
                 https_endpoint: builtins.str,
                 ref_id: builtins.str,
                 resource_id: builtins.str,
                 status: builtins.str,
                 topologies: Sequence['outputs.GetDeploymentApmTopologyResult'],
                 version: builtins.str):
        """
        :param builtins.str elasticsearch_cluster_ref_id: The locally-unique user-specified id of an APM Resource.
        :param builtins.bool healthy: APM resource health status.
        :param builtins.str http_endpoint: HTTP endpoint for the APM resource.
        :param builtins.str https_endpoint: HTTPS endpoint for the APM resource.
        :param builtins.str ref_id: A locally-unique friendly alias for this APM resource.
        :param builtins.str resource_id: The resource unique identifier.
        :param builtins.str status: APM resource status (for example, "started", "stopped", etc).
        :param Sequence['GetDeploymentApmTopologyArgs'] topologies: Node topology element definition.
        :param builtins.str version: Elastic stack version.
        """
        pulumi.set(__self__, "elasticsearch_cluster_ref_id", elasticsearch_cluster_ref_id)
        pulumi.set(__self__, "healthy", healthy)
        pulumi.set(__self__, "http_endpoint", http_endpoint)
        pulumi.set(__self__, "https_endpoint", https_endpoint)
        pulumi.set(__self__, "ref_id", ref_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "topologies", topologies)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="elasticsearchClusterRefId")
    def elasticsearch_cluster_ref_id(self) -> builtins.str:
        """
        The locally-unique user-specified id of an APM Resource.
        """
        return pulumi.get(self, "elasticsearch_cluster_ref_id")

    @property
    @pulumi.getter
    def healthy(self) -> builtins.bool:
        """
        APM resource health status.
        """
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> builtins.str:
        """
        HTTP endpoint for the APM resource.
        """
        return pulumi.get(self, "http_endpoint")

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> builtins.str:
        """
        HTTPS endpoint for the APM resource.
        """
        return pulumi.get(self, "https_endpoint")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> builtins.str:
        """
        A locally-unique friendly alias for this APM resource.
        """
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        The resource unique identifier.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        APM resource status (for example, "started", "stopped", etc).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.GetDeploymentApmTopologyResult']:
        """
        Node topology element definition.
        """
        return pulumi.get(self, "topologies")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDeploymentApmTopologyResult(dict):
    def __init__(__self__, *,
                 instance_configuration_id: builtins.str,
                 size: builtins.str,
                 size_resource: builtins.str,
                 zone_count: builtins.int):
        """
        :param builtins.str instance_configuration_id: Controls the allocation of this topology element as well as allowed sizes and node_types. It needs to match the ID of an existing instance configuration.
        :param builtins.str size: Amount of "size_resource" in Gigabytes. For example "4g".
        :param builtins.str size_resource: Type of resource ("memory" or "storage")
        :param builtins.int zone_count: Number of zones in which nodes will be placed.
        """
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "size_resource", size_resource)
        pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        """
        Controls the allocation of this topology element as well as allowed sizes and node_types. It needs to match the ID of an existing instance configuration.
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter
    def size(self) -> builtins.str:
        """
        Amount of "size_resource" in Gigabytes. For example "4g".
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        """
        Type of resource ("memory" or "storage")
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> builtins.int:
        """
        Number of zones in which nodes will be placed.
        """
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class GetDeploymentElasticsearchResult(dict):
    def __init__(__self__, *,
                 autoscale: builtins.str,
                 cloud_id: builtins.str,
                 healthy: builtins.bool,
                 http_endpoint: builtins.str,
                 https_endpoint: builtins.str,
                 ref_id: builtins.str,
                 resource_id: builtins.str,
                 status: builtins.str,
                 topologies: Sequence['outputs.GetDeploymentElasticsearchTopologyResult'],
                 version: builtins.str):
        """
        :param builtins.str autoscale: Whether or not Elasticsearch autoscaling is enabled.
        :param builtins.str cloud_id: The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana. See [Configure Beats and Logstash with Cloud ID](https://www.elastic.co/guide/en/cloud/current/ec-cloud-id.html) for more information.
        :param builtins.bool healthy: Elasticsearch resource health status.
        :param builtins.str http_endpoint: HTTP endpoint for the Elasticsearch resource.
        :param builtins.str https_endpoint: HTTPS endpoint for the Elasticsearch resource.
        :param builtins.str ref_id: A locally-unique friendly alias for this Elasticsearch cluster.
        :param builtins.str resource_id: The resource unique identifier.
        :param builtins.str status: Elasticsearch resource status (for example, "started", "stopped", etc).
        :param Sequence['GetDeploymentElasticsearchTopologyArgs'] topologies: Node topology element definition.
        :param builtins.str version: Elastic stack version.
        """
        pulumi.set(__self__, "autoscale", autoscale)
        pulumi.set(__self__, "cloud_id", cloud_id)
        pulumi.set(__self__, "healthy", healthy)
        pulumi.set(__self__, "http_endpoint", http_endpoint)
        pulumi.set(__self__, "https_endpoint", https_endpoint)
        pulumi.set(__self__, "ref_id", ref_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "topologies", topologies)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def autoscale(self) -> builtins.str:
        """
        Whether or not Elasticsearch autoscaling is enabled.
        """
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="cloudId")
    def cloud_id(self) -> builtins.str:
        """
        The cloud ID, an encoded string that provides other Elastic services with the necessary information to connect to this Elasticsearch and Kibana. See [Configure Beats and Logstash with Cloud ID](https://www.elastic.co/guide/en/cloud/current/ec-cloud-id.html) for more information.
        """
        return pulumi.get(self, "cloud_id")

    @property
    @pulumi.getter
    def healthy(self) -> builtins.bool:
        """
        Elasticsearch resource health status.
        """
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> builtins.str:
        """
        HTTP endpoint for the Elasticsearch resource.
        """
        return pulumi.get(self, "http_endpoint")

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> builtins.str:
        """
        HTTPS endpoint for the Elasticsearch resource.
        """
        return pulumi.get(self, "https_endpoint")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> builtins.str:
        """
        A locally-unique friendly alias for this Elasticsearch cluster.
        """
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        The resource unique identifier.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Elasticsearch resource status (for example, "started", "stopped", etc).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.GetDeploymentElasticsearchTopologyResult']:
        """
        Node topology element definition.
        """
        return pulumi.get(self, "topologies")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDeploymentElasticsearchTopologyResult(dict):
    def __init__(__self__, *,
                 autoscalings: Sequence['outputs.GetDeploymentElasticsearchTopologyAutoscalingResult'],
                 instance_configuration_id: builtins.str,
                 node_roles: Sequence[builtins.str],
                 node_type_data: builtins.bool,
                 node_type_ingest: builtins.bool,
                 node_type_master: builtins.bool,
                 node_type_ml: builtins.bool,
                 size: builtins.str,
                 size_resource: builtins.str,
                 zone_count: builtins.int):
        """
        :param Sequence['GetDeploymentElasticsearchTopologyAutoscalingArgs'] autoscalings: Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        :param builtins.str instance_configuration_id: Controls the allocation of this topology element as well as allowed sizes and node_types. It needs to match the ID of an existing instance configuration.
        :param Sequence[builtins.str] node_roles: Defines the list of Elasticsearch node roles assigned to the topology element. This is supported from v7.10, and required from v8.
        :param builtins.bool node_type_data: Defines whether this node can hold data (\\n\\n).
        :param builtins.bool node_type_ingest: Defines whether this node can run an ingest pipeline (\\n\\n).
        :param builtins.bool node_type_master: Defines whether this node can be elected master (\\n\\n).
        :param builtins.bool node_type_ml: Defines whether this node can run ML jobs (\\n\\n).
        :param builtins.str size: Amount of "size_resource" per topology element in Gigabytes. For example "4g".
        :param builtins.str size_resource: Type of resource ("memory" or "storage")
        :param builtins.int zone_count: Number of zones in which nodes will be placed.
        """
        pulumi.set(__self__, "autoscalings", autoscalings)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "node_roles", node_roles)
        pulumi.set(__self__, "node_type_data", node_type_data)
        pulumi.set(__self__, "node_type_ingest", node_type_ingest)
        pulumi.set(__self__, "node_type_master", node_type_master)
        pulumi.set(__self__, "node_type_ml", node_type_ml)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "size_resource", size_resource)
        pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter
    def autoscalings(self) -> Sequence['outputs.GetDeploymentElasticsearchTopologyAutoscalingResult']:
        """
        Optional Elasticsearch autoscaling settings, such a maximum and minimum size and resources.
        """
        return pulumi.get(self, "autoscalings")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        """
        Controls the allocation of this topology element as well as allowed sizes and node_types. It needs to match the ID of an existing instance configuration.
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="nodeRoles")
    def node_roles(self) -> Sequence[builtins.str]:
        """
        Defines the list of Elasticsearch node roles assigned to the topology element. This is supported from v7.10, and required from v8.
        """
        return pulumi.get(self, "node_roles")

    @property
    @pulumi.getter(name="nodeTypeData")
    def node_type_data(self) -> builtins.bool:
        """
        Defines whether this node can hold data (\\n\\n).
        """
        return pulumi.get(self, "node_type_data")

    @property
    @pulumi.getter(name="nodeTypeIngest")
    def node_type_ingest(self) -> builtins.bool:
        """
        Defines whether this node can run an ingest pipeline (\\n\\n).
        """
        return pulumi.get(self, "node_type_ingest")

    @property
    @pulumi.getter(name="nodeTypeMaster")
    def node_type_master(self) -> builtins.bool:
        """
        Defines whether this node can be elected master (\\n\\n).
        """
        return pulumi.get(self, "node_type_master")

    @property
    @pulumi.getter(name="nodeTypeMl")
    def node_type_ml(self) -> builtins.bool:
        """
        Defines whether this node can run ML jobs (\\n\\n).
        """
        return pulumi.get(self, "node_type_ml")

    @property
    @pulumi.getter
    def size(self) -> builtins.str:
        """
        Amount of "size_resource" per topology element in Gigabytes. For example "4g".
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        """
        Type of resource ("memory" or "storage")
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> builtins.int:
        """
        Number of zones in which nodes will be placed.
        """
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class GetDeploymentElasticsearchTopologyAutoscalingResult(dict):
    def __init__(__self__, *,
                 max_size: builtins.str,
                 max_size_resource: builtins.str,
                 min_size: builtins.str,
                 min_size_resource: builtins.str,
                 policy_override_json: builtins.str):
        """
        :param builtins.str max_size: Maximum size the tier can scale up to, e.g "64g".
        :param builtins.str max_size_resource: Resource type used when specifying the maximum size the tier can scale up to.
        :param builtins.str min_size: Minimum size the tier can scale down to when bidirectional autoscaling is supported.
        :param builtins.str min_size_resource: Resource type used when specifying the minimum size the tier can scale down to when bidirectional autoscaling is supported.
        :param builtins.str policy_override_json: An arbitrary JSON object overriding the default autoscaling policy. Don't set unless you really know what you are doing.
        """
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "max_size_resource", max_size_resource)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "min_size_resource", min_size_resource)
        pulumi.set(__self__, "policy_override_json", policy_override_json)

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> builtins.str:
        """
        Maximum size the tier can scale up to, e.g "64g".
        """
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> builtins.str:
        """
        Resource type used when specifying the maximum size the tier can scale up to.
        """
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> builtins.str:
        """
        Minimum size the tier can scale down to when bidirectional autoscaling is supported.
        """
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> builtins.str:
        """
        Resource type used when specifying the minimum size the tier can scale down to when bidirectional autoscaling is supported.
        """
        return pulumi.get(self, "min_size_resource")

    @property
    @pulumi.getter(name="policyOverrideJson")
    def policy_override_json(self) -> builtins.str:
        """
        An arbitrary JSON object overriding the default autoscaling policy. Don't set unless you really know what you are doing.
        """
        return pulumi.get(self, "policy_override_json")


@pulumi.output_type
class GetDeploymentEnterpriseSearchResult(dict):
    def __init__(__self__, *,
                 elasticsearch_cluster_ref_id: builtins.str,
                 healthy: builtins.bool,
                 http_endpoint: builtins.str,
                 https_endpoint: builtins.str,
                 ref_id: builtins.str,
                 resource_id: builtins.str,
                 status: builtins.str,
                 topologies: Sequence['outputs.GetDeploymentEnterpriseSearchTopologyResult'],
                 version: builtins.str):
        """
        :param builtins.str elasticsearch_cluster_ref_id: A locally-unique friendly alias for an Elasticsearch resource in this deployment.
        :param builtins.bool healthy: Enterprise Search resource health status.
        :param builtins.str http_endpoint: HTTP endpoint for the Enterprise Search resource.
        :param builtins.str https_endpoint: HTTPS endpoint for the Enterprise Search resource.
        :param builtins.str ref_id: A locally-unique friendly alias for this Enterprise Search resource.
        :param builtins.str resource_id: The resource unique identifier.
        :param builtins.str status: Enterprise Search resource status (for example, "started", "stopped", etc).
        :param Sequence['GetDeploymentEnterpriseSearchTopologyArgs'] topologies: Node topology element definition.
        :param builtins.str version: Elastic stack version.
        """
        pulumi.set(__self__, "elasticsearch_cluster_ref_id", elasticsearch_cluster_ref_id)
        pulumi.set(__self__, "healthy", healthy)
        pulumi.set(__self__, "http_endpoint", http_endpoint)
        pulumi.set(__self__, "https_endpoint", https_endpoint)
        pulumi.set(__self__, "ref_id", ref_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "topologies", topologies)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="elasticsearchClusterRefId")
    def elasticsearch_cluster_ref_id(self) -> builtins.str:
        """
        A locally-unique friendly alias for an Elasticsearch resource in this deployment.
        """
        return pulumi.get(self, "elasticsearch_cluster_ref_id")

    @property
    @pulumi.getter
    def healthy(self) -> builtins.bool:
        """
        Enterprise Search resource health status.
        """
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> builtins.str:
        """
        HTTP endpoint for the Enterprise Search resource.
        """
        return pulumi.get(self, "http_endpoint")

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> builtins.str:
        """
        HTTPS endpoint for the Enterprise Search resource.
        """
        return pulumi.get(self, "https_endpoint")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> builtins.str:
        """
        A locally-unique friendly alias for this Enterprise Search resource.
        """
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        The resource unique identifier.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Enterprise Search resource status (for example, "started", "stopped", etc).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.GetDeploymentEnterpriseSearchTopologyResult']:
        """
        Node topology element definition.
        """
        return pulumi.get(self, "topologies")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDeploymentEnterpriseSearchTopologyResult(dict):
    def __init__(__self__, *,
                 instance_configuration_id: builtins.str,
                 node_type_appserver: builtins.bool,
                 node_type_connector: builtins.bool,
                 node_type_worker: builtins.bool,
                 size: builtins.str,
                 size_resource: builtins.str,
                 zone_count: builtins.int):
        """
        :param builtins.str instance_configuration_id: Controls the allocation of this topology element as well as allowed sizes and node_types. It needs to match the ID of an existing instance configuration.
        :param builtins.bool node_type_appserver: Defines whether this instance should run as application/API server.
        :param builtins.bool node_type_connector: Defines whether this instance should run as connector.
        :param builtins.bool node_type_worker: Defines whether this instance should run as background worker.
        :param builtins.str size: Amount of "size_resource" in Gigabytes. For example "4g".
        :param builtins.str size_resource: Type of resource ("memory" or "storage")
        :param builtins.int zone_count: Number of zones in which nodes will be placed.
        """
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "node_type_appserver", node_type_appserver)
        pulumi.set(__self__, "node_type_connector", node_type_connector)
        pulumi.set(__self__, "node_type_worker", node_type_worker)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "size_resource", size_resource)
        pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        """
        Controls the allocation of this topology element as well as allowed sizes and node_types. It needs to match the ID of an existing instance configuration.
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="nodeTypeAppserver")
    def node_type_appserver(self) -> builtins.bool:
        """
        Defines whether this instance should run as application/API server.
        """
        return pulumi.get(self, "node_type_appserver")

    @property
    @pulumi.getter(name="nodeTypeConnector")
    def node_type_connector(self) -> builtins.bool:
        """
        Defines whether this instance should run as connector.
        """
        return pulumi.get(self, "node_type_connector")

    @property
    @pulumi.getter(name="nodeTypeWorker")
    def node_type_worker(self) -> builtins.bool:
        """
        Defines whether this instance should run as background worker.
        """
        return pulumi.get(self, "node_type_worker")

    @property
    @pulumi.getter
    def size(self) -> builtins.str:
        """
        Amount of "size_resource" in Gigabytes. For example "4g".
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        """
        Type of resource ("memory" or "storage")
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> builtins.int:
        """
        Number of zones in which nodes will be placed.
        """
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class GetDeploymentIntegrationsServerResult(dict):
    def __init__(__self__, *,
                 elasticsearch_cluster_ref_id: builtins.str,
                 healthy: builtins.bool,
                 http_endpoint: builtins.str,
                 https_endpoint: builtins.str,
                 ref_id: builtins.str,
                 resource_id: builtins.str,
                 status: builtins.str,
                 topologies: Sequence['outputs.GetDeploymentIntegrationsServerTopologyResult'],
                 version: builtins.str):
        """
        :param builtins.str elasticsearch_cluster_ref_id: A locally-unique friendly alias for an Elasticsearch resource in this deployment.
        :param builtins.bool healthy: Resource kind health status.
        :param builtins.str http_endpoint: HTTP endpoint for the resource kind.
        :param builtins.str https_endpoint: HTTPS endpoint for the resource kind.
        :param builtins.str ref_id: A locally-unique friendly alias for this Integrations Server resource.
        :param builtins.str resource_id: The resource unique identifier.
        :param builtins.str status: Resource kind status (for example, "started", "stopped", etc).
        :param Sequence['GetDeploymentIntegrationsServerTopologyArgs'] topologies: Node topology element definition.
        :param builtins.str version: Elastic stack version.
        """
        pulumi.set(__self__, "elasticsearch_cluster_ref_id", elasticsearch_cluster_ref_id)
        pulumi.set(__self__, "healthy", healthy)
        pulumi.set(__self__, "http_endpoint", http_endpoint)
        pulumi.set(__self__, "https_endpoint", https_endpoint)
        pulumi.set(__self__, "ref_id", ref_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "topologies", topologies)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="elasticsearchClusterRefId")
    def elasticsearch_cluster_ref_id(self) -> builtins.str:
        """
        A locally-unique friendly alias for an Elasticsearch resource in this deployment.
        """
        return pulumi.get(self, "elasticsearch_cluster_ref_id")

    @property
    @pulumi.getter
    def healthy(self) -> builtins.bool:
        """
        Resource kind health status.
        """
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> builtins.str:
        """
        HTTP endpoint for the resource kind.
        """
        return pulumi.get(self, "http_endpoint")

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> builtins.str:
        """
        HTTPS endpoint for the resource kind.
        """
        return pulumi.get(self, "https_endpoint")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> builtins.str:
        """
        A locally-unique friendly alias for this Integrations Server resource.
        """
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        The resource unique identifier.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Resource kind status (for example, "started", "stopped", etc).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.GetDeploymentIntegrationsServerTopologyResult']:
        """
        Node topology element definition.
        """
        return pulumi.get(self, "topologies")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDeploymentIntegrationsServerTopologyResult(dict):
    def __init__(__self__, *,
                 instance_configuration_id: builtins.str,
                 size: builtins.str,
                 size_resource: builtins.str,
                 zone_count: builtins.int):
        """
        :param builtins.str instance_configuration_id: Controls the allocation of this topology element as well as allowed sizes and node_types. It needs to match the ID of an existing instance configuration.
        :param builtins.str size: Amount of "size_resource" in Gigabytes. For example "4g".
        :param builtins.str size_resource: Type of resource ("memory" or "storage")
        :param builtins.int zone_count: Number of zones in which nodes will be placed.
        """
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "size_resource", size_resource)
        pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        """
        Controls the allocation of this topology element as well as allowed sizes and node_types. It needs to match the ID of an existing instance configuration.
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter
    def size(self) -> builtins.str:
        """
        Amount of "size_resource" in Gigabytes. For example "4g".
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        """
        Type of resource ("memory" or "storage")
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> builtins.int:
        """
        Number of zones in which nodes will be placed.
        """
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class GetDeploymentKibanaResult(dict):
    def __init__(__self__, *,
                 elasticsearch_cluster_ref_id: builtins.str,
                 healthy: builtins.bool,
                 http_endpoint: builtins.str,
                 https_endpoint: builtins.str,
                 ref_id: builtins.str,
                 resource_id: builtins.str,
                 status: builtins.str,
                 topologies: Sequence['outputs.GetDeploymentKibanaTopologyResult'],
                 version: builtins.str):
        """
        :param builtins.str elasticsearch_cluster_ref_id: A locally-unique friendly alias for an Elasticsearch resource in this deployment.
        :param builtins.bool healthy: Kibana resource health status.
        :param builtins.str http_endpoint: HTTP endpoint for the Kibana resource.
        :param builtins.str https_endpoint: HTTPS endpoint for the Kibana resource.
        :param builtins.str ref_id: A locally-unique friendly alias for this Kibana resource.
        :param builtins.str resource_id: The resource unique identifier.
        :param builtins.str status: Kibana resource status (for example, "started", "stopped", etc).
        :param Sequence['GetDeploymentKibanaTopologyArgs'] topologies: Node topology element definition.
        :param builtins.str version: Elastic stack version.
        """
        pulumi.set(__self__, "elasticsearch_cluster_ref_id", elasticsearch_cluster_ref_id)
        pulumi.set(__self__, "healthy", healthy)
        pulumi.set(__self__, "http_endpoint", http_endpoint)
        pulumi.set(__self__, "https_endpoint", https_endpoint)
        pulumi.set(__self__, "ref_id", ref_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "topologies", topologies)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="elasticsearchClusterRefId")
    def elasticsearch_cluster_ref_id(self) -> builtins.str:
        """
        A locally-unique friendly alias for an Elasticsearch resource in this deployment.
        """
        return pulumi.get(self, "elasticsearch_cluster_ref_id")

    @property
    @pulumi.getter
    def healthy(self) -> builtins.bool:
        """
        Kibana resource health status.
        """
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter(name="httpEndpoint")
    def http_endpoint(self) -> builtins.str:
        """
        HTTP endpoint for the Kibana resource.
        """
        return pulumi.get(self, "http_endpoint")

    @property
    @pulumi.getter(name="httpsEndpoint")
    def https_endpoint(self) -> builtins.str:
        """
        HTTPS endpoint for the Kibana resource.
        """
        return pulumi.get(self, "https_endpoint")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> builtins.str:
        """
        A locally-unique friendly alias for this Kibana resource.
        """
        return pulumi.get(self, "ref_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> builtins.str:
        """
        The resource unique identifier.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter
    def status(self) -> builtins.str:
        """
        Kibana resource status (for example, "started", "stopped", etc).
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def topologies(self) -> Sequence['outputs.GetDeploymentKibanaTopologyResult']:
        """
        Node topology element definition.
        """
        return pulumi.get(self, "topologies")

    @property
    @pulumi.getter
    def version(self) -> builtins.str:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDeploymentKibanaTopologyResult(dict):
    def __init__(__self__, *,
                 instance_configuration_id: builtins.str,
                 size: builtins.str,
                 size_resource: builtins.str,
                 zone_count: builtins.int):
        """
        :param builtins.str instance_configuration_id: Controls the allocation of this topology element as well as allowed sizes and node_types. It needs to match the ID of an existing instance configuration.
        :param builtins.str size: Amount of size_resource in Gigabytes. For example "4g".
        :param builtins.str size_resource: Type of resource ("memory" or "storage")
        :param builtins.int zone_count: Number of zones in which nodes will be placed.
        """
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "size_resource", size_resource)
        pulumi.set(__self__, "zone_count", zone_count)

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        """
        Controls the allocation of this topology element as well as allowed sizes and node_types. It needs to match the ID of an existing instance configuration.
        """
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter
    def size(self) -> builtins.str:
        """
        Amount of size_resource in Gigabytes. For example "4g".
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        """
        Type of resource ("memory" or "storage")
        """
        return pulumi.get(self, "size_resource")

    @property
    @pulumi.getter(name="zoneCount")
    def zone_count(self) -> builtins.int:
        """
        Number of zones in which nodes will be placed.
        """
        return pulumi.get(self, "zone_count")


@pulumi.output_type
class GetDeploymentObservabilityResult(dict):
    def __init__(__self__, *,
                 deployment_id: builtins.str,
                 logs: builtins.bool,
                 metrics: builtins.bool,
                 ref_id: builtins.str):
        """
        :param builtins.str deployment_id: Destination deployment ID for the shipped logs and monitoring metrics.
        :param builtins.bool logs: Defines whether logs are shipped to the destination deployment.
        :param builtins.bool metrics: Defines whether metrics are shipped to the destination deployment.
        :param builtins.str ref_id: Elasticsearch resource kind ref_id of the destination deployment.
        """
        pulumi.set(__self__, "deployment_id", deployment_id)
        pulumi.set(__self__, "logs", logs)
        pulumi.set(__self__, "metrics", metrics)
        pulumi.set(__self__, "ref_id", ref_id)

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> builtins.str:
        """
        Destination deployment ID for the shipped logs and monitoring metrics.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter
    def logs(self) -> builtins.bool:
        """
        Defines whether logs are shipped to the destination deployment.
        """
        return pulumi.get(self, "logs")

    @property
    @pulumi.getter
    def metrics(self) -> builtins.bool:
        """
        Defines whether metrics are shipped to the destination deployment.
        """
        return pulumi.get(self, "metrics")

    @property
    @pulumi.getter(name="refId")
    def ref_id(self) -> builtins.str:
        """
        Elasticsearch resource kind ref_id of the destination deployment.
        """
        return pulumi.get(self, "ref_id")


@pulumi.output_type
class GetDeploymentTemplatesTemplateResult(dict):
    def __init__(__self__, *,
                 apm: 'outputs.GetDeploymentTemplatesTemplateApmResult',
                 deprecated: builtins.bool,
                 description: builtins.str,
                 elasticsearch: 'outputs.GetDeploymentTemplatesTemplateElasticsearchResult',
                 enterprise_search: 'outputs.GetDeploymentTemplatesTemplateEnterpriseSearchResult',
                 id: builtins.str,
                 integrations_server: 'outputs.GetDeploymentTemplatesTemplateIntegrationsServerResult',
                 kibana: 'outputs.GetDeploymentTemplatesTemplateKibanaResult',
                 min_stack_version: builtins.str,
                 name: builtins.str):
        """
        :param 'GetDeploymentTemplatesTemplateApmArgs' apm: Defines the default configuration for a stateless application (Kibana, Enterprise Search, APM or Integrations Server).
        :param builtins.bool deprecated: Outdated templates are marked as deprecated, but can still be used.
        :param builtins.str description: The description of the deployment template.
        :param 'GetDeploymentTemplatesTemplateElasticsearchArgs' elasticsearch: Defines the default configuration for Elasticsearch.
        :param 'GetDeploymentTemplatesTemplateEnterpriseSearchArgs' enterprise_search: Defines the default configuration for a stateless application (Kibana, Enterprise Search, APM or Integrations Server).
        :param builtins.str id: The id of the deployment template.
        :param 'GetDeploymentTemplatesTemplateIntegrationsServerArgs' integrations_server: Defines the default configuration for a stateless application (Kibana, Enterprise Search, APM or Integrations Server).
        :param 'GetDeploymentTemplatesTemplateKibanaArgs' kibana: Defines the default configuration for a stateless application (Kibana, Enterprise Search, APM or Integrations Server).
        :param builtins.str min_stack_version: The minimum stack version that can used with this deployment template.
        :param builtins.str name: The name of the deployment template.
        """
        pulumi.set(__self__, "apm", apm)
        pulumi.set(__self__, "deprecated", deprecated)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "elasticsearch", elasticsearch)
        pulumi.set(__self__, "enterprise_search", enterprise_search)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "integrations_server", integrations_server)
        pulumi.set(__self__, "kibana", kibana)
        pulumi.set(__self__, "min_stack_version", min_stack_version)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def apm(self) -> 'outputs.GetDeploymentTemplatesTemplateApmResult':
        """
        Defines the default configuration for a stateless application (Kibana, Enterprise Search, APM or Integrations Server).
        """
        return pulumi.get(self, "apm")

    @property
    @pulumi.getter
    def deprecated(self) -> builtins.bool:
        """
        Outdated templates are marked as deprecated, but can still be used.
        """
        return pulumi.get(self, "deprecated")

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the deployment template.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def elasticsearch(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchResult':
        """
        Defines the default configuration for Elasticsearch.
        """
        return pulumi.get(self, "elasticsearch")

    @property
    @pulumi.getter(name="enterpriseSearch")
    def enterprise_search(self) -> 'outputs.GetDeploymentTemplatesTemplateEnterpriseSearchResult':
        """
        Defines the default configuration for a stateless application (Kibana, Enterprise Search, APM or Integrations Server).
        """
        return pulumi.get(self, "enterprise_search")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The id of the deployment template.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="integrationsServer")
    def integrations_server(self) -> 'outputs.GetDeploymentTemplatesTemplateIntegrationsServerResult':
        """
        Defines the default configuration for a stateless application (Kibana, Enterprise Search, APM or Integrations Server).
        """
        return pulumi.get(self, "integrations_server")

    @property
    @pulumi.getter
    def kibana(self) -> 'outputs.GetDeploymentTemplatesTemplateKibanaResult':
        """
        Defines the default configuration for a stateless application (Kibana, Enterprise Search, APM or Integrations Server).
        """
        return pulumi.get(self, "kibana")

    @property
    @pulumi.getter(name="minStackVersion")
    def min_stack_version(self) -> builtins.str:
        """
        The minimum stack version that can used with this deployment template.
        """
        return pulumi.get(self, "min_stack_version")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the deployment template.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDeploymentTemplatesTemplateApmResult(dict):
    def __init__(__self__, *,
                 available_sizes: Sequence[builtins.str],
                 default_size: builtins.str,
                 instance_configuration_id: builtins.str,
                 instance_configuration_version: builtins.float,
                 size_resource: builtins.str):
        pulumi.set(__self__, "available_sizes", available_sizes)
        pulumi.set(__self__, "default_size", default_size)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        pulumi.set(__self__, "size_resource", size_resource)

    @property
    @pulumi.getter(name="availableSizes")
    def available_sizes(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "available_sizes")

    @property
    @pulumi.getter(name="defaultSize")
    def default_size(self) -> builtins.str:
        return pulumi.get(self, "default_size")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> builtins.float:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        return pulumi.get(self, "size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchResult(dict):
    def __init__(__self__, *,
                 autoscale: builtins.bool,
                 cold: 'outputs.GetDeploymentTemplatesTemplateElasticsearchColdResult',
                 coordinating: 'outputs.GetDeploymentTemplatesTemplateElasticsearchCoordinatingResult',
                 frozen: 'outputs.GetDeploymentTemplatesTemplateElasticsearchFrozenResult',
                 hot: 'outputs.GetDeploymentTemplatesTemplateElasticsearchHotResult',
                 master: 'outputs.GetDeploymentTemplatesTemplateElasticsearchMasterResult',
                 ml: 'outputs.GetDeploymentTemplatesTemplateElasticsearchMlResult',
                 warm: 'outputs.GetDeploymentTemplatesTemplateElasticsearchWarmResult'):
        """
        :param 'GetDeploymentTemplatesTemplateElasticsearchColdArgs' cold: Defines the default configuration for each topology.
        :param 'GetDeploymentTemplatesTemplateElasticsearchCoordinatingArgs' coordinating: Defines the default configuration for each topology.
        :param 'GetDeploymentTemplatesTemplateElasticsearchFrozenArgs' frozen: Defines the default configuration for each topology.
        :param 'GetDeploymentTemplatesTemplateElasticsearchHotArgs' hot: Defines the default configuration for each topology.
        :param 'GetDeploymentTemplatesTemplateElasticsearchMasterArgs' master: Defines the default configuration for each topology.
        :param 'GetDeploymentTemplatesTemplateElasticsearchMlArgs' ml: Defines the default configuration for each topology.
        :param 'GetDeploymentTemplatesTemplateElasticsearchWarmArgs' warm: Defines the default configuration for each topology.
        """
        pulumi.set(__self__, "autoscale", autoscale)
        pulumi.set(__self__, "cold", cold)
        pulumi.set(__self__, "coordinating", coordinating)
        pulumi.set(__self__, "frozen", frozen)
        pulumi.set(__self__, "hot", hot)
        pulumi.set(__self__, "master", master)
        pulumi.set(__self__, "ml", ml)
        pulumi.set(__self__, "warm", warm)

    @property
    @pulumi.getter
    def autoscale(self) -> builtins.bool:
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter
    def cold(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchColdResult':
        """
        Defines the default configuration for each topology.
        """
        return pulumi.get(self, "cold")

    @property
    @pulumi.getter
    def coordinating(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchCoordinatingResult':
        """
        Defines the default configuration for each topology.
        """
        return pulumi.get(self, "coordinating")

    @property
    @pulumi.getter
    def frozen(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchFrozenResult':
        """
        Defines the default configuration for each topology.
        """
        return pulumi.get(self, "frozen")

    @property
    @pulumi.getter
    def hot(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchHotResult':
        """
        Defines the default configuration for each topology.
        """
        return pulumi.get(self, "hot")

    @property
    @pulumi.getter
    def master(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchMasterResult':
        """
        Defines the default configuration for each topology.
        """
        return pulumi.get(self, "master")

    @property
    @pulumi.getter
    def ml(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchMlResult':
        """
        Defines the default configuration for each topology.
        """
        return pulumi.get(self, "ml")

    @property
    @pulumi.getter
    def warm(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchWarmResult':
        """
        Defines the default configuration for each topology.
        """
        return pulumi.get(self, "warm")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchColdResult(dict):
    def __init__(__self__, *,
                 autoscaling: 'outputs.GetDeploymentTemplatesTemplateElasticsearchColdAutoscalingResult',
                 available_sizes: Sequence[builtins.str],
                 default_size: builtins.str,
                 instance_configuration_id: builtins.str,
                 instance_configuration_version: builtins.float,
                 size_resource: builtins.str):
        pulumi.set(__self__, "autoscaling", autoscaling)
        pulumi.set(__self__, "available_sizes", available_sizes)
        pulumi.set(__self__, "default_size", default_size)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        pulumi.set(__self__, "size_resource", size_resource)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchColdAutoscalingResult':
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="availableSizes")
    def available_sizes(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "available_sizes")

    @property
    @pulumi.getter(name="defaultSize")
    def default_size(self) -> builtins.str:
        return pulumi.get(self, "default_size")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> builtins.float:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        return pulumi.get(self, "size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchColdAutoscalingResult(dict):
    def __init__(__self__, *,
                 autoscale: builtins.bool,
                 max_size: builtins.str,
                 max_size_resource: builtins.str,
                 min_size: builtins.str,
                 min_size_resource: builtins.str):
        pulumi.set(__self__, "autoscale", autoscale)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "max_size_resource", max_size_resource)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "min_size_resource", min_size_resource)

    @property
    @pulumi.getter
    def autoscale(self) -> builtins.bool:
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> builtins.str:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> builtins.str:
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> builtins.str:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> builtins.str:
        return pulumi.get(self, "min_size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchCoordinatingResult(dict):
    def __init__(__self__, *,
                 autoscaling: 'outputs.GetDeploymentTemplatesTemplateElasticsearchCoordinatingAutoscalingResult',
                 available_sizes: Sequence[builtins.str],
                 default_size: builtins.str,
                 instance_configuration_id: builtins.str,
                 instance_configuration_version: builtins.float,
                 size_resource: builtins.str):
        pulumi.set(__self__, "autoscaling", autoscaling)
        pulumi.set(__self__, "available_sizes", available_sizes)
        pulumi.set(__self__, "default_size", default_size)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        pulumi.set(__self__, "size_resource", size_resource)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchCoordinatingAutoscalingResult':
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="availableSizes")
    def available_sizes(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "available_sizes")

    @property
    @pulumi.getter(name="defaultSize")
    def default_size(self) -> builtins.str:
        return pulumi.get(self, "default_size")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> builtins.float:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        return pulumi.get(self, "size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchCoordinatingAutoscalingResult(dict):
    def __init__(__self__, *,
                 autoscale: builtins.bool,
                 max_size: builtins.str,
                 max_size_resource: builtins.str,
                 min_size: builtins.str,
                 min_size_resource: builtins.str):
        pulumi.set(__self__, "autoscale", autoscale)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "max_size_resource", max_size_resource)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "min_size_resource", min_size_resource)

    @property
    @pulumi.getter
    def autoscale(self) -> builtins.bool:
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> builtins.str:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> builtins.str:
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> builtins.str:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> builtins.str:
        return pulumi.get(self, "min_size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchFrozenResult(dict):
    def __init__(__self__, *,
                 autoscaling: 'outputs.GetDeploymentTemplatesTemplateElasticsearchFrozenAutoscalingResult',
                 available_sizes: Sequence[builtins.str],
                 default_size: builtins.str,
                 instance_configuration_id: builtins.str,
                 instance_configuration_version: builtins.float,
                 size_resource: builtins.str):
        pulumi.set(__self__, "autoscaling", autoscaling)
        pulumi.set(__self__, "available_sizes", available_sizes)
        pulumi.set(__self__, "default_size", default_size)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        pulumi.set(__self__, "size_resource", size_resource)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchFrozenAutoscalingResult':
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="availableSizes")
    def available_sizes(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "available_sizes")

    @property
    @pulumi.getter(name="defaultSize")
    def default_size(self) -> builtins.str:
        return pulumi.get(self, "default_size")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> builtins.float:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        return pulumi.get(self, "size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchFrozenAutoscalingResult(dict):
    def __init__(__self__, *,
                 autoscale: builtins.bool,
                 max_size: builtins.str,
                 max_size_resource: builtins.str,
                 min_size: builtins.str,
                 min_size_resource: builtins.str):
        pulumi.set(__self__, "autoscale", autoscale)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "max_size_resource", max_size_resource)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "min_size_resource", min_size_resource)

    @property
    @pulumi.getter
    def autoscale(self) -> builtins.bool:
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> builtins.str:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> builtins.str:
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> builtins.str:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> builtins.str:
        return pulumi.get(self, "min_size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchHotResult(dict):
    def __init__(__self__, *,
                 autoscaling: 'outputs.GetDeploymentTemplatesTemplateElasticsearchHotAutoscalingResult',
                 available_sizes: Sequence[builtins.str],
                 default_size: builtins.str,
                 instance_configuration_id: builtins.str,
                 instance_configuration_version: builtins.float,
                 size_resource: builtins.str):
        pulumi.set(__self__, "autoscaling", autoscaling)
        pulumi.set(__self__, "available_sizes", available_sizes)
        pulumi.set(__self__, "default_size", default_size)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        pulumi.set(__self__, "size_resource", size_resource)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchHotAutoscalingResult':
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="availableSizes")
    def available_sizes(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "available_sizes")

    @property
    @pulumi.getter(name="defaultSize")
    def default_size(self) -> builtins.str:
        return pulumi.get(self, "default_size")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> builtins.float:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        return pulumi.get(self, "size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchHotAutoscalingResult(dict):
    def __init__(__self__, *,
                 autoscale: builtins.bool,
                 max_size: builtins.str,
                 max_size_resource: builtins.str,
                 min_size: builtins.str,
                 min_size_resource: builtins.str):
        pulumi.set(__self__, "autoscale", autoscale)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "max_size_resource", max_size_resource)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "min_size_resource", min_size_resource)

    @property
    @pulumi.getter
    def autoscale(self) -> builtins.bool:
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> builtins.str:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> builtins.str:
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> builtins.str:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> builtins.str:
        return pulumi.get(self, "min_size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchMasterResult(dict):
    def __init__(__self__, *,
                 autoscaling: 'outputs.GetDeploymentTemplatesTemplateElasticsearchMasterAutoscalingResult',
                 available_sizes: Sequence[builtins.str],
                 default_size: builtins.str,
                 instance_configuration_id: builtins.str,
                 instance_configuration_version: builtins.float,
                 size_resource: builtins.str):
        pulumi.set(__self__, "autoscaling", autoscaling)
        pulumi.set(__self__, "available_sizes", available_sizes)
        pulumi.set(__self__, "default_size", default_size)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        pulumi.set(__self__, "size_resource", size_resource)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchMasterAutoscalingResult':
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="availableSizes")
    def available_sizes(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "available_sizes")

    @property
    @pulumi.getter(name="defaultSize")
    def default_size(self) -> builtins.str:
        return pulumi.get(self, "default_size")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> builtins.float:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        return pulumi.get(self, "size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchMasterAutoscalingResult(dict):
    def __init__(__self__, *,
                 autoscale: builtins.bool,
                 max_size: builtins.str,
                 max_size_resource: builtins.str,
                 min_size: builtins.str,
                 min_size_resource: builtins.str):
        pulumi.set(__self__, "autoscale", autoscale)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "max_size_resource", max_size_resource)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "min_size_resource", min_size_resource)

    @property
    @pulumi.getter
    def autoscale(self) -> builtins.bool:
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> builtins.str:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> builtins.str:
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> builtins.str:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> builtins.str:
        return pulumi.get(self, "min_size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchMlResult(dict):
    def __init__(__self__, *,
                 autoscaling: 'outputs.GetDeploymentTemplatesTemplateElasticsearchMlAutoscalingResult',
                 available_sizes: Sequence[builtins.str],
                 default_size: builtins.str,
                 instance_configuration_id: builtins.str,
                 instance_configuration_version: builtins.float,
                 size_resource: builtins.str):
        pulumi.set(__self__, "autoscaling", autoscaling)
        pulumi.set(__self__, "available_sizes", available_sizes)
        pulumi.set(__self__, "default_size", default_size)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        pulumi.set(__self__, "size_resource", size_resource)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchMlAutoscalingResult':
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="availableSizes")
    def available_sizes(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "available_sizes")

    @property
    @pulumi.getter(name="defaultSize")
    def default_size(self) -> builtins.str:
        return pulumi.get(self, "default_size")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> builtins.float:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        return pulumi.get(self, "size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchMlAutoscalingResult(dict):
    def __init__(__self__, *,
                 autoscale: builtins.bool,
                 max_size: builtins.str,
                 max_size_resource: builtins.str,
                 min_size: builtins.str,
                 min_size_resource: builtins.str):
        pulumi.set(__self__, "autoscale", autoscale)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "max_size_resource", max_size_resource)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "min_size_resource", min_size_resource)

    @property
    @pulumi.getter
    def autoscale(self) -> builtins.bool:
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> builtins.str:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> builtins.str:
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> builtins.str:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> builtins.str:
        return pulumi.get(self, "min_size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchWarmResult(dict):
    def __init__(__self__, *,
                 autoscaling: 'outputs.GetDeploymentTemplatesTemplateElasticsearchWarmAutoscalingResult',
                 available_sizes: Sequence[builtins.str],
                 default_size: builtins.str,
                 instance_configuration_id: builtins.str,
                 instance_configuration_version: builtins.float,
                 size_resource: builtins.str):
        pulumi.set(__self__, "autoscaling", autoscaling)
        pulumi.set(__self__, "available_sizes", available_sizes)
        pulumi.set(__self__, "default_size", default_size)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        pulumi.set(__self__, "size_resource", size_resource)

    @property
    @pulumi.getter
    def autoscaling(self) -> 'outputs.GetDeploymentTemplatesTemplateElasticsearchWarmAutoscalingResult':
        return pulumi.get(self, "autoscaling")

    @property
    @pulumi.getter(name="availableSizes")
    def available_sizes(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "available_sizes")

    @property
    @pulumi.getter(name="defaultSize")
    def default_size(self) -> builtins.str:
        return pulumi.get(self, "default_size")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> builtins.float:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        return pulumi.get(self, "size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateElasticsearchWarmAutoscalingResult(dict):
    def __init__(__self__, *,
                 autoscale: builtins.bool,
                 max_size: builtins.str,
                 max_size_resource: builtins.str,
                 min_size: builtins.str,
                 min_size_resource: builtins.str):
        pulumi.set(__self__, "autoscale", autoscale)
        pulumi.set(__self__, "max_size", max_size)
        pulumi.set(__self__, "max_size_resource", max_size_resource)
        pulumi.set(__self__, "min_size", min_size)
        pulumi.set(__self__, "min_size_resource", min_size_resource)

    @property
    @pulumi.getter
    def autoscale(self) -> builtins.bool:
        return pulumi.get(self, "autoscale")

    @property
    @pulumi.getter(name="maxSize")
    def max_size(self) -> builtins.str:
        return pulumi.get(self, "max_size")

    @property
    @pulumi.getter(name="maxSizeResource")
    def max_size_resource(self) -> builtins.str:
        return pulumi.get(self, "max_size_resource")

    @property
    @pulumi.getter(name="minSize")
    def min_size(self) -> builtins.str:
        return pulumi.get(self, "min_size")

    @property
    @pulumi.getter(name="minSizeResource")
    def min_size_resource(self) -> builtins.str:
        return pulumi.get(self, "min_size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateEnterpriseSearchResult(dict):
    def __init__(__self__, *,
                 available_sizes: Sequence[builtins.str],
                 default_size: builtins.str,
                 instance_configuration_id: builtins.str,
                 instance_configuration_version: builtins.float,
                 size_resource: builtins.str):
        pulumi.set(__self__, "available_sizes", available_sizes)
        pulumi.set(__self__, "default_size", default_size)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        pulumi.set(__self__, "size_resource", size_resource)

    @property
    @pulumi.getter(name="availableSizes")
    def available_sizes(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "available_sizes")

    @property
    @pulumi.getter(name="defaultSize")
    def default_size(self) -> builtins.str:
        return pulumi.get(self, "default_size")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> builtins.float:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        return pulumi.get(self, "size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateIntegrationsServerResult(dict):
    def __init__(__self__, *,
                 available_sizes: Sequence[builtins.str],
                 default_size: builtins.str,
                 instance_configuration_id: builtins.str,
                 instance_configuration_version: builtins.float,
                 size_resource: builtins.str):
        pulumi.set(__self__, "available_sizes", available_sizes)
        pulumi.set(__self__, "default_size", default_size)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        pulumi.set(__self__, "size_resource", size_resource)

    @property
    @pulumi.getter(name="availableSizes")
    def available_sizes(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "available_sizes")

    @property
    @pulumi.getter(name="defaultSize")
    def default_size(self) -> builtins.str:
        return pulumi.get(self, "default_size")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> builtins.float:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        return pulumi.get(self, "size_resource")


@pulumi.output_type
class GetDeploymentTemplatesTemplateKibanaResult(dict):
    def __init__(__self__, *,
                 available_sizes: Sequence[builtins.str],
                 default_size: builtins.str,
                 instance_configuration_id: builtins.str,
                 instance_configuration_version: builtins.float,
                 size_resource: builtins.str):
        pulumi.set(__self__, "available_sizes", available_sizes)
        pulumi.set(__self__, "default_size", default_size)
        pulumi.set(__self__, "instance_configuration_id", instance_configuration_id)
        pulumi.set(__self__, "instance_configuration_version", instance_configuration_version)
        pulumi.set(__self__, "size_resource", size_resource)

    @property
    @pulumi.getter(name="availableSizes")
    def available_sizes(self) -> Sequence[builtins.str]:
        return pulumi.get(self, "available_sizes")

    @property
    @pulumi.getter(name="defaultSize")
    def default_size(self) -> builtins.str:
        return pulumi.get(self, "default_size")

    @property
    @pulumi.getter(name="instanceConfigurationId")
    def instance_configuration_id(self) -> builtins.str:
        return pulumi.get(self, "instance_configuration_id")

    @property
    @pulumi.getter(name="instanceConfigurationVersion")
    def instance_configuration_version(self) -> builtins.float:
        return pulumi.get(self, "instance_configuration_version")

    @property
    @pulumi.getter(name="sizeResource")
    def size_resource(self) -> builtins.str:
        return pulumi.get(self, "size_resource")


@pulumi.output_type
class GetDeploymentsApmResult(dict):
    def __init__(__self__, *,
                 healthy: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str healthy: Overall health status of the resource instances.
        :param builtins.str status: Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        :param builtins.str version: Elastic stack version.
        """
        if healthy is not None:
            pulumi.set(__self__, "healthy", healthy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def healthy(self) -> Optional[builtins.str]:
        """
        Overall health status of the resource instances.
        """
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDeploymentsDeploymentResult(dict):
    def __init__(__self__, *,
                 alias: builtins.str,
                 apm_ref_id: builtins.str,
                 apm_resource_id: builtins.str,
                 deployment_id: builtins.str,
                 elasticsearch_ref_id: builtins.str,
                 elasticsearch_resource_id: builtins.str,
                 enterprise_search_ref_id: builtins.str,
                 enterprise_search_resource_id: builtins.str,
                 integrations_server_ref_id: builtins.str,
                 integrations_server_resource_id: builtins.str,
                 kibana_ref_id: builtins.str,
                 kibana_resource_id: builtins.str,
                 name: builtins.str):
        """
        :param builtins.str alias: Deployment alias.
        :param builtins.str apm_ref_id: The APM resource reference.
        :param builtins.str apm_resource_id: The APM resource unique ID.
        :param builtins.str deployment_id: The deployment unique ID.
        :param builtins.str elasticsearch_ref_id: The Elasticsearch resource reference.
        :param builtins.str elasticsearch_resource_id: The Elasticsearch resource unique ID.
        :param builtins.str enterprise_search_ref_id: The Enterprise Search resource reference.
        :param builtins.str enterprise_search_resource_id: The Enterprise Search resource unique ID.
        :param builtins.str integrations_server_ref_id: The Integrations Server resource reference.
        :param builtins.str integrations_server_resource_id: The Integrations Server resource unique ID.
        :param builtins.str kibana_ref_id: The Kibana resource reference.
        :param builtins.str kibana_resource_id: The Kibana resource unique ID.
        :param builtins.str name: The name of the deployment.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "apm_ref_id", apm_ref_id)
        pulumi.set(__self__, "apm_resource_id", apm_resource_id)
        pulumi.set(__self__, "deployment_id", deployment_id)
        pulumi.set(__self__, "elasticsearch_ref_id", elasticsearch_ref_id)
        pulumi.set(__self__, "elasticsearch_resource_id", elasticsearch_resource_id)
        pulumi.set(__self__, "enterprise_search_ref_id", enterprise_search_ref_id)
        pulumi.set(__self__, "enterprise_search_resource_id", enterprise_search_resource_id)
        pulumi.set(__self__, "integrations_server_ref_id", integrations_server_ref_id)
        pulumi.set(__self__, "integrations_server_resource_id", integrations_server_resource_id)
        pulumi.set(__self__, "kibana_ref_id", kibana_ref_id)
        pulumi.set(__self__, "kibana_resource_id", kibana_resource_id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def alias(self) -> builtins.str:
        """
        Deployment alias.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter(name="apmRefId")
    def apm_ref_id(self) -> builtins.str:
        """
        The APM resource reference.
        """
        return pulumi.get(self, "apm_ref_id")

    @property
    @pulumi.getter(name="apmResourceId")
    def apm_resource_id(self) -> builtins.str:
        """
        The APM resource unique ID.
        """
        return pulumi.get(self, "apm_resource_id")

    @property
    @pulumi.getter(name="deploymentId")
    def deployment_id(self) -> builtins.str:
        """
        The deployment unique ID.
        """
        return pulumi.get(self, "deployment_id")

    @property
    @pulumi.getter(name="elasticsearchRefId")
    def elasticsearch_ref_id(self) -> builtins.str:
        """
        The Elasticsearch resource reference.
        """
        return pulumi.get(self, "elasticsearch_ref_id")

    @property
    @pulumi.getter(name="elasticsearchResourceId")
    def elasticsearch_resource_id(self) -> builtins.str:
        """
        The Elasticsearch resource unique ID.
        """
        return pulumi.get(self, "elasticsearch_resource_id")

    @property
    @pulumi.getter(name="enterpriseSearchRefId")
    def enterprise_search_ref_id(self) -> builtins.str:
        """
        The Enterprise Search resource reference.
        """
        return pulumi.get(self, "enterprise_search_ref_id")

    @property
    @pulumi.getter(name="enterpriseSearchResourceId")
    def enterprise_search_resource_id(self) -> builtins.str:
        """
        The Enterprise Search resource unique ID.
        """
        return pulumi.get(self, "enterprise_search_resource_id")

    @property
    @pulumi.getter(name="integrationsServerRefId")
    def integrations_server_ref_id(self) -> builtins.str:
        """
        The Integrations Server resource reference.
        """
        return pulumi.get(self, "integrations_server_ref_id")

    @property
    @pulumi.getter(name="integrationsServerResourceId")
    def integrations_server_resource_id(self) -> builtins.str:
        """
        The Integrations Server resource unique ID.
        """
        return pulumi.get(self, "integrations_server_resource_id")

    @property
    @pulumi.getter(name="kibanaRefId")
    def kibana_ref_id(self) -> builtins.str:
        """
        The Kibana resource reference.
        """
        return pulumi.get(self, "kibana_ref_id")

    @property
    @pulumi.getter(name="kibanaResourceId")
    def kibana_resource_id(self) -> builtins.str:
        """
        The Kibana resource unique ID.
        """
        return pulumi.get(self, "kibana_resource_id")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the deployment.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class GetDeploymentsElasticsearchResult(dict):
    def __init__(__self__, *,
                 healthy: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str healthy: Overall health status of the resource instances.
        :param builtins.str status: Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        :param builtins.str version: Elastic stack version.
        """
        if healthy is not None:
            pulumi.set(__self__, "healthy", healthy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def healthy(self) -> Optional[builtins.str]:
        """
        Overall health status of the resource instances.
        """
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDeploymentsEnterpriseSearchResult(dict):
    def __init__(__self__, *,
                 healthy: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str healthy: Overall health status of the resource instances.
        :param builtins.str status: Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        :param builtins.str version: Elastic stack version.
        """
        if healthy is not None:
            pulumi.set(__self__, "healthy", healthy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def healthy(self) -> Optional[builtins.str]:
        """
        Overall health status of the resource instances.
        """
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDeploymentsIntegrationsServerResult(dict):
    def __init__(__self__, *,
                 healthy: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str healthy: Overall health status of the resource instances.
        :param builtins.str status: Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        :param builtins.str version: Elastic stack version.
        """
        if healthy is not None:
            pulumi.set(__self__, "healthy", healthy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def healthy(self) -> Optional[builtins.str]:
        """
        Overall health status of the resource instances.
        """
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDeploymentsKibanaResult(dict):
    def __init__(__self__, *,
                 healthy: Optional[builtins.str] = None,
                 status: Optional[builtins.str] = None,
                 version: Optional[builtins.str] = None):
        """
        :param builtins.str healthy: Overall health status of the resource instances.
        :param builtins.str status: Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        :param builtins.str version: Elastic stack version.
        """
        if healthy is not None:
            pulumi.set(__self__, "healthy", healthy)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def healthy(self) -> Optional[builtins.str]:
        """
        Overall health status of the resource instances.
        """
        return pulumi.get(self, "healthy")

    @property
    @pulumi.getter
    def status(self) -> Optional[builtins.str]:
        """
        Resource kind status. Can be one of `initializing`, `stopping`, `stopped`, `rebooting`, `restarting`.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def version(self) -> Optional[builtins.str]:
        """
        Elastic stack version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetStackApmResult(dict):
    def __init__(__self__, *,
                 capacity_constraints_max: builtins.int,
                 capacity_constraints_min: builtins.int,
                 compatible_node_types: Sequence[builtins.str],
                 denylists: Sequence[builtins.str],
                 docker_image: builtins.str):
        """
        :param builtins.int capacity_constraints_max: Maximum size of the instances.
        :param builtins.int capacity_constraints_min: Minimum size of the instances.
        :param Sequence[builtins.str] compatible_node_types: List of node types compatible with this one.
        :param Sequence[builtins.str] denylists: List of configuration options that cannot be overridden by user settings.
        :param builtins.str docker_image: Docker image to use for the APM instance.
        """
        pulumi.set(__self__, "capacity_constraints_max", capacity_constraints_max)
        pulumi.set(__self__, "capacity_constraints_min", capacity_constraints_min)
        pulumi.set(__self__, "compatible_node_types", compatible_node_types)
        pulumi.set(__self__, "denylists", denylists)
        pulumi.set(__self__, "docker_image", docker_image)

    @property
    @pulumi.getter(name="capacityConstraintsMax")
    def capacity_constraints_max(self) -> builtins.int:
        """
        Maximum size of the instances.
        """
        return pulumi.get(self, "capacity_constraints_max")

    @property
    @pulumi.getter(name="capacityConstraintsMin")
    def capacity_constraints_min(self) -> builtins.int:
        """
        Minimum size of the instances.
        """
        return pulumi.get(self, "capacity_constraints_min")

    @property
    @pulumi.getter(name="compatibleNodeTypes")
    def compatible_node_types(self) -> Sequence[builtins.str]:
        """
        List of node types compatible with this one.
        """
        return pulumi.get(self, "compatible_node_types")

    @property
    @pulumi.getter
    def denylists(self) -> Sequence[builtins.str]:
        """
        List of configuration options that cannot be overridden by user settings.
        """
        return pulumi.get(self, "denylists")

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> builtins.str:
        """
        Docker image to use for the APM instance.
        """
        return pulumi.get(self, "docker_image")


@pulumi.output_type
class GetStackElasticsearchResult(dict):
    def __init__(__self__, *,
                 capacity_constraints_max: builtins.int,
                 capacity_constraints_min: builtins.int,
                 compatible_node_types: Sequence[builtins.str],
                 default_plugins: Sequence[builtins.str],
                 denylists: Sequence[builtins.str],
                 docker_image: builtins.str,
                 plugins: Sequence[builtins.str]):
        """
        :param builtins.int capacity_constraints_max: Maximum size of the instances.
        :param builtins.int capacity_constraints_min: Minimum size of the instances.
        :param Sequence[builtins.str] compatible_node_types: List of node types compatible with this one.
        :param Sequence[builtins.str] default_plugins: List of default plugins.
        :param Sequence[builtins.str] denylists: List of configuration options that cannot be overridden by user settings.
        :param builtins.str docker_image: Docker image to use for the Elasticsearch cluster instances.
        :param Sequence[builtins.str] plugins: List of available plugins to be specified by users in Elasticsearch cluster instances.
        """
        pulumi.set(__self__, "capacity_constraints_max", capacity_constraints_max)
        pulumi.set(__self__, "capacity_constraints_min", capacity_constraints_min)
        pulumi.set(__self__, "compatible_node_types", compatible_node_types)
        pulumi.set(__self__, "default_plugins", default_plugins)
        pulumi.set(__self__, "denylists", denylists)
        pulumi.set(__self__, "docker_image", docker_image)
        pulumi.set(__self__, "plugins", plugins)

    @property
    @pulumi.getter(name="capacityConstraintsMax")
    def capacity_constraints_max(self) -> builtins.int:
        """
        Maximum size of the instances.
        """
        return pulumi.get(self, "capacity_constraints_max")

    @property
    @pulumi.getter(name="capacityConstraintsMin")
    def capacity_constraints_min(self) -> builtins.int:
        """
        Minimum size of the instances.
        """
        return pulumi.get(self, "capacity_constraints_min")

    @property
    @pulumi.getter(name="compatibleNodeTypes")
    def compatible_node_types(self) -> Sequence[builtins.str]:
        """
        List of node types compatible with this one.
        """
        return pulumi.get(self, "compatible_node_types")

    @property
    @pulumi.getter(name="defaultPlugins")
    def default_plugins(self) -> Sequence[builtins.str]:
        """
        List of default plugins.
        """
        return pulumi.get(self, "default_plugins")

    @property
    @pulumi.getter
    def denylists(self) -> Sequence[builtins.str]:
        """
        List of configuration options that cannot be overridden by user settings.
        """
        return pulumi.get(self, "denylists")

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> builtins.str:
        """
        Docker image to use for the Elasticsearch cluster instances.
        """
        return pulumi.get(self, "docker_image")

    @property
    @pulumi.getter
    def plugins(self) -> Sequence[builtins.str]:
        """
        List of available plugins to be specified by users in Elasticsearch cluster instances.
        """
        return pulumi.get(self, "plugins")


@pulumi.output_type
class GetStackEnterpriseSearchResult(dict):
    def __init__(__self__, *,
                 capacity_constraints_max: builtins.int,
                 capacity_constraints_min: builtins.int,
                 compatible_node_types: Sequence[builtins.str],
                 denylists: Sequence[builtins.str],
                 docker_image: builtins.str):
        """
        :param builtins.int capacity_constraints_max: Maximum size of the instances.
        :param builtins.int capacity_constraints_min: Minimum size of the instances.
        :param Sequence[builtins.str] compatible_node_types: List of node types compatible with this one.
        :param Sequence[builtins.str] denylists: List of configuration options that cannot be overridden by user settings.
        :param builtins.str docker_image: Docker image to use for the Enterprise Search instance.
        """
        pulumi.set(__self__, "capacity_constraints_max", capacity_constraints_max)
        pulumi.set(__self__, "capacity_constraints_min", capacity_constraints_min)
        pulumi.set(__self__, "compatible_node_types", compatible_node_types)
        pulumi.set(__self__, "denylists", denylists)
        pulumi.set(__self__, "docker_image", docker_image)

    @property
    @pulumi.getter(name="capacityConstraintsMax")
    def capacity_constraints_max(self) -> builtins.int:
        """
        Maximum size of the instances.
        """
        return pulumi.get(self, "capacity_constraints_max")

    @property
    @pulumi.getter(name="capacityConstraintsMin")
    def capacity_constraints_min(self) -> builtins.int:
        """
        Minimum size of the instances.
        """
        return pulumi.get(self, "capacity_constraints_min")

    @property
    @pulumi.getter(name="compatibleNodeTypes")
    def compatible_node_types(self) -> Sequence[builtins.str]:
        """
        List of node types compatible with this one.
        """
        return pulumi.get(self, "compatible_node_types")

    @property
    @pulumi.getter
    def denylists(self) -> Sequence[builtins.str]:
        """
        List of configuration options that cannot be overridden by user settings.
        """
        return pulumi.get(self, "denylists")

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> builtins.str:
        """
        Docker image to use for the Enterprise Search instance.
        """
        return pulumi.get(self, "docker_image")


@pulumi.output_type
class GetStackKibanaResult(dict):
    def __init__(__self__, *,
                 capacity_constraints_max: builtins.int,
                 capacity_constraints_min: builtins.int,
                 compatible_node_types: Sequence[builtins.str],
                 denylists: Sequence[builtins.str],
                 docker_image: builtins.str):
        """
        :param builtins.int capacity_constraints_max: Maximum size of the instances.
        :param builtins.int capacity_constraints_min: Minimum size of the instances.
        :param Sequence[builtins.str] compatible_node_types: List of node types compatible with this one.
        :param Sequence[builtins.str] denylists: List of configuration options that cannot be overridden by user settings.
        :param builtins.str docker_image: Docker image to use for the Kibana instance.
        """
        pulumi.set(__self__, "capacity_constraints_max", capacity_constraints_max)
        pulumi.set(__self__, "capacity_constraints_min", capacity_constraints_min)
        pulumi.set(__self__, "compatible_node_types", compatible_node_types)
        pulumi.set(__self__, "denylists", denylists)
        pulumi.set(__self__, "docker_image", docker_image)

    @property
    @pulumi.getter(name="capacityConstraintsMax")
    def capacity_constraints_max(self) -> builtins.int:
        """
        Maximum size of the instances.
        """
        return pulumi.get(self, "capacity_constraints_max")

    @property
    @pulumi.getter(name="capacityConstraintsMin")
    def capacity_constraints_min(self) -> builtins.int:
        """
        Minimum size of the instances.
        """
        return pulumi.get(self, "capacity_constraints_min")

    @property
    @pulumi.getter(name="compatibleNodeTypes")
    def compatible_node_types(self) -> Sequence[builtins.str]:
        """
        List of node types compatible with this one.
        """
        return pulumi.get(self, "compatible_node_types")

    @property
    @pulumi.getter
    def denylists(self) -> Sequence[builtins.str]:
        """
        List of configuration options that cannot be overridden by user settings.
        """
        return pulumi.get(self, "denylists")

    @property
    @pulumi.getter(name="dockerImage")
    def docker_image(self) -> builtins.str:
        """
        Docker image to use for the Kibana instance.
        """
        return pulumi.get(self, "docker_image")


@pulumi.output_type
class GetTrafficFilterRulesetResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 id: builtins.str,
                 include_by_default: builtins.bool,
                 name: builtins.str,
                 region: builtins.str,
                 rules: Sequence['outputs.GetTrafficFilterRulesetRuleResult']):
        """
        :param builtins.str description: The description of the ruleset.
        :param builtins.str id: The ID of the ruleset
        :param builtins.bool include_by_default: Should the ruleset be automatically included in the new deployments.
        :param builtins.str name: The name of the ruleset.
        :param builtins.str region: The ruleset can be attached only to deployments in the specific region.
        :param Sequence['GetTrafficFilterRulesetRuleArgs'] rules: An individual rule
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "include_by_default", include_by_default)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "rules", rules)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the ruleset.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the ruleset
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="includeByDefault")
    def include_by_default(self) -> builtins.bool:
        """
        Should the ruleset be automatically included in the new deployments.
        """
        return pulumi.get(self, "include_by_default")

    @property
    @pulumi.getter
    def name(self) -> builtins.str:
        """
        The name of the ruleset.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> builtins.str:
        """
        The ruleset can be attached only to deployments in the specific region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GetTrafficFilterRulesetRuleResult']:
        """
        An individual rule
        """
        return pulumi.get(self, "rules")


@pulumi.output_type
class GetTrafficFilterRulesetRuleResult(dict):
    def __init__(__self__, *,
                 description: builtins.str,
                 id: builtins.str,
                 source: builtins.str):
        """
        :param builtins.str description: The description of the rule.
        :param builtins.str id: The ID of the rule
        :param builtins.str source: Allowed traffic filter source: IP address, CIDR mask, or VPC endpoint ID.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "source", source)

    @property
    @pulumi.getter
    def description(self) -> builtins.str:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The ID of the rule
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def source(self) -> builtins.str:
        """
        Allowed traffic filter source: IP address, CIDR mask, or VPC endpoint ID.
        """
        return pulumi.get(self, "source")


