# This an autogenerated file
# Statistical representation of a a sector.
# Generated with HsBinned
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.hsbinned import HsBinnedBlueprint
from typing import Dict
from .weibull import Weibull
from dmt.namedentity import NamedEntity

class HsBinned(NamedEntity):
    """
    Statistical representation of a a sector.
    Keyword arguments
    -----------------
    description : str
         (default "")
    name : str
         unique name for this bin.(default None)
    upperHsLimit : float
         mean sector direction.(default 0.0)
    lowerHsLimit : float
         mean sector direction.(default 0.0)
    weibullDistribution : Weibull
         Weibull parameters.
    """

    def __init__(self , description="", upperHsLimit=0.0, lowerHsLimit=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.name = None
        self.upperHsLimit = upperHsLimit
        self.lowerHsLimit = lowerHsLimit
        self.weibullDistribution = None
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return HsBinnedBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def name(self) -> str:
        """unique name for this bin."""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def upperHsLimit(self) -> float:
        """mean sector direction."""
        return self.__upperHsLimit

    @upperHsLimit.setter
    def upperHsLimit(self, value: float):
        """Set upperHsLimit"""
        self.__upperHsLimit = float(value)

    @property
    def lowerHsLimit(self) -> float:
        """mean sector direction."""
        return self.__lowerHsLimit

    @lowerHsLimit.setter
    def lowerHsLimit(self, value: float):
        """Set lowerHsLimit"""
        self.__lowerHsLimit = float(value)

    @property
    def weibullDistribution(self) -> Weibull:
        """Weibull parameters."""
        return self.__weibullDistribution

    @weibullDistribution.setter
    def weibullDistribution(self, value: Weibull):
        """Set weibullDistribution"""
        self.__weibullDistribution = value
