# This an autogenerated file
# Description for stochastic process with sampling.
# Generated with Stat
from typing import Dict,Sequence,List
from dmt.blueprint import Blueprint
from .blueprints.stat import StatBlueprint
from typing import Dict
from .profile import Profile
from dmt.namedentity import NamedEntity

class Stat(NamedEntity):
    """
    Description for stochastic process with sampling.
    Keyword arguments
    -----------------
    description : str
         (default "")
    name : str
         name for this statistical data, wind/current, which appear in SIMA, e.g. wind_12sec, or current_omni.(default None)
    duration : float
         event duration in hours.(default 0.0)
    levels : List[Profile]
         statistical representation of wind/current at this level and sampling rate.
    """

    def __init__(self , description="", duration=0.0, **kwargs):
        super().__init__(**kwargs)
        self.description = description
        self.name = None
        self.duration = duration
        self.levels = list()
        for key, value in kwargs.items():
            if not isinstance(value, Dict):
                setattr(self, key, value)


    @property
    def blueprint(self) -> Blueprint:
        """Return blueprint that this entity represents"""
        return StatBlueprint()


    @property
    def description(self) -> str:
        """"""
        return self.__description

    @description.setter
    def description(self, value: str):
        """Set description"""
        self.__description = value

    @property
    def name(self) -> str:
        """name for this statistical data, wind/current, which appear in SIMA, e.g. wind_12sec, or current_omni."""
        return self.__name

    @name.setter
    def name(self, value: str):
        """Set name"""
        self.__name = value

    @property
    def duration(self) -> float:
        """event duration in hours."""
        return self.__duration

    @duration.setter
    def duration(self, value: float):
        """Set duration"""
        self.__duration = float(value)

    @property
    def levels(self) -> List[Profile]:
        """statistical representation of wind/current at this level and sampling rate."""
        return self.__levels

    @levels.setter
    def levels(self, value: List[Profile]):
        """Set levels"""
        if not isinstance(value, Sequence):
            raise ValueError("Expected sequense, but was " , type(value))
        self.__levels = value
